/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import pt.tumba.parser.swf.InStream;
import pt.tumba.parser.swf.OutStream;

public class SoundInfo {
    protected boolean noMultiplePlay;
    protected boolean stopPlaying;
    protected EnvelopePoint[] envelope;
    protected int inPoint;
    protected int outPoint;
    protected int loopCount;

    public SoundInfo(boolean noMultiplePlay, boolean stopSound, EnvelopePoint[] envelope, int inPoint, int outPoint, int loopCount) {
        this.noMultiplePlay = noMultiplePlay;
        this.stopPlaying = stopSound;
        this.envelope = envelope;
        this.inPoint = inPoint;
        this.outPoint = outPoint;
        this.loopCount = loopCount;
    }

    public boolean isNoMultiplePlay() {
        return this.noMultiplePlay;
    }

    public boolean isStopPlaying() {
        return this.stopPlaying;
    }

    public EnvelopePoint[] getEnvelope() {
        return this.envelope;
    }

    public int getInPoint() {
        return this.inPoint;
    }

    public int getOutPoint() {
        return this.outPoint;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public SoundInfo(InStream in) throws IOException {
        int flags = in.readUI8();
        this.noMultiplePlay = (flags & 0x10) != 0;
        this.stopPlaying = (flags & 0x20) != 0;
        boolean hasEnvelope = (flags & 8) != 0;
        boolean hasLoops = (flags & 4) != 0;
        boolean hasOutPoint = (flags & 2) != 0;
        boolean hasInPoint = (flags & 1) != 0;
        this.inPoint = hasInPoint ? (int)in.readUI32() : -1;
        this.outPoint = hasOutPoint ? (int)in.readUI32() : -1;
        this.loopCount = hasLoops ? in.readUI16() : 1;
        int envsize = 0;
        if (hasEnvelope) {
            envsize = in.readUI8();
        }
        this.envelope = new EnvelopePoint[envsize];
        int i = 0;
        while (i < envsize) {
            this.envelope[i] = new EnvelopePoint((int)in.readUI32(), in.readUI16(), in.readUI16());
            ++i;
        }
    }

    public void write(OutStream out) throws IOException {
        int flags = 0;
        if (this.noMultiplePlay) {
            ++flags;
        }
        if (this.stopPlaying) {
            flags += 2;
        }
        out.writeUBits(4, flags);
        boolean hasEnvelope = this.envelope != null && this.envelope.length > 0;
        boolean hasLoops = this.loopCount > 1;
        boolean hasOutPoint = this.outPoint >= 0;
        boolean hasInPoint = this.inPoint >= 0;
        flags = 0;
        if (hasEnvelope) {
            flags += 8;
        }
        if (hasLoops) {
            flags += 4;
        }
        if (hasOutPoint) {
            flags += 2;
        }
        if (hasInPoint) {
            ++flags;
        }
        out.writeUBits(4, flags);
        if (hasInPoint) {
            out.writeUI32(this.inPoint);
        }
        if (hasOutPoint) {
            out.writeUI32(this.outPoint);
        }
        if (hasLoops) {
            out.writeUI16(this.loopCount);
        }
        if (hasEnvelope) {
            out.writeUI8(this.envelope.length);
            int i = 0;
            while (i < this.envelope.length) {
                out.writeUI32(this.envelope[i].mark44);
                out.writeUI16(this.envelope[i].level0);
                out.writeUI16(this.envelope[i].level1);
                ++i;
            }
        }
    }

    public String toString() {
        return "SoundInfo: no-multiplay=" + this.noMultiplePlay + " stop=" + this.stopPlaying + " envelope=" + (this.envelope == null ? "none" : "" + this.envelope.length + " points") + " in-point=" + this.inPoint + " out-point=" + this.outPoint + " loop-count=" + this.loopCount;
    }

    public static class EnvelopePoint {
        public int mark44;
        public int level0;
        public int level1;

        public EnvelopePoint(int mark44, int level0, int level1) {
            this.mark44 = mark44;
            this.level0 = level0;
            this.level1 = level1;
        }
    }
}

