/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.WeakIdentityMap;

public abstract class AttributeFactory {
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
    private static final MethodType NO_ARG_CTOR = MethodType.methodType(Void.TYPE);
    private static final MethodType NO_ARG_RETURNING_ATTRIBUTEIMPL = MethodType.methodType(AttributeImpl.class);
    public static final AttributeFactory DEFAULT_ATTRIBUTE_FACTORY = new DefaultAttributeFactory(true);

    public abstract AttributeImpl createAttributeInstance(Class<? extends Attribute> var1);

    static final MethodHandle findAttributeImplCtor(Class<? extends AttributeImpl> clazz) {
        try {
            return lookup.findConstructor(clazz, NO_ARG_CTOR).asType(NO_ARG_RETURNING_ATTRIBUTEIMPL);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot lookup accessible no-arg constructor for: " + clazz.getName(), e);
        }
    }

    public static <A extends AttributeImpl> AttributeFactory getStaticImplementation(AttributeFactory delegate, Class<A> clazz) {
        final MethodHandle constr = AttributeFactory.findAttributeImplCtor(clazz);
        return new StaticImplementationAttributeFactory<A>(delegate, clazz){

            @Override
            protected A createInstance() {
                try {
                    return constr.invokeExact();
                }
                catch (Throwable t) {
                    1.rethrow(t);
                    throw new AssertionError();
                }
            }
        };
    }

    static void rethrow(Throwable t) {
        AttributeFactory.rethrow0(t);
    }

    private static <T extends Throwable> void rethrow0(Throwable t) throws T {
        throw t;
    }

    public static abstract class StaticImplementationAttributeFactory<A extends AttributeImpl>
    extends AttributeFactory {
        private final AttributeFactory delegate;
        private final Class<A> clazz;

        public StaticImplementationAttributeFactory(AttributeFactory delegate, Class<A> clazz) {
            this.delegate = delegate;
            this.clazz = clazz;
        }

        @Override
        public final AttributeImpl createAttributeInstance(Class<? extends Attribute> attClass) {
            return attClass.isAssignableFrom(this.clazz) ? this.createInstance() : this.delegate.createAttributeInstance(attClass);
        }

        protected abstract A createInstance();

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            StaticImplementationAttributeFactory af = (StaticImplementationAttributeFactory)other;
            return this.delegate.equals(af.delegate) && this.clazz == af.clazz;
        }

        public int hashCode() {
            return 31 * this.delegate.hashCode() + this.clazz.hashCode();
        }
    }

    static final class DefaultAttributeFactory
    extends AttributeFactory {
        private final WeakIdentityMap<Class<? extends Attribute>, Object> attClassImplMap = WeakIdentityMap.newConcurrentHashMap(false);
        private final ClassLoader myClassLoader = this.getClass().getClassLoader();
        private final boolean useMethodHandles;

        DefaultAttributeFactory(boolean useMethodHandles) {
            this.useMethodHandles = useMethodHandles;
        }

        @Override
        public AttributeImpl createAttributeInstance(Class<? extends Attribute> attClass) {
            Object cached = this.attClassImplMap.get(attClass);
            if (cached instanceof MethodHandle) {
                return this.invokeMethodHandle((MethodHandle)cached);
            }
            if (cached instanceof Reference) {
                Class clazz = (Class)((Reference)cached).get();
                if (clazz != null) {
                    return this.invokeReflective(clazz);
                }
                cached = null;
            }
            assert (cached == null);
            Class<? extends AttributeImpl> implClazz = this.findImplClass(attClass);
            if (this.useMethodHandles && implClazz.getClassLoader() == this.myClassLoader) {
                MethodHandle constr = DefaultAttributeFactory.findAttributeImplCtor(implClazz);
                this.attClassImplMap.put(attClass, constr);
                return this.invokeMethodHandle(constr);
            }
            this.attClassImplMap.put(attClass, new WeakReference<Class<? extends AttributeImpl>>(implClazz));
            return this.invokeReflective(implClazz);
        }

        private Class<? extends AttributeImpl> findImplClass(Class<? extends Attribute> attClass) {
            try {
                return Class.forName(attClass.getName() + "Impl", true, attClass.getClassLoader()).asSubclass(AttributeImpl.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("Cannot find implementing class for: " + attClass.getName());
            }
        }

        private AttributeImpl invokeMethodHandle(MethodHandle constr) {
            try {
                return constr.invokeExact();
            }
            catch (Throwable t) {
                DefaultAttributeFactory.rethrow(t);
                throw new AssertionError();
            }
        }

        private AttributeImpl invokeReflective(Class<? extends AttributeImpl> implClass) {
            try {
                return implClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Cannot instantiate implementing class: " + implClass.getName(), e);
            }
        }
    }
}

