/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.Color;
import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;

public class PDICCBased
extends PDColorSpace {
    private static final Log LOG = LogFactory.getLog(PDICCBased.class);
    public static final String NAME = "ICCBased";
    private PDStream stream;
    private int numberOfComponents = -1;

    public PDICCBased(PDDocument doc) {
        this.array = new COSArray();
        this.array.add(COSName.ICCBASED);
        this.array.add(new PDStream(doc));
    }

    public PDICCBased(COSArray iccArray) {
        this.array = iccArray;
        this.stream = new PDStream((COSStream)iccArray.getObject(1));
    }

    public String getName() {
        return NAME;
    }

    public COSBase getCOSObject() {
        return this.array;
    }

    public PDStream getPDStream() {
        return this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ColorSpace createColorSpace() throws IOException {
        void var2_5;
        InputStream profile = null;
        Object var2_2 = null;
        try {
            try {
                profile = this.stream.createInputStream();
                ICC_Profile iccProfile = ICC_Profile.getInstance(profile);
                ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(iccProfile);
                new Color(iCC_ColorSpace, new float[this.getNumberOfComponents()], 1.0f);
            }
            catch (RuntimeException e) {
                if (!(e instanceof ProfileDataException) && !(e instanceof CMMException)) {
                    if (!(e instanceof IllegalArgumentException)) throw e;
                }
                List alternateCSList = this.getAlternateColorSpaces();
                PDColorSpace alternate = (PDColorSpace)alternateCSList.get(0);
                LOG.error((Object)("Can't read ICC-profile, using alternate colorspace instead: " + alternate));
                ColorSpace colorSpace = alternate.getJavaColorSpace();
                Object var7_9 = null;
                if (profile == null) return var2_5;
                profile.close();
                return var2_5;
            }
            Object var7_8 = null;
            if (profile == null) return var2_5;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (profile == null) throw throwable;
            profile.close();
            throw throwable;
        }
        profile.close();
        return var2_5;
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        int[] nbBits;
        int numOfComponents = this.getNumberOfComponents();
        switch (numOfComponents) {
            case 1: {
                nbBits = new int[]{bpc};
                break;
            }
            case 3: {
                nbBits = new int[]{bpc, bpc, bpc};
                break;
            }
            case 4: {
                nbBits = new int[]{bpc, bpc, bpc, bpc};
                break;
            }
            default: {
                throw new IOException("Unknown colorspace number of components:" + numOfComponents);
            }
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(this.getJavaColorSpace(), nbBits, false, false, 1, 0);
        return componentColorModel;
    }

    public int getNumberOfComponents() {
        if (this.numberOfComponents < 0) {
            this.numberOfComponents = this.stream.getStream().getInt(COSName.N);
        }
        return this.numberOfComponents;
    }

    public void setNumberOfComponents(int n) {
        this.numberOfComponents = n;
        this.stream.getStream().setInt(COSName.N, n);
    }

    public List getAlternateColorSpaces() throws IOException {
        COSBase alternate = this.stream.getStream().getDictionaryObject(COSName.ALTERNATE);
        COSArray alternateArray = null;
        if (alternate == null) {
            alternateArray = new COSArray();
            int numComponents = this.getNumberOfComponents();
            COSName csName = null;
            if (numComponents == 1) {
                csName = COSName.DEVICEGRAY;
            } else if (numComponents == 3) {
                csName = COSName.DEVICERGB;
            } else if (numComponents == 4) {
                csName = COSName.DEVICECMYK;
            } else {
                throw new IOException("Unknown colorspace number of components:" + numComponents);
            }
            alternateArray.add(csName);
        } else if (alternate instanceof COSArray) {
            alternateArray = (COSArray)alternate;
        } else if (alternate instanceof COSName) {
            alternateArray = new COSArray();
            alternateArray.add(alternate);
        } else {
            throw new IOException("Error: expected COSArray or COSName and not " + alternate.getClass().getName());
        }
        ArrayList<PDColorSpace> retval = new ArrayList<PDColorSpace>();
        retval.add(PDColorSpaceFactory.createColorSpace(alternateArray));
        return new COSArrayList(retval, alternateArray);
    }

    public void setAlternateColorSpaces(List list) {
        COSArray altArray = null;
        if (list != null) {
            altArray = COSArrayList.converterToCOSArray(list);
        }
        this.stream.getStream().setItem(COSName.ALTERNATE, (COSBase)altArray);
    }

    public PDRange getRangeForComponent(int n) {
        COSArray rangeArray = (COSArray)this.stream.getStream().getDictionaryObject(COSName.RANGE);
        if (rangeArray == null || rangeArray.size() < this.getNumberOfComponents() * 2) {
            return new PDRange();
        }
        return new PDRange(rangeArray, n);
    }

    public void setRangeForComponent(PDRange range, int n) {
        COSArray rangeArray = (COSArray)this.stream.getStream().getDictionaryObject(COSName.RANGE);
        if (rangeArray == null) {
            rangeArray = new COSArray();
            this.stream.getStream().setItem(COSName.RANGE, (COSBase)rangeArray);
        }
        while (rangeArray.size() < (n + 1) * 2) {
            rangeArray.add(new COSFloat(0.0f));
            rangeArray.add(new COSFloat(1.0f));
        }
        rangeArray.set(n * 2, new COSFloat(range.getMin()));
        rangeArray.set(n * 2 + 1, new COSFloat(range.getMax()));
    }

    public COSStream getMetadata() {
        return (COSStream)this.stream.getStream().getDictionaryObject(COSName.METADATA);
    }

    public void setMetadata(COSStream metadata) {
        this.stream.getStream().setItem(COSName.METADATA, (COSBase)metadata);
    }

    public String toString() {
        return this.getName() + "{numberOfComponents: " + this.getNumberOfComponents() + "}";
    }
}

