/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import pt.tumba.parser.swf.InStream;
import pt.tumba.parser.swf.SWFActionCodes;
import pt.tumba.parser.swf.SWFActions;

public class ActionParser
implements SWFActionCodes {
    protected SWFActions actions;
    protected int blockDepth = 0;

    public ActionParser(SWFActions actions) {
        this.actions = actions;
    }

    public synchronized void parse(byte[] bytes) throws IOException {
        List records = this.createRecords(bytes);
        this.processRecords(records);
    }

    public synchronized void parse(InStream in) throws IOException {
        List records = this.createRecords(in);
        this.processRecords(records);
    }

    protected void processRecords(List records) throws IOException {
        Iterator iterator = records.iterator();
        while (iterator.hasNext()) {
            ActionRecord rec = (ActionRecord)iterator.next();
            if (rec.blockDepth < this.blockDepth) {
                --this.blockDepth;
                this.actions.endBlock();
            }
            if (rec.label != null) {
                this.actions.jumpLabel(rec.label);
            }
            int code = rec.code;
            byte[] data = rec.data;
            InStream in = data != null && data.length > 0 ? new InStream(data) : null;
            switch (code) {
                case 0: {
                    this.actions.end();
                    break;
                }
                case 129: {
                    this.actions.gotoFrame(in.readUI16());
                    break;
                }
                case 131: {
                    this.actions.getURL(in.readString(), in.readString());
                    break;
                }
                case 4: {
                    this.actions.nextFrame();
                    break;
                }
                case 5: {
                    this.actions.prevFrame();
                    break;
                }
                case 6: {
                    this.actions.play();
                    break;
                }
                case 7: {
                    this.actions.stop();
                    break;
                }
                case 8: {
                    this.actions.toggleQuality();
                    break;
                }
                case 9: {
                    this.actions.stopSounds();
                    break;
                }
                case 138: {
                    this.actions.waitForFrame(in.readUI16(), rec.jumpLabel);
                    break;
                }
                case 139: {
                    this.actions.setTarget(in.readString());
                    break;
                }
                case 140: {
                    this.actions.gotoFrame(in.readString());
                    break;
                }
                case 157: {
                    this.actions.ifJump(rec.jumpLabel);
                    break;
                }
                case 153: {
                    this.actions.jump(rec.jumpLabel);
                    break;
                }
                case 141: {
                    this.actions.waitForFrame(rec.jumpLabel);
                    break;
                }
                case 23: {
                    this.actions.pop();
                    break;
                }
                case 150: {
                    this.parsePush(data.length, in);
                    break;
                }
                case 10: {
                    this.actions.add();
                    break;
                }
                case 11: {
                    this.actions.substract();
                    break;
                }
                case 12: {
                    this.actions.multiply();
                    break;
                }
                case 13: {
                    this.actions.divide();
                    break;
                }
                case 14: {
                    this.actions.equals();
                    break;
                }
                case 15: {
                    this.actions.lessThan();
                    break;
                }
                case 16: {
                    this.actions.and();
                    break;
                }
                case 17: {
                    this.actions.or();
                    break;
                }
                case 18: {
                    this.actions.not();
                    break;
                }
                case 19: {
                    this.actions.stringEquals();
                    break;
                }
                case 20: {
                    this.actions.stringLength();
                    break;
                }
                case 33: {
                    this.actions.concat();
                    break;
                }
                case 21: {
                    this.actions.substring();
                    break;
                }
                case 41: {
                    this.actions.stringLessThan();
                    break;
                }
                case 53: {
                    this.actions.substringMB();
                    break;
                }
                case 49: {
                    this.actions.stringLengthMB();
                    break;
                }
                case 24: {
                    this.actions.toInteger();
                    break;
                }
                case 50: {
                    this.actions.charToAscii();
                    break;
                }
                case 51: {
                    this.actions.asciiToChar();
                    break;
                }
                case 54: {
                    this.actions.charMBToAscii();
                    break;
                }
                case 55: {
                    this.actions.asciiToCharMB();
                    break;
                }
                case 158: {
                    this.actions.call();
                    break;
                }
                case 28: {
                    this.actions.getVariable();
                    break;
                }
                case 29: {
                    this.actions.setVariable();
                    break;
                }
                case 154: {
                    this.parseGetURL2(in.readUI8());
                    break;
                }
                case 159: {
                    this.actions.gotoFrame(in.readUI8() != 0);
                    break;
                }
                case 32: {
                    this.actions.setTarget();
                    break;
                }
                case 34: {
                    this.actions.getProperty();
                    break;
                }
                case 35: {
                    this.actions.setProperty();
                    break;
                }
                case 36: {
                    this.actions.cloneSprite();
                    break;
                }
                case 37: {
                    this.actions.removeSprite();
                    break;
                }
                case 39: {
                    this.actions.startDrag();
                    break;
                }
                case 40: {
                    this.actions.endDrag();
                    break;
                }
                case 38: {
                    this.actions.trace();
                    break;
                }
                case 52: {
                    this.actions.getTime();
                    break;
                }
                case 48: {
                    this.actions.randomNumber();
                    break;
                }
                case 66: {
                    this.actions.initArray();
                    break;
                }
                case 136: {
                    this.parseLookupTable(in);
                    break;
                }
                case 61: {
                    this.actions.callFunction();
                    break;
                }
                case 82: {
                    this.actions.callMethod();
                    break;
                }
                case 155: {
                    this.parseDefineFunction(in);
                    break;
                }
                case 60: {
                    this.actions.defineLocalValue();
                    break;
                }
                case 65: {
                    this.actions.defineLocal();
                    break;
                }
                case 58: {
                    this.actions.deleteProperty();
                    break;
                }
                case 59: {
                    this.actions.deleteThreadVars();
                    break;
                }
                case 70: {
                    this.actions.enumerate();
                    break;
                }
                case 73: {
                    this.actions.typedEquals();
                    break;
                }
                case 78: {
                    this.actions.getMember();
                    break;
                }
                case 67: {
                    this.actions.initObject();
                    break;
                }
                case 83: {
                    this.actions.newMethod();
                    break;
                }
                case 64: {
                    this.actions.newObject();
                    break;
                }
                case 79: {
                    this.actions.setMember();
                    break;
                }
                case 69: {
                    this.actions.getTargetPath();
                    break;
                }
                case 148: {
                    this.parseWith(in);
                    break;
                }
                case 76: {
                    this.actions.duplicate();
                    break;
                }
                case 62: {
                    this.actions.returnValue();
                    break;
                }
                case 77: {
                    this.actions.swap();
                    break;
                }
                case 135: {
                    this.actions.storeInRegister(in.readUI8());
                    break;
                }
                case 63: {
                    this.actions.modulo();
                    break;
                }
                case 68: {
                    this.actions.typeOf();
                    break;
                }
                case 71: {
                    this.actions.typedAdd();
                    break;
                }
                case 72: {
                    this.actions.typedLessThan();
                    break;
                }
                case 74: {
                    this.actions.convertToNumber();
                    break;
                }
                case 75: {
                    this.actions.convertToString();
                    break;
                }
                case 80: {
                    this.actions.increment();
                    break;
                }
                case 81: {
                    this.actions.decrement();
                    break;
                }
                case 96: {
                    this.actions.bitAnd();
                    break;
                }
                case 97: {
                    this.actions.bitOr();
                    break;
                }
                case 98: {
                    this.actions.bitXor();
                    break;
                }
                case 99: {
                    this.actions.shiftLeft();
                    break;
                }
                case 100: {
                    this.actions.shiftRight();
                    break;
                }
                case 101: {
                    this.actions.shiftRightUnsigned();
                    break;
                }
                default: {
                    this.actions.unknown(code, data);
                }
            }
        }
    }

    protected void parseDefineFunction(InStream in) throws IOException {
        String name = in.readString();
        int paramCount = in.readUI16();
        String[] params = new String[paramCount];
        int i = 0;
        while (i < params.length) {
            params[i] = in.readString();
            ++i;
        }
        this.actions.startFunction(name, params);
        ++this.blockDepth;
    }

    protected void parseWith(InStream in) throws IOException {
        this.actions.startWith();
        ++this.blockDepth;
    }

    protected void parseLookupTable(InStream in) throws IOException {
        String[] strings = new String[in.readUI16()];
        int i = 0;
        while (i < strings.length) {
            strings[i] = in.readString();
            ++i;
        }
        this.actions.lookupTable(strings);
    }

    protected void parseGetURL2(int flags) throws IOException {
        int sendVars = flags & 3;
        int mode = 0;
        switch (flags & 0xF0) {
            case 64: {
                mode = 1;
                break;
            }
            case 128: {
                mode = 3;
                break;
            }
            case 192: {
                mode = 4;
                break;
            }
            default: {
                mode = 0;
            }
        }
        this.actions.getURL(sendVars, mode);
    }

    protected void parsePush(int length, InStream in) throws IOException {
        while (in.getBytesRead() < (long)length) {
            int pushType = in.readUI8();
            switch (pushType) {
                case 0: {
                    this.actions.push(in.readString());
                    break;
                }
                case 1: {
                    this.actions.push(in.readFloat());
                    break;
                }
                case 2: {
                    this.actions.pushNull();
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.actions.pushRegister(in.readUI8());
                    break;
                }
                case 5: {
                    this.actions.push(in.readUI8() != 0);
                    break;
                }
                case 6: {
                    this.actions.push(in.readDouble());
                    break;
                }
                case 7: {
                    this.actions.push(in.readSI32());
                    break;
                }
                case 8: {
                    this.actions.lookup(in.readUI8());
                }
            }
        }
    }

    protected List createRecords(byte[] bytes) throws IOException {
        return this.createRecords(new InStream(bytes));
    }

    protected List createRecords(InStream in) throws IOException {
        Vector<ActionRecord> records = new Vector<ActionRecord>();
        Vector<ActionRecord> jumpers = new Vector<ActionRecord>();
        Vector<Integer> skippers = new Vector<Integer>();
        Hashtable<Integer, ActionRecord> offsetTable = new Hashtable<Integer, ActionRecord>();
        Stack<int[]> blockSizes = new Stack<int[]>();
        int labelIndex = 0;
        while (true) {
            int i;
            int offset = (int)in.getBytesRead();
            int code = in.readUI8();
            int dataLength = code >= 128 ? in.readUI16() : 0;
            byte[] data = dataLength > 0 ? in.read(dataLength) : null;
            ActionRecord rec = new ActionRecord(offset, code, data);
            records.addElement(rec);
            offsetTable.put(new Integer(offset), rec);
            if (!blockSizes.isEmpty()) {
                int depth;
                rec.blockDepth = depth = blockSizes.size();
                int blockDecrement = dataLength > 0 ? dataLength + 3 : 1;
                i = depth - 1;
                while (i >= 0) {
                    int[] blockSize = (int[])blockSizes.elementAt(i);
                    int size = blockSize[0];
                    if ((size -= blockDecrement) <= 0) {
                        blockSizes.pop();
                    } else {
                        blockSize[0] = size;
                    }
                    --i;
                }
            }
            if (code == 0) break;
            if (code == 155) {
                InStream in2 = new InStream(rec.data);
                in2.readString();
                int params = in2.readUI16();
                i = 0;
                while (i < params) {
                    in2.readString();
                    ++i;
                }
                int blockSize = in2.readUI16();
                blockSizes.push(new int[]{blockSize});
                continue;
            }
            if (code == 148) {
                InStream in2 = new InStream(rec.data);
                int blockSize = in2.readUI16();
                blockSizes.push(new int[]{blockSize});
                continue;
            }
            if (code == 138 || code == 141) {
                skippers.addElement(new Integer(records.size() - 1));
                continue;
            }
            if (code != 157 && code != 153) continue;
            jumpers.addElement(rec);
        }
        Enumeration enumeration = jumpers.elements();
        while (enumeration.hasMoreElements()) {
            ActionRecord rec = (ActionRecord)enumeration.nextElement();
            int offset = rec.offset + 5;
            InStream in2 = new InStream(rec.data);
            short jumpOffset = in2.readSI16();
            int absoluteOffset = offset + jumpOffset;
            ActionRecord target = (ActionRecord)offsetTable.get(new Integer(absoluteOffset));
            if (target == null) continue;
            if (target.label == null) {
                target.label = rec.jumpLabel = "label" + labelIndex++;
                continue;
            }
            rec.jumpLabel = target.label;
        }
        enumeration = skippers.elements();
        while (enumeration.hasMoreElements()) {
            int skip;
            int skipIndex;
            int idx = (Integer)enumeration.nextElement();
            ActionRecord rec = (ActionRecord)records.elementAt(idx);
            InStream in2 = new InStream(rec.data);
            if (rec.code == 138) {
                in2.readUI16();
            }
            if ((skipIndex = idx + (skip = in2.readUI8()) + 1) >= records.size()) continue;
            ActionRecord target = (ActionRecord)records.elementAt(skipIndex);
            if (target.label == null) {
                target.label = rec.jumpLabel = "label" + labelIndex++;
                continue;
            }
            rec.jumpLabel = target.label;
        }
        return records;
    }

    protected static class ActionRecord {
        public int offset;
        public int code;
        public String label;
        public String jumpLabel;
        public byte[] data;
        public int blockDepth = 0;

        protected ActionRecord(int offset, int code, byte[] data) {
            this.offset = offset;
            this.code = code;
            this.data = data;
        }
    }
}

