/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;

public class Base64 {
    private static final Base64 _theInstance = new Base64();
    public static final char[] charset = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    public static final char paddingChar = '=';
    protected static Hashtable charLookup = new Hashtable();

    static {
        int i = 0;
        while (i < charset.length) {
            charLookup.put(new Character(charset[i]), new Integer(i));
            ++i;
        }
    }

    private Base64() {
    }

    public static Base64 getInstance() {
        return _theInstance;
    }

    public static void decode(Reader in, OutputStream out) throws Exception {
        char[] chars = new char[4];
        int[] sixbit = new int[4];
        while (true) {
            int numread = 0;
            while (numread < 4) {
                int read = in.read();
                if (read < 0) break;
                char aChar = (char)read;
                if (Character.isWhitespace(aChar)) continue;
                chars[numread++] = aChar;
            }
            if (numread == 0) {
                return;
            }
            if (numread != 4) {
                throw new Exception("Incomplete character quartet at end of Base64 input");
            }
            int i = 0;
            while (i < 4) {
                Integer value = (Integer)charLookup.get(new Character(chars[i]));
                if (value == null) {
                    if (chars[i] != '=' || i < 2) {
                        throw new Exception("Invalid char (" + chars[i] + ") in Base64 data");
                    }
                    sixbit[i] = -1;
                } else {
                    sixbit[i] = value;
                }
                ++i;
            }
            out.write((sixbit[0] << 2) + (sixbit[1] >> 4));
            int val = (sixbit[1] & 0xF) << 4;
            if (sixbit[2] < 0) continue;
            out.write(val += sixbit[2] >> 2);
            val = (sixbit[2] & 3) << 6;
            if (sixbit[3] < 0) continue;
            out.write(val += sixbit[3]);
        }
    }

    public static byte[] decode(String base64) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StringReader in = new StringReader(base64);
        Base64.decode(in, out);
        in.close();
        out.flush();
        out.close();
        return out.toByteArray();
    }

    public static void encode(InputStream in, Writer out) throws IOException {
        int column = 0;
        while (true) {
            int byte1 = in.read();
            int byte2 = in.read();
            int byte3 = in.read();
            if (byte1 < 0) {
                return;
            }
            if (column >= 72) {
                column = 0;
                out.write(10);
            }
            out.write(charset[byte1 >> 2]);
            int index = (byte1 & 3) << 4;
            if (byte2 < 0) {
                out.write(charset[index]);
                out.write(61);
                out.write(61);
                return;
            }
            out.write(charset[index += byte2 >> 4]);
            index = (byte2 & 0xF) << 2;
            if (byte3 < 0) {
                out.write(charset[index]);
                out.write(61);
                return;
            }
            out.write(charset[index += byte3 >> 6]);
            out.write(charset[byte3 & 0x3F]);
            column += 4;
        }
    }

    public static String encode(byte[] data) {
        try {
            return Base64.encode(data, 0, data.length);
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            return aiobe.toString();
        }
    }

    public static String encode(byte[] data, int start, int length) throws ArrayIndexOutOfBoundsException {
        StringWriter out = new StringWriter();
        ByteArrayInputStream in = new ByteArrayInputStream(data, start, length);
        try {
            Base64.encode(in, out);
            in.close();
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            return ioe.toString();
        }
        return out.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            OutputStreamWriter out = new OutputStreamWriter(System.out);
            Base64.encode(System.in, out);
            out.flush();
            return;
        }
        Base64.decode(new InputStreamReader(System.in), System.out);
        System.out.flush();
    }
}

