/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import pt.tumba.parser.swf.AlphaColor;
import pt.tumba.parser.swf.Color;
import pt.tumba.parser.swf.Image;
import pt.tumba.parser.swf.Shape;
import pt.tumba.parser.swf.Transform;

public class ImageUtil {
    private static final ImageUtil _theInstance = new ImageUtil();

    private ImageUtil() {
    }

    public static ImageUtil getInstance() {
        return _theInstance;
    }

    public static byte[] normalizeJPEG(InputStream jpegImage, int[] size2) throws IOException {
        int[] size = size2;
        JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)jpegImage);
        BufferedImage buff = decoder.decodeAsBufferedImage();
        if (size != null && size.length >= 2) {
            size[0] = decoder.getJPEGDecodeParam().getWidth();
            size[1] = decoder.getJPEGDecodeParam().getHeight();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(255);
        out.write(217);
        out.write(255);
        out.write(216);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        encoder.encode(buff);
        out.flush();
        return out.toByteArray();
    }

    public static Shape shapeForImage(InputStream jpegImage, int[] size2) throws IOException {
        int[] size = size2;
        if (size == null || size.length < 2) {
            size = new int[2];
        }
        byte[] data = ImageUtil.normalizeJPEG(jpegImage, size);
        int width = size[0];
        int height = size[1];
        Image.JPEG img = new Image.JPEG(data);
        return ImageUtil.shapeForImage(img, width, height);
    }

    public static Shape shapeForImage(Image image, double width, double height) throws IOException {
        Shape s = new Shape();
        Transform matrix = new Transform(20.0, 20.0, 0.0, 0.0);
        s.defineFillStyle(image, matrix, true);
        s.setRightFillStyle(1);
        s.setLineStyle(0);
        s.line(width, 0.0);
        s.line(width, height);
        s.line(0.0, height);
        s.line(0.0, 0.0);
        return s;
    }

    public static Image.Lossless createLosslessImage(java.awt.Image image, int format, boolean hasAlpha) {
        Color[] colors;
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, height, true);
        grabber.startGrabbing();
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int[] pixelData = (int[])grabber.getPixels();
        int size = 0;
        switch (format) {
            case 3: {
                size = 1;
                break;
            }
            case 4: {
                size = 2;
                break;
            }
            default: {
                size = 4;
            }
        }
        int rowBytes = width * size;
        int modulo = rowBytes % 4;
        if (modulo > 0) {
            rowBytes += 3 - modulo;
        }
        byte[] imageData = new byte[height * rowBytes];
        HashMap<Integer, Integer> table = format == 5 ? null : new HashMap<Integer, Integer>();
        int y = 0;
        while (y < height) {
            int rowStart = y * width;
            int rowByte = y * rowBytes;
            int x = 0;
            while (x < width) {
                int pix = pixelData[rowStart + x];
                int bite = rowByte + x * size;
                if (format == 5) {
                    imageData[bite] = hasAlpha ? (int)(pix >> 24) : -1;
                    imageData[bite + 1] = (byte)(pix >> 16 & 0xFF);
                    imageData[bite + 2] = (byte)(pix >> 8 & 0xFF);
                    imageData[bite + 3] = (byte)(pix & 0xFF);
                } else {
                    Integer pixI = new Integer(pix);
                    Integer index = (Integer)table.get(pixI);
                    if (index == null) {
                        index = new Integer(table.size());
                        table.put(pixI, index);
                    }
                    int idx = index;
                    if (format == 3) {
                        imageData[bite] = (byte)idx;
                    } else {
                        imageData[bite] = (byte)(idx >> 8);
                        imageData[bite + 1] = (byte)(idx & 0xFF);
                    }
                }
                ++x;
            }
            ++y;
        }
        Color[] colorArray = colors = format == 5 ? null : new Color[table.size()];
        if (colors != null) {
            Iterator it = table.keySet().iterator();
            while (it.hasNext()) {
                Integer key = (Integer)it.next();
                int argb = key;
                int index = (Integer)table.get(key);
                int alpha = argb >> 24;
                int red = argb >> 16 & 0xFF;
                int green = argb >> 8 & 0xFF;
                int blue = argb & 0xFF;
                Color color = hasAlpha ? new AlphaColor(red, green, blue, alpha) : new Color(red, green, blue);
                colors[index] = color;
            }
        }
        return new Image.Lossless(colors, imageData, width, height, hasAlpha, format);
    }
}

