/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pt.tumba.parser.swf.Color;
import pt.tumba.parser.swf.MP3Frame;
import pt.tumba.parser.swf.SWFTagTypes;
import pt.tumba.parser.swf.SWFWriter;
import pt.tumba.parser.swf.TagWriter;

public class MP3Helper {
    private static final MP3Helper _theInstance = new MP3Helper();

    private MP3Helper() {
    }

    public static MP3Helper getInstance() {
        return _theInstance;
    }

    public static List streamingBlocks(InputStream mp3, SWFTagTypes tags, int framesPerSecond) throws IOException {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        MP3Frame frame = MP3Frame.readFrame(mp3);
        int samplesPerFrame = frame.getSamplesPerFrame();
        int sampleRate = frame.getSampleRate();
        int mp3FramesPerSecond = sampleRate / samplesPerFrame;
        int mp3FramesPerSwfFrame = mp3FramesPerSecond / framesPerSecond;
        boolean isStereo = frame.isStereo();
        int blockSize = (frame.getDataLength() + 4) * mp3FramesPerSwfFrame;
        int rate = 0;
        if (sampleRate >= 44000) {
            rate = 3;
        } else if (sampleRate >= 22000) {
            rate = 2;
        } else if (sampleRate >= 11000) {
            rate = 1;
        }
        tags.tagSoundStreamHead(rate, true, isStereo, 2, rate, true, isStereo, mp3FramesPerSwfFrame * samplesPerFrame);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(blockSize + 1000);
        while (frame != null) {
            bout.write(0);
            bout.write(0);
            bout.write(0);
            bout.write(0);
            int frameCount = mp3FramesPerSwfFrame;
            int sampleCount = 0;
            while (frameCount > 0 && frame != null) {
                sampleCount += frame.getSamplesPerFrame();
                frame.write(bout);
                --frameCount;
                frame = MP3Frame.readFrame(mp3);
            }
            bout.flush();
            byte[] bytes = bout.toByteArray();
            bytes[0] = (byte)(sampleCount & 0xFF);
            bytes[1] = (byte)(sampleCount >> 8);
            list.add(bytes);
            bout.reset();
        }
        mp3.close();
        return list;
    }

    public static void main(String[] args) throws IOException {
        FileInputStream mp3 = new FileInputStream(args[0]);
        SWFWriter swfwriter = new SWFWriter(args[1]);
        TagWriter tags = new TagWriter(swfwriter);
        tags.header(5, -1L, 200, 200, 12, -1);
        tags.tagSetBackgroundColor(new Color(255, 255, 255));
        List blocks = MP3Helper.streamingBlocks(mp3, tags, 12);
        Iterator it = blocks.iterator();
        while (it.hasNext()) {
            byte[] data = (byte[])it.next();
            tags.tagSoundStreamBlock(data);
            tags.tagShowFrame();
        }
        tags.tagEnd();
    }
}

