/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import pt.tumba.parser.swf.Actions;
import pt.tumba.parser.swf.AlphaColor;
import pt.tumba.parser.swf.AlphaTransform;
import pt.tumba.parser.swf.Button;
import pt.tumba.parser.swf.ButtonRecord;
import pt.tumba.parser.swf.ButtonRecord2;
import pt.tumba.parser.swf.Color;
import pt.tumba.parser.swf.ColorTransform;
import pt.tumba.parser.swf.EditField;
import pt.tumba.parser.swf.Font;
import pt.tumba.parser.swf.FontDefinition;
import pt.tumba.parser.swf.Frame;
import pt.tumba.parser.swf.Image;
import pt.tumba.parser.swf.Instance;
import pt.tumba.parser.swf.Matrix;
import pt.tumba.parser.swf.MorphShape;
import pt.tumba.parser.swf.Movie;
import pt.tumba.parser.swf.MovieClip;
import pt.tumba.parser.swf.QTMovie;
import pt.tumba.parser.swf.Rect;
import pt.tumba.parser.swf.SWFActions;
import pt.tumba.parser.swf.SWFActionsImpl;
import pt.tumba.parser.swf.SWFShape;
import pt.tumba.parser.swf.SWFTagTypes;
import pt.tumba.parser.swf.SWFText;
import pt.tumba.parser.swf.SWFVectors;
import pt.tumba.parser.swf.Shape;
import pt.tumba.parser.swf.SoundInfo;
import pt.tumba.parser.swf.Symbol;
import pt.tumba.parser.swf.Text;
import pt.tumba.parser.swf.TimeLine;
import pt.tumba.parser.swf.Transform;

public class MovieBuilder
implements SWFTagTypes {
    protected Movie movie;
    protected MovieClip clip;
    protected boolean newMovie = false;
    protected Frame frame;
    protected Map symbols = new HashMap();
    protected TimeLine timeline;
    protected Map instances = new HashMap();

    public MovieBuilder() {
        this.movie = new Movie();
        this.newMovie = true;
        this.timeline = this.movie;
    }

    public MovieBuilder(Movie movie) {
        this.movie = movie;
        this.newMovie = false;
        this.timeline = movie;
    }

    protected MovieBuilder(MovieBuilder parent, MovieClip clip) {
        this.movie = parent.movie;
        this.symbols = parent.symbols;
        this.clip = clip;
        this.newMovie = false;
        this.timeline = clip;
    }

    public Movie getMovie() {
        return this.movie;
    }

    public Map getDefinedSymbols() {
        return this.symbols;
    }

    protected Symbol getSymbol(int id) {
        return (Symbol)this.symbols.get(new Integer(id));
    }

    protected void saveSymbol(int id, Symbol s) {
        this.symbols.put(new Integer(id), s);
    }

    protected Instance getInstance(int depth) {
        return (Instance)this.instances.get(new Integer(depth));
    }

    protected void saveInstance(int depth, Instance inst) {
        this.instances.put(new Integer(depth), inst);
    }

    public void tag(int tagType, boolean longTag, byte[] contents) throws IOException {
    }

    public void header(int version, long length, int twipsWidth, int twipsHeight, int frameRate, int frameCount) throws IOException {
        if (this.newMovie) {
            this.movie.setVersion(version);
            this.movie.setWidth(twipsWidth / 20);
            this.movie.setHeight(twipsHeight / 20);
            this.movie.setFrameRate(frameRate);
        }
    }

    public void tagEnd() throws IOException {
    }

    public void tagShowFrame() throws IOException {
        if (this.frame == null) {
            this.timeline.appendFrame();
        } else {
            this.frame = null;
        }
    }

    protected Frame currentFrame() {
        if (this.frame == null) {
            this.frame = this.timeline.appendFrame();
        }
        return this.frame;
    }

    public void tagDefineSound(int id, int format, int frequency, boolean bits16, boolean stereo, int sampleCount, byte[] soundData) throws IOException {
    }

    public void tagDefineButtonSound(int buttonId, int rollOverSoundId, SoundInfo rollOverSoundInfo, int rollOutSoundId, SoundInfo rollOutSoundInfo, int pressSoundId, SoundInfo pressSoundInfo, int releaseSoundId, SoundInfo releaseSoundInfo) throws IOException {
    }

    public void tagStartSound(int soundId, SoundInfo info) throws IOException {
    }

    public void tagSoundStreamHead(int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
    }

    public void tagSoundStreamHead2(int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
    }

    public void tagSoundStreamBlock(byte[] soundData) throws IOException {
    }

    public void tagSerialNumber(String serialNumber) throws IOException {
    }

    public void tagGenerator(byte[] data) throws IOException {
    }

    public void tagGeneratorText(byte[] data) throws IOException {
    }

    public void tagGeneratorCommand(byte[] data) throws IOException {
    }

    public void tagGeneratorFont(byte[] data) throws IOException {
    }

    public void tagNameCharacter(byte[] data) throws IOException {
    }

    public void tagDefineBits(int id, byte[] imageData) throws IOException {
    }

    public void tagJPEGTables(byte[] jpegEncodingData) throws IOException {
    }

    public void tagDefineBitsJPEG3(int id, byte[] imageData, byte[] alphaData) throws IOException {
    }

    public SWFActions tagDoAction() throws IOException {
        Actions acts = this.currentFrame().actions(this.movie.getVersion());
        return acts;
    }

    public SWFShape tagDefineShape(int id, Rect outline) throws IOException {
        Shape s = new Shape();
        s.setBoundingRectangle((double)outline.getMinX() / 20.0, (double)outline.getMinY() / 20.0, (double)outline.getMaxX() / 20.0, (double)outline.getMaxY() / 20.0);
        this.saveSymbol(id, s);
        return new ShapeBuilder(s);
    }

    public SWFShape tagDefineShape2(int id, Rect outline) throws IOException {
        Shape s = new Shape();
        s.setBoundingRectangle((double)outline.getMinX() / 20.0, (double)outline.getMinY() / 20.0, (double)outline.getMaxX() / 20.0, (double)outline.getMaxY() / 20.0);
        this.saveSymbol(id, s);
        return new ShapeBuilder(s);
    }

    public SWFShape tagDefineShape3(int id, Rect outline) throws IOException {
        Shape s = new Shape();
        s.setBoundingRectangle((double)outline.getMinX() / 20.0, (double)outline.getMinY() / 20.0, (double)outline.getMaxX() / 20.0, (double)outline.getMaxY() / 20.0);
        this.saveSymbol(id, s);
        return new ShapeBuilder(s);
    }

    public void tagFreeCharacter(int charId) throws IOException {
    }

    public void tagPlaceObject(int charId, int depth, Matrix matrix, AlphaTransform cxform) throws IOException {
        Symbol s = this.getSymbol(charId);
        if (s == null) {
            return;
        }
        this.timeline.setAvailableDepth(depth);
        Instance inst = this.currentFrame().placeSymbol(s, new Transform(matrix), cxform);
        this.saveInstance(depth, inst);
    }

    public SWFActions tagPlaceObject2(boolean isMove, int clipDepth, int depth, int charId, Matrix matrix, AlphaTransform cxform, int ratio, String name, int clipActionFlags) throws IOException {
        Instance inst = null;
        if (isMove && charId <= 0) {
            inst = this.getInstance(depth);
            if (inst == null) {
                System.out.println("Failed to find Instance at depth " + depth);
                return null;
            }
            this.currentFrame().alter(inst, new Transform(matrix), cxform, ratio);
        } else {
            Symbol s = this.getSymbol(charId);
            if (s == null) {
                System.out.println("Failed to find Symbol with id " + charId);
                return null;
            }
            if (name != null) {
                Frame frame = this.currentFrame();
                if (isMove) {
                    frame.replaceMovieClip(s, depth, new Transform(matrix), cxform, name, null);
                } else {
                    this.timeline.setAvailableDepth(depth);
                    frame.placeMovieClip(s, new Transform(matrix), cxform, name, null);
                }
                this.saveInstance(depth, inst);
            } else {
                if (clipActionFlags != 0) {
                    return new ClipActionBuilder(s, matrix, cxform, depth, name, this.movie.getVersion(), isMove);
                }
                Frame frame = this.currentFrame();
                if (isMove) {
                    inst = frame.replaceSymbol(s, depth, new Transform(matrix), cxform, ratio, clipDepth);
                } else {
                    this.timeline.setAvailableDepth(depth);
                    inst = frame.placeSymbol(s, new Transform(matrix), cxform, ratio, clipDepth);
                }
                this.saveInstance(depth, inst);
            }
        }
        return null;
    }

    public void tagRemoveObject(int charId, int depth) throws IOException {
        Instance inst = this.getInstance(depth);
        if (inst == null) {
            return;
        }
        this.currentFrame().remove(inst);
    }

    public void tagRemoveObject2(int depth) throws IOException {
        Instance inst = this.getInstance(depth);
        if (inst == null) {
            return;
        }
        this.currentFrame().remove(inst);
    }

    public void tagSetBackgroundColor(Color color) throws IOException {
        if (this.newMovie) {
            this.movie.setBackColor(color);
        }
    }

    public void tagFrameLabel(String label) throws IOException {
        this.currentFrame().setLabel(label);
    }

    public SWFTagTypes tagDefineSprite(int id) throws IOException {
        MovieClip clip = new MovieClip();
        this.saveSymbol(id, clip);
        return new MovieBuilder(this, clip);
    }

    public void tagProtect(byte[] password) throws IOException {
        if (this.newMovie) {
            this.movie.protect(true);
        }
    }

    public void tagEnableDebug(byte[] password) throws IOException {
    }

    public SWFVectors tagDefineFont(int id, int numGlyphs) throws IOException {
        FontDefinition fontDef = new FontDefinition();
        Font font = new Font(fontDef);
        this.saveSymbol(id, font);
        return new GlyphBuilder(fontDef, font, numGlyphs);
    }

    public void tagDefineFontInfo(int fontId, String fontName, int flags, int[] codes) throws IOException {
        Symbol s = this.getSymbol(fontId);
        if (s == null || !(s instanceof Font)) {
            return;
        }
        Font font = (Font)s;
        FontDefinition def = font.getDefinition();
        def.setName(fontName);
        boolean isUnicode = (flags & 0x20) != 0;
        boolean isShiftJIS = (flags & 0x10) != 0;
        boolean isAnsi = (flags & 8) != 0;
        boolean isItalic = (flags & 4) != 0;
        boolean isBold = (flags & 2) != 0;
        def.setFontFlags(isUnicode, isShiftJIS, isAnsi, isItalic, isBold, false);
        List glyphs = font.getGlyphList();
        int glyphCount = glyphs.size();
        int i = 0;
        while (i < codes.length && i < glyphCount) {
            int code = codes[i];
            font.setCode(i, code);
            ++i;
        }
    }

    public SWFVectors tagDefineFont2(int id, int flags, String name, int numGlyphs, int ascent, int descent, int leading, int[] codes, int[] advances, Rect[] bounds, int[] kernCodes1, int[] kernCodes2, int[] kernAdjustments) throws IOException {
        boolean hasMetrics = (flags & 0x80) != 0;
        boolean isShiftJIS = (flags & 0x40) != 0;
        boolean isUnicode = (flags & 0x20) != 0;
        boolean isAnsi = (flags & 0x10) != 0;
        boolean isItalic = (flags & 2) != 0;
        boolean isBold = (flags & 1) != 0;
        FontDefinition fontDef = new FontDefinition(name, (double)ascent / 20.0, (double)descent / 20.0, (double)leading / 20.0, isUnicode, isShiftJIS, isAnsi, isItalic, isBold, hasMetrics);
        Font font = new Font(fontDef);
        this.saveSymbol(id, font);
        if (hasMetrics && kernCodes1 != null) {
            List kerns = fontDef.getKerningPairList();
            int i = 0;
            while (i < kernCodes1.length) {
                FontDefinition.KerningPair pair = new FontDefinition.KerningPair(kernCodes1[i], kernCodes2[i], (double)kernAdjustments[i] / 20.0);
                kerns.add(pair);
                ++i;
            }
        }
        return new GlyphBuilder(fontDef, font, codes, advances, bounds);
    }

    public void tagDefineTextField(int fieldId, String fieldName, String initialText, Rect boundary, int flags, AlphaColor textColor, int alignment, int fontId, int fontSize, int charLimit, int leftMargin, int rightMargin, int indentation, int lineSpacing) throws IOException {
        Symbol f = this.getSymbol(fontId);
        if (f == null || !(f instanceof Font)) {
            return;
        }
        Font font = (Font)f;
        EditField field = new EditField(fieldName, initialText, font, (double)fontSize / 20.0, (double)boundary.getMinX() / 20.0, (double)boundary.getMinY() / 20.0, (double)boundary.getMaxX() / 20.0, (double)boundary.getMaxY() / 20.0);
        field.setTextColor(textColor);
        field.setAlignment(alignment);
        field.setCharLimit(charLimit);
        field.setLeftMargin((double)leftMargin / 20.0);
        field.setRightMargin((double)rightMargin / 20.0);
        field.setIndentation((double)indentation / 20.0);
        field.setLineSpacing((double)lineSpacing / 20.0);
        boolean isSelectable = (flags & 0x1000) == 0;
        boolean hasBorder = (flags & 0x800) != 0;
        boolean isHtml = (flags & 0x200) != 0;
        boolean usesSystemFont = (flags & 0x100) == 0;
        boolean hasWordWrap = (flags & 0x40) != 0;
        boolean isMultiline = (flags & 0x20) != 0;
        boolean isPassword = (flags & 0x10) != 0;
        boolean isEditable = (flags & 8) == 0;
        field.setProperties(isSelectable, hasBorder, isHtml, usesSystemFont, hasWordWrap, isMultiline, isPassword, isEditable);
        this.saveSymbol(fieldId, field);
    }

    public SWFText tagDefineText(int id, Rect bounds, Matrix matrix) throws IOException {
        Text text = new Text(new Transform(matrix));
        this.saveSymbol(id, text);
        return new TextBuilder(text);
    }

    public SWFText tagDefineText2(int id, Rect bounds, Matrix matrix) throws IOException {
        Text text = new Text(new Transform(matrix));
        this.saveSymbol(id, text);
        return new TextBuilder(text);
    }

    public SWFActions tagDefineButton(int id, List buttonRecords) throws IOException {
        Button but = new Button(false);
        this.saveSymbol(id, but);
        Iterator e = buttonRecords.iterator();
        while (e.hasNext()) {
            ButtonRecord rec = (ButtonRecord)e.next();
            Symbol s = this.getSymbol(rec.getCharId());
            if (s == null) continue;
            int flags = rec.getFlags();
            boolean hit = (flags & 8) != 0;
            boolean up = (flags & 1) != 0;
            boolean over = (flags & 2) != 0;
            boolean down = (flags & 4) != 0;
            but.addLayer(s, new Transform(rec.getMatrix()), null, rec.getLayer(), hit, up, down, over);
        }
        return new ButtonActionBuilder(but, this.movie.getVersion());
    }

    public void tagButtonCXForm(int buttonId, ColorTransform transform) throws IOException {
        Symbol s = this.getSymbol(buttonId);
        if (s == null || !(s instanceof Button)) {
            return;
        }
        Button but = (Button)s;
        List layers = but.getButtonLayers();
        Iterator it = layers.iterator();
        while (it.hasNext()) {
            Button.Layer layer = (Button.Layer)it.next();
            layer.setColoring(new AlphaTransform(transform));
        }
    }

    public SWFActions tagDefineButton2(int id, boolean trackAsMenu, List buttonRecord2s) throws IOException {
        Button but = new Button(trackAsMenu);
        this.saveSymbol(id, but);
        Iterator e = buttonRecord2s.iterator();
        while (e.hasNext()) {
            ButtonRecord2 rec = (ButtonRecord2)e.next();
            Symbol s = this.getSymbol(rec.getCharId());
            if (s == null) continue;
            int flags = rec.getFlags();
            boolean hit = (flags & 8) != 0;
            boolean up = (flags & 1) != 0;
            boolean over = (flags & 2) != 0;
            boolean down = (flags & 4) != 0;
            but.addLayer(s, new Transform(rec.getMatrix()), rec.getTransform(), rec.getLayer(), hit, up, down, over);
        }
        return new ButtonActionBuilder(but, this.movie.getVersion());
    }

    public void tagExport(String[] names, int[] ids) throws IOException {
        Symbol[] symbols = new Symbol[ids.length];
        int i = 0;
        while (i < ids.length) {
            symbols[i] = this.getSymbol(ids[i]);
            ++i;
        }
        this.movie.exportSymbols(names, symbols);
    }

    public void tagImport(String movieName, String[] names, int[] ids) throws IOException {
        this.movie.importSymbols(movieName, names);
    }

    public void tagDefineQuickTimeMovie(int id, String filename) throws IOException {
        this.saveSymbol(id, new QTMovie(filename));
    }

    public void tagDefineBitsJPEG2(int id, byte[] data) throws IOException {
        this.saveSymbol(id, new Image.JPEG(data));
    }

    public void tagDefineBitsJPEG2(int id, InputStream jpegImage) throws IOException {
        this.saveSymbol(id, new Image.JPEG(jpegImage));
    }

    public void tagDefineBitsLossless(int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        this.saveSymbol(id, new Image.Lossless(colors, imageData, (double)width / 20.0, (double)height / 20.0, false, format));
    }

    public void tagDefineBitsLossless2(int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        this.saveSymbol(id, new Image.Lossless(colors, imageData, (double)width / 20.0, (double)height / 20.0, true, format));
    }

    public SWFShape tagDefineMorphShape(int id, Rect startBounds, Rect endBounds) throws IOException {
        return new MorphShapeBuilder(id, startBounds, endBounds);
    }

    protected static class ActionsBuilder
    extends SWFActionsImpl {
        protected int version;
        protected List actions = new Vector();

        protected ActionsBuilder(int flashVersion) {
            super(null);
            this.version = flashVersion;
        }

        public Actions[] getActions() {
            Actions[] a = new Actions[this.actions.size()];
            this.actions.toArray(a);
            return a;
        }

        public void start(int conditions) {
            this.acts = new Actions(conditions, this.version);
            this.actions.add(this.acts);
        }
    }

    protected class ButtonActionBuilder
    extends ActionsBuilder {
        protected Button but;

        protected ButtonActionBuilder(Button b, int flashVersion) {
            super(flashVersion);
            this.but = b;
        }

        public void start(int conditions2) {
            int conditions = conditions2;
            if (conditions == 0) {
                conditions = 8;
            }
            this.acts = this.but.addActions(conditions, this.version);
        }
    }

    protected class ClipActionBuilder
    extends ActionsBuilder {
        protected Symbol symbol;
        protected Transform matrix;
        protected AlphaTransform cxform;
        protected String name;
        protected int depth;
        protected boolean isMove;

        protected ClipActionBuilder(Symbol symbol, Matrix matrix, AlphaTransform cxform, int depth, String name, int version, boolean isMove) {
            super(version);
            this.symbol = symbol;
            this.matrix = matrix != null ? new Transform(matrix) : null;
            this.cxform = cxform;
            this.name = name;
            this.depth = depth;
            this.isMove = isMove;
        }

        public void done() throws IOException {
            Frame frame = MovieBuilder.this.currentFrame();
            Instance inst = null;
            if (this.isMove) {
                frame.replaceMovieClip(this.symbol, this.depth, this.matrix, this.cxform, this.name, this.getActions());
            } else {
                MovieBuilder.this.timeline.setAvailableDepth(this.depth);
                frame.placeMovieClip(this.symbol, this.matrix, this.cxform, this.name, this.getActions());
            }
            MovieBuilder.this.saveInstance(this.depth, inst);
        }
    }

    protected class ShapeBuilder
    implements SWFShape {
        protected Shape s;
        protected int currx;
        protected int curry;

        protected ShapeBuilder(Shape s) {
            this.s = s;
        }

        public void done() {
        }

        public void line(int dx, int dy) {
            this.currx += dx;
            this.curry += dy;
            this.s.line((double)this.currx / 20.0, (double)this.curry / 20.0);
        }

        public void curve(int cx2, int cy2, int dx, int dy) {
            int cx = cx2 + this.currx;
            int cy = cy2 + this.curry;
            this.currx = cx + dx;
            this.curry = cy + dy;
            this.s.curve((double)this.currx / 20.0, (double)this.curry / 20.0, (double)cx / 20.0, (double)cy / 20.0);
        }

        public void move(int x, int y) {
            this.currx = x;
            this.curry = y;
            this.s.move((double)this.currx / 20.0, (double)this.curry / 20.0);
        }

        public void setFillStyle0(int styleIndex) {
            this.s.setLeftFillStyle(styleIndex);
        }

        public void setFillStyle1(int styleIndex) {
            this.s.setRightFillStyle(styleIndex);
        }

        public void setLineStyle(int styleIndex) {
            this.s.setLineStyle(styleIndex);
        }

        public void defineFillStyle(Color color) {
            this.s.defineFillStyle(color);
        }

        public void defineFillStyle(Matrix matrix, int[] ratios, Color[] colors, boolean radial) {
            this.s.defineFillStyle(colors, ratios, new Transform(matrix), radial);
        }

        public void defineFillStyle(int bitmapId, Matrix matrix, boolean clipped) {
            Symbol image = MovieBuilder.this.getSymbol(bitmapId);
            this.s.defineFillStyle(image, new Transform(matrix), clipped);
        }

        public void defineLineStyle(int width, Color color) {
            this.s.defineLineStyle((double)width / 20.0, color);
        }
    }

    protected class MorphShapeBuilder
    extends ShapeBuilder {
        protected int id;
        protected Rect startBounds;
        protected Rect endBounds;
        protected Shape shape1;

        protected MorphShapeBuilder(int id, Rect startBounds, Rect endBounds) {
            super(new Shape());
            this.id = id;
            this.startBounds = startBounds;
            this.endBounds = endBounds;
        }

        public void done() {
            if (this.shape1 == null) {
                this.shape1 = this.s;
                this.s = new Shape();
                return;
            }
            Shape shape2 = this.s;
            MorphShape morph = new MorphShape(this.shape1, shape2);
            MovieBuilder.this.saveSymbol(this.id, morph);
        }
    }

    protected class GlyphBuilder
    extends ShapeBuilder {
        protected FontDefinition fontDef;
        protected Font font;
        protected int count;
        protected int[] advances;
        protected int[] codes;
        protected Rect[] bounds;
        protected List defGlyphs;
        protected List fontGlyphs;
        protected int index = 0;

        public GlyphBuilder(FontDefinition fontDef, Font font, int glyphCount) {
            super(new Shape());
            this.fontDef = fontDef;
            this.font = font;
            this.count = glyphCount;
            this.defGlyphs = fontDef.getGlyphList();
            this.fontGlyphs = font.getGlyphList();
        }

        public GlyphBuilder(FontDefinition fontDef, Font font, int[] codes, int[] advances, Rect[] bounds) {
            this(fontDef, font, codes.length);
            this.codes = codes;
            this.advances = advances;
            this.bounds = bounds;
        }

        public void done() {
            if (this.index >= this.count) {
                return;
            }
            if (this.bounds != null) {
                Rect r = this.bounds[this.index];
                this.s.setBoundingRectangle((double)r.getMinX() / 20.0, (double)r.getMinY() / 20.0, (double)r.getMaxX() / 20.0, (double)r.getMaxY() / 20.0);
            }
            double advance = this.advances != null ? (double)this.advances[this.index] / 20.0 : 0.0;
            int code = this.codes != null ? this.codes[this.index] : 0;
            FontDefinition.Glyph g = new FontDefinition.Glyph(this.s, advance, code);
            this.defGlyphs.add(g);
            this.font.addGlyph(g);
            ++this.index;
            if (this.index < this.count) {
                this.s = new Shape();
            }
        }
    }

    protected class TextBuilder
    implements SWFText {
        protected Text t;
        protected Font font;
        protected double size;
        protected Color color;
        protected double x;
        protected double y;
        protected boolean hasX;
        protected boolean hasY;

        protected TextBuilder(Text text) {
            this.t = text;
        }

        public void font(int fontId, int textHeight) {
            Symbol f = MovieBuilder.this.getSymbol(fontId);
            if (f == null || !(f instanceof Font)) {
                return;
            }
            this.font = (Font)f;
            this.size = (double)textHeight / 20.0;
        }

        public void color(Color color) {
            this.color = color;
        }

        public void setX(int x) {
            this.hasX = true;
            this.x = (double)x / 20.0;
        }

        public void setY(int y) {
            this.hasY = true;
            this.y = (double)y / 20.0;
        }

        public void text(int[] glyphIndices, int[] glyphAdvances) {
            List glyphs = this.font.getGlyphList();
            char[] chars = new char[glyphIndices.length];
            int i = 0;
            while (i < glyphIndices.length) {
                int index = glyphIndices[i];
                double advance = (double)glyphAdvances[i] / 20.0;
                advance = advance * 51.2 / this.size;
                FontDefinition.Glyph g = (FontDefinition.Glyph)glyphs.get(index);
                chars[i] = (char)g.getCode();
                if (advance > g.getAdvance()) {
                    g.setAdvance(advance);
                }
                ++i;
            }
            try {
                Font.Chars cc = this.font.chars(new String(chars), this.size);
                this.t.row(cc, this.color, this.x, this.y, this.hasX, this.hasY);
            }
            catch (Font.NoGlyphException nge) {
                this.color = null;
            }
            this.color = null;
            this.hasX = false;
            this.hasY = false;
        }

        public void done() {
        }
    }
}

