/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import pt.tumba.parser.swf.Frame;
import pt.tumba.parser.swf.Movie;
import pt.tumba.parser.swf.SWFTagTypes;
import pt.tumba.parser.swf.Symbol;
import pt.tumba.parser.swf.TimeLine;

public class MovieClip
extends Symbol
implements TimeLine {
    protected SortedMap frames = new TreeMap();
    protected int frameCount = 0;
    protected int depth = 1;

    public int getFrameCount() {
        return this.frameCount;
    }

    public Frame getFrame(int frameNumber) {
        if (frameNumber < 1) {
            return null;
        }
        Integer num = new Integer(frameNumber);
        Frame frame = (Frame)this.frames.get(num);
        if (frame == null) {
            frame = new Frame(frameNumber, this);
            this.frames.put(num, frame);
            if (frameNumber > this.frameCount) {
                this.frameCount = frameNumber;
            }
        }
        return frame;
    }

    public Frame appendFrame() {
        ++this.frameCount;
        Frame frame = new Frame(this.frameCount, this);
        this.frames.put(new Integer(this.frameCount), frame);
        return frame;
    }

    public int getAvailableDepth() {
        return this.depth;
    }

    public void setAvailableDepth(int depth) {
        if (depth < 1) {
            return;
        }
        this.depth = depth;
    }

    protected int defineSymbol(Movie movie, SWFTagTypes timelineWriter, SWFTagTypes definitionWriter) throws IOException {
        int id = this.getNextId(movie);
        Iterator iter = this.frames.values().iterator();
        while (iter.hasNext()) {
            Frame frame = (Frame)iter.next();
            frame.flushDefinitions(movie, timelineWriter, definitionWriter);
        }
        SWFTagTypes spriteWriter = definitionWriter.tagDefineSprite(id);
        int lastFrame = 0;
        Iterator iter2 = this.frames.values().iterator();
        while (iter2.hasNext()) {
            Frame frame = (Frame)iter2.next();
            int number = frame.getFrameNumber();
            while (number > lastFrame + 1) {
                spriteWriter.tagShowFrame();
                ++lastFrame;
            }
            frame.write(movie, definitionWriter, spriteWriter);
            lastFrame = number;
        }
        spriteWriter.tagEnd();
        return id;
    }
}

