/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import pt.tumba.parser.DocFilter;
import pt.tumba.parser.swf.AlphaColor;
import pt.tumba.parser.swf.Color;
import pt.tumba.parser.swf.Matrix;
import pt.tumba.parser.swf.Rect;
import pt.tumba.parser.swf.SWFReader;
import pt.tumba.parser.swf.SWFTagTypesImpl;
import pt.tumba.parser.swf.SWFTags;
import pt.tumba.parser.swf.SWFText;
import pt.tumba.parser.swf.SWFVectors;
import pt.tumba.parser.swf.TagParser;

public class SWF2HTML
extends SWFTagTypesImpl
implements DocFilter {
    private int sizeCount = 0;
    protected Map fontCodes = new HashMap();
    protected PrintWriter output;

    public int originalSize() {
        return this.sizeCount;
    }

    public SWF2HTML() {
        super(null);
    }

    public void tagDefineFontInfo(int fontId, String fontName, int flags, int[] codes) throws IOException {
        this.fontCodes.put(new Integer(fontId), codes);
    }

    public SWFVectors tagDefineFont2(int id, int flags, String name, int numGlyphs, int ascent, int descent, int leading, int[] codes, int[] advances, Rect[] bounds, int[] kernCodes1, int[] kernCodes2, int[] kernAdjustments) throws IOException {
        this.fontCodes.put(new Integer(id), codes != null ? codes : new int[]{});
        return null;
    }

    public void tagDefineTextField(int fieldId, String fieldName, String initialText, Rect boundary, int flags, AlphaColor textColor, int alignment, int fontId, int fontSize, int charLimit, int leftMargin, int rightMargin, int indentation, int lineSpacing) throws IOException {
        if (initialText != null) {
            this.output.println(initialText);
        }
    }

    public SWFText tagDefineText(int id, Rect bounds, Matrix matrix) throws IOException {
        return new TextDumper();
    }

    public SWFText tagDefineText2(int id, Rect bounds, Matrix matrix) throws IOException {
        return new TextDumper();
    }

    public String convertSWFToHTML(File in) throws Exception {
        return this.convertSWFToHTML(new FileInputStream(in));
    }

    public String convertSWFToHTML(URL in) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)in.openConnection();
        conn.setAllowUserInteraction(false);
        conn.setRequestProperty("User-agent", "www.tumba.pt");
        conn.setInstanceFollowRedirects(true);
        conn.connect();
        return this.convertSWFToHTML(conn.getInputStream());
    }

    public String convertSWFToHTML(InputStream in) throws Exception {
        StringWriter out1 = new StringWriter();
        this.output = new PrintWriter(out1);
        this.output.println("<html><body>");
        TagParser parser = new TagParser(this);
        SWFReader reader = new SWFReader((SWFTags)parser, in);
        reader.readFile();
        in.close();
        this.output.println("</body></html>");
        this.sizeCount = reader.size;
        return out1.toString();
    }

    public String convertSWFToHTML(byte[] b2) throws Exception {
        return this.convertSWFToHTML(new ByteArrayInputStream(b2));
    }

    public class TextDumper
    implements SWFText {
        protected Integer fontId;
        protected boolean firstY = true;

        public void font(int fontId, int textHeight) {
            this.fontId = new Integer(fontId);
        }

        public void setY(int y) {
            if (this.firstY) {
                this.firstY = false;
            } else {
                SWF2HTML.this.output.println();
            }
        }

        public void text(int[] glyphIndices, int[] glyphAdvances) {
            int[] codes = (int[])SWF2HTML.this.fontCodes.get(this.fontId);
            if (codes == null) {
                return;
            }
            char[] chars = new char[glyphIndices.length];
            int i = 0;
            while (i < chars.length) {
                int index = glyphIndices[i];
                chars[i] = index >= codes.length ? (char)index : (char)codes[index];
                ++i;
            }
            SWF2HTML.this.output.print(chars);
        }

        public void color(Color color) {
        }

        public void setX(int x) {
        }

        public void done() {
            SWF2HTML.this.output.println();
        }
    }
}

