/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import pt.tumba.parser.swf.ActionTextWriter;
import pt.tumba.parser.swf.AlphaColor;
import pt.tumba.parser.swf.AlphaTransform;
import pt.tumba.parser.swf.ButtonRecord;
import pt.tumba.parser.swf.ButtonRecord2;
import pt.tumba.parser.swf.Color;
import pt.tumba.parser.swf.ColorTransform;
import pt.tumba.parser.swf.Decompiler;
import pt.tumba.parser.swf.Hex;
import pt.tumba.parser.swf.Matrix;
import pt.tumba.parser.swf.Rect;
import pt.tumba.parser.swf.SWFActions;
import pt.tumba.parser.swf.SWFReader;
import pt.tumba.parser.swf.SWFShape;
import pt.tumba.parser.swf.SWFTagTypes;
import pt.tumba.parser.swf.SWFTags;
import pt.tumba.parser.swf.SWFText;
import pt.tumba.parser.swf.SWFVectors;
import pt.tumba.parser.swf.SoundInfo;
import pt.tumba.parser.swf.TagParser;

public class SWFTagDumper
implements SWFTagTypes,
SWFShape,
SWFText {
    protected PrintWriter writer;
    protected String dashes = "---------------";
    protected boolean dumpHex;
    protected String indent = "";
    protected boolean decompileActions = false;

    public SWFTagDumper(boolean dumpHex, boolean decompileActions) {
        this(System.out, dumpHex, decompileActions);
    }

    public SWFTagDumper(OutputStream out, boolean dumpHex, boolean decompileActions) {
        this.writer = new PrintWriter(out);
        this.dumpHex = dumpHex;
        this.decompileActions = decompileActions;
    }

    public SWFTagDumper(PrintWriter writer, boolean dumpHex, boolean decompileActions) {
        this.writer = writer;
        this.dumpHex = dumpHex;
        this.decompileActions = decompileActions;
    }

    protected void println(String line) {
        this.writer.println(String.valueOf(this.indent) + line);
    }

    public void tag(int tagType, boolean longTag, byte[] contents) throws IOException {
        this.println("Tag " + tagType + " length=" + contents.length);
        if (this.dumpHex) {
            Hex.dump(this.writer, contents, 0L, String.valueOf(this.indent) + "    ", false);
            this.println(this.dashes);
        }
    }

    public void header(int version, long length, int twipsWidth, int twipsHeight, int frameRate, int frameCount) throws IOException {
        this.println("header: version=" + version + " length=" + length + " width=" + twipsWidth + " height=" + twipsHeight + " rate=" + frameRate + " frame-count=" + frameCount);
    }

    public void tagEnd() throws IOException {
        this.println("end");
        this.println(this.dashes);
    }

    public void tagStartSound(int soundId, SoundInfo info) throws IOException {
        this.println("start-sound id=" + soundId + " " + info);
    }

    public void tagSoundStreamHead(int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        this.printSoundStreamHead("sound-stream-head", playbackFrequency, playback16bit, playbackStereo, streamFormat, streamFrequency, stream16bit, streamStereo, averageSampleCount);
    }

    public void tagSoundStreamHead2(int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        this.printSoundStreamHead("sound-stream-head-2", playbackFrequency, playback16bit, playbackStereo, streamFormat, streamFrequency, stream16bit, streamStereo, averageSampleCount);
    }

    public void printSoundStreamHead(String name, int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        String playFreq = "5.5";
        if (playbackFrequency == 1) {
            playFreq = "11";
        }
        if (playbackFrequency == 2) {
            playFreq = "22";
        }
        if (playbackFrequency == 3) {
            playFreq = "44";
        }
        String streamFreq = "5.5";
        if (streamFrequency == 1) {
            streamFreq = "11";
        }
        if (streamFrequency == 2) {
            streamFreq = "22";
        }
        if (streamFrequency == 3) {
            streamFreq = "44";
        }
        String format = "RawSamples";
        if (streamFormat == 1) {
            format = "ADPCM";
        }
        if (streamFormat == 2) {
            format = "MP3";
        }
        this.println(String.valueOf(name) + " play at " + playFreq + "kHz stereo=" + playbackStereo + " 16bit=" + playback16bit + " | Stream at " + streamFreq + "kHz format=" + format + " stereo=" + streamStereo + " 16bit=" + stream16bit + " Avg-Samples=" + averageSampleCount);
    }

    public void tagSoundStreamBlock(byte[] soundData) throws IOException {
        this.println("sound-stream-block");
        if (this.dumpHex) {
            Hex.dump(this.writer, soundData, 0L, String.valueOf(this.indent) + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagSerialNumber(String serialNumber) throws IOException {
        this.println("serial number =" + serialNumber);
    }

    public void tagGenerator(byte[] data) throws IOException {
        this.println("generator tag");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, String.valueOf(this.indent) + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagGeneratorText(byte[] data) throws IOException {
        this.println("generator text");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, String.valueOf(this.indent) + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagGeneratorFont(byte[] data) throws IOException {
        this.println("generator font");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, String.valueOf(this.indent) + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagGeneratorCommand(byte[] data) throws IOException {
        this.println("generator command");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, String.valueOf(this.indent) + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagNameCharacter(byte[] data) throws IOException {
        this.println("generator name character");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, String.valueOf(this.indent) + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagDefineBits(int id, byte[] imageData) throws IOException {
        this.println("jpeg bits");
        if (this.dumpHex) {
            Hex.dump(this.writer, imageData, 0L, String.valueOf(this.indent) + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagJPEGTables(byte[] jpegEncodingData) throws IOException {
        this.println("jpeg encoding data");
        if (this.dumpHex) {
            Hex.dump(this.writer, jpegEncodingData, 0L, String.valueOf(this.indent) + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagDefineBitsJPEG3(int id, byte[] imageData, byte[] alphaData) throws IOException {
        this.println("jpeg with alpha");
        if (this.dumpHex) {
            Hex.dump(this.writer, imageData, 0L, String.valueOf(this.indent) + "    ", false);
            this.println("--- Alpha Channel follows ---");
            Hex.dump(this.writer, alphaData, 0L, String.valueOf(this.indent) + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagDefineSound(int id, int format, int frequency, boolean bits16, boolean stereo, int sampleCount, byte[] soundData) throws IOException {
        String freq = "5.5";
        if (frequency == 1) {
            freq = "11";
        }
        if (frequency == 2) {
            freq = "22";
        }
        if (frequency == 3) {
            freq = "44";
        }
        String formatS = "RawSamples";
        if (format == 1) {
            formatS = "ADPCM";
        }
        if (format == 2) {
            formatS = "MP3";
        }
        this.println("define sound: id=" + id + " format=" + formatS + " freq=" + freq + "kHz 16bit=" + bits16 + " stereo=" + stereo + " samples=" + sampleCount);
        if (this.dumpHex) {
            Hex.dump(this.writer, soundData, 0L, String.valueOf(this.indent) + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagDefineButtonSound(int buttonId, int rollOverSoundId, SoundInfo rollOverSoundInfo, int rollOutSoundId, SoundInfo rollOutSoundInfo, int pressSoundId, SoundInfo pressSoundInfo, int releaseSoundId, SoundInfo releaseSoundInfo) throws IOException {
        this.println("define button sound: id=" + buttonId);
        this.println("    roll-over sound=" + rollOverSoundId + " " + rollOverSoundInfo);
        this.println("    roll-out  sound=" + rollOutSoundId + " " + rollOutSoundInfo);
        this.println("    press     sound=" + pressSoundId + " " + pressSoundInfo);
        this.println("    release   sound=" + releaseSoundId + " " + releaseSoundInfo);
    }

    public void tagShowFrame() throws IOException {
        this.println("---------- frame ----------");
    }

    public SWFActions tagDoAction() throws IOException {
        this.println("actions:");
        if (this.decompileActions) {
            return new Decompiler(this.writer, 1 + this.indent.length() / 4);
        }
        ActionTextWriter acts = new ActionTextWriter(this.writer);
        acts.indent = "    " + this.indent;
        return acts;
    }

    public SWFShape tagDefineShape(int id, Rect outline) throws IOException {
        this.println("shape id=" + id + "   " + outline);
        return this;
    }

    public SWFShape tagDefineShape2(int id, Rect outline) throws IOException {
        this.println("shape2 id=" + id + "   " + outline);
        return this;
    }

    public SWFShape tagDefineShape3(int id, Rect outline) throws IOException {
        this.println("shape3 id=" + id + "   " + outline);
        return this;
    }

    public void tagFreeCharacter(int charId) throws IOException {
        this.println("free character id=" + charId);
    }

    public void tagPlaceObject(int charId, int depth, Matrix matrix, AlphaTransform cxform) throws IOException {
        this.println("place-object id=" + charId + " depth=" + depth + "  " + matrix + "  " + cxform);
    }

    public SWFActions tagPlaceObject2(boolean isMove, int clipDepth, int depth, int charId, Matrix matrix, AlphaTransform cxform, int ratio, String name, int clipActionFlags) throws IOException {
        this.println("place-object2 move=" + isMove + " id=" + charId + " depth=" + depth + " clip=" + clipDepth + " ratio=" + ratio + " name=" + name + "  " + matrix + "  " + cxform);
        if (clipActionFlags != 0) {
            this.println("  clip-actions:");
            if (this.decompileActions) {
                return new Decompiler(this.writer, 1 + this.indent.length() / 4);
            }
            ActionTextWriter acts = new ActionTextWriter(this.writer);
            acts.indent = "    " + this.indent;
            return acts;
        }
        return null;
    }

    public void tagRemoveObject(int charId, int depth) throws IOException {
        this.println("remove-object id=" + charId + " depth=" + depth);
    }

    public void tagRemoveObject2(int depth) throws IOException {
        this.println("remove-object2 depth=" + depth);
    }

    public void tagSetBackgroundColor(Color color) throws IOException {
        this.println("background-color  " + color);
    }

    public void tagFrameLabel(String label) throws IOException {
        this.println("frame-label " + label);
    }

    public SWFTagTypes tagDefineSprite(int id) throws IOException {
        this.println("sprite id=" + id);
        SWFTagDumper dumper = new SWFTagDumper(this.writer, this.dumpHex, this.decompileActions);
        dumper.indent = String.valueOf(this.indent) + "    ";
        return dumper;
    }

    public void tagProtect(byte[] password) throws IOException {
        this.println("protect");
    }

    public void tagEnableDebug(byte[] password) throws IOException {
        this.println("enable-debug");
    }

    public SWFVectors tagDefineFont(int id, int numGlyphs) throws IOException {
        this.println("font id=" + id);
        return this;
    }

    public void tagDefineFontInfo(int fontId, String fontName, int flags, int[] codes) throws IOException {
        this.println("font-info id=" + fontId + " name=" + fontName + " flags=" + Integer.toBinaryString(flags) + " codes=" + codes.length);
    }

    public SWFVectors tagDefineFont2(int id, int flags, String name, int numGlyphs, int ascent, int descent, int leading, int[] codes, int[] advances, Rect[] bounds, int[] kernCodes1, int[] kernCodes2, int[] kernAdjustments) throws IOException {
        this.println("font2 id=" + id + " flags=" + Integer.toBinaryString(flags) + " name=" + name + " ascent=" + ascent + " descent=" + descent + " leading=" + leading + " has-kerns=" + (kernCodes1 != null));
        return this;
    }

    public void tagDefineTextField(int fieldId, String fieldName, String initialText, Rect boundary, int flags, AlphaColor textColor, int alignment, int fontId, int fontSize, int charLimit, int leftMargin, int rightMargin, int indentation, int lineSpacing) throws IOException {
        this.println("edit-field id=" + fieldId + " name=" + fieldName + " text=" + initialText + " font=" + fontId + " size=" + fontSize + " chars=" + charLimit + " left=" + leftMargin + " right=" + rightMargin + " indent=" + indentation + " spacing=" + lineSpacing + " alignment=" + alignment + " flags=" + Integer.toBinaryString(flags) + " " + textColor);
    }

    public SWFText tagDefineText(int id, Rect bounds, Matrix matrix) throws IOException {
        this.println("text id=" + id + " " + bounds + " " + matrix);
        return this;
    }

    public SWFText tagDefineText2(int id, Rect bounds, Matrix matrix) throws IOException {
        this.println("text2 id=" + id + " " + bounds + " " + matrix);
        return this;
    }

    public SWFActions tagDefineButton(int id, List buttonRecords) throws IOException {
        this.println("button id=" + id);
        Iterator iterator = buttonRecords.iterator();
        while (iterator.hasNext()) {
            ButtonRecord rec = (ButtonRecord)iterator.next();
            this.println("  " + rec);
        }
        this.println("  actions:");
        if (this.decompileActions) {
            return new Decompiler(this.writer, 1 + this.indent.length() / 4);
        }
        ActionTextWriter acts = new ActionTextWriter(this.writer);
        acts.indent = "    " + this.indent;
        return acts;
    }

    public void tagButtonCXForm(int buttonId, ColorTransform transform) throws IOException {
        this.println("button-cxform id=" + buttonId + "  " + transform);
    }

    public SWFActions tagDefineButton2(int id, boolean trackAsMenu, List buttonRecord2s) throws IOException {
        this.println("button2 id=" + id + " track-as-menu=" + trackAsMenu);
        Iterator iterator = buttonRecord2s.iterator();
        while (iterator.hasNext()) {
            ButtonRecord2 rec = (ButtonRecord2)iterator.next();
            this.println("  " + rec);
        }
        this.println("  actions:");
        if (this.decompileActions) {
            return new Decompiler(this.writer, 1 + this.indent.length() / 4);
        }
        ActionTextWriter acts = new ActionTextWriter(this.writer);
        acts.indent = "    " + this.indent;
        return acts;
    }

    public void tagExport(String[] names, int[] ids) throws IOException {
        this.println("export");
        int i = 0;
        while (i < names.length && i < ids.length) {
            this.println("  id=" + ids[i] + " name=" + names[i]);
            ++i;
        }
    }

    public void tagImport(String movieName, String[] names, int[] ids) throws IOException {
        this.println("import library-movie=" + movieName);
        int i = 0;
        while (i < names.length && i < ids.length) {
            this.println("  id=" + ids[i] + " name=" + names[i]);
            ++i;
        }
    }

    public void tagDefineQuickTimeMovie(int id, String filename) throws IOException {
        this.println("quicktime-movie id=" + id + " name=" + filename);
    }

    public void tagDefineBitsJPEG2(int id, byte[] data) throws IOException {
        this.println("jpeg2 id=" + id);
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, String.valueOf(this.indent) + "    ", false);
            this.println(this.dashes);
        }
    }

    public void tagDefineBitsJPEG2(int id, InputStream jpegImage) throws IOException {
        this.println("jpeg2 id=" + id + " (from input stream)");
    }

    public SWFShape tagDefineMorphShape(int id, Rect startBounds, Rect endBounds) throws IOException {
        this.println("morph-shape id=" + id + " start: " + startBounds + "  end: " + endBounds);
        return this;
    }

    public void tagDefineBitsLossless(int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        this.dumpBitsLossless("bits-lossless", id, format, width, height, colors, imageData);
    }

    public void tagDefineBitsLossless2(int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        this.dumpBitsLossless("bits-lossless2", id, format, width, height, colors, imageData);
    }

    public void dumpBitsLossless(String name, int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        int size = 0;
        if (format == 3) {
            size = 8;
        } else if (format == 4) {
            size = 16;
        } else if (format == 5) {
            size = 32;
        }
        this.println(String.valueOf(name) + " id=" + id + " bits=" + size + " width=" + width + " height=" + height);
        if (this.dumpHex) {
            int i = 0;
            while (i < colors.length) {
                this.println("    " + i + ": " + colors[i]);
                ++i;
            }
            Hex.dump(this.writer, imageData, 0L, String.valueOf(this.indent) + "    ", false);
            this.println(this.dashes);
        }
    }

    public void done() throws IOException {
        this.println("    " + this.dashes);
    }

    public void line(int dx, int dy) throws IOException {
        this.println("    line  " + dx + "," + dy);
    }

    public void curve(int cx, int cy, int dx, int dy) throws IOException {
        this.println("    curve " + cx + "," + cy + " - " + dx + "," + dy);
    }

    public void move(int x, int y) throws IOException {
        this.println("    move  " + x + "," + y);
    }

    public void setFillStyle0(int styleIndex) throws IOException {
        this.println("    fill0 = " + styleIndex);
    }

    public void setFillStyle1(int styleIndex) throws IOException {
        this.println("    fill1 = " + styleIndex);
    }

    public void setLineStyle(int styleIndex) throws IOException {
        this.println("    line  = " + styleIndex);
    }

    public void defineFillStyle(Color color) throws IOException {
        this.println("    fill " + color);
    }

    public void defineFillStyle(Matrix matrix, int[] ratios, Color[] colors, boolean radial) throws IOException {
        this.println("    fill radial=" + radial + "  " + matrix);
        int i = 0;
        while (i < ratios.length && i < colors.length) {
            if (colors[i] != null) {
                this.println("         ratio=" + ratios[i] + " " + colors[i]);
            }
            ++i;
        }
    }

    public void defineFillStyle(int bitmapId, Matrix matrix, boolean clipped) throws IOException {
        this.println("    fill clipped=" + clipped + " image=" + bitmapId + " " + matrix);
    }

    public void defineLineStyle(int width, Color color) throws IOException {
        this.println("    line-style width=" + width + "  " + color);
    }

    public void font(int fontId, int textHeight) throws IOException {
        this.println("    font id=" + fontId + " size=" + textHeight);
    }

    public void color(Color color) throws IOException {
        this.println("    color " + color);
    }

    public void setX(int x) throws IOException {
        this.println("    x = " + x);
    }

    public void setY(int y) throws IOException {
        this.println("    y = " + y);
    }

    public void text(int[] glyphIndices, int[] glyphAdvances) throws IOException {
        StringBuffer buff1 = new StringBuffer();
        StringBuffer buff2 = new StringBuffer();
        buff1.append("(");
        buff2.append("(");
        int i = 0;
        while (i < glyphIndices.length && i < glyphAdvances.length) {
            buff1.append(" ");
            buff2.append(" ");
            buff1.append(glyphIndices[i]);
            buff2.append(glyphAdvances[i]);
            ++i;
        }
        buff1.append(" )");
        buff2.append(" )");
        this.println("    text");
        this.println("        glyph indices = " + buff1);
        this.println("        advances      = " + buff2);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public static void main(String[] args) throws IOException {
        SWFTagDumper dumper = new SWFTagDumper(args.length > 1, args.length > 2);
        FileInputStream in = new FileInputStream(args[0]);
        TagParser tagparser = new TagParser(dumper);
        SWFReader reader = new SWFReader((SWFTags)tagparser, in);
        reader.readFile();
        dumper.flush();
        in.close();
    }
}

