/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import pt.tumba.parser.swf.OutStream;
import pt.tumba.parser.swf.Rect;
import pt.tumba.parser.swf.SWFTags;

public class SWFWriter
implements SWFTags {
    protected OutStream out;
    protected OutputStream outputstream;
    protected ByteArrayOutputStream byteout;
    protected String filename;
    protected int frameCount;
    protected int version;
    protected Rect frameSize;
    protected int height;
    protected int rate;

    public SWFWriter(String filename) throws FileNotFoundException {
        this(new FileOutputStream(filename));
        this.filename = filename;
    }

    public SWFWriter(OutputStream outputstream) {
        this.outputstream = outputstream;
        this.out = new OutStream(outputstream);
    }

    public SWFWriter(OutStream outstream) {
        this.out = outstream;
    }

    public void header(int version, long length2, int twipsWidth, int twipsHeight, int frameRate, int frameCount2) throws IOException {
        int frameCount = frameCount2;
        long length = length2;
        this.frameSize = new Rect(0, 0, twipsWidth, twipsHeight);
        if (length < 0L || frameCount < 0) {
            this.version = version;
            this.rate = frameRate;
            this.frameCount = 0;
            if (this.filename != null) {
                length = 0L;
                frameCount = 0;
            } else {
                if (this.byteout == null) {
                    this.byteout = new ByteArrayOutputStream(20000);
                    this.out = new OutStream(this.byteout);
                }
                return;
            }
        }
        this.writeHeader(version, length, frameRate, frameCount);
    }

    public void tag(int tagType, boolean longTag2, byte[] contents) throws IOException {
        boolean longTag = longTag2;
        int length = contents != null ? contents.length : 0;
        longTag = length > 62 || longTag;
        int hdr = (tagType << 6) + (longTag ? 63 : length);
        this.out.writeUI16(hdr);
        if (longTag) {
            this.out.writeUI32(length);
        }
        if (contents != null) {
            this.out.write(contents);
        }
        if (tagType == 1) {
            ++this.frameCount;
        }
        if (tagType == 0) {
            this.finish();
        }
    }

    protected void writeHeader(int version, long length, int frameRate, int frameCount) throws IOException {
        this.out.write(new byte[]{70, 87, 83});
        this.out.writeUI8(version);
        this.out.writeUI32(length);
        this.frameSize.write(this.out);
        this.out.writeUI16(frameRate << 8);
        this.out.writeUI16(frameCount);
    }

    protected void finish() throws IOException {
        this.out.flush();
        if (this.filename != null) {
            this.outputstream.close();
            RandomAccessFile raf = new RandomAccessFile(this.filename, "rw");
            int length = (int)raf.length();
            this.byteout = new ByteArrayOutputStream();
            this.out = new OutStream(this.byteout);
            this.writeHeader(this.version, length, this.rate, this.frameCount);
            this.out.flush();
            raf.write(this.byteout.toByteArray());
            raf.close();
            return;
        }
        if (this.byteout != null) {
            byte[] bytes = this.byteout.toByteArray();
            long length = 12L + this.frameSize.getLength() + (long)bytes.length;
            this.out = new OutStream(this.outputstream);
            this.writeHeader(this.version, length, this.rate, this.frameCount);
            this.out.write(bytes);
            this.out.flush();
        }
    }
}

