/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SaxHandlerBase
extends DefaultHandler {
    protected Map elementTypes = new HashMap();
    protected ElementType elemType;
    protected List elems = new ArrayList();
    protected boolean gatherMode = false;
    protected List gatherBuffer;
    protected GatheringElementType gatheringElement;

    public void startGatherMode(GatheringElementType elem) {
        this.gatheringElement = elem;
        this.gatherBuffer = new ArrayList();
        this.gatherMode = true;
    }

    public void endGatherMode() throws Exception {
        this.gatherMode = false;
        this.gatheringElement = null;
        Iterator it = this.gatherBuffer.iterator();
        while (it.hasNext()) {
            Object[] elem = (Object[])it.next();
            ElementType type = (ElementType)elem[0];
            if (type == null) continue;
            if (elem[1] == null) {
                type.endElement();
                continue;
            }
            if (elem[1] instanceof String) {
                String charstring = (String)elem[1];
                char[] chars = charstring.toCharArray();
                type.characters(chars, 0, chars.length);
                continue;
            }
            Attributes atts = (Attributes)elem[1];
            type.startElement(atts);
        }
        this.gatherBuffer = null;
    }

    public void dispatchAllMatchingGatheredElements(String elemName) throws Exception {
        ElementType dispelem = (ElementType)this.elementTypes.get(elemName);
        if (dispelem == null) {
            return;
        }
        boolean found = false;
        Iterator it = this.gatherBuffer.iterator();
        while (it.hasNext()) {
            Object[] elem = (Object[])it.next();
            ElementType type = (ElementType)elem[0];
            if (type == null) continue;
            if (type == dispelem) {
                found = true;
            }
            if (!found) continue;
            it.remove();
            if (elem[1] == null) {
                type.endElement();
                if (type != dispelem) continue;
                found = false;
                continue;
            }
            if (elem[1] instanceof String) {
                String charstring = (String)elem[1];
                char[] chars = charstring.toCharArray();
                type.characters(chars, 0, chars.length);
                continue;
            }
            Attributes atts = (Attributes)elem[1];
            type.startElement(atts);
        }
    }

    public void dispatchGatheredElement(String elemName) throws Exception {
        ElementType dispelem = (ElementType)this.elementTypes.get(elemName);
        if (dispelem == null) {
            return;
        }
        boolean found = false;
        Iterator it = this.gatherBuffer.iterator();
        while (it.hasNext()) {
            Object[] elem = (Object[])it.next();
            ElementType type = (ElementType)elem[0];
            if (type == null) continue;
            if (type == dispelem) {
                found = true;
            }
            if (!found) continue;
            it.remove();
            if (elem[1] == null) {
                type.endElement();
                if (type != dispelem) continue;
                return;
            }
            if (elem[1] instanceof String) {
                String charstring = (String)elem[1];
                char[] chars = charstring.toCharArray();
                type.characters(chars, 0, chars.length);
                continue;
            }
            Attributes atts = (Attributes)elem[1];
            type.startElement(atts);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.elemType = (ElementType)this.elementTypes.get(localName);
            if (this.gatherMode) {
                if (this.gatheringElement.gatherElement(localName, atts)) {
                    this.gatherBuffer.add(new Object[]{this.elemType, new AttributesImpl(atts)});
                }
            } else {
                if (this.elemType == null) {
                    return;
                }
                this.elemType.startElement(atts);
            }
            this.elems.add(this.elemType);
        }
        catch (SAXException saxex) {
            throw saxex;
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            this.elemType = (ElementType)this.elementTypes.get(localName);
            if (this.elemType == null) {
                return;
            }
            if (this.elemType == this.gatheringElement) {
                this.gatherMode = false;
            }
            if (this.gatherMode) {
                Object[] objectArray = new Object[2];
                objectArray[0] = this.elemType;
                this.gatherBuffer.add(objectArray);
            } else {
                this.elemType.endElement();
            }
            this.elemType = !this.elems.isEmpty() ? (ElementType)this.elems.remove(this.elems.size() - 1) : null;
        }
        catch (SAXException saxex) {
            throw saxex;
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.elemType == null) {
                return;
            }
            if (this.gatherMode) {
                this.gatherBuffer.add(new Object[]{this.elemType, new String(ch, start, length)});
            } else {
                this.elemType.characters(ch, start, length);
            }
        }
        catch (SAXException saxex) {
            throw saxex;
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    public static String getAttr(Attributes attrs, String name, String defaultValue) {
        String value = attrs.getValue("", name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static int getAttrInt(Attributes attrs, String name, int defaultValue) {
        String value = attrs.getValue("", name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static double getAttrDouble(Attributes attrs, String name, double defaultValue) {
        String value = attrs.getValue("", name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static boolean getAttrBool(Attributes attrs, String name, boolean defaultValue) {
        String value = attrs.getValue("", name);
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("yes")) {
            return true;
        }
        return value.equalsIgnoreCase("true");
    }

    public static class ElementType {
        public void startElement(Attributes atts) throws Exception {
        }

        public void endElement() throws Exception {
        }

        public void characters(char[] ch, int start, int length) throws Exception {
        }
    }

    public static class ContentElementType
    extends ElementType {
        protected Attributes attrs;
        protected StringBuffer buff;

        public void startElement(Attributes atts) throws Exception {
            this.attrs = new AttributesImpl(atts);
            this.buff = new StringBuffer();
        }

        public void characters(char[] ch, int start, int length) throws Exception {
            this.buff.append(ch, start, length);
        }
    }

    public static class GatheringElementType
    extends ContentElementType {
        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
        }

        public boolean gatherElement(String localName, Attributes atts) {
            return true;
        }
    }
}

