/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public abstract class SaxParserBase
implements XMLReader {
    protected EntityResolver resolver;
    protected DTDHandler dtdhandler;
    protected ContentHandler contenthandler;
    protected ErrorHandler errorhandler;
    protected List elementStack = new ArrayList();
    protected String namespace;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected SaxParserBase(String namespace) {
        this.namespace = namespace;
    }

    protected void startDoc() throws IOException {
        if (this.contenthandler == null) {
            return;
        }
        try {
            this.contenthandler.startDocument();
        }
        catch (SAXException saxex) {
            throw new IOException(saxex.toString());
        }
    }

    protected void endDoc() throws IOException {
        if (this.contenthandler == null) {
            return;
        }
        try {
            this.contenthandler.endDocument();
        }
        catch (SAXException saxex) {
            throw new IOException(saxex.toString());
        }
    }

    protected void text(String text) throws IOException {
        if (this.contenthandler == null) {
            return;
        }
        try {
            this.contenthandler.characters(text.toCharArray(), 0, text.length());
        }
        catch (SAXException saxex) {
            throw new IOException(saxex.toString());
        }
    }

    protected void element(String name, String[] attributes) throws IOException {
        if (this.contenthandler == null) {
            return;
        }
        AttributesImpl attrs = new AttributesImpl();
        if (attributes != null) {
            int topIndex = attributes.length - 1;
            int i = 0;
            while (i < topIndex) {
                String attName = attributes[i];
                String value = attributes[i + 1];
                if (attName != null && value != null) {
                    attrs.addAttribute("", attName, attName, "CDATA", value);
                }
                i += 2;
            }
        }
        try {
            this.contenthandler.startElement(this.namespace, name, name, attrs);
            this.contenthandler.endElement(this.namespace, name, name);
        }
        catch (SAXException saxex) {
            throw new IOException(saxex.toString());
        }
    }

    protected void start(String name, String[] attributes) throws IOException {
        this.elementStack.add(name);
        if (this.contenthandler == null) {
            return;
        }
        AttributesImpl attrs = new AttributesImpl();
        if (attributes != null) {
            int topIndex = attributes.length - 1;
            int i = 0;
            while (i < topIndex) {
                String attName = attributes[i];
                String value = attributes[i + 1];
                if (attName != null && value != null) {
                    attrs.addAttribute("", attName, attName, "CDATA", value);
                }
                i += 2;
            }
        }
        try {
            this.contenthandler.startElement(this.namespace, name, name, attrs);
        }
        catch (SAXException saxex) {
            throw new IOException(saxex.toString());
        }
    }

    protected void end() throws IOException {
        if (this.elementStack.isEmpty()) {
            return;
        }
        if (this.contenthandler == null) {
            return;
        }
        String name = (String)this.elementStack.remove(this.elementStack.size() - 1);
        try {
            this.contenthandler.endElement(this.namespace, name, name);
        }
        catch (SAXException saxex) {
            throw new IOException(saxex.toString());
        }
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return false;
        }
        throw new SAXNotRecognizedException(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces") || name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return;
        }
        throw new SAXNotRecognizedException(name);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdhandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdhandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contenthandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contenthandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorhandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorhandler;
    }

    public abstract void parse(InputSource var1) throws IOException, SAXException;

    public abstract void parse(String var1) throws IOException, SAXException;
}

