/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import pt.tumba.parser.swf.ActionParser;
import pt.tumba.parser.swf.AlphaColor;
import pt.tumba.parser.swf.AlphaTransform;
import pt.tumba.parser.swf.ButtonRecord;
import pt.tumba.parser.swf.ButtonRecord2;
import pt.tumba.parser.swf.Color;
import pt.tumba.parser.swf.ColorTransform;
import pt.tumba.parser.swf.InStream;
import pt.tumba.parser.swf.Matrix;
import pt.tumba.parser.swf.Rect;
import pt.tumba.parser.swf.SWFActions;
import pt.tumba.parser.swf.SWFConstants;
import pt.tumba.parser.swf.SWFReader;
import pt.tumba.parser.swf.SWFShape;
import pt.tumba.parser.swf.SWFTagTypes;
import pt.tumba.parser.swf.SWFTags;
import pt.tumba.parser.swf.SWFText;
import pt.tumba.parser.swf.SWFVectors;
import pt.tumba.parser.swf.SWFWriter;
import pt.tumba.parser.swf.SoundInfo;
import pt.tumba.parser.swf.TagWriter;

public class TagParser
implements SWFTags,
SWFConstants {
    protected SWFTagTypes tagtypes;

    public TagParser(SWFTagTypes tagtypes) {
        this.tagtypes = tagtypes;
    }

    public void header(int version, long length, int twipsWidth, int twipsHeight, int frameRate, int frameCount) throws IOException {
        this.tagtypes.header(version, length, twipsWidth, twipsHeight, frameRate, frameCount);
    }

    public void tag(int tagType, boolean longTag, byte[] contents) throws IOException {
        int length = contents != null ? contents.length : 0;
        InStream in = length > 0 ? new InStream(contents) : null;
        switch (tagType) {
            case 0: {
                this.tagtypes.tagEnd();
                break;
            }
            case 1: {
                this.tagtypes.tagShowFrame();
                break;
            }
            case 2: 
            case 22: 
            case 32: {
                this.parseDefineShape(tagType, in);
                break;
            }
            case 12: {
                this.parseDoAction(in);
                break;
            }
            case 3: {
                this.tagtypes.tagFreeCharacter(in.readUI16());
                break;
            }
            case 4: {
                this.parsePlaceObject(in, length);
                break;
            }
            case 26: {
                this.parsePlaceObject2(in);
                break;
            }
            case 5: {
                this.tagtypes.tagRemoveObject(in.readUI16(), in.readUI16());
                break;
            }
            case 28: {
                this.tagtypes.tagRemoveObject2(in.readUI16());
                break;
            }
            case 9: {
                this.tagtypes.tagSetBackgroundColor(new Color(in));
                break;
            }
            case 43: {
                this.tagtypes.tagFrameLabel(in.readString());
                break;
            }
            case 39: {
                this.parseDefineSprite(in);
                break;
            }
            case 24: {
                this.tagtypes.tagProtect(length > 0 ? in.read(length) : null);
                break;
            }
            case 58: {
                this.tagtypes.tagEnableDebug(length > 0 ? in.read(length) : null);
                break;
            }
            case 10: {
                this.parseDefineFont(in);
                break;
            }
            case 13: {
                this.parseFontInfo(in, length);
                break;
            }
            case 48: {
                this.parseDefineFont2(in);
                break;
            }
            case 37: {
                this.parseDefineTextField(in);
                break;
            }
            case 11: 
            case 33: {
                this.parseDefineText(tagType, in);
                break;
            }
            case 7: {
                this.parseDefineButton(in);
                break;
            }
            case 34: {
                this.parseDefineButton2(in);
                break;
            }
            case 23: {
                this.parseButtonCXForm(in);
                break;
            }
            case 56: {
                this.parseExport(in);
                break;
            }
            case 57: {
                this.parseImport(in);
                break;
            }
            case 38: {
                this.tagtypes.tagDefineQuickTimeMovie(in.readUI16(), in.readString());
                break;
            }
            case 21: {
                this.parseDefineJPEG2(in, length);
                break;
            }
            case 20: {
                this.parseDefineBitsLossless(in, length, false);
                break;
            }
            case 36: {
                this.parseDefineBitsLossless(in, length, true);
                break;
            }
            case 46: {
                this.parseMorphShape(in);
                break;
            }
            case 40: {
                this.tagtypes.tagNameCharacter(contents);
                break;
            }
            case 42: {
                this.tagtypes.tagGeneratorText(contents);
                break;
            }
            case 49: {
                this.tagtypes.tagGeneratorCommand(contents);
                break;
            }
            case 51: {
                this.tagtypes.tagGenerator(contents);
                break;
            }
            case 52: {
                this.tagtypes.tagGeneratorFont(contents);
                break;
            }
            case 41: {
                this.tagtypes.tagSerialNumber(in.readString());
                break;
            }
            case 14: {
                this.parseDefineSound(in);
                break;
            }
            case 15: {
                this.parseStartSound(in);
                break;
            }
            case 17: {
                this.parseDefineButtonSound(in);
                break;
            }
            case 18: {
                this.parseSoundStreamHead(true, in);
                break;
            }
            case 45: {
                this.parseSoundStreamHead(false, in);
                break;
            }
            case 19: {
                this.parseSoundStreamBlock(in);
                break;
            }
            case 6: {
                this.parseDefineBits(in);
                break;
            }
            case 8: {
                this.parseDefineJPEGTables(in);
                break;
            }
            case 35: {
                this.parseDefineBitsJPEG3(in);
                break;
            }
            default: {
                this.tagtypes.tag(tagType, longTag, contents);
            }
        }
    }

    protected void parseDefineSound(InStream in) throws IOException {
        int id = in.readUI16();
        int format = (int)in.readUBits(4);
        int frequency = (int)in.readUBits(2);
        boolean bits16 = in.readUBits(1) != 0L;
        boolean stereo = in.readUBits(1) != 0L;
        int sampleCount = (int)in.readUI32();
        byte[] soundData = in.read();
        this.tagtypes.tagDefineSound(id, format, frequency, bits16, stereo, sampleCount, soundData);
    }

    protected void parseStartSound(InStream in) throws IOException {
        int id = in.readUI16();
        SoundInfo info = new SoundInfo(in);
        this.tagtypes.tagStartSound(id, info);
    }

    protected void parseDefineButtonSound(InStream in) throws IOException {
        int id = in.readUI16();
        int rollOverSoundId = in.readUI16();
        SoundInfo rollOverSoundInfo = rollOverSoundId == 0 ? null : new SoundInfo(in);
        int rollOutSoundId = in.readUI16();
        SoundInfo rollOutSoundInfo = rollOutSoundId == 0 ? null : new SoundInfo(in);
        int pressSoundId = in.readUI16();
        SoundInfo pressSoundInfo = pressSoundId == 0 ? null : new SoundInfo(in);
        int releaseSoundId = in.readUI16();
        SoundInfo releaseSoundInfo = releaseSoundId == 0 ? null : new SoundInfo(in);
        this.tagtypes.tagDefineButtonSound(id, rollOverSoundId, rollOverSoundInfo, rollOutSoundId, rollOutSoundInfo, pressSoundId, pressSoundInfo, releaseSoundId, releaseSoundInfo);
    }

    protected void parseSoundStreamHead(boolean adpcmOnly, InStream in) throws IOException {
        int playbackFreq = (int)in.readUBits(2);
        boolean playback16bits = in.readUBits(1) != 0L;
        boolean playbackStereo = in.readUBits(1) != 0L;
        int format = (int)in.readUBits(4);
        int streamFreq = (int)in.readUBits(2);
        boolean stream16bits = in.readUBits(1) != 0L;
        boolean streamStereo = in.readUBits(1) != 0L;
        int avgSampleCount = in.readUI16();
        if (adpcmOnly) {
            this.tagtypes.tagSoundStreamHead(playbackFreq, playback16bits, playbackStereo, format, streamFreq, stream16bits, streamStereo, avgSampleCount);
        } else {
            this.tagtypes.tagSoundStreamHead2(playbackFreq, playback16bits, playbackStereo, format, streamFreq, stream16bits, streamStereo, avgSampleCount);
        }
    }

    protected void parseSoundStreamBlock(InStream in) throws IOException {
        this.tagtypes.tagSoundStreamBlock(in.read());
    }

    protected void parseDefineBits(InStream in) throws IOException {
        this.tagtypes.tagDefineBits(in.readUI16(), in.read());
    }

    protected void parseDefineJPEGTables(InStream in) throws IOException {
        this.tagtypes.tagJPEGTables(in.read());
    }

    protected void parseDefineBitsJPEG3(InStream in) throws IOException {
        int id = in.readUI16();
        int size = (int)in.readUI32();
        byte[] imageData = in.read(size);
        byte[] alphaData = in.read();
        this.tagtypes.tagDefineBitsJPEG3(id, imageData, alphaData);
    }

    protected void parseMorphShape(InStream in) throws IOException {
        Rect endBounds;
        Rect startBounds;
        int id = in.readUI16();
        SWFShape shape = this.tagtypes.tagDefineMorphShape(id, startBounds = new Rect(in), endBounds = new Rect(in));
        if (shape == null) {
            return;
        }
        int fillCount = in.readUI8();
        if (fillCount == 255) {
            fillCount = in.readUI16();
        }
        int i = 0;
        while (i < fillCount) {
            this.parseMorphFillStyle(in, shape);
            ++i;
        }
        int lineCount = in.readUI8();
        if (lineCount == 255) {
            lineCount = in.readUI16();
        }
        int i2 = 0;
        while (i2 < lineCount) {
            this.parseMorphLineStyle(in, shape);
            ++i2;
        }
        this.parseShape(in, shape, false, true);
        this.parseShape(in, shape, false, true);
    }

    protected void parseMorphLineStyle(InStream in, SWFShape shape) throws IOException {
        int startWidth = in.readUI16();
        int endWidth = in.readUI16();
        AlphaColor startColor = new AlphaColor(in);
        AlphaColor endColor = new AlphaColor(in);
        shape.defineLineStyle(startWidth, startColor);
        shape.defineLineStyle(endWidth, endColor);
    }

    protected void parseMorphFillStyle(InStream in, SWFShape shape) throws IOException {
        int fillType = in.readUI8();
        if (fillType == 0) {
            AlphaColor startColor = new AlphaColor(in);
            AlphaColor endColor = new AlphaColor(in);
            shape.defineFillStyle(startColor);
            shape.defineFillStyle(endColor);
        } else if (fillType == 16 || fillType == 18) {
            Matrix startMatrix = new Matrix(in);
            Matrix endMatrix = new Matrix(in);
            int numRatios = in.readUI8();
            int[] startRatios = new int[numRatios];
            Color[] startColors = new AlphaColor[numRatios];
            int[] endRatios = new int[numRatios];
            Color[] endColors = new AlphaColor[numRatios];
            int i = 0;
            while (i < numRatios) {
                startRatios[i] = in.readUI8();
                startColors[i] = new AlphaColor(in);
                endRatios[i] = in.readUI8();
                endColors[i] = new AlphaColor(in);
                ++i;
            }
            shape.defineFillStyle(startMatrix, startRatios, startColors, fillType == 18);
            shape.defineFillStyle(endMatrix, endRatios, endColors, fillType == 18);
        } else if (fillType == 64 || fillType == 65) {
            int bitmapId = in.readUI16();
            Matrix startMatrix = new Matrix(in);
            Matrix endMatrix = new Matrix(in);
            shape.defineFillStyle(bitmapId, startMatrix, fillType == 65);
            shape.defineFillStyle(bitmapId, endMatrix, fillType == 65);
        }
    }

    protected void parseDefineJPEG2(InStream in, int length) throws IOException {
        int id = in.readUI16();
        byte[] image = in.read(length - 2);
        this.tagtypes.tagDefineBitsJPEG2(id, image);
    }

    protected void parseDefineBitsLossless(InStream in, int length, boolean hasAlpha) throws IOException {
        int id = in.readUI16();
        int format = in.readUI8();
        int width = in.readUI16();
        int height = in.readUI16();
        int size = 0;
        switch (format) {
            case 3: {
                size = in.readUI8() + 1;
                break;
            }
            case 4: {
                size = in.readUI16() + 1;
                break;
            }
            case 5: {
                size = 0;
                break;
            }
            default: {
                throw new IOException("unknown bitmap format: " + format);
            }
        }
        byte[] data = in.read(length - (int)in.getBytesRead());
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        InflaterInputStream inflater = new InflaterInputStream(bin);
        InStream dataIn = new InStream(inflater);
        Color[] colors = hasAlpha ? new AlphaColor[size] : new Color[size];
        int i = 0;
        while (i < size) {
            colors[i] = hasAlpha ? new AlphaColor(dataIn) : new Color(dataIn);
            ++i;
        }
        byte[] imageData = dataIn.read();
        if (hasAlpha) {
            this.tagtypes.tagDefineBitsLossless2(id, format, width, height, (AlphaColor[])colors, imageData);
        } else {
            this.tagtypes.tagDefineBitsLossless(id, format, width, height, colors, imageData);
        }
    }

    protected void parseExport(InStream in) throws IOException {
        int count = in.readUI16();
        String[] exportNames = new String[count];
        int[] exportIds = new int[count];
        int i = 0;
        while (i < count) {
            exportIds[i] = in.readUI16();
            exportNames[i] = in.readString();
            ++i;
        }
        this.tagtypes.tagExport(exportNames, exportIds);
    }

    protected void parseImport(InStream in) throws IOException {
        String movieName = in.readString();
        int count = in.readUI16();
        String[] importNames = new String[count];
        int[] importIds = new int[count];
        int i = 0;
        while (i < count) {
            importIds[i] = in.readUI16();
            importNames[i] = in.readString();
            ++i;
        }
        this.tagtypes.tagImport(movieName, importNames, importIds);
    }

    /*
     * Unable to fully structure code
     */
    protected void parseDefineButton2(InStream in) throws IOException {
        id = in.readUI16();
        trackAsMenu = in.readUI8() != 0;
        actionOffset = in.readUI16();
        buttonRecords = ButtonRecord2.read(in);
        actions = this.tagtypes.tagDefineButton2(id, trackAsMenu, buttonRecords);
        if (actions != null) ** GOTO lbl13
        return;
lbl-1000:
        // 1 sources

        {
            actionOffset = in.readUI16();
            actionConditions = in.readUI16();
            actions.start(actionConditions);
            parser = new ActionParser(actions);
            parser.parse(in);
lbl13:
            // 2 sources

            ** while (actionOffset != 0)
        }
lbl14:
        // 1 sources

        actions.done();
    }

    protected void parseButtonCXForm(InStream in) throws IOException {
        int buttonId = in.readUI16();
        ColorTransform transform = new ColorTransform(in);
        this.tagtypes.tagButtonCXForm(buttonId, transform);
    }

    protected void parseDefineButton(InStream in) throws IOException {
        List buttonRecords;
        int id = in.readUI16();
        SWFActions actions = this.tagtypes.tagDefineButton(id, buttonRecords = ButtonRecord.read(in));
        if (actions == null) {
            return;
        }
        actions.start(0);
        ActionParser parser = new ActionParser(actions);
        parser.parse(in);
        actions.done();
    }

    protected void parseDefineText(int type, InStream in) throws IOException {
        int firstByte;
        SWFText text;
        int id = in.readUI16();
        Rect bounds = new Rect(in);
        Matrix matrix = new Matrix(in);
        SWFText sWFText = text = type == 11 ? this.tagtypes.tagDefineText(id, bounds, matrix) : this.tagtypes.tagDefineText2(id, bounds, matrix);
        if (text == null) {
            return;
        }
        int glyphBits = in.readUI8();
        int advanceBits = in.readUI8();
        while ((firstByte = in.readUI8()) != 0) {
            if ((firstByte & 0x80) == 0) {
                int glyphCount = firstByte & 0x7F;
                int[] glyphs = new int[glyphCount];
                int[] advances = new int[glyphCount];
                int i = 0;
                while (i < glyphCount) {
                    glyphs[i] = (int)in.readUBits(glyphBits);
                    advances[i] = in.readSBits(advanceBits);
                    ++i;
                }
                text.text(glyphs, advances);
                continue;
            }
            int flags = firstByte;
            int fontId = 0;
            if ((flags & 8) != 0) {
                fontId = in.readUI16();
            }
            if ((flags & 4) != 0) {
                text.color(type == 33 ? new AlphaColor(in) : new Color(in));
            }
            if ((flags & 1) != 0) {
                text.setX(in.readSI16());
            }
            if ((flags & 2) != 0) {
                text.setY(in.readSI16());
            }
            if ((flags & 8) == 0) continue;
            int textHeight = in.readUI16();
            text.font(fontId, textHeight);
        }
        text.done();
    }

    protected void parseDefineTextField(InStream in) throws IOException {
        int id = in.readUI16();
        Rect boundary = new Rect(in);
        int flags = in.readUI16();
        int fontId = in.readUI16();
        int fontSize = in.readUI16();
        AlphaColor textColor = new AlphaColor(in);
        int charLimit = (flags & 2) != 0 ? in.readUI16() : 0;
        int alignment = in.readUI8();
        int leftMargin = in.readUI16();
        int rightMargin = in.readUI16();
        int indentation = in.readUI16();
        int lineSpacing = in.readUI16();
        String fieldName = in.readString();
        String initialText = (flags & 0x80) != 0 ? in.readString() : null;
        this.tagtypes.tagDefineTextField(id, fieldName, initialText, boundary, flags, textColor, alignment, fontId, fontSize, charLimit, leftMargin, rightMargin, indentation, lineSpacing);
    }

    protected void parseDefineFont2(InStream in) throws IOException {
        SWFVectors vectors;
        int id = in.readUI16();
        int flags = in.readUI8();
        int nameLength = in.readUI8();
        String name = new String(in.read(nameLength));
        int glyphCount = in.readUI16();
        Vector<byte[]> glyphs = new Vector<byte[]>();
        int[] offsets = new int[glyphCount + 1];
        boolean is32 = (flags & 8) != 0;
        int i = 0;
        while (i <= glyphCount) {
            offsets[i] = is32 ? (int)in.readUI32() : in.readUI16();
            ++i;
        }
        i = 1;
        while (i <= glyphCount) {
            int glyphSize = offsets[i] - offsets[i - 1];
            byte[] glyphBytes = in.read(glyphSize);
            glyphs.addElement(glyphBytes);
            ++i;
        }
        boolean isWide = (flags & 4) != 0 || glyphCount > 256;
        int[] codes = new int[glyphCount];
        int i2 = 0;
        while (i2 < glyphCount) {
            codes[i2] = isWide ? in.readUI16() : in.readUI8();
            ++i2;
        }
        short ascent = 0;
        short descent = 0;
        short leading = 0;
        int[] advances = null;
        Rect[] bounds = null;
        int[] kerningCodes1 = null;
        int[] kerningCodes2 = null;
        int[] kerningAdjustments = null;
        if ((flags & 0x80) != 0) {
            ascent = in.readSI16();
            descent = in.readSI16();
            leading = in.readSI16();
            advances = new int[glyphCount];
            int i3 = 0;
            while (i3 < glyphCount) {
                advances[i3] = in.readSI16();
                ++i3;
            }
            bounds = new Rect[glyphCount];
            i3 = 0;
            while (i3 < glyphCount) {
                bounds[i3] = new Rect(in);
                ++i3;
            }
            int kerningCount = in.readUI16();
            kerningCodes1 = new int[kerningCount];
            kerningCodes2 = new int[kerningCount];
            kerningAdjustments = new int[kerningCount];
            int i4 = 0;
            while (i4 < kerningCount) {
                kerningCodes1[i4] = isWide ? in.readUI16() : in.readUI8();
                kerningCodes2[i4] = isWide ? in.readUI16() : in.readUI8();
                kerningAdjustments[i4] = in.readSI16();
                ++i4;
            }
        }
        if ((vectors = this.tagtypes.tagDefineFont2(id, flags, name, glyphCount, ascent, descent, leading, codes, advances, bounds, kerningCodes1, kerningCodes2, kerningAdjustments)) == null) {
            return;
        }
        if (glyphs.isEmpty()) {
            vectors.done();
        } else {
            Enumeration enumeration = glyphs.elements();
            while (enumeration.hasMoreElements()) {
                byte[] glyphBytes = (byte[])enumeration.nextElement();
                InStream glyphIn = new InStream(glyphBytes);
                this.parseShape(glyphIn, vectors, false, false);
            }
        }
    }

    protected void parseFontInfo(InStream in, int length2) throws IOException {
        int fontId = in.readUI16();
        int length = length2;
        int nameLength = in.readUI8();
        byte[] chars = in.read(nameLength);
        String fontName = new String(chars);
        int flags = in.readUI8();
        boolean wide = (flags & 1) != 0;
        int[] codes = new int[wide ? length / 2 : (length -= 4 + nameLength)];
        int i = 0;
        while (i < codes.length) {
            codes[i] = wide ? in.readUI16() : in.readUI8();
            ++i;
        }
        this.tagtypes.tagDefineFontInfo(fontId, fontName, flags, codes);
    }

    protected void parseDefineFont(InStream in) throws IOException {
        int firstOffset;
        int numGlyphs;
        int id = in.readUI16();
        SWFVectors vectors = this.tagtypes.tagDefineFont(id, numGlyphs = (firstOffset = in.readUI16()) / 2);
        if (vectors == null) {
            return;
        }
        int i = 1;
        while (i < numGlyphs) {
            in.readUI16();
            ++i;
        }
        i = 0;
        while (i < numGlyphs) {
            this.parseShape(in, vectors, false, false);
            ++i;
        }
    }

    protected void parseDefineSprite(InStream in) throws IOException {
        int id = in.readUI16();
        SWFTagTypes sstt = this.tagtypes.tagDefineSprite(id);
        if (sstt == null) {
            return;
        }
        TagParser parser = new TagParser(sstt);
        SWFReader reader = new SWFReader((SWFTags)parser, in);
        reader.readTags();
    }

    protected void parsePlaceObject2(InStream in) throws IOException {
        boolean hasClipActions = in.readUBits(1) != 0L;
        boolean isClipBracket = in.readUBits(1) != 0L;
        boolean hasName = in.readUBits(1) != 0L;
        boolean hasRatio = in.readUBits(1) != 0L;
        boolean hasColorTransform = in.readUBits(1) != 0L;
        boolean hasMatrix = in.readUBits(1) != 0L;
        boolean hasCharacter = in.readUBits(1) != 0L;
        boolean isMove = in.readUBits(1) != 0L;
        int depth = in.readUI16();
        int charId = hasCharacter ? in.readUI16() : 0;
        Matrix matrix = hasMatrix ? new Matrix(in) : null;
        AlphaTransform cxform = hasColorTransform ? new AlphaTransform(in) : null;
        int ratio = hasRatio ? in.readUI16() : -1;
        int clipDepth = isClipBracket ? in.readUI16() : 0;
        String name = hasName ? in.readString() : null;
        int clipActionFlags = 0;
        if (hasClipActions) {
            in.readUI16();
            clipActionFlags = in.readUI16();
        }
        SWFActions actions = this.tagtypes.tagPlaceObject2(isMove, clipDepth, depth, charId, matrix, cxform, ratio, name, clipActionFlags);
        if (hasClipActions && actions != null) {
            int flags = 0;
            while ((flags = in.readUI16()) != 0) {
                actions.start(flags);
                ActionParser parser = new ActionParser(actions);
                parser.parse(in);
            }
            actions.done();
        }
    }

    protected void parsePlaceObject(InStream in, int length) throws IOException {
        this.tagtypes.tagPlaceObject(in.readUI16(), in.readUI16(), new Matrix(in), in.getBytesRead() < (long)length ? new AlphaTransform(in) : null);
    }

    protected void parseDoAction(InStream in) throws IOException {
        SWFActions actions = this.tagtypes.tagDoAction();
        if (actions == null) {
            return;
        }
        actions.start(0);
        ActionParser parser = new ActionParser(actions);
        parser.parse(in);
        actions.done();
    }

    protected void parseDefineShape(int type, InStream in) throws IOException {
        int id = in.readUI16();
        Rect rect = new Rect(in);
        SWFShape shape = null;
        switch (type) {
            case 2: {
                shape = this.tagtypes.tagDefineShape(id, rect);
                break;
            }
            case 22: {
                shape = this.tagtypes.tagDefineShape2(id, rect);
                break;
            }
            case 32: {
                shape = this.tagtypes.tagDefineShape3(id, rect);
                break;
            }
        }
        if (shape == null) {
            return;
        }
        this.parseShape(in, shape, true, type == 32);
    }

    protected void parseShape(InStream in, SWFVectors vectors, boolean hasStyle, boolean hasAlpha) throws IOException {
        SWFShape shape = vectors instanceof SWFShape ? (SWFShape)vectors : null;
        in.synchBits();
        if (hasStyle) {
            this.parseStyles(in, shape, hasAlpha);
        }
        in.synchBits();
        int[] numFillBits = new int[]{(int)in.readUBits(4)};
        int[] numLineBits = new int[]{(int)in.readUBits(4)};
        while (true) {
            int type;
            if ((type = (int)in.readUBits(1)) == 1) {
                int numBits;
                boolean isCurved;
                boolean bl = isCurved = in.readUBits(1) == 0L;
                if (isCurved) {
                    numBits = (int)in.readUBits(4) + 2;
                    int cx = in.readSBits(numBits);
                    int cy = in.readSBits(numBits);
                    int dx = in.readSBits(numBits);
                    int dy = in.readSBits(numBits);
                    vectors.curve(cx, cy, dx, dy);
                    continue;
                }
                numBits = (int)in.readUBits(4) + 2;
                boolean generalLine = in.readUBits(1) == 1L;
                int dx = 0;
                int dy = 0;
                if (generalLine) {
                    dx = in.readSBits(numBits);
                    dy = in.readSBits(numBits);
                } else {
                    boolean vertLine;
                    boolean bl2 = vertLine = in.readUBits(1) == 1L;
                    if (vertLine) {
                        dy = in.readSBits(numBits);
                    } else {
                        dx = in.readSBits(numBits);
                    }
                }
                vectors.line(dx, dy);
                continue;
            }
            int flags = (int)in.readUBits(5);
            if (flags == 0) break;
            this.parseChangeRecord(in, flags, vectors, shape, hasAlpha, numFillBits, numLineBits);
        }
        vectors.done();
    }

    protected void parseChangeRecord(InStream in, int flags, SWFVectors vectors, SWFShape shape, boolean hasAlpha, int[] numFillBits2, int[] numLineBits2) throws IOException {
        boolean hasMoveTo;
        int[] numFillBits = numFillBits2;
        int[] numLineBits = numLineBits2;
        boolean hasNewStyles = (flags & 0x10) != 0;
        boolean hasLineStyle = (flags & 8) != 0;
        boolean hasFillStyle1 = (flags & 4) != 0;
        boolean hasFillStyle0 = (flags & 2) != 0;
        boolean bl = hasMoveTo = (flags & 1) != 0;
        if (hasMoveTo) {
            int moveBits = (int)in.readUBits(5);
            int moveX = in.readSBits(moveBits);
            int moveY = in.readSBits(moveBits);
            vectors.move(moveX, moveY);
        }
        if (hasFillStyle0) {
            int fillStyle0 = (int)in.readUBits(numFillBits[0]);
            if (shape != null) {
                shape.setFillStyle0(fillStyle0);
            }
        }
        if (hasFillStyle1) {
            int fillStyle1 = (int)in.readUBits(numFillBits[0]);
            if (shape != null) {
                shape.setFillStyle1(fillStyle1);
            }
        }
        if (hasLineStyle) {
            int lineStyle = (int)in.readUBits(numLineBits[0]);
            if (shape != null) {
                shape.setLineStyle(lineStyle);
            }
        }
        if (hasNewStyles) {
            this.parseStyles(in, shape, hasAlpha);
            numFillBits[0] = (int)in.readUBits(4);
            numLineBits[0] = (int)in.readUBits(4);
        }
    }

    protected void parseStyles(InStream in, SWFShape shape, boolean hasAlpha) throws IOException {
        int numFillStyles = in.readUI8();
        if (numFillStyles == 255) {
            numFillStyles = in.readUI16();
        }
        int i = 0;
        while (i < numFillStyles) {
            this.parseFillStyle(in, shape, hasAlpha);
            ++i;
        }
        int numLineStyles = in.readUI8();
        if (numLineStyles == 255) {
            numLineStyles = in.readUI16();
        }
        int i2 = 0;
        while (i2 < numLineStyles) {
            this.parseLineStyle(in, shape, hasAlpha);
            ++i2;
        }
    }

    public void parseLineStyle(InStream in, SWFShape shape, boolean hasAlpha) throws IOException {
        Color color;
        int width = in.readUI16();
        Color color2 = color = hasAlpha ? new AlphaColor(in) : new Color(in);
        if (shape != null) {
            shape.defineLineStyle(width, color);
        }
    }

    public void parseFillStyle(InStream in, SWFShape shape, boolean hasAlpha) throws IOException {
        int fillType = in.readUI8();
        if (fillType == 0) {
            Color color;
            Color color2 = color = hasAlpha ? new AlphaColor(in) : new Color(in);
            if (shape != null) {
                shape.defineFillStyle(color);
            }
        } else if (fillType == 16 || fillType == 18) {
            Matrix matrix = new Matrix(in);
            int numRatios = in.readUI8();
            int[] ratios = new int[numRatios];
            Color[] colors = new Color[numRatios];
            int i = 0;
            while (i < numRatios) {
                ratios[i] = in.readUI8();
                colors[i] = hasAlpha ? new AlphaColor(in) : new Color(in);
                ++i;
            }
            if (shape != null) {
                shape.defineFillStyle(matrix, ratios, colors, fillType == 18);
            }
        } else if (fillType == 64 || fillType == 65) {
            int bitmapId = in.readUI16();
            Matrix matrix = new Matrix(in);
            if (shape != null) {
                shape.defineFillStyle(bitmapId, matrix, fillType == 65);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        FileInputStream in = new FileInputStream(args[0]);
        FileOutputStream out = new FileOutputStream(args[1]);
        SWFWriter writer = new SWFWriter(out);
        TagWriter tagwtr = new TagWriter(writer);
        TagParser parser = new TagParser(tagwtr);
        SWFReader reader = new SWFReader((SWFTags)parser, in);
        reader.readFile();
        out.flush();
        out.close();
        in.close();
    }
}

