/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import pt.tumba.parser.swf.SaxHandlerBase;

public class XMLWriter
extends SaxHandlerBase {
    protected Writer out;
    protected boolean started = false;

    public XMLWriter(OutputStream outstream) {
        this.out = new PrintWriter(outstream);
    }

    public XMLWriter(PrintWriter writer) {
        this.out = writer;
    }

    public void startDocument() throws SAXException {
        try {
            this.out.write("<?xml version='1.0'?>");
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.out.flush();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    protected void completeElement() throws IOException {
        if (!this.started) {
            return;
        }
        this.out.write(" >");
        this.started = false;
    }

    public static String normalize(char[] chars, int start, int length) {
        StringBuffer buff = new StringBuffer();
        int i = start;
        while (i < start + length) {
            char c = chars[i];
            switch (c) {
                case '\'': {
                    buff.append("&apos;");
                    break;
                }
                case '\"': {
                    buff.append("&quot;");
                    break;
                }
                case '&': {
                    buff.append("&amp;");
                    break;
                }
                case '<': {
                    buff.append("&lt;");
                    break;
                }
                case '>': {
                    buff.append("&gt;");
                    break;
                }
                default: {
                    buff.append("" + c);
                }
            }
            ++i;
        }
        return buff.toString();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.completeElement();
            this.started = true;
            this.out.write("<" + qName);
            if (atts != null) {
                int count = atts.getLength();
                int i = 0;
                while (i < count) {
                    String name = atts.getQName(i);
                    String value = atts.getValue(i);
                    this.out.write(" " + name + "='" + XMLWriter.normalize(value.toCharArray(), 0, value.length()) + "'");
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (this.started) {
                this.out.write(" />");
            } else {
                this.out.write("</" + qName + ">");
            }
            this.started = false;
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.completeElement();
            this.out.write(XMLWriter.normalize(ch, start, length));
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.completeElement();
            this.out.write("<?" + target + " " + data + "?>");
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }
}

