/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.images.Artwork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTag
implements Tag {
    protected int commonNumber = 0;
    protected Map<String, List<TagField>> fields = new LinkedHashMap<String, List<TagField>>();

    @Override
    public void addField(TagField field) {
        if (field == null) {
            return;
        }
        List<TagField> list = this.fields.get(field.getId());
        if (list == null) {
            list = new ArrayList<TagField>();
            list.add(field);
            this.fields.put(field.getId(), list);
            if (field.isCommon()) {
                ++this.commonNumber;
            }
        } else {
            list.add(field);
        }
    }

    @Override
    public List<TagField> getFields(String id) {
        List<TagField> list = this.fields.get(id);
        if (list == null) {
            return new ArrayList<TagField>();
        }
        return list;
    }

    @Override
    public List<TagField> getFields(FieldKey id) throws KeyNotFoundException {
        List<TagField> list = this.fields.get(id.name());
        if (list == null) {
            return new ArrayList<TagField>();
        }
        return list;
    }

    public String getItem(String id, int index) {
        List<TagField> l = this.getFields(id);
        return l.size() > index ? ((Object)l.get(index)).toString() : "";
    }

    @Override
    public String getFirst(FieldKey genericKey) throws KeyNotFoundException {
        return this.getValue(genericKey, 0);
    }

    @Override
    public String getFirst(String id) {
        List<TagField> l = this.getFields(id);
        return l.size() != 0 ? ((Object)l.get(0)).toString() : "";
    }

    @Override
    public TagField getFirstField(String id) {
        List<TagField> l = this.getFields(id);
        return l.size() != 0 ? l.get(0) : null;
    }

    @Override
    public Iterator<TagField> getFields() {
        final Iterator<Map.Entry<String, List<TagField>>> it = this.fields.entrySet().iterator();
        return new Iterator<TagField>(){
            private Iterator<TagField> fieldsIt;

            private void changeIt() {
                if (!it.hasNext()) {
                    return;
                }
                Map.Entry e = (Map.Entry)it.next();
                List l = (List)e.getValue();
                this.fieldsIt = l.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.fieldsIt == null) {
                    this.changeIt();
                }
                return it.hasNext() || this.fieldsIt != null && this.fieldsIt.hasNext();
            }

            @Override
            public TagField next() {
                if (!this.fieldsIt.hasNext()) {
                    this.changeIt();
                }
                return this.fieldsIt.next();
            }

            @Override
            public void remove() {
                this.fieldsIt.remove();
            }
        };
    }

    @Override
    public int getFieldCount() {
        Iterator<TagField> it = this.getFields();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    @Override
    public int getFieldCountIncludingSubValues() {
        return this.getFieldCount();
    }

    @Override
    public boolean hasCommonFields() {
        return this.commonNumber != 0;
    }

    @Override
    public boolean hasField(String id) {
        return this.getFields(id).size() != 0;
    }

    @Override
    public boolean hasField(FieldKey fieldKey) {
        return this.hasField(fieldKey.name());
    }

    protected abstract boolean isAllowedEncoding(String var1);

    @Override
    public boolean isEmpty() {
        return this.fields.size() == 0;
    }

    @Override
    public void setField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.setField(tagfield);
    }

    @Override
    public void addField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.addField(tagfield);
    }

    @Override
    public void setField(TagField field) {
        if (field == null) {
            return;
        }
        List<TagField> list = this.fields.get(field.getId());
        if (list != null) {
            list.set(0, field);
            return;
        }
        list = new ArrayList<TagField>();
        list.add(field);
        this.fields.put(field.getId(), list);
        if (field.isCommon()) {
            ++this.commonNumber;
        }
    }

    @Override
    public String getSubValue(FieldKey id, int n, int m) {
        return this.getValue(id, n);
    }

    @Override
    public boolean setEncoding(String enc) {
        if (!this.isAllowedEncoding(enc)) {
            return false;
        }
        Iterator<TagField> it = this.getFields();
        while (it.hasNext()) {
            TagField field = it.next();
            if (!(field instanceof TagTextField)) continue;
            ((TagTextField)field).setEncoding(enc);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("Tag content:\n");
        Iterator<TagField> it = this.getFields();
        while (it.hasNext()) {
            TagField field = it.next();
            out.append("\t");
            out.append(field.getId());
            out.append(":");
            out.append(((Object)field).toString());
            out.append("\n");
        }
        return out.toString().substring(0, out.length() - 1);
    }

    @Override
    public abstract TagField createField(FieldKey var1, String var2) throws KeyNotFoundException, FieldDataInvalidException;

    @Override
    public abstract TagField getFirstField(FieldKey var1) throws KeyNotFoundException;

    @Override
    public abstract void deleteField(FieldKey var1) throws KeyNotFoundException;

    @Override
    public void deleteField(String key) {
        this.fields.remove(key);
    }

    @Override
    public Artwork getFirstArtwork() {
        List<Artwork> artwork = this.getArtworkList();
        if (artwork.size() > 0) {
            return artwork.get(0);
        }
        return null;
    }

    @Override
    public void setField(Artwork artwork) throws FieldDataInvalidException {
        this.setField(this.createField(artwork));
    }

    @Override
    public void addField(Artwork artwork) throws FieldDataInvalidException {
        this.addField(this.createField(artwork));
    }

    @Override
    public void deleteArtworkField() throws KeyNotFoundException {
        this.deleteField(FieldKey.COVER_ART);
    }
}

