/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.mp4.Mp4AtomIdentifier;
import org.jaudiotagger.audio.mp4.Mp4AtomTree;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4FreeBox;
import org.jaudiotagger.audio.mp4.atom.Mp4HdlrBox;
import org.jaudiotagger.audio.mp4.atom.Mp4MetaBox;
import org.jaudiotagger.audio.mp4.atom.Mp4StcoBox;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import org.jaudiotagger.tag.mp4.Mp4TagCreator;
import org.jaudiotagger.utils.tree.DefaultMutableTreeNode;

public class Mp4TagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.mp4");
    private Mp4TagCreator tc = new Mp4TagCreator();

    private void writeMetadataSameSize(ByteBuffer rawIlstData, long oldIlstSize, long startIstWithinFile, FileChannel fileReadChannel, FileChannel fileWriteChannel, Mp4BoxHeader tagsHeader) throws CannotWriteException, IOException {
        fileReadChannel.position(0L);
        fileWriteChannel.transferFrom(fileReadChannel, 0L, startIstWithinFile);
        fileWriteChannel.position(startIstWithinFile);
        fileWriteChannel.write(rawIlstData);
        fileReadChannel.position(startIstWithinFile + oldIlstSize);
        this.writeDataAfterIlst(fileReadChannel, fileWriteChannel, tagsHeader);
    }

    private void writeNeroData(FileChannel fileReadChannel, FileChannel fileWriteChannel, Mp4BoxHeader tagsHeader) throws IOException {
        long writeBetweenIlstAndTags = tagsHeader.getFilePos() - fileReadChannel.position();
        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), writeBetweenIlstAndTags);
        fileWriteChannel.position(fileWriteChannel.position() + writeBetweenIlstAndTags);
        this.convertandWriteTagsAtomToFreeAtom(fileWriteChannel, tagsHeader);
        fileReadChannel.position(tagsHeader.getFilePos() + (long)tagsHeader.getLength());
        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
    }

    private void adjustSizeOfMoovHeader(Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, int sizeAdjustment, Mp4BoxHeader udtaHeader, Mp4BoxHeader metaHeader) throws IOException {
        moovHeader.setLength(moovHeader.getLength() + sizeAdjustment);
        if (udtaHeader != null) {
            udtaHeader.setLength(udtaHeader.getLength() + sizeAdjustment);
            moovBuffer.position((int)(udtaHeader.getFilePos() - moovHeader.getFilePos() - 8L));
            moovBuffer.put(udtaHeader.getHeaderData());
        }
        if (metaHeader != null) {
            metaHeader.setLength(metaHeader.getLength() + sizeAdjustment);
            moovBuffer.position((int)(metaHeader.getFilePos() - moovHeader.getFilePos() - 8L));
            moovBuffer.put(metaHeader.getHeaderData());
        }
    }

    private void createMetadataAtoms(Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, int sizeAdjustment, Mp4BoxHeader udtaHeader, Mp4BoxHeader metaHeader) throws IOException {
        moovHeader.setLength(moovHeader.getLength() + sizeAdjustment);
    }

    public void write(Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotWriteException, IOException {
        int relativeIlstposition;
        int startIlstWithinFile;
        Mp4AtomTree atomTree;
        logger.config("Started writing tag data");
        FileChannel fileReadChannel = raf.getChannel();
        FileChannel fileWriteChannel = rafTemp.getChannel();
        int oldIlstSize = 0;
        long endOfMoov = 0L;
        try {
            atomTree = new Mp4AtomTree(raf, false);
        }
        catch (CannotReadException cre) {
            throw new CannotWriteException(cre.getMessage());
        }
        Mp4BoxHeader mdatHeader = atomTree.getBoxHeader(atomTree.getMdatNode());
        if (mdatHeader == null) {
            throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_CANNOT_FIND_AUDIO.getMsg());
        }
        ByteBuffer rawIlstData = this.tc.convert(tag);
        rawIlstData.rewind();
        int newIlstSize = rawIlstData.limit();
        Mp4BoxHeader moovHeader = atomTree.getBoxHeader(atomTree.getMoovNode());
        long positionWithinFileAfterFindingMoovHeader = moovHeader.getFilePos() + 8L;
        endOfMoov = moovHeader.getFilePos() + (long)moovHeader.getLength();
        Mp4StcoBox stco = atomTree.getStco();
        Mp4BoxHeader ilstHeader = atomTree.getBoxHeader(atomTree.getIlstNode());
        Mp4BoxHeader udtaHeader = atomTree.getBoxHeader(atomTree.getUdtaNode());
        Mp4BoxHeader metaHeader = atomTree.getBoxHeader(atomTree.getMetaNode());
        Mp4BoxHeader hdlrMetaHeader = atomTree.getBoxHeader(atomTree.getHdlrWithinMetaNode());
        Mp4BoxHeader tagsHeader = atomTree.getBoxHeader(atomTree.getTagsNode());
        Mp4BoxHeader trakHeader = atomTree.getBoxHeader(atomTree.getTrakNodes().get(0));
        ByteBuffer moovBuffer = atomTree.getMoovBuffer();
        if (udtaHeader != null) {
            if (metaHeader != null) {
                if (ilstHeader != null) {
                    oldIlstSize = ilstHeader.getLength();
                    startIlstWithinFile = (int)ilstHeader.getFilePos();
                    relativeIlstposition = (int)((long)startIlstWithinFile - (moovHeader.getFilePos() + 8L));
                } else if (hdlrMetaHeader != null) {
                    startIlstWithinFile = (int)hdlrMetaHeader.getFilePos() + hdlrMetaHeader.getLength();
                    relativeIlstposition = (int)((long)startIlstWithinFile - (moovHeader.getFilePos() + 8L));
                } else {
                    startIlstWithinFile = (int)metaHeader.getFilePos() + 8 + 4;
                    relativeIlstposition = (int)((long)startIlstWithinFile - (moovHeader.getFilePos() + 8L));
                }
            } else {
                relativeIlstposition = moovHeader.getLength() - 8;
                startIlstWithinFile = (int)(moovHeader.getFilePos() + (long)moovHeader.getLength());
            }
        } else if (metaHeader != null) {
            startIlstWithinFile = (int)trakHeader.getFilePos() + trakHeader.getLength();
            relativeIlstposition = (int)((long)startIlstWithinFile - (moovHeader.getFilePos() + 8L));
        } else {
            relativeIlstposition = moovHeader.getLength() - 8;
            startIlstWithinFile = (int)(moovHeader.getFilePos() + (long)moovHeader.getLength());
        }
        int oldMetaLevelFreeAtomSize = this.getMetaLevelFreeAtomSize(atomTree);
        int topLevelFreePosition = 0;
        int topLevelFreeSize = 0;
        boolean topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata = true;
        boolean topLevelFreeAtomComesBeforeMdatAndMetadata = false;
        for (DefaultMutableTreeNode freeNode : atomTree.getFreeNodes()) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)freeNode.getParent();
            if (!parentNode.isRoot()) continue;
            Mp4BoxHeader topLevelFreeHeader = (Mp4BoxHeader)freeNode.getUserObject();
            topLevelFreeSize = topLevelFreeHeader.getLength();
            topLevelFreePosition = (int)topLevelFreeHeader.getFilePos();
            break;
        }
        if (topLevelFreeSize > 0) {
            if ((long)topLevelFreePosition > mdatHeader.getFilePos()) {
                topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata = false;
            } else if ((long)topLevelFreePosition < moovHeader.getFilePos()) {
                topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata = false;
                topLevelFreeAtomComesBeforeMdatAndMetadata = true;
            }
        } else {
            topLevelFreePosition = (int)mdatHeader.getFilePos();
        }
        logger.config("Read header successfully ready for writing");
        if (oldIlstSize == newIlstSize) {
            logger.config("Writing:Option 1:Same Size");
            this.writeMetadataSameSize(rawIlstData, oldIlstSize, startIlstWithinFile, fileReadChannel, fileWriteChannel, tagsHeader);
        } else if (oldIlstSize > newIlstSize) {
            Mp4FreeBox newFreeBox;
            if (oldMetaLevelFreeAtomSize > 0) {
                logger.config("Writing:Option 2:Smaller Size have free atom:" + oldIlstSize + ":" + newIlstSize);
                this.writeDataUptoIncludingIlst(fileReadChannel, fileWriteChannel, oldIlstSize, startIlstWithinFile, rawIlstData);
                int newFreeSize = oldMetaLevelFreeAtomSize + (oldIlstSize - newIlstSize);
                newFreeBox = new Mp4FreeBox(newFreeSize - 8);
                fileWriteChannel.write(newFreeBox.getHeader().getHeaderData());
                fileWriteChannel.write(newFreeBox.getData());
                fileReadChannel.position(fileReadChannel.position() + (long)oldMetaLevelFreeAtomSize);
                this.writeDataAfterIlst(fileReadChannel, fileWriteChannel, tagsHeader);
            } else {
                int newFreeSize = oldIlstSize - newIlstSize - 8;
                if (newFreeSize > 0) {
                    logger.config("Writing:Option 3:Smaller Size can create free atom");
                    this.writeDataUptoIncludingIlst(fileReadChannel, fileWriteChannel, oldIlstSize, startIlstWithinFile, rawIlstData);
                    newFreeBox = new Mp4FreeBox(newFreeSize);
                    fileWriteChannel.write(newFreeBox.getHeader().getHeaderData());
                    fileWriteChannel.write(newFreeBox.getData());
                    this.writeDataAfterIlst(fileReadChannel, fileWriteChannel, tagsHeader);
                } else {
                    logger.config("Writing:Option 4:Smaller Size <=8 cannot create free atoms");
                    int sizeReducedBy = oldIlstSize - newIlstSize;
                    fileReadChannel.position(0L);
                    fileWriteChannel.transferFrom(fileReadChannel, 0L, moovHeader.getFilePos());
                    fileWriteChannel.position(moovHeader.getFilePos());
                    if (mdatHeader.getFilePos() > moovHeader.getFilePos()) {
                        stco.adjustOffsets(-sizeReducedBy);
                    }
                    this.adjustSizeOfMoovHeader(moovHeader, moovBuffer, -sizeReducedBy, udtaHeader, metaHeader);
                    fileWriteChannel.write(moovHeader.getHeaderData());
                    moovBuffer.rewind();
                    moovBuffer.limit(relativeIlstposition);
                    fileWriteChannel.write(moovBuffer);
                    fileWriteChannel.write(rawIlstData);
                    fileReadChannel.position(startIlstWithinFile + oldIlstSize);
                    this.writeDataAfterIlst(fileReadChannel, fileWriteChannel, tagsHeader);
                }
            }
        } else {
            int additionalSpaceRequiredForMetadata = newIlstSize - oldIlstSize;
            if (additionalSpaceRequiredForMetadata <= oldMetaLevelFreeAtomSize - 8) {
                int newFreeSize = oldMetaLevelFreeAtomSize - additionalSpaceRequiredForMetadata;
                logger.config("Writing:Option 5;Larger Size can use meta free atom need extra:" + newFreeSize + "bytes");
                this.writeDataUptoIncludingIlst(fileReadChannel, fileWriteChannel, oldIlstSize, startIlstWithinFile, rawIlstData);
                Mp4FreeBox newFreeBox = new Mp4FreeBox(newFreeSize - 8);
                fileWriteChannel.write(newFreeBox.getHeader().getHeaderData());
                fileWriteChannel.write(newFreeBox.getData());
                fileReadChannel.position(fileReadChannel.position() + (long)oldMetaLevelFreeAtomSize);
                this.writeDataAfterIlst(fileReadChannel, fileWriteChannel, tagsHeader);
            } else {
                int additionalMetaSizeThatWontFitWithinMetaAtom = additionalSpaceRequiredForMetadata - oldMetaLevelFreeAtomSize;
                fileReadChannel.position(0L);
                fileWriteChannel.transferFrom(fileReadChannel, 0L, positionWithinFileAfterFindingMoovHeader - 8L);
                fileWriteChannel.position(positionWithinFileAfterFindingMoovHeader - 8L);
                if (udtaHeader == null) {
                    logger.config("Writing:Option 5.1;No udta atom");
                    Mp4HdlrBox hdlrBox = Mp4HdlrBox.createiTunesStyleHdlrBox();
                    Mp4MetaBox metaBox = Mp4MetaBox.createiTunesStyleMetaBox(hdlrBox.getHeader().getLength() + rawIlstData.limit());
                    udtaHeader = new Mp4BoxHeader(Mp4AtomIdentifier.UDTA.getFieldName());
                    udtaHeader.setLength(8 + metaBox.getHeader().getLength());
                    if ((!topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata || topLevelFreeSize - 8 < (additionalMetaSizeThatWontFitWithinMetaAtom += udtaHeader.getLength() - rawIlstData.limit()) && topLevelFreeSize != additionalMetaSizeThatWontFitWithinMetaAtom) && mdatHeader.getFilePos() > moovHeader.getFilePos()) {
                        logger.config("Adjusting Offsets");
                        stco.adjustOffsets(additionalMetaSizeThatWontFitWithinMetaAtom);
                    }
                    moovHeader.setLength(moovHeader.getLength() + additionalMetaSizeThatWontFitWithinMetaAtom);
                    fileWriteChannel.write(moovHeader.getHeaderData());
                    moovBuffer.rewind();
                    moovBuffer.limit(relativeIlstposition);
                    fileWriteChannel.write(moovBuffer);
                    fileWriteChannel.write(udtaHeader.getHeaderData());
                    fileWriteChannel.write(metaBox.getHeader().getHeaderData());
                    fileWriteChannel.write(metaBox.getData());
                    fileWriteChannel.write(hdlrBox.getHeader().getHeaderData());
                    fileWriteChannel.write(hdlrBox.getData());
                } else if (metaHeader == null) {
                    logger.config("Writing:Option 5.2;No meta atom");
                    int oldUdtaHeaderLength = udtaHeader.getLength();
                    Mp4HdlrBox hdlrBox = Mp4HdlrBox.createiTunesStyleHdlrBox();
                    Mp4MetaBox metaBox = Mp4MetaBox.createiTunesStyleMetaBox(hdlrBox.getHeader().getLength() + rawIlstData.limit());
                    udtaHeader = new Mp4BoxHeader(Mp4AtomIdentifier.UDTA.getFieldName());
                    udtaHeader.setLength(8 + metaBox.getHeader().getLength());
                    if ((!topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata || topLevelFreeSize - 8 < (additionalMetaSizeThatWontFitWithinMetaAtom += udtaHeader.getLength() - rawIlstData.limit()) && topLevelFreeSize != additionalMetaSizeThatWontFitWithinMetaAtom) && mdatHeader.getFilePos() > moovHeader.getFilePos()) {
                        logger.config("Adjusting Offsets");
                        stco.adjustOffsets(additionalMetaSizeThatWontFitWithinMetaAtom);
                    }
                    moovHeader.setLength(moovHeader.getLength() - oldUdtaHeaderLength + additionalMetaSizeThatWontFitWithinMetaAtom);
                    fileWriteChannel.write(moovHeader.getHeaderData());
                    moovBuffer.rewind();
                    moovBuffer.limit(relativeIlstposition - oldUdtaHeaderLength);
                    fileWriteChannel.write(moovBuffer);
                    fileWriteChannel.write(udtaHeader.getHeaderData());
                    fileWriteChannel.write(metaBox.getHeader().getHeaderData());
                    fileWriteChannel.write(metaBox.getData());
                    fileWriteChannel.write(hdlrBox.getHeader().getHeaderData());
                    fileWriteChannel.write(hdlrBox.getData());
                } else {
                    logger.config("Writing:Option 5.3;udta atom exists");
                    if ((!topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata || topLevelFreeSize - 8 < additionalMetaSizeThatWontFitWithinMetaAtom && topLevelFreeSize != additionalMetaSizeThatWontFitWithinMetaAtom) && mdatHeader.getFilePos() > moovHeader.getFilePos()) {
                        stco.adjustOffsets(additionalMetaSizeThatWontFitWithinMetaAtom);
                    }
                    this.adjustSizeOfMoovHeader(moovHeader, moovBuffer, additionalMetaSizeThatWontFitWithinMetaAtom, udtaHeader, metaHeader);
                    fileWriteChannel.write(moovHeader.getHeaderData());
                    moovBuffer.rewind();
                    moovBuffer.limit(relativeIlstposition);
                    fileWriteChannel.write(moovBuffer);
                }
                fileWriteChannel.write(rawIlstData);
                fileReadChannel.position(startIlstWithinFile + oldIlstSize);
                fileReadChannel.position(fileReadChannel.position() + (long)oldMetaLevelFreeAtomSize);
                if (tagsHeader != null) {
                    long writeBetweenIlstAndTags = tagsHeader.getFilePos() - fileReadChannel.position();
                    fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), writeBetweenIlstAndTags);
                    fileWriteChannel.position(fileWriteChannel.position() + writeBetweenIlstAndTags);
                    this.convertandWriteTagsAtomToFreeAtom(fileWriteChannel, tagsHeader);
                    fileReadChannel.position(tagsHeader.getFilePos() + (long)tagsHeader.getLength());
                    long extraData = endOfMoov - fileReadChannel.position();
                    fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), extraData);
                } else {
                    long extraData = endOfMoov - fileReadChannel.position();
                    fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), extraData);
                    fileWriteChannel.position(fileWriteChannel.position() + extraData);
                }
                if (topLevelFreeAtomComesBeforeMdatAtomAndAfterMetadata && topLevelFreePosition >= startIlstWithinFile) {
                    if (topLevelFreeSize - 8 >= additionalMetaSizeThatWontFitWithinMetaAtom) {
                        logger.config("Writing:Option 6;Larger Size can use top free atom");
                        Mp4FreeBox freeBox = new Mp4FreeBox(topLevelFreeSize - 8 - additionalMetaSizeThatWontFitWithinMetaAtom);
                        fileWriteChannel.write(freeBox.getHeader().getHeaderData());
                        fileWriteChannel.write(freeBox.getData());
                        fileReadChannel.position(fileReadChannel.position() + (long)topLevelFreeSize);
                        this.writeDataInChunks(fileReadChannel, fileWriteChannel);
                    } else if (topLevelFreeSize == additionalMetaSizeThatWontFitWithinMetaAtom) {
                        logger.config("Writing:Option 7;Larger Size uses top free atom including header");
                        fileReadChannel.position(fileReadChannel.position() + (long)topLevelFreeSize);
                        this.writeDataInChunks(fileReadChannel, fileWriteChannel);
                    } else {
                        logger.config("Writing:Option 8;Larger Size cannot use top free atom");
                        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
                        this.writeDataInChunks(fileReadChannel, fileWriteChannel);
                    }
                } else {
                    logger.config("Writing:Option 9;Top Level Free comes after Mdat or before Metadata so cant use it");
                    this.writeDataInChunks(fileReadChannel, fileWriteChannel);
                }
            }
        }
        fileReadChannel.close();
        raf.close();
        this.checkFileWrittenCorrectly(rafTemp, mdatHeader, fileWriteChannel, stco);
    }

    private void writeDataInChunks(FileChannel fileReadChannel, FileChannel fileWriteChannel) throws IOException, CannotWriteException {
        long amountToBeWritten = fileReadChannel.size() - fileReadChannel.position();
        long written = 0L;
        long chunksize = TagOptionSingleton.getInstance().getWriteChunkSize();
        long count = amountToBeWritten / chunksize;
        long mod = amountToBeWritten % chunksize;
        int i = 0;
        while ((long)i < count) {
            written += fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), chunksize);
            fileWriteChannel.position(fileWriteChannel.position() + chunksize);
            ++i;
        }
        if ((written += fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), mod)) != amountToBeWritten) {
            throw new CannotWriteException("Was meant to write " + amountToBeWritten + " bytes but only written " + written + " bytes");
        }
    }

    private void convertandWriteTagsAtomToFreeAtom(FileChannel fileWriteChannel, Mp4BoxHeader tagsHeader) throws IOException {
        Mp4FreeBox freeBox = new Mp4FreeBox(tagsHeader.getDataLength());
        fileWriteChannel.write(freeBox.getHeader().getHeaderData());
        fileWriteChannel.write(freeBox.getData());
    }

    private void writeDataUptoIncludingIlst(FileChannel fileReadChannel, FileChannel fileWriteChannel, int oldIlstSize, int startIlstWithinFile, ByteBuffer rawIlstData) throws IOException {
        fileReadChannel.position(0L);
        fileWriteChannel.transferFrom(fileReadChannel, 0L, startIlstWithinFile);
        fileWriteChannel.position(startIlstWithinFile);
        fileWriteChannel.write(rawIlstData);
        fileReadChannel.position(startIlstWithinFile + oldIlstSize);
    }

    private void writeDataAfterIlst(FileChannel fileReadChannel, FileChannel fileWriteChannel, Mp4BoxHeader tagsHeader) throws IOException {
        if (tagsHeader != null) {
            this.writeNeroData(fileReadChannel, fileWriteChannel, tagsHeader);
        } else {
            fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
        }
    }

    private int getMetaLevelFreeAtomSize(Mp4AtomTree atomTree) {
        int oldMetaLevelFreeAtomSize = 0;
        for (DefaultMutableTreeNode freeNode : atomTree.getFreeNodes()) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)freeNode.getParent();
            DefaultMutableTreeNode brotherNode = freeNode.getPreviousSibling();
            if (parentNode.isRoot()) continue;
            Mp4BoxHeader parentHeader = (Mp4BoxHeader)parentNode.getUserObject();
            Mp4BoxHeader freeHeader = (Mp4BoxHeader)freeNode.getUserObject();
            if (brotherNode == null) continue;
            Mp4BoxHeader brotherHeader = (Mp4BoxHeader)brotherNode.getUserObject();
            if (!parentHeader.getId().equals(Mp4AtomIdentifier.META.getFieldName()) || !brotherHeader.getId().equals(Mp4AtomIdentifier.ILST.getFieldName())) continue;
            oldMetaLevelFreeAtomSize = freeHeader.getLength();
            break;
        }
        return oldMetaLevelFreeAtomSize;
    }

    private void checkFileWrittenCorrectly(RandomAccessFile rafTemp, Mp4BoxHeader mdatHeader, FileChannel fileWriteChannel, Mp4StcoBox stco) throws CannotWriteException, IOException {
        logger.config("Checking file has been written correctly");
        try {
            try {
                Mp4AtomTree newAtomTree = new Mp4AtomTree(rafTemp, false);
                Mp4BoxHeader newMdatHeader = newAtomTree.getBoxHeader(newAtomTree.getMdatNode());
                if (newMdatHeader == null) {
                    throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_DATA.getMsg());
                }
                if (newMdatHeader.getLength() != mdatHeader.getLength()) {
                    throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_DATA_CORRUPT.getMsg());
                }
                Mp4BoxHeader newUdtaHeader = newAtomTree.getBoxHeader(newAtomTree.getUdtaNode());
                if (newUdtaHeader == null) {
                    throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_TAG_DATA.getMsg());
                }
                Mp4BoxHeader newMetaHeader = newAtomTree.getBoxHeader(newAtomTree.getMetaNode());
                if (newMetaHeader == null) {
                    throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_TAG_DATA.getMsg());
                }
                Mp4StcoBox newStco = newAtomTree.getStco();
                logger.finer("stco:Original First Offset" + stco.getFirstOffSet());
                logger.finer("stco:Original Diff" + (int)((long)stco.getFirstOffSet() - mdatHeader.getFilePos()));
                logger.finer("stco:Original Mdat Pos" + mdatHeader.getFilePos());
                logger.finer("stco:New First Offset" + newStco.getFirstOffSet());
                logger.finer("stco:New Diff" + (int)((long)newStco.getFirstOffSet() - newMdatHeader.getFilePos()));
                logger.finer("stco:New Mdat Pos" + newMdatHeader.getFilePos());
                int diff = (int)((long)stco.getFirstOffSet() - mdatHeader.getFilePos());
                if ((long)newStco.getFirstOffSet() - newMdatHeader.getFilePos() != (long)diff) {
                    int discrepancy = (int)((long)newStco.getFirstOffSet() - newMdatHeader.getFilePos() - (long)diff);
                    throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_INCORRECT_OFFSETS.getMsg(discrepancy));
                }
                Object var13_13 = null;
            }
            catch (Exception e) {
                if (e instanceof CannotWriteException) {
                    throw (CannotWriteException)e;
                }
                e.printStackTrace();
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED.getMsg() + ":" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            rafTemp.close();
            fileWriteChannel.close();
            throw throwable;
        }
        rafTemp.close();
        fileWriteChannel.close();
        logger.config("File has been written correctly");
    }

    public void delete(RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException {
        Mp4Tag tag = new Mp4Tag();
        try {
            this.write(tag, raf, rafTemp);
        }
        catch (CannotWriteException cwe) {
            throw new IOException(cwe.getMessage());
        }
    }
}

