/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.Config;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CorePropertiesLocator;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.util.DOMUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;

public class ConfigSolrXml
extends ConfigSolr {
    protected static Logger log = LoggerFactory.getLogger(ConfigSolrXml.class);
    private final CoresLocator coresLocator;
    private static final Function<Map.Entry<String, Object>, String> GET_KEY_FUNCTION = new Function<Map.Entry<String, Object>, String>(){

        public String apply(Map.Entry<String, Object> input) {
            return input.getKey();
        }
    };
    private static final Function<Object, Integer> TO_INT_FUNCTION = new Function<Object, Integer>(){

        public Integer apply(Object input) {
            try {
                return Integer.parseInt(String.valueOf(input));
            }
            catch (NumberFormatException exc) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Value of '%s' can not be parsed as 'int'", input));
            }
        }
    };
    private static final Function<Object, Boolean> TO_BOOLEAN_FUNCTION = new Function<Object, Boolean>(){

        public Boolean apply(Object input) {
            if (input instanceof String) {
                return Boolean.valueOf(String.valueOf(input));
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Value of '%s' can not be parsed as 'bool'", input));
        }
    };

    public ConfigSolrXml(Config config) {
        super(config);
        try {
            this.checkForIllegalConfig();
            this.fillPropMap();
            this.coresLocator = new CorePropertiesLocator(this.getCoreRootDirectory());
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void checkForIllegalConfig() throws IOException {
        this.failIfFound("solr/@coreLoadThreads");
        this.failIfFound("solr/@persistent");
        this.failIfFound("solr/@sharedLib");
        this.failIfFound("solr/@zkHost");
        this.failIfFound("solr/logging/@class");
        this.failIfFound("solr/logging/@enabled");
        this.failIfFound("solr/logging/watcher/@size");
        this.failIfFound("solr/logging/watcher/@threshold");
        this.failIfFound("solr/cores/@adminHandler");
        this.failIfFound("solr/cores/@distribUpdateConnTimeout");
        this.failIfFound("solr/cores/@distribUpdateSoTimeout");
        this.failIfFound("solr/cores/@host");
        this.failIfFound("solr/cores/@hostContext");
        this.failIfFound("solr/cores/@hostPort");
        this.failIfFound("solr/cores/@leaderVoteWait");
        this.failIfFound("solr/cores/@leaderConflictResolveWait");
        this.failIfFound("solr/cores/@genericCoreNodeNames");
        this.failIfFound("solr/cores/@managementPath");
        this.failIfFound("solr/cores/@shareSchema");
        this.failIfFound("solr/cores/@transientCacheSize");
        this.failIfFound("solr/cores/@zkClientTimeout");
        this.failIfFound("solr/cores/@defaultCoreName");
        this.failIfFound("solr/@persistent");
        this.failIfFound("solr/cores/@adminPath");
    }

    private void failIfFound(String xPath) {
        if (this.config.getVal(xPath, false) != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Should not have found " + xPath + " solr.xml may be a mix of old and new style formats.");
        }
    }

    private NamedList<Object> readNodeListAsNamedList(String path) {
        NodeList nodes = this.config.getNodeList(path, false);
        if (nodes != null) {
            NamedList<Object> namedList = DOMUtil.nodesToNamedList(nodes);
            return namedList;
        }
        return new NamedList();
    }

    private void fillPropMap() {
        NamedList unknownConfigParams = new NamedList();
        this.fillSolrSection(this.readNodeListAsNamedList("solr/*[@name][not(name()='shardHandlerFactory')]"));
        this.thereCanBeOnlyOne("solr/solrcloud", "<solrcloud>");
        this.fillSolrCloudSection(this.readNodeListAsNamedList("solr/solrcloud/*[@name]"));
        this.thereCanBeOnlyOne("solr/logging", "<logging>");
        this.thereCanBeOnlyOne("solr/logging/watcher", "Logging <watcher>");
        this.fillLoggingSection(this.readNodeListAsNamedList("solr/logging/*[@name]"), this.readNodeListAsNamedList("solr/logging/watcher/*[@name]"));
    }

    private void fillSolrSection(NamedList<Object> nl) {
        String s = "Main";
        this.storeConfigPropertyAsString(s, nl, ConfigSolr.CfgProp.SOLR_ADMINHANDLER, "adminHandler");
        this.storeConfigPropertyAsString(s, nl, ConfigSolr.CfgProp.SOLR_COLLECTIONSHANDLER, "collectionsHandler");
        this.storeConfigPropertyAsString(s, nl, ConfigSolr.CfgProp.SOLR_INFOHANDLER, "infoHandler");
        this.storeConfigPropertyAsString(s, nl, ConfigSolr.CfgProp.SOLR_COREROOTDIRECTORY, "coreRootDirectory");
        this.storeConfigPropertyAsString(s, nl, ConfigSolr.CfgProp.SOLR_MANAGEMENTPATH, "managementPath");
        this.storeConfigPropertyAsString(s, nl, ConfigSolr.CfgProp.SOLR_SHAREDLIB, "sharedLib");
        this.storeConfigPropertyAsString(s, nl, ConfigSolr.CfgProp.SOLR_CONFIGSETBASEDIR, "configSetBaseDir");
        this.storeConfigPropertyAsBoolean(s, nl, ConfigSolr.CfgProp.SOLR_SHARESCHEMA, "shareSchema");
        this.storeConfigPropertyAsInt(s, nl, ConfigSolr.CfgProp.SOLR_CORELOADTHREADS, "coreLoadThreads");
        this.storeConfigPropertyAsInt(s, nl, ConfigSolr.CfgProp.SOLR_TRANSIENTCACHESIZE, "transientCacheSize");
        this.errorOnLeftOvers(s, nl);
    }

    private void fillSolrCloudSection(NamedList<Object> nl) {
        String s = "<solrcloud>";
        this.storeConfigPropertyAsInt(s, nl, ConfigSolr.CfgProp.SOLR_DISTRIBUPDATECONNTIMEOUT, "distribUpdateConnTimeout");
        this.storeConfigPropertyAsInt(s, nl, ConfigSolr.CfgProp.SOLR_DISTRIBUPDATESOTIMEOUT, "distribUpdateSoTimeout");
        this.storeConfigPropertyAsInt(s, nl, ConfigSolr.CfgProp.SOLR_MAXUPDATECONNECTIONS, "maxUpdateConnections");
        this.storeConfigPropertyAsInt(s, nl, ConfigSolr.CfgProp.SOLR_MAXUPDATECONNECTIONSPERHOST, "maxUpdateConnectionsPerHost");
        this.storeConfigPropertyAsInt(s, nl, ConfigSolr.CfgProp.SOLR_LEADERVOTEWAIT, "leaderVoteWait");
        this.storeConfigPropertyAsInt(s, nl, ConfigSolr.CfgProp.SOLR_LEADERCONFLICTRESOLVEWAIT, "leaderConflictResolveWait");
        this.storeConfigPropertyAsInt(s, nl, ConfigSolr.CfgProp.SOLR_ZKCLIENTTIMEOUT, "zkClientTimeout");
        this.storeConfigPropertyAsInt(s, nl, ConfigSolr.CfgProp.SOLR_AUTOREPLICAFAILOVERBADNODEEXPIRATION, "autoReplicaFailoverBadNodeExpiration");
        this.storeConfigPropertyAsInt(s, nl, ConfigSolr.CfgProp.SOLR_AUTOREPLICAFAILOVERWAITAFTEREXPIRATION, "autoReplicaFailoverWaitAfterExpiration");
        this.storeConfigPropertyAsInt(s, nl, ConfigSolr.CfgProp.SOLR_AUTOREPLICAFAILOVERWORKLOOPDELAY, "autoReplicaFailoverWorkLoopDelay");
        this.storeConfigPropertyAsString(s, nl, ConfigSolr.CfgProp.SOLR_HOST, "host");
        this.storeConfigPropertyAsString(s, nl, ConfigSolr.CfgProp.SOLR_HOSTCONTEXT, "hostContext");
        this.storeConfigPropertyAsString(s, nl, ConfigSolr.CfgProp.SOLR_HOSTPORT, "hostPort");
        this.storeConfigPropertyAsString(s, nl, ConfigSolr.CfgProp.SOLR_ZKHOST, "zkHost");
        this.storeConfigPropertyAsBoolean(s, nl, ConfigSolr.CfgProp.SOLR_GENERICCORENODENAMES, "genericCoreNodeNames");
        this.errorOnLeftOvers(s, nl);
    }

    private void fillLoggingSection(NamedList<Object> loggingConfig, NamedList<Object> loggingWatcherConfig) {
        String s = "<logging>";
        this.storeConfigPropertyAsString(s, loggingConfig, ConfigSolr.CfgProp.SOLR_LOGGING_CLASS, "class");
        this.storeConfigPropertyAsBoolean(s, loggingConfig, ConfigSolr.CfgProp.SOLR_LOGGING_ENABLED, "enabled");
        this.errorOnLeftOvers(s, loggingConfig);
        s = "Logging <watcher>";
        this.storeConfigPropertyAsInt(s, loggingWatcherConfig, ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_SIZE, "size");
        this.storeConfigPropertyAsString(s, loggingWatcherConfig, ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_THRESHOLD, "threshold");
        this.errorOnLeftOvers(s, loggingWatcherConfig);
    }

    private <T> void storeConfigProperty(String section, NamedList<Object> config, ConfigSolr.CfgProp propertyKey, String name, Function<Object, T> valueTransformer, Class<T> clazz) {
        List values = config.removeAll(name);
        if (null != values && 0 != values.size()) {
            if (1 < values.size()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "%s section of solr.xml contains duplicated '%s' in solr.xml: %s", section, name, values));
            }
            Object value = values.get(0);
            if (value != null) {
                if (value.getClass().isAssignableFrom(clazz)) {
                    this.propMap.put(propertyKey, value);
                } else {
                    this.propMap.put(propertyKey, valueTransformer.apply(value));
                }
            } else {
                this.propMap.put(propertyKey, null);
            }
        }
    }

    private void storeConfigPropertyAsString(String section, NamedList<Object> config, ConfigSolr.CfgProp propertyKey, String name) {
        this.storeConfigProperty(section, config, propertyKey, name, Functions.toStringFunction(), String.class);
    }

    private void storeConfigPropertyAsInt(String section, NamedList<Object> config, ConfigSolr.CfgProp propertyKey, String xmlElementName) {
        this.storeConfigProperty(section, config, propertyKey, xmlElementName, TO_INT_FUNCTION, Integer.class);
    }

    private void storeConfigPropertyAsBoolean(String section, NamedList<Object> config, ConfigSolr.CfgProp propertyKey, String name) {
        this.storeConfigProperty(section, config, propertyKey, name, TO_BOOLEAN_FUNCTION, Boolean.class);
    }

    private void thereCanBeOnlyOne(String xpath, String section) {
        NodeList lst = this.config.getNodeList(xpath, false);
        if (1 < lst.getLength()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, lst.getLength() + " instances of " + section + " found in solr.xml");
        }
    }

    private void errorOnLeftOvers(String section, NamedList<Object> leftovers) {
        if (null == leftovers || 0 == leftovers.size()) {
            return;
        }
        ArrayList unknownElements = new ArrayList(leftovers.size());
        for (Map.Entry unknownElement : leftovers) {
            log.error("Unknown config parameter in {} section of solr.xml: {} -> {}", new Object[]{section, unknownElement.getKey(), unknownElement.getValue()});
            unknownElements.add(unknownElement.getKey());
        }
        if (!unknownElements.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "%s section of solr.xml contains %d unknown config parameter(s): %s", section, unknownElements.size(), unknownElements));
        }
    }

    @Override
    public String getDefaultCoreName() {
        return "collection1";
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    protected String getShardHandlerFactoryConfigPath() {
        return "solr/shardHandlerFactory";
    }

    @Override
    public String getAdminPath() {
        return "/admin/cores";
    }

    @Override
    public CoresLocator getCoresLocator() {
        return this.coresLocator;
    }
}

