/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import org.apache.commons.io.IOUtils;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.util.FileUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class ManagedIndexSchema
extends IndexSchema {
    private boolean isMutable = false;
    final String managedSchemaResourceName;
    int schemaZkVersion;
    final Object schemaUpdateLock;

    @Override
    public boolean isMutable() {
        return this.isMutable;
    }

    ManagedIndexSchema(SolrConfig solrConfig, String name, InputSource is, boolean isMutable, String managedSchemaResourceName, int schemaZkVersion, Object schemaUpdateLock) throws KeeperException, InterruptedException {
        super(solrConfig, name, is);
        this.isMutable = isMutable;
        this.managedSchemaResourceName = managedSchemaResourceName;
        this.schemaZkVersion = schemaZkVersion;
        this.schemaUpdateLock = schemaUpdateLock;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean persistManagedSchema(boolean createOnly) {
        if (this.loader instanceof ZkSolrResourceLoader) {
            return this.persistManagedSchemaToZooKeeper(createOnly);
        }
        File managedSchemaFile = new File(this.loader.getConfigDir(), this.managedSchemaResourceName);
        OutputStreamWriter writer = null;
        try {
            File parentDir = managedSchemaFile.getParentFile();
            if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                String msg = "Can't create managed schema directory " + parentDir.getAbsolutePath();
                log.error(msg);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            }
            FileOutputStream out = new FileOutputStream(managedSchemaFile);
            writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            this.persist(writer);
            log.info("Upgraded to managed schema at " + managedSchemaFile.getPath());
        }
        catch (IOException e) {
            try {
                String msg = "Error persisting managed schema " + managedSchemaFile;
                log.error(msg, (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                try {
                    FileUtils.sync(managedSchemaFile);
                    throw throwable;
                }
                catch (IOException e2) {
                    String msg = "Error syncing the managed schema file " + managedSchemaFile;
                    log.error(msg, (Throwable)e2);
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        try {
            FileUtils.sync(managedSchemaFile);
            return true;
        }
        catch (IOException e) {
            String msg = "Error syncing the managed schema file " + managedSchemaFile;
            log.error(msg, (Throwable)e);
            return true;
        }
    }

    boolean persistManagedSchemaToZooKeeper(boolean createOnly) {
        ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)this.loader;
        ZkController zkController = zkLoader.getZkController();
        SolrZkClient zkClient = zkController.getZkClient();
        String managedSchemaPath = zkLoader.getCollectionZkPath() + "/" + this.managedSchemaResourceName;
        boolean success = true;
        boolean schemaChangedInZk = false;
        try {
            StringWriter writer = new StringWriter();
            this.persist(writer);
            byte[] data = writer.toString().getBytes(StandardCharsets.UTF_8);
            if (createOnly) {
                try {
                    zkClient.create(managedSchemaPath, data, CreateMode.PERSISTENT, true);
                    this.schemaZkVersion = 0;
                    log.info("Created and persisted managed schema znode at " + managedSchemaPath);
                }
                catch (KeeperException.NodeExistsException e) {
                    log.info("Managed schema znode at " + managedSchemaPath + " already exists - no need to create it");
                }
            } else {
                try {
                    Stat stat = zkClient.setData(managedSchemaPath, data, this.schemaZkVersion, true);
                    this.schemaZkVersion = stat.getVersion();
                    log.info("Persisted managed schema at " + managedSchemaPath);
                }
                catch (KeeperException.BadVersionException e) {
                    success = false;
                    schemaChangedInZk = true;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            String msg = "Error persisting managed schema at " + managedSchemaPath;
            log.error(msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
        }
        if (schemaChangedInZk) {
            String msg = "Failed to persist managed schema at " + managedSchemaPath + " - version mismatch";
            log.info(msg);
            throw new SchemaChangedInZkException(SolrException.ErrorCode.CONFLICT, msg + ", retry.");
        }
        return success;
    }

    @Override
    public ManagedIndexSchema addField(SchemaField newField) {
        return this.addFields(Arrays.asList(newField));
    }

    @Override
    public ManagedIndexSchema addField(SchemaField newField, Collection<String> copyFieldNames) {
        return this.addFields(Arrays.asList(newField), (Map)Collections.singletonMap(newField.getName(), copyFieldNames));
    }

    @Override
    public ManagedIndexSchema addFields(Collection<SchemaField> newFields) {
        return this.addFields((Collection)newFields, Collections.emptyMap());
    }

    @Override
    public ManagedIndexSchema addFields(Collection<SchemaField> newFields, Map<String, Collection<String>> copyFieldNames) {
        ManagedIndexSchema newSchema = null;
        if (this.isMutable) {
            boolean success = false;
            if (copyFieldNames == null) {
                copyFieldNames = Collections.emptyMap();
            }
            newSchema = this.shallowCopy(true);
            for (SchemaField newField : newFields) {
                Collection<String> copyFields;
                if (null != newSchema.getFieldOrNull(newField.getName())) {
                    String msg = "Field '" + newField.getName() + "' already exists.";
                    throw new FieldExistsException(SolrException.ErrorCode.BAD_REQUEST, msg);
                }
                newSchema.fields.put(newField.getName(), newField);
                if (null != newField.getDefaultValue()) {
                    log.debug(newField.getName() + " contains default value: " + newField.getDefaultValue());
                    newSchema.fieldsWithDefaultValue.add(newField);
                }
                if (newField.isRequired()) {
                    log.debug("{} is required in this schema", (Object)newField.getName());
                    newSchema.requiredFields.add(newField);
                }
                if ((copyFields = copyFieldNames.get(newField.getName())) != null) {
                    for (String copyField : copyFields) {
                        newSchema.registerCopyField(newField.getName(), copyField);
                    }
                }
                for (SchemaAware aware : newSchema.schemaAware) {
                    aware.inform(newSchema);
                }
                newSchema.refreshAnalyzers();
                success = newSchema.persistManagedSchema(false);
                if (success) {
                    log.debug("Added field(s): {}", newFields);
                    continue;
                }
                log.error("Failed to add field(s): {}", newFields);
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        return newSchema;
    }

    @Override
    public ManagedIndexSchema addCopyFields(Map<String, Collection<String>> copyFields) {
        ManagedIndexSchema newSchema = null;
        if (this.isMutable) {
            boolean success = false;
            newSchema = this.shallowCopy(true);
            for (Map.Entry<String, Collection<String>> entry : copyFields.entrySet()) {
                for (String destination : entry.getValue()) {
                    newSchema.registerCopyField(entry.getKey(), destination);
                }
            }
            for (SchemaAware aware : newSchema.schemaAware) {
                aware.inform(newSchema);
            }
            newSchema.refreshAnalyzers();
            success = newSchema.persistManagedSchema(false);
            if (success) {
                log.debug("Added copy fields for {} sources", (Object)copyFields.size());
            } else {
                log.error("Failed to add copy fields for {} sources", (Object)copyFields.size());
            }
        }
        return newSchema;
    }

    @Override
    public SchemaField newField(String fieldName, String fieldType, Map<String, ?> options) {
        SchemaField sf;
        if (this.isMutable) {
            try {
                if (-1 != fieldName.indexOf(42)) {
                    String msg = "Can't add dynamic field '" + fieldName + "'.";
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                }
                SchemaField existingFieldWithTheSameName = this.getFieldOrNull(fieldName);
                if (null != existingFieldWithTheSameName) {
                    String msg = "Field '" + fieldName + "' already exists.";
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                }
                FieldType type = this.getFieldTypeByName(fieldType);
                if (null == type) {
                    String msg = "Field '" + fieldName + "': Field type '" + fieldType + "' not found.";
                    log.error(msg);
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                }
                sf = SchemaField.create(fieldName, type, options);
            }
            catch (SolrException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        return sf;
    }

    ManagedIndexSchema reloadFields(InputSource inputSource, int schemaZkVersion) {
        ManagedIndexSchema newSchema;
        try {
            newSchema = this.shallowCopy(false);
            Config schemaConf = new Config(this.loader, "schema", inputSource, "/schema/");
            Document document = schemaConf.getDocument();
            XPath xpath = schemaConf.getXPath();
            newSchema.loadFields(document, xpath);
            newSchema.copyFieldsMap = new HashMap();
            newSchema.dynamicCopyFields = new IndexSchema.DynamicCopy[0];
            newSchema.copyFieldTargetCounts = new HashMap();
            newSchema.loadCopyFields(document, xpath);
            if (null != this.uniqueKeyField) {
                newSchema.requiredFields.add(this.uniqueKeyField);
            }
            for (SchemaAware aware : newSchema.schemaAware) {
                aware.inform(newSchema);
            }
            newSchema.refreshAnalyzers();
            newSchema.schemaZkVersion = schemaZkVersion;
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Schema Parsing Failed: " + e.getMessage(), (Throwable)e);
        }
        return newSchema;
    }

    private ManagedIndexSchema(SolrConfig solrConfig, SolrResourceLoader loader, boolean isMutable, String managedSchemaResourceName, int schemaZkVersion, Object schemaUpdateLock) throws KeeperException, InterruptedException {
        super(solrConfig, loader);
        this.isMutable = isMutable;
        this.managedSchemaResourceName = managedSchemaResourceName;
        this.schemaZkVersion = schemaZkVersion;
        this.schemaUpdateLock = schemaUpdateLock;
    }

    private ManagedIndexSchema shallowCopy(boolean includeFieldDataStructures) {
        ManagedIndexSchema newSchema = null;
        try {
            newSchema = new ManagedIndexSchema(this.solrConfig, this.loader, this.isMutable, this.managedSchemaResourceName, this.schemaZkVersion, this.getSchemaUpdateLock());
        }
        catch (KeeperException e) {
            String msg = "Error instantiating ManagedIndexSchema";
            log.error("Error instantiating ManagedIndexSchema", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating ManagedIndexSchema", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("", (Throwable)e);
        }
        assert (newSchema != null);
        newSchema.name = this.name;
        newSchema.version = this.version;
        newSchema.defaultSearchFieldName = this.defaultSearchFieldName;
        newSchema.queryParserDefaultOperator = this.queryParserDefaultOperator;
        newSchema.isExplicitQueryParserDefaultOperator = this.isExplicitQueryParserDefaultOperator;
        newSchema.similarity = this.similarity;
        newSchema.similarityFactory = this.similarityFactory;
        newSchema.isExplicitSimilarity = this.isExplicitSimilarity;
        newSchema.uniqueKeyField = this.uniqueKeyField;
        newSchema.uniqueKeyFieldName = this.uniqueKeyFieldName;
        newSchema.uniqueKeyFieldType = this.uniqueKeyFieldType;
        newSchema.resourceName = this.managedSchemaResourceName;
        if (includeFieldDataStructures) {
            newSchema.fields.putAll(this.fields);
            newSchema.fieldsWithDefaultValue.addAll(this.fieldsWithDefaultValue);
            newSchema.requiredFields.addAll(this.requiredFields);
        }
        newSchema.fieldTypes = this.fieldTypes;
        newSchema.dynamicFields = this.dynamicFields;
        newSchema.dynamicCopyFields = this.dynamicCopyFields;
        newSchema.copyFieldsMap = this.copyFieldsMap;
        newSchema.copyFieldTargetCounts = this.copyFieldTargetCounts;
        newSchema.schemaAware = this.schemaAware;
        return newSchema;
    }

    @Override
    public Object getSchemaUpdateLock() {
        return this.schemaUpdateLock;
    }

    public class SchemaChangedInZkException
    extends SolrException {
        public SchemaChangedInZkException(SolrException.ErrorCode code, String msg) {
            super(code, msg);
        }
    }

    public class FieldExistsException
    extends SolrException {
        public FieldExistsException(SolrException.ErrorCode code, String msg) {
            super(code, msg);
        }
    }
}

