/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.solr.update.processor.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Signature
extends Signature {
    protected static final Logger log = LoggerFactory.getLogger(MD5Signature.class);
    private static ThreadLocal<MessageDigest> DIGESTER_FACTORY = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private MessageDigest digester = DIGESTER_FACTORY.get();

    public MD5Signature() {
        this.digester.reset();
    }

    @Override
    public void add(String content) {
        this.digester.update(content.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte[] getSignature() {
        return this.digester.digest();
    }
}

