/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.png;

import com.drew.imaging.png.PngChromaticities;
import com.drew.imaging.png.PngChunk;
import com.drew.imaging.png.PngChunkReader;
import com.drew.imaging.png.PngChunkType;
import com.drew.imaging.png.PngHeader;
import com.drew.imaging.png.PngProcessingException;
import com.drew.lang.KeyValuePair;
import com.drew.lang.RandomAccessStreamReader;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.StreamReader;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.png.PngChromaticitiesDirectory;
import com.drew.metadata.png.PngDirectory;
import com.drew.metadata.xmp.XmpReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.zip.InflaterInputStream;

public class PngMetadataReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws PngProcessingException, IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Metadata metadata = PngMetadataReader.readMetadata(fileInputStream);
            return metadata;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws PngProcessingException, IOException {
        HashSet<PngChunkType> hashSet = new HashSet<PngChunkType>();
        hashSet.add(PngChunkType.IHDR);
        hashSet.add(PngChunkType.PLTE);
        hashSet.add(PngChunkType.tRNS);
        hashSet.add(PngChunkType.cHRM);
        hashSet.add(PngChunkType.sRGB);
        hashSet.add(PngChunkType.gAMA);
        hashSet.add(PngChunkType.iCCP);
        hashSet.add(PngChunkType.bKGD);
        hashSet.add(PngChunkType.tEXt);
        hashSet.add(PngChunkType.iTXt);
        hashSet.add(PngChunkType.tIME);
        Iterable<PngChunk> iterable = new PngChunkReader().extract(new StreamReader(inputStream), hashSet);
        Metadata metadata = new Metadata();
        ArrayList<KeyValuePair> arrayList = new ArrayList<KeyValuePair>();
        for (PngChunk pngChunk : iterable) {
            Object object;
            int n;
            short s;
            PngChunkType pngChunkType = pngChunk.getType();
            byte[] byArray = pngChunk.getBytes();
            if (pngChunkType.equals(PngChunkType.IHDR)) {
                PngHeader pngHeader = new PngHeader(byArray);
                PngDirectory pngDirectory = metadata.getOrCreateDirectory(PngDirectory.class);
                pngDirectory.setInt(1, pngHeader.getImageWidth());
                pngDirectory.setInt(2, pngHeader.getImageHeight());
                pngDirectory.setInt(3, pngHeader.getBitsPerSample());
                pngDirectory.setInt(4, pngHeader.getColorType().getNumericValue());
                pngDirectory.setInt(5, pngHeader.getCompressionType());
                pngDirectory.setInt(6, pngHeader.getFilterMethod());
                pngDirectory.setInt(7, pngHeader.getInterlaceMethod());
                continue;
            }
            if (pngChunkType.equals(PngChunkType.PLTE)) {
                PngDirectory pngDirectory = metadata.getOrCreateDirectory(PngDirectory.class);
                pngDirectory.setInt(8, byArray.length / 3);
                continue;
            }
            if (pngChunkType.equals(PngChunkType.tRNS)) {
                PngDirectory pngDirectory = metadata.getOrCreateDirectory(PngDirectory.class);
                pngDirectory.setInt(9, 1);
                continue;
            }
            if (pngChunkType.equals(PngChunkType.sRGB)) {
                byte by = new SequentialByteArrayReader(byArray).getInt8();
                PngDirectory pngDirectory = metadata.getOrCreateDirectory(PngDirectory.class);
                pngDirectory.setInt(10, by);
                continue;
            }
            if (pngChunkType.equals(PngChunkType.cHRM)) {
                PngChromaticities pngChromaticities = new PngChromaticities(byArray);
                PngChromaticitiesDirectory pngChromaticitiesDirectory = metadata.getOrCreateDirectory(PngChromaticitiesDirectory.class);
                pngChromaticitiesDirectory.setInt(1, pngChromaticities.getWhitePointX());
                pngChromaticitiesDirectory.setInt(1, pngChromaticities.getWhitePointX());
                pngChromaticitiesDirectory.setInt(3, pngChromaticities.getRedX());
                pngChromaticitiesDirectory.setInt(4, pngChromaticities.getRedY());
                pngChromaticitiesDirectory.setInt(5, pngChromaticities.getGreenX());
                pngChromaticitiesDirectory.setInt(6, pngChromaticities.getGreenY());
                pngChromaticitiesDirectory.setInt(7, pngChromaticities.getBlueX());
                pngChromaticitiesDirectory.setInt(8, pngChromaticities.getBlueY());
                continue;
            }
            if (pngChunkType.equals(PngChunkType.gAMA)) {
                int n2 = new SequentialByteArrayReader(byArray).getInt32();
                PngDirectory pngDirectory = metadata.getOrCreateDirectory(PngDirectory.class);
                pngDirectory.setDouble(11, (double)n2 / 100000.0);
                continue;
            }
            if (pngChunkType.equals(PngChunkType.iCCP)) {
                SequentialByteArrayReader sequentialByteArrayReader = new SequentialByteArrayReader(byArray);
                String string = sequentialByteArrayReader.getNullTerminatedString(79);
                PngDirectory pngDirectory = metadata.getOrCreateDirectory(PngDirectory.class);
                pngDirectory.setString(12, string);
                s = sequentialByteArrayReader.getInt8();
                if (s != 0) continue;
                n = byArray.length - string.length() - 2;
                byte[] byArray2 = ((SequentialReader)sequentialByteArrayReader).getBytes(n);
                InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray2));
                new IccReader().extract(new RandomAccessStreamReader(inflaterInputStream), metadata);
                inflaterInputStream.close();
                continue;
            }
            if (pngChunkType.equals(PngChunkType.bKGD)) {
                PngDirectory pngDirectory = metadata.getOrCreateDirectory(PngDirectory.class);
                pngDirectory.setByteArray(15, byArray);
                continue;
            }
            if (pngChunkType.equals(PngChunkType.tEXt)) {
                SequentialByteArrayReader sequentialByteArrayReader = new SequentialByteArrayReader(byArray);
                String string = sequentialByteArrayReader.getNullTerminatedString(79);
                int n3 = byArray.length - string.length() - 1;
                String string2 = sequentialByteArrayReader.getNullTerminatedString(n3);
                arrayList.add(new KeyValuePair(string, string2));
                continue;
            }
            if (pngChunkType.equals(PngChunkType.iTXt)) {
                SequentialByteArrayReader sequentialByteArrayReader = new SequentialByteArrayReader(byArray);
                String string = sequentialByteArrayReader.getNullTerminatedString(79);
                byte by = sequentialByteArrayReader.getInt8();
                s = sequentialByteArrayReader.getInt8();
                String string3 = sequentialByteArrayReader.getNullTerminatedString(byArray.length);
                String string4 = sequentialByteArrayReader.getNullTerminatedString(byArray.length);
                int n4 = byArray.length - string.length() - 1 - 1 - 1 - string3.length() - 1 - string4.length() - 1;
                object = null;
                if (by == 0) {
                    object = sequentialByteArrayReader.getNullTerminatedString(n4);
                } else if (by == 1) {
                    if (s == 0) {
                        object = StringUtil.fromStream(new InflaterInputStream(new ByteArrayInputStream(byArray, byArray.length - n4, n4)));
                    } else {
                        metadata.getOrCreateDirectory(PngDirectory.class).addError("Invalid compression method value");
                    }
                } else {
                    metadata.getOrCreateDirectory(PngDirectory.class).addError("Invalid compression flag value");
                }
                if (object == null) continue;
                if (string.equals("XML:com.adobe.xmp")) {
                    new XmpReader().extract((String)object, metadata);
                    continue;
                }
                arrayList.add(new KeyValuePair(string, (String)object));
                continue;
            }
            if (!pngChunkType.equals(PngChunkType.tIME)) continue;
            SequentialByteArrayReader sequentialByteArrayReader = new SequentialByteArrayReader(byArray);
            int n5 = sequentialByteArrayReader.getUInt16();
            int n6 = sequentialByteArrayReader.getUInt8() - 1;
            s = sequentialByteArrayReader.getUInt8();
            n = sequentialByteArrayReader.getUInt8();
            short s2 = sequentialByteArrayReader.getUInt8();
            short s3 = sequentialByteArrayReader.getUInt8();
            object = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            ((Calendar)object).set(n5, n6, s, n, s2, s3);
            PngDirectory pngDirectory = metadata.getOrCreateDirectory(PngDirectory.class);
            pngDirectory.setDate(14, ((Calendar)object).getTime());
        }
        if (arrayList.size() != 0) {
            PngDirectory pngDirectory = metadata.getOrCreateDirectory(PngDirectory.class);
            pngDirectory.setObject(13, arrayList);
        }
        return metadata;
    }
}

