/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Metadata {
    @NotNull
    private final Map<Class<? extends Directory>, Directory> _directoryByClass = new HashMap<Class<? extends Directory>, Directory>();
    @NotNull
    private final Collection<Directory> _directoryList = new ArrayList<Directory>();

    @NotNull
    public Iterable<Directory> getDirectories() {
        return Collections.unmodifiableCollection(this._directoryList);
    }

    public int getDirectoryCount() {
        return this._directoryList.size();
    }

    @NotNull
    public <T extends Directory> T getOrCreateDirectory(@NotNull Class<T> clazz) {
        Directory directory;
        if (this._directoryByClass.containsKey(clazz)) {
            return (T)this._directoryByClass.get(clazz);
        }
        try {
            directory = (Directory)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot instantiate provided Directory type: " + clazz.toString());
        }
        this._directoryByClass.put(clazz, directory);
        this._directoryList.add(directory);
        return (T)directory;
    }

    @Nullable
    public <T extends Directory> T getDirectory(@NotNull Class<T> clazz) {
        return (T)this._directoryByClass.get(clazz);
    }

    public boolean containsDirectory(Class<? extends Directory> clazz) {
        return this._directoryByClass.containsKey(clazz);
    }

    public boolean hasErrors() {
        for (Directory directory : this._directoryList) {
            if (!directory.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("Metadata (%d %s)", this._directoryList.size(), this._directoryList.size() == 1 ? "directory" : "directories");
    }
}

