/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.bmp;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.bmp.BmpHeaderDirectory;
import java.io.IOException;

public class BmpReader {
    public void extract(@NotNull SequentialReader sequentialReader, @NotNull Metadata metadata) {
        BmpHeaderDirectory bmpHeaderDirectory = metadata.getOrCreateDirectory(BmpHeaderDirectory.class);
        sequentialReader.setMotorolaByteOrder(false);
        try {
            int n = sequentialReader.getUInt16();
            if (n != 19778) {
                bmpHeaderDirectory.addError("Invalid BMP magic number");
                return;
            }
            sequentialReader.skip(12L);
            int n2 = sequentialReader.getInt32();
            bmpHeaderDirectory.setInt(-1, n2);
            if (n2 == 40) {
                bmpHeaderDirectory.setInt(2, sequentialReader.getInt32());
                bmpHeaderDirectory.setInt(1, sequentialReader.getInt32());
                bmpHeaderDirectory.setInt(3, sequentialReader.getInt16());
                bmpHeaderDirectory.setInt(4, sequentialReader.getInt16());
                bmpHeaderDirectory.setInt(5, sequentialReader.getInt32());
                sequentialReader.skip(4L);
                bmpHeaderDirectory.setInt(6, sequentialReader.getInt32());
                bmpHeaderDirectory.setInt(7, sequentialReader.getInt32());
                bmpHeaderDirectory.setInt(8, sequentialReader.getInt32());
                bmpHeaderDirectory.setInt(9, sequentialReader.getInt32());
            } else if (n2 == 12) {
                bmpHeaderDirectory.setInt(2, sequentialReader.getInt16());
                bmpHeaderDirectory.setInt(1, sequentialReader.getInt16());
                bmpHeaderDirectory.setInt(3, sequentialReader.getInt16());
                bmpHeaderDirectory.setInt(4, sequentialReader.getInt16());
            } else {
                bmpHeaderDirectory.addError("Unexpected DIB header size: " + n2);
            }
        }
        catch (IOException iOException) {
            bmpHeaderDirectory.addError("Unable to read BMP header");
        }
    }
}

