/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.imaging.tiff.TiffReader;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.Rational;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifInteropDirectory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import com.drew.metadata.exif.ExifTiffHandler;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.exif.makernotes.CanonMakernoteDirectory;
import com.drew.metadata.exif.makernotes.CasioType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.CasioType2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.FujifilmMakernoteDirectory;
import com.drew.metadata.exif.makernotes.KodakMakernoteDirectory;
import com.drew.metadata.exif.makernotes.KyoceraMakernoteDirectory;
import com.drew.metadata.exif.makernotes.LeicaMakernoteDirectory;
import com.drew.metadata.exif.makernotes.NikonType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.NikonType2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusMakernoteDirectory;
import com.drew.metadata.exif.makernotes.PanasonicMakernoteDirectory;
import com.drew.metadata.exif.makernotes.PentaxMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SanyoMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SigmaMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SonyType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.SonyType6MakernoteDirectory;
import com.drew.metadata.iptc.IptcReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifReader
implements JpegSegmentMetadataReader {
    @NotNull
    private static final int[] BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int MAX_FORMAT_CODE = 12;
    private static final int FMT_BYTE = 1;
    private static final int FMT_STRING = 2;
    private static final int FMT_USHORT = 3;
    private static final int FMT_ULONG = 4;
    private static final int FMT_URATIONAL = 5;
    private static final int FMT_SBYTE = 6;
    private static final int FMT_UNDEFINED = 7;
    private static final int FMT_SSHORT = 8;
    private static final int FMT_SLONG = 9;
    private static final int FMT_SRATIONAL = 10;
    private static final int FMT_SINGLE = 11;
    private static final int FMT_DOUBLE = 12;
    private static final String JPEG_EXIF_SEGMENT_PREAMBLE = "Exif\u0000\u0000";
    private boolean _storeThumbnailBytes = true;

    public boolean isStoreThumbnailBytes() {
        return this._storeThumbnailBytes;
    }

    public void setStoreThumbnailBytes(boolean bl) {
        this._storeThumbnailBytes = bl;
    }

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APP1);
    }

    @Override
    public boolean canProcess(@NotNull byte[] byArray, @NotNull JpegSegmentType jpegSegmentType) {
        return byArray.length >= JPEG_EXIF_SEGMENT_PREAMBLE.length() && new String(byArray, 0, JPEG_EXIF_SEGMENT_PREAMBLE.length()).equalsIgnoreCase(JPEG_EXIF_SEGMENT_PREAMBLE);
    }

    @Override
    public void extract(@NotNull byte[] byArray, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        if (byArray == null) {
            throw new NullPointerException("segmentBytes cannot be null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata cannot be null");
        }
        if (jpegSegmentType == null) {
            throw new NullPointerException("segmentType cannot be null");
        }
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            try {
                if (!byteArrayReader.getString(0, JPEG_EXIF_SEGMENT_PREAMBLE.length()).equals(JPEG_EXIF_SEGMENT_PREAMBLE)) {
                    System.err.println("Invalid JPEG Exif segment preamble");
                    return;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                return;
            }
            new TiffReader().processTiff(byteArrayReader, new ExifTiffHandler(metadata, this._storeThumbnailBytes), JPEG_EXIF_SEGMENT_PREAMBLE.length());
        }
        catch (TiffProcessingException tiffProcessingException) {
            tiffProcessingException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    @Deprecated
    public void extractTiff(@NotNull RandomAccessReader randomAccessReader, @NotNull Metadata metadata) {
        ExifIFD0Directory exifIFD0Directory = metadata.getOrCreateDirectory(ExifIFD0Directory.class);
        try {
            ExifReader.extractTiff(randomAccessReader, metadata, exifIFD0Directory, 0);
        }
        catch (IOException iOException) {
            exifIFD0Directory.addError("IO problem: " + iOException.getMessage());
        }
    }

    @Deprecated
    private static void extractTiff(@NotNull RandomAccessReader randomAccessReader, @NotNull Metadata metadata, @NotNull Directory directory, int n) throws IOException {
        String string = randomAccessReader.getString(n, 2);
        if ("MM".equals(string)) {
            randomAccessReader.setMotorolaByteOrder(true);
        } else if ("II".equals(string)) {
            randomAccessReader.setMotorolaByteOrder(false);
        } else {
            directory.addError("Unclear distinction between Motorola/Intel byte ordering: " + string);
            return;
        }
        int n2 = randomAccessReader.getUInt16(2 + n);
        if (n2 != 42 && n2 != 20306 && n2 != 85) {
            directory.addError("Unexpected TIFF marker after byte order identifier: 0x" + Integer.toHexString(n2));
            return;
        }
        int n3 = randomAccessReader.getInt32(4 + n) + n;
        if ((long)n3 >= randomAccessReader.getLength() - 1L) {
            directory.addError("First Exif directory offset is beyond end of Exif data segment");
            n3 = 14;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ExifReader.processIFD(directory, hashSet, n3, n, metadata, randomAccessReader);
        ExifThumbnailDirectory exifThumbnailDirectory = metadata.getDirectory(ExifThumbnailDirectory.class);
        if (exifThumbnailDirectory != null && exifThumbnailDirectory.containsTag(259)) {
            Integer n4 = exifThumbnailDirectory.getInteger(513);
            Integer n5 = exifThumbnailDirectory.getInteger(514);
            if (n4 != null && n5 != null) {
                try {
                    byte[] byArray = randomAccessReader.getBytes(n + n4, n5);
                    exifThumbnailDirectory.setThumbnailData(byArray);
                }
                catch (IOException iOException) {
                    directory.addError("Invalid thumbnail data specification: " + iOException.getMessage());
                }
            }
        }
    }

    @Deprecated
    private static void processIFD(@NotNull Directory directory, @NotNull Set<Integer> set, int n, int n2, @NotNull Metadata metadata, @NotNull RandomAccessReader randomAccessReader) throws IOException {
        int n3;
        int n4;
        if (set.contains(n)) {
            return;
        }
        set.add(n);
        if ((long)n >= randomAccessReader.getLength() || n < 0) {
            directory.addError("Ignored IFD marked to start outside data segment");
            return;
        }
        int n5 = randomAccessReader.getUInt16(n);
        int n6 = 2 + 12 * n5 + 4;
        if ((long)(n6 + n) > randomAccessReader.getLength()) {
            directory.addError("Illegally sized IFD");
            return;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            int n7;
            int n8;
            n3 = ExifReader.calculateTagOffset(n, n4);
            int n9 = randomAccessReader.getUInt16(n3);
            int n10 = randomAccessReader.getUInt16(n3 + 2);
            if (n10 < 1 || n10 > 12) {
                directory.addError("Invalid TIFF tag format code: " + n10);
                return;
            }
            int n11 = randomAccessReader.getInt32(n3 + 4);
            if (n11 < 0) {
                directory.addError("Negative TIFF tag component count");
                continue;
            }
            int n12 = n11 * BYTES_PER_FORMAT[n10];
            if (n12 > 4) {
                n8 = randomAccessReader.getInt32(n3 + 8);
                if ((long)(n8 + n12) > randomAccessReader.getLength()) {
                    directory.addError("Illegal TIFF tag pointer offset");
                    continue;
                }
                n7 = n2 + n8;
            } else {
                n7 = n3 + 8;
            }
            if (n7 < 0 || (long)n7 > randomAccessReader.getLength()) {
                directory.addError("Illegal TIFF tag pointer offset");
                continue;
            }
            if (n12 < 0 || (long)(n7 + n12) > randomAccessReader.getLength()) {
                directory.addError("Illegal number of bytes for TIFF tag data: " + n12);
                continue;
            }
            if (n9 == 34665 && directory instanceof ExifIFD0Directory) {
                if (n12 != 4) {
                    directory.addError("Exif SubIFD Offset tag should have a component count of four (bytes) for the offset.");
                    continue;
                }
                n8 = n2 + randomAccessReader.getInt32(n7);
                ExifReader.processIFD(metadata.getOrCreateDirectory(ExifSubIFDDirectory.class), set, n8, n2, metadata, randomAccessReader);
                continue;
            }
            if (n9 == 40965 && directory instanceof ExifSubIFDDirectory) {
                if (n12 != 4) {
                    directory.addError("Exif Interop Offset tag should have a component count of four (bytes) for the offset.");
                    continue;
                }
                n8 = n2 + randomAccessReader.getInt32(n7);
                ExifReader.processIFD(metadata.getOrCreateDirectory(ExifInteropDirectory.class), set, n8, n2, metadata, randomAccessReader);
                continue;
            }
            if (n9 == 34853 && directory instanceof ExifIFD0Directory) {
                if (n12 != 4) {
                    directory.addError("Exif GPS Info Offset tag should have a component count of four (bytes) for the offset.");
                    continue;
                }
                n8 = n2 + randomAccessReader.getInt32(n7);
                ExifReader.processIFD(metadata.getOrCreateDirectory(GpsDirectory.class), set, n8, n2, metadata, randomAccessReader);
                continue;
            }
            if (n9 == 37500 && directory instanceof ExifSubIFDDirectory) {
                ExifReader.processMakernote(n7, set, n2, metadata, randomAccessReader);
                continue;
            }
            if (n9 == 33723 && directory instanceof ExifIFD0Directory) {
                byte[] byArray = randomAccessReader.getBytes(n7, n12);
                new IptcReader().extract(new SequentialByteArrayReader(byArray), metadata, byArray.length);
                continue;
            }
            ExifReader.processTag(directory, n9, n7, n11, n10, randomAccessReader);
        }
        n4 = ExifReader.calculateTagOffset(n, n5);
        n3 = randomAccessReader.getInt32(n4);
        if (n3 != 0) {
            if ((long)(n3 += n2) >= randomAccessReader.getLength()) {
                return;
            }
            if (n3 < n) {
                return;
            }
            ExifThumbnailDirectory exifThumbnailDirectory = metadata.getOrCreateDirectory(ExifThumbnailDirectory.class);
            ExifReader.processIFD(exifThumbnailDirectory, set, n3, n2, metadata, randomAccessReader);
        }
    }

    @Deprecated
    private static void processMakernote(int n, @NotNull Set<Integer> set, int n2, @NotNull Metadata metadata, @NotNull RandomAccessReader randomAccessReader) throws IOException {
        ExifIFD0Directory exifIFD0Directory = metadata.getDirectory(ExifIFD0Directory.class);
        if (exifIFD0Directory == null) {
            return;
        }
        String string = exifIFD0Directory.getString(271);
        String string2 = randomAccessReader.getString(n, 3);
        String string3 = randomAccessReader.getString(n, 4);
        String string4 = randomAccessReader.getString(n, 5);
        String string5 = randomAccessReader.getString(n, 6);
        String string6 = randomAccessReader.getString(n, 7);
        String string7 = randomAccessReader.getString(n, 8);
        String string8 = randomAccessReader.getString(n, 12);
        boolean bl = randomAccessReader.isMotorolaByteOrder();
        if ("OLYMP".equals(string4) || "EPSON".equals(string4) || "AGFA".equals(string3)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(OlympusMakernoteDirectory.class), set, n + 8, n2, metadata, randomAccessReader);
        } else if (string != null && string.trim().toUpperCase().startsWith("NIKON")) {
            if ("Nikon".equals(string4)) {
                switch (randomAccessReader.getUInt8(n + 6)) {
                    case 1: {
                        ExifReader.processIFD(metadata.getOrCreateDirectory(NikonType1MakernoteDirectory.class), set, n + 8, n2, metadata, randomAccessReader);
                        break;
                    }
                    case 2: {
                        ExifReader.processIFD(metadata.getOrCreateDirectory(NikonType2MakernoteDirectory.class), set, n + 18, n + 10, metadata, randomAccessReader);
                        break;
                    }
                    default: {
                        exifIFD0Directory.addError("Unsupported Nikon makernote data ignored.");
                        break;
                    }
                }
            } else {
                ExifReader.processIFD(metadata.getOrCreateDirectory(NikonType2MakernoteDirectory.class), set, n, n2, metadata, randomAccessReader);
            }
        } else if ("SONY CAM".equals(string7) || "SONY DSC".equals(string7)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(SonyType1MakernoteDirectory.class), set, n + 12, n2, metadata, randomAccessReader);
        } else if ("SEMC MS\u0000\u0000\u0000\u0000\u0000".equals(string8)) {
            randomAccessReader.setMotorolaByteOrder(true);
            ExifReader.processIFD(metadata.getOrCreateDirectory(SonyType6MakernoteDirectory.class), set, n + 20, n2, metadata, randomAccessReader);
        } else if ("SIGMA\u0000\u0000\u0000".equals(string7) || "FOVEON\u0000\u0000".equals(string7)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(SigmaMakernoteDirectory.class), set, n + 10, n2, metadata, randomAccessReader);
        } else if ("KDK".equals(string2)) {
            randomAccessReader.setMotorolaByteOrder(string6.equals("KDK INFO"));
            ExifReader.processKodakMakernote(metadata.getOrCreateDirectory(KodakMakernoteDirectory.class), n, randomAccessReader);
        } else if ("Canon".equalsIgnoreCase(string)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(CanonMakernoteDirectory.class), set, n, n2, metadata, randomAccessReader);
        } else if (string != null && string.toUpperCase().startsWith("CASIO")) {
            if ("QVC\u0000\u0000\u0000".equals(string5)) {
                ExifReader.processIFD(metadata.getOrCreateDirectory(CasioType2MakernoteDirectory.class), set, n + 6, n2, metadata, randomAccessReader);
            } else {
                ExifReader.processIFD(metadata.getOrCreateDirectory(CasioType1MakernoteDirectory.class), set, n, n2, metadata, randomAccessReader);
            }
        } else if ("FUJIFILM".equals(string7) || "Fujifilm".equalsIgnoreCase(string)) {
            randomAccessReader.setMotorolaByteOrder(false);
            int n3 = n + randomAccessReader.getInt32(n + 8);
            ExifReader.processIFD(metadata.getOrCreateDirectory(FujifilmMakernoteDirectory.class), set, n3, n, metadata, randomAccessReader);
        } else if (string != null && string.toUpperCase().startsWith("MINOLTA")) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(OlympusMakernoteDirectory.class), set, n, n2, metadata, randomAccessReader);
        } else if ("KYOCERA".equals(string6)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(KyoceraMakernoteDirectory.class), set, n + 22, n2, metadata, randomAccessReader);
        } else if ("LEICA".equals(string4)) {
            randomAccessReader.setMotorolaByteOrder(false);
            if ("Leica Camera AG".equals(string)) {
                ExifReader.processIFD(metadata.getOrCreateDirectory(LeicaMakernoteDirectory.class), set, n + 8, n2, metadata, randomAccessReader);
            } else if ("LEICA".equals(string)) {
                ExifReader.processIFD(metadata.getOrCreateDirectory(PanasonicMakernoteDirectory.class), set, n + 8, n2, metadata, randomAccessReader);
            }
        } else if ("Panasonic\u0000\u0000\u0000".equals(randomAccessReader.getString(n, 12))) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(PanasonicMakernoteDirectory.class), set, n + 12, n2, metadata, randomAccessReader);
        } else if ("AOC\u0000".equals(string3)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(CasioType2MakernoteDirectory.class), set, n + 6, n, metadata, randomAccessReader);
        } else if (string != null && (string.toUpperCase().startsWith("PENTAX") || string.toUpperCase().startsWith("ASAHI"))) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(PentaxMakernoteDirectory.class), set, n, n, metadata, randomAccessReader);
        } else if ("SANYO\u0000\u0001\u0000".equals(string7)) {
            ExifReader.processIFD(metadata.getOrCreateDirectory(SanyoMakernoteDirectory.class), set, n + 8, n, metadata, randomAccessReader);
        }
        randomAccessReader.setMotorolaByteOrder(bl);
    }

    @Deprecated
    private static void processKodakMakernote(@NotNull KodakMakernoteDirectory kodakMakernoteDirectory, int n, @NotNull RandomAccessReader randomAccessReader) {
        int n2 = n + 8;
        try {
            kodakMakernoteDirectory.setString(0, randomAccessReader.getString(n2, 8));
            kodakMakernoteDirectory.setInt(9, randomAccessReader.getUInt8(n2 + 9));
            kodakMakernoteDirectory.setInt(10, randomAccessReader.getUInt8(n2 + 10));
            kodakMakernoteDirectory.setInt(12, randomAccessReader.getUInt16(n2 + 12));
            kodakMakernoteDirectory.setInt(14, randomAccessReader.getUInt16(n2 + 14));
            kodakMakernoteDirectory.setInt(16, randomAccessReader.getUInt16(n2 + 16));
            kodakMakernoteDirectory.setByteArray(18, randomAccessReader.getBytes(n2 + 18, 2));
            kodakMakernoteDirectory.setByteArray(20, randomAccessReader.getBytes(n2 + 20, 4));
            kodakMakernoteDirectory.setInt(24, randomAccessReader.getUInt16(n2 + 24));
            kodakMakernoteDirectory.setInt(27, randomAccessReader.getUInt8(n2 + 27));
            kodakMakernoteDirectory.setInt(28, randomAccessReader.getUInt8(n2 + 28));
            kodakMakernoteDirectory.setInt(29, randomAccessReader.getUInt8(n2 + 29));
            kodakMakernoteDirectory.setInt(30, randomAccessReader.getUInt16(n2 + 30));
            kodakMakernoteDirectory.setLong(32, randomAccessReader.getUInt32(n2 + 32));
            kodakMakernoteDirectory.setInt(36, randomAccessReader.getInt16(n2 + 36));
            kodakMakernoteDirectory.setInt(56, randomAccessReader.getUInt8(n2 + 56));
            kodakMakernoteDirectory.setInt(64, randomAccessReader.getUInt8(n2 + 64));
            kodakMakernoteDirectory.setInt(92, randomAccessReader.getUInt8(n2 + 92));
            kodakMakernoteDirectory.setInt(93, randomAccessReader.getUInt8(n2 + 93));
            kodakMakernoteDirectory.setInt(94, randomAccessReader.getUInt16(n2 + 94));
            kodakMakernoteDirectory.setInt(96, randomAccessReader.getUInt16(n2 + 96));
            kodakMakernoteDirectory.setInt(98, randomAccessReader.getUInt16(n2 + 98));
            kodakMakernoteDirectory.setInt(100, randomAccessReader.getUInt16(n2 + 100));
            kodakMakernoteDirectory.setInt(102, randomAccessReader.getUInt16(n2 + 102));
            kodakMakernoteDirectory.setInt(104, randomAccessReader.getUInt16(n2 + 104));
            kodakMakernoteDirectory.setInt(107, randomAccessReader.getInt8(n2 + 107));
        }
        catch (IOException iOException) {
            kodakMakernoteDirectory.addError("Error processing Kodak makernote data: " + iOException.getMessage());
        }
    }

    @Deprecated
    private static void processTag(@NotNull Directory directory, int n, int n2, int n3, int n4, @NotNull RandomAccessReader randomAccessReader) throws IOException {
        switch (n4) {
            case 7: {
                directory.setByteArray(n, randomAccessReader.getBytes(n2, n3));
                break;
            }
            case 2: {
                String string = randomAccessReader.getNullTerminatedString(n2, n3);
                directory.setString(n, string);
                break;
            }
            case 10: {
                if (n3 == 1) {
                    directory.setRational(n, new Rational(randomAccessReader.getInt32(n2), randomAccessReader.getInt32(n2 + 4)));
                    break;
                }
                if (n3 <= 1) break;
                Rational[] rationalArray = new Rational[n3];
                for (int i = 0; i < n3; ++i) {
                    rationalArray[i] = new Rational(randomAccessReader.getInt32(n2 + 8 * i), randomAccessReader.getInt32(n2 + 4 + 8 * i));
                }
                directory.setRationalArray(n, rationalArray);
                break;
            }
            case 5: {
                if (n3 == 1) {
                    directory.setRational(n, new Rational(randomAccessReader.getUInt32(n2), randomAccessReader.getUInt32(n2 + 4)));
                    break;
                }
                if (n3 <= 1) break;
                Rational[] rationalArray = new Rational[n3];
                for (int i = 0; i < n3; ++i) {
                    rationalArray[i] = new Rational(randomAccessReader.getUInt32(n2 + 8 * i), randomAccessReader.getUInt32(n2 + 4 + 8 * i));
                }
                directory.setRationalArray(n, rationalArray);
                break;
            }
            case 11: {
                if (n3 == 1) {
                    directory.setFloat(n, randomAccessReader.getFloat32(n2));
                    break;
                }
                float[] fArray = new float[n3];
                for (int i = 0; i < n3; ++i) {
                    fArray[i] = randomAccessReader.getFloat32(n2 + i * 4);
                }
                directory.setFloatArray(n, fArray);
                break;
            }
            case 12: {
                if (n3 == 1) {
                    directory.setDouble(n, randomAccessReader.getDouble64(n2));
                    break;
                }
                double[] dArray = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    dArray[i] = randomAccessReader.getDouble64(n2 + i * 4);
                }
                directory.setDoubleArray(n, dArray);
                break;
            }
            case 6: {
                if (n3 == 1) {
                    directory.setInt(n, randomAccessReader.getInt8(n2));
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = randomAccessReader.getInt8(n2 + i);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 1: {
                if (n3 == 1) {
                    directory.setInt(n, randomAccessReader.getUInt8(n2));
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = randomAccessReader.getUInt8(n2 + i);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 3: {
                if (n3 == 1) {
                    int n5 = randomAccessReader.getUInt16(n2);
                    directory.setInt(n, n5);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = randomAccessReader.getUInt16(n2 + i * 2);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 8: {
                if (n3 == 1) {
                    short s = randomAccessReader.getInt16(n2);
                    directory.setInt(n, s);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = randomAccessReader.getInt16(n2 + i * 2);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 4: 
            case 9: {
                if (n3 == 1) {
                    int n6 = randomAccessReader.getInt32(n2);
                    directory.setInt(n, n6);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = randomAccessReader.getInt32(n2 + i * 4);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            default: {
                directory.addError("Unknown format code " + n4 + " for tag " + n);
            }
        }
    }

    @Deprecated
    private static int calculateTagOffset(int n, int n2) {
        return n + 2 + 12 * n2;
    }
}

