/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.SigmaMakernoteDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigmaMakernoteDescriptor
extends TagDescriptor<SigmaMakernoteDirectory> {
    public SigmaMakernoteDescriptor(@NotNull SigmaMakernoteDirectory sigmaMakernoteDirectory) {
        super(sigmaMakernoteDirectory);
    }

    @Override
    public String getDescription(int n) {
        switch (n) {
            case 8: {
                return this.getExposureModeDescription();
            }
            case 9: {
                return this.getMeteringModeDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    private String getMeteringModeDescription() {
        String string = ((SigmaMakernoteDirectory)this._directory).getString(9);
        if (string == null || string.length() == 0) {
            return null;
        }
        switch (string.charAt(0)) {
            case '8': {
                return "Multi Segment";
            }
            case 'A': {
                return "Average";
            }
            case 'C': {
                return "Center Weighted Average";
            }
        }
        return string;
    }

    @Nullable
    private String getExposureModeDescription() {
        String string = ((SigmaMakernoteDirectory)this._directory).getString(8);
        if (string == null || string.length() == 0) {
            return null;
        }
        switch (string.charAt(0)) {
            case 'A': {
                return "Aperture Priority AE";
            }
            case 'M': {
                return "Manual";
            }
            case 'P': {
                return "Program AE";
            }
            case 'S': {
                return "Shutter Speed Priority AE";
            }
        }
        return string;
    }
}

