/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.photoshop.PhotoshopDirectory;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotoshopDescriptor
extends TagDescriptor<PhotoshopDirectory> {
    public PhotoshopDescriptor(@NotNull PhotoshopDirectory photoshopDirectory) {
        super(photoshopDirectory);
    }

    @Override
    public String getDescription(int n) {
        switch (n) {
            case 1033: 
            case 1036: {
                return this.getThumbnailDescription(n);
            }
            case 1002: 
            case 1035: {
                return this.getSimpleString(n);
            }
            case 1028: {
                return this.getBinaryDataString(n);
            }
            case 1050: {
                return this.getSlicesDescription();
            }
            case 1057: {
                return this.getVersionDescription();
            }
            case 1034: {
                return this.getBooleanString(n);
            }
            case 1005: {
                return this.getResolutionInfoDescription();
            }
            case 1037: 
            case 1044: 
            case 1049: 
            case 1054: {
                return this.get32BitNumberString(n);
            }
            case 1030: {
                return this.getJpegQualityString();
            }
            case 1062: {
                return this.getPrintScaleDescription();
            }
            case 1064: {
                return this.getPixelAspectRatioString();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getJpegQualityString() {
        try {
            String string;
            String string2;
            byte[] byArray = ((PhotoshopDirectory)this._directory).getByteArray(1030);
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            int n = byteArrayReader.getUInt16(0);
            int n2 = byteArrayReader.getUInt16(2);
            int n3 = byteArrayReader.getUInt16(4);
            int n4 = n <= 65535 && n >= 65533 ? n - 65532 : (n <= 8 ? n + 4 : n);
            switch (n) {
                case 0: 
                case 65533: 
                case 65534: 
                case 65535: {
                    string2 = "Low";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string2 = "Medium";
                    break;
                }
                case 4: 
                case 5: {
                    string2 = "High";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    string2 = "Maximum";
                    break;
                }
                default: {
                    string2 = "Unknown";
                }
            }
            switch (n2) {
                case 0: {
                    string = "Standard";
                    break;
                }
                case 1: {
                    string = "Optimised";
                    break;
                }
                case 257: {
                    string = "Progressive ";
                    break;
                }
                default: {
                    string = String.format("Unknown 0x%04X", n2);
                }
            }
            String string3 = n3 >= 1 && n3 <= 3 ? String.format("%d", n3 + 2) : String.format("Unknown 0x%04X", n3);
            return String.format("%d (%s), %s format, %s scans", n4, string2, string, string3);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    public String getPixelAspectRatioString() {
        try {
            byte[] byArray = ((PhotoshopDirectory)this._directory).getByteArray(1064);
            if (byArray == null) {
                return null;
            }
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            double d = byteArrayReader.getDouble64(4);
            return Double.toString(d);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public String getPrintScaleDescription() {
        try {
            byte[] byArray = ((PhotoshopDirectory)this._directory).getByteArray(1062);
            if (byArray == null) {
                return null;
            }
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            int n = byteArrayReader.getInt32(0);
            float f = byteArrayReader.getFloat32(2);
            float f2 = byteArrayReader.getFloat32(6);
            float f3 = byteArrayReader.getFloat32(10);
            switch (n) {
                case 0: {
                    return "Centered, Scale " + f3;
                }
                case 1: {
                    return "Size to fit";
                }
                case 2: {
                    return String.format("User defined, X:%s Y:%s, Scale:%s", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3));
                }
            }
            return String.format("Unknown %04X, X:%s Y:%s, Scale:%s", n, Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public String getResolutionInfoDescription() {
        try {
            byte[] byArray = ((PhotoshopDirectory)this._directory).getByteArray(1005);
            if (byArray == null) {
                return null;
            }
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            float f = byteArrayReader.getS15Fixed16(0);
            float f2 = byteArrayReader.getS15Fixed16(8);
            return f + "x" + f2 + " DPI";
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public String getVersionDescription() {
        try {
            byte[] byArray = ((PhotoshopDirectory)this._directory).getByteArray(1057);
            if (byArray == null) {
                return null;
            }
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            int n = 0;
            int n2 = byteArrayReader.getInt32(0);
            n += 4;
            ++n;
            int n3 = byteArrayReader.getInt32(5);
            n += 4;
            String string = byteArrayReader.getString(9, n3 * 2, "UTF-16");
            int n4 = byteArrayReader.getInt32(n += n3 * 2);
            String string2 = byteArrayReader.getString(n += 4, n4 * 2, "UTF-16");
            int n5 = byteArrayReader.getInt32(n += n4 * 2);
            return String.format("%d (%s, %s) %d", n2, string, string2, n5);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    public String getSlicesDescription() {
        try {
            byte[] byArray = ((PhotoshopDirectory)this._directory).getByteArray(1050);
            if (byArray == null) {
                return null;
            }
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            int n = byteArrayReader.getInt32(20);
            String string = byteArrayReader.getString(24, n * 2, "UTF-16");
            int n2 = 24 + n * 2;
            int n3 = byteArrayReader.getInt32(n2);
            return String.format("%s (%d,%d,%d,%d) %d Slices", string, byteArrayReader.getInt32(4), byteArrayReader.getInt32(8), byteArrayReader.getInt32(12), byteArrayReader.getInt32(16), n3);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    public String getThumbnailDescription(int n) {
        try {
            byte[] byArray = ((PhotoshopDirectory)this._directory).getByteArray(n);
            if (byArray == null) {
                return null;
            }
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            int n2 = byteArrayReader.getInt32(0);
            int n3 = byteArrayReader.getInt32(4);
            int n4 = byteArrayReader.getInt32(8);
            int n5 = byteArrayReader.getInt32(16);
            int n6 = byteArrayReader.getInt32(20);
            int n7 = byteArrayReader.getInt32(24);
            return String.format("%s, %dx%d, Decomp %d bytes, %d bpp, %d bytes", n2 == 1 ? "JpegRGB" : "RawRGB", n3, n4, n5, n7, n6);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    private String getBooleanString(int n) {
        byte[] byArray = ((PhotoshopDirectory)this._directory).getByteArray(n);
        if (byArray == null) {
            return null;
        }
        return byArray[0] == 0 ? "No" : "Yes";
    }

    @Nullable
    private String get32BitNumberString(int n) {
        byte[] byArray = ((PhotoshopDirectory)this._directory).getByteArray(n);
        if (byArray == null) {
            return null;
        }
        ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
        try {
            return String.format("%d", byteArrayReader.getInt32(0));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    private String getSimpleString(int n) {
        byte[] byArray = ((PhotoshopDirectory)this._directory).getByteArray(n);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    @Nullable
    private String getBinaryDataString(int n) {
        byte[] byArray = ((PhotoshopDirectory)this._directory).getByteArray(n);
        if (byArray == null) {
            return null;
        }
        return String.format("%d bytes binary data", byArray.length);
    }
}

