/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.png;

import com.drew.imaging.png.PngColorType;
import com.drew.lang.KeyValuePair;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.png.PngDirectory;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngDescriptor
extends TagDescriptor<PngDirectory> {
    public PngDescriptor(@NotNull PngDirectory pngDirectory) {
        super(pngDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 4: {
                return this.getColorTypeDescription();
            }
            case 5: {
                return this.getCompressionTypeDescription();
            }
            case 6: {
                return this.getFilterMethodDescription();
            }
            case 7: {
                return this.getInterlaceMethodDescription();
            }
            case 9: {
                return this.getPaletteHasTransparencyDescription();
            }
            case 10: {
                return this.getIsSrgbColorSpaceDescription();
            }
            case 13: {
                return this.getTextualDataDescription();
            }
            case 15: {
                return this.getBackgroundColorDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getColorTypeDescription() {
        Integer n = ((PngDirectory)this._directory).getInteger(4);
        if (n == null) {
            return null;
        }
        PngColorType pngColorType = PngColorType.fromNumericValue(n);
        if (pngColorType == null) {
            return null;
        }
        return pngColorType.getDescription();
    }

    @Nullable
    public String getCompressionTypeDescription() {
        return this.getIndexedDescription(5, "Deflate");
    }

    @Nullable
    public String getFilterMethodDescription() {
        return this.getIndexedDescription(6, "Adaptive");
    }

    @Nullable
    public String getInterlaceMethodDescription() {
        return this.getIndexedDescription(7, "No Interlace", "Adam7 Interlace");
    }

    @Nullable
    public String getPaletteHasTransparencyDescription() {
        return this.getIndexedDescription(9, null, "Yes");
    }

    @Nullable
    public String getIsSrgbColorSpaceDescription() {
        return this.getIndexedDescription(10, "Perceptual", "Relative Colorimetric", "Saturation", "Absolute Colorimetric");
    }

    @Nullable
    public String getTextualDataDescription() {
        Object object = ((PngDirectory)this._directory).getObject(13);
        if (object == null) {
            return null;
        }
        List list = (List)object;
        StringBuilder stringBuilder = new StringBuilder();
        for (KeyValuePair keyValuePair : list) {
            stringBuilder.append(String.format("%s: %s\n", keyValuePair.getKey(), keyValuePair.getValue()));
        }
        return stringBuilder.toString();
    }

    @Nullable
    public String getBackgroundColorDescription() {
        byte[] byArray = ((PngDirectory)this._directory).getByteArray(15);
        Integer n = ((PngDirectory)this._directory).getInteger(4);
        if (byArray == null || n == null) {
            return null;
        }
        SequentialByteArrayReader sequentialByteArrayReader = new SequentialByteArrayReader(byArray);
        try {
            switch (n) {
                case 0: 
                case 4: {
                    return String.format("Greyscale Level %d", sequentialByteArrayReader.getUInt16());
                }
                case 2: 
                case 6: {
                    return String.format("R %d, G %d, B %d", sequentialByteArrayReader.getUInt16(), sequentialByteArrayReader.getUInt16(), sequentialByteArrayReader.getUInt16());
                }
                case 3: {
                    return String.format("Palette Index %d", sequentialByteArrayReader.getUInt8());
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return null;
    }
}

