#!/usr/bin/env python

# DO NOT EDIT THIS FILE BY HAND!
# It is auto-generated from tests.json and gentests.py.

import hashlib
import io
import os
import json
import unittest
import sys
import socket

# Allow direct execution
import os
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

import youtube_dl.FileDownloader
import youtube_dl.InfoExtractors
from youtube_dl.utils import *

# General configuration (from __init__, not very elegant...)
jar = compat_cookiejar.CookieJar()
cookie_processor = compat_urllib_request.HTTPCookieProcessor(jar)
proxy_handler = compat_urllib_request.ProxyHandler()
opener = compat_urllib_request.build_opener(proxy_handler, cookie_processor, YoutubeDLHandler())
compat_urllib_request.install_opener(opener)
socket.setdefaulttimeout(300) # 5 minutes should be enough (famous last words)

class FileDownloader(youtube_dl.FileDownloader):
    def __init__(self, *args, **kwargs):
        youtube_dl.FileDownloader.__init__(self, *args, **kwargs)
        self.to_stderr = self.to_screen

def _file_md5(fn):
    with open(fn, 'rb') as f:
        return hashlib.md5(f.read()).hexdigest()
try:
    _skip_unless = unittest.skipUnless
except AttributeError: # Python 2.6
    def _skip_unless(cond, reason='No reason given'):
        def resfunc(f):
            # Start the function name with test to appease nosetests-2.6
            def test_wfunc(*args, **kwargs):
                if cond:
                    return f(*args, **kwargs)
                else:
                    print('Skipped test')
                    return
            return test_wfunc
        return resfunc
_skip = lambda *args, **kwargs: _skip_unless(False, *args, **kwargs)

class DownloadTest(unittest.TestCase):
    PARAMETERS_FILE = os.path.join(os.path.dirname(os.path.abspath(__file__)), "parameters.json")

    def setUp(self):
        # Clear old files
        self.tearDown()

        with io.open(self.PARAMETERS_FILE, encoding='utf-8') as pf:
            self.parameters = json.load(pf)

    @_skip_unless(youtube_dl.InfoExtractors.YoutubeIE._WORKING, "IE marked as not _WORKING")
    def test_Youtube(self):
        filename = u'BaW_jenozKc.mp4'
        params = self.parameters
        fd = FileDownloader(params)
        fd.add_info_extractor(youtube_dl.InfoExtractors.YoutubeIE())
        fd.download([u'http://www.youtube.com/watch?v=BaW_jenozKc'])
        self.assertTrue(os.path.exists(filename))

    @_skip_unless(youtube_dl.InfoExtractors.DailymotionIE._WORKING, "IE marked as not _WORKING")
    def test_Dailymotion(self):
        filename = u'x33vw9.mp4'
        params = self.parameters
        fd = FileDownloader(params)
        fd.add_info_extractor(youtube_dl.InfoExtractors.DailymotionIE())
        fd.download([u'http://www.dailymotion.com/video/x33vw9_tutoriel-de-youtubeur-dl-des-video_tech'])
        self.assertTrue(os.path.exists(filename))
        md5_for_file = _file_md5(filename)
        self.assertEqual(md5_for_file, u'392c4b85a60a90dc4792da41ce3144eb')

    @_skip_unless(youtube_dl.InfoExtractors.MetacafeIE._WORKING, "IE marked as not _WORKING")
    def test_Metacafe(self):
        filename = u'_aUehQsCQtM.flv'
        params = self.parameters
        fd = FileDownloader(params)
        fd.add_info_extractor(youtube_dl.InfoExtractors.MetacafeIE())
        fd.add_info_extractor(youtube_dl.InfoExtractors.YoutubeIE())
        fd.download([u'http://www.metacafe.com/watch/yt-_aUehQsCQtM/the_electric_company_short_i_pbs_kids_go/'])
        self.assertTrue(os.path.exists(filename))

    @_skip_unless(youtube_dl.InfoExtractors.BlipTVIE._WORKING, "IE marked as not _WORKING")
    def test_BlipTV(self):
        filename = u'5779306.m4v'
        params = self.parameters
        fd = FileDownloader(params)
        fd.add_info_extractor(youtube_dl.InfoExtractors.BlipTVIE())
        fd.download([u'http://blip.tv/cbr/cbr-exclusive-gotham-city-imposters-bats-vs-jokerz-short-3-5796352'])
        self.assertTrue(os.path.exists(filename))
        md5_for_file = _file_md5(filename)
        self.assertEqual(md5_for_file, u'b2d849efcf7ee18917e4b4d9ff37cafe')

    @_skip_unless(youtube_dl.InfoExtractors.XVideosIE._WORKING, "IE marked as not _WORKING")
    def test_XVideos(self):
        filename = u'939581.flv'
        params = self.parameters
        fd = FileDownloader(params)
        fd.add_info_extractor(youtube_dl.InfoExtractors.XVideosIE())
        fd.download([u'http://www.xvideos.com/video939581/funny_porns_by_s_-1'])
        self.assertTrue(os.path.exists(filename))
        md5_for_file = _file_md5(filename)
        self.assertEqual(md5_for_file, u'1d0c835822f0a71a7bf011855db929d0')

    @_skip_unless(youtube_dl.InfoExtractors.VimeoIE._WORKING, "IE marked as not _WORKING")
    def test_Vimeo(self):
        filename = u'14160053.mp4'
        params = self.parameters
        fd = FileDownloader(params)
        fd.add_info_extractor(youtube_dl.InfoExtractors.VimeoIE())
        fd.download([u'http://vimeo.com/14160053'])
        self.assertTrue(os.path.exists(filename))
        md5_for_file = _file_md5(filename)
        self.assertEqual(md5_for_file, u'60540a4ec7cc378ec84b919c0aed5023')

    @_skip_unless(youtube_dl.InfoExtractors.SoundcloudIE._WORKING, "IE marked as not _WORKING")
    def test_Soundcloud(self):
        filename = u'62986583.mp3'
        params = self.parameters
        fd = FileDownloader(params)
        fd.add_info_extractor(youtube_dl.InfoExtractors.SoundcloudIE())
        fd.download([u'http://soundcloud.com/ethmusic/lostin-powers-she-so-heavy'])
        self.assertTrue(os.path.exists(filename))
        md5_for_file = _file_md5(filename)
        self.assertEqual(md5_for_file, u'ebef0a451b909710ed1d7787dddbf0d7')

    @_skip_unless(youtube_dl.InfoExtractors.StanfordOpenClassroomIE._WORKING, "IE marked as not _WORKING")
    def test_StanfordOpenClassroom(self):
        filename = u'PracticalUnix_intro-environment.mp4'
        params = self.parameters
        fd = FileDownloader(params)
        fd.add_info_extractor(youtube_dl.InfoExtractors.StanfordOpenClassroomIE())
        fd.download([u'http://openclassroom.stanford.edu/MainFolder/VideoPage.php?course=PracticalUnix&video=intro-environment&speed=100'])
        self.assertTrue(os.path.exists(filename))
        md5_for_file = _file_md5(filename)
        self.assertEqual(md5_for_file, u'544a9468546059d4e80d76265b0443b8')

    @_skip_unless(youtube_dl.InfoExtractors.XNXXIE._WORKING, "IE marked as not _WORKING")
    def test_XNXX(self):
        filename = u'1135332.flv'
        params = self.parameters
        fd = FileDownloader(params)
        fd.add_info_extractor(youtube_dl.InfoExtractors.XNXXIE())
        fd.download([u'http://video.xnxx.com/video1135332/lida_naked_funny_actress_5_'])
        self.assertTrue(os.path.exists(filename))
        md5_for_file = _file_md5(filename)
        self.assertEqual(md5_for_file, u'0831677e2b4761795f68d417e0b7b445')

    @_skip_unless(youtube_dl.InfoExtractors.YoukuIE._WORKING, "IE marked as not _WORKING")
    def test_Youku(self):
        filename = u'XNDgyMDQ2NTQw_part00.flv'
        params = self.parameters
        params["test"] = False
        fd = FileDownloader(params)
        fd.add_info_extractor(youtube_dl.InfoExtractors.YoukuIE())
        fd.download([u'http://v.youku.com/v_show/id_XNDgyMDQ2NTQw.html'])
        self.assertTrue(os.path.exists(filename))
        md5_for_file = _file_md5(filename)
        self.assertEqual(md5_for_file, u'ffe3f2e435663dc2d1eea34faeff5b5b')


    def tearDown(self):
        if os.path.exists(u'BaW_jenozKc.mp4'):
            os.remove(u'BaW_jenozKc.mp4')
        if os.path.exists(u'x33vw9.mp4'):
            os.remove(u'x33vw9.mp4')
        if os.path.exists(u'_aUehQsCQtM.flv'):
            os.remove(u'_aUehQsCQtM.flv')
        if os.path.exists(u'5779306.m4v'):
            os.remove(u'5779306.m4v')
        if os.path.exists(u'939581.flv'):
            os.remove(u'939581.flv')
        if os.path.exists(u'14160053.mp4'):
            os.remove(u'14160053.mp4')
        if os.path.exists(u'62986583.mp3'):
            os.remove(u'62986583.mp3')
        if os.path.exists(u'PracticalUnix_intro-environment.mp4'):
            os.remove(u'PracticalUnix_intro-environment.mp4')
        if os.path.exists(u'1135332.flv'):
            os.remove(u'1135332.flv')
        if os.path.exists(u'XNDgyMDQ2NTQw_part00.flv'):
            os.remove(u'XNDgyMDQ2NTQw_part00.flv')



if __name__ == '__main__':
    unittest.main()
