import re

from .common import InfoExtractor
from ..utils import ExtractorError


class TestURLIE(InfoExtractor):
    """ Allows addressing of the test cases as test:yout.*be_1 """

    IE_DESC = False  # Do not list
    _VALID_URL = r'test(?:url)?:(?P<extractor>.+?)(?:_(?P<num>[0-9]+))?$'

    def _real_extract(self, url):
        from ..extractor import gen_extractor_classes

        extractor_id, num = self._match_valid_url(url).group('extractor', 'num')

        rex = re.compile(extractor_id, flags=re.IGNORECASE)
        matching_extractors = [e for e in gen_extractor_classes() if rex.search(e.IE_NAME)]

        if len(matching_extractors) == 0:
            raise ExtractorError('No extractors matching {extractor_id!r} found', expected=True)
        elif len(matching_extractors) > 1:
            try:  # Check for exact match
                extractor = next(
                    ie for ie in matching_extractors
                    if ie.IE_NAME.lower() == extractor_id.lower())
            except StopIteration:
                raise ExtractorError(
                    'Found multiple matching extractors: %s' % ' '.join(ie.IE_NAME for ie in matching_extractors),
                    expected=True)
        else:
            extractor = matching_extractors[0]

        testcases = tuple(extractor.get_testcases(True))
        try:
            tc = testcases[int(num or 0)]
        except IndexError:
            raise ExtractorError(
                f'Test case {num or 0} not found, got only {len(testcases)} tests', expected=True)

        self.to_screen(f'Test URL: {tc["url"]}')
        return self.url_result(tc['url'])
