/* table-lookup.c generated by valac 0.16.0, the Vala compiler
 * generated from table-lookup.vala, do not modify */

/* table-lookup.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>


#define ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP (zeitgeist_sq_lite_table_lookup_get_type ())
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookup))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))

typedef struct _ZeitgeistSQLiteTableLookup ZeitgeistSQLiteTableLookup;
typedef struct _ZeitgeistSQLiteTableLookupClass ZeitgeistSQLiteTableLookupClass;
typedef struct _ZeitgeistSQLiteTableLookupPrivate ZeitgeistSQLiteTableLookupPrivate;

#define ZEITGEIST_SQ_LITE_TYPE_DATABASE (zeitgeist_sq_lite_database_get_type ())
#define ZEITGEIST_SQ_LITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabase))
#define ZEITGEIST_SQ_LITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))
#define ZEITGEIST_SQ_LITE_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))

typedef struct _ZeitgeistSQLiteDatabase ZeitgeistSQLiteDatabase;
typedef struct _ZeitgeistSQLiteDatabaseClass ZeitgeistSQLiteDatabaseClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
typedef struct _ZeitgeistSQLiteDatabasePrivate ZeitgeistSQLiteDatabasePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ZeitgeistSQLiteTableLookup {
	GObject parent_instance;
	ZeitgeistSQLiteTableLookupPrivate * priv;
};

struct _ZeitgeistSQLiteTableLookupClass {
	GObjectClass parent_class;
};

struct _ZeitgeistSQLiteTableLookupPrivate {
	ZeitgeistSQLiteDatabase* database;
	sqlite3* db;
	gchar* table;
	GHashTable* id_to_value;
	GHashTable* value_to_id;
	sqlite3_stmt* insertion_stmt;
	sqlite3_stmt* retrieval_stmt;
};

typedef enum  {
	ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED,
	ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT,
	ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR,
	ZEITGEIST_ENGINE_ERROR_DATABASE_RETIRE_FAILED,
	ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE,
	ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_KEY,
	ZEITGEIST_ENGINE_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_ENGINE_ERROR_TOO_MANY_RESULTS
} ZeitgeistEngineError;
#define ZEITGEIST_ENGINE_ERROR zeitgeist_engine_error_quark ()
struct _ZeitgeistSQLiteDatabase {
	GObject parent_instance;
	ZeitgeistSQLiteDatabasePrivate * priv;
	sqlite3_stmt* event_insertion_stmt;
	sqlite3_stmt* id_retrieval_stmt;
	sqlite3_stmt* move_handling_stmt;
	sqlite3_stmt* payload_insertion_stmt;
	sqlite3* database;
};

struct _ZeitgeistSQLiteDatabaseClass {
	GObjectClass parent_class;
};


static gpointer zeitgeist_sq_lite_table_lookup_parent_class = NULL;

GType zeitgeist_sq_lite_table_lookup_get_type (void) G_GNUC_CONST;
GType zeitgeist_sq_lite_database_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupPrivate))
enum  {
	ZEITGEIST_SQ_LITE_TABLE_LOOKUP_DUMMY_PROPERTY
};
GQuark zeitgeist_engine_error_quark (void);
ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_new (ZeitgeistSQLiteDatabase* database, const gchar* table_name, GError** error);
ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_construct (GType object_type, ZeitgeistSQLiteDatabase* database, const gchar* table_name, GError** error);
static void _g_free0_ (gpointer var);
static gint __lambda5_ (ZeitgeistSQLiteTableLookup* self, gint n_columns, gchar** values, int values_length1, gchar** column_names, int column_names_length1);
static gint ___lambda5__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names);
void zeitgeist_sq_lite_database_assert_query_success (ZeitgeistSQLiteDatabase* self, gint rc, const gchar* msg, gint success_code, GError** error);
gint zeitgeist_sq_lite_table_lookup_id_try_string (ZeitgeistSQLiteTableLookup* self, const gchar* name);
gint zeitgeist_sq_lite_table_lookup_id_for_string (ZeitgeistSQLiteTableLookup* self, const gchar* name, GError** error);
const gchar* zeitgeist_sq_lite_table_lookup_get_value (ZeitgeistSQLiteTableLookup* self, gint id, GError** error);
void zeitgeist_sq_lite_table_lookup_remove (ZeitgeistSQLiteTableLookup* self, gint id);
static void zeitgeist_sq_lite_table_lookup_finalize (GObject* obj);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	const gchar* _tmp0_;
	sqlite3_callback _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint ec;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


static gint __lambda5_ (ZeitgeistSQLiteTableLookup* self, gint n_columns, gchar** values, int values_length1, gchar** column_names, int column_names_length1) {
	gint result = 0;
	GHashTable* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GHashTable* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	gint _tmp13_ = 0;
	_tmp0_ = self->priv->id_to_value;
	_tmp1_ = values;
	_tmp1__length1 = values_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = atoi (_tmp2_);
	_tmp4_ = values;
	_tmp4__length1 = values_length1;
	_tmp5_ = _tmp4_[1];
	_tmp6_ = g_strdup (_tmp5_);
	g_hash_table_insert (_tmp0_, GINT_TO_POINTER (_tmp3_), _tmp6_);
	_tmp7_ = self->priv->value_to_id;
	_tmp8_ = values;
	_tmp8__length1 = values_length1;
	_tmp9_ = _tmp8_[1];
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = values;
	_tmp11__length1 = values_length1;
	_tmp12_ = _tmp11_[0];
	_tmp13_ = atoi (_tmp12_);
	g_hash_table_insert (_tmp7_, _tmp10_, GINT_TO_POINTER (_tmp13_));
	result = 0;
	return result;
}


static gint ___lambda5__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names) {
	gint result;
	result = __lambda5_ (self, n_columns, values, -1, column_names, -1);
	return result;
}


ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_construct (GType object_type, ZeitgeistSQLiteDatabase* database, const gchar* table_name, GError** error) {
	ZeitgeistSQLiteTableLookup * self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	sqlite3* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	GHashFunc _tmp8_;
	GEqualFunc _tmp9_;
	GHashTable* _tmp10_;
	gint rc = 0;
	gchar* sql = NULL;
	sqlite3* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_ = 0;
	ZeitgeistSQLiteDatabase* _tmp16_;
	gint _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	sqlite3* _tmp25_;
	const gchar* _tmp26_;
	sqlite3_stmt* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	ZeitgeistSQLiteDatabase* _tmp29_;
	gint _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	sqlite3* _tmp35_;
	const gchar* _tmp36_;
	sqlite3_stmt* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	ZeitgeistSQLiteDatabase* _tmp39_;
	gint _tmp40_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (database != NULL, NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	self = (ZeitgeistSQLiteTableLookup*) g_object_new (object_type, NULL);
	_tmp0_ = database;
	self->priv->database = _tmp0_;
	_tmp1_ = database;
	_tmp2_ = _tmp1_->database;
	self->priv->db = _tmp2_;
	_tmp3_ = table_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->table);
	self->priv->table = _tmp4_;
	_tmp5_ = g_direct_hash;
	_tmp6_ = g_direct_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->id_to_value);
	self->priv->id_to_value = _tmp7_;
	_tmp8_ = g_str_hash;
	_tmp9_ = g_str_equal;
	_tmp10_ = g_hash_table_new_full (_tmp8_, _tmp9_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->value_to_id);
	self->priv->value_to_id = _tmp10_;
	_tmp11_ = self->priv->db;
	_tmp12_ = self->priv->table;
	_tmp13_ = g_strconcat ("SELECT id, value FROM ", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = _sqlite3_exec (_tmp11_, _tmp14_, ___lambda5__sqlite3_callback, self, NULL);
	rc = _tmp15_;
	_g_free0 (_tmp14_);
	_tmp16_ = database;
	_tmp17_ = rc;
	_tmp18_ = self->priv->table;
	_tmp19_ = g_strdup_printf ("Can't init %s table", _tmp18_);
	_tmp20_ = _tmp19_;
	zeitgeist_sq_lite_database_assert_query_success (_tmp16_, _tmp17_, _tmp20_, SQLITE_OK, &_inner_error_);
	_g_free0 (_tmp20_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp21_ = self->priv->table;
	_tmp22_ = g_strconcat ("INSERT INTO ", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, " (value) VALUES (?)", NULL);
	_g_free0 (sql);
	sql = _tmp24_;
	_g_free0 (_tmp23_);
	_tmp25_ = self->priv->db;
	_tmp26_ = sql;
	_tmp28_ = sqlite3_prepare_v2 (_tmp25_, _tmp26_, -1, &_tmp27_, NULL);
	_sqlite3_finalize0 (self->priv->insertion_stmt);
	self->priv->insertion_stmt = _tmp27_;
	rc = _tmp28_;
	_tmp29_ = database;
	_tmp30_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp29_, _tmp30_, "table-lookup.vala:62: Error creating insertion_stmt", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp31_ = self->priv->table;
	_tmp32_ = g_strconcat ("SELECT value FROM ", _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp33_, " WHERE id=?", NULL);
	_g_free0 (sql);
	sql = _tmp34_;
	_g_free0 (_tmp33_);
	_tmp35_ = self->priv->db;
	_tmp36_ = sql;
	_tmp38_ = sqlite3_prepare_v2 (_tmp35_, _tmp36_, -1, &_tmp37_, NULL);
	_sqlite3_finalize0 (self->priv->retrieval_stmt);
	self->priv->retrieval_stmt = _tmp37_;
	rc = _tmp38_;
	_tmp39_ = database;
	_tmp40_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp39_, _tmp40_, "table-lookup.vala:66: Error creating retrieval_stmt", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_free0 (sql);
	return self;
}


ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_new (ZeitgeistSQLiteDatabase* database, const gchar* table_name, GError** error) {
	return zeitgeist_sq_lite_table_lookup_construct (ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, database, table_name, error);
}


/**
         * Searches the table for the given ID, returns -1 if not found.
         *
         * @see id_for_string
         */
gint zeitgeist_sq_lite_table_lookup_id_try_string (ZeitgeistSQLiteTableLookup* self, const gchar* name) {
	gint result = 0;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	gint id;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->value_to_id;
	_tmp1_ = name;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	id = GPOINTER_TO_INT (_tmp2_);
	_tmp3_ = id;
	if (_tmp3_ == 0) {
		result = -1;
		return result;
	}
	result = id;
	return result;
}


/**
         * Searches the table for the given ID, inserts a new one if not found.
         *
         * @see id_try_string
         *
         */
gint zeitgeist_sq_lite_table_lookup_id_for_string (ZeitgeistSQLiteTableLookup* self, const gchar* name, GError** error) {
	gint result = 0;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	gint id;
	gint _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->value_to_id;
	_tmp1_ = name;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	id = GPOINTER_TO_INT (_tmp2_);
	_tmp3_ = id;
	if (_tmp3_ == 0) {
		gint rc = 0;
		sqlite3_stmt* _tmp4_;
		sqlite3_stmt* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		GDestroyNotify _tmp8_;
		sqlite3_stmt* _tmp9_;
		gint _tmp10_ = 0;
		ZeitgeistSQLiteDatabase* _tmp11_;
		gint _tmp12_;
		sqlite3* _tmp13_;
		gint64 _tmp14_ = 0LL;
		GHashTable* _tmp15_;
		gint _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		GHashTable* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gint _tmp22_;
		_tmp4_ = self->priv->insertion_stmt;
		sqlite3_reset (_tmp4_);
		_tmp5_ = self->priv->insertion_stmt;
		_tmp6_ = name;
		_tmp7_ = g_strdup (_tmp6_);
		_tmp8_ = g_free;
		sqlite3_bind_text (_tmp5_, 1, _tmp7_, -1, _tmp8_);
		_tmp9_ = self->priv->insertion_stmt;
		_tmp10_ = sqlite3_step (_tmp9_);
		rc = _tmp10_;
		_tmp11_ = self->priv->database;
		_tmp12_ = rc;
		zeitgeist_sq_lite_database_assert_query_success (_tmp11_, _tmp12_, "Error in id_for_string", SQLITE_DONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		_tmp13_ = self->priv->db;
		_tmp14_ = sqlite3_last_insert_rowid (_tmp13_);
		id = (gint) _tmp14_;
		_tmp15_ = self->priv->id_to_value;
		_tmp16_ = id;
		_tmp17_ = name;
		_tmp18_ = g_strdup (_tmp17_);
		g_hash_table_insert (_tmp15_, GINT_TO_POINTER (_tmp16_), _tmp18_);
		_tmp19_ = self->priv->value_to_id;
		_tmp20_ = name;
		_tmp21_ = g_strdup (_tmp20_);
		_tmp22_ = id;
		g_hash_table_insert (_tmp19_, _tmp21_, GINT_TO_POINTER (_tmp22_));
	}
	result = id;
	return result;
}


const gchar* zeitgeist_sq_lite_table_lookup_get_value (ZeitgeistSQLiteTableLookup* self, gint id, GError** error) {
	const gchar* result = NULL;
	GHashTable* _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_ = NULL;
	const gchar* val;
	const gchar* _tmp3_;
	gint rc = 0;
	gchar* text;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_;
	ZeitgeistSQLiteDatabase* _tmp24_;
	gint _tmp25_;
	const gchar* _tmp26_;
	GHashTable* _tmp30_;
	gint _tmp31_;
	gconstpointer _tmp32_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->id_to_value;
	_tmp1_ = id;
	_tmp2_ = g_hash_table_lookup (_tmp0_, GINT_TO_POINTER (_tmp1_));
	val = (const gchar*) _tmp2_;
	_tmp3_ = val;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = val;
		result = _tmp4_;
		return result;
	}
	text = NULL;
	_tmp5_ = self->priv->retrieval_stmt;
	sqlite3_reset (_tmp5_);
	_tmp6_ = self->priv->retrieval_stmt;
	_tmp7_ = id;
	sqlite3_bind_int64 (_tmp6_, 1, (gint64) _tmp7_);
	_tmp8_ = self->priv->retrieval_stmt;
	_tmp9_ = sqlite3_step (_tmp8_);
	rc = _tmp9_;
	_tmp10_ = rc;
	if (_tmp10_ == SQLITE_ROW) {
		sqlite3_stmt* _tmp11_;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GHashTable* _tmp14_;
		gint _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		GHashTable* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gint _tmp21_;
		sqlite3_stmt* _tmp22_;
		gint _tmp23_ = 0;
		_tmp11_ = self->priv->retrieval_stmt;
		_tmp12_ = sqlite3_column_text (_tmp11_, 0);
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (text);
		text = _tmp13_;
		_tmp14_ = self->priv->id_to_value;
		_tmp15_ = id;
		_tmp16_ = text;
		_tmp17_ = g_strdup (_tmp16_);
		g_hash_table_insert (_tmp14_, GINT_TO_POINTER (_tmp15_), _tmp17_);
		_tmp18_ = self->priv->value_to_id;
		_tmp19_ = text;
		_tmp20_ = g_strdup (_tmp19_);
		_tmp21_ = id;
		g_hash_table_insert (_tmp18_, _tmp20_, GINT_TO_POINTER (_tmp21_));
		_tmp22_ = self->priv->retrieval_stmt;
		_tmp23_ = sqlite3_step (_tmp22_);
		rc = _tmp23_;
	}
	_tmp24_ = self->priv->database;
	_tmp25_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp24_, _tmp25_, "Error in get_value", SQLITE_DONE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (text);
			return NULL;
		} else {
			_g_free0 (text);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp26_ = text;
	if (_tmp26_ == NULL) {
		gint _tmp27_;
		sqlite3* _tmp28_;
		const gchar* _tmp29_ = NULL;
		_tmp27_ = rc;
		_tmp28_ = self->priv->db;
		_tmp29_ = sqlite3_errmsg (_tmp28_);
		g_critical ("table-lookup.vala:135: Error getting data from table: %d, %s\n", _tmp27_, _tmp29_);
	}
	_tmp30_ = self->priv->id_to_value;
	_tmp31_ = id;
	_tmp32_ = g_hash_table_lookup (_tmp30_, GINT_TO_POINTER (_tmp31_));
	result = (const gchar*) _tmp32_;
	_g_free0 (text);
	return result;
}


void zeitgeist_sq_lite_table_lookup_remove (ZeitgeistSQLiteTableLookup* self, gint id) {
	GHashTable* _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* name;
	GHashTable* _tmp4_;
	gint _tmp5_;
	GHashTable* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->id_to_value;
	_tmp1_ = id;
	_tmp2_ = g_hash_table_lookup (_tmp0_, GINT_TO_POINTER (_tmp1_));
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	name = _tmp3_;
	_tmp4_ = self->priv->id_to_value;
	_tmp5_ = id;
	g_hash_table_remove (_tmp4_, GINT_TO_POINTER (_tmp5_));
	_tmp6_ = self->priv->value_to_id;
	g_hash_table_remove (_tmp6_, name);
	_g_free0 (name);
}


static void zeitgeist_sq_lite_table_lookup_class_init (ZeitgeistSQLiteTableLookupClass * klass) {
	zeitgeist_sq_lite_table_lookup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistSQLiteTableLookupPrivate));
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_sq_lite_table_lookup_finalize;
}


static void zeitgeist_sq_lite_table_lookup_instance_init (ZeitgeistSQLiteTableLookup * self) {
	self->priv = ZEITGEIST_SQ_LITE_TABLE_LOOKUP_GET_PRIVATE (self);
}


static void zeitgeist_sq_lite_table_lookup_finalize (GObject* obj) {
	ZeitgeistSQLiteTableLookup * self;
	self = ZEITGEIST_SQ_LITE_TABLE_LOOKUP (obj);
	_g_free0 (self->priv->table);
	_g_hash_table_unref0 (self->priv->id_to_value);
	_g_hash_table_unref0 (self->priv->value_to_id);
	_sqlite3_finalize0 (self->priv->insertion_stmt);
	_sqlite3_finalize0 (self->priv->retrieval_stmt);
	G_OBJECT_CLASS (zeitgeist_sq_lite_table_lookup_parent_class)->finalize (obj);
}


GType zeitgeist_sq_lite_table_lookup_get_type (void) {
	static volatile gsize zeitgeist_sq_lite_table_lookup_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_sq_lite_table_lookup_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSQLiteTableLookupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_sq_lite_table_lookup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSQLiteTableLookup), 0, (GInstanceInitFunc) zeitgeist_sq_lite_table_lookup_instance_init, NULL };
		GType zeitgeist_sq_lite_table_lookup_type_id;
		zeitgeist_sq_lite_table_lookup_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistSQLiteTableLookup", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_sq_lite_table_lookup_type_id__volatile, zeitgeist_sq_lite_table_lookup_type_id);
	}
	return zeitgeist_sq_lite_table_lookup_type_id__volatile;
}



