/* zeitgeist-daemon.c generated by valac 0.16.0, the Vala compiler
 * generated from zeitgeist-daemon.vala, do not modify */

/* zeitgeist-daemon.vala
 *
 * Copyright © 2011 Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <stdio.h>
#include "config.h"


#define ZEITGEIST_TYPE_REMOTE_DBUS (zeitgeist_remote_dbus_get_type ())
#define ZEITGEIST_REMOTE_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_DBUS, ZeitgeistRemoteDBus))
#define ZEITGEIST_IS_REMOTE_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_DBUS))
#define ZEITGEIST_REMOTE_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_DBUS, ZeitgeistRemoteDBusIface))

typedef struct _ZeitgeistRemoteDBus ZeitgeistRemoteDBus;
typedef struct _ZeitgeistRemoteDBusIface ZeitgeistRemoteDBusIface;

#define ZEITGEIST_TYPE_REMOTE_DBUS_PROXY (zeitgeist_remote_dbus_proxy_get_type ())
typedef GDBusProxy ZeitgeistRemoteDBusProxy;
typedef GDBusProxyClass ZeitgeistRemoteDBusProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define ZEITGEIST_TYPE_REMOTE_LOG (zeitgeist_remote_log_get_type ())
#define ZEITGEIST_REMOTE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_LOG, ZeitgeistRemoteLog))
#define ZEITGEIST_IS_REMOTE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_LOG))
#define ZEITGEIST_REMOTE_LOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_LOG, ZeitgeistRemoteLogIface))

typedef struct _ZeitgeistRemoteLog ZeitgeistRemoteLog;
typedef struct _ZeitgeistRemoteLogIface ZeitgeistRemoteLogIface;

#define ZEITGEIST_TYPE_REMOTE_LOG_PROXY (zeitgeist_remote_log_proxy_get_type ())

#define ZEITGEIST_TYPE_VERSION_STRUCT (zeitgeist_version_struct_get_type ())
typedef struct _ZeitgeistVersionStruct ZeitgeistVersionStruct;

#define ZEITGEIST_TYPE_DAEMON (zeitgeist_daemon_get_type ())
#define ZEITGEIST_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemon))
#define ZEITGEIST_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemonClass))
#define ZEITGEIST_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_DAEMON))
#define ZEITGEIST_IS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_DAEMON))
#define ZEITGEIST_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemonClass))

typedef struct _ZeitgeistDaemon ZeitgeistDaemon;
typedef struct _ZeitgeistDaemonClass ZeitgeistDaemonClass;
typedef struct _ZeitgeistDaemonPrivate ZeitgeistDaemonPrivate;

#define ZEITGEIST_TYPE_DB_READER (zeitgeist_db_reader_get_type ())
#define ZEITGEIST_DB_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader))
#define ZEITGEIST_DB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderClass))
#define ZEITGEIST_IS_DB_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_DB_READER))
#define ZEITGEIST_IS_DB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_DB_READER))
#define ZEITGEIST_DB_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderClass))

typedef struct _ZeitgeistDbReader ZeitgeistDbReader;
typedef struct _ZeitgeistDbReaderClass ZeitgeistDbReaderClass;

#define ZEITGEIST_TYPE_ENGINE (zeitgeist_engine_get_type ())
#define ZEITGEIST_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine))
#define ZEITGEIST_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))
#define ZEITGEIST_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))

typedef struct _ZeitgeistEngine ZeitgeistEngine;
typedef struct _ZeitgeistEngineClass ZeitgeistEngineClass;

#define ZEITGEIST_TYPE_MONITOR_MANAGER (zeitgeist_monitor_manager_get_type ())
#define ZEITGEIST_MONITOR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManager))
#define ZEITGEIST_MONITOR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManagerClass))
#define ZEITGEIST_IS_MONITOR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_MONITOR_MANAGER))
#define ZEITGEIST_IS_MONITOR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_MONITOR_MANAGER))
#define ZEITGEIST_MONITOR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_MONITOR_MANAGER, ZeitgeistMonitorManagerClass))

typedef struct _ZeitgeistMonitorManager ZeitgeistMonitorManager;
typedef struct _ZeitgeistMonitorManagerClass ZeitgeistMonitorManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

#define ZEITGEIST_TYPE_TIME_RANGE (zeitgeist_time_range_get_type ())
#define ZEITGEIST_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange))
#define ZEITGEIST_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))
#define ZEITGEIST_IS_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_IS_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_TIME_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))

typedef struct _ZeitgeistTimeRange ZeitgeistTimeRange;
typedef struct _ZeitgeistTimeRangeClass ZeitgeistTimeRangeClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _ZeitgeistRemoteDBusIface {
	GTypeInterface parent_iface;
	gboolean (*name_has_owner) (ZeitgeistRemoteDBus* self, const gchar* name, GError** error);
};

struct _ZeitgeistVersionStruct {
	gint major;
	gint minor;
	gint micro;
};

struct _ZeitgeistRemoteLogIface {
	GTypeInterface parent_iface;
	GVariant* (*delete_events) (ZeitgeistRemoteLog* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
	guint32* (*find_event_ids) (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, int* result_length1, GError** error);
	GVariant* (*find_events) (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, GError** error);
	gchar** (*find_related_uris) (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, GVariant* result_event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, int* result_length1, GError** error);
	GVariant* (*get_events) (ZeitgeistRemoteLog* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
	guint32* (*insert_events) (ZeitgeistRemoteLog* self, GVariant* events, const char* sender, int* result_length1, GError** error);
	void (*install_monitor) (ZeitgeistRemoteLog* self, const char* monitor_path, GVariant* time_range, GVariant* event_templates, const char* owner, GError** error);
	void (*remove_monitor) (ZeitgeistRemoteLog* self, const char* monitor_path, const char* owner, GError** error);
	void (*quit) (ZeitgeistRemoteLog* self, GError** error);
	gchar** (*get_extensions) (ZeitgeistRemoteLog* self, int* result_length1);
	void (*get_version) (ZeitgeistRemoteLog* self, ZeitgeistVersionStruct* value);
};

struct _ZeitgeistDaemon {
	GObject parent_instance;
	ZeitgeistDaemonPrivate * priv;
};

struct _ZeitgeistDaemonClass {
	GObjectClass parent_class;
};

struct _ZeitgeistDaemonPrivate {
	ZeitgeistEngine* engine;
	ZeitgeistMonitorManager* notifications;
	guint log_register_id;
	GDBusConnection* connection;
};

typedef enum  {
	ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED,
	ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT,
	ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR,
	ZEITGEIST_ENGINE_ERROR_DATABASE_RETIRE_FAILED,
	ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE,
	ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_KEY,
	ZEITGEIST_ENGINE_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_ENGINE_ERROR_TOO_MANY_RESULTS
} ZeitgeistEngineError;
#define ZEITGEIST_ENGINE_ERROR zeitgeist_engine_error_quark ()

static gpointer zeitgeist_daemon_parent_class = NULL;
static gboolean zeitgeist_daemon_show_version_info;
static gboolean zeitgeist_daemon_show_version_info = FALSE;
static gboolean zeitgeist_daemon_show_options;
static gboolean zeitgeist_daemon_show_options = FALSE;
static gboolean zeitgeist_daemon_no_datahub;
static gboolean zeitgeist_daemon_no_datahub = FALSE;
static gboolean zeitgeist_daemon_replace_mode;
static gboolean zeitgeist_daemon_replace_mode = FALSE;
static gboolean zeitgeist_daemon_quit_daemon;
static gboolean zeitgeist_daemon_quit_daemon = FALSE;
static gchar* zeitgeist_daemon_log_level;
static gchar* zeitgeist_daemon_log_level = NULL;
static gchar* zeitgeist_daemon_log_file;
static gchar* zeitgeist_daemon_log_file = NULL;
static ZeitgeistDaemon* zeitgeist_daemon_instance;
static ZeitgeistDaemon* zeitgeist_daemon_instance = NULL;
static GMainLoop* zeitgeist_daemon_mainloop;
static GMainLoop* zeitgeist_daemon_mainloop = NULL;
static gboolean zeitgeist_daemon_name_acquired;
static gboolean zeitgeist_daemon_name_acquired = FALSE;
static ZeitgeistRemoteLogIface* zeitgeist_daemon_zeitgeist_remote_log_parent_iface = NULL;

GType zeitgeist_remote_dbus_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_dbus_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_dbus_get_type (void) G_GNUC_CONST;
gboolean zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self, const gchar* name, GError** error);
static void zeitgeist_remote_dbus_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gboolean zeitgeist_remote_dbus_proxy_name_has_owner (ZeitgeistRemoteDBus* self, const gchar* name, GError** error);
static void zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init (ZeitgeistRemoteDBusIface* iface);
static void _dbus_zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void zeitgeist_remote_dbus_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* zeitgeist_remote_dbus_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean zeitgeist_remote_dbus_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _zeitgeist_remote_dbus_unregister_object (gpointer user_data);
GType zeitgeist_remote_log_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_log_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_version_struct_get_type (void) G_GNUC_CONST;
ZeitgeistVersionStruct* zeitgeist_version_struct_dup (const ZeitgeistVersionStruct* self);
void zeitgeist_version_struct_free (ZeitgeistVersionStruct* self);
GType zeitgeist_remote_log_get_type (void) G_GNUC_CONST;
GType zeitgeist_daemon_get_type (void) G_GNUC_CONST;
GType zeitgeist_db_reader_get_type (void) G_GNUC_CONST;
GType zeitgeist_engine_get_type (void) G_GNUC_CONST;
GType zeitgeist_monitor_manager_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_DAEMON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_DAEMON, ZeitgeistDaemonPrivate))
enum  {
	ZEITGEIST_DAEMON_DUMMY_PROPERTY
};
#define ZEITGEIST_DAEMON_DBUS_NAME "org.gnome.zeitgeist.Engine"
GQuark zeitgeist_engine_error_quark (void);
ZeitgeistDaemon* zeitgeist_daemon_new (GError** error);
ZeitgeistDaemon* zeitgeist_daemon_construct (GType object_type, GError** error);
ZeitgeistEngine* zeitgeist_engine_new (GError** error);
ZeitgeistEngine* zeitgeist_engine_construct (GType object_type, GError** error);
ZeitgeistMonitorManager* zeitgeist_monitor_manager_get_default (void);
static GVariant* zeitgeist_daemon_real_get_events (ZeitgeistRemoteLog* base, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
GType zeitgeist_event_get_type (void) G_GNUC_CONST;
GPtrArray* zeitgeist_db_reader_get_events (ZeitgeistDbReader* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
GVariant* zeitgeist_events_to_variant_with_limit (GPtrArray* events, gsize limit, GError** error);
#define ZEITGEIST_UTILS_MAX_DBUS_RESULT_SIZE ((gsize) ((4 * 1024) * 1024))
static gchar** zeitgeist_daemon_real_find_related_uris (ZeitgeistRemoteLog* base, GVariant* time_range, GVariant* event_templates, GVariant* result_event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, int* result_length1, GError** error);
ZeitgeistTimeRange* zeitgeist_time_range_new_from_variant (GVariant* variant, GError** error);
ZeitgeistTimeRange* zeitgeist_time_range_construct_from_variant (GType object_type, GVariant* variant, GError** error);
GType zeitgeist_time_range_get_type (void) G_GNUC_CONST;
GPtrArray* zeitgeist_events_from_variant (GVariant* vevents, GError** error);
gchar** zeitgeist_db_reader_find_related_uris (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, GPtrArray* result_event_templates, guint storage_state, guint max_results, guint result_type, const char* sender, int* result_length1, GError** error);
static guint32* zeitgeist_daemon_real_find_event_ids (ZeitgeistRemoteLog* base, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, int* result_length1, GError** error);
guint32* zeitgeist_db_reader_find_event_ids (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, int* result_length1, GError** error);
static GVariant* zeitgeist_daemon_real_find_events (ZeitgeistRemoteLog* base, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, GError** error);
GPtrArray* zeitgeist_db_reader_find_events (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, GError** error);
static guint32* zeitgeist_daemon_real_insert_events (ZeitgeistRemoteLog* base, GVariant* vevents, const char* sender, int* result_length1, GError** error);
guint32* zeitgeist_engine_insert_events (ZeitgeistEngine* self, GPtrArray* events, const char* sender, int* result_length1, GError** error);
gint64 zeitgeist_event_get_timestamp (ZeitgeistEvent* self);
void zeitgeist_monitor_manager_notify_insert (ZeitgeistMonitorManager* self, ZeitgeistTimeRange* time_range, GPtrArray* events);
ZeitgeistTimeRange* zeitgeist_time_range_new (gint64 start_msec, gint64 end_msec);
ZeitgeistTimeRange* zeitgeist_time_range_construct (GType object_type, gint64 start_msec, gint64 end_msec);
static GVariant* zeitgeist_daemon_real_delete_events (ZeitgeistRemoteLog* base, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
ZeitgeistTimeRange* zeitgeist_engine_delete_events (ZeitgeistEngine* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
void zeitgeist_monitor_manager_notify_delete (ZeitgeistMonitorManager* self, ZeitgeistTimeRange* time_range, guint32* event_ids, int event_ids_length1);
GVariant* zeitgeist_time_range_to_variant (ZeitgeistTimeRange* self);
static void zeitgeist_daemon_real_quit (ZeitgeistRemoteLog* base, GError** error);
static void zeitgeist_daemon_do_quit (ZeitgeistDaemon* self);
void zeitgeist_db_reader_close (ZeitgeistDbReader* self);
static void zeitgeist_daemon_real_install_monitor (ZeitgeistRemoteLog* base, const char* monitor_path, GVariant* time_range, GVariant* event_templates, const char* owner, GError** error);
void zeitgeist_monitor_manager_install_monitor (ZeitgeistMonitorManager* self, const char* peer, const gchar* object_path, ZeitgeistTimeRange* time_range, GPtrArray* templates);
static void zeitgeist_daemon_real_remove_monitor (ZeitgeistRemoteLog* base, const char* monitor_path, const char* owner, GError** error);
void zeitgeist_monitor_manager_remove_monitor (ZeitgeistMonitorManager* self, const char* peer, const gchar* object_path);
void zeitgeist_daemon_register_dbus_object (ZeitgeistDaemon* self, GDBusConnection* conn, GError** error);
void zeitgeist_daemon_unregister_dbus_object (ZeitgeistDaemon* self);
static gboolean zeitgeist_daemon_quit_running_instance (GDBusConnection* conn);
void zeitgeist_remote_log_quit (ZeitgeistRemoteLog* self, GError** error);
static void zeitgeist_daemon_name_acquired_callback (GDBusConnection* conn);
static void zeitgeist_daemon_name_lost_callback (GDBusConnection* conn);
static gboolean ____lambda12_ (void);
static gboolean _____lambda12__gsource_func (gpointer self);
static void zeitgeist_daemon_run (GError** error);
const gchar* zeitgeist_utils_get_database_file_path (void);
static void _zeitgeist_daemon_name_acquired_callback_gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void _zeitgeist_daemon_name_lost_callback_gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void zeitgeist_daemon_safe_exit (void);
static gint zeitgeist_daemon_main (gchar** args, int args_length1);
static void _zeitgeist_daemon_safe_exit_sighandler_t (gint signal);
void zeitgeist_logging_setup_logging (const gchar* log_level, const gchar* log_file);
gchar** zeitgeist_engine_get_extension_names (ZeitgeistEngine* self, int* result_length1);
static void zeitgeist_daemon_finalize (GObject* obj);
static void _vala_zeitgeist_daemon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_name = {-1, "name", "s"};
static const GDBusArgInfo _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_result = {-1, "result", "b"};
static const GDBusArgInfo * const _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_in[] = {&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_name, NULL};
static const GDBusArgInfo * const _zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_out[] = {&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_result, NULL};
static const GDBusMethodInfo _zeitgeist_remote_dbus_dbus_method_info_name_has_owner = {-1, "NameHasOwner", (GDBusArgInfo **) (&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_in), (GDBusArgInfo **) (&_zeitgeist_remote_dbus_dbus_arg_info_name_has_owner_out)};
static const GDBusMethodInfo * const _zeitgeist_remote_dbus_dbus_method_info[] = {&_zeitgeist_remote_dbus_dbus_method_info_name_has_owner, NULL};
static const GDBusSignalInfo * const _zeitgeist_remote_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _zeitgeist_remote_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _zeitgeist_remote_dbus_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_zeitgeist_remote_dbus_dbus_method_info), (GDBusSignalInfo **) (&_zeitgeist_remote_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_zeitgeist_remote_dbus_dbus_property_info)};
static const GDBusInterfaceVTable _zeitgeist_remote_dbus_dbus_interface_vtable = {zeitgeist_remote_dbus_dbus_interface_method_call, zeitgeist_remote_dbus_dbus_interface_get_property, zeitgeist_remote_dbus_dbus_interface_set_property};
static const GOptionEntry ZEITGEIST_DAEMON_options[9] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_show_version_info, "Print program's version number and exit", NULL}, {"no-datahub", (gchar) 0, 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_no_datahub, "Do not start zeitgeist-datahub automatically", NULL}, {"no-passive-loggers", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &zeitgeist_daemon_no_datahub, NULL, NULL}, {"replace", 'r', 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_replace_mode, "If another Zeitgeist instance is already running, replace it", NULL}, {"quit", 'q', 0, G_OPTION_ARG_NONE, &zeitgeist_daemon_quit_daemon, "Quit running Zeitgeist daemon instance", NULL}, {"log-level", (gchar) 0, 0, G_OPTION_ARG_STRING, &zeitgeist_daemon_log_level, "How much information should be printed; possible values: " "DEBUG, INFO, WARNING, ERROR, CRITICAL", "LEVEL"}, {"log-file", (gchar) 0, 0, G_OPTION_ARG_STRING, &zeitgeist_daemon_log_file, "File to which the log output will be appended", NULL}, {"shell-completion", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &zeitgeist_daemon_show_options, NULL, NULL}, {NULL}};

gboolean zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self, const gchar* name, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return ZEITGEIST_REMOTE_DBUS_GET_INTERFACE (self)->name_has_owner (self, name, error);
}


static void zeitgeist_remote_dbus_base_init (ZeitgeistRemoteDBusIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType zeitgeist_remote_dbus_get_type (void) {
	static volatile gsize zeitgeist_remote_dbus_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_remote_dbus_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistRemoteDBusIface), (GBaseInitFunc) zeitgeist_remote_dbus_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType zeitgeist_remote_dbus_type_id;
		zeitgeist_remote_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "ZeitgeistRemoteDBus", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (zeitgeist_remote_dbus_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) zeitgeist_remote_dbus_proxy_get_type);
		g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
		g_type_set_qdata (zeitgeist_remote_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) zeitgeist_remote_dbus_register_object);
		g_once_init_leave (&zeitgeist_remote_dbus_type_id__volatile, zeitgeist_remote_dbus_type_id);
	}
	return zeitgeist_remote_dbus_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ZeitgeistRemoteDBusProxy, zeitgeist_remote_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ZEITGEIST_TYPE_REMOTE_DBUS, zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init) )
static void zeitgeist_remote_dbus_proxy_class_init (ZeitgeistRemoteDBusProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = zeitgeist_remote_dbus_proxy_g_signal;
}


static void zeitgeist_remote_dbus_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void zeitgeist_remote_dbus_proxy_init (ZeitgeistRemoteDBusProxy* self) {
}


static gboolean zeitgeist_remote_dbus_proxy_name_has_owner (ZeitgeistRemoteDBus* self, const gchar* name, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp0_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "NameHasOwner");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp0_);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}


static void zeitgeist_remote_dbus_proxy_zeitgeist_remote_dbus_interface_init (ZeitgeistRemoteDBusIface* iface) {
	iface->name_has_owner = zeitgeist_remote_dbus_proxy_name_has_owner;
}


static void _dbus_zeitgeist_remote_dbus_name_has_owner (ZeitgeistRemoteDBus* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp1_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	result = zeitgeist_remote_dbus_name_has_owner (self, name, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (name);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void zeitgeist_remote_dbus_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "NameHasOwner") == 0) {
		_dbus_zeitgeist_remote_dbus_name_has_owner (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* zeitgeist_remote_dbus_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean zeitgeist_remote_dbus_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint zeitgeist_remote_dbus_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_zeitgeist_remote_dbus_dbus_interface_info), &_zeitgeist_remote_dbus_dbus_interface_vtable, data, _zeitgeist_remote_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _zeitgeist_remote_dbus_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


ZeitgeistDaemon* zeitgeist_daemon_construct (GType object_type, GError** error) {
	ZeitgeistDaemon * self = NULL;
	ZeitgeistEngine* _tmp0_;
	ZeitgeistEngine* _tmp1_;
	ZeitgeistMonitorManager* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistDaemon*) g_object_new (object_type, NULL);
	_tmp0_ = zeitgeist_engine_new (&_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp1_;
	_tmp2_ = zeitgeist_monitor_manager_get_default ();
	_g_object_unref0 (self->priv->notifications);
	self->priv->notifications = _tmp2_;
	return self;
}


ZeitgeistDaemon* zeitgeist_daemon_new (GError** error) {
	return zeitgeist_daemon_construct (ZEITGEIST_TYPE_DAEMON, error);
}


static GVariant* zeitgeist_daemon_real_get_events (ZeitgeistRemoteLog* base, guint32* event_ids, int event_ids_length1, const char* sender, GError** error) {
	ZeitgeistDaemon * self;
	GVariant* result = NULL;
	GTimer* _tmp0_;
	GTimer* timer;
	ZeitgeistEngine* _tmp1_;
	guint32* _tmp2_;
	gint _tmp2__length1;
	GPtrArray* _tmp3_ = NULL;
	GPtrArray* events;
	GTimer* _tmp4_;
	gdouble _tmp5_ = 0.0;
	GPtrArray* _tmp6_;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistDaemon*) base;
	g_return_val_if_fail (sender != NULL, NULL);
	_tmp0_ = g_timer_new ();
	timer = _tmp0_;
	_tmp1_ = self->priv->engine;
	_tmp2_ = event_ids;
	_tmp2__length1 = event_ids_length1;
	_tmp3_ = zeitgeist_db_reader_get_events ((ZeitgeistDbReader*) _tmp1_, _tmp2_, _tmp2__length1, NULL, &_inner_error_);
	events = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_timer_destroy0 (timer);
		return NULL;
	}
	_tmp4_ = timer;
	_tmp5_ = g_timer_elapsed (_tmp4_, NULL);
	g_debug ("zeitgeist-daemon.vala:140: %s executed in %f seconds", "Zeitgeist.Daemon.get_events", _tmp5_);
	_tmp6_ = events;
	_tmp7_ = zeitgeist_events_to_variant_with_limit (_tmp6_, ZEITGEIST_UTILS_MAX_DBUS_RESULT_SIZE, &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_ptr_array_unref0 (events);
		_g_timer_destroy0 (timer);
		return NULL;
	}
	result = _tmp8_;
	_g_ptr_array_unref0 (events);
	_g_timer_destroy0 (timer);
	return result;
}


static gchar** zeitgeist_daemon_real_find_related_uris (ZeitgeistRemoteLog* base, GVariant* time_range, GVariant* event_templates, GVariant* result_event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, int* result_length1, GError** error) {
	ZeitgeistDaemon * self;
	gchar** result = NULL;
	GVariant* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	GVariant* _tmp3_;
	GPtrArray* _tmp4_ = NULL;
	GPtrArray* _tmp5_;
	GVariant* _tmp6_;
	GPtrArray* _tmp7_ = NULL;
	GPtrArray* _tmp8_;
	ZeitgeistEngine* _tmp9_;
	ZeitgeistTimeRange* _tmp10_;
	GPtrArray* _tmp11_;
	GPtrArray* _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	gint _tmp16_ = 0;
	gchar** _tmp17_ = NULL;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gint __tmp19__size_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistDaemon*) base;
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	g_return_val_if_fail (result_event_templates != NULL, NULL);
	g_return_val_if_fail (sender != NULL, NULL);
	_tmp0_ = time_range;
	_tmp1_ = zeitgeist_time_range_new_from_variant (_tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = event_templates;
	_tmp4_ = zeitgeist_events_from_variant (_tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp6_ = result_event_templates;
	_tmp7_ = zeitgeist_events_from_variant (_tmp6_, &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp9_ = self->priv->engine;
	_tmp10_ = _tmp2_;
	_tmp11_ = _tmp5_;
	_tmp12_ = _tmp8_;
	_tmp13_ = storage_state;
	_tmp14_ = num_events;
	_tmp15_ = result_type;
	_tmp17_ = zeitgeist_db_reader_find_related_uris ((ZeitgeistDbReader*) _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_, NULL, &_tmp16_, &_inner_error_);
	_tmp18_ = _tmp17_;
	_tmp18__length1 = _tmp16_;
	_g_ptr_array_unref0 (_tmp12_);
	_g_ptr_array_unref0 (_tmp11_);
	_g_object_unref0 (_tmp10_);
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _tmp18__length1;
	__tmp19__size_ = _tmp19__length1;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp20_ = _tmp19_;
	_tmp20__length1 = _tmp19__length1;
	if (result_length1) {
		*result_length1 = _tmp20__length1;
	}
	result = _tmp20_;
	return result;
}


static guint32* zeitgeist_daemon_real_find_event_ids (ZeitgeistRemoteLog* base, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, int* result_length1, GError** error) {
	ZeitgeistDaemon * self;
	guint32* result = NULL;
	GTimer* _tmp0_;
	GTimer* timer;
	GVariant* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	ZeitgeistTimeRange* _tmp3_;
	GVariant* _tmp4_;
	GPtrArray* _tmp5_ = NULL;
	GPtrArray* _tmp6_;
	ZeitgeistEngine* _tmp7_;
	ZeitgeistTimeRange* _tmp8_;
	GPtrArray* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	const char* _tmp13_;
	gint _tmp14_ = 0;
	guint32* _tmp15_ = NULL;
	guint32* _tmp16_;
	gint _tmp16__length1;
	guint32* ids;
	gint ids_length1;
	gint _ids_size_;
	GTimer* _tmp17_;
	gdouble _tmp18_ = 0.0;
	guint32* _tmp19_;
	gint _tmp19__length1;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistDaemon*) base;
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	g_return_val_if_fail (sender != NULL, NULL);
	_tmp0_ = g_timer_new ();
	timer = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = zeitgeist_time_range_new_from_variant (_tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_timer_destroy0 (timer);
		return NULL;
	}
	_tmp4_ = event_templates;
	_tmp5_ = zeitgeist_events_from_variant (_tmp4_, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_timer_destroy0 (timer);
		return NULL;
	}
	_tmp7_ = self->priv->engine;
	_tmp8_ = _tmp3_;
	_tmp9_ = _tmp6_;
	_tmp10_ = storage_state;
	_tmp11_ = num_events;
	_tmp12_ = result_type;
	_tmp13_ = sender;
	_tmp15_ = zeitgeist_db_reader_find_event_ids ((ZeitgeistDbReader*) _tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, &_tmp14_, &_inner_error_);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp14_;
	_g_ptr_array_unref0 (_tmp9_);
	_g_object_unref0 (_tmp8_);
	ids = _tmp16_;
	ids_length1 = _tmp16__length1;
	_ids_size_ = ids_length1;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_timer_destroy0 (timer);
		return NULL;
	}
	_tmp17_ = timer;
	_tmp18_ = g_timer_elapsed (_tmp17_, NULL);
	g_debug ("zeitgeist-daemon.vala:167: %s executed in %f seconds", "Zeitgeist.Daemon.find_event_ids", _tmp18_);
	_tmp19_ = ids;
	_tmp19__length1 = ids_length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	_g_timer_destroy0 (timer);
	return result;
}


static GVariant* zeitgeist_daemon_real_find_events (ZeitgeistRemoteLog* base, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, GError** error) {
	ZeitgeistDaemon * self;
	GVariant* result = NULL;
	GTimer* _tmp0_;
	GTimer* timer;
	GVariant* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	ZeitgeistTimeRange* _tmp3_;
	GVariant* _tmp4_;
	GPtrArray* _tmp5_ = NULL;
	GPtrArray* _tmp6_;
	ZeitgeistEngine* _tmp7_;
	ZeitgeistTimeRange* _tmp8_;
	GPtrArray* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	const char* _tmp13_;
	GPtrArray* _tmp14_ = NULL;
	GPtrArray* _tmp15_;
	GPtrArray* events;
	GTimer* _tmp16_;
	gdouble _tmp17_ = 0.0;
	GPtrArray* _tmp18_;
	GVariant* _tmp19_ = NULL;
	GVariant* _tmp20_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistDaemon*) base;
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	g_return_val_if_fail (sender != NULL, NULL);
	_tmp0_ = g_timer_new ();
	timer = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = zeitgeist_time_range_new_from_variant (_tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_timer_destroy0 (timer);
		return NULL;
	}
	_tmp4_ = event_templates;
	_tmp5_ = zeitgeist_events_from_variant (_tmp4_, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_timer_destroy0 (timer);
		return NULL;
	}
	_tmp7_ = self->priv->engine;
	_tmp8_ = _tmp3_;
	_tmp9_ = _tmp6_;
	_tmp10_ = storage_state;
	_tmp11_ = num_events;
	_tmp12_ = result_type;
	_tmp13_ = sender;
	_tmp14_ = zeitgeist_db_reader_find_events ((ZeitgeistDbReader*) _tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, &_inner_error_);
	_tmp15_ = _tmp14_;
	_g_ptr_array_unref0 (_tmp9_);
	_g_object_unref0 (_tmp8_);
	events = _tmp15_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_timer_destroy0 (timer);
		return NULL;
	}
	_tmp16_ = timer;
	_tmp17_ = g_timer_elapsed (_tmp16_, NULL);
	g_debug ("zeitgeist-daemon.vala:181: %s executed in %f seconds", "Zeitgeist.Daemon.find_events", _tmp17_);
	_tmp18_ = events;
	_tmp19_ = zeitgeist_events_to_variant_with_limit (_tmp18_, ZEITGEIST_UTILS_MAX_DBUS_RESULT_SIZE, &_inner_error_);
	_tmp20_ = _tmp19_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_ptr_array_unref0 (events);
		_g_timer_destroy0 (timer);
		return NULL;
	}
	result = _tmp20_;
	_g_ptr_array_unref0 (events);
	_g_timer_destroy0 (timer);
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static guint32* zeitgeist_daemon_real_insert_events (ZeitgeistRemoteLog* base, GVariant* vevents, const char* sender, int* result_length1, GError** error) {
	ZeitgeistDaemon * self;
	guint32* result = NULL;
	GVariant* _tmp0_;
	GPtrArray* _tmp1_ = NULL;
	GPtrArray* events;
	ZeitgeistEngine* _tmp2_;
	GPtrArray* _tmp3_;
	const char* _tmp4_;
	gint _tmp5_ = 0;
	guint32* _tmp6_ = NULL;
	guint32* event_ids;
	gint event_ids_length1;
	gint _event_ids_size_;
	gint64 _tmp7_;
	gint64 min_timestamp;
	gint64 _tmp8_;
	gint64 max_timestamp;
	gint64 _tmp33_;
	gint64 _tmp34_;
	guint32* _tmp41_;
	gint _tmp41__length1;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistDaemon*) base;
	g_return_val_if_fail (vevents != NULL, NULL);
	g_return_val_if_fail (sender != NULL, NULL);
	_tmp0_ = vevents;
	_tmp1_ = zeitgeist_events_from_variant (_tmp0_, &_inner_error_);
	events = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp2_ = self->priv->engine;
	_tmp3_ = events;
	_tmp4_ = sender;
	_tmp6_ = zeitgeist_engine_insert_events (_tmp2_, _tmp3_, _tmp4_, &_tmp5_, &_inner_error_);
	event_ids = _tmp6_;
	event_ids_length1 = _tmp5_;
	_event_ids_size_ = event_ids_length1;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_ptr_array_unref0 (events);
		return NULL;
	}
	_tmp7_ = G_MAXINT64;
	min_timestamp = _tmp7_;
	_tmp8_ = G_MININT64;
	max_timestamp = _tmp8_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				gint _tmp12_;
				GPtrArray* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				GPtrArray* _tmp16_;
				gint _tmp17_;
				gconstpointer _tmp18_ = NULL;
				gint64 _tmp19_;
				GPtrArray* _tmp20_;
				gint _tmp21_;
				gconstpointer _tmp22_ = NULL;
				gint64 _tmp23_;
				gint64 _tmp24_;
				gint64 _tmp25_ = 0LL;
				gint64 _tmp26_;
				GPtrArray* _tmp27_;
				gint _tmp28_;
				gconstpointer _tmp29_ = NULL;
				gint64 _tmp30_;
				gint64 _tmp31_;
				gint64 _tmp32_ = 0LL;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = events;
				_tmp14_ = g_ptr_array_get_length (_tmp13_);
				_tmp15_ = _tmp14_;
				if (!(_tmp12_ < _tmp15_)) {
					break;
				}
				_tmp16_ = events;
				_tmp17_ = i;
				_tmp18_ = g_ptr_array_index (_tmp16_, (guint) _tmp17_);
				if (((ZeitgeistEvent*) _tmp18_) == NULL) {
					continue;
				}
				_tmp19_ = min_timestamp;
				_tmp20_ = events;
				_tmp21_ = i;
				_tmp22_ = g_ptr_array_index (_tmp20_, (guint) _tmp21_);
				_tmp23_ = zeitgeist_event_get_timestamp ((ZeitgeistEvent*) _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = MIN (_tmp19_, _tmp24_);
				min_timestamp = _tmp25_;
				_tmp26_ = max_timestamp;
				_tmp27_ = events;
				_tmp28_ = i;
				_tmp29_ = g_ptr_array_index (_tmp27_, (guint) _tmp28_);
				_tmp30_ = zeitgeist_event_get_timestamp ((ZeitgeistEvent*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = MAX (_tmp26_, _tmp31_);
				max_timestamp = _tmp32_;
			}
		}
	}
	_tmp33_ = min_timestamp;
	_tmp34_ = G_MAXINT64;
	if (_tmp33_ < _tmp34_) {
		ZeitgeistMonitorManager* _tmp35_;
		gint64 _tmp36_;
		gint64 _tmp37_;
		ZeitgeistTimeRange* _tmp38_;
		ZeitgeistTimeRange* _tmp39_;
		GPtrArray* _tmp40_;
		_tmp35_ = self->priv->notifications;
		_tmp36_ = min_timestamp;
		_tmp37_ = max_timestamp;
		_tmp38_ = zeitgeist_time_range_new (_tmp36_, _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = events;
		zeitgeist_monitor_manager_notify_insert (_tmp35_, _tmp39_, _tmp40_);
		_g_object_unref0 (_tmp39_);
	}
	_tmp41_ = event_ids;
	_tmp41__length1 = event_ids_length1;
	if (result_length1) {
		*result_length1 = _tmp41__length1;
	}
	result = _tmp41_;
	_g_ptr_array_unref0 (events);
	return result;
}


static GVariant* zeitgeist_daemon_real_delete_events (ZeitgeistRemoteLog* base, guint32* event_ids, int event_ids_length1, const char* sender, GError** error) {
	ZeitgeistDaemon * self;
	GVariant* result = NULL;
	ZeitgeistEngine* _tmp0_;
	guint32* _tmp1_;
	gint _tmp1__length1;
	const char* _tmp2_;
	ZeitgeistTimeRange* _tmp3_ = NULL;
	ZeitgeistTimeRange* time_range;
	ZeitgeistTimeRange* _tmp4_;
	ZeitgeistTimeRange* _tmp9_;
	GVariant* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistDaemon*) base;
	g_return_val_if_fail (sender != NULL, NULL);
	_tmp0_ = self->priv->engine;
	_tmp1_ = event_ids;
	_tmp1__length1 = event_ids_length1;
	_tmp2_ = sender;
	_tmp3_ = zeitgeist_engine_delete_events (_tmp0_, _tmp1_, _tmp1__length1, _tmp2_, &_inner_error_);
	time_range = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = time_range;
	if (_tmp4_ != NULL) {
		ZeitgeistMonitorManager* _tmp5_;
		ZeitgeistTimeRange* _tmp6_;
		guint32* _tmp7_;
		gint _tmp7__length1;
		_tmp5_ = self->priv->notifications;
		_tmp6_ = time_range;
		_tmp7_ = event_ids;
		_tmp7__length1 = event_ids_length1;
		zeitgeist_monitor_manager_notify_delete (_tmp5_, _tmp6_, _tmp7_, _tmp7__length1);
	} else {
		ZeitgeistTimeRange* _tmp8_;
		_tmp8_ = zeitgeist_time_range_new ((gint64) (-1), (gint64) (-1));
		_g_object_unref0 (time_range);
		time_range = _tmp8_;
	}
	_tmp9_ = time_range;
	_tmp10_ = zeitgeist_time_range_to_variant (_tmp9_);
	result = _tmp10_;
	_g_object_unref0 (time_range);
	return result;
}


static void zeitgeist_daemon_real_quit (ZeitgeistRemoteLog* base, GError** error) {
	ZeitgeistDaemon * self;
	self = (ZeitgeistDaemon*) base;
	zeitgeist_daemon_do_quit (self);
}


static void zeitgeist_daemon_do_quit (ZeitgeistDaemon* self) {
	ZeitgeistEngine* _tmp0_;
	GMainLoop* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->engine;
	zeitgeist_db_reader_close ((ZeitgeistDbReader*) _tmp0_);
	_tmp1_ = zeitgeist_daemon_mainloop;
	g_main_loop_quit (_tmp1_);
}


static void zeitgeist_daemon_real_install_monitor (ZeitgeistRemoteLog* base, const char* monitor_path, GVariant* time_range, GVariant* event_templates, const char* owner, GError** error) {
	ZeitgeistDaemon * self;
	GVariant* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	GVariant* _tmp3_;
	GPtrArray* _tmp4_ = NULL;
	GPtrArray* _tmp5_;
	ZeitgeistMonitorManager* _tmp6_;
	const char* _tmp7_;
	const char* _tmp8_;
	ZeitgeistTimeRange* _tmp9_;
	GPtrArray* _tmp10_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistDaemon*) base;
	g_return_if_fail (monitor_path != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (event_templates != NULL);
	g_return_if_fail (owner != NULL);
	_tmp0_ = time_range;
	_tmp1_ = zeitgeist_time_range_new_from_variant (_tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = event_templates;
	_tmp4_ = zeitgeist_events_from_variant (_tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp6_ = self->priv->notifications;
	_tmp7_ = owner;
	_tmp8_ = monitor_path;
	_tmp9_ = _tmp2_;
	_tmp10_ = _tmp5_;
	zeitgeist_monitor_manager_install_monitor (_tmp6_, _tmp7_, (const gchar*) _tmp8_, _tmp9_, _tmp10_);
	_g_ptr_array_unref0 (_tmp10_);
	_g_object_unref0 (_tmp9_);
}


static void zeitgeist_daemon_real_remove_monitor (ZeitgeistRemoteLog* base, const char* monitor_path, const char* owner, GError** error) {
	ZeitgeistDaemon * self;
	ZeitgeistMonitorManager* _tmp0_;
	const char* _tmp1_;
	const char* _tmp2_;
	self = (ZeitgeistDaemon*) base;
	g_return_if_fail (monitor_path != NULL);
	g_return_if_fail (owner != NULL);
	_tmp0_ = self->priv->notifications;
	_tmp1_ = owner;
	_tmp2_ = monitor_path;
	zeitgeist_monitor_manager_remove_monitor (_tmp0_, _tmp1_, (const gchar*) _tmp2_);
}


void zeitgeist_daemon_register_dbus_object (ZeitgeistDaemon* self, GDBusConnection* conn, GError** error) {
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	guint _tmp2_ = 0U;
	guint _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	_tmp0_ = conn;
	self->priv->connection = _tmp0_;
	_tmp1_ = conn;
	_tmp2_ = zeitgeist_remote_log_register_object ((ZeitgeistRemoteLog*) self, _tmp1_, "/org/gnome/zeitgeist/log/activity", &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->log_register_id = _tmp3_;
}


void zeitgeist_daemon_unregister_dbus_object (ZeitgeistDaemon* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->log_register_id;
	if (_tmp0_ != ((guint) 0)) {
		GDBusConnection* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->connection;
		_tmp2_ = self->priv->log_register_id;
		g_dbus_connection_unregister_object (_tmp1_, _tmp2_);
		self->priv->log_register_id = (guint) 0;
	}
}


static gboolean zeitgeist_daemon_quit_running_instance (GDBusConnection* conn) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (conn != NULL, FALSE);
	{
		GDBusConnection* _tmp0_;
		ZeitgeistRemoteLog* _tmp1_ = NULL;
		ZeitgeistRemoteLog* running_instance;
		ZeitgeistRemoteLog* _tmp2_;
		_tmp0_ = conn;
		_tmp1_ = g_initable_new (ZEITGEIST_TYPE_REMOTE_LOG_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", ZEITGEIST_DAEMON_DBUS_NAME, "g-connection", _tmp0_, "g-object-path", "/org/gnome/zeitgeist/log/activity", "g-interface-name", "org.gnome.zeitgeist.Log", NULL);
		running_instance = (ZeitgeistRemoteLog*) _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp2_ = running_instance;
		zeitgeist_remote_log_quit (_tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (running_instance);
			goto __catch0_g_error;
		}
		result = TRUE;
		_g_object_unref0 (running_instance);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_warning ("zeitgeist-daemon.vala:282: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static void zeitgeist_daemon_name_acquired_callback (GDBusConnection* conn) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (conn != NULL);
	zeitgeist_daemon_name_acquired = TRUE;
	_tmp0_ = zeitgeist_daemon_no_datahub;
	if (!_tmp0_) {
		{
			g_spawn_command_line_async ("zeitgeist-datahub", &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch1_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally1;
		__catch1_g_spawn_error:
		{
			GError* err = NULL;
			GError* _tmp1_;
			const gchar* _tmp2_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp1_ = err;
			_tmp2_ = _tmp1_->message;
			g_warning ("zeitgeist-daemon.vala:301: %s", _tmp2_);
			_g_error_free0 (err);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gboolean ____lambda12_ (void) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	_tmp0_ = zeitgeist_daemon_name_acquired;
	if (!_tmp0_) {
		GMainLoop* _tmp1_;
		g_warning ("zeitgeist-daemon.vala:328: Timeout reached, unable to acquire name!");
		_tmp1_ = zeitgeist_daemon_mainloop;
		g_main_loop_quit (_tmp1_);
	}
	result = FALSE;
	return result;
}


static gboolean _____lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda12_ ();
	return result;
}


static void zeitgeist_daemon_name_lost_callback (GDBusConnection* conn) {
	GDBusConnection* _tmp0_;
	_tmp0_ = conn;
	if (_tmp0_ == NULL) {
		GMainLoop* _tmp1_;
		_tmp1_ = zeitgeist_daemon_mainloop;
		g_main_loop_quit (_tmp1_);
	} else {
		gboolean _tmp2_ = FALSE;
		ZeitgeistDaemon* _tmp3_;
		gboolean _tmp5_;
		_tmp3_ = zeitgeist_daemon_instance;
		if (_tmp3_ != NULL) {
			gboolean _tmp4_;
			_tmp4_ = zeitgeist_daemon_name_acquired;
			_tmp2_ = !_tmp4_;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp5_ = _tmp2_;
		if (_tmp5_) {
			gboolean _tmp6_;
			_tmp6_ = zeitgeist_daemon_replace_mode;
			if (!_tmp6_) {
			}
			g_debug ("zeitgeist-daemon.vala:320: Waiting 10 seconds to acquire name...");
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10000, _____lambda12__gsource_func, NULL, NULL);
		} else {
			gboolean _tmp7_ = FALSE;
			ZeitgeistDaemon* _tmp8_;
			gboolean _tmp10_;
			_tmp8_ = zeitgeist_daemon_instance;
			if (_tmp8_ != NULL) {
				gboolean _tmp9_;
				_tmp9_ = zeitgeist_daemon_name_acquired;
				_tmp7_ = _tmp9_;
			} else {
				_tmp7_ = FALSE;
			}
			_tmp10_ = _tmp7_;
			if (_tmp10_) {
				GMainLoop* _tmp11_;
				_tmp11_ = zeitgeist_daemon_mainloop;
				g_main_loop_quit (_tmp11_);
			}
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void _zeitgeist_daemon_name_acquired_callback_gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	zeitgeist_daemon_name_acquired_callback (connection);
}


static void _zeitgeist_daemon_name_lost_callback_gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	zeitgeist_daemon_name_lost_callback (connection);
}


static void zeitgeist_daemon_run (GError** error) {
	GDBusConnection* connection = NULL;
	gboolean name_owned = FALSE;
	gboolean _tmp9_;
	gboolean _tmp16_;
	GDBusConnection* _tmp26_;
	guint _tmp27_ = 0U;
	guint owner_id;
	GMainLoop* _tmp28_;
	GMainLoop* _tmp29_;
	ZeitgeistDaemon* _tmp30_;
	GError * _inner_error_ = NULL;
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		GDBusConnection* _tmp2_;
		ZeitgeistRemoteDBus* _tmp3_ = NULL;
		ZeitgeistRemoteDBus* proxy;
		ZeitgeistRemoteDBus* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			_g_object_unref0 (connection);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (connection);
		connection = _tmp1_;
		_tmp2_ = connection;
		_tmp3_ = g_initable_new (ZEITGEIST_TYPE_REMOTE_DBUS_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", "org.freedesktop.DBus", "g-connection", _tmp2_, "g-object-path", "/org/freedesktop/DBus", "g-interface-name", "org.freedesktop.DBus", NULL);
		proxy = (ZeitgeistRemoteDBus*) _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			_g_object_unref0 (connection);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = proxy;
		_tmp5_ = zeitgeist_remote_dbus_name_has_owner (_tmp4_, ZEITGEIST_DAEMON_DBUS_NAME, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (proxy);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			_g_object_unref0 (proxy);
			_g_object_unref0 (connection);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		name_owned = _tmp6_;
		_g_object_unref0 (proxy);
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		GError* _tmp8_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _g_error_copy0 (_tmp7_);
		_inner_error_ = _tmp8_;
		_g_error_free0 (err);
		goto __finally2;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (connection);
		return;
	}
	_tmp9_ = name_owned;
	if (_tmp9_) {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		gboolean _tmp13_;
		_tmp11_ = zeitgeist_daemon_replace_mode;
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			gboolean _tmp12_;
			_tmp12_ = zeitgeist_daemon_quit_daemon;
			_tmp10_ = _tmp12_;
		}
		_tmp13_ = _tmp10_;
		if (_tmp13_) {
			GDBusConnection* _tmp14_;
			_tmp14_ = connection;
			zeitgeist_daemon_quit_running_instance (_tmp14_);
		} else {
			GError* _tmp15_;
			g_warning ("zeitgeist-daemon.vala:366: %s", "An existing instance was found. Please use " "--replace to stop it and start a new instance.");
			_tmp15_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE, "Zeitgeist is running already.");
			_inner_error_ = _tmp15_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (connection);
			return;
		}
	}
	_tmp16_ = zeitgeist_daemon_quit_daemon;
	if (_tmp16_) {
		_g_object_unref0 (connection);
		return;
	}
	{
		ZeitgeistDaemon* _tmp17_;
		ZeitgeistDaemon* _tmp18_;
		ZeitgeistDaemon* _tmp19_;
		GDBusConnection* _tmp20_;
		_tmp17_ = zeitgeist_daemon_new (&_inner_error_);
		_tmp18_ = _tmp17_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_g_object_unref0 (zeitgeist_daemon_instance);
		zeitgeist_daemon_instance = _tmp18_;
		_tmp19_ = zeitgeist_daemon_instance;
		_tmp20_ = connection;
		zeitgeist_daemon_register_dbus_object (_tmp19_, _tmp20_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* err = NULL;
		GError* _tmp21_;
		GError* _tmp24_;
		GError* _tmp25_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = err;
		if (g_error_matches (_tmp21_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN)) {
			const gchar* _tmp22_ = NULL;
			_tmp22_ = zeitgeist_utils_get_database_file_path ();
			g_warning ("Could not access the database file.\n" "Please check the permissions of file %s.", _tmp22_);
		} else {
			GError* _tmp23_;
			_tmp23_ = err;
			if (g_error_matches (_tmp23_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY)) {
				g_warning ("zeitgeist-daemon.vala:392: %s", "It looks like another Zeitgeist instance " "is already running (the database is locked). " "If you want to start a new instance, use --replace.");
			}
		}
		_tmp24_ = err;
		_tmp25_ = _g_error_copy0 (_tmp24_);
		_inner_error_ = _tmp25_;
		_g_error_free0 (err);
		goto __finally3;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (connection);
		return;
	}
	_tmp26_ = connection;
	_tmp27_ = g_bus_own_name_on_connection_with_closures (_tmp26_, ZEITGEIST_DAEMON_DBUS_NAME, G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_zeitgeist_daemon_name_acquired_callback_gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _zeitgeist_daemon_name_acquired_callback_gbus_name_acquired_callback, NULL, NULL)), (GClosure*) ((_zeitgeist_daemon_name_lost_callback_gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _zeitgeist_daemon_name_lost_callback_gbus_name_lost_callback, NULL, NULL)));
	owner_id = _tmp27_;
	_tmp28_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (zeitgeist_daemon_mainloop);
	zeitgeist_daemon_mainloop = _tmp28_;
	_tmp29_ = zeitgeist_daemon_mainloop;
	g_main_loop_run (_tmp29_);
	_tmp30_ = zeitgeist_daemon_instance;
	if (_tmp30_ != NULL) {
		guint _tmp31_;
		ZeitgeistDaemon* _tmp32_;
		_tmp31_ = owner_id;
		g_bus_unown_name (_tmp31_);
		_tmp32_ = zeitgeist_daemon_instance;
		zeitgeist_daemon_unregister_dbus_object (_tmp32_);
		_g_object_unref0 (zeitgeist_daemon_instance);
		zeitgeist_daemon_instance = NULL;
		{
			GDBusConnection* _tmp33_;
			_tmp33_ = connection;
			g_dbus_connection_flush_sync (_tmp33_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			GError* _tmp34_;
			const gchar* _tmp35_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp34_ = e;
			_tmp35_ = _tmp34_->message;
			g_warning ("zeitgeist-daemon.vala:421: %s", _tmp35_);
			_g_error_free0 (e);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (connection);
			return;
		}
	}
	_g_object_unref0 (connection);
}


static void zeitgeist_daemon_safe_exit (void) {
	ZeitgeistDaemon* _tmp0_;
	_tmp0_ = zeitgeist_daemon_instance;
	zeitgeist_daemon_do_quit (_tmp0_);
}


static void _zeitgeist_daemon_safe_exit_sighandler_t (gint signal) {
	zeitgeist_daemon_safe_exit ();
}


static gint zeitgeist_daemon_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_;
	GOptionContext* opt_context;
	GOptionContext* _tmp1_;
	GError * _inner_error_ = NULL;
	signal (SIGHUP, _zeitgeist_daemon_safe_exit_sighandler_t);
	signal (SIGINT, _zeitgeist_daemon_safe_exit_sighandler_t);
	signal (SIGTERM, _zeitgeist_daemon_safe_exit_sighandler_t);
	_tmp0_ = g_option_context_new (" - Zeitgeist daemon");
	opt_context = _tmp0_;
	_tmp1_ = opt_context;
	g_option_context_add_main_entries (_tmp1_, ZEITGEIST_DAEMON_options, NULL);
	{
		GOptionContext* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp5_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp2_ = opt_context;
		g_option_context_parse (_tmp2_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp3_ = zeitgeist_daemon_show_version_info;
		if (_tmp3_) {
			FILE* _tmp4_;
			_tmp4_ = stdout;
			fprintf (_tmp4_, "%s", VERSION "\n");
			result = 0;
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp5_ = zeitgeist_daemon_show_options;
		if (_tmp5_) {
			FILE* _tmp16_;
			{
				GOptionEntry* entry_collection = NULL;
				gint entry_collection_length1 = 0;
				gint _entry_collection_size_ = 0;
				gint entry_it = 0;
				entry_collection = ZEITGEIST_DAEMON_options;
				entry_collection_length1 = G_N_ELEMENTS (ZEITGEIST_DAEMON_options);
				for (entry_it = 0; entry_it < G_N_ELEMENTS (ZEITGEIST_DAEMON_options); entry_it = entry_it + 1) {
					GOptionEntry* entry = NULL;
					entry = &entry_collection[entry_it];
					{
						GOptionEntry* _tmp6_;
						const gchar* _tmp7_;
						GOptionEntry* _tmp11_;
						gchar _tmp12_;
						_tmp6_ = entry;
						_tmp7_ = (*_tmp6_).long_name;
						if (_tmp7_ != NULL) {
							FILE* _tmp8_;
							GOptionEntry* _tmp9_;
							const gchar* _tmp10_;
							_tmp8_ = stdout;
							_tmp9_ = entry;
							_tmp10_ = (*_tmp9_).long_name;
							fprintf (_tmp8_, "--%s ", _tmp10_);
						}
						_tmp11_ = entry;
						_tmp12_ = (*_tmp11_).short_name;
						if (((gint) _tmp12_) != 0) {
							FILE* _tmp13_;
							GOptionEntry* _tmp14_;
							gchar _tmp15_;
							_tmp13_ = stdout;
							_tmp14_ = entry;
							_tmp15_ = (*_tmp14_).short_name;
							fprintf (_tmp13_, "-%c ", (gint) _tmp15_);
						}
					}
				}
			}
			_tmp16_ = stdout;
			fprintf (_tmp16_, "--help\n");
			result = 0;
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp17_ = zeitgeist_daemon_log_level;
		_tmp18_ = zeitgeist_daemon_log_file;
		zeitgeist_logging_setup_logging (_tmp17_, _tmp18_);
		zeitgeist_daemon_run (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* err = NULL;
		GError* _tmp19_;
		GError* _tmp20_;
		GError* _tmp21_;
		GError* _tmp22_;
		const gchar* _tmp23_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = err;
		if (g_error_matches (_tmp19_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE)) {
			result = 10;
			_g_error_free0 (err);
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp20_ = err;
		if (g_error_matches (_tmp20_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN)) {
			result = 21;
			_g_error_free0 (err);
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp21_ = err;
		if (g_error_matches (_tmp21_, ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY)) {
			result = 22;
			_g_error_free0 (err);
			_g_option_context_free0 (opt_context);
			return result;
		}
		_tmp22_ = err;
		_tmp23_ = _tmp22_->message;
		g_warning ("zeitgeist-daemon.vala:476: %s", _tmp23_);
		result = 1;
		_g_error_free0 (err);
		_g_option_context_free0 (opt_context);
		return result;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (opt_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	_g_option_context_free0 (opt_context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return zeitgeist_daemon_main (argv, argc);
}


static gchar** zeitgeist_daemon_real_get_extensions (ZeitgeistRemoteLog* base, int* result_length1) {
	gchar** result;
	ZeitgeistDaemon* self;
	ZeitgeistEngine* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gchar** ext;
	gint ext_length1;
	gint _ext_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = (ZeitgeistDaemon*) base;
	_tmp0_ = self->priv->engine;
	_tmp2_ = zeitgeist_engine_get_extension_names (_tmp0_, &_tmp1_);
	ext = _tmp2_;
	ext_length1 = _tmp1_;
	_ext_size_ = ext_length1;
	_tmp3_ = ext;
	_tmp3__length1 = ext_length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}


static void zeitgeist_daemon_real_get_version (ZeitgeistRemoteLog* base, ZeitgeistVersionStruct* result) {
	ZeitgeistDaemon* self;
	ZeitgeistVersionStruct s = {0};
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** ver;
	gint ver_length1;
	gint _ver_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (ZeitgeistDaemon*) base;
	memset (&s, 0, sizeof (ZeitgeistVersionStruct));
	_tmp1_ = _tmp0_ = g_strsplit (VERSION, ".", 0);
	ver = _tmp1_;
	ver_length1 = _vala_array_length (_tmp0_);
	_ver_size_ = ver_length1;
	_tmp2_ = ver;
	_tmp2__length1 = ver_length1;
	if (_tmp2__length1 >= 3) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		gint _tmp5_ = 0;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gint _tmp8_ = 0;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gint _tmp11_ = 0;
		_tmp3_ = ver;
		_tmp3__length1 = ver_length1;
		_tmp4_ = _tmp3_[0];
		_tmp5_ = atoi (_tmp4_);
		s.major = _tmp5_;
		_tmp6_ = ver;
		_tmp6__length1 = ver_length1;
		_tmp7_ = _tmp6_[1];
		_tmp8_ = atoi (_tmp7_);
		s.minor = _tmp8_;
		_tmp9_ = ver;
		_tmp9__length1 = ver_length1;
		_tmp10_ = _tmp9_[2];
		_tmp11_ = atoi (_tmp10_);
		s.micro = _tmp11_;
	} else {
		g_warning ("zeitgeist-daemon.vala:120: Unable to parse version info!");
		s.major = 0;
		s.minor = 8;
		s.micro = 99;
	}
	*result = s;
	ver = (_vala_array_free (ver, ver_length1, (GDestroyNotify) g_free), NULL);
	return;
}


static void zeitgeist_daemon_class_init (ZeitgeistDaemonClass * klass) {
	gchar* _tmp0_;
	zeitgeist_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistDaemonPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_daemon_get_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_daemon_finalize;
	_tmp0_ = g_strdup ("");
	zeitgeist_daemon_log_level = _tmp0_;
}


static void zeitgeist_daemon_zeitgeist_remote_log_interface_init (ZeitgeistRemoteLogIface * iface) {
	zeitgeist_daemon_zeitgeist_remote_log_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_events = (GVariant* (*)(ZeitgeistRemoteLog*, guint32*, int, const char*, GError**)) zeitgeist_daemon_real_get_events;
	iface->find_related_uris = (gchar** (*)(ZeitgeistRemoteLog*, GVariant*, GVariant*, GVariant*, guint, guint, guint, const char*, int*, GError**)) zeitgeist_daemon_real_find_related_uris;
	iface->find_event_ids = (guint32* (*)(ZeitgeistRemoteLog*, GVariant*, GVariant*, guint, guint, guint, const char*, int*, GError**)) zeitgeist_daemon_real_find_event_ids;
	iface->find_events = (GVariant* (*)(ZeitgeistRemoteLog*, GVariant*, GVariant*, guint, guint, guint, const char*, GError**)) zeitgeist_daemon_real_find_events;
	iface->insert_events = (guint32* (*)(ZeitgeistRemoteLog*, GVariant*, const char*, int*, GError**)) zeitgeist_daemon_real_insert_events;
	iface->delete_events = (GVariant* (*)(ZeitgeistRemoteLog*, guint32*, int, const char*, GError**)) zeitgeist_daemon_real_delete_events;
	iface->quit = (void (*)(ZeitgeistRemoteLog*, GError**)) zeitgeist_daemon_real_quit;
	iface->install_monitor = (void (*)(ZeitgeistRemoteLog*, const char*, GVariant*, GVariant*, const char*, GError**)) zeitgeist_daemon_real_install_monitor;
	iface->remove_monitor = (void (*)(ZeitgeistRemoteLog*, const char*, const char*, GError**)) zeitgeist_daemon_real_remove_monitor;
	iface->get_extensions = zeitgeist_daemon_real_get_extensions;
	iface->get_version = zeitgeist_daemon_real_get_version;
}


static void zeitgeist_daemon_instance_init (ZeitgeistDaemon * self) {
	self->priv = ZEITGEIST_DAEMON_GET_PRIVATE (self);
}


static void zeitgeist_daemon_finalize (GObject* obj) {
	ZeitgeistDaemon * self;
	self = ZEITGEIST_DAEMON (obj);
	_g_object_unref0 (self->priv->engine);
	_g_object_unref0 (self->priv->notifications);
	G_OBJECT_CLASS (zeitgeist_daemon_parent_class)->finalize (obj);
}


GType zeitgeist_daemon_get_type (void) {
	static volatile gsize zeitgeist_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistDaemon), 0, (GInstanceInitFunc) zeitgeist_daemon_instance_init, NULL };
		static const GInterfaceInfo zeitgeist_remote_log_info = { (GInterfaceInitFunc) zeitgeist_daemon_zeitgeist_remote_log_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zeitgeist_daemon_type_id;
		zeitgeist_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistDaemon", &g_define_type_info, 0);
		g_type_add_interface_static (zeitgeist_daemon_type_id, ZEITGEIST_TYPE_REMOTE_LOG, &zeitgeist_remote_log_info);
		g_once_init_leave (&zeitgeist_daemon_type_id__volatile, zeitgeist_daemon_type_id);
	}
	return zeitgeist_daemon_type_id__volatile;
}


static void _vala_zeitgeist_daemon_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistDaemon * self;
	self = ZEITGEIST_DAEMON (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



