package ONVIF::PTZ::Types::PTZPresetTourSpot;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %PresetDetail_of :ATTR(:get<PresetDetail>);
my %Speed_of :ATTR(:get<Speed>);
my %StayTime_of :ATTR(:get<StayTime>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        PresetDetail
        Speed
        StayTime
        Extension

    ) ],
    {
        'PresetDetail' => \%PresetDetail_of,
        'Speed' => \%Speed_of,
        'StayTime' => \%StayTime_of,
        'Extension' => \%Extension_of,
    },
    {
        'PresetDetail' => 'ONVIF::PTZ::Types::PTZPresetTourPresetDetail',
        'Speed' => 'ONVIF::PTZ::Types::PTZSpeed',
        'StayTime' => 'SOAP::WSDL::XSD::Typelib::Builtin::duration',
        'Extension' => 'ONVIF::PTZ::Types::PTZPresetTourSpotExtension',
    },
    {

        'PresetDetail' => 'PresetDetail',
        'Speed' => 'Speed',
        'StayTime' => 'StayTime',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::PTZPresetTourSpot

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PTZPresetTourSpot from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * PresetDetail


=item * Speed


=item * StayTime


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::PTZPresetTourSpot
   PresetDetail =>    { # ONVIF::PTZ::Types::PTZPresetTourPresetDetail
     # One of the following elements.
     # No occurance checks yet, so be sure to pass just one...
     PresetToken => $some_value, # ReferenceToken
     Home =>  $some_value, # boolean
     PTZPosition =>  { # ONVIF::PTZ::Types::PTZVector
       PanTilt => ,
       Zoom => ,
     },
     TypeExtension =>  { # ONVIF::PTZ::Types::PTZPresetTourTypeExtension
     },
   },
   Speed =>  { # ONVIF::PTZ::Types::PTZSpeed
     PanTilt => ,
     Zoom => ,
   },
   StayTime =>  $some_value, # duration
   Extension =>  { # ONVIF::PTZ::Types::PTZPresetTourSpotExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

