/*
 * Decompiled with CFR 0.152.
 */
package com.zspace.helpers;

import com.zspace.Sdk3;
import com.zspace.ZSEye;
import com.zspace.ZSFrustumAttribute;
import com.zspace.ZSIntWH;
import com.zspace.ZSIntXY;
import com.zspace.ZSMatrix4;
import com.zspace.ZSTargetType;
import com.zspace.ZSTrackerPose;
import com.zspace.helpers.IDrawWithStylus;
import java.awt.Point;
import java.nio.FloatBuffer;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.gl2.GLUgl2;

public class ZSLite {
    public static boolean DEBUG = true;
    private GLUgl2 glu2 = new GLUgl2();
    private long zContext;
    private long zBuffer;
    private long zViewport;
    private long zFrustum;
    private long zStylus;
    private ZSMatrix4 viewLeftZ;
    private ZSMatrix4 viewRightZ;
    private ZSMatrix4 projLeftZ;
    private ZSMatrix4 projRightZ;
    float[] viewMain = new float[16];
    private FloatBuffer viewMainFB = FloatBuffer.wrap(this.viewMain);

    public ZSLite() {
        this.zContext = Sdk3.ZSInitialize();
        this.zBuffer = Sdk3.ZSCreateStereoBufferGL(this.zContext, 0L);
        if (DEBUG) {
            Sdk3.ZSPrintAndClearIfErrors("Problem with zStereoBuffer");
        }
        this.zViewport = Sdk3.ZSCreateViewport(this.zContext);
        if (DEBUG) {
            Sdk3.ZSPrintAndClearIfErrors("Problem with zViewport");
        }
        this.zFrustum = Sdk3.ZSFindFrustum(this.zViewport);
        if (DEBUG) {
            Sdk3.ZSPrintAndClearIfErrors("Problem with Frustum");
        }
        this.zStylus = Sdk3.ZSFindTargetByType(this.zContext, ZSTargetType.ZS_TARGET_TYPE_PRIMARY, 0);
        if (DEBUG) {
            Sdk3.ZSPrintAndClearIfErrors("Problem with Stylus");
        }
    }

    private void setMainViewpoint(GL2 gL2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        Sdk3.ZSSetFrustumAttribute(this.zFrustum, ZSFrustumAttribute.ZS_FRUSTUM_ATTRIBUTE_VIEWER_SCALE, f10);
        if (DEBUG) {
            Sdk3.ZSPrintAndClearIfErrors("Setting viewer scale");
        }
        float f11 = f10 * f;
        float f12 = f10 * f2;
        float f13 = f10 * f3;
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        this.glu2.gluLookAt(f11, f12, f13, f4, f5, f6, f7, f8, f9);
        gL2.glGetFloatv(2982, this.viewMainFB);
    }

    private void viewportUpdate(Point point, int n, int n2, float f, float f2) {
        Sdk3.ZSUpdate(this.zContext);
        if (DEBUG) {
            Sdk3.ZSPrintAndClearIfErrors("Problem updating zSpace");
        }
        ZSIntXY zSIntXY = new ZSIntXY();
        zSIntXY.setX(point.x);
        zSIntXY.setY(point.y);
        Sdk3.ZSSetViewportPosition(this.zViewport, zSIntXY);
        if (DEBUG) {
            Sdk3.ZSPrintAndClearIfErrors("Problem with Viewport position");
        }
        ZSIntWH zSIntWH = new ZSIntWH();
        zSIntWH.setW(n);
        zSIntWH.setH(n2);
        Sdk3.ZSSetViewportSize(this.zViewport, zSIntWH);
        if (DEBUG) {
            Sdk3.ZSPrintAndClearIfErrors("Problem with Viewport size");
        }
        Sdk3.ZSSetFrustumAttribute(this.zFrustum, ZSFrustumAttribute.ZS_FRUSTUM_ATTRIBUTE_NEAR_CLIP, f);
        if (DEBUG) {
            Sdk3.ZSPrintAndClearIfErrors("Problem with near clip");
        }
        Sdk3.ZSSetFrustumAttribute(this.zFrustum, ZSFrustumAttribute.ZS_FRUSTUM_ATTRIBUTE_FAR_CLIP, f2);
        if (DEBUG) {
            Sdk3.ZSPrintAndClearIfErrors("Problem with far clip");
        }
    }

    private void UpdateViewAndProjectionEyeMatrices() {
        this.viewLeftZ = Sdk3.ZSGetFrustumViewMatrix(this.zFrustum, ZSEye.ZS_EYE_LEFT);
        this.projLeftZ = Sdk3.ZSGetFrustumProjectionMatrix(this.zFrustum, ZSEye.ZS_EYE_LEFT);
        this.viewRightZ = Sdk3.ZSGetFrustumViewMatrix(this.zFrustum, ZSEye.ZS_EYE_RIGHT);
        this.projRightZ = Sdk3.ZSGetFrustumProjectionMatrix(this.zFrustum, ZSEye.ZS_EYE_RIGHT);
    }

    private void displayEye(GL2 gL2, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int n, IDrawWithStylus iDrawWithStylus) {
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glMatrixMode(5889);
        gL2.glPushMatrix();
        gL2.glMatrixMode(5888);
        gL2.glLoadMatrixf(floatBuffer);
        gL2.glMultMatrixf(this.viewMainFB);
        gL2.glMatrixMode(5889);
        gL2.glLoadMatrixf(floatBuffer2);
        gL2.glDrawBuffer(n);
        ZSTrackerPose zSTrackerPose = Sdk3.ZSGetTargetPose(this.zStylus);
        iDrawWithStylus.DrawWithStylus(gL2, zSTrackerPose.getMatrix().getF());
        gL2.glMatrixMode(5889);
        gL2.glPopMatrix();
        gL2.glMatrixMode(5888);
        gL2.glPopMatrix();
    }

    public void DrawInStereoWithStylus(GL2 gL2, Point point, int n, int n2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, IDrawWithStylus iDrawWithStylus) {
        this.setMainViewpoint(gL2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
        this.viewportUpdate(point, n, n2, f, f2);
        this.UpdateViewAndProjectionEyeMatrices();
        ZSTrackerPose zSTrackerPose = Sdk3.ZSGetTargetPose(this.zStylus);
        FloatBuffer floatBuffer = FloatBuffer.wrap(this.viewLeftZ.getF());
        FloatBuffer floatBuffer2 = FloatBuffer.wrap(this.viewRightZ.getF());
        FloatBuffer floatBuffer3 = FloatBuffer.wrap(this.projLeftZ.getF());
        FloatBuffer floatBuffer4 = FloatBuffer.wrap(this.projRightZ.getF());
        this.displayEye(gL2, floatBuffer, floatBuffer3, 1026, iDrawWithStylus);
        this.displayEye(gL2, floatBuffer2, floatBuffer4, 1027, iDrawWithStylus);
    }
}

