/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** As a special exception, The Qt Company gives you certain additional
** rights. These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "textcodec/Big5TextEncoder.h"
#include "textcodec/Big5MapTable.h"

/*
 * ucs4 to big5hkscs convert routing
 */

struct Summary16 {
    uint16_t index; /* index into big table */
	uint16_t used;  /* bitmask of used entries */
};

/* ISO-10646-UCS-4 to big5hkscs convert table */
static const uint8_t big5hkscs_to_charset[24908][2] = {
    {0x21,0x00}, {0xa2,0x46}, {0xa2,0x47}, {0xa2,0x44}, {0x7c,0x00}, {0xa1,0xb1}, {0xc6,0xd8}, {0x63,0x00}, {0x61,0x00}, {0x2d,0x00},
    {0x52,0x00}, {0xa1,0xc2}, {0xa2,0x58}, {0xa1,0xd3}, {0x32,0x00}, {0x33,0x00}, {0xa1,0xa6}, {0xa3,0x67}, {0xa1,0x50}, {0xa1,0x4d},
    {0x31,0x00}, {0x6f,0x00}, {0x3f,0x00}, {0x88,0x59}, {0x88,0x57}, {0x41,0x00}, {0x41,0x00}, {0x41,0x00}, {0x41,0x00}, {0x41,0x00},
    {0x43,0x00}, {0x88,0x5d}, {0x88,0x5b}, {0x88,0x66}, {0x45,0x00}, {0x49,0x00}, {0x49,0x00}, {0x49,0x00}, {0x49,0x00}, {0x44,0x00},
    {0x4e,0x00}, {0x88,0x61}, {0x88,0x5f}, {0x4f,0x00}, {0x4f,0x00}, {0x4f,0x00}, {0xa1,0xd1}, {0x4f,0x00}, {0x55,0x00}, {0x55,0x00},
    {0x55,0x00}, {0x55,0x00}, {0x59,0x00}, {0x54,0x00}, {0x73,0x00}, {0x88,0x6a}, {0x88,0x68}, {0x61,0x00}, {0x61,0x00}, {0x61,0x00},
    {0x61,0x00}, {0x61,0x00}, {0x63,0x00}, {0x88,0x6f}, {0x88,0x6d}, {0x88,0xa7}, {0x65,0x00}, {0x88,0x73}, {0x88,0x71}, {0x69,0x00},
    {0x69,0x00}, {0x65,0x00}, {0x6e,0x00}, {0x88,0x77}, {0x88,0x75}, {0x6f,0x00}, {0x6f,0x00}, {0x6f,0x00}, {0xa1,0xd2}, {0xc8,0xfb},
    {0x88,0x7b}, {0x88,0x79}, {0x75,0x00}, {0x88,0xa2}, {0x79,0x00}, {0x74,0x00}, {0x79,0x00}, {0x88,0x56}, {0x88,0x67}, {0x88,0x5a},
    {0x88,0x6c}, {0x88,0x5c}, {0x88,0x6e}, {0x88,0x70}, {0xc8,0xfc}, {0x88,0x5e}, {0x88,0x74}, {0xc8,0xfa}, {0x88,0x78}, {0x88,0x58},
    {0x88,0x69}, {0x88,0x72}, {0x88,0x60}, {0x88,0x76}, {0x88,0x7a}, {0x88,0x7c}, {0x88,0x7d}, {0x88,0x7e}, {0x88,0xa1}, {0xc8,0xf6},
    {0x88,0x6b}, {0xc8,0xf8}, {0xc8,0xf7}, {0x88,0xa8}, {0xc8,0xfe}, {0xc8,0xf9}, {0xc8,0xf5}, {0xc8,0xfd}, {0xc6,0xd9}, {0xa3,0xbe},
    {0xa3,0xbc}, {0xa3,0xbd}, {0xa3,0xbf}, {0xa1,0xc5}, {0xa3,0xbb}, {0xa1,0xc2}, {0xa3,0x44}, {0xa3,0x45}, {0xa3,0x46}, {0xa3,0x47},
    {0xa3,0x48}, {0xa3,0x49}, {0xa3,0x4a}, {0xa3,0x4b}, {0xa3,0x4c}, {0xa3,0x4d}, {0xa3,0x4e}, {0xa3,0x4f}, {0xa3,0x50}, {0xa3,0x51},
    {0xa3,0x52}, {0xa3,0x53}, {0xa3,0x54}, {0xa3,0x55}, {0xa3,0x56}, {0xa3,0x57}, {0xa3,0x58}, {0xa3,0x59}, {0xa3,0x5a}, {0xa3,0x5b},
    {0xa3,0x5c}, {0xa3,0x5d}, {0xa3,0x5e}, {0xa3,0x5f}, {0xa3,0x60}, {0xa3,0x61}, {0xa3,0x62}, {0xa3,0x63}, {0xa3,0x64}, {0xa3,0x65},
    {0xa3,0x66}, {0xa3,0x67}, {0xa3,0x68}, {0xa3,0x69}, {0xa3,0x6a}, {0xa3,0x6b}, {0xa3,0x6c}, {0xa3,0x6d}, {0xa3,0x6e}, {0xa3,0x6f},
    {0xa3,0x70}, {0xa3,0x71}, {0xa3,0x72}, {0xa3,0x73}, {0xc7,0xf9}, {0xc7,0xf3}, {0xc7,0xf4}, {0xc7,0xf5}, {0xc7,0xf6}, {0xc7,0xf7},
    {0xc7,0xf8}, {0xc7,0xfa}, {0xc7,0xfb}, {0xc7,0xfc}, {0xc7,0xfd}, {0xc7,0xfe}, {0xc8,0x40}, {0xc8,0x41}, {0xc8,0x42}, {0xc8,0x43},
    {0xc8,0x44}, {0xc8,0x45}, {0xc8,0x46}, {0xc8,0x47}, {0xc8,0x48}, {0xc8,0x49}, {0xc8,0x4a}, {0xc8,0x4b}, {0xc8,0x4c}, {0xc8,0x4d},
    {0xc8,0x4e}, {0xc8,0x4f}, {0xc8,0x50}, {0xc8,0x51}, {0xc8,0x52}, {0xc8,0x53}, {0xc8,0x54}, {0xc8,0x55}, {0xc8,0x56}, {0xc8,0x57},
    {0xc8,0x58}, {0xc8,0x59}, {0xc8,0x5a}, {0xc8,0x5c}, {0xc8,0x5d}, {0xc8,0x5e}, {0xc8,0x5f}, {0xc8,0x60}, {0xc8,0x61}, {0xc8,0x62},
    {0xc8,0x63}, {0xc8,0x64}, {0xc8,0x65}, {0xc8,0x66}, {0xc8,0x67}, {0xc8,0x68}, {0xc8,0x69}, {0xc8,0x6a}, {0xc8,0x6b}, {0xc8,0x6c},
    {0xc8,0x6d}, {0xc8,0x6e}, {0xc8,0x6f}, {0xc8,0x70}, {0xc8,0x71}, {0xc8,0x72}, {0xc8,0x73}, {0xc8,0x74}, {0xc8,0x75}, {0xc8,0x5b},
    {0x88,0x63}, {0x88,0xa4}, {0x88,0x65}, {0x88,0xa6}, {0xa1,0x56}, {0xa1,0x58}, {0xa2,0x77}, {0xa1,0xfc}, {0xa1,0xa5}, {0xa1,0xa6},
    {0xa1,0xa7}, {0xa1,0xa8}, {0xa1,0x45}, {0xa3,0xbb}, {0xa1,0x4c}, {0xa1,0x4b}, {0xa1,0x45}, {0xa1,0xac}, {0xa1,0xb2}, {0xa1,0xab},
    {0xa1,0xb0}, {0xa1,0xc3}, {0xa3,0xe1}, {0xa2,0x4a}, {0xa1,0xc1}, {0xa2,0x4b}, {0xc8,0xd2}, {0xc8,0xd3}, {0xa2,0xb9}, {0xa2,0xba},
    {0xa2,0xbb}, {0xa2,0xbc}, {0xa2,0xbd}, {0xa2,0xbe}, {0xa2,0xbf}, {0xa2,0xc0}, {0xa2,0xc1}, {0xa2,0xc2}, {0xc6,0xb5}, {0xc6,0xb6},
    {0xc6,0xb7}, {0xc6,0xb8}, {0xc6,0xb9}, {0xc6,0xba}, {0xc6,0xbb}, {0xc6,0xbc}, {0xc6,0xbd}, {0xc6,0xbe}, {0xa1,0xf6}, {0xa1,0xf4},
    {0xa1,0xf7}, {0xa1,0xf5}, {0xa1,0xf8}, {0xa1,0xf9}, {0xa1,0xfb}, {0xa1,0xfa}, {0xc8,0x77}, {0xc8,0x78}, {0xc8,0x76}, {0xa2,0x41},
    {0xa2,0x42}, {0xa2,0x58}, {0xa1,0xd4}, {0xa1,0xdb}, {0xa1,0xe8}, {0xa1,0xe7}, {0xa1,0xfd}, {0xa1,0xfc}, {0xa1,0xe4}, {0xa1,0xe5},
    {0xa1,0xec}, {0xa1,0xed}, {0xa1,0xef}, {0xa1,0xee}, {0xa1,0xdc}, {0xa1,0xda}, {0xa1,0xdd}, {0xa1,0xdd}, {0xa1,0xd8}, {0xa1,0xd9},
    {0xa1,0xf2}, {0xa1,0xf3}, {0xa1,0xe6}, {0xa1,0xe9}, {0xa1,0x5b}, {0xc6,0xa1}, {0xc6,0xa2}, {0xc6,0xa3}, {0xc6,0xa4}, {0xc6,0xa5},
    {0xc6,0xa6}, {0xc6,0xa7}, {0xc6,0xa8}, {0xc6,0xa9}, {0xc6,0xaa}, {0xc6,0xab}, {0xc6,0xac}, {0xc6,0xad}, {0xc6,0xae}, {0xc6,0xaf},
    {0xc6,0xb0}, {0xc6,0xb1}, {0xc6,0xb2}, {0xc6,0xb3}, {0xc6,0xb4}, {0xa2,0x77}, {0xa2,0x78}, {0xa2,0x7a}, {0xa2,0x7b}, {0xa2,0x7c},
    {0xa2,0x7d}, {0xa2,0x75}, {0xa2,0x74}, {0xa2,0x73}, {0xa2,0x72}, {0xa2,0x71}, {0xf9,0xf9}, {0xf9,0xf8}, {0xf9,0xe6}, {0xf9,0xef},
    {0xf9,0xdd}, {0xf9,0xe8}, {0xf9,0xf1}, {0xf9,0xdf}, {0xf9,0xec}, {0xf9,0xf5}, {0xf9,0xe3}, {0xf9,0xee}, {0xf9,0xf7}, {0xf9,0xe5},
    {0xf9,0xe9}, {0xf9,0xf2}, {0xf9,0xe0}, {0xf9,0xeb}, {0xf9,0xf4}, {0xf9,0xe2}, {0xf9,0xe7}, {0xf9,0xf0}, {0xf9,0xde}, {0xf9,0xed},
    {0xf9,0xf6}, {0xf9,0xe4}, {0xf9,0xea}, {0xf9,0xf3}, {0xf9,0xe1}, {0xf9,0xfa}, {0xf9,0xfb}, {0xf9,0xfd}, {0xf9,0xfc}, {0xa2,0xac},
    {0xa2,0xad}, {0xa2,0xae}, {0xa1,0x5a}, {0xa2,0x62}, {0xa2,0x63}, {0xa2,0x64}, {0xa2,0x65}, {0xa2,0x66}, {0xa2,0x67}, {0xa2,0x68},
    {0xa2,0x69}, {0xa2,0x70}, {0xa2,0x6f}, {0xa2,0x6e}, {0xa2,0x6d}, {0xa2,0x6c}, {0xa2,0x6b}, {0xa2,0x6a}, {0xf9,0xfe}, {0xa2,0x76},
    {0xa2,0x79}, {0xa1,0xbd}, {0xa1,0xbc}, {0xa1,0xb6}, {0xa1,0xb5}, {0xa1,0xbf}, {0xa1,0xbe}, {0xa1,0xbb}, {0xa1,0xba}, {0xa1,0xb3},
    {0xa1,0xb7}, {0xa1,0xb4}, {0xa2,0xa8}, {0xa2,0xa9}, {0xa2,0xab}, {0xa2,0xaa}, {0xa1,0xb9}, {0xa1,0xb8}, {0xa1,0xf3}, {0xa1,0xf0},
    {0xa1,0xf2}, {0xa1,0xf1}, {0xc6,0xe6}, {0xc8,0xd6}, {0xc8,0xd7}, {0xc8,0xd8}, {0xc8,0xd9}, {0xc8,0xda}, {0xc8,0xdb}, {0xc8,0xdc},
    {0xc8,0xdd}, {0xc8,0xde}, {0xc8,0xdf}, {0xc8,0xe0}, {0xc8,0xe1}, {0xc8,0xe2}, {0xc8,0xe3}, {0xc8,0xe4}, {0xc8,0xe5}, {0xc8,0xe6},
    {0xc8,0xe7}, {0xc8,0xe8}, {0xc8,0xe9}, {0xc8,0xea}, {0xc8,0xeb}, {0xc8,0xec}, {0xc8,0xed}, {0xc8,0xee}, {0xc8,0xef}, {0xc8,0xf0},
    {0xc8,0xf1}, {0xc6,0xcd}, {0xa1,0x40}, {0xa1,0x42}, {0xa1,0x43}, {0xa1,0xb2}, {0xc6,0xe0}, {0xc6,0xe1}, {0xc6,0xe2}, {0xa1,0x71},
    {0xa1,0x72}, {0xa1,0x6d}, {0xa1,0x6e}, {0xa1,0x75}, {0xa1,0x76}, {0xa1,0x79}, {0xa1,0x7a}, {0xa1,0x69}, {0xa1,0x6a}, {0xa2,0x45},
    {0xa1,0x65}, {0xa1,0x66}, {0xa1,0xe3}, {0xa1,0xa9}, {0xa1,0xaa}, {0xa2,0xc3}, {0xa2,0xc4}, {0xa2,0xc5}, {0xa2,0xc6}, {0xa2,0xc7},
    {0xa2,0xc8}, {0xa2,0xc9}, {0xa2,0xca}, {0xa2,0xcb}, {0xa1,0xca}, {0xc6,0xe7}, {0xc6,0xe8}, {0xc6,0xe9}, {0xc6,0xea}, {0xc6,0xeb},
    {0xc6,0xec}, {0xc6,0xed}, {0xc6,0xee}, {0xc6,0xef}, {0xc6,0xf0}, {0xc6,0xf1}, {0xc6,0xf2}, {0xc6,0xf3}, {0xc6,0xf4}, {0xc6,0xf5},
    {0xc6,0xf6}, {0xc6,0xf7}, {0xc6,0xf8}, {0xc6,0xf9}, {0xc6,0xfa}, {0xc6,0xfb}, {0xc6,0xfc}, {0xc6,0xfd}, {0xc6,0xfe}, {0xc7,0x40},
    {0xc7,0x41}, {0xc7,0x42}, {0xc7,0x43}, {0xc7,0x44}, {0xc7,0x45}, {0xc7,0x46}, {0xc7,0x47}, {0xc7,0x48}, {0xc7,0x49}, {0xc7,0x4a},
    {0xc7,0x4b}, {0xc7,0x4c}, {0xc7,0x4d}, {0xc7,0x4e}, {0xc7,0x4f}, {0xc7,0x50}, {0xc7,0x51}, {0xc7,0x52}, {0xc7,0x53}, {0xc7,0x54},
    {0xc7,0x55}, {0xc7,0x56}, {0xc7,0x57}, {0xc7,0x58}, {0xc7,0x59}, {0xc7,0x5a}, {0xc7,0x5b}, {0xc7,0x5c}, {0xc7,0x5d}, {0xc7,0x5e},
    {0xc7,0x5f}, {0xc7,0x60}, {0xc7,0x61}, {0xc7,0x62}, {0xc7,0x63}, {0xc7,0x64}, {0xc7,0x65}, {0xc7,0x66}, {0xc7,0x67}, {0xc7,0x68},
    {0xc7,0x69}, {0xc7,0x6a}, {0xc7,0x6b}, {0xc7,0x6c}, {0xc7,0x6d}, {0xc7,0x6e}, {0xc7,0x6f}, {0xc7,0x70}, {0xc7,0x71}, {0xc7,0x72},
    {0xc7,0x73}, {0xc7,0x74}, {0xc7,0x75}, {0xc7,0x76}, {0xc7,0x77}, {0xc7,0x78}, {0xc7,0x79}, {0xc7,0x7a}, {0xc8,0xd4}, {0xc8,0xd5},
    {0xc6,0xdc}, {0xc6,0xdd}, {0xc7,0x7b}, {0xc7,0x7c}, {0xc7,0x7d}, {0xc7,0x7e}, {0xc7,0xa1}, {0xc7,0xa2}, {0xc7,0xa3}, {0xc7,0xa4},
    {0xc7,0xa5}, {0xc7,0xa6}, {0xc7,0xa7}, {0xc7,0xa8}, {0xc7,0xa9}, {0xc7,0xaa}, {0xc7,0xab}, {0xc7,0xac}, {0xc7,0xad}, {0xc7,0xae},
    {0xc7,0xaf}, {0xc7,0xb0}, {0xc7,0xb1}, {0xc7,0xb2}, {0xc7,0xb3}, {0xc7,0xb4}, {0xc7,0xb5}, {0xc7,0xb6}, {0xc7,0xb7}, {0xc7,0xb8},
    {0xc7,0xb9}, {0xc7,0xba}, {0xc7,0xbb}, {0xc7,0xbc}, {0xc7,0xbd}, {0xc7,0xbe}, {0xc7,0xbf}, {0xc7,0xc0}, {0xc7,0xc1}, {0xc7,0xc2},
    {0xc7,0xc3}, {0xc7,0xc4}, {0xc7,0xc5}, {0xc7,0xc6}, {0xc7,0xc7}, {0xc7,0xc8}, {0xc7,0xc9}, {0xc7,0xca}, {0xc7,0xcb}, {0xc7,0xcc},
    {0xc7,0xcd}, {0xc7,0xce}, {0xc7,0xcf}, {0xc7,0xd0}, {0xc7,0xd1}, {0xc7,0xd2}, {0xc7,0xd3}, {0xc7,0xd4}, {0xc7,0xd5}, {0xc7,0xd6},
    {0xc7,0xd7}, {0xc7,0xd8}, {0xc7,0xd9}, {0xc7,0xda}, {0xc7,0xdb}, {0xc7,0xdc}, {0xc7,0xdd}, {0xc7,0xde}, {0xc7,0xdf}, {0xc7,0xe0},
    {0xc7,0xe1}, {0xc7,0xe2}, {0xc7,0xe3}, {0xc7,0xe4}, {0xc7,0xe5}, {0xc7,0xe6}, {0xc7,0xe7}, {0xc7,0xe8}, {0xc7,0xe9}, {0xc7,0xea},
    {0xc7,0xeb}, {0xc7,0xec}, {0xc7,0xed}, {0xc7,0xee}, {0xc7,0xef}, {0xc7,0xf0}, {0xc7,0xf1}, {0xc7,0xf2}, {0xc6,0xe3}, {0xc6,0xda},
    {0xc6,0xdb}, {0xa3,0x74}, {0xa3,0x75}, {0xa3,0x76}, {0xa3,0x77}, {0xa3,0x78}, {0xa3,0x79}, {0xa3,0x7a}, {0xa3,0x7b}, {0xa3,0x7c},
    {0xa3,0x7d}, {0xa3,0x7e}, {0xa3,0xa1}, {0xa3,0xa2}, {0xa3,0xa3}, {0xa3,0xa4}, {0xa3,0xa5}, {0xa3,0xa6}, {0xa3,0xa7}, {0xa3,0xa8},
    {0xa3,0xa9}, {0xa3,0xaa}, {0xa3,0xab}, {0xa3,0xac}, {0xa3,0xad}, {0xa3,0xae}, {0xa3,0xaf}, {0xa3,0xb0}, {0xa3,0xb1}, {0xa3,0xb2},
    {0xa3,0xb3}, {0xa3,0xb4}, {0xa3,0xb5}, {0xa3,0xb6}, {0xa3,0xb7}, {0xa3,0xb8}, {0xa3,0xb9}, {0xa3,0xba}, {0xa4,0x40}, {0xa4,0x47},
    {0xa4,0x54}, {0xa5,0x7c}, {0xa4,0x57}, {0xa4,0xa4}, {0xa4,0x55}, {0xa5,0xd2}, {0xa4,0x41}, {0xa4,0xfe}, {0xa4,0x42}, {0xa4,0xd1},
    {0xa6,0x61}, {0xa4,0x48}, {0xa4,0x40}, {0xa4,0x47}, {0xa4,0x54}, {0xa5,0x7c}, {0xa4,0xad}, {0xa4,0xbb}, {0xa4,0x43}, {0xa4,0x4b},
    {0xa4,0x45}, {0xa4,0x51}, {0xa4,0xeb}, {0xa4,0xf5}, {0xa4,0xf4}, {0xa4,0xec}, {0xaa,0xf7}, {0xa4,0x67}, {0xa4,0xe9}, {0xc8,0xd1},
    {0xa6,0xb3}, {0xaa,0xc0}, {0xa6,0x57}, {0xaf,0x53}, {0xb0,0x5d}, {0xaf,0xac}, {0xb3,0xd2}, {0xa5,0x4e}, {0xa9,0x49}, {0xbe,0xc7},
    {0xba,0xca}, {0xa5,0xf8}, {0xb8,0xea}, {0xa8,0xf3}, {0xb2,0xbd}, {0xa5,0xf0}, {0xa6,0xdb}, {0xa6,0xdc}, {0xa4,0x40}, {0xa4,0x47},
    {0xa4,0x54}, {0xa5,0x7c}, {0xa4,0xad}, {0xa4,0xbb}, {0xa4,0x43}, {0xa4,0x4b}, {0xa4,0x45}, {0xa4,0x51}, {0xa4,0xeb}, {0xa4,0xf5},
    {0xa4,0xf4}, {0xa4,0xec}, {0xaa,0xf7}, {0xa4,0x67}, {0xa4,0xe9}, {0xae,0xe8}, {0xa6,0xb3}, {0xaa,0xc0}, {0xa6,0x57}, {0xaf,0x53},
    {0xb0,0x5d}, {0xaf,0xac}, {0xb3,0xd2}, {0xaf,0xb5}, {0xa8,0x6b}, {0xa4,0x6b}, {0xbe,0x41}, {0xc0,0x75}, {0xa6,0x4c}, {0xaa,0x60},
    {0xb6,0xb5}, {0xa5,0xf0}, {0xbc,0x67}, {0xa1,0xc0}, {0xa4,0x57}, {0xa4,0xa4}, {0xa4,0x55}, {0xa5,0xaa}, {0xa5,0x6b}, {0xc2,0xe5},
    {0xa9,0x76}, {0xbe,0xc7}, {0xba,0xca}, {0xa5,0xf8}, {0xb8,0xea}, {0xa8,0xf3}, {0xa9,0x5d}, {0xa2,0x55}, {0xa2,0x56}, {0xa2,0x50},
    {0xa2,0x51}, {0xa2,0x52}, {0xa2,0x54}, {0xa2,0x57}, {0xa2,0x53}, {0xa1,0xeb}, {0xa1,0xea}, {0xa2,0x4f}, {0x92,0x77}, {0x96,0xdf},
    {0x89,0xd5}, {0x93,0xcd}, {0x9b,0xdf}, {0xfa,0x68}, {0x89,0xda}, {0x8f,0x59}, {0x89,0xdb}, {0x8f,0x5d}, {0x89,0xdc}, {0x96,0xf7},
    {0x8a,0xda}, {0x8b,0xdc}, {0x97,0xdb}, {0x9e,0x53}, {0x9d,0xaa}, {0x9b,0xea}, {0x8a,0x6e}, {0x8b,0xc8}, {0x89,0xe8}, {0x89,0xea},
    {0x8c,0x4b}, {0xfb,0x70}, {0x89,0xed}, {0x94,0xdd}, {0x89,0xee}, {0x9e,0xb4}, {0x8a,0xd3}, {0x92,0xdb}, {0x94,0xdb}, {0x89,0xf9},
    {0xfb,0x7a}, {0x89,0xfb}, {0x9e,0xfc}, {0x89,0xfc}, {0x89,0xbf}, {0x89,0xfe}, {0x89,0xe6}, {0x9d,0x46}, {0x9d,0xee}, {0xa0,0x7e},
    {0xa0,0x68}, {0x98,0xe9}, {0x8b,0x68}, {0x8d,0xfd}, {0x8b,0xbe}, {0x9f,0xd9}, {0x8a,0xeb}, {0x9f,0xd7}, {0x8b,0x6a}, {0x9c,0x5c},
    {0x8b,0xb1}, {0xfb,0x5e}, {0x9d,0xf3}, {0xa0,0xd0}, {0xfc,0x66}, {0x92,0xe9}, {0x9a,0xec}, {0x8f,0xab}, {0xfa,0x48}, {0x8e,0x45},
    {0x9c,0x6f}, {0x9e,0xde}, {0x89,0xef}, {0x96,0xe9}, {0x9e,0xbb}, {0x94,0xde}, {0x9e,0xb8}, {0x97,0xba}, {0xfb,0x65}, {0x95,0xd6},
    {0x9c,0xbb}, {0x97,0xda}, {0x8f,0x45}, {0xfb,0x7d}, {0x91,0x58}, {0xfe,0x64}, {0x98,0x56}, {0x9b,0x4d}, {0x93,0x5b}, {0x95,0xc7},
    {0x97,0xe7}, {0x93,0x59}, {0x91,0xf5}, {0x97,0xb8}, {0xfd,0xa2}, {0xfb,0xb6}, {0x92,0xfa}, {0x93,0x57}, {0x8b,0xa6}, {0xfb,0xb9},
    {0x97,0xb0}, {0xfd,0xc4}, {0x9c,0xa1}, {0x91,0xf2}, {0x91,0xf9}, {0x8f,0xf1}, {0x97,0x45}, {0x98,0x53}, {0xfe,0x78}, {0xfb,0xc1},
    {0x92,0x51}, {0x9d,0xad}, {0xfd,0x6c}, {0xfa,0x6b}, {0x9b,0xc2}, {0x9a,0x7b}, {0x8b,0x60}, {0x93,0x4b}, {0x9a,0xbd}, {0x91,0xb7},
    {0x95,0xb4}, {0xfe,0xc5}, {0x9e,0xf0}, {0x8d,0x64}, {0x92,0x69}, {0x8d,0x67}, {0xfb,0xea}, {0xfb,0xef}, {0x8d,0x68}, {0x93,0xeb},
    {0xfc,0x42}, {0x91,0x66}, {0xfa,0xcd}, {0x93,0xdd}, {0x8b,0xcc}, {0x8d,0x6d}, {0x8d,0x6e}, {0x96,0xa8}, {0xfc,0xa6}, {0x8d,0x6f},
    {0x8d,0x70}, {0xfc,0x64}, {0x90,0x60}, {0x8d,0x74}, {0x97,0xc3}, {0x8a,0xd0}, {0x92,0x74}, {0x9b,0xbe}, {0x9c,0xc8}, {0x9c,0xba},
    {0x8d,0x78}, {0x9e,0xb9}, {0x95,0x5a}, {0x91,0xb4}, {0x8a,0x48}, {0x8d,0x7d}, {0x8a,0x7d}, {0x8a,0xc2}, {0xfd,0x4a}, {0x8d,0xa1},
    {0x8a,0xd1}, {0xfc,0xb4}, {0x8b,0x47}, {0x93,0xa4}, {0x9e,0xda}, {0x8a,0x51}, {0x8d,0xa6}, {0x9e,0xc5}, {0xfc,0xc4}, {0xa0,0x78},
    {0x94,0xb5}, {0xfc,0xc2}, {0x8a,0x6b}, {0x8d,0xab}, {0xfa,0xe8}, {0x8d,0xad}, {0xfc,0x49}, {0x93,0xc1}, {0x90,0x6f}, {0x8d,0xb0},
    {0x94,0x7e}, {0x90,0xfa}, {0x94,0x79}, {0x8d,0xb2}, {0xfc,0xee}, {0x99,0x7b}, {0x8d,0xb4}, {0x8d,0xb7}, {0x91,0xb3}, {0x8d,0xbb},
    {0x8d,0xba}, {0x8d,0xbc}, {0x90,0x44}, {0xfd,0x4c}, {0x93,0xe4}, {0x93,0xe0}, {0xfd,0x53}, {0x8d,0xc3}, {0x9b,0xb8}, {0xfb,0xf0},
    {0x93,0xe9}, {0x93,0xf6}, {0x8d,0xc5}, {0x8d,0xca}, {0x8d,0xcc}, {0xfd,0x5d}, {0x93,0xb5}, {0xfd,0x61}, {0x9c,0xf8}, {0x92,0x52},
    {0xa0,0xe8}, {0x9c,0xa5}, {0x8c,0x56}, {0x8d,0xd6}, {0x97,0xc0}, {0xa0,0xde}, {0x97,0xd2}, {0xfa,0xa5}, {0xfd,0xa3}, {0x8d,0xdb},
    {0x8e,0xaf}, {0x91,0xb5}, {0xfd,0x49}, {0xfd,0xd1}, {0x8d,0xeb}, {0x97,0xc6}, {0xfd,0xce}, {0x90,0xfc}, {0xfc,0x59}, {0x96,0xd6},
    {0x97,0xc5}, {0x8d,0xef}, {0x97,0xd7}, {0x8d,0xf0}, {0x96,0xa6}, {0xfb,0xbf}, {0x8d,0xf3}, {0x94,0x49}, {0x8d,0xf5}, {0x98,0x72},
    {0x8e,0x6b}, {0xfa,0xfd}, {0x8f,0x50}, {0x9d,0xcc}, {0xfc,0x65}, {0x8c,0x44}, {0x99,0x6e}, {0x94,0xa1}, {0x8f,0x63}, {0xa0,0xda},
    {0x92,0x53}, {0xfd,0xe9}, {0x9d,0xb5}, {0x98,0x79}, {0x9d,0x5d}, {0x8d,0x63}, {0x96,0x69}, {0x9f,0x70}, {0xfc,0x6a}, {0x8a,0xc7},
    {0x89,0xd7}, {0xfe,0x4d}, {0x9e,0xdd}, {0xfe,0xfb}, {0x98,0xbc}, {0xfa,0xcc}, {0x95,0xb0}, {0x94,0x64}, {0x93,0x6f}, {0x94,0xb9},
    {0x95,0xec}, {0x91,0xee}, {0x98,0xc3}, {0x95,0xf6}, {0x8f,0xfd}, {0x98,0xc5}, {0x97,0x66}, {0xfe,0x6e}, {0x97,0xdd}, {0x8c,0xaa},
    {0x92,0xd2}, {0x97,0x61}, {0x98,0xcb}, {0x95,0xf0}, {0x97,0x5d}, {0x91,0xe3}, {0x98,0xcc}, {0x94,0x69}, {0x98,0xcd}, {0x98,0xce},
    {0x95,0xfc}, {0x94,0xa3}, {0x96,0x62}, {0xfe,0xb6}, {0x94,0x63}, {0x98,0xd0}, {0x98,0xd1}, {0x94,0x75}, {0xfa,0xe0}, {0x94,0x72},
    {0x98,0xd6}, {0x8a,0xf0}, {0x98,0xd9}, {0x98,0xdb}, {0x98,0xdd}, {0x98,0xa8}, {0x8a,0x6d}, {0x8a,0xfb}, {0x8a,0xae}, {0xfb,0xc9},
    {0x8c,0x5d}, {0x98,0xe4}, {0x98,0xe6}, {0x98,0xe8}, {0x8a,0x4d}, {0x92,0x57}, {0x95,0xdf}, {0xa0,0xac}, {0x98,0xeb}, {0x98,0xec},
    {0x8c,0xc3}, {0x98,0xf4}, {0x8a,0xb8}, {0x9e,0xe7}, {0x94,0xbc}, {0xfc,0xd1}, {0x9c,0xc6}, {0x9e,0x7e}, {0x98,0xfe}, {0xfd,0xe8},
    {0x99,0x40}, {0x94,0xc9}, {0x94,0xd3}, {0x99,0x46}, {0x90,0xc0}, {0x94,0xd1}, {0x95,0x73}, {0x93,0xc2}, {0x99,0x48}, {0x99,0x4b},
    {0x8e,0x55}, {0x99,0x4e}, {0x8e,0xfe}, {0x8e,0x59}, {0x94,0xec}, {0x94,0xef}, {0x8c,0x60}, {0x8f,0x74}, {0x99,0x55}, {0x95,0x44},
    {0x8c,0xcb}, {0x99,0x56}, {0x99,0x59}, {0x99,0x5b}, {0x8c,0xc4}, {0xfa,0x45}, {0x90,0xb7}, {0x97,0x43}, {0x95,0xcd}, {0x97,0xc9},
    {0xfd,0x50}, {0x8e,0xb9}, {0x95,0xc6}, {0x99,0x67}, {0x8a,0xb9}, {0x8d,0xfc}, {0x8a,0x76}, {0x9d,0x51}, {0x99,0x73}, {0x9d,0x4f},
    {0x99,0x7a}, {0x95,0x64}, {0x99,0xa1}, {0x99,0xa5}, {0x99,0xa7}, {0x8e,0xed}, {0x99,0xad}, {0x94,0x6e}, {0x8f,0x70}, {0xfa,0xd0},
    {0x99,0xb3}, {0xa0,0x53}, {0x96,0x5c}, {0xfd,0x7a}, {0x97,0xfe}, {0x92,0xbd}, {0x97,0xfd}, {0x8f,0x64}, {0xfc,0xf7}, {0x95,0x62},
    {0x97,0xcd}, {0x9e,0x64}, {0x92,0x4c}, {0x8e,0xc9}, {0x99,0xbc}, {0x9d,0xa5}, {0x8f,0x54}, {0x8f,0x7c}, {0x8e,0xa2}, {0x8f,0x7a},
    {0x97,0xae}, {0x96,0xc8}, {0x99,0xc3}, {0x90,0xd6}, {0x9c,0xbe}, {0x8f,0x76}, {0x94,0x70}, {0xfb,0x4b}, {0xfd,0xca}, {0x8e,0xc7},
    {0xa0,0xf9}, {0x8f,0xa9}, {0x99,0xc7}, {0x90,0xd7}, {0x9e,0xdf}, {0x99,0xce}, {0x8f,0xba}, {0x8f,0xeb}, {0x99,0xcf}, {0x8f,0xc2},
    {0x92,0xc9}, {0x97,0xdc}, {0x95,0xb3}, {0x9c,0x79}, {0x95,0xb2}, {0x8f,0xdb}, {0x9b,0xe3}, {0x9e,0x7a}, {0x9b,0xee}, {0x99,0xde},
    {0xfa,0xfa}, {0x9e,0xe5}, {0x8a,0x52}, {0x99,0xe1}, {0x8a,0x67}, {0x8b,0xb5}, {0x8a,0xac}, {0x99,0xe9}, {0xfb,0xca}, {0x97,0xde},
    {0x95,0xd1}, {0x99,0xf5}, {0xfc,0x4a}, {0x9b,0xa9}, {0xfb,0xdc}, {0xfe,0x56}, {0x9e,0xa4}, {0x9d,0x49}, {0x95,0xdb}, {0x89,0xc5},
    {0x99,0xf8}, {0x96,0x64}, {0x90,0x55}, {0x96,0xd4}, {0x97,0x7c}, {0x96,0x4d}, {0x97,0xe1}, {0x9a,0x48}, {0x9a,0x49}, {0xfe,0x7d},
    {0x90,0xaa}, {0x9a,0x50}, {0x93,0x47}, {0x8e,0xd8}, {0x90,0xc9}, {0x9a,0x55}, {0x90,0xbc}, {0x9a,0x58}, {0x8b,0xb8}, {0x90,0xd5},
    {0x96,0x41}, {0x9a,0x5a}, {0x9a,0x5c}, {0x97,0xc2}, {0x8a,0xbb}, {0x9b,0xaa}, {0x90,0xf5}, {0x9a,0x60}, {0x91,0x45}, {0x8c,0x58},
    {0x9a,0x63}, {0x8c,0x49}, {0x8b,0xb6}, {0xfc,0xcf}, {0x96,0x6b}, {0x9a,0x6e}, {0x91,0x4f}, {0x97,0x46}, {0xa0,0xe6}, {0x92,0xd7},
    {0x96,0x75}, {0x93,0xd4}, {0x91,0xbb}, {0x96,0x79}, {0x9a,0x70}, {0x96,0x78}, {0x91,0xcd}, {0x9c,0x4a}, {0xa0,0x6f}, {0xa0,0x6a},
    {0x91,0x5f}, {0x9f,0xa5}, {0x89,0xba}, {0x9e,0xcd}, {0x9a,0x79}, {0x9d,0xce}, {0x8c,0xd2}, {0x9d,0x73}, {0x96,0xb9}, {0x96,0xbc},
    {0x9c,0xd1}, {0x89,0xb7}, {0x9e,0xee}, {0xfb,0x43}, {0x9e,0xc9}, {0xfb,0xd3}, {0x91,0xae}, {0x9d,0x78}, {0x9d,0x7b}, {0xa4,0x40},
    {0xa4,0x42}, {0xa4,0x43}, {0x9e,0xb3}, {0xc9,0x45}, {0xa4,0x56}, {0xa4,0x54}, {0xa4,0x57}, {0xa4,0x55}, {0xc9,0x46}, {0xa4,0xa3},
    {0xc9,0x4f}, {0xc9,0x4d}, {0xa4,0xa2}, {0xa4,0xa1}, {0xa5,0x42}, {0xa5,0x41}, {0xa5,0x40}, {0xa5,0x43}, {0xa4,0xfe}, {0x9e,0xb2},
    {0x9d,0xd6}, {0xa5,0xe0}, {0xa5,0xe1}, {0x99,0x4f}, {0x89,0xce}, {0xa8,0xc3}, {0x8b,0xc0}, {0x9f,0xc4}, {0xa4,0x58}, {0x8b,0xd4},
    {0xa4,0xa4}, {0xc9,0x50}, {0x8c,0x72}, {0xa4,0xa5}, {0xc9,0x63}, {0xa6,0xea}, {0xcb,0xb1}, {0xc6,0xbf}, {0x8b,0xf9}, {0xa4,0x59},
    {0xa4,0xa6}, {0xa5,0x44}, {0xc9,0x64}, {0x89,0x46}, {0xc6,0xc0}, {0xc9,0x40}, {0xa4,0x44}, {0xa4,0x5b}, {0xc9,0x47}, {0xa4,0x5c},
    {0xfa,0xe5}, {0xa4,0xa7}, {0xa5,0x45}, {0xa5,0x47}, {0xa5,0x46}, {0xa5,0xe2}, {0xa5,0xe3}, {0xa8,0xc4}, {0xad,0xbc}, {0xa4,0x41},
    {0xc8,0x7b}, {0x8b,0xc6}, {0xc9,0x41}, {0xa4,0x45}, {0xa4,0x5e}, {0xa4,0x5d}, {0xa5,0xe4}, {0x9c,0x57}, {0xa8,0xc5}, {0x9a,0xfb},
    {0xb0,0xae}, {0xd4,0x4b}, {0x89,0xd0}, {0x89,0xcf}, {0xb6,0xc3}, {0xdc,0xb1}, {0xdc,0xb2}, {0xc6,0xc1}, {0xa4,0x46}, {0x89,0xd1},
    {0xa4,0xa9}, {0x89,0xe2}, {0xa8,0xc6}, {0xa4,0x47}, {0xc9,0x48}, {0xa4,0x5f}, {0xa4,0xaa}, {0xa4,0xac}, {0xc9,0x51}, {0xa4,0xad},
    {0xa4,0xab}, {0x92,0x7e}, {0xa5,0xe5}, {0x9d,0xba}, {0xa8,0xc7}, {0xa8,0xc8}, {0xab,0x45}, {0xc6,0xc2}, {0xa4,0x60}, {0xa4,0xae},
    {0x8c,0x6f}, {0xa5,0xe6}, {0xa5,0xe8}, {0xa5,0xe7}, {0xa6,0xeb}, {0xa8,0xc9}, {0xa8,0xca}, {0xab,0x46}, {0xab,0x47}, {0xad,0xbd},
    {0xdc,0xb3}, {0xfb,0xf8}, {0xf6,0xd6}, {0xa4,0x48}, {0x8b,0xc7}, {0x92,0x6b}, {0x89,0xd2}, {0xa4,0xb0}, {0xa4,0xaf}, {0xc9,0x52},
    {0xa4,0xb1}, {0xa4,0xb7}, {0xa4,0xb2}, {0xa4,0xb3}, {0xc9,0x54}, {0xc9,0x53}, {0xa4,0xb5}, {0xa4,0xb6}, {0xa4,0xb4}, {0x9f,0xcf},
    {0xa5,0x4a}, {0xa5,0x4b}, {0xa5,0x4c}, {0xa5,0x4d}, {0xa5,0x49}, {0xa5,0x50}, {0xc9,0x6a}, {0xc9,0x66}, {0xc9,0x69}, {0xa5,0x51},
    {0xa5,0x61}, {0xc9,0x68}, {0xa5,0x4e}, {0xa5,0x4f}, {0xa5,0x48}, {0xc9,0x65}, {0xc9,0x67}, {0x9d,0xa9}, {0x89,0xd3}, {0x99,0xe2},
    {0xa5,0xf5}, {0xc9,0xb0}, {0xa5,0xf2}, {0xa5,0xf6}, {0xc9,0xba}, {0xc9,0xae}, {0xa5,0xf3}, {0xc9,0xb2}, {0x92,0x67}, {0xa5,0xf4},
    {0xa5,0xf7}, {0xa5,0xe9}, {0xc9,0xb1}, {0xa5,0xf8}, {0xc9,0xb5}, {0x92,0xa4}, {0xc9,0xb9}, {0xc9,0xb6}, {0xc9,0xb3}, {0xa5,0xea},
    {0xa5,0xec}, {0xa5,0xf9}, {0xa5,0xee}, {0xc9,0xab}, {0xa5,0xf1}, {0xa5,0xef}, {0xa5,0xf0}, {0xc9,0xbb}, {0xc9,0xb8}, {0xc9,0xaf},
    {0xa5,0xed}, {0x8c,0x73}, {0xc9,0xac}, {0xa5,0xeb}, {0x89,0x4e}, {0xc9,0xb4}, {0xc9,0xb7}, {0x89,0x4f}, {0x92,0x78}, {0xc9,0xad},
    {0xca,0x66}, {0xa7,0x42}, {0xa6,0xf4}, {0x91,0xb6}, {0xca,0x67}, {0xa6,0xf1}, {0xa7,0x44}, {0x89,0xd4}, {0xa6,0xf9}, {0x9f,0xd2},
    {0xa6,0xf8}, {0xca,0x5b}, {0xa6,0xfc}, {0xa6,0xf7}, {0xca,0x60}, {0xca,0x68}, {0xca,0x64}, {0x92,0xa7}, {0xa6,0xfa}, {0x95,0xa2},
    {0xa6,0xfd}, {0xa6,0xee}, {0xa7,0x47}, {0xca,0x5d}, {0x92,0x6e}, {0xcb,0xbd}, {0xa6,0xec}, {0xa7,0x43}, {0xa6,0xed}, {0xa6,0xf5},
    {0xa6,0xf6}, {0xca,0x62}, {0xca,0x5e}, {0xa6,0xfb}, {0xa6,0xf3}, {0xca,0x5a}, {0xa6,0xef}, {0xca,0x65}, {0xa7,0x45}, {0xa7,0x48},
    {0xa6,0xf2}, {0xa7,0x40}, {0xa7,0x46}, {0xa6,0xf0}, {0xca,0x63}, {0xa7,0x41}, {0xca,0x69}, {0xca,0x5c}, {0xa6,0xfe}, {0xca,0x5f},
    {0xca,0x61}, {0xa8,0xd8}, {0xcb,0xbf}, {0xcb,0xcb}, {0xa8,0xd0}, {0xcb,0xcc}, {0xa8,0xcb}, {0xa8,0xd5}, {0x96,0xea}, {0xa8,0xce},
    {0xcb,0xb9}, {0xa8,0xd6}, {0xcb,0xb8}, {0xcb,0xbc}, {0xcb,0xc3}, {0xcb,0xc1}, {0xa8,0xde}, {0xa8,0xd9}, {0xcb,0xb3}, {0xcb,0xb5},
    {0xa8,0xdb}, {0xa8,0xcf}, {0xcb,0xb6}, {0xcb,0xc2}, {0xcb,0xc9}, {0xa8,0xd4}, {0xcb,0xbb}, {0xcb,0xb4}, {0xa8,0xd3}, {0xcb,0xb7},
    {0xa8,0xd7}, {0xcb,0xba}, {0x92,0x6f}, {0xa8,0xd2}, {0xa8,0xcd}, {0xa8,0xdc}, {0xcb,0xc4}, {0xa8,0xdd}, {0xcb,0xc8}, {0xcb,0xc6},
    {0xcb,0xca}, {0xa8,0xda}, {0xcb,0xbe}, {0xcb,0xb2}, {0xcb,0xc0}, {0xa8,0xd1}, {0xcb,0xc5}, {0xa8,0xcc}, {0xcb,0xc7}, {0x92,0xa3},
    {0x89,0x50}, {0xfa,0x57}, {0xab,0x56}, {0xab,0x4a}, {0x98,0x66}, {0xcd,0xe0}, {0xcd,0xe8}, {0xab,0x49}, {0xab,0x51}, {0xab,0x5d},
    {0xcd,0xee}, {0xcd,0xec}, {0xcd,0xe7}, {0x89,0xd6}, {0xab,0x4b}, {0xcd,0xed}, {0xcd,0xe3}, {0xab,0x59}, {0xab,0x50}, {0xab,0x58},
    {0xcd,0xde}, {0xcd,0xea}, {0x98,0xb2}, {0xcd,0xe1}, {0xab,0x54}, {0xcd,0xe2}, {0x92,0xab}, {0xcd,0xdd}, {0xab,0x5b}, {0xab,0x4e},
    {0xab,0x57}, {0xab,0x4d}, {0xcd,0xdf}, {0xcd,0xe4}, {0xcd,0xeb}, {0xab,0x55}, {0xab,0x52}, {0xcd,0xe6}, {0xab,0x5a}, {0xcd,0xe9},
    {0xcd,0xe5}, {0xab,0x4f}, {0xab,0x5c}, {0xab,0x53}, {0xab,0x4c}, {0xab,0x48}, {0x96,0xde}, {0x92,0xac}, {0xcd,0xef}, {0xad,0xd7},
    {0xad,0xc1}, {0x8c,0x70}, {0xad,0xd1}, {0x9f,0x6e}, {0xad,0xd6}, {0xd0,0xd0}, {0xd0,0xcf}, {0xd0,0xd4}, {0xd0,0xd5}, {0xad,0xc4},
    {0x8e,0xf2}, {0xad,0xcd}, {0x9f,0x6c}, {0xad,0xda}, {0xad,0xce}, {0x89,0xd8}, {0xd0,0xc9}, {0xad,0xc7}, {0xd0,0xca}, {0xfa,0x59},
    {0xad,0xdc}, {0xad,0xd3}, {0xad,0xbe}, {0xad,0xbf}, {0xd0,0xdd}, {0xb0,0xbf}, {0xad,0xcc}, {0xad,0xcb}, {0xd0,0xcb}, {0xad,0xcf},
    {0xd4,0x5b}, {0xad,0xc6}, {0xd0,0xd6}, {0xad,0xd5}, {0xad,0xd4}, {0xad,0xca}, {0xd0,0xce}, {0xd0,0xd7}, {0xd0,0xc8}, {0xad,0xc9},
    {0xd0,0xd8}, {0xad,0xd2}, {0xd0,0xcc}, {0xad,0xc0}, {0xad,0xc3}, {0xad,0xc2}, {0xd0,0xd9}, {0xad,0xd0}, {0xad,0xc5}, {0xad,0xd9},
    {0xad,0xdb}, {0xd0,0xd3}, {0xad,0xd8}, {0x92,0xa8}, {0xd0,0xdb}, {0xd0,0xcd}, {0xd0,0xdc}, {0xd0,0xd1}, {0x91,0x63}, {0xd0,0xda},
    {0xd0,0xd2}, {0x8c,0x40}, {0xad,0xc8}, {0xd4,0x63}, {0xd4,0x57}, {0xb0,0xb3}, {0xd4,0x5c}, {0xd4,0x62}, {0xb0,0xb2}, {0xd4,0x55},
    {0xb0,0xb6}, {0xd4,0x59}, {0xd4,0x52}, {0xb0,0xb4}, {0xd4,0x56}, {0xb0,0xb9}, {0xb0,0xbe}, {0xd4,0x67}, {0xd4,0x51}, {0xb0,0xba},
    {0x9f,0x73}, {0xd4,0x66}, {0x92,0xad}, {0xb0,0xb5}, {0xd4,0x58}, {0xb0,0xb1}, {0xd4,0x53}, {0xd4,0x4f}, {0xd4,0x5d}, {0xd4,0x50},
    {0xd4,0x4e}, {0xd4,0x5a}, {0xd4,0x60}, {0xd4,0x61}, {0xb0,0xb7}, {0x9b,0xe9}, {0xd8,0x5b}, {0xd4,0x5e}, {0xd4,0x4d}, {0xd4,0x5f},
    {0x92,0xa9}, {0xb0,0xc1}, {0xd4,0x64}, {0xb0,0xc0}, {0xd4,0x4c}, {0xd4,0x54}, {0xd4,0x65}, {0xb0,0xbc}, {0xb0,0xbb}, {0xb0,0xb8},
    {0xb0,0xbd}, {0xb0,0xaf}, {0xb0,0xb0}, {0xb3,0xc8}, {0x92,0xaa}, {0xd8,0x5e}, {0xd8,0x57}, {0xb3,0xc5}, {0xd8,0x5f}, {0x89,0xd9},
    {0xd8,0x55}, {0xd8,0x58}, {0xb3,0xc4}, {0xd8,0x59}, {0xfd,0x56}, {0xb3,0xc7}, {0xd8,0x5d}, {0xd8,0x53}, {0xd8,0x52}, {0xb3,0xc9},
    {0xb3,0xca}, {0xb3,0xc6}, {0xb3,0xcb}, {0xd8,0x51}, {0xd8,0x5c}, {0xd8,0x5a}, {0xd8,0x54}, {0xb3,0xc3}, {0xd8,0x56}, {0x9f,0xa8},
    {0xb6,0xca}, {0xb6,0xc4}, {0xdc,0xb7}, {0xb6,0xcd}, {0xdc,0xbd}, {0xdc,0xc0}, {0xb6,0xc6}, {0xb6,0xc7}, {0xdc,0xba}, {0xb6,0xc5},
    {0xdc,0xc3}, {0xb6,0xcb}, {0xdc,0xc4}, {0xdc,0xbf}, {0xb6,0xcc}, {0x8c,0x71}, {0xdc,0xb4}, {0xb6,0xc9}, {0xdc,0xb5}, {0xdc,0xbe},
    {0xdc,0xbc}, {0xdc,0xb8}, {0xb6,0xc8}, {0xdc,0xb6}, {0xb6,0xce}, {0xdc,0xbb}, {0xdc,0xc2}, {0xdc,0xb9}, {0xdc,0xc1}, {0x92,0xa1},
    {0xb9,0xb6}, {0xb9,0xb3}, {0x90,0xe3}, {0xb9,0xb4}, {0xe0,0xf9}, {0xe0,0xf1}, {0xb9,0xb2}, {0xb9,0xaf}, {0xe0,0xf2}, {0xa0,0xa6},
    {0xb9,0xb1}, {0xe0,0xf5}, {0xe0,0xf7}, {0x94,0xab}, {0xe0,0xfe}, {0xfc,0x72}, {0xe0,0xfd}, {0xe0,0xf8}, {0xb9,0xae}, {0xe0,0xf0},
    {0xb9,0xac}, {0xe0,0xf3}, {0xb9,0xb7}, {0xe0,0xf6}, {0xe0,0xfa}, {0xb9,0xb0}, {0xb9,0xad}, {0xe0,0xfc}, {0xe0,0xfb}, {0xb9,0xb5},
    {0xe0,0xf4}, {0x97,0xc4}, {0xbb,0xf8}, {0xe4,0xec}, {0xe4,0xe9}, {0xbb,0xf9}, {0xbb,0xf7}, {0x92,0xae}, {0xe4,0xf0}, {0xe4,0xed},
    {0xe4,0xe6}, {0xbb,0xf6}, {0xfa,0x67}, {0xbb,0xfa}, {0xe4,0xe7}, {0xbb,0xf5}, {0xbb,0xfd}, {0xe4,0xea}, {0xe4,0xeb}, {0xbb,0xfb},
    {0xbb,0xfc}, {0xe4,0xf1}, {0xe4,0xee}, {0xe4,0xef}, {0x92,0xa2}, {0xfa,0x69}, {0xbe,0xaa}, {0xe8,0xf8}, {0xbe,0xa7}, {0xe8,0xf5},
    {0xbe,0xa9}, {0xbe,0xab}, {0xe8,0xf6}, {0xbe,0xa8}, {0xe8,0xf7}, {0xe8,0xf4}, {0xc0,0x76}, {0xec,0xbd}, {0xc0,0x77}, {0xec,0xbb},
    {0xec,0xbc}, {0xec,0xba}, {0xec,0xb9}, {0xec,0xbe}, {0xc0,0x75}, {0x92,0x68}, {0xef,0xb8}, {0xef,0xb9}, {0xe4,0xe8}, {0xef,0xb7},
    {0xc0,0x78}, {0xc3,0x5f}, {0xf1,0xeb}, {0xf1,0xec}, {0xc4,0xd7}, {0xc4,0xd8}, {0xf5,0xc1}, {0xf5,0xc0}, {0xc5,0x6c}, {0xc5,0x6b},
    {0xf7,0xd0}, {0xa4,0x49}, {0xa4,0x61}, {0xa4,0xb9}, {0xa4,0xb8}, {0xa5,0x53}, {0xa5,0x52}, {0xa5,0xfc}, {0xa5,0xfb}, {0xa5,0xfd},
    {0xa5,0xfa}, {0xa7,0x4a}, {0xa7,0x49}, {0xa7,0x4b}, {0xa8,0xe0}, {0xa8,0xdf}, {0xa8,0xe1}, {0x89,0x51}, {0xab,0x5e}, {0xa2,0x59},
    {0xd0,0xde}, {0xa2,0x5a}, {0xb0,0xc2}, {0xa2,0x5c}, {0xa2,0x5b}, {0xd8,0x60}, {0xfa,0x6f}, {0xa2,0x5d}, {0xb9,0xb8}, {0xa2,0x5e},
    {0xa4,0x4a}, {0xa4,0xba}, {0xa5,0xfe}, {0xa8,0xe2}, {0xfa,0x71}, {0xa4,0x4b}, {0xa4,0xbd}, {0xa4,0xbb}, {0xa4,0xbc}, {0xa6,0x40},
    {0x89,0x52}, {0xa7,0x4c}, {0xa8,0xe4}, {0xa8,0xe3}, {0xa8,0xe5}, {0x94,0x5a}, {0xad,0xdd}, {0xbe,0xac}, {0xc6,0xc3}, {0x89,0xdd},
    {0xc9,0x4e}, {0xc8,0xa2}, {0xa5,0x54}, {0xa5,0x55}, {0xa6,0x41}, {0xca,0x6a}, {0xab,0x60}, {0xab,0x5f}, {0xd0,0xe0}, {0xd0,0xdf},
    {0xb0,0xc3}, {0xc6,0xc4}, {0xa4,0xbe}, {0xc9,0x55}, {0x9e,0x52}, {0x89,0x53}, {0xcb,0xcd}, {0xab,0x61}, {0xad,0xe0}, {0xad,0xde},
    {0xad,0xdf}, {0x9e,0x55}, {0x92,0xba}, {0xbe,0xad}, {0xc6,0xc5}, {0xa5,0x56}, {0x8c,0x5b}, {0xa6,0x42}, {0xc9,0xbc}, {0xfa,0x7d},
    {0xfa,0xa8}, {0x9a,0x68}, {0xfa,0x47}, {0xa7,0x4d}, {0xa7,0x4e}, {0xfa,0x7e}, {0xca,0x6b}, {0xcb,0xce}, {0xa8,0xe6}, {0xcb,0xcf},
    {0x92,0xbb}, {0xd0,0xe2}, {0xd0,0xe3}, {0xad,0xe3}, {0xfd,0xb6}, {0xd0,0xe4}, {0xfa,0xa2}, {0xd0,0xe1}, {0xad,0xe4}, {0xad,0xe2},
    {0xad,0xe1}, {0xd0,0xe5}, {0xfa,0xa3}, {0xd4,0x68}, {0xfa,0xa4}, {0x9b,0xb4}, {0xfa,0xa6}, {0xd8,0x61}, {0xdc,0xc5}, {0xe1,0x40},
    {0x89,0xdf}, {0xbb,0xfe}, {0xbe,0xae}, {0xe8,0xf9}, {0xfd,0xdb}, {0xa4,0x4c}, {0xa4,0x5a}, {0xfa,0xa9}, {0x89,0x54}, {0xfa,0xab},
    {0xb0,0xc4}, {0xb3,0xcd}, {0xb9,0xb9}, {0xfc,0x7a}, {0xc9,0x42}, {0xa4,0xbf}, {0xa5,0x59}, {0xa5,0x57}, {0xa5,0x58}, {0x89,0xe0},
    {0xa8,0xe7}, {0x9f,0x4f}, {0xa4,0x4d}, {0xa4,0x4e}, {0xc8,0x7d}, {0xa4,0x62}, {0x89,0xe1}, {0xa4,0xc0}, {0xa4,0xc1}, {0xa4,0xc2},
    {0xc9,0xbe}, {0xa5,0x5a}, {0xfa,0xb0}, {0xc9,0x6b}, {0xa6,0x46}, {0xc9,0xbf}, {0xa6,0x44}, {0xa6,0x45}, {0xc9,0xbd}, {0xa6,0x47},
    {0xa6,0x43}, {0xca,0x6c}, {0xaa,0xec}, {0xca,0x6d}, {0x9f,0xcd}, {0xa0,0xe7}, {0xca,0x6e}, {0xa7,0x50}, {0xa7,0x4f}, {0xfa,0xb1},
    {0x89,0xa6}, {0xa7,0x53}, {0xa7,0x51}, {0xa7,0x52}, {0xa8,0xed}, {0xa8,0xec}, {0xcb,0xd4}, {0xcb,0xd1}, {0xcb,0xd2}, {0x9e,0xfa},
    {0xcb,0xd0}, {0xa8,0xee}, {0xa8,0xea}, {0xa8,0xe9}, {0xa8,0xeb}, {0xa8,0xe8}, {0xfa,0xb2}, {0xa8,0xef}, {0xab,0x63}, {0xcd,0xf0},
    {0xcb,0xd3}, {0xab,0x68}, {0xcd,0xf1}, {0xab,0x64}, {0xab,0x67}, {0xab,0x66}, {0xab,0x65}, {0xab,0x62}, {0xd0,0xe8}, {0xad,0xe7},
    {0xd0,0xeb}, {0xad,0xe5}, {0xfa,0xb4}, {0x92,0xc4}, {0xd0,0xe7}, {0xad,0xe8}, {0xad,0xe6}, {0xad,0xe9}, {0xd0,0xe9}, {0xd0,0xea},
    {0x9f,0x6f}, {0xd0,0xe6}, {0xd0,0xec}, {0x8b,0xb0}, {0xb3,0xd1}, {0xb0,0xc5}, {0xd4,0x69}, {0xd4,0x6b}, {0xd4,0x6a}, {0xd4,0x6c},
    {0xb0,0xc6}, {0xb3,0xce}, {0x9f,0xac}, {0xb3,0xcf}, {0xb3,0xd0}, {0xb6,0xd0}, {0xdc,0xc7}, {0x89,0xe3}, {0xdc,0xc6}, {0xdc,0xc8},
    {0xdc,0xc9}, {0xb6,0xd1}, {0xb6,0xcf}, {0xe1,0x41}, {0xe1,0x42}, {0xb9,0xbb}, {0xb9,0xba}, {0xe3,0x5a}, {0xbc,0x40}, {0xbc,0x41},
    {0xbc,0x42}, {0xbc,0x44}, {0xe4,0xf2}, {0xe4,0xf3}, {0xbc,0x43}, {0x9b,0xd3}, {0x89,0xe4}, {0xbe,0xaf}, {0xbe,0xb0}, {0xfa,0xb5},
    {0xf1,0xed}, {0xf5,0xc3}, {0xf5,0xc2}, {0xf7,0xd1}, {0x9f,0xd5}, {0xa4,0x4f}, {0xa5,0x5c}, {0xa5,0x5b}, {0x89,0x55}, {0xa6,0x48},
    {0x92,0xc5}, {0xc9,0xc0}, {0x89,0x56}, {0xa7,0x55}, {0xa7,0x56}, {0xa7,0x54}, {0xa7,0x57}, {0xca,0x6f}, {0xca,0x70}, {0xfa,0xb3},
    {0xfa,0xb6}, {0xa8,0xf1}, {0xcb,0xd5}, {0xa8,0xf0}, {0xcd,0xf2}, {0xab,0x6c}, {0xcd,0xf3}, {0xab,0x6b}, {0xfa,0xb7}, {0xab,0x69},
    {0xab,0x6a}, {0x9e,0xdc}, {0xd0,0xed}, {0xfb,0xc4}, {0x9f,0x71}, {0xb0,0xc7}, {0xd4,0x6e}, {0xb0,0xca}, {0xd4,0x6d}, {0xb1,0xe5},
    {0xb0,0xc9}, {0xb0,0xc8}, {0xb3,0xd4}, {0xb3,0xd3}, {0xb3,0xd2}, {0xb6,0xd2}, {0xfa,0xba}, {0x92,0xc7}, {0xb6,0xd5}, {0xb6,0xd6},
    {0xb6,0xd4}, {0xb6,0xd3}, {0xe1,0x43}, {0xe1,0x44}, {0xe4,0xf5}, {0xbc,0x45}, {0xe4,0xf4}, {0xbe,0xb1}, {0xec,0xbf}, {0xc0,0x79},
    {0xf1,0xee}, {0xc4,0x55}, {0xc6,0xc6}, {0xa4,0x63}, {0xa4,0xc3}, {0xc9,0x56}, {0xa4,0xc4}, {0xa4,0xc5}, {0x9a,0x4c}, {0xa5,0x5d},
    {0xa5,0x5e}, {0xa6,0x49}, {0xca,0x71}, {0xcb,0xd6}, {0xcb,0xd7}, {0xab,0x6d}, {0xd0,0xee}, {0xb0,0xcc}, {0xb0,0xcb}, {0xd8,0x63},
    {0xd8,0x62}, {0xa4,0x50}, {0xa4,0xc6}, {0xa5,0x5f}, {0xb0,0xcd}, {0xc9,0x43}, {0xc9,0x6c}, {0xa5,0x60}, {0xc9,0xc2}, {0xa6,0x4b},
    {0xa6,0x4a}, {0xc9,0xc1}, {0xa7,0x58}, {0x8c,0x68}, {0x89,0xe5}, {0xad,0xea}, {0x9f,0x7d}, {0xd4,0x6f}, {0xb6,0xd7}, {0xe1,0x45},
    {0xb9,0xbc}, {0xa0,0xa9}, {0xfa,0xc4}, {0xe8,0xfa}, {0xf3,0xfd}, {0xc6,0xc7}, {0xa4,0xc7}, {0x89,0x57}, {0xcb,0xd8}, {0xcd,0xf4},
    {0xb0,0xd0}, {0xb0,0xce}, {0xb0,0xcf}, {0xa4,0x51}, {0xfa,0xaa}, {0xa4,0x64}, {0xa2,0xcd}, {0xa4,0xca}, {0xa4,0xc9}, {0xa4,0xc8},
    {0xa5,0x63}, {0xa5,0x62}, {0xc9,0x6d}, {0xc9,0xc3}, {0x89,0x58}, {0xa8,0xf5}, {0xa8,0xf2}, {0xa8,0xf4}, {0xa8,0xf3}, {0xab,0x6e},
    {0xb3,0xd5}, {0xa4,0x52}, {0x8b,0xe3}, {0xa4,0xcb}, {0x8b,0x61}, {0xa5,0x65}, {0xa5,0x64}, {0xca,0x72}, {0x9a,0xf1}, {0xa8,0xf6},
    {0x9e,0xb7}, {0xc6,0xc8}, {0xc9,0x57}, {0xfa,0xd1}, {0xa5,0x67}, {0xa5,0x66}, {0xa6,0x4c}, {0xa6,0x4d}, {0xca,0x73}, {0xa7,0x59},
    {0xfa,0xd2}, {0xa7,0x5a}, {0xa8,0xf7}, {0xa8,0xf8}, {0xa8,0xf9}, {0xab,0x6f}, {0xcd,0xf5}, {0x9e,0xba}, {0xfa,0xd4}, {0xad,0xeb},
    {0xc9,0x44}, {0xa4,0xcc}, {0xc9,0xc4}, {0xca,0x74}, {0xca,0x75}, {0xcb,0xd9}, {0xfa,0xd9}, {0xcb,0xda}, {0xcd,0xf7}, {0xcd,0xf6},
    {0xcd,0xf9}, {0xcd,0xf8}, {0xab,0x70}, {0xd4,0x70}, {0xad,0xed}, {0xd0,0xef}, {0xad,0xec}, {0xfa,0xdb}, {0x9c,0xe0}, {0xd8,0x64},
    {0xb3,0xd6}, {0xfb,0xf7}, {0xd8,0x65}, {0xfb,0xfa}, {0x89,0xe7}, {0xa0,0x7a}, {0xfa,0xdc}, {0xe1,0x46}, {0xb9,0xbd}, {0xfa,0xdd},
    {0x89,0xe9}, {0xbc,0x46}, {0xf1,0xef}, {0xc6,0xc9}, {0xc9,0x58}, {0xa5,0x68}, {0xfa,0xe2}, {0x89,0xeb}, {0xb0,0xd1}, {0xfa,0xe3},
    {0xa4,0x53}, {0xa4,0x65}, {0xa4,0xce}, {0xa4,0xcd}, {0x90,0xc8}, {0xa4,0xcf}, {0x92,0xda}, {0x89,0x59}, {0x9c,0xf5}, {0xa8,0xfb},
    {0xa8,0xfa}, {0xa8,0xfc}, {0x89,0x5a}, {0xfa,0xe7}, {0x9f,0xa2}, {0xab,0x71}, {0xad,0xee}, {0xfa,0xea}, {0xe8,0xfb}, {0xc2,0x4f},
    {0xa4,0x66}, {0xa5,0x6a}, {0xa5,0x79}, {0xa5,0x74}, {0xa5,0x6f}, {0xa5,0x6e}, {0xa5,0x75}, {0xa5,0x73}, {0xa5,0x6c}, {0xa5,0x7a},
    {0xa5,0x6d}, {0xa5,0x69}, {0xa5,0x78}, {0xa5,0x77}, {0xa5,0x76}, {0xa5,0x6b}, {0xa5,0x72}, {0xfa,0xed}, {0x8f,0xad}, {0xa5,0x71},
    {0xa5,0x7b}, {0xa5,0x70}, {0xfb,0x59}, {0xa6,0x53}, {0xa6,0x59}, {0xa6,0x55}, {0xa6,0x5b}, {0xc9,0xc5}, {0xa6,0x58}, {0xa6,0x4e},
    {0xa6,0x51}, {0xa6,0x54}, {0xa6,0x50}, {0xa6,0x57}, {0xa6,0x5a}, {0xa6,0x4f}, {0xa6,0x52}, {0xa6,0x56}, {0xa6,0x5c}, {0xfa,0xef},
    {0x96,0xef}, {0x9d,0xec}, {0xca,0x7e}, {0xca,0x7b}, {0x9d,0xca}, {0xa7,0x67}, {0xca,0x7c}, {0xa7,0x5b}, {0xa7,0x5d}, {0xa7,0x75},
    {0xa7,0x70}, {0xfd,0x6d}, {0x89,0xec}, {0xca,0xa5}, {0xca,0x7d}, {0xa7,0x5f}, {0xa7,0x61}, {0xca,0xa4}, {0xa7,0x68}, {0xca,0x78},
    {0xa7,0x74}, {0xa7,0x76}, {0xa7,0x5c}, {0xa7,0x6d}, {0xfb,0x44}, {0xca,0x76}, {0xa7,0x73}, {0x9d,0xe2}, {0xa7,0x64}, {0x8c,0x75},
    {0xa7,0x6e}, {0xa7,0x6f}, {0xca,0x77}, {0xa7,0x6c}, {0xa7,0x6a}, {0xa7,0x6b}, {0xa7,0x71}, {0xca,0xa1}, {0xa7,0x5e}, {0xa7,0x72},
    {0xca,0xa3}, {0xa7,0x66}, {0xa7,0x63}, {0xca,0x7a}, {0xa7,0x62}, {0xca,0xa6}, {0xa7,0x65}, {0xa7,0x69}, {0x9e,0xc0}, {0x9e,0x56},
    {0xa7,0x60}, {0xca,0xa2}, {0xca,0x79}, {0xcb,0xeb}, {0xcb,0xea}, {0xa9,0x4f}, {0xcb,0xed}, {0xcb,0xef}, {0xcb,0xe4}, {0xcb,0xe7},
    {0xcb,0xee}, {0xa9,0x50}, {0x9f,0x79}, {0x9a,0xc7}, {0xcb,0xe1}, {0xcb,0xe5}, {0xfa,0xf4}, {0xcb,0xe9}, {0xce,0x49}, {0xa9,0x4b},
    {0xce,0x4d}, {0xa8,0xfd}, {0xcb,0xe6}, {0xa8,0xfe}, {0xa9,0x4c}, {0xa9,0x45}, {0xa9,0x41}, {0xcb,0xe2}, {0xa9,0x44}, {0xa9,0x49},
    {0xa9,0x52}, {0xcb,0xe3}, {0xcb,0xdc}, {0xa9,0x43}, {0xcb,0xdd}, {0xcb,0xdf}, {0xa9,0x46}, {0x98,0xa1}, {0xa9,0x48}, {0xcb,0xdb},
    {0xcb,0xe0}, {0xa9,0x51}, {0xa9,0x4d}, {0xcb,0xe8}, {0xa9,0x53}, {0xfa,0xf8}, {0xa9,0x4a}, {0xcb,0xde}, {0xa9,0x47}, {0x89,0xf0},
    {0x9e,0x47}, {0xa9,0x42}, {0xa9,0x40}, {0x9d,0xf7}, {0xcb,0xec}, {0xa9,0x4e}, {0x9f,0xd3}, {0x9a,0xca}, {0xce,0x48}, {0xcd,0xfb},
    {0xce,0x4b}, {0x89,0xf1}, {0xfa,0xf9}, {0xcd,0xfd}, {0xab,0x78}, {0xab,0xa8}, {0xab,0x74}, {0xab,0xa7}, {0xab,0x7d}, {0xab,0xa4},
    {0xab,0x72}, {0xcd,0xfc}, {0xce,0x43}, {0xab,0xa3}, {0xce,0x4f}, {0xab,0xa5}, {0x8e,0x5a}, {0xab,0x79}, {0x89,0xf2}, {0xce,0x45},
    {0xce,0x42}, {0xab,0x77}, {0x89,0xf3}, {0xcd,0xfa}, {0xab,0xa6}, {0xce,0x4a}, {0xab,0x7c}, {0xce,0x4c}, {0xab,0xa9}, {0xab,0x73},
    {0xab,0x7e}, {0xab,0x7b}, {0xce,0x40}, {0xab,0xa1}, {0xce,0x46}, {0xce,0x47}, {0xab,0x7a}, {0xab,0xa2}, {0xab,0x76}, {0x92,0x5d},
    {0x8b,0x51}, {0x92,0xe0}, {0xab,0x75}, {0xcd,0xfe}, {0x89,0xf4}, {0xce,0x44}, {0x9f,0xd4}, {0xce,0x4e}, {0xd1,0x44}, {0xad,0xfb},
    {0xd0,0xf1}, {0x8a,0x79}, {0xd0,0xf6}, {0xad,0xf4}, {0xae,0x40}, {0xd0,0xf4}, {0xad,0xef}, {0xad,0xf9}, {0xad,0xfe}, {0xd0,0xfb},
    {0xad,0xfa}, {0xad,0xfd}, {0x89,0xf5}, {0xd0,0xfe}, {0xad,0xf5}, {0xd0,0xf5}, {0xd1,0x42}, {0xd1,0x43}, {0xad,0xf7}, {0xd1,0x41},
    {0xad,0xf3}, {0xae,0x43}, {0xd0,0xf8}, {0xad,0xf1}, {0x97,0xa7}, {0xd1,0x46}, {0xd0,0xf9}, {0xd0,0xfd}, {0xad,0xf6}, {0xae,0x42},
    {0xd0,0xfa}, {0xad,0xfc}, {0xd1,0x40}, {0xd1,0x47}, {0xd4,0xa1}, {0x93,0xba}, {0xd1,0x45}, {0xae,0x44}, {0xad,0xf0}, {0xd0,0xfc},
    {0xd0,0xf3}, {0x9e,0x58}, {0xad,0xf8}, {0xd0,0xf2}, {0x89,0xf6}, {0xd0,0xf7}, {0x9e,0x57}, {0x89,0xf7}, {0x8a,0x41}, {0xd0,0xf0},
    {0xae,0x41}, {0x89,0xf8}, {0xd4,0x77}, {0xfa,0xf1}, {0xb0,0xe4}, {0xd4,0xa7}, {0xb0,0xe2}, {0xb0,0xdf}, {0xd4,0x7c}, {0xb0,0xdb},
    {0xd4,0xa2}, {0xb0,0xe6}, {0xd4,0x76}, {0xd4,0x7b}, {0xd4,0x7a}, {0xad,0xf2}, {0xb0,0xe1}, {0xd4,0xa5}, {0xd4,0xa8}, {0xd4,0x73},
    {0xb3,0xe8}, {0x89,0xfa}, {0xd4,0xa9}, {0xb0,0xe7}, {0xb0,0xd9}, {0xb0,0xd6}, {0xd4,0x7e}, {0xb0,0xd3}, {0xfb,0x42}, {0xd4,0xa6},
    {0xfa,0xbf}, {0xb0,0xda}, {0xd4,0xaa}, {0xd4,0x74}, {0xd4,0xa4}, {0xb0,0xdd}, {0xd4,0x75}, {0xd4,0x78}, {0xd4,0x7d}, {0xfb,0xa3},
    {0xb0,0xde}, {0xb0,0xdc}, {0xb0,0xe8}, {0xb0,0xe3}, {0xfa,0xf7}, {0xb0,0xd7}, {0xb1,0xd2}, {0xb0,0xd8}, {0xd4,0x79}, {0xb0,0xe5},
    {0xb0,0xe0}, {0xd4,0xa3}, {0xb0,0xd5}, {0x9e,0x4e}, {0xb0,0xd4}, {0x94,0xdc}, {0x95,0xda}, {0x9d,0xf8}, {0x9f,0x6a}, {0xd4,0x71},
    {0xd4,0x72}, {0xd8,0x6a}, {0x8a,0xb7}, {0xb3,0xd7}, {0xb3,0xda}, {0xd8,0x75}, {0xb3,0xee}, {0xd8,0x78}, {0xb3,0xd8}, {0xd8,0x71},
    {0xb3,0xde}, {0xb3,0xe4}, {0xb5,0xbd}, {0xfb,0x46}, {0xb3,0xe2}, {0xd8,0x6e}, {0xb3,0xef}, {0xb3,0xdb}, {0xb3,0xe3}, {0xd8,0x76},
    {0xdc,0xd7}, {0xd8,0x7b}, {0xd8,0x6f}, {0x8a,0x46}, {0xd8,0x66}, {0xd8,0x73}, {0xd8,0x6d}, {0xb3,0xe1}, {0xd8,0x79}, {0xb3,0xdd},
    {0xb3,0xf1}, {0xb3,0xea}, {0xb3,0xdf}, {0xb3,0xdc}, {0xb3,0xe7}, {0xd8,0x7a}, {0xd8,0x6c}, {0xd8,0x72}, {0xd8,0x74}, {0xd8,0x68},
    {0xd8,0x77}, {0xb3,0xd9}, {0xd8,0x67}, {0xfb,0x47}, {0xb3,0xe0}, {0xb3,0xf0}, {0xb3,0xec}, {0xd8,0x69}, {0xb3,0xe6}, {0x91,0x48},
    {0xb3,0xed}, {0xb3,0xe9}, {0xb3,0xe5}, {0x92,0xde}, {0xd8,0x70}, {0x8b,0x53}, {0x9d,0xf6}, {0xb3,0xeb}, {0x9b,0xda}, {0xdc,0xd5},
    {0xdc,0xd1}, {0x9d,0x7e}, {0xdc,0xe0}, {0xdc,0xca}, {0xdc,0xd3}, {0xb6,0xe5}, {0xb6,0xe6}, {0xb6,0xde}, {0xdc,0xdc}, {0xb6,0xe8},
    {0xdc,0xcf}, {0xdc,0xce}, {0xdc,0xcc}, {0xdc,0xde}, {0xb6,0xdc}, {0xdc,0xd8}, {0xdc,0xcd}, {0xb6,0xdf}, {0xdc,0xd6}, {0xb6,0xda},
    {0xdc,0xd2}, {0xdc,0xd9}, {0xdc,0xdb}, {0x89,0xfd}, {0x99,0xe4}, {0xdc,0xdf}, {0xb6,0xe3}, {0xdc,0xcb}, {0xb6,0xdd}, {0xdc,0xd0},
    {0x9e,0x43}, {0xb6,0xd8}, {0xb6,0xe4}, {0xdc,0xda}, {0xb6,0xe0}, {0xb6,0xe1}, {0xb6,0xe7}, {0xb6,0xdb}, {0xa2,0x5f}, {0xb6,0xd9},
    {0xdc,0xd4}, {0x9d,0xe9}, {0x8f,0x52}, {0xb6,0xe2}, {0x9d,0xf5}, {0x9d,0xf0}, {0xdc,0xdd}, {0x99,0xe7}, {0xb9,0xcd}, {0xb9,0xc8},
    {0xe1,0x55}, {0xe1,0x51}, {0x8b,0xbd}, {0xe1,0x4b}, {0xb9,0xc2}, {0xb9,0xbe}, {0xe1,0x54}, {0xb9,0xbf}, {0xe1,0x4e}, {0xe1,0x50},
    {0xe1,0x53}, {0x9d,0xef}, {0xb9,0xc4}, {0xb9,0xcb}, {0xb9,0xc5}, {0xe1,0x49}, {0xb9,0xc6}, {0xb9,0xc7}, {0xe1,0x4c}, {0xb9,0xcc},
    {0x9f,0xb7}, {0xe1,0x4a}, {0xe1,0x4f}, {0xb9,0xc3}, {0xe1,0x48}, {0xb9,0xc9}, {0xb9,0xc1}, {0xb9,0xc0}, {0xe1,0x4d}, {0xe1,0x52},
    {0x9d,0xd0}, {0xb9,0xca}, {0x9f,0xeb}, {0x8d,0xa9}, {0x9d,0xcf}, {0x98,0xe1}, {0x9d,0xe5}, {0xe1,0x47}, {0xbc,0x4d}, {0xe5,0x47},
    {0xe5,0x44}, {0x9d,0xc8}, {0xbc,0x47}, {0xbc,0x53}, {0xbc,0x54}, {0xbc,0x4a}, {0xe5,0x42}, {0xbc,0x4c}, {0xe4,0xf9}, {0xbc,0x52},
    {0xfb,0x4f}, {0xe5,0x46}, {0xbc,0x49}, {0xe5,0x48}, {0xbc,0x48}, {0xe5,0x43}, {0xe5,0x45}, {0xbc,0x4b}, {0xe5,0x41}, {0xe4,0xfa},
    {0xe4,0xf7}, {0x9d,0xeb}, {0xd8,0x6b}, {0xe4,0xfd}, {0xe4,0xf6}, {0xe4,0xfc}, {0xe4,0xfb}, {0xe4,0xf8}, {0xfb,0x54}, {0xbc,0x4f},
    {0xfb,0x55}, {0x9a,0xa2}, {0x8a,0xd6}, {0xbc,0x4e}, {0x9a,0x5f}, {0xbc,0x50}, {0xe4,0xfe}, {0xbe,0xb2}, {0xe5,0x40}, {0x9e,0xf5},
    {0xe9,0x45}, {0xe8,0xfd}, {0x8f,0xb7}, {0xbe,0xbe}, {0xe9,0x42}, {0xbe,0xb6}, {0xbe,0xba}, {0xe9,0x41}, {0xbe,0xb9}, {0xbe,0xb5},
    {0xbe,0xb8}, {0xbe,0xb3}, {0xbe,0xbd}, {0xe9,0x43}, {0xe8,0xfe}, {0xbe,0xbc}, {0xe8,0xfc}, {0xbe,0xbb}, {0xe9,0x44}, {0xe9,0x40},
    {0xbc,0x51}, {0xbe,0xbf}, {0xe9,0x46}, {0xbe,0xb7}, {0xbe,0xb4}, {0x9a,0xd2}, {0x9e,0x6a}, {0x9e,0xe8}, {0xec,0xc6}, {0xec,0xc8},
    {0xc0,0x7b}, {0xec,0xc9}, {0xec,0xc7}, {0xec,0xc5}, {0xec,0xc4}, {0xc0,0x7d}, {0xec,0xc3}, {0xc0,0x7e}, {0x8b,0xbf}, {0x91,0xc2},
    {0x9d,0x62}, {0xec,0xc1}, {0xec,0xc2}, {0xc0,0x7a}, {0xc0,0xa1}, {0xc0,0x7c}, {0x92,0x60}, {0xec,0xc0}, {0xc2,0x50}, {0xef,0xbc},
    {0xef,0xba}, {0xef,0xbf}, {0xef,0xbd}, {0xef,0xbb}, {0xef,0xbe}, {0x92,0x5e}, {0x91,0xc1}, {0x8a,0xc5}, {0x97,0xa3}, {0xc3,0x60},
    {0xf1,0xf2}, {0xf1,0xf3}, {0xc4,0x56}, {0xf1,0xf4}, {0xf1,0xf0}, {0xf1,0xf5}, {0xf1,0xf1}, {0xc2,0x51}, {0x8b,0x6c}, {0x8d,0x7e},
    {0xf3,0xfe}, {0xf4,0x41}, {0xc4,0x59}, {0xf4,0x40}, {0xc4,0x58}, {0xc4,0x57}, {0x9c,0x54}, {0xc4,0x5a}, {0xf5,0xc5}, {0xf5,0xc6},
    {0x9d,0xbd}, {0xc4,0xda}, {0xc4,0xd9}, {0xc4,0xdb}, {0xf5,0xc4}, {0xf6,0xd8}, {0xf6,0xd7}, {0xc5,0x6d}, {0xc5,0x6f}, {0xc5,0x6e},
    {0xf6,0xd9}, {0xc5,0xc8}, {0xf8,0xa6}, {0xc5,0xf1}, {0xf8,0xa5}, {0xf8,0xee}, {0x9c,0xc5}, {0xc9,0x49}, {0xa5,0x7d}, {0xa5,0x7c},
    {0xa6,0x5f}, {0xa6,0x5e}, {0xc9,0xc7}, {0xa6,0x5d}, {0xc9,0xc6}, {0x89,0x5b}, {0xa7,0x79}, {0xca,0xa9}, {0xca,0xa8}, {0xa7,0x77},
    {0xa7,0x7a}, {0xfb,0x5c}, {0xca,0xa7}, {0xfb,0x5b}, {0xa7,0x78}, {0xfb,0x57}, {0xcb,0xf0}, {0xcb,0xf1}, {0xa9,0x54}, {0x98,0xc7},
    {0xab,0xaa}, {0xfb,0x5a}, {0xd1,0x48}, {0xd1,0x49}, {0xae,0x45}, {0xae,0x46}, {0xd4,0xac}, {0xb0,0xe9}, {0xb0,0xeb}, {0xd4,0xab},
    {0xb0,0xea}, {0xd8,0x7c}, {0xb3,0xf2}, {0xb6,0xe9}, {0xb6,0xea}, {0xdc,0xe1}, {0x9c,0xee}, {0xb9,0xcf}, {0xb9,0xce}, {0xe5,0x49},
    {0xe9,0x48}, {0xe9,0x47}, {0x92,0xe2}, {0xf9,0x6b}, {0xa4,0x67}, {0xc9,0x59}, {0xc9,0x6e}, {0xc9,0x6f}, {0xa6,0x62}, {0xa6,0x66},
    {0xc9,0xc9}, {0xa6,0x64}, {0xa6,0x63}, {0xc9,0xc8}, {0xa6,0x65}, {0xa6,0x61}, {0x94,0xa7}, {0xa6,0x60}, {0xc9,0xca}, {0xa7,0xa6},
    {0x8c,0xcc}, {0xa7,0xa3}, {0x9b,0xd4}, {0xa7,0x7d}, {0xca,0xaa}, {0xfb,0x64}, {0xfb,0x76}, {0xca,0xab}, {0xfb,0x60}, {0xa7,0xa1},
    {0xca,0xad}, {0xa7,0x7b}, {0xca,0xae}, {0xca,0xac}, {0xa7,0x7e}, {0xa7,0xa2}, {0xa7,0xa5}, {0xa7,0xa4}, {0xa7,0x7c}, {0xca,0xaf},
    {0x99,0xe5}, {0x9a,0xc2}, {0x91,0xfb}, {0xa0,0x73}, {0xa9,0x59}, {0xcb,0xfe}, {0xa9,0x5b}, {0xa9,0x5a}, {0x9f,0x72}, {0xcc,0x40},
    {0xa9,0x58}, {0xa9,0x57}, {0xcb,0xf5}, {0xcb,0xf4}, {0xcb,0xf2}, {0xcb,0xf7}, {0xcb,0xf6}, {0xcb,0xf3}, {0xcb,0xfc}, {0xcb,0xfd},
    {0xcb,0xfa}, {0xcb,0xf8}, {0xa9,0x56}, {0x9f,0xcc}, {0xcb,0xfb}, {0xa9,0x5c}, {0xcc,0x41}, {0x98,0xa5}, {0x92,0xe8}, {0xcb,0xf9},
    {0xab,0xab}, {0xa9,0x55}, {0x9b,0xbc}, {0x96,0xf3}, {0xab,0xac}, {0xce,0x54}, {0x92,0xe7}, {0xce,0x5a}, {0xfc,0x67}, {0xab,0xb2},
    {0xce,0x58}, {0xce,0x5e}, {0xce,0x55}, {0xce,0x59}, {0xce,0x5b}, {0xce,0x5d}, {0xce,0x57}, {0x8b,0x7d}, {0xce,0x56}, {0xce,0x51},
    {0xce,0x52}, {0xab,0xad}, {0x9b,0xf4}, {0xab,0xaf}, {0xab,0xae}, {0xce,0x53}, {0xce,0x5c}, {0x9e,0xf7}, {0x9e,0xc1}, {0xab,0xb1},
    {0x99,0x6f}, {0xce,0x50}, {0xd1,0x53}, {0xd1,0x52}, {0xd1,0x57}, {0xd1,0x4e}, {0x96,0xf1}, {0xd1,0x51}, {0xd1,0x50}, {0x8e,0x41},
    {0xd1,0x54}, {0xd1,0x58}, {0xae,0x47}, {0xae,0x4a}, {0x95,0x4a}, {0xd1,0x4f}, {0xd1,0x55}, {0x97,0xe6}, {0xae,0x49}, {0xd1,0x4a},
    {0xab,0xb0}, {0xd4,0xba}, {0xd1,0x56}, {0xd1,0x4d}, {0xae,0x48}, {0xd1,0x4c}, {0x96,0xf5}, {0xd4,0xb1}, {0x92,0xe6}, {0x9f,0x42},
    {0xb0,0xec}, {0xb0,0xf0}, {0xd4,0xc1}, {0xd4,0xaf}, {0xd4,0xbd}, {0xb0,0xf1}, {0xd4,0xbf}, {0xfb,0x67}, {0xd4,0xc5}, {0xd4,0xc9},
    {0xd4,0xc0}, {0xd4,0xb4}, {0xd4,0xbc}, {0x99,0xa9}, {0xd4,0xca}, {0xd4,0xc8}, {0xd4,0xbe}, {0xd4,0xb9}, {0xd4,0xb2}, {0xd8,0xa6},
    {0xd4,0xb0}, {0xb0,0xf5}, {0xd4,0xb7}, {0xb0,0xf6}, {0xb0,0xf2}, {0xd4,0xad}, {0xd4,0xc3}, {0xd4,0xb5}, {0xfa,0xe6}, {0xd4,0xb3},
    {0xd4,0xc6}, {0xb0,0xf3}, {0xfb,0x69}, {0xd4,0xcc}, {0xb0,0xed}, {0xb0,0xef}, {0xd4,0xbb}, {0xd4,0xb6}, {0xae,0x4b}, {0xb0,0xee},
    {0xd4,0xb8}, {0xd4,0xc7}, {0xd4,0xcb}, {0xd4,0xc2}, {0xd4,0xc4}, {0x97,0xe5}, {0xd4,0xae}, {0xd8,0xa1}, {0xd8,0xaa}, {0xd8,0xa9},
    {0xb3,0xfa}, {0xd8,0xa2}, {0xb3,0xfb}, {0xb3,0xf9}, {0x96,0x7d}, {0xd8,0xa4}, {0xb3,0xf6}, {0xd8,0xa8}, {0xfb,0x6c}, {0xd8,0xa3},
    {0xd8,0xa5}, {0xd8,0x7d}, {0xb3,0xf4}, {0xd8,0xb2}, {0xd8,0xb1}, {0xd8,0xae}, {0xb3,0xf3}, {0xb3,0xf7}, {0xb3,0xf8}, {0xd1,0x4b},
    {0xd8,0xab}, {0xb3,0xf5}, {0xb0,0xf4}, {0xd8,0xad}, {0xd8,0x7e}, {0xd8,0xb0}, {0xd8,0xaf}, {0x99,0xa2}, {0xd8,0xb3}, {0xdc,0xef},
    {0xd8,0xac}, {0x9a,0xbb}, {0x9a,0x65}, {0x94,0x4e}, {0xd8,0xa7}, {0xdc,0xe7}, {0xb6,0xf4}, {0xb6,0xf7}, {0xb6,0xf2}, {0xdc,0xe6},
    {0xdc,0xea}, {0xdc,0xe5}, {0xb6,0xec}, {0xb6,0xf6}, {0xdc,0xe2}, {0xb6,0xf0}, {0xdc,0xe9}, {0xb6,0xee}, {0xb6,0xed}, {0xdc,0xec},
    {0xb6,0xef}, {0xdc,0xee}, {0xfb,0x6e}, {0xdc,0xeb}, {0xb6,0xeb}, {0x99,0xdf}, {0xb6,0xf5}, {0xdc,0xf0}, {0xdc,0xe4}, {0xdc,0xed},
    {0xdc,0xe3}, {0x98,0xe3}, {0xb6,0xf1}, {0x92,0x54}, {0xb6,0xf3}, {0xdc,0xe8}, {0xdc,0xf1}, {0x96,0x7b}, {0x8a,0xaf}, {0xe1,0x5d},
    {0xb9,0xd0}, {0xe1,0x63}, {0xb9,0xd5}, {0xe1,0x5f}, {0xe1,0x66}, {0xe1,0x57}, {0xb9,0xd7}, {0xb9,0xd1}, {0xe1,0x5c}, {0xbc,0x55},
    {0xe1,0x5b}, {0xe1,0x64}, {0xb9,0xd2}, {0xb9,0xd6}, {0xe1,0x5a}, {0xe1,0x60}, {0xe1,0x65}, {0xe1,0x56}, {0xb9,0xd4}, {0xe1,0x5e},
    {0xe1,0x62}, {0xe1,0x68}, {0xe1,0x58}, {0xe1,0x61}, {0x8c,0x77}, {0xb9,0xd3}, {0xe1,0x67}, {0xe1,0x59}, {0x8b,0xaf}, {0x9e,0xbd},
    {0xbc,0x59}, {0xe5,0x4b}, {0xbc,0x57}, {0xbc,0x56}, {0xe5,0x4d}, {0xe5,0x52}, {0xe5,0x4e}, {0xe5,0x51}, {0xbc,0x5c}, {0x9e,0xe6},
    {0xbe,0xa5}, {0xbc,0x5b}, {0xfb,0x6f}, {0xe5,0x4a}, {0xe5,0x50}, {0xbc,0x5a}, {0xe5,0x4f}, {0x8e,0xe1}, {0xe5,0x4c}, {0xbc,0x58},
    {0x9b,0x7d}, {0x9c,0x7e}, {0xe9,0x4d}, {0xf9,0xd9}, {0xe9,0x4f}, {0xe9,0x4a}, {0xbe,0xc1}, {0xe9,0x4c}, {0xbe,0xc0}, {0xe9,0x4e},
    {0xbe,0xc3}, {0xe9,0x50}, {0xbe,0xc2}, {0xe9,0x49}, {0xe9,0x4b}, {0x92,0xea}, {0xc0,0xa5}, {0xec,0xcc}, {0x8c,0x78}, {0xc0,0xa4},
    {0xec,0xcd}, {0xc0,0xa3}, {0xec,0xcb}, {0xc0,0xa2}, {0xec,0xca}, {0xc2,0x53}, {0xc2,0x52}, {0xf1,0xf6}, {0xf1,0xf8}, {0xfb,0x72},
    {0xf1,0xf7}, {0xc3,0x61}, {0xc3,0x62}, {0xfb,0x71}, {0xc3,0x63}, {0xf4,0x42}, {0xc4,0x5b}, {0xf7,0xd3}, {0xf7,0xd2}, {0xc5,0xf2},
    {0xa4,0x68}, {0xa4,0xd0}, {0xa7,0xa7}, {0x89,0x5c}, {0x98,0xf0}, {0x96,0xf2}, {0xce,0x5f}, {0xb3,0xfc}, {0xb3,0xfd}, {0xfb,0x74},
    {0xdc,0xf2}, {0xb9,0xd8}, {0xe1,0x69}, {0xe5,0x53}, {0x8b,0xc1}, {0xc9,0x5a}, {0x89,0x5d}, {0x89,0xde}, {0xca,0xb0}, {0x89,0x5e},
    {0xc6,0xca}, {0xcc,0x42}, {0xce,0x60}, {0xd1,0x59}, {0xae,0x4c}, {0xfe,0x42}, {0xf1,0xf9}, {0xc4,0xdc}, {0xa4,0x69}, {0xa5,0x7e},
    {0xc9,0x70}, {0xa6,0x67}, {0xa6,0x68}, {0xa9,0x5d}, {0xfb,0x7b}, {0xb0,0xf7}, {0xb9,0xda}, {0xb9,0xdb}, {0xb9,0xd9}, {0xa4,0x6a},
    {0xa4,0xd1}, {0xa4,0xd3}, {0xa4,0xd2}, {0xc9,0x5b}, {0xa4,0xd4}, {0xa5,0xa1}, {0xc9,0x71}, {0xa5,0xa2}, {0x89,0x5f}, {0x89,0x60},
    {0xa6,0x69}, {0xa6,0x6a}, {0xc9,0xcb}, {0xa7,0xa8}, {0xca,0xb1}, {0xa9,0x61}, {0xcc,0x43}, {0xa9,0x5f}, {0xa9,0x60}, {0xa9,0x5e},
    {0xd1,0x5a}, {0xab,0xb6}, {0xab,0xb5}, {0xab,0xb7}, {0xab,0xb4}, {0xce,0x61}, {0xa9,0x62}, {0xab,0xb3}, {0xae,0x4d}, {0xae,0x4e},
    {0xae,0x4f}, {0xd4,0xcd}, {0xb3,0xfe}, {0xd8,0xb4}, {0xb0,0xf8}, {0x9b,0xcd}, {0xb6,0xf8}, {0xb9,0xdd}, {0xb9,0xdc}, {0xe1,0x6a},
    {0xbc,0x5d}, {0xbe,0xc4}, {0xef,0xc0}, {0xf6,0xda}, {0xf7,0xd4}, {0xa4,0x6b}, {0xa5,0xa3}, {0x9d,0xd3}, {0xa5,0xa4}, {0xc9,0xd1},
    {0xa6,0x6c}, {0xa6,0x6f}, {0xc9,0xcf}, {0xc9,0xcd}, {0xa6,0x6e}, {0xc9,0xd0}, {0xc9,0xd2}, {0xc9,0xcc}, {0xa6,0x71}, {0xa6,0x70},
    {0xa6,0x6d}, {0xa6,0x6b}, {0xc9,0xce}, {0x98,0x4c}, {0xa7,0xb3}, {0xa7,0xb0}, {0xca,0xb6}, {0xca,0xb9}, {0xca,0xb8}, {0xa7,0xaa},
    {0xa7,0xb2}, {0x97,0x52}, {0xa7,0xaf}, {0xca,0xb5}, {0xca,0xb3}, {0xa7,0xae}, {0x95,0xc3}, {0xa7,0xa9}, {0xa7,0xac}, {0x9b,0xb6},
    {0xca,0xb4}, {0xca,0xbb}, {0xca,0xb7}, {0xa7,0xad}, {0xa7,0xb1}, {0xa7,0xb4}, {0xca,0xb2}, {0xca,0xba}, {0xa7,0xab}, {0x9a,0xb9},
    {0xa9,0x67}, {0xa9,0x6f}, {0x97,0xb3}, {0xcc,0x4f}, {0xcc,0x48}, {0xa9,0x70}, {0xcc,0x53}, {0xcc,0x44}, {0xcc,0x4b}, {0x9f,0x74},
    {0x92,0xf1}, {0xa9,0x66}, {0xcc,0x45}, {0xa9,0x64}, {0xcc,0x4c}, {0xcc,0x50}, {0xa9,0x63}, {0xcc,0x51}, {0xcc,0x4a}, {0xcc,0x4d},
    {0x97,0xdf}, {0xa9,0x72}, {0xa9,0x69}, {0xcc,0x54}, {0xcc,0x52}, {0xfb,0xa6}, {0xa9,0x6e}, {0xa9,0x6c}, {0xcc,0x49}, {0xa9,0x6b},
    {0xcc,0x47}, {0xcc,0x46}, {0xa9,0x6a}, {0xa9,0x68}, {0xa9,0x71}, {0xa9,0x6d}, {0xa9,0x65}, {0xcc,0x4e}, {0xab,0xb9}, {0xfb,0xab},
    {0xab,0xc0}, {0xce,0x6f}, {0xab,0xb8}, {0xce,0x67}, {0xce,0x63}, {0xce,0x73}, {0xce,0x62}, {0xab,0xbb}, {0xce,0x6c}, {0xab,0xbe},
    {0xab,0xc1}, {0xab,0xbc}, {0xce,0x70}, {0xab,0xbf}, {0x98,0x77}, {0xae,0x56}, {0xce,0x76}, {0xce,0x64}, {0x98,0x54}, {0x95,0xc5},
    {0xce,0x66}, {0xce,0x6d}, {0xce,0x71}, {0xce,0x75}, {0xce,0x72}, {0xce,0x6b}, {0xce,0x6e}, {0x9d,0x55}, {0xfb,0xb2}, {0xce,0x68},
    {0xab,0xc3}, {0xce,0x6a}, {0xce,0x69}, {0xce,0x74}, {0xab,0xba}, {0xce,0x65}, {0xab,0xc2}, {0x95,0x7e}, {0xab,0xbd}, {0xae,0x5c},
    {0xd1,0x62}, {0x97,0x42}, {0xae,0x5b}, {0x94,0xe6}, {0xd1,0x60}, {0xae,0x50}, {0x92,0xf5}, {0xae,0x55}, {0xd1,0x5f}, {0xd1,0x5c},
    {0xd1,0x61}, {0xae,0x51}, {0xd1,0x5b}, {0x8c,0xc5}, {0xae,0x54}, {0xae,0x52}, {0xd1,0x63}, {0xae,0x53}, {0xae,0x57}, {0x92,0xfd},
    {0xae,0x58}, {0xfb,0xa2}, {0xae,0x5a}, {0x9c,0x51}, {0xae,0x59}, {0x94,0xe9}, {0x98,0x5c}, {0x92,0xf0}, {0xd1,0x5d}, {0xd1,0x5e},
    {0xd1,0x64}, {0xd4,0xd4}, {0xb0,0xf9}, {0xd8,0xc2}, {0xd4,0xd3}, {0xd4,0xe6}, {0xb1,0x40}, {0x94,0x4c}, {0xd4,0xe4}, {0xb0,0xfe},
    {0xb0,0xfa}, {0xd4,0xed}, {0xd4,0xdd}, {0xd4,0xe0}, {0x91,0x6b}, {0xb1,0x43}, {0xd4,0xea}, {0xd4,0xe2}, {0xb0,0xfb}, {0xb1,0x44},
    {0xd4,0xe7}, {0xd4,0xe5}, {0xd4,0xd6}, {0xd4,0xeb}, {0xd4,0xdf}, {0xd4,0xda}, {0x8b,0x78}, {0xd4,0xd0}, {0xd4,0xec}, {0xd4,0xdc},
    {0xd4,0xcf}, {0x94,0xe2}, {0xb1,0x42}, {0xd4,0xe1}, {0xd4,0xee}, {0xd4,0xde}, {0xd4,0xd2}, {0xd4,0xd7}, {0xd4,0xce}, {0x98,0x4f},
    {0xb1,0x41}, {0xfb,0xb5}, {0xd4,0xdb}, {0xd4,0xd8}, {0xb0,0xfc}, {0xd4,0xd1}, {0x92,0x71}, {0xd4,0xe9}, {0xb0,0xfd}, {0x93,0x65},
    {0xd4,0xd9}, {0xd4,0xd5}, {0x98,0x5b}, {0xd4,0xe8}, {0x98,0x50}, {0xb4,0x40}, {0xd8,0xbb}, {0x97,0xbc}, {0xd8,0xb8}, {0xd8,0xc9},
    {0xd8,0xbd}, {0xd8,0xca}, {0x92,0xf3}, {0xb4,0x42}, {0x93,0x40}, {0x98,0x4d}, {0xd8,0xc6}, {0xd8,0xc3}, {0x95,0x72}, {0xfd,0xef},
    {0xd8,0xc4}, {0xd8,0xc7}, {0xd8,0xcb}, {0xd4,0xe3}, {0xd8,0xcd}, {0xdd,0x47}, {0xfd,0xc1}, {0xb4,0x43}, {0xd8,0xce}, {0xd8,0xb6},
    {0xd8,0xc0}, {0xfb,0xba}, {0xd8,0xc5}, {0x92,0xeb}, {0xb4,0x41}, {0xb4,0x44}, {0xd8,0xcc}, {0xd8,0xcf}, {0xd8,0xba}, {0xd8,0xb7},
    {0xfc,0x73}, {0x97,0xb7}, {0xd8,0xb9}, {0xd8,0xbe}, {0xd8,0xbc}, {0xb4,0x45}, {0xd8,0xc8}, {0xfb,0xb4}, {0xd8,0xbf}, {0xd8,0xc1},
    {0xd8,0xb5}, {0xdc,0xfa}, {0xdc,0xf8}, {0xb7,0x42}, {0xb7,0x40}, {0xdd,0x43}, {0xdc,0xf9}, {0xdd,0x44}, {0xdd,0x40}, {0xdc,0xf7},
    {0xdd,0x46}, {0xdc,0xf6}, {0xdc,0xfd}, {0xb6,0xfe}, {0xb6,0xfd}, {0xb6,0xfc}, {0xdc,0xfb}, {0xdd,0x41}, {0xb6,0xf9}, {0xb7,0x41},
    {0x90,0xa7}, {0xdc,0xf4}, {0xdc,0xfe}, {0xdc,0xf3}, {0xdc,0xfc}, {0xb6,0xfa}, {0xdd,0x42}, {0xdc,0xf5}, {0xb6,0xfb}, {0xdd,0x45},
    {0x97,0x41}, {0x92,0xf4}, {0xfb,0xbc}, {0xe1,0x6e}, {0xb9,0xe2}, {0xb9,0xe1}, {0xb9,0xe3}, {0xe1,0x7a}, {0xe1,0x70}, {0xe1,0x76},
    {0xe1,0x6b}, {0xe1,0x79}, {0xe1,0x78}, {0xe1,0x7c}, {0xe1,0x75}, {0xb9,0xde}, {0xe1,0x74}, {0xb9,0xe4}, {0x95,0x77}, {0xe1,0x6d},
    {0xb9,0xdf}, {0xe1,0x7b}, {0xb9,0xe0}, {0xe1,0x6f}, {0xe1,0x72}, {0xe1,0x77}, {0xe1,0x71}, {0xe1,0x6c}, {0x9e,0xe2}, {0x8f,0x78},
    {0xe1,0x73}, {0xe5,0x55}, {0xbc,0x61}, {0xe5,0x58}, {0xe5,0x57}, {0xe5,0x5a}, {0xe5,0x5c}, {0xf9,0xdc}, {0xbc,0x5f}, {0xe5,0x56},
    {0x96,0x72}, {0xe5,0x54}, {0xe5,0x5d}, {0xe5,0x5b}, {0xe5,0x59}, {0xe5,0x5f}, {0xe5,0x5e}, {0xbc,0x63}, {0xbc,0x5e}, {0xbc,0x60},
    {0xbc,0x62}, {0x9e,0xb5}, {0xe5,0x60}, {0xe9,0x57}, {0x96,0x4b}, {0xe9,0x56}, {0xe9,0x55}, {0x8c,0xac}, {0xe9,0x58}, {0xe9,0x51},
    {0xe9,0x52}, {0xe9,0x5a}, {0xe9,0x53}, {0xbe,0xc5}, {0xe9,0x5c}, {0xa0,0xfa}, {0xe9,0x5b}, {0xe9,0x54}, {0xec,0xd1}, {0xc0,0xa8},
    {0xec,0xcf}, {0xec,0xd4}, {0xec,0xd3}, {0xe9,0x59}, {0xc0,0xa7}, {0x95,0x75}, {0xec,0xd2}, {0xec,0xce}, {0xec,0xd6}, {0xec,0xd5},
    {0xc0,0xa6}, {0xec,0xd0}, {0xbe,0xc6}, {0xc2,0x54}, {0xef,0xc1}, {0xf1,0xfa}, {0xf1,0xfb}, {0xf1,0xfc}, {0xc4,0x5c}, {0x90,0xda},
    {0xc4,0x5d}, {0x93,0x67}, {0xf4,0x43}, {0xfe,0xa4}, {0xf5,0xc8}, {0xf5,0xc7}, {0x90,0xdf}, {0xf6,0xdb}, {0xf6,0xdc}, {0xf7,0xd5},
    {0xf8,0xa7}, {0x93,0x54}, {0xa4,0x6c}, {0xa4,0x6d}, {0xa4,0x6e}, {0xa4,0xd5}, {0xa5,0xa5}, {0xc9,0xd3}, {0xa6,0x72}, {0xa6,0x73},
    {0xa7,0xb7}, {0xa7,0xb8}, {0xa7,0xb6}, {0xa7,0xb5}, {0xa9,0x73}, {0xcc,0x55}, {0xa9,0x75}, {0xa9,0x74}, {0xcc,0x56}, {0x89,0x61},
    {0x8b,0xb4}, {0xab,0xc4}, {0xae,0x5d}, {0xd1,0x65}, {0x9d,0xc0}, {0xd4,0xf0}, {0xb1,0x45}, {0xb4,0x47}, {0xd4,0xef}, {0xb4,0x46},
    {0x8e,0x48}, {0xb9,0xe5}, {0xfb,0xc5}, {0xe1,0x7d}, {0xbe,0xc7}, {0xc0,0xa9}, {0xec,0xd7}, {0xfb,0xc7}, {0xc4,0x5e}, {0xc5,0x70},
    {0xc6,0xcb}, {0xc9,0x72}, {0xfa,0x79}, {0xa5,0xa6}, {0xc9,0x73}, {0xa6,0x76}, {0xa6,0x74}, {0xa6,0x75}, {0xa6,0x77}, {0xa7,0xba},
    {0xa7,0xb9}, {0xca,0xbc}, {0xa7,0xbb}, {0x9e,0x67}, {0xca,0xbd}, {0xcc,0x57}, {0xcc,0x58}, {0x8c,0xd9}, {0xa9,0x76}, {0xa9,0x78},
    {0xa9,0x7a}, {0xa9,0x77}, {0xa9,0x7b}, {0xa9,0x79}, {0xfb,0xd2}, {0x89,0x62}, {0x89,0x63}, {0xab,0xc8}, {0xab,0xc5}, {0xab,0xc7},
    {0xab,0xc9}, {0xab,0xc6}, {0xd1,0x66}, {0xce,0x77}, {0xfc,0x7d}, {0xd1,0x68}, {0xd1,0x67}, {0xae,0x63}, {0xae,0x5f}, {0xae,0x60},
    {0xae,0x62}, {0xae,0x64}, {0xae,0x61}, {0xae,0x66}, {0xae,0x65}, {0xb1,0x4a}, {0xd4,0xf2}, {0xd4,0xf1}, {0xb1,0x49}, {0x9f,0x6b},
    {0xb1,0x48}, {0xb1,0x47}, {0xb1,0x4b}, {0xb1,0x46}, {0xd8,0xd5}, {0xd8,0xd2}, {0xb4,0x49}, {0xd8,0xd1}, {0xd8,0xd6}, {0xb4,0x4b},
    {0xd8,0xd4}, {0xb4,0x48}, {0xb4,0x4a}, {0xd8,0xd3}, {0xfb,0xcc}, {0xdd,0x48}, {0xfe,0xae}, {0xdd,0x49}, {0xdd,0x4a}, {0xb9,0xe6},
    {0xb9,0xee}, {0xe1,0x7e}, {0xb9,0xe8}, {0xb9,0xec}, {0xe1,0xa1}, {0xb9,0xed}, {0xb9,0xe9}, {0xb9,0xea}, {0xb9,0xe7}, {0xb9,0xeb},
    {0xbc,0x66}, {0xd8,0xd0}, {0xbc,0x67}, {0xbc,0x65}, {0xbc,0x64}, {0xe9,0x5d}, {0xbe,0xc8}, {0xec,0xd8}, {0xec,0xd9}, {0xfb,0xd1},
    {0xc3,0x64}, {0xc4,0x5f}, {0xa4,0x6f}, {0xa6,0x78}, {0xfb,0x75}, {0xab,0xca}, {0xd1,0x69}, {0xae,0x67}, {0xfb,0xd4}, {0xb1,0x4e},
    {0xb1,0x4d}, {0xb1,0x4c}, {0xb4,0x4c}, {0xb4,0x4d}, {0xd8,0xd7}, {0xb9,0xef}, {0xbe,0xc9}, {0xa4,0x70}, {0xc9,0x5c}, {0xa4,0xd6},
    {0xc9,0x74}, {0xfb,0xd6}, {0xfb,0xd8}, {0xc9,0xd4}, {0xa6,0x79}, {0xa9,0x7c}, {0x8b,0x5d}, {0x93,0x4c}, {0xdd,0x4b}, {0x9a,0xe2},
    {0xa4,0x71}, {0x8b,0xc9}, {0xa4,0xd7}, {0xc9,0xd5}, {0xca,0xbe}, {0xca,0xbf}, {0xa7,0xbc}, {0xd8,0xd8}, {0xb4,0x4e}, {0xdd,0x4c},
    {0xc0,0xaa}, {0xa4,0x72}, {0xa4,0xa8}, {0xa4,0xd8}, {0xc9,0x75}, {0xa5,0xa7}, {0xa7,0xc0}, {0xa7,0xbf}, {0xa7,0xbd}, {0xa7,0xbe},
    {0xcc,0x59}, {0xa9,0x7e}, {0xa9,0xa1}, {0xcc,0x5a}, {0xa9,0x7d}, {0xfb,0xdb}, {0x9f,0xc9}, {0xab,0xce}, {0xce,0x78}, {0xab,0xcd},
    {0xab,0xcb}, {0xab,0xcc}, {0xae,0x6a}, {0xae,0x68}, {0x9f,0x44}, {0xd1,0x6b}, {0xae,0x69}, {0xd1,0x6a}, {0xae,0x5e}, {0xd4,0xf3},
    {0xb1,0x50}, {0xb1,0x51}, {0x98,0xed}, {0xb1,0x4f}, {0xb9,0xf0}, {0xe1,0xa2}, {0xbc,0x68}, {0xbc,0x69}, {0xe5,0x61}, {0xc0,0xab},
    {0xef,0xc2}, {0xef,0xc3}, {0xc4,0xdd}, {0xf8,0xa8}, {0xc9,0x4b}, {0xa4,0xd9}, {0xa4,0x73}, {0xc9,0x77}, {0xc9,0x76}, {0xa6,0x7a},
    {0xc9,0xd7}, {0xc9,0xd8}, {0xc9,0xd6}, {0xc9,0xd9}, {0xfb,0xdd}, {0xca,0xc7}, {0xca,0xc2}, {0xca,0xc4}, {0xca,0xc6}, {0xca,0xc3},
    {0xa7,0xc4}, {0xca,0xc0}, {0xca,0xc1}, {0xa7,0xc1}, {0xa7,0xc2}, {0xca,0xc5}, {0xca,0xc8}, {0xa7,0xc3}, {0xca,0xc9}, {0x8d,0xf2},
    {0x89,0x64}, {0xfd,0xf2}, {0xcc,0x68}, {0x93,0x4d}, {0xcc,0x62}, {0xcc,0x5d}, {0xa9,0xa3}, {0xcc,0x65}, {0xcc,0x63}, {0xcc,0x5c},
    {0xcc,0x69}, {0xcc,0x6c}, {0xcc,0x67}, {0xcc,0x60}, {0xa9,0xa5}, {0xcc,0x66}, {0xa9,0xa6}, {0xcc,0x61}, {0xcc,0x64}, {0xcc,0x5b},
    {0xcc,0x5f}, {0xcc,0x6b}, {0xa9,0xa7}, {0xa9,0xa8}, {0xcc,0x5e}, {0xcc,0x6a}, {0xa9,0xa2}, {0xa9,0xa4}, {0xfb,0xe7}, {0xa0,0xf2},
    {0x98,0x68}, {0xce,0xab}, {0xce,0xa4}, {0xce,0xaa}, {0xce,0xa3}, {0xce,0xa5}, {0xce,0x7d}, {0xce,0x7b}, {0xce,0xac}, {0xce,0xa9},
    {0xce,0x79}, {0x9f,0x58}, {0xab,0xd0}, {0xce,0xa7}, {0xce,0xa8}, {0xce,0xa6}, {0xce,0x7c}, {0xce,0x7a}, {0xab,0xcf}, {0xce,0xa2},
    {0xce,0x7e}, {0xce,0xa1}, {0xce,0xad}, {0x8d,0x73}, {0xae,0x6f}, {0xfb,0xde}, {0xae,0x6e}, {0xd1,0x6c}, {0xae,0x6b}, {0xd1,0x6e},
    {0xfb,0xdf}, {0xae,0x70}, {0xd1,0x6f}, {0xae,0x73}, {0x8c,0x48}, {0xae,0x71}, {0xd1,0x70}, {0xce,0xae}, {0xd1,0x72}, {0xae,0x6d},
    {0xae,0x6c}, {0xd1,0x6d}, {0xd1,0x71}, {0xae,0x72}, {0xb1,0x53}, {0xb1,0x52}, {0xd4,0xf5}, {0xd4,0xf9}, {0xd4,0xfb}, {0xb1,0x54},
    {0xd4,0xfe}, {0xfb,0xe3}, {0xb1,0x58}, {0xd5,0x41}, {0xb1,0x5a}, {0x8d,0xa8}, {0xb1,0x56}, {0xb1,0x5e}, {0xfb,0xe4}, {0xb1,0x5b},
    {0xd4,0xf7}, {0xb1,0x55}, {0xd4,0xf6}, {0xd4,0xf4}, {0xd5,0x43}, {0xd4,0xf8}, {0xb1,0x57}, {0xd5,0x42}, {0xb1,0x5c}, {0xd4,0xfd},
    {0xd4,0xfc}, {0xb1,0x5d}, {0xd4,0xfa}, {0xb1,0x59}, {0x9c,0x75}, {0xd5,0x44}, {0x98,0x78}, {0xd5,0x40}, {0xd8,0xe7}, {0xd8,0xee},
    {0xd8,0xe3}, {0xb4,0x51}, {0xd8,0xdf}, {0xd8,0xef}, {0xd8,0xd9}, {0xd8,0xec}, {0xd8,0xea}, {0xd8,0xe4}, {0xd8,0xed}, {0xd8,0xe6},
    {0x8d,0x60}, {0xd8,0xde}, {0xd8,0xf0}, {0xd8,0xdc}, {0xd8,0xe9}, {0xd8,0xda}, {0xd8,0xf1}, {0xfb,0xe5}, {0xb4,0x52}, {0x8d,0x61},
    {0xd8,0xeb}, {0xdd,0x4f}, {0xd8,0xdd}, {0xb4,0x4f}, {0xd8,0xe1}, {0xb4,0x50}, {0xd8,0xe0}, {0xd8,0xe5}, {0xd8,0xe2}, {0x8d,0x62},
    {0xa0,0xa1}, {0xd8,0xe8}, {0x9c,0x40}, {0xdd,0x53}, {0xdd,0x56}, {0xdd,0x4e}, {0xdd,0x50}, {0xdd,0x55}, {0xdd,0x54}, {0xb7,0x43},
    {0xd8,0xdb}, {0xdd,0x52}, {0xb7,0x44}, {0x98,0xad}, {0xdd,0x4d}, {0xdd,0x51}, {0x9e,0xea}, {0xe1,0xa9}, {0xe1,0xb0}, {0xe1,0xa7},
    {0x8c,0xd4}, {0xe1,0xae}, {0xe1,0xa5}, {0xe1,0xad}, {0xe1,0xb1}, {0xe1,0xa4}, {0xe1,0xa8}, {0xe1,0xa3}, {0xb9,0xf1}, {0x9c,0xeb},
    {0xe1,0xa6}, {0xb9,0xf2}, {0xe1,0xac}, {0xe1,0xab}, {0xe1,0xaa}, {0xfb,0xe0}, {0xe1,0xaf}, {0x9f,0x51}, {0xe5,0x65}, {0xe5,0x67},
    {0xbc,0x6b}, {0xe5,0x68}, {0xe5,0x63}, {0xe5,0x62}, {0xe5,0x6c}, {0xe5,0x6a}, {0xbc,0x6a}, {0xe5,0x6d}, {0xe5,0x64}, {0xe5,0x69},
    {0xe5,0x6b}, {0xe5,0x66}, {0x8d,0x65}, {0xe9,0x61}, {0xe9,0x66}, {0xe9,0x60}, {0xe9,0x65}, {0x9c,0xf1}, {0xe9,0x5e}, {0xe9,0x68},
    {0xe9,0x64}, {0xe9,0x69}, {0xe9,0x63}, {0xe9,0x5f}, {0xe9,0x67}, {0xe9,0x6a}, {0xe9,0x62}, {0xfc,0x58}, {0xec,0xda}, {0xc0,0xaf},
    {0x8d,0x66}, {0xc0,0xad}, {0xc0,0xac}, {0xc0,0xae}, {0xef,0xc4}, {0x96,0x54}, {0xf1,0x72}, {0xf1,0xfd}, {0xf4,0x44}, {0xf4,0x45},
    {0xc4,0x60}, {0xf5,0xc9}, {0xc4,0xde}, {0xf5,0xca}, {0xf6,0xde}, {0xc5,0x72}, {0xc5,0x71}, {0xf6,0xdd}, {0xc5,0xc9}, {0xfb,0xe8},
    {0xf7,0xd6}, {0xc6,0xcc}, {0xa4,0x74}, {0xa6,0x7b}, {0xc9,0xda}, {0xca,0xca}, {0xa8,0xb5}, {0xb1,0x5f}, {0xa4,0x75}, {0xa5,0xaa},
    {0xa5,0xa9}, {0xa5,0xa8}, {0xa7,0xc5}, {0xae,0x74}, {0xdd,0x57}, {0xa4,0x76}, {0xa4,0x77}, {0xa4,0x78}, {0xa4,0xda}, {0x9f,0xce},
    {0xab,0xd1}, {0xce,0xaf}, {0xb4,0x53}, {0xa4,0x79}, {0xc9,0x5d}, {0xa5,0xab}, {0xa5,0xac}, {0xc9,0x78}, {0xa6,0x7c}, {0xfb,0xfc},
    {0xca,0xcb}, {0x9a,0xe4}, {0xa7,0xc6}, {0xca,0xcc}, {0xa9,0xae}, {0x9f,0x75}, {0xcc,0x6e}, {0xa9,0xac}, {0xa9,0xab}, {0xcc,0x6d},
    {0xa9,0xa9}, {0xcc,0x6f}, {0xa9,0xaa}, {0xa9,0xad}, {0xab,0xd2}, {0xab,0xd4}, {0xce,0xb3}, {0xce,0xb0}, {0xce,0xb1}, {0xce,0xb2},
    {0xce,0xb4}, {0xab,0xd3}, {0xd1,0x74}, {0xd1,0x73}, {0xae,0x76}, {0xae,0x75}, {0xfb,0xf1}, {0xb1,0x62}, {0xd5,0x46}, {0xb1,0x61},
    {0xb1,0x63}, {0xb1,0x60}, {0xb4,0x55}, {0xd5,0x45}, {0xb4,0x56}, {0xd8,0xf3}, {0x8d,0x69}, {0xb4,0x57}, {0xd8,0xf2}, {0xb4,0x54},
    {0x93,0x4f}, {0xdd,0x5a}, {0xdd,0x5c}, {0xb7,0x45}, {0xdd,0x5b}, {0xdd,0x59}, {0xdd,0x58}, {0xe1,0xb4}, {0xb9,0xf7}, {0xb9,0xf5},
    {0xb9,0xf6}, {0xe1,0xb2}, {0xe1,0xb3}, {0xb9,0xf3}, {0xe5,0x71}, {0xe5,0x6f}, {0x93,0x4e}, {0xbc,0x6d}, {0xe5,0x70}, {0xbc,0x6e},
    {0xbc,0x6c}, {0xb9,0xf4}, {0xe9,0x6d}, {0xe9,0x6b}, {0xe9,0x6c}, {0xe5,0x6e}, {0xec,0xdc}, {0xc0,0xb0}, {0xec,0xdb}, {0xef,0xc5},
    {0xef,0xc6}, {0xe9,0x6e}, {0xf1,0xfe}, {0xa4,0x7a}, {0xa5,0xad}, {0xa6,0x7e}, {0xc9,0xdb}, {0xa6,0x7d}, {0xa9,0xaf}, {0xb7,0x46},
    {0xfb,0xf4}, {0xa4,0xdb}, {0xa5,0xae}, {0xab,0xd5}, {0xb4,0x58}, {0xc6,0xce}, {0xc9,0x79}, {0xc9,0x7a}, {0xfb,0xc3}, {0xc9,0xdc},
    {0x89,0x65}, {0xa7,0xc8}, {0xca,0xd0}, {0xca,0xce}, {0xa7,0xc9}, {0xca,0xcd}, {0xca,0xcf}, {0xca,0xd1}, {0xa7,0xc7}, {0x8c,0x7a},
    {0xa9,0xb3}, {0xa9,0xb4}, {0xa9,0xb1}, {0x8c,0x7b}, {0xa9,0xb0}, {0xce,0xb8}, {0xa9,0xb2}, {0xab,0xd6}, {0xce,0xb7}, {0xce,0xb9},
    {0xce,0xb6}, {0xce,0xba}, {0xab,0xd7}, {0xae,0x79}, {0xd1,0x75}, {0xd1,0x77}, {0xae,0x77}, {0xd1,0x78}, {0xae,0x78}, {0xd1,0x76},
    {0xce,0xb5}, {0xd5,0x47}, {0xd5,0x4a}, {0xd5,0x4b}, {0xd5,0x48}, {0xb1,0x67}, {0xb1,0x66}, {0xb1,0x64}, {0xb1,0x65}, {0xd5,0x49},
    {0x8d,0x6a}, {0xb1,0x68}, {0xb4,0x5a}, {0xb4,0x5b}, {0xb4,0x5c}, {0xdd,0x5d}, {0xdd,0x5f}, {0xdd,0x61}, {0xb7,0x48}, {0xb7,0x47},
    {0xb4,0x59}, {0xdd,0x60}, {0xdd,0x5e}, {0x93,0x53}, {0xe1,0xb8}, {0x9d,0xfb}, {0xe1,0xb6}, {0xe1,0xbc}, {0xb9,0xf8}, {0xe1,0xbd},
    {0xe1,0xba}, {0xb9,0xf9}, {0xe1,0xb7}, {0xe1,0xb5}, {0xe1,0xbb}, {0xbc,0x70}, {0xe5,0x73}, {0xe1,0xb9}, {0xbc,0x72}, {0xe5,0x74},
    {0xbc,0x71}, {0xbc,0x74}, {0xe5,0x75}, {0xbc,0x6f}, {0xbc,0x73}, {0xe9,0x73}, {0xe9,0x71}, {0xe9,0x70}, {0xe9,0x72}, {0xe9,0x6f},
    {0xc3,0x66}, {0xf4,0x46}, {0xf4,0x47}, {0xf5,0xcb}, {0xf6,0xdf}, {0xc6,0x55}, {0xfb,0xfd}, {0xa9,0xb5}, {0xa7,0xca}, {0x90,0x59},
    {0xfc,0x40}, {0xab,0xd8}, {0xfc,0x41}, {0xfc,0x43}, {0xa4,0x7b}, {0xa4,0xdc}, {0xa5,0xaf}, {0xc9,0xdd}, {0xa7,0xcb}, {0xca,0xd2},
    {0xce,0xbb}, {0xab,0xd9}, {0xb9,0xfa}, {0xa4,0x7c}, {0x93,0x61}, {0xfc,0x46}, {0x93,0x62}, {0xa6,0xa1}, {0xb7,0x49}, {0xa4,0x7d},
    {0xa4,0xdd}, {0xa4,0xde}, {0xa5,0xb1}, {0xa5,0xb0}, {0xc9,0xde}, {0xa6,0xa2}, {0xca,0xd3}, {0xa7,0xcc}, {0xcc,0x71}, {0xcc,0x72},
    {0xcc,0x73}, {0x8d,0x6b}, {0xa9,0xb6}, {0xa9,0xb7}, {0xcc,0x70}, {0xa9,0xb8}, {0xab,0xda}, {0xce,0xbc}, {0xd1,0x7a}, {0xae,0x7a},
    {0xd1,0x79}, {0xb1,0x69}, {0xd5,0x4c}, {0xb1,0x6a}, {0xd5,0x4d}, {0xfc,0x4c}, {0xb4,0x5d}, {0xdd,0x62}, {0xe1,0xbf}, {0xe1,0xbe},
    {0xb9,0xfb}, {0xbc,0x75}, {0xe5,0x76}, {0xbe,0xca}, {0xe9,0x74}, {0xc0,0xb1}, {0x95,0xb8}, {0xc5,0x73}, {0xf7,0xd8}, {0xc6,0xd0},
    {0x8b,0xca}, {0xcc,0x74}, {0xce,0xbd}, {0xb1,0x6b}, {0xd8,0xf4}, {0xb7,0x4a}, {0x98,0x7a}, {0xc2,0x55}, {0xc6,0xd1}, {0xa7,0xce},
    {0xfc,0x51}, {0xa7,0xcd}, {0xab,0xdb}, {0xd1,0x7b}, {0xb1,0x6d}, {0xb3,0x43}, {0xb1,0x6e}, {0xb1,0x6c}, {0xb4,0x5e}, {0xe1,0xc0},
    {0xb9,0xfc}, {0xbc,0x76}, {0xfc,0x54}, {0xc9,0x4c}, {0xc9,0xdf}, {0xca,0xd5}, {0xa7,0xcf}, {0xca,0xd4}, {0xa7,0xd0}, {0xfa,0xaf},
    {0xa9,0xbc}, {0xcc,0x77}, {0xcc,0x76}, {0xa9,0xbb}, {0xa9,0xb9}, {0xa9,0xba}, {0xcc,0x75}, {0x8d,0x6c}, {0xab,0xdd}, {0xce,0xbe},
    {0xab,0xe0}, {0xab,0xdc}, {0xab,0xe2}, {0xab,0xde}, {0xab,0xdf}, {0xab,0xe1}, {0xae,0x7d}, {0xae,0x7c}, {0xae,0x7b}, {0xd5,0x4f},
    {0xb1,0x6f}, {0xb1,0x72}, {0xb1,0x70}, {0xd5,0x4e}, {0xb1,0x75}, {0xb1,0x71}, {0xd5,0x50}, {0xb1,0x74}, {0xb1,0x73}, {0xfa,0x61},
    {0xd8,0xf6}, {0xd8,0xf5}, {0xfc,0x57}, {0xb4,0x61}, {0xb4,0x5f}, {0xb4,0x60}, {0xd8,0xf7}, {0xb7,0x4b}, {0xdd,0x64}, {0xb7,0x4c},
    {0xdd,0x63}, {0x9b,0x70}, {0xe5,0x77}, {0xbc,0x78}, {0xe1,0xc1}, {0xbc,0x77}, {0xb9,0xfd}, {0xa0,0x51}, {0xec,0xde}, {0xe9,0x75},
    {0xc0,0xb2}, {0xec,0xdd}, {0xf2,0x40}, {0xf4,0x48}, {0xf4,0x49}, {0x8c,0x7c}, {0xa4,0xdf}, {0x8b,0xcb}, {0xa5,0xb2}, {0xc9,0x7b},
    {0xa7,0xd2}, {0xa7,0xd4}, {0xc9,0xe2}, {0xca,0xd8}, {0xca,0xd7}, {0xca,0xd6}, {0xc9,0xe1}, {0xc9,0xe0}, {0xa6,0xa4}, {0xa7,0xd3},
    {0xa7,0xd1}, {0xa6,0xa3}, {0x93,0x6e}, {0xa9,0xbd}, {0xcc,0x78}, {0xfc,0xd5}, {0xa9,0xbe}, {0xca,0xdd}, {0xca,0xdf}, {0xca,0xde},
    {0xcc,0x79}, {0xca,0xda}, {0xa7,0xd8}, {0xa7,0xd6}, {0xca,0xd9}, {0xca,0xdb}, {0xca,0xe1}, {0xa7,0xd5}, {0xca,0xdc}, {0xca,0xe5},
    {0xa9,0xc0}, {0xca,0xe2}, {0xa7,0xd7}, {0xca,0xe0}, {0xca,0xe3}, {0xa9,0xbf}, {0xa9,0xc1}, {0xca,0xe4}, {0xcc,0xaf}, {0xcc,0xa2},
    {0xcc,0x7e}, {0xcc,0xae}, {0xcc,0xa9}, {0xab,0xe7}, {0xa9,0xc2}, {0xcc,0xaa}, {0xcc,0xad}, {0xab,0xe3}, {0xcc,0xac}, {0xa9,0xc3},
    {0xa9,0xc8}, {0xa9,0xc6}, {0xcc,0xa3}, {0xcc,0x7c}, {0xcc,0xa5}, {0xa9,0xcd}, {0xcc,0xb0}, {0xab,0xe4}, {0xcc,0xa6}, {0xab,0xe5},
    {0xa9,0xc9}, {0xcc,0xa8}, {0xfc,0xa9}, {0xce,0xcd}, {0xab,0xe6}, {0xcc,0x7b}, {0xa9,0xca}, {0xab,0xe8}, {0xa9,0xcb}, {0xa9,0xc7},
    {0xa9,0xcc}, {0xcc,0xa7}, {0xcc,0x7a}, {0xcc,0xab}, {0xa9,0xc4}, {0xfc,0x61}, {0xcc,0x7d}, {0xcc,0xa4}, {0xcc,0xa1}, {0xa9,0xc5},
    {0xce,0xbf}, {0xce,0xc0}, {0x89,0x66}, {0xce,0xca}, {0xd1,0xa1}, {0xce,0xcb}, {0xab,0xee}, {0xce,0xce}, {0xce,0xc4}, {0xab,0xed},
    {0xce,0xc6}, {0xce,0xc7}, {0xfa,0xcb}, {0xce,0xc9}, {0xab,0xe9}, {0xae,0xa3}, {0xf9,0xda}, {0xce,0xc5}, {0xce,0xc1}, {0xae,0xa4},
    {0xce,0xcf}, {0xae,0x7e}, {0xd1,0x7d}, {0xce,0xc8}, {0xd1,0x7c}, {0xce,0xc3}, {0xce,0xcc}, {0xab,0xec}, {0xae,0xa1}, {0xab,0xf2},
    {0xae,0xa2}, {0xce,0xd0}, {0xd1,0x7e}, {0xab,0xeb}, {0xae,0xa6}, {0xab,0xf1}, {0xab,0xf0}, {0xab,0xef}, {0xae,0xa5}, {0xce,0xd1},
    {0xae,0xa7}, {0xab,0xea}, {0xce,0xc2}, {0x93,0x7a}, {0xa0,0xe0}, {0x93,0x6b}, {0xb1,0x76}, {0xd1,0xa4}, {0xd1,0xa6}, {0xd1,0xa8},
    {0xae,0xa8}, {0xae,0xae}, {0xd5,0x53}, {0xd1,0xac}, {0xd1,0xa3}, {0xb1,0x78}, {0xd5,0x51}, {0xae,0xad}, {0xae,0xab}, {0xd1,0xae},
    {0xd5,0x52}, {0xd1,0xa5}, {0xae,0xac}, {0xd1,0xa9}, {0xae,0xaf}, {0xd1,0xab}, {0xae,0xaa}, {0xd1,0xaa}, {0xd1,0xad}, {0xd1,0xa7},
    {0xfc,0x6b}, {0xae,0xa9}, {0xb1,0x79}, {0xd1,0xa2}, {0xb1,0x77}, {0xa0,0xdc}, {0x94,0x68}, {0xb1,0x7a}, {0xd5,0x55}, {0xd5,0x5e},
    {0xb4,0x64}, {0xfc,0x6d}, {0xb1,0x7c}, {0xb1,0xa3}, {0xb4,0x65}, {0xd5,0x60}, {0xb1,0xaa}, {0xd8,0xf9}, {0xd5,0x56}, {0xb1,0xa2},
    {0xb1,0xa5}, {0xb1,0x7e}, {0xd5,0x54}, {0xd5,0x62}, {0xd5,0x65}, {0xd9,0x49}, {0xd5,0x63}, {0xd8,0xfd}, {0xb1,0xa1}, {0xb1,0xa8},
    {0xb1,0xac}, {0xd5,0x5d}, {0xd8,0xf8}, {0xd5,0x61}, {0xb1,0x7b}, {0xd8,0xfa}, {0xd5,0x64}, {0xd8,0xfc}, {0xd5,0x59}, {0xb4,0x62},
    {0xd5,0x57}, {0xd5,0x58}, {0xb1,0xa7}, {0x8d,0x71}, {0xb1,0xa6}, {0xd5,0x5b}, {0xb1,0xab}, {0xd5,0x5f}, {0xb1,0xa4}, {0xd5,0x5c},
    {0xfd,0x64}, {0xb1,0xa9}, {0xb4,0x66}, {0xb4,0x63}, {0xd8,0xfb}, {0x99,0xba}, {0xd5,0x5a}, {0xb1,0x7d}, {0x9a,0xd0}, {0x9a,0x61},
    {0xa0,0xe5}, {0xb4,0x6b}, {0xb4,0x6f}, {0xd9,0x40}, {0xb7,0x51}, {0xb4,0x6d}, {0xd9,0x44}, {0xb4,0x71}, {0xdd,0x65}, {0xd9,0x46},
    {0xb7,0x53}, {0xb4,0x69}, {0xb4,0x6c}, {0xd9,0x47}, {0xa0,0x5b}, {0xd9,0x48}, {0xd9,0x4e}, {0xb4,0x73}, {0xb7,0x54}, {0xd9,0x4a},
    {0xd9,0x4f}, {0xd9,0x43}, {0xb7,0x5e}, {0x96,0xac}, {0xb7,0x55}, {0xb4,0x72}, {0xd9,0x41}, {0xd9,0x50}, {0x97,0x40}, {0xb7,0x5d},
    {0xb4,0x70}, {0xb7,0x4e}, {0xd9,0x4d}, {0xb4,0x74}, {0xd9,0x45}, {0xd8,0xfe}, {0xb4,0x6a}, {0xd9,0x42}, {0xd9,0x4b}, {0x9e,0xf1},
    {0xb7,0x4d}, {0xb7,0x52}, {0xb4,0x67}, {0xd9,0x4c}, {0xb7,0x50}, {0x8c,0x4d}, {0xb4,0x68}, {0xb7,0x5c}, {0xe1,0xc3}, {0xdd,0x70},
    {0xdd,0x68}, {0xe1,0xc2}, {0xdd,0x6c}, {0xdd,0x6e}, {0x9f,0x7e}, {0xdd,0x6b}, {0xb7,0x5b}, {0xdd,0x6a}, {0xb7,0x5f}, {0xe1,0xd2},
    {0x8d,0x72}, {0xb7,0x5a}, {0xba,0x40}, {0xdd,0x71}, {0xe1,0xc4}, {0xfc,0x76}, {0xb7,0x58}, {0xdd,0x69}, {0xdd,0x6d}, {0xb9,0xfe},
    {0xb7,0x4f}, {0xdd,0x66}, {0xdd,0x67}, {0xba,0x41}, {0xb7,0x57}, {0xb7,0x59}, {0xb7,0x56}, {0xdd,0x6f}, {0x96,0xa9}, {0xe1,0xc8},
    {0xe1,0xc9}, {0xe1,0xce}, {0xbc,0x7d}, {0xe1,0xd5}, {0xba,0x47}, {0xa0,0x6e}, {0xba,0x46}, {0xe1,0xd0}, {0xfc,0xaa}, {0xbc,0x7c},
    {0xe1,0xc5}, {0xba,0x45}, {0xfb,0xcd}, {0xe1,0xd4}, {0xba,0x43}, {0xba,0x44}, {0xfc,0x74}, {0xe1,0xd1}, {0xe5,0xaa}, {0xbc,0x7a},
    {0xb4,0x6e}, {0xe1,0xd3}, {0xbc,0xa3}, {0xe1,0xcb}, {0xbc,0x7b}, {0xa0,0x74}, {0xbc,0xa2}, {0xe1,0xc6}, {0xe1,0xca}, {0xe1,0xc7},
    {0xe1,0xcd}, {0xba,0x48}, {0xbc,0x79}, {0xba,0x42}, {0xe5,0x7a}, {0xe1,0xcf}, {0xbc,0xa1}, {0xa0,0x71}, {0xbc,0xa4}, {0xe1,0xcc},
    {0xfc,0x79}, {0xbc,0x7e}, {0xe5,0x79}, {0xfc,0x7c}, {0xe5,0x7e}, {0xbe,0xce}, {0xe5,0x78}, {0xe9,0xa3}, {0xe5,0xa9}, {0xbc,0xa8},
    {0xbc,0xa6}, {0xbe,0xcc}, {0xe5,0xa6}, {0xe5,0xa2}, {0xbc,0xac}, {0x9c,0x50}, {0xe9,0x78}, {0x93,0x79}, {0x93,0x78}, {0xbc,0xaa},
    {0xe5,0xa1}, {0xa0,0xdd}, {0xe9,0x76}, {0xe5,0xa5}, {0xe5,0xa8}, {0xe5,0x7d}, {0xbc,0xab}, {0xbc,0xa5}, {0xe9,0x77}, {0xbe,0xcd},
    {0xe5,0xa7}, {0xbc,0xa7}, {0xbc,0xa9}, {0xe5,0xa4}, {0xbc,0xad}, {0xe5,0xa3}, {0xe5,0x7c}, {0xe5,0x7b}, {0xbe,0xcb}, {0xe5,0xab},
    {0xe9,0x7a}, {0xec,0xe0}, {0xbe,0xd0}, {0x8d,0x75}, {0xe9,0xa2}, {0x8d,0x76}, {0xe9,0x7e}, {0xec,0xe1}, {0xbe,0xd1}, {0xe9,0xa1},
    {0x93,0x74}, {0xe9,0x7c}, {0xc0,0xb4}, {0xec,0xdf}, {0xe9,0x79}, {0xe9,0x7b}, {0xc0,0xb5}, {0xbe,0xd3}, {0xc0,0xb3}, {0xbe,0xd2},
    {0xc0,0xb7}, {0xe9,0x7d}, {0xbe,0xcf}, {0x8d,0x77}, {0xfc,0xa5}, {0xfc,0xa2}, {0xef,0xcf}, {0xef,0xc7}, {0x90,0xc3}, {0xec,0xe7},
    {0xef,0xc8}, {0xec,0xe3}, {0xa0,0x79}, {0xc2,0x56}, {0xec,0xe5}, {0xec,0xe4}, {0xc0,0xb6}, {0xec,0xe2}, {0xec,0xe6}, {0xef,0xd0},
    {0xef,0xcc}, {0xef,0xce}, {0xef,0xc9}, {0xef,0xca}, {0xef,0xcd}, {0xef,0xcb}, {0xc3,0x67}, {0xc3,0x6a}, {0xc3,0x69}, {0xc3,0x68},
    {0xc4,0x61}, {0xf4,0x4a}, {0xc4,0x62}, {0xf2,0x41}, {0xc4,0xdf}, {0xf5,0xcc}, {0xc4,0xe0}, {0xc5,0x74}, {0xc5,0xca}, {0xf7,0xd9},
    {0xf7,0xda}, {0xf7,0xdb}, {0xf9,0xba}, {0xa4,0xe0}, {0xc9,0x7c}, {0xa5,0xb3}, {0xa6,0xa6}, {0xa6,0xa7}, {0xa6,0xa5}, {0xa6,0xa8},
    {0xa7,0xda}, {0xa7,0xd9}, {0xcc,0xb1}, {0xa9,0xcf}, {0xa9,0xce}, {0xd1,0xaf}, {0xb1,0xad}, {0xb1,0xae}, {0xb4,0x75}, {0xdd,0x72},
    {0xb7,0x60}, {0xb7,0x61}, {0xdd,0x74}, {0xdd,0x76}, {0xdd,0x75}, {0xe1,0xd7}, {0xe1,0xd6}, {0xba,0x49}, {0xe1,0xd8}, {0x8d,0x79},
    {0xe5,0xac}, {0xbc,0xae}, {0xbe,0xd4}, {0xc0,0xb8}, {0xc2,0x57}, {0xc0,0xb9}, {0xa4,0xe1}, {0x8b,0xfc}, {0xa0,0x76}, {0xca,0xe6},
    {0xcc,0xb2}, {0xa9,0xd1}, {0xa9,0xd0}, {0xa9,0xd2}, {0xab,0xf3}, {0xce,0xd2}, {0xce,0xd3}, {0xd1,0xb0}, {0xae,0xb0}, {0xb1,0xaf},
    {0xb4,0x76}, {0xd9,0x51}, {0xa4,0xe2}, {0x8b,0xcd}, {0xa4,0x7e}, {0xa4,0xe3}, {0xc9,0x7d}, {0xa5,0xb7}, {0xa5,0xb6}, {0xa5,0xb4},
    {0xa5,0xb5}, {0xa6,0xab}, {0xc9,0xe9}, {0xc9,0xeb}, {0xa6,0xaa}, {0xc9,0xe3}, {0xc9,0xe4}, {0xc9,0xea}, {0xc9,0xe6}, {0xc9,0xe8},
    {0xa6,0xa9}, {0xc9,0xe5}, {0xc9,0xec}, {0xc9,0xe7}, {0x9f,0x5a}, {0xa7,0xe1}, {0xa7,0xea}, {0xa7,0xe8}, {0xca,0xf0}, {0xca,0xed},
    {0xca,0xf5}, {0xa7,0xe6}, {0xca,0xf6}, {0xa7,0xdf}, {0xca,0xf3}, {0xa7,0xe5}, {0xca,0xef}, {0xca,0xee}, {0xa7,0xe3}, {0xca,0xf4},
    {0xa7,0xe4}, {0xa9,0xd3}, {0xa7,0xde}, {0xca,0xf1}, {0x9f,0xf4}, {0xca,0xe7}, {0xa7,0xdb}, {0x9f,0xba}, {0xa7,0xee}, {0xca,0xec},
    {0xca,0xf2}, {0xa7,0xe0}, {0xa7,0xe2}, {0xca,0xe8}, {0xca,0xe9}, {0xca,0xea}, {0x8d,0x7a}, {0xa7,0xed}, {0xa7,0xe7}, {0xa7,0xec},
    {0xca,0xeb}, {0xa7,0xeb}, {0xa7,0xdd}, {0xa7,0xdc}, {0xa7,0xe9}, {0x9e,0x45}, {0x93,0xb0}, {0xa0,0x75}, {0xa9,0xe1}, {0xcc,0xbe},
    {0xcc,0xb7}, {0xa9,0xdc}, {0xa9,0xef}, {0xcc,0xb3}, {0xcc,0xba}, {0xcc,0xbc}, {0xcc,0xbf}, {0xa9,0xea}, {0xcc,0xbb}, {0xcc,0xb4},
    {0xa9,0xe8}, {0xcc,0xb8}, {0xcc,0xc0}, {0xa9,0xd9}, {0xcc,0xbd}, {0xa9,0xe3}, {0xa9,0xe2}, {0xcc,0xb6}, {0xa9,0xd7}, {0xa9,0xd8},
    {0x9b,0x46}, {0xa9,0xd6}, {0xfc,0xae}, {0xa9,0xee}, {0xa9,0xe6}, {0xa9,0xe0}, {0xa9,0xd4}, {0xcc,0xb9}, {0xa9,0xdf}, {0xa9,0xd5},
    {0xa9,0xe7}, {0xa9,0xf0}, {0xce,0xd4}, {0xa9,0xe4}, {0xcc,0xb5}, {0xa9,0xda}, {0xa9,0xdd}, {0xa9,0xde}, {0xfc,0xb0}, {0xa9,0xec},
    {0xa9,0xed}, {0xa9,0xeb}, {0xa9,0xe5}, {0xa9,0xe9}, {0xa9,0xdb}, {0xab,0xf4}, {0xfa,0x51}, {0x8d,0x7b}, {0xce,0xda}, {0xac,0x41},
    {0xab,0xf8}, {0xab,0xfa}, {0xac,0x40}, {0xce,0xe6}, {0xab,0xfd}, {0xd1,0xb1}, {0xae,0xb1}, {0xac,0x43}, {0xce,0xd7}, {0xce,0xdf},
    {0xab,0xfe}, {0xce,0xde}, {0xce,0xdb}, {0xce,0xe3}, {0xce,0xe5}, {0xab,0xf7}, {0xab,0xfb}, {0xac,0x42}, {0xae,0xb3}, {0xce,0xe0},
    {0xab,0xf9}, {0xac,0x45}, {0xce,0xd9}, {0xab,0xfc}, {0xae,0xb2}, {0xab,0xf6}, {0xce,0xd6}, {0xce,0xdd}, {0xce,0xd5}, {0xce,0xd8},
    {0xce,0xdc}, {0xd1,0xb2}, {0xac,0x44}, {0xce,0xe1}, {0xce,0xe2}, {0xce,0xe4}, {0xab,0xf5}, {0x8d,0x7c}, {0xae,0xc1}, {0xd1,0xbe},
    {0xae,0xbf}, {0xae,0xc0}, {0xd1,0xb4}, {0xd1,0xc4}, {0x9e,0xd6}, {0xae,0xb6}, {0x93,0xac}, {0xd5,0x66}, {0xd1,0xc6}, {0xd1,0xc0},
    {0x9f,0x5b}, {0xd1,0xb7}, {0x93,0xa9}, {0xd1,0xc9}, {0xd1,0xba}, {0xae,0xbc}, {0xd5,0x7d}, {0xd1,0xbd}, {0xae,0xbe}, {0xae,0xb5},
    {0xd1,0xcb}, {0xd1,0xbf}, {0xae,0xb8}, {0xd1,0xb8}, {0xd1,0xb5}, {0xd1,0xb6}, {0xae,0xb9}, {0xd1,0xc5}, {0xd1,0xcc}, {0xae,0xbb},
    {0xd1,0xbc}, {0xd1,0xbb}, {0xae,0xc3}, {0xae,0xc2}, {0xae,0xb4}, {0xae,0xba}, {0xae,0xbd}, {0xd1,0xc8}, {0xd1,0xc2}, {0xae,0xb7},
    {0xd1,0xb3}, {0xd1,0xca}, {0xd1,0xc1}, {0xd1,0xc3}, {0xd1,0xc7}, {0xa0,0x7c}, {0xd5,0x67}, {0xb1,0xb7}, {0xb1,0xcb}, {0xb1,0xca},
    {0xb1,0xbf}, {0xfc,0xb2}, {0xd5,0x79}, {0xd5,0x75}, {0xd5,0x72}, {0xd5,0xa6}, {0xb1,0xba}, {0xb1,0xb2}, {0xd5,0x77}, {0xb4,0xa8},
    {0xb1,0xb6}, {0xd5,0xa1}, {0x8a,0xc1}, {0xb1,0xcc}, {0xb1,0xc9}, {0xd5,0x7b}, {0xd5,0x6a}, {0x9f,0xb4}, {0xb1,0xc8}, {0xd5,0xa3},
    {0xd5,0x69}, {0xb1,0xbd}, {0xb1,0xc1}, {0xd5,0xa2}, {0xd5,0x73}, {0xb1,0xc2}, {0xb1,0xbc}, {0xd5,0x68}, {0xfc,0xac}, {0xb4,0x78},
    {0xd5,0xa5}, {0xd5,0x71}, {0xb1,0xc7}, {0xd5,0x74}, {0xd5,0xa4}, {0xb1,0xc6}, {0xd9,0x52}, {0xb1,0xb3}, {0xd5,0x6f}, {0xb1,0xb8},
    {0xb1,0xc3}, {0xb1,0xbe}, {0xd5,0x78}, {0xd5,0x6e}, {0xd5,0x6c}, {0xd5,0x7e}, {0xb1,0xb0}, {0xb1,0xc4}, {0xb1,0xb4}, {0xb4,0x77},
    {0xd5,0x7c}, {0xb1,0xb5}, {0xb1,0xb1}, {0xb1,0xc0}, {0xb1,0xbb}, {0xb1,0xb9}, {0xd5,0x70}, {0xb1,0xc5}, {0xd5,0x6d}, {0xd5,0x7a},
    {0xd5,0x76}, {0xd9,0x54}, {0xd9,0x53}, {0x9e,0x4c}, {0xd5,0x6b}, {0xd9,0x64}, {0xb4,0x7a}, {0x8f,0xc5}, {0xd9,0x6a}, {0xd9,0x59},
    {0xd9,0x67}, {0xdd,0x77}, {0xb4,0x7d}, {0xd9,0x6b}, {0xd9,0x6e}, {0xb4,0x7c}, {0xd9,0x5c}, {0xd9,0x6d}, {0xd9,0x6c}, {0xb4,0x7e},
    {0xd9,0x55}, {0xb4,0x79}, {0xb4,0xa3}, {0x93,0xad}, {0xb4,0xa1}, {0xd9,0x69}, {0xd9,0x5f}, {0xb4,0xa5}, {0xd9,0x70}, {0xd9,0x68},
    {0xd9,0x71}, {0xb4,0xad}, {0xb4,0xab}, {0xd9,0x66}, {0xd9,0x65}, {0x9d,0xc3}, {0xd9,0x63}, {0xd9,0x5d}, {0xb4,0xa4}, {0x8d,0xa2},
    {0xb4,0xa2}, {0xd1,0xb9}, {0xd9,0x56}, {0x9d,0x4a}, {0xdd,0xb7}, {0xd9,0x57}, {0xb4,0x7b}, {0xb4,0xaa}, {0xdd,0x79}, {0xb4,0xa6},
    {0xb4,0xa7}, {0xd9,0x58}, {0xd9,0x6f}, {0xdd,0x78}, {0xd9,0x60}, {0xd9,0x5b}, {0xb4,0xa9}, {0xd9,0x61}, {0xd9,0x5e}, {0xfc,0xb6},
    {0xb4,0xae}, {0x8d,0xa3}, {0x9e,0x4b}, {0x9e,0x4d}, {0xb7,0x70}, {0x8d,0xa4}, {0xdd,0x7c}, {0xdd,0xb1}, {0xdd,0xb6}, {0xdd,0xaa},
    {0xb7,0x6c}, {0xdd,0xbb}, {0xb7,0x69}, {0xdd,0x7a}, {0xdd,0x7b}, {0xb7,0x62}, {0xb7,0x6b}, {0xdd,0xa4}, {0xb7,0x6e}, {0xb7,0x6f},
    {0xdd,0xa5}, {0xdd,0xb2}, {0xdd,0xb8}, {0xb7,0x6a}, {0xb7,0x64}, {0xdd,0xa3}, {0xdd,0x7d}, {0xdd,0xba}, {0xdd,0xa8}, {0xdd,0xa9},
    {0xdd,0x7e}, {0xdd,0xb4}, {0xdd,0xab}, {0xdd,0xb5}, {0xdd,0xad}, {0xb7,0x65}, {0xe1,0xd9}, {0xb7,0x68}, {0xb7,0x66}, {0xdd,0xb9},
    {0xdd,0xb0}, {0xdd,0xac}, {0x8a,0xfd}, {0xdd,0xa1}, {0xba,0x53}, {0xdd,0xaf}, {0xb7,0x6d}, {0xdd,0xa7}, {0xfc,0xb5}, {0xdd,0xa6},
    {0xfc,0xc3}, {0x93,0xb2}, {0xb7,0x67}, {0xb7,0x63}, {0xe1,0xee}, {0xdd,0xb3}, {0xdd,0xae}, {0xdd,0xa2}, {0xe1,0xe9}, {0xe1,0xda},
    {0xe1,0xe5}, {0xe1,0xec}, {0xba,0x51}, {0xb4,0xac}, {0xe1,0xea}, {0xba,0x4c}, {0xba,0x4b}, {0xe1,0xf1}, {0x8d,0xa5}, {0xe1,0xdb},
    {0xe1,0xe8}, {0xe1,0xdc}, {0xe1,0xe7}, {0xba,0x4f}, {0xe1,0xeb}, {0xd9,0x62}, {0xe1,0xf2}, {0xe1,0xe3}, {0xba,0x52}, {0xe5,0xba},
    {0xbc,0xaf}, {0xe1,0xf0}, {0xe1,0xef}, {0xba,0x54}, {0xe5,0xad}, {0xbc,0xb0}, {0xe5,0xae}, {0x93,0xa1}, {0xe1,0xdf}, {0xe1,0xe0},
    {0xe1,0xdd}, {0xe1,0xe2}, {0xe1,0xde}, {0xe1,0xf3}, {0xba,0x4e}, {0xbc,0xb1}, {0xba,0x50}, {0xba,0x55}, {0x8a,0xc6}, {0xe1,0xe1},
    {0xe1,0xed}, {0xe1,0xe6}, {0xe5,0xb1}, {0xba,0x4a}, {0xbc,0xb4}, {0xe9,0xaa}, {0xe5,0xb6}, {0xe5,0xb5}, {0xe5,0xb7}, {0x8a,0x5b},
    {0xe5,0xb4}, {0xbc,0xb5}, {0x89,0x4d}, {0xbc,0xbb}, {0xbc,0xb8}, {0xbc,0xb9}, {0xe5,0xaf}, {0xe5,0xb2}, {0xe5,0xbc}, {0xbc,0xc1},
    {0xbc,0xbf}, {0xe5,0xb3}, {0xd9,0x5a}, {0xbc,0xb2}, {0xe5,0xb9}, {0xe5,0xb0}, {0xbc,0xc2}, {0xe5,0xb8}, {0xba,0x4d}, {0xbc,0xb7},
    {0xe1,0xe4}, {0xbc,0xba}, {0xbc,0xbe}, {0xbc,0xc0}, {0xbc,0xbd}, {0xbc,0xbc}, {0xfe,0xd4}, {0xbc,0xb6}, {0xe5,0xbb}, {0xbc,0xb3},
    {0xbc,0xc3}, {0x8a,0x78}, {0x93,0xab}, {0xbe,0xd8}, {0xbe,0xd9}, {0xe9,0xa9}, {0xbe,0xe2}, {0xbe,0xdf}, {0x8d,0xa7}, {0xbe,0xd6},
    {0xbe,0xdd}, {0xe9,0xab}, {0xbe,0xdb}, {0xbe,0xd5}, {0xbe,0xdc}, {0xe9,0xa8}, {0xc0,0xbb}, {0xbe,0xd7}, {0xbe,0xde}, {0xc0,0xba},
    {0xe9,0xa7}, {0xe9,0xa6}, {0xbe,0xe0}, {0x9f,0x45}, {0xbe,0xe1}, {0xe9,0xa5}, {0xe9,0xa4}, {0xc0,0xbc}, {0xe9,0xae}, {0xbe,0xda},
    {0xe9,0xac}, {0x8a,0x56}, {0xc0,0xbd}, {0xfc,0xbf}, {0xc0,0xc2}, {0xec,0xea}, {0xec,0xec}, {0xfc,0xc0}, {0xc0,0xbf}, {0x8e,0xe6},
    {0xec,0xed}, {0xec,0xe9}, {0x8a,0xa4}, {0xec,0xeb}, {0xc0,0xc0}, {0xc0,0xc3}, {0xec,0xe8}, {0xc0,0xbe}, {0xc0,0xc1}, {0xc2,0x59},
    {0xe9,0xad}, {0xc2,0x58}, {0xc2,0x5e}, {0xef,0xd4}, {0xc2,0x5c}, {0xc2,0x5d}, {0xef,0xd7}, {0xef,0xd3}, {0xc2,0x5a}, {0xef,0xd1},
    {0xc3,0x6b}, {0xef,0xd5}, {0xef,0xd6}, {0xef,0xd2}, {0xc2,0x5b}, {0xf2,0x42}, {0xf2,0x45}, {0x89,0x43}, {0xf2,0x46}, {0xf2,0x44},
    {0xf2,0x47}, {0xc3,0x6c}, {0xf2,0x43}, {0x93,0xf3}, {0xf4,0x4e}, {0xc4,0x64}, {0xf4,0x4d}, {0xf4,0x4c}, {0xf4,0x4b}, {0xc4,0x63},
    {0xc4,0x65}, {0xf5,0xcd}, {0xc4,0xe2}, {0xc4,0xe1}, {0xfc,0xab}, {0x9e,0xa2}, {0xf6,0xe1}, {0xf6,0xe0}, {0xf6,0xe3}, {0xc5,0xcb},
    {0xc5,0x75}, {0xf7,0xdd}, {0xf6,0xe2}, {0xf7,0xdc}, {0xc5,0xcd}, {0xc5,0xcc}, {0xc5,0xf3}, {0xf8,0xa9}, {0xf8,0xef}, {0xa4,0xe4},
    {0x9d,0xc7}, {0xd9,0x72}, {0xe9,0xaf}, {0xc6,0xd2}, {0x8b,0xce}, {0xa6,0xac}, {0xca,0xf7}, {0xa7,0xf1}, {0xa7,0xef}, {0xa7,0xf0},
    {0xcc,0xc1}, {0xa9,0xf1}, {0xac,0x46}, {0xce,0xe7}, {0xce,0xe8}, {0xac,0x47}, {0xd1,0xce}, {0xae,0xc4}, {0xae,0xc5}, {0xd1,0xcd},
    {0xfc,0xc5}, {0xb1,0xd3}, {0xb1,0xcf}, {0xd5,0xa7}, {0xb1,0xd6}, {0xb1,0xd5}, {0xb1,0xce}, {0xb1,0xd1}, {0xb1,0xd4}, {0xb1,0xd0},
    {0xd9,0x76}, {0xb1,0xcd}, {0xb4,0xaf}, {0xfc,0xcb}, {0xb4,0xb1}, {0xb4,0xb2}, {0xd9,0x75}, {0xd9,0x78}, {0xb4,0xb0}, {0xd9,0x73},
    {0xd9,0x77}, {0xd9,0x74}, {0x93,0xb3}, {0xb7,0x71}, {0xfc,0xca}, {0xdd,0xbc}, {0xba,0x56}, {0xe1,0xf4}, {0xbe,0xe3}, {0xbc,0xc4},
    {0xe5,0xbd}, {0xbc,0xc5}, {0xbc,0xc6}, {0xe5,0xbf}, {0xe5,0xbe}, {0xe5,0xc0}, {0xe9,0xb1}, {0xe9,0xb0}, {0xec,0xef}, {0xec,0xee},
    {0xc0,0xc4}, {0xc0,0xc5}, {0xf2,0x48}, {0xfc,0xc9}, {0x8d,0xac}, {0xa4,0xe5}, {0xfb,0xc6}, {0x89,0x67}, {0x8c,0x7e}, {0xd9,0x79},
    {0xb4,0xb4}, {0xb4,0xb3}, {0xdd,0xbd}, {0xef,0xd8}, {0xc4,0xe3}, {0xf7,0xde}, {0xa4,0xe6}, {0xae,0xc6}, {0xb1,0xd8}, {0xb1,0xd7},
    {0xd9,0x7a}, {0xd9,0x7b}, {0xb7,0x72}, {0xe1,0xf5}, {0xba,0x57}, {0xe9,0xb2}, {0xa4,0xe7}, {0xa5,0xb8}, {0xa9,0xf2}, {0xcc,0xc2},
    {0xce,0xe9}, {0xac,0x48}, {0xb1,0xd9}, {0xd9,0x7c}, {0xb4,0xb5}, {0xb7,0x73}, {0xe5,0xc1}, {0xe5,0xc2}, {0xfc,0xcd}, {0xec,0xf0},
    {0xc2,0x5f}, {0xf8,0xf0}, {0xa4,0xe8}, {0xcc,0xc3}, {0xa9,0xf3}, {0xac,0x49}, {0x9c,0xf3}, {0xce,0xea}, {0xae,0xc7}, {0xd1,0xd2},
    {0xd1,0xd0}, {0xd1,0xd1}, {0xae,0xc8}, {0xd1,0xcf}, {0xb1,0xdb}, {0xb1,0xdc}, {0xd5,0xa8}, {0xb1,0xdd}, {0xb1,0xda}, {0xd9,0x7d},
    {0xfc,0xd0}, {0xd9,0x7e}, {0xdd,0xbe}, {0x95,0xbb}, {0xba,0x59}, {0xba,0x58}, {0xec,0xf1}, {0xef,0xd9}, {0xf2,0x4a}, {0xf2,0x49},
    {0xf4,0x4f}, {0xfc,0xd3}, {0xc9,0x5e}, {0xac,0x4a}, {0xfc,0xd4}, {0xa4,0xe9}, {0xa5,0xb9}, {0xa6,0xae}, {0xa6,0xad}, {0xa6,0xaf},
    {0xa6,0xb0}, {0xc9,0xee}, {0xc9,0xed}, {0xca,0xf8}, {0xa7,0xf2}, {0xca,0xfb}, {0xca,0xfa}, {0xca,0xf9}, {0xca,0xfc}, {0xa9,0xf4},
    {0xcc,0xc9}, {0xcc,0xc5}, {0xcc,0xce}, {0x8d,0xae}, {0xa9,0xfb}, {0xa9,0xf9}, {0xcc,0xca}, {0xcc,0xc6}, {0xcc,0xcd}, {0xa9,0xf8},
    {0xaa,0x40}, {0xcc,0xc8}, {0xcc,0xc4}, {0xa9,0xfe}, {0xcc,0xcb}, {0xa9,0xf7}, {0xcc,0xcc}, {0xa9,0xfa}, {0xa9,0xfc}, {0xcc,0xd0},
    {0xcc,0xcf}, {0xcc,0xc7}, {0xa9,0xf6}, {0xa9,0xf5}, {0xa9,0xfd}, {0xfc,0xd7}, {0xce,0xef}, {0xce,0xf5}, {0x93,0xdb}, {0xac,0x50},
    {0xac,0x4d}, {0xce,0xec}, {0xce,0xf1}, {0xfe,0x63}, {0xac,0x53}, {0xac,0x4b}, {0xce,0xf0}, {0xac,0x4e}, {0xac,0x51}, {0xce,0xf3},
    {0xac,0x4c}, {0xce,0xf8}, {0xac,0x4f}, {0x93,0xd5}, {0xac,0x52}, {0xce,0xed}, {0xce,0xf2}, {0xce,0xf6}, {0xce,0xee}, {0xce,0xeb},
    {0xce,0xf7}, {0xce,0xf4}, {0xae,0xd0}, {0xae,0xc9}, {0xae,0xcc}, {0xfc,0xda}, {0xae,0xcf}, {0xd1,0xd5}, {0x9b,0x71}, {0xae,0xca},
    {0xd1,0xd3}, {0xfc,0xdd}, {0xae,0xce}, {0xae,0xcb}, {0xd1,0xd6}, {0xae,0xcd}, {0x8d,0xaf}, {0xfa,0xf2}, {0xd5,0xac}, {0xb1,0xdf},
    {0xd5,0xab}, {0xd5,0xad}, {0xb1,0xde}, {0xb1,0xe3}, {0xd1,0xd4}, {0xd5,0xaa}, {0xd5,0xae}, {0x93,0xd8}, {0xb1,0xe0}, {0xd5,0xa9},
    {0xb1,0xe2}, {0xfc,0xdf}, {0xb1,0xe1}, {0xd9,0xa7}, {0x93,0xd3}, {0xd9,0xa2}, {0xb4,0xb6}, {0xb4,0xba}, {0xb4,0xb7}, {0xd9,0xa5},
    {0xd9,0xa8}, {0xfc,0xe1}, {0xb4,0xb8}, {0xb4,0xb9}, {0xb4,0xbe}, {0xdd,0xc7}, {0xd9,0xa6}, {0xb4,0xbc}, {0xd9,0xa3}, {0xd9,0xa1},
    {0x8e,0x76}, {0xb4,0xbd}, {0xd9,0xa4}, {0xb7,0x79}, {0xfc,0x62}, {0xdd,0xbf}, {0xb7,0x76}, {0xb7,0x77}, {0xb7,0x75}, {0xdd,0xc4},
    {0xdd,0xc3}, {0xdd,0xc0}, {0xb7,0x7b}, {0x93,0xd1}, {0xdd,0xc2}, {0xb4,0xbb}, {0x8d,0xb1}, {0xdd,0xc6}, {0xdd,0xc1}, {0xb7,0x78},
    {0xb7,0x74}, {0xb7,0x7a}, {0xdd,0xc5}, {0x98,0x59}, {0xba,0x5c}, {0xe1,0xf8}, {0xe1,0xf7}, {0xe1,0xf6}, {0xba,0x5a}, {0xfb,0x52},
    {0xba,0x5b}, {0xe5,0xc5}, {0xe5,0xc8}, {0xbc,0xc8}, {0xfb,0x53}, {0xbc,0xc7}, {0xe5,0xc9}, {0xe5,0xc4}, {0xbc,0xca}, {0xe5,0xc6},
    {0xfb,0x4d}, {0xbc,0xc9}, {0xe5,0xc3}, {0x9c,0xbf}, {0xe5,0xc7}, {0xbe,0xe9}, {0xbe,0xe6}, {0xe9,0xbb}, {0xe9,0xba}, {0xe9,0xb9},
    {0xe9,0xb4}, {0x9b,0x72}, {0xe9,0xb5}, {0xbe,0xe7}, {0xbe,0xe4}, {0xbe,0xe8}, {0xe9,0xb3}, {0xbe,0xe5}, {0xe9,0xb6}, {0xe9,0xb7},
    {0xe9,0xbc}, {0xfb,0x50}, {0x93,0xbe}, {0xe9,0xb8}, {0xec,0xf2}, {0xc0,0xc7}, {0xef,0xdc}, {0xc0,0xc6}, {0xef,0xda}, {0xef,0xdb},
    {0xc2,0x60}, {0xc3,0x6e}, {0xf2,0x4b}, {0xc3,0x6d}, {0xf4,0x51}, {0xf4,0x52}, {0xc4,0x66}, {0xf4,0x50}, {0xc4,0xe4}, {0xf7,0xdf},
    {0xc5,0xce}, {0xf8,0xaa}, {0xf8,0xab}, {0xa4,0xea}, {0x9d,0xf1}, {0xa6,0xb1}, {0xa6,0xb2}, {0xa7,0xf3}, {0xcc,0xd1}, {0xac,0x54},
    {0xae,0xd1}, {0xb1,0xe4}, {0xb0,0xd2}, {0xb4,0xbf}, {0xb4,0xc0}, {0xb3,0xcc}, {0xd9,0xa9}, {0xfc,0xeb}, {0xb7,0x7c}, {0xe1,0xfa},
    {0xe1,0xf9}, {0xa4,0xeb}, {0xa6,0xb3}, {0xcc,0xd2}, {0xaa,0x42}, {0xa0,0xbb}, {0xaa,0x41}, {0x9b,0x7e}, {0xce,0xf9}, {0xce,0xfa},
    {0xd1,0xd7}, {0xd1,0xd8}, {0xae,0xd2}, {0xae,0xd3}, {0x8d,0xb3}, {0xae,0xd4}, {0xd5,0xaf}, {0x8c,0x52}, {0xb1,0xe6}, {0xb4,0xc2},
    {0x9a,0xe8}, {0xb4,0xc1}, {0xdd,0xc8}, {0xdf,0x7a}, {0xe1,0xfb}, {0xe9,0xbd}, {0x8e,0xdc}, {0xc2,0x61}, {0xc4,0x67}, {0xa4,0xec},
    {0xa5,0xbc}, {0xa5,0xbd}, {0xa5,0xbb}, {0xa5,0xbe}, {0xa5,0xba}, {0xa6,0xb6}, {0xc9,0xf6}, {0xa6,0xb5}, {0xa6,0xb7}, {0x9c,0xf9},
    {0xc9,0xf1}, {0xc9,0xf0}, {0xc9,0xf3}, {0xc9,0xf2}, {0xc9,0xf5}, {0xa6,0xb4}, {0xc9,0xef}, {0xc9,0xf4}, {0xfa,0x50}, {0xca,0xfd},
    {0xa7,0xfd}, {0xca,0xfe}, {0xcb,0x43}, {0xa7,0xfc}, {0xcb,0x47}, {0xcb,0x42}, {0xcb,0x45}, {0xa7,0xf5}, {0xa7,0xf6}, {0xa7,0xf7},
    {0xa7,0xf8}, {0xa8,0x40}, {0xcb,0x41}, {0xa7,0xfa}, {0xa8,0x41}, {0xcb,0x40}, {0xcb,0x46}, {0xa7,0xf9}, {0xcb,0x44}, {0xa7,0xfb},
    {0xa7,0xf4}, {0xa7,0xfe}, {0x98,0xe7}, {0xfc,0xf3}, {0xfc,0xf2}, {0xaa,0x57}, {0x8c,0xca}, {0xcc,0xd4}, {0xaa,0x43}, {0xaa,0x4d},
    {0xaa,0x4e}, {0xaa,0x46}, {0xaa,0x58}, {0xaa,0x48}, {0xcc,0xdc}, {0xaa,0x53}, {0xcc,0xd7}, {0xaa,0x49}, {0xcc,0xe6}, {0xcc,0xe7},
    {0xcc,0xdf}, {0xcc,0xd8}, {0xaa,0x56}, {0xcc,0xe4}, {0xaa,0x51}, {0xaa,0x4f}, {0xcc,0xe5}, {0xcc,0xe3}, {0xcc,0xdb}, {0xcc,0xd3},
    {0xcc,0xda}, {0xaa,0x4a}, {0xaa,0x50}, {0xaa,0x44}, {0xcc,0xde}, {0xcc,0xdd}, {0xcc,0xd5}, {0x93,0xe5}, {0xaa,0x52}, {0xcc,0xe1},
    {0xcc,0xd6}, {0xaa,0x55}, {0xcc,0xe8}, {0xaa,0x45}, {0xaa,0x4c}, {0xcc,0xd9}, {0xcc,0xe2}, {0xaa,0x54}, {0xaa,0x47}, {0xaa,0x4b},
    {0xcc,0xe0}, {0x9a,0x59}, {0x8d,0xb5}, {0xfd,0x4d}, {0xcf,0x5b}, {0xac,0x5c}, {0xac,0x69}, {0xfd,0x5e}, {0xcf,0x56}, {0xcf,0x4c},
    {0xac,0x62}, {0xcf,0x4a}, {0xac,0x5b}, {0xcf,0x45}, {0xac,0x65}, {0xcf,0x52}, {0xce,0xfe}, {0xcf,0x41}, {0x8f,0x7d}, {0xcf,0x44},
    {0xce,0xfb}, {0xcf,0x51}, {0xcf,0x61}, {0xac,0x60}, {0xcf,0x46}, {0xcf,0x58}, {0xce,0xfd}, {0xcf,0x5f}, {0xcf,0x60}, {0xcf,0x63},
    {0xcf,0x5a}, {0xcf,0x4b}, {0xcf,0x53}, {0xac,0x66}, {0xac,0x59}, {0xac,0x61}, {0xac,0x6d}, {0xac,0x56}, {0xac,0x58}, {0x95,0x47},
    {0xfc,0xf6}, {0xcf,0x43}, {0xac,0x6a}, {0xac,0x63}, {0xcf,0x5d}, {0xcf,0x40}, {0xac,0x6c}, {0xac,0x67}, {0xcf,0x49}, {0xac,0x6b},
    {0xcf,0x50}, {0xcf,0x48}, {0xac,0x64}, {0xcf,0x5c}, {0xcf,0x54}, {0xac,0x5e}, {0xcf,0x62}, {0xcf,0x47}, {0xac,0x5a}, {0xcf,0x59},
    {0xcf,0x4f}, {0xac,0x5f}, {0xcf,0x55}, {0xac,0x57}, {0xce,0xfc}, {0xac,0x68}, {0xae,0xe3}, {0xac,0x5d}, {0xcf,0x4e}, {0xcf,0x4d},
    {0xcf,0x42}, {0x92,0x50}, {0xcf,0x5e}, {0xcf,0x57}, {0x89,0x68}, {0xac,0x55}, {0x8d,0xb6}, {0xfc,0xfb}, {0xa0,0x7d}, {0x98,0xfc},
    {0x89,0x69}, {0xfe,0x4f}, {0x92,0x56}, {0xd1,0xec}, {0xae,0xea}, {0xd1,0xed}, {0xd1,0xe1}, {0xae,0xdf}, {0xae,0xeb}, {0xd1,0xda},
    {0xfa,0xc9}, {0xd1,0xe3}, {0xd1,0xeb}, {0x93,0xe8}, {0xd1,0xd9}, {0xd1,0xf4}, {0xae,0xd5}, {0xfc,0xf8}, {0xd1,0xf3}, {0xd1,0xee},
    {0xd1,0xef}, {0xae,0xdd}, {0xae,0xe8}, {0xd1,0xe5}, {0xd1,0xe6}, {0xd1,0xf0}, {0xd1,0xe7}, {0xd1,0xe2}, {0xd1,0xdc}, {0xd1,0xdd},
    {0xd1,0xea}, {0xd1,0xe4}, {0x9c,0xe3}, {0xfd,0xa9}, {0xae,0xd6}, {0xae,0xda}, {0xd1,0xf2}, {0xd1,0xde}, {0xae,0xe6}, {0xae,0xe2},
    {0xfc,0x44}, {0xae,0xe5}, {0xae,0xec}, {0xae,0xdb}, {0xae,0xe7}, {0xd1,0xe9}, {0xae,0xe9}, {0xae,0xd8}, {0x96,0x40}, {0xae,0xd7},
    {0xd1,0xdb}, {0x8d,0xb8}, {0xd1,0xdf}, {0xae,0xe0}, {0xd1,0xf1}, {0xd1,0xe8}, {0xd1,0xe0}, {0xae,0xe4}, {0xae,0xe1}, {0xae,0xd9},
    {0xae,0xdc}, {0x9b,0x4a}, {0x8f,0xb9}, {0xfc,0xfe}, {0x89,0x6a}, {0xd5,0xc4}, {0xd5,0xb4}, {0xd5,0xb5}, {0xd5,0xb9}, {0xd5,0xc8},
    {0xd5,0xc5}, {0xd5,0xbe}, {0xd5,0xbd}, {0xb1,0xed}, {0xd5,0xc1}, {0xd5,0xd0}, {0xd5,0xb0}, {0xd5,0xd1}, {0xd5,0xc3}, {0xd5,0xd5},
    {0xd5,0xc9}, {0xb1,0xec}, {0xd5,0xc7}, {0xb1,0xe7}, {0xb1,0xfc}, {0xb1,0xf2}, {0x8d,0xb9}, {0xb1,0xf6}, {0xb1,0xf5}, {0xd5,0xb1},
    {0x91,0x7e}, {0xd5,0xce}, {0xd5,0xd4}, {0xd5,0xcc}, {0xd5,0xd3}, {0xd5,0xc0}, {0xd5,0xb2}, {0xd5,0xd2}, {0xd5,0xc2}, {0xb1,0xea},
    {0xb1,0xf7}, {0xd5,0xcb}, {0xb1,0xf0}, {0x93,0xf4}, {0xd5,0xca}, {0xd5,0xb3}, {0xb1,0xf8}, {0xb1,0xfa}, {0xd5,0xcd}, {0xb1,0xfb},
    {0xb1,0xe9}, {0xd5,0xba}, {0xd5,0xcf}, {0xfb,0x7c}, {0xb1,0xef}, {0xb1,0xf9}, {0xd5,0xbc}, {0xd5,0xc6}, {0xd5,0xb7}, {0xd5,0xbb},
    {0xb1,0xf4}, {0xd5,0xb6}, {0xb1,0xe8}, {0xb1,0xf1}, {0xb1,0xee}, {0xd5,0xbf}, {0xae,0xde}, {0xd9,0xc0}, {0xb1,0xeb}, {0x93,0xe7},
    {0x97,0xef}, {0xfe,0x4a}, {0xfd,0x45}, {0xb1,0xf3}, {0x96,0xa5}, {0xd9,0xc3}, {0xd9,0xd9}, {0xd9,0xce}, {0xb4,0xd6}, {0xfe,0xe0},
    {0xb4,0xd1}, {0xd9,0xbd}, {0xb4,0xd2}, {0xd9,0xcd}, {0xd9,0xc6}, {0xd9,0xd3}, {0xb4,0xce}, {0xd9,0xab}, {0xd9,0xd5}, {0xb4,0xc4},
    {0xd9,0xb3}, {0xb4,0xc7}, {0xb4,0xc6}, {0xb4,0xd7}, {0xd9,0xad}, {0xd9,0xcf}, {0xd9,0xd0}, {0xb4,0xc9}, {0xb4,0xc5}, {0xd9,0xbb},
    {0xb4,0xd0}, {0xd9,0xb6}, {0xd9,0xd1}, {0xb4,0xcc}, {0xd9,0xc9}, {0xd9,0xd6}, {0xd9,0xb0}, {0xd9,0xb5}, {0xd9,0xaf}, {0xb4,0xcb},
    {0xd9,0xc2}, {0xdd,0xde}, {0xd9,0xb1}, {0xb4,0xcf}, {0xd9,0xba}, {0xd9,0xd2}, {0xb4,0xca}, {0xd9,0xb7}, {0xd9,0xb4}, {0xd9,0xc5},
    {0xb4,0xcd}, {0xb4,0xc3}, {0xb4,0xd9}, {0xd9,0xc8}, {0xd9,0xc7}, {0xfd,0x48}, {0xfd,0x47}, {0xfe,0xf2}, {0xfe,0x6a}, {0xd9,0xac},
    {0xb4,0xc8}, {0xd9,0xd4}, {0xd9,0xbc}, {0xd9,0xbe}, {0x8d,0xbd}, {0xd9,0xcb}, {0xd9,0xca}, {0xd9,0xaa}, {0xb4,0xd3}, {0xb4,0xd5},
    {0xd9,0xb2}, {0xd9,0xb9}, {0xd9,0xc1}, {0xb4,0xd4}, {0xd9,0xb8}, {0xd9,0xc4}, {0xd9,0xd7}, {0xd9,0xcc}, {0x9b,0xa1}, {0x8c,0xa2},
    {0x9a,0xb7}, {0x8e,0xfc}, {0xd9,0xd8}, {0xd9,0xae}, {0x9f,0xa1}, {0xdd,0xf2}, {0xb7,0xa6}, {0xdd,0xf0}, {0xdd,0xdb}, {0xdd,0xe0},
    {0xdd,0xd9}, {0xfd,0x51}, {0xdd,0xec}, {0xdd,0xcb}, {0xdd,0xd2}, {0xdd,0xea}, {0xdd,0xf4}, {0xdd,0xdc}, {0xfa,0xad}, {0xdd,0xcf},
    {0xdd,0xe2}, {0xdd,0xe7}, {0xdd,0xd3}, {0x8d,0xbe}, {0xdd,0xe4}, {0xdd,0xd0}, {0x89,0xa4}, {0xdd,0xd7}, {0xdd,0xd8}, {0xb7,0xa8},
    {0xdd,0xeb}, {0xdd,0xe9}, {0xdd,0xcc}, {0xdd,0xee}, {0xdd,0xef}, {0xdd,0xf1}, {0xb7,0xac}, {0xb7,0xa4}, {0x9a,0xd9}, {0xd5,0xb8},
    {0xdd,0xd4}, {0xdd,0xe6}, {0xdd,0xd5}, {0xb7,0xa1}, {0xb7,0xb1}, {0xdd,0xed}, {0xb7,0xaf}, {0xb7,0xab}, {0xdd,0xca}, {0xb7,0xa3},
    {0xfd,0x4e}, {0xdd,0xcd}, {0xb7,0xb0}, {0x8d,0xc0}, {0xdd,0xdd}, {0xdd,0xc9}, {0x97,0xf0}, {0xb7,0xa9}, {0xdd,0xe1}, {0xdd,0xd1},
    {0xb7,0xaa}, {0xdd,0xda}, {0xb7,0x7e}, {0xb4,0xd8}, {0xdd,0xe3}, {0xd9,0xbf}, {0xdd,0xce}, {0x93,0xb4}, {0xfd,0x44}, {0xdd,0xe8},
    {0xb7,0xa5}, {0xdd,0xe5}, {0xb7,0xa2}, {0xdd,0xdf}, {0xb7,0xad}, {0xdd,0xd6}, {0xdd,0xf3}, {0x9f,0xa7}, {0xb7,0xa7}, {0xde,0xc6},
    {0x8d,0xc2}, {0xb7,0xae}, {0x99,0xb6}, {0xe2,0x4a}, {0xe2,0x48}, {0xe2,0x5e}, {0xe2,0x46}, {0xe2,0x58}, {0xb7,0x7d}, {0xba,0x5f},
    {0xe2,0x42}, {0xe2,0x5d}, {0xfd,0x52}, {0xe2,0x47}, {0xe2,0x55}, {0xba,0x64}, {0xba,0x5d}, {0xe2,0x5b}, {0x8d,0xc1}, {0xe2,0x40},
    {0xe2,0x5a}, {0x8e,0x46}, {0xba,0x6f}, {0xe2,0x51}, {0xe2,0x61}, {0xba,0x6d}, {0xe2,0x49}, {0xba,0x5e}, {0xe2,0x4b}, {0xe2,0x59},
    {0xba,0x67}, {0xe2,0x44}, {0xba,0x6b}, {0xba,0x61}, {0xe2,0x4d}, {0xe2,0x43}, {0xe1,0xfc}, {0xa0,0xd1}, {0xe2,0x57}, {0xba,0x68},
    {0xe2,0x60}, {0xe1,0xfd}, {0xba,0x65}, {0xe2,0x53}, {0xba,0x66}, {0xe2,0x45}, {0xe2,0x50}, {0xe2,0x4c}, {0xe2,0x4e}, {0x9f,0xca},
    {0xba,0x60}, {0xe2,0x5f}, {0xba,0x6e}, {0xe2,0x4f}, {0xe2,0x62}, {0xe1,0xfe}, {0xe2,0x54}, {0xba,0x63}, {0xba,0x6c}, {0xba,0x6a},
    {0xe2,0x41}, {0xe2,0x56}, {0xba,0x69}, {0x92,0xcf}, {0xba,0x62}, {0xe2,0x52}, {0x9c,0xf4}, {0x8d,0xc4}, {0xe2,0x5c}, {0xfd,0x41},
    {0xe5,0xd5}, {0xe5,0xd1}, {0xe5,0xcd}, {0xe5,0xe1}, {0xe5,0xde}, {0xbc,0xcd}, {0x9b,0x4c}, {0xe5,0xe5}, {0xe5,0xd4}, {0xbc,0xd8},
    {0xe5,0xdb}, {0xe5,0xd0}, {0xe5,0xda}, {0xbc,0xd5}, {0xe5,0xee}, {0xe5,0xeb}, {0xe5,0xdd}, {0xe5,0xce}, {0xfd,0x57}, {0xfc,0xef},
    {0xe5,0xe2}, {0xe5,0xe4}, {0xbc,0xd1}, {0xe5,0xd8}, {0xe5,0xd3}, {0xe5,0xca}, {0xbc,0xce}, {0xbc,0xd6}, {0x9c,0xde}, {0xe5,0xe7},
    {0xbc,0xd7}, {0xe5,0xcb}, {0xe5,0xed}, {0xe5,0xe0}, {0xe5,0xe6}, {0xbc,0xd4}, {0xfd,0x42}, {0x98,0x6c}, {0xe5,0xe3}, {0xe5,0xea},
    {0xbc,0xd9}, {0xbc,0xd3}, {0xe5,0xdc}, {0xe5,0xcf}, {0xe5,0xef}, {0xe5,0xcc}, {0xe5,0xe8}, {0xbc,0xd0}, {0x97,0xf9}, {0xe5,0xd6},
    {0x95,0x58}, {0xe5,0xd7}, {0xbc,0xcf}, {0xbc,0xcc}, {0xe5,0xd2}, {0xbc,0xd2}, {0xbc,0xcb}, {0xe5,0xe9}, {0xe5,0xec}, {0xe5,0xd9},
    {0xe9,0xca}, {0x98,0x5e}, {0xfe,0x7b}, {0x94,0xcd}, {0xe9,0xc2}, {0x93,0xee}, {0xe9,0xbe}, {0xbe,0xf6}, {0xbe,0xeb}, {0xbe,0xf0},
    {0xbe,0xec}, {0xe9,0xcc}, {0xe9,0xd7}, {0xbe,0xea}, {0xe9,0xc4}, {0xe9,0xcd}, {0xe5,0xdf}, {0xe9,0xce}, {0x8c,0xa3}, {0xbe,0xf1},
    {0xfd,0x5a}, {0xe9,0xdd}, {0xbe,0xf5}, {0xbe,0xf8}, {0xe9,0xc0}, {0xbe,0xf4}, {0x93,0xf5}, {0xe9,0xdb}, {0xe9,0xdc}, {0xe9,0xd2},
    {0xe9,0xd1}, {0xe9,0xc9}, {0x93,0xef}, {0x8e,0xea}, {0xe9,0xd3}, {0xe9,0xda}, {0xe9,0xd9}, {0x8f,0x5b}, {0xbe,0xef}, {0xbe,0xed},
    {0xe9,0xcb}, {0xe9,0xc8}, {0xe9,0xc5}, {0xe9,0xd8}, {0xbe,0xf7}, {0xe9,0xd6}, {0xbe,0xf3}, {0xbe,0xf2}, {0x8c,0x5e}, {0xe9,0xd0},
    {0x8d,0xc6}, {0xe9,0xbf}, {0xe9,0xc1}, {0xe9,0xc3}, {0xe9,0xd5}, {0xe9,0xcf}, {0xbe,0xee}, {0xe9,0xc6}, {0xe9,0xd4}, {0x8d,0xc8},
    {0x8d,0xc7}, {0xe9,0xc7}, {0x93,0xf7}, {0xc0,0xcf}, {0xed,0x45}, {0xc0,0xc8}, {0xec,0xf5}, {0x8d,0xc9}, {0xed,0x41}, {0xc0,0xca},
    {0xed,0x48}, {0xec,0xfc}, {0xec,0xf7}, {0xfb,0xf2}, {0xed,0x49}, {0xec,0xf3}, {0xec,0xfe}, {0x96,0x70}, {0xc0,0xd1}, {0xed,0x44},
    {0xed,0x4a}, {0xec,0xfd}, {0xc0,0xc9}, {0xed,0x40}, {0xec,0xf4}, {0xc0,0xd0}, {0x8d,0xcb}, {0xed,0x47}, {0xec,0xf9}, {0xc0,0xcc},
    {0xfd,0x5c}, {0xec,0xfb}, {0xec,0xf8}, {0xc0,0xd2}, {0xec,0xfa}, {0xc0,0xcb}, {0xc0,0xce}, {0xed,0x43}, {0xec,0xf6}, {0xed,0x46},
    {0x8f,0x65}, {0xed,0x42}, {0x8d,0xcd}, {0xc2,0x63}, {0xef,0xe7}, {0xc2,0x68}, {0xc2,0x69}, {0x9d,0xa8}, {0x94,0xf9}, {0xc2,0x62},
    {0xef,0xe6}, {0x8d,0xce}, {0xef,0xe3}, {0xef,0xe4}, {0xc2,0x66}, {0xef,0xde}, {0xef,0xe2}, {0xc2,0x65}, {0xef,0xdf}, {0x93,0xea},
    {0xc2,0x67}, {0xc2,0x64}, {0xef,0xdd}, {0xef,0xe1}, {0xef,0xe5}, {0xfd,0x5f}, {0x93,0xf0}, {0x9f,0xb6}, {0xf2,0x51}, {0xf2,0x4e},
    {0xf2,0x57}, {0xf2,0x56}, {0xf2,0x54}, {0xf2,0x4f}, {0xc3,0x72}, {0x8d,0xcf}, {0x97,0x63}, {0xf2,0x50}, {0xc3,0x71}, {0xc0,0xcd},
    {0xf2,0x53}, {0xc3,0x70}, {0xf2,0x58}, {0xf2,0x52}, {0xf2,0x4d}, {0xef,0xe0}, {0xc3,0x6f}, {0xf2,0x4c}, {0xf4,0x56}, {0xf4,0x55},
    {0xf2,0x55}, {0xc4,0x68}, {0xf4,0x59}, {0xf4,0x5a}, {0xf4,0x54}, {0xf4,0x58}, {0xf4,0x53}, {0x8d,0xd0}, {0xf5,0xd1}, {0xf4,0x57},
    {0xc4,0xe7}, {0xc4,0xe5}, {0xf5,0xcf}, {0xf5,0xd2}, {0xf5,0xce}, {0xf5,0xd0}, {0xc4,0xe6}, {0x93,0xf1}, {0xf6,0xe5}, {0xf6,0xe6},
    {0xc5,0x76}, {0xf6,0xe4}, {0xf7,0xe2}, {0xc5,0xcf}, {0xf7,0xe0}, {0xf7,0xe1}, {0xf8,0xac}, {0xc6,0x56}, {0xf8,0xf3}, {0xf8,0xf1},
    {0xf8,0xf2}, {0xf8,0xf4}, {0xfd,0x62}, {0xf9,0xbb}, {0xa4,0xed}, {0xa6,0xb8}, {0xaa,0x59}, {0xcc,0xe9}, {0xcf,0x64}, {0xd1,0xf5},
    {0xd1,0xf7}, {0xd1,0xf6}, {0xd1,0xf8}, {0xb1,0xfd}, {0xd5,0xd7}, {0xd1,0xf9}, {0xfd,0x65}, {0xd5,0xd6}, {0xd5,0xd8}, {0xd5,0xd9},
    {0xd9,0xda}, {0xb4,0xdb}, {0xd9,0xdb}, {0xd9,0xdd}, {0xb4,0xdc}, {0xb4,0xda}, {0xd9,0xdc}, {0xdd,0xfa}, {0xdd,0xf8}, {0xdd,0xf7},
    {0xdd,0xf6}, {0xdd,0xf5}, {0xb7,0xb2}, {0xdd,0xf9}, {0xba,0x70}, {0xe2,0x63}, {0xe2,0x65}, {0xba,0x71}, {0xe2,0x64}, {0xbc,0xdb},
    {0xbc,0xda}, {0xe5,0xf0}, {0x9f,0xdb}, {0xe9,0xdf}, {0xe9,0xde}, {0xe9,0xe0}, {0x93,0xf8}, {0xbe,0xf9}, {0xed,0x4b}, {0xc0,0xd3},
    {0xef,0xe8}, {0xc2,0x6a}, {0xf2,0x59}, {0xc5,0x77}, {0xa4,0xee}, {0xa5,0xbf}, {0xa6,0xb9}, {0xa8,0x42}, {0xaa,0x5a}, {0xaa,0x5b},
    {0xac,0x6e}, {0xd1,0xfa}, {0x8b,0xf7}, {0xb7,0xb3}, {0xfd,0x66}, {0xe6,0xd1}, {0xbe,0xfa}, {0xc2,0x6b}, {0xa4,0xef}, {0x8b,0xcf},
    {0xa6,0xba}, {0xcc,0xeb}, {0xaa,0x5c}, {0xcc,0xea}, {0x8d,0xd1}, {0xcf,0x65}, {0xac,0x6f}, {0xcf,0x66}, {0xac,0x70}, {0xd1,0xfc},
    {0xae,0xee}, {0xae,0xed}, {0xd5,0xde}, {0xd5,0xdc}, {0xd5,0xdd}, {0xd5,0xdb}, {0xd5,0xda}, {0xd9,0xde}, {0xd9,0xe1}, {0xb4,0xde},
    {0xd9,0xdf}, {0xb4,0xdd}, {0xd9,0xe0}, {0xdd,0xfb}, {0xe2,0x66}, {0xe2,0x67}, {0xe2,0x68}, {0xe5,0xf3}, {0xe5,0xf2}, {0xbc,0xdc},
    {0xe5,0xf1}, {0xe5,0xf4}, {0xe9,0xe1}, {0xe9,0xe2}, {0xe9,0xe3}, {0xed,0x4c}, {0xc0,0xd4}, {0xc2,0x6c}, {0xf2,0x5a}, {0xc4,0xe8},
    {0xc9,0x5f}, {0xac,0x71}, {0xcf,0x67}, {0xae,0xef}, {0xb1,0xfe}, {0xb4,0xdf}, {0xd9,0xe2}, {0xb7,0xb5}, {0xb7,0xb4}, {0x8d,0xd2},
    {0xe2,0x69}, {0xe2,0x6a}, {0xbc,0xdd}, {0xbc,0xde}, {0xe9,0xe5}, {0xe9,0xe4}, {0xef,0xe9}, {0xf7,0xe3}, {0xa4,0xf0}, {0xc9,0x60},
    {0xa5,0xc0}, {0xa8,0x43}, {0xcb,0x48}, {0xac,0x72}, {0xb7,0xb6}, {0xa4,0xf1}, {0xcf,0x68}, {0xac,0x73}, {0xcf,0x69}, {0xc0,0xd5},
    {0xa4,0xf2}, {0xfd,0x71}, {0xcc,0xec}, {0xcf,0x6a}, {0xfd,0x6f}, {0xd2,0x42}, {0xd2,0x41}, {0xd1,0xfe}, {0xd1,0xfd}, {0xd2,0x43},
    {0xd2,0x40}, {0x8d,0xd3}, {0xb2,0x40}, {0xb2,0x41}, {0xb4,0xe0}, {0xd9,0xe3}, {0xd9,0xe4}, {0xd9,0xe5}, {0xde,0x41}, {0xde,0x42},
    {0xde,0x40}, {0x9f,0xe7}, {0xdd,0xfd}, {0xdd,0xfe}, {0xb7,0xb7}, {0xe2,0x6b}, {0xe5,0xf7}, {0xe5,0xf6}, {0xe5,0xf5}, {0xe5,0xf8},
    {0xe9,0xe7}, {0xe9,0xe6}, {0xbe,0xfb}, {0xe9,0xe8}, {0xc0,0xd6}, {0xed,0x4d}, {0xef,0xea}, {0xf2,0x5b}, {0xf6,0xe7}, {0xa4,0xf3},
    {0xa5,0xc2}, {0xa5,0xc1}, {0xaa,0x5d}, {0xc9,0x61}, {0xc9,0x7e}, {0xa6,0xbb}, {0xc9,0xf7}, {0xcb,0x49}, {0xcb,0x4a}, {0xaa,0x5e},
    {0x90,0xbd}, {0xcc,0xed}, {0xac,0x74}, {0xcf,0x6b}, {0xcf,0x6c}, {0xae,0xf0}, {0xae,0xf4}, {0xd2,0x44}, {0xae,0xf3}, {0xae,0xf1},
    {0xae,0xf2}, {0xd5,0xdf}, {0xb2,0x42}, {0xb4,0xe3}, {0xb4,0xe1}, {0xb4,0xe2}, {0xd9,0xe6}, {0x9f,0xd0}, {0xba,0x72}, {0xa4,0xf4},
    {0x8b,0xd0}, {0xc9,0xa1}, {0xfd,0x72}, {0xa5,0xc3}, {0x9c,0xae}, {0x8b,0xd1}, {0xc9,0xa4}, {0x8a,0xdb}, {0xa5,0xc6}, {0xc9,0xa3},
    {0xa5,0xc5}, {0xa5,0xc4}, {0xa8,0x44}, {0xc9,0xa2}, {0xc9,0xf8}, {0xfa,0xe4}, {0xc9,0xfc}, {0xc9,0xfe}, {0xca,0x40}, {0xa6,0xc5},
    {0xa6,0xc6}, {0xc9,0xfb}, {0xa6,0xc1}, {0xc9,0xf9}, {0xc9,0xfd}, {0xa6,0xc2}, {0xa6,0xbd}, {0x95,0xce}, {0xa6,0xbe}, {0xfd,0x76},
    {0xa6,0xc4}, {0xc9,0xfa}, {0xa6,0xbc}, {0xa8,0x45}, {0xa6,0xbf}, {0xa6,0xc0}, {0xa6,0xc3}, {0xcb,0x5b}, {0xcb,0x59}, {0xcb,0x4c},
    {0xa8,0x51}, {0xcb,0x53}, {0xa8,0x4c}, {0xcb,0x4d}, {0xcb,0x55}, {0xfb,0x62}, {0xcb,0x52}, {0xa8,0x4f}, {0xcb,0x51}, {0xa8,0x56},
    {0xcb,0x5a}, {0xa8,0x58}, {0x8d,0xd4}, {0xa8,0x5a}, {0xcb,0x4b}, {0xfd,0x78}, {0xa8,0x4d}, {0xcb,0x5c}, {0xa8,0x54}, {0xa8,0x57},
    {0x8e,0xe3}, {0xcd,0x45}, {0xa8,0x47}, {0xa8,0x5e}, {0xa8,0x55}, {0xcb,0x4e}, {0xa8,0x4a}, {0xa8,0x59}, {0xcb,0x56}, {0xa8,0x48},
    {0xa8,0x49}, {0xcd,0x43}, {0xcb,0x4f}, {0xa8,0x50}, {0xa8,0x5b}, {0xcb,0x5d}, {0xcb,0x50}, {0xa8,0x4e}, {0xa8,0x53}, {0xcc,0xee},
    {0xa8,0x5c}, {0xcb,0x57}, {0xa8,0x52}, {0xa8,0x5d}, {0xa8,0x46}, {0xcb,0x54}, {0xa8,0x4b}, {0xcb,0x58}, {0xcd,0x44}, {0x90,0x76},
    {0x98,0xc6}, {0x8d,0xd5}, {0xaa,0x6a}, {0xaa,0x7a}, {0xcc,0xf5}, {0xaa,0x71}, {0x97,0xd1}, {0xcd,0x4b}, {0xaa,0x62}, {0x9e,0xb6},
    {0xaa,0x65}, {0xcd,0x42}, {0xcc,0xf3}, {0xcc,0xf7}, {0xaa,0x6d}, {0xaa,0x6f}, {0xcc,0xfa}, {0xaa,0x76}, {0xaa,0x68}, {0xaa,0x66},
    {0xaa,0x67}, {0xaa,0x75}, {0xcd,0x47}, {0xaa,0x70}, {0xcc,0xf9}, {0xcc,0xfb}, {0xaa,0x6e}, {0xaa,0x73}, {0xcc,0xfc}, {0xcd,0x4a},
    {0xac,0x75}, {0xaa,0x79}, {0xfa,0xc7}, {0xaa,0x63}, {0xcd,0x49}, {0xa0,0x42}, {0xcd,0x4d}, {0xcc,0xf8}, {0xcd,0x4f}, {0xcd,0x40},
    {0xaa,0x6c}, {0xcc,0xf4}, {0xaa,0x6b}, {0xaa,0x7d}, {0xaa,0x72}, {0xcc,0xf2}, {0xcf,0x75}, {0xaa,0x78}, {0xaa,0x7c}, {0xcd,0x41},
    {0xcd,0x46}, {0x98,0x73}, {0xaa,0x7e}, {0xaa,0x77}, {0xaa,0x69}, {0xaa,0x5f}, {0xaa,0x64}, {0xcc,0xf6}, {0xaa,0x60}, {0xcd,0x4e},
    {0x9f,0xfc}, {0xcc,0xf0}, {0xcc,0xef}, {0xcc,0xfd}, {0xcc,0xf1}, {0xaa,0x7b}, {0xae,0xf5}, {0xaa,0x74}, {0xcc,0xfe}, {0xaa,0x61},
    {0xac,0xa6}, {0xcd,0x4c}, {0x8c,0xa5}, {0xcf,0x7c}, {0xcf,0xa1}, {0x8d,0xd7}, {0xcf,0xa4}, {0xcf,0x77}, {0x92,0xfb}, {0x8d,0xd8},
    {0xcf,0xa7}, {0xcf,0xaa}, {0xcf,0xac}, {0xcf,0x74}, {0xac,0x76}, {0xac,0x7b}, {0xd2,0x49}, {0xac,0xad}, {0xcf,0xa5}, {0xcf,0xad},
    {0xcf,0x7b}, {0xcf,0x73}, {0xd2,0x64}, {0xac,0x7e}, {0xcf,0xa2}, {0xcf,0x78}, {0xcf,0x7a}, {0xac,0xa5}, {0xcf,0x7d}, {0xac,0x7d},
    {0xcf,0x70}, {0xcf,0xa8}, {0xcf,0xab}, {0x94,0x4f}, {0xac,0x7a}, {0x8d,0xd9}, {0xac,0xa8}, {0xcf,0x6d}, {0xac,0xaa}, {0xac,0x78},
    {0xac,0xae}, {0xcf,0xa9}, {0xcf,0x6f}, {0xac,0xab}, {0xd2,0x5e}, {0xcd,0x48}, {0xac,0x7c}, {0xac,0x77}, {0xcf,0x76}, {0xcf,0x6e},
    {0xac,0xac}, {0xac,0xa4}, {0xcf,0xa3}, {0xac,0xa9}, {0xac,0xa7}, {0xcf,0x79}, {0xac,0xa1}, {0xcf,0x71}, {0xac,0xa2}, {0xac,0xa3},
    {0xcf,0x72}, {0xcf,0xa6}, {0xac,0x79}, {0xcf,0x7e}, {0x89,0x6b}, {0x97,0xce}, {0xd2,0x4c}, {0xae,0xfd}, {0xaf,0x43}, {0xfa,0xf3},
    {0xfd,0xae}, {0xd2,0x55}, {0xd2,0x5b}, {0xd2,0x57}, {0xd2,0x4a}, {0xd2,0x4d}, {0xd2,0x46}, {0xd2,0x47}, {0xaf,0x4a}, {0xae,0xfa},
    {0xd2,0x56}, {0xd2,0x5f}, {0xaf,0x45}, {0xae,0xf6}, {0xaf,0x40}, {0xd2,0x4e}, {0xaf,0x42}, {0xd2,0x4f}, {0xd2,0x59}, {0xfb,0xaf},
    {0x92,0xb7}, {0xaf,0x44}, {0xd2,0x68}, {0xd2,0x48}, {0xae,0xfc}, {0xae,0xfb}, {0xaf,0x48}, {0xd2,0x45}, {0xd2,0x66}, {0xd2,0x5a},
    {0xd2,0x67}, {0xd2,0x61}, {0xd2,0x53}, {0xd2,0x62}, {0x8d,0xda}, {0xd2,0x5c}, {0xd2,0x65}, {0xd2,0x63}, {0xaf,0x49}, {0xd2,0x54},
    {0xae,0xf9}, {0xae,0xf8}, {0xaf,0x41}, {0xaf,0x47}, {0xd2,0x60}, {0xaf,0x46}, {0xd2,0x51}, {0xb2,0x43}, {0x9c,0x5a}, {0xd2,0x69},
    {0xd2,0x50}, {0xd2,0x4b}, {0xae,0xfe}, {0xaf,0x4b}, {0xae,0xf7}, {0xfd,0xad}, {0xd2,0x58}, {0xd2,0x5d}, {0x8d,0xdc}, {0x94,0x44},
    {0xb2,0x65}, {0xd5,0xe1}, {0xd5,0xe5}, {0xb2,0x52}, {0xb2,0x50}, {0x8d,0xdd}, {0xb2,0x47}, {0xd5,0xe3}, {0xd5,0xe2}, {0xb2,0x5b},
    {0xd5,0xe8}, {0xb2,0x55}, {0xa0,0xd6}, {0xd5,0xfa}, {0xd6,0x47}, {0xb2,0x44}, {0xd5,0xf7}, {0xd5,0xf0}, {0xb2,0x67}, {0xd5,0xe0},
    {0xd5,0xfc}, {0xb2,0x64}, {0xb2,0x58}, {0xb2,0x63}, {0xb2,0x4e}, {0xd5,0xec}, {0xd5,0xfe}, {0xd5,0xf6}, {0xb2,0x4f}, {0xb2,0x49},
    {0xd6,0x45}, {0xd5,0xfd}, {0xd6,0x40}, {0xb2,0x51}, {0xb2,0x59}, {0xd6,0x42}, {0xd5,0xea}, {0xd5,0xfb}, {0xd5,0xef}, {0xd6,0x44},
    {0xb2,0x5e}, {0xb2,0x46}, {0xb2,0x5c}, {0xd5,0xf4}, {0xd5,0xf2}, {0xd5,0xf3}, {0xb2,0x53}, {0xd5,0xee}, {0xd5,0xed}, {0xb2,0x48},
    {0xd5,0xe7}, {0xd6,0x46}, {0xb2,0x4a}, {0xd5,0xf1}, {0xb2,0x68}, {0xb2,0x62}, {0xd5,0xe6}, {0xb2,0x5f}, {0xb2,0x5d}, {0xb2,0x66},
    {0xd5,0xf8}, {0xb2,0x61}, {0xd2,0x52}, {0xd5,0xf9}, {0xb2,0x60}, {0xd6,0x41}, {0xb2,0x45}, {0xd5,0xf5}, {0xb2,0x57}, {0xd5,0xe9},
    {0xb2,0x56}, {0xb2,0x54}, {0xb2,0x4c}, {0xb2,0x4b}, {0xd9,0xe7}, {0xd6,0x43}, {0x8c,0x41}, {0xd5,0xeb}, {0x97,0xd5}, {0xd9,0xfc},
    {0x94,0x4a}, {0xb2,0x4d}, {0x94,0x4d}, {0x97,0xcb}, {0x8d,0xde}, {0x8d,0xdf}, {0xb5,0x41}, {0xb2,0x5a}, {0xb4,0xee}, {0xd9,0xf6},
    {0xb4,0xfc}, {0xd9,0xea}, {0xb4,0xeb}, {0xb4,0xe7}, {0xda,0x49}, {0xb4,0xed}, {0xb4,0xf1}, {0xb4,0xec}, {0xb4,0xf5}, {0xda,0x4d},
    {0xda,0x44}, {0x8d,0xe0}, {0xfe,0xf9}, {0xd9,0xf1}, {0xb4,0xfa}, {0xb4,0xf4}, {0xd9,0xfd}, {0xb4,0xe4}, {0xda,0x4a}, {0xda,0x43},
    {0xb4,0xe8}, {0xd9,0xf7}, {0xb4,0xf7}, {0xda,0x55}, {0xda,0x56}, {0xb4,0xe5}, {0xda,0x48}, {0xb4,0xf9}, {0xd9,0xfb}, {0xd9,0xed},
    {0xd9,0xee}, {0xb4,0xfd}, {0xd9,0xf2}, {0xd9,0xf9}, {0xd9,0xf3}, {0xb4,0xfb}, {0xb5,0x44}, {0xd9,0xef}, {0xd9,0xe8}, {0xd9,0xe9},
    {0xd9,0xeb}, {0xb4,0xea}, {0xd9,0xf8}, {0xb4,0xf8}, {0xb5,0x42}, {0xfd,0xc0}, {0xfc,0xf9}, {0xd9,0xfa}, {0xda,0x53}, {0xda,0x4b},
    {0xb4,0xe6}, {0xda,0x51}, {0xb4,0xf2}, {0xb4,0xf0}, {0xfb,0x7e}, {0xda,0x57}, {0xb4,0xef}, {0xda,0x41}, {0xd9,0xf4}, {0xd9,0xfe},
    {0xb5,0x47}, {0xda,0x45}, {0xda,0x42}, {0xd9,0xf0}, {0xb5,0x43}, {0xda,0x4f}, {0xda,0x4c}, {0xda,0x54}, {0xb4,0xe9}, {0xda,0x40},
    {0xb5,0x46}, {0xda,0x47}, {0xb4,0xf3}, {0xb4,0xf6}, {0xda,0x46}, {0xb5,0x45}, {0xd9,0xf5}, {0xd5,0xe4}, {0x92,0xb3}, {0xda,0x50},
    {0xda,0x4e}, {0xda,0x52}, {0xfd,0xaf}, {0x8d,0xe1}, {0xd9,0xec}, {0xb5,0x40}, {0x95,0xd3}, {0xde,0x61}, {0xde,0x60}, {0xde,0x46},
    {0xb7,0xbd}, {0xde,0x5f}, {0xde,0x49}, {0xde,0x4a}, {0xb7,0xc7}, {0xde,0x68}, {0xb7,0xc2}, {0xde,0x5e}, {0x89,0xc1}, {0xde,0x43},
    {0xb7,0xc8}, {0xb7,0xbe}, {0xde,0x52}, {0xde,0x48}, {0xde,0x4b}, {0xde,0x63}, {0xb7,0xb8}, {0xde,0x6a}, {0xde,0x62}, {0xb7,0xc1},
    {0xde,0x57}, {0xb7,0xcc}, {0xb7,0xcb}, {0xb7,0xc5}, {0xde,0x69}, {0xb7,0xb9}, {0xde,0x55}, {0xde,0x4c}, {0xde,0x59}, {0xde,0x65},
    {0xb7,0xcd}, {0xfd,0x68}, {0xb7,0xbb}, {0xde,0x54}, {0x9c,0xb7}, {0xde,0x4d}, {0xb7,0xc4}, {0x8d,0xe3}, {0xb7,0xc3}, {0xde,0x50},
    {0xde,0x5a}, {0xde,0x64}, {0xde,0x47}, {0xde,0x51}, {0xb7,0xbc}, {0xde,0x5b}, {0xb7,0xc9}, {0xb7,0xc0}, {0xde,0x4e}, {0xb7,0xbf},
    {0xde,0x45}, {0xde,0x53}, {0xde,0x67}, {0xb4,0xfe}, {0xba,0xb0}, {0xde,0x56}, {0xe2,0x6c}, {0xde,0x58}, {0xde,0x66}, {0xb7,0xc6},
    {0xde,0x4f}, {0xb7,0xba}, {0xb7,0xca}, {0xbc,0xf0}, {0xde,0x44}, {0xde,0x5d}, {0xfa,0xc0}, {0x8d,0xe5}, {0xfa,0x64}, {0xde,0x5c},
    {0x89,0x47}, {0x8d,0xe4}, {0x8d,0xe7}, {0x8d,0xe8}, {0xe2,0xaa}, {0xba,0xad}, {0xe2,0x7d}, {0xe2,0xa4}, {0xba,0xa2}, {0xe2,0x6e},
    {0xba,0xaf}, {0xba,0x77}, {0xe2,0x6d}, {0xe2,0xb0}, {0xba,0xb1}, {0xe2,0x71}, {0xe2,0xa3}, {0xfd,0xc7}, {0xe2,0x73}, {0xe2,0xb3},
    {0xe2,0xaf}, {0xba,0x75}, {0xba,0xa1}, {0xe6,0x53}, {0xba,0xae}, {0xba,0x7d}, {0xe2,0x6f}, {0xfd,0xb0}, {0xe2,0xae}, {0xba,0xa3},
    {0xe2,0xab}, {0xe2,0xb8}, {0xe2,0x75}, {0xe2,0x7e}, {0x94,0x45}, {0x97,0xd6}, {0xe2,0xb6}, {0xe2,0xac}, {0xba,0x7c}, {0xe2,0x7c},
    {0xba,0x76}, {0xba,0x74}, {0xba,0xa8}, {0xfc,0xc6}, {0x98,0x44}, {0xe2,0x7a}, {0xe2,0x77}, {0xe2,0x78}, {0xe2,0xb2}, {0xe2,0xb7},
    {0xe2,0xb5}, {0xba,0x7a}, {0xe2,0xb9}, {0xba,0x7e}, {0xba,0xa7}, {0x8d,0xe9}, {0xe2,0x70}, {0xe5,0xfa}, {0xe2,0x79}, {0xba,0x78},
    {0xba,0xac}, {0xba,0xa9}, {0xba,0x7b}, {0xe2,0xa5}, {0xe2,0x74}, {0xba,0xaa}, {0xe2,0xa7}, {0xba,0xa4}, {0xba,0xa6}, {0xba,0x73},
    {0x8d,0xea}, {0xe2,0xa9}, {0xe2,0xa1}, {0xe2,0x72}, {0xba,0xa5}, {0xe2,0xb1}, {0xe2,0xb4}, {0xe2,0x7b}, {0xe2,0xa8}, {0xfe,0x50},
    {0xba,0x79}, {0xbc,0xdf}, {0xe2,0xa6}, {0xe5,0xf9}, {0xe2,0xad}, {0xfd,0xcc}, {0xe2,0x76}, {0xe6,0x44}, {0xe6,0x4e}, {0xbc,0xe2},
    {0xe6,0x4d}, {0xe6,0x59}, {0xbc,0xe4}, {0xe6,0x4b}, {0x9d,0xa7}, {0xe6,0x4f}, {0xbc,0xef}, {0xe6,0x46}, {0xbc,0xe7}, {0xfd,0xcd},
    {0xe6,0x52}, {0xe9,0xf0}, {0xbc,0xf3}, {0xbc,0xf2}, {0xe6,0x54}, {0xe6,0x43}, {0xe6,0x5e}, {0xbc,0xed}, {0xbc,0xe3}, {0xe6,0x57},
    {0xe6,0x5b}, {0xe6,0x60}, {0xe6,0x55}, {0xe6,0x49}, {0xbc,0xe6}, {0xbc,0xe9}, {0xbc,0xf1}, {0xbc,0xec}, {0xe6,0x4c}, {0xe2,0xa2},
    {0xfd,0xcf}, {0xe6,0x48}, {0xe6,0x5f}, {0xbc,0xe8}, {0x95,0xd2}, {0xbc,0xeb}, {0xe6,0x61}, {0xbc,0xe0}, {0xe6,0x56}, {0xe5,0xfb},
    {0xe6,0x5c}, {0xc0,0xdf}, {0x8d,0xed}, {0xe6,0x4a}, {0xbc,0xe1}, {0xe6,0x45}, {0xbc,0xe5}, {0xe5,0xfc}, {0xba,0xab}, {0xe6,0x41},
    {0xfc,0xba}, {0xe6,0x5a}, {0xe6,0x42}, {0xe6,0x40}, {0xbc,0xea}, {0xe6,0x58}, {0xe5,0xfe}, {0xe6,0x51}, {0xe6,0x50}, {0xe6,0x5d},
    {0xe6,0x47}, {0xbc,0xee}, {0xfd,0xc5}, {0xe9,0xf3}, {0xfd,0xd2}, {0xbf,0x49}, {0xbe,0xfe}, {0xea,0x40}, {0xe9,0xeb}, {0xbf,0x41},
    {0xe9,0xf7}, {0xbf,0x48}, {0xbf,0x43}, {0xe9,0xf5}, {0xed,0x4f}, {0xe9,0xfb}, {0xea,0x42}, {0xe9,0xfa}, {0xe9,0xe9}, {0xe9,0xf8},
    {0xea,0x44}, {0xea,0x46}, {0xbe,0xfd}, {0xea,0x45}, {0xbf,0x44}, {0xbf,0x4a}, {0x9c,0xdc}, {0xbf,0x47}, {0xe9,0xfe}, {0xbf,0x46},
    {0xe9,0xf9}, {0x95,0xcf}, {0xe9,0xed}, {0xe9,0xf2}, {0x8d,0xee}, {0xe9,0xfd}, {0xbf,0x45}, {0xbf,0x42}, {0xbe,0xfc}, {0xbf,0x40},
    {0xe9,0xf1}, {0xe5,0xfd}, {0xe9,0xec}, {0xe9,0xef}, {0xea,0x41}, {0xe9,0xf4}, {0xe9,0xea}, {0xed,0x4e}, {0xea,0x43}, {0xe9,0xee},
    {0xe9,0xfc}, {0xfd,0xd4}, {0xed,0x51}, {0xc0,0xe3}, {0xc0,0xd7}, {0x96,0xec}, {0x96,0xeb}, {0xc0,0xdb}, {0xed,0x53}, {0xed,0x59},
    {0xed,0x57}, {0xc0,0xd9}, {0xc0,0xda}, {0xc0,0xe1}, {0xed,0x5a}, {0xed,0x52}, {0xc0,0xdc}, {0xed,0x56}, {0xed,0x55}, {0xed,0x5b},
    {0xc0,0xe2}, {0xc0,0xdd}, {0xc0,0xe0}, {0xed,0x54}, {0xc0,0xe4}, {0xc0,0xde}, {0xc0,0xe5}, {0xc0,0xd8}, {0xed,0x58}, {0xed,0x50},
    {0x90,0xb6}, {0xef,0xf7}, {0xfd,0xc3}, {0xc2,0x71}, {0xef,0xf4}, {0xef,0xf6}, {0xc2,0x6f}, {0xef,0xf2}, {0xef,0xf3}, {0xef,0xee},
    {0x98,0xab}, {0xe9,0xf6}, {0xef,0xef}, {0xc2,0x70}, {0xef,0xeb}, {0xc2,0x6d}, {0xef,0xf8}, {0xc2,0x6e}, {0xef,0xec}, {0xef,0xed},
    {0xef,0xf1}, {0xc2,0x73}, {0xc2,0x72}, {0xef,0xf0}, {0xc3,0x78}, {0xf2,0x5f}, {0xf2,0x65}, {0xc3,0x79}, {0xf2,0x5c}, {0xc3,0x76},
    {0xc3,0x73}, {0xf2,0x67}, {0xc3,0x77}, {0x96,0xee}, {0xc3,0x74}, {0xf2,0x5e}, {0xf2,0x61}, {0xf2,0x62}, {0xf2,0x63}, {0xf2,0x66},
    {0xef,0xf5}, {0xf2,0x5d}, {0xc3,0x75}, {0xf2,0x64}, {0xf2,0x68}, {0xf2,0x60}, {0x8d,0xf4}, {0xf4,0x5d}, {0xc4,0x6a}, {0xf4,0x60},
    {0xc4,0x6b}, {0xf4,0x68}, {0xf4,0x5f}, {0xf4,0x5c}, {0xf4,0x5e}, {0xf4,0x62}, {0xf4,0x65}, {0xf4,0x64}, {0xf4,0x67}, {0xf4,0x5b},
    {0xc4,0x69}, {0xf4,0x63}, {0xf4,0x66}, {0xf4,0x69}, {0xf4,0x61}, {0xf5,0xd3}, {0xf5,0xd4}, {0xf5,0xd8}, {0xf5,0xd9}, {0xf5,0xd6},
    {0xf5,0xd7}, {0xf5,0xd5}, {0xfd,0xe0}, {0xc4,0xe9}, {0x8c,0x67}, {0x8d,0xf6}, {0xc5,0x78}, {0xf6,0xeb}, {0x8d,0xf7}, {0xf6,0xe8},
    {0xf6,0xe9}, {0xf6,0xea}, {0xc5,0x79}, {0xf7,0xe5}, {0xf7,0xe4}, {0x8f,0xfa}, {0xf8,0xaf}, {0xc5,0xf4}, {0xf8,0xad}, {0xf8,0xb0},
    {0xf8,0xae}, {0xf8,0xf5}, {0xc6,0x57}, {0xc6,0x65}, {0xf9,0xa3}, {0xf9,0x6c}, {0x97,0xd0}, {0xf9,0xa2}, {0xf9,0xd0}, {0xf9,0xd1},
    {0xa4,0xf5}, {0x8b,0xd2}, {0x8d,0xf8}, {0xa6,0xc7}, {0xca,0x41}, {0xcb,0x5e}, {0x90,0xd9}, {0xa8,0x5f}, {0x8c,0x47}, {0xa8,0x62},
    {0xfa,0xf0}, {0xcb,0x5f}, {0xa8,0x60}, {0xa8,0x61}, {0xfd,0xe1}, {0x8d,0xf9}, {0xfd,0xe3}, {0xcd,0x58}, {0xcd,0x5a}, {0xcd,0x55},
    {0xcd,0x52}, {0xcd,0x54}, {0x8d,0xfa}, {0xaa,0xa4}, {0xfb,0x63}, {0xaa,0xa2}, {0x90,0xa6}, {0xcd,0x56}, {0xaa,0xa3}, {0xcd,0x53},
    {0xcd,0x50}, {0xaa,0xa1}, {0xcd,0x57}, {0xcd,0x51}, {0xaa,0xa5}, {0xcd,0x59}, {0xcf,0xaf}, {0x99,0x70}, {0xcf,0xb3}, {0x91,0xeb},
    {0xac,0xb7}, {0x97,0x70}, {0x98,0x6f}, {0xfd,0xe2}, {0xcf,0xb6}, {0xac,0xaf}, {0xac,0xb2}, {0xac,0xb4}, {0xac,0xb6}, {0xac,0xb3},
    {0xcf,0xb2}, {0xcf,0xb1}, {0xac,0xb1}, {0xcf,0xb4}, {0xcf,0xb5}, {0xcf,0xae}, {0xac,0xb5}, {0x98,0xf2}, {0xac,0xb0}, {0x9a,0xfc},
    {0x89,0x6c}, {0xfd,0xfd}, {0xcf,0xb0}, {0x99,0x5e}, {0x95,0xbd}, {0xd2,0x77}, {0xd2,0x78}, {0xd2,0x79}, {0xaf,0x50}, {0xaf,0x4c},
    {0xd2,0x6e}, {0xfd,0xe4}, {0xd2,0x76}, {0xd2,0x7b}, {0xaf,0x51}, {0x91,0xe6}, {0xd2,0x6c}, {0xd2,0x72}, {0xd2,0x6b}, {0xd2,0x75},
    {0xfd,0xe5}, {0xfd,0xe6}, {0xd2,0x71}, {0xaf,0x4d}, {0xaf,0x4f}, {0xd2,0x7a}, {0xd2,0x6a}, {0xd2,0x6d}, {0xd2,0x73}, {0xfd,0xe7},
    {0xd2,0x74}, {0xd2,0x7c}, {0xd2,0x70}, {0xaf,0x4e}, {0xb2,0x6d}, {0xd6,0x4e}, {0x94,0x54}, {0xd6,0x50}, {0xd6,0x4c}, {0x99,0xb8},
    {0xd6,0x58}, {0xd6,0x4a}, {0xd6,0x57}, {0xb2,0x69}, {0xd6,0x48}, {0xda,0x5b}, {0xd6,0x52}, {0xb2,0x6c}, {0x97,0xe9}, {0xd6,0x53},
    {0xd6,0x56}, {0xd6,0x5a}, {0xd6,0x4f}, {0x93,0x46}, {0xd6,0x54}, {0xb2,0x6a}, {0xb2,0x6b}, {0xd6,0x59}, {0xd6,0x4d}, {0xd6,0x49},
    {0xd6,0x5b}, {0xd6,0x51}, {0xd6,0x55}, {0xd6,0x4b}, {0xb5,0x48}, {0xb5,0x49}, {0xda,0x65}, {0xb5,0x4f}, {0x98,0x63}, {0xda,0x59},
    {0xda,0x62}, {0xda,0x58}, {0xb5,0x4c}, {0xda,0x60}, {0xda,0x5e}, {0xda,0x5f}, {0xb5,0x4a}, {0xda,0x63}, {0x95,0xbc}, {0xfd,0xed},
    {0xfd,0xf7}, {0xda,0x5c}, {0xda,0x5a}, {0xb5,0x4b}, {0xda,0x5d}, {0xda,0x61}, {0x98,0x70}, {0x96,0xf6}, {0x8e,0xa9}, {0xb5,0x4d},
    {0xda,0x64}, {0x94,0x51}, {0x8e,0x43}, {0x8b,0x5a}, {0xde,0x70}, {0xde,0x77}, {0xde,0x79}, {0xde,0xa1}, {0xfd,0xee}, {0xb7,0xda},
    {0xde,0x6b}, {0xb7,0xd2}, {0xfd,0xf0}, {0xde,0x7a}, {0xb7,0xd7}, {0xde,0xa2}, {0xb7,0xce}, {0xfd,0xf4}, {0xde,0x7d}, {0x9b,0xf5},
    {0xde,0x6d}, {0xde,0x7e}, {0xde,0x6c}, {0xb7,0xdc}, {0xde,0x78}, {0xb7,0xcf}, {0xde,0xa3}, {0xb7,0xd4}, {0xde,0x71}, {0xb7,0xd9},
    {0xde,0x7c}, {0xde,0x6f}, {0xde,0x76}, {0xde,0x72}, {0xde,0x6e}, {0xb7,0xd1}, {0xb7,0xd8}, {0xb7,0xd6}, {0xb7,0xd3}, {0xb7,0xdb},
    {0xb7,0xd0}, {0xde,0x75}, {0x97,0x7e}, {0xb7,0xd5}, {0xb5,0x4e}, {0xde,0x7b}, {0x9b,0xd5}, {0xde,0x73}, {0x9a,0xc3}, {0x97,0xc8},
    {0xa0,0xdb}, {0x91,0xd0}, {0xde,0x74}, {0x9f,0xe4}, {0xe2,0xc1}, {0x8f,0xdd}, {0xba,0xb4}, {0x91,0xe9}, {0xe2,0xbd}, {0xe2,0xc3},
    {0xe2,0xbf}, {0xba,0xb6}, {0xe2,0xbe}, {0xe2,0xc2}, {0xe2,0xba}, {0x98,0xe0}, {0xe2,0xbc}, {0xba,0xb5}, {0x92,0xca}, {0x98,0x57},
    {0xe2,0xc0}, {0xe2,0xbb}, {0x8c,0x51}, {0xba,0xb7}, {0xba,0xb2}, {0xfd,0xeb}, {0xe2,0xc4}, {0x9b,0x49}, {0xba,0xb3}, {0xe6,0x67},
    {0xe6,0x64}, {0xe6,0x70}, {0xe6,0x6a}, {0xe6,0x6c}, {0xbc,0xf4}, {0xe6,0x66}, {0xe6,0x6e}, {0x9d,0x76}, {0x9e,0xaf}, {0xe6,0x6d},
    {0xe6,0x6b}, {0xe6,0x71}, {0xbc,0xf7}, {0xe6,0x68}, {0xe6,0x6f}, {0xbc,0xf5}, {0x9c,0xcc}, {0xe6,0x63}, {0xe6,0x65}, {0xbc,0xf6},
    {0xe6,0x62}, {0xe6,0x72}, {0xfd,0xea}, {0xe6,0x69}, {0x8d,0xf1}, {0xea,0x4a}, {0xbf,0x51}, {0xfd,0xfb}, {0xea,0x55}, {0xea,0x53},
    {0xbf,0x4b}, {0xea,0x49}, {0xea,0x4c}, {0xea,0x4d}, {0xea,0x48}, {0xbf,0x55}, {0xbf,0x56}, {0xea,0x47}, {0xea,0x56}, {0xea,0x51},
    {0xbf,0x4f}, {0xbf,0x4c}, {0xea,0x50}, {0xea,0x4e}, {0xbf,0x52}, {0xea,0x52}, {0xbf,0x4d}, {0x8e,0x53}, {0xbf,0x4e}, {0xea,0x4f},
    {0xbf,0x50}, {0xea,0x4b}, {0xea,0x54}, {0xbf,0x53}, {0xea,0x57}, {0xea,0x58}, {0xbf,0x54}, {0xfa,0xcf}, {0xc0,0xe7}, {0xc0,0xee},
    {0xed,0x5c}, {0xed,0x62}, {0xed,0x60}, {0xc0,0xea}, {0xc0,0xe9}, {0xc0,0xe6}, {0xed,0x5e}, {0x96,0xf9}, {0xc0,0xec}, {0xc0,0xeb},
    {0xc0,0xe8}, {0xed,0x61}, {0xed,0x5d}, {0xed,0x5f}, {0xc0,0xed}, {0x98,0xbf}, {0x9e,0x49}, {0xc2,0x77}, {0xef,0xfb}, {0xc2,0x74},
    {0xc2,0x75}, {0xef,0xfd}, {0xc2,0x76}, {0xef,0xfa}, {0x8c,0xa7}, {0xef,0xf9}, {0xf2,0x6c}, {0xef,0xfc}, {0xf2,0x6d}, {0xc3,0x7a},
    {0xf2,0x6b}, {0x9b,0xca}, {0xf2,0x6a}, {0xf2,0x69}, {0xc3,0x7b}, {0xfd,0xfe}, {0x92,0xdc}, {0xc4,0x6c}, {0xf4,0x6a}, {0xf4,0x6b},
    {0xfe,0x41}, {0x91,0xcc}, {0x91,0xe2}, {0xf5,0xdc}, {0xf5,0xdb}, {0xc4,0xea}, {0xf5,0xda}, {0xf6,0xec}, {0xf6,0xed}, {0xf7,0xe6},
    {0xf8,0xb1}, {0xfe,0x44}, {0xf8,0xf6}, {0xf9,0xbc}, {0xc6,0x79}, {0xf9,0xc6}, {0xa4,0xf6}, {0x8b,0xd3}, {0xaa,0xa6}, {0xaa,0xa7},
    {0xfe,0x47}, {0xac,0xb8}, {0xc0,0xef}, {0xa4,0xf7}, {0xaa,0xa8}, {0xaf,0x52}, {0xb7,0xdd}, {0xa4,0xf8}, {0xb2,0x6e}, {0xba,0xb8},
    {0xc9,0x62}, {0xfe,0x48}, {0xcf,0xb7}, {0xd2,0x7d}, {0xe2,0xc5}, {0xc0,0xf0}, {0xa4,0xf9}, {0xaa,0xa9}, {0xcf,0xb8}, {0xcf,0xb9},
    {0xda,0x66}, {0xb5,0x50}, {0xde,0xa4}, {0x94,0x55}, {0xb7,0xde}, {0xe2,0xc6}, {0xfe,0x4b}, {0xbc,0xf8}, {0xfe,0x4c}, {0xc3,0x7c},
    {0xa4,0xfa}, {0xda,0x67}, {0xa4,0xfb}, {0x8d,0xbf}, {0xa6,0xc9}, {0xca,0x42}, {0xa6,0xc8}, {0xa8,0x65}, {0xa8,0x64}, {0xa8,0x63},
    {0xcb,0x60}, {0x9e,0x78}, {0xaa,0xaa}, {0xaa,0xab}, {0xcd,0x5b}, {0xcf,0xba}, {0xcf,0xbd}, {0xac,0xba}, {0xcf,0xbb}, {0xac,0xb9},
    {0xcf,0xbc}, {0xac,0xbb}, {0xd2,0xa2}, {0xd2,0xa1}, {0xd2,0x7e}, {0xaf,0x53}, {0xd6,0x5d}, {0xd6,0x5e}, {0xb2,0x6f}, {0xd6,0x5c},
    {0xd6,0x5f}, {0xb5,0x52}, {0xb2,0x70}, {0xfe,0x51}, {0xb5,0x51}, {0xda,0x6b}, {0xda,0x6a}, {0x94,0x56}, {0xda,0x68}, {0xda,0x69},
    {0xda,0x6c}, {0xde,0xa6}, {0xde,0xa5}, {0xde,0xa9}, {0x9d,0x61}, {0xde,0xa8}, {0xde,0xa7}, {0xba,0xb9}, {0xe2,0xc9}, {0x94,0x57},
    {0xe2,0xc8}, {0xba,0xba}, {0xe2,0xc7}, {0xe6,0x73}, {0xe6,0x74}, {0xbc,0xf9}, {0xea,0x59}, {0xea,0x5a}, {0x99,0x66}, {0xf2,0x72},
    {0xc3,0x7d}, {0xf2,0x71}, {0xf2,0x70}, {0xf2,0x6e}, {0xf2,0x6f}, {0xc4,0xeb}, {0xf4,0x6c}, {0xf6,0xee}, {0xf8,0xf7}, {0xa4,0xfc},
    {0x8b,0xd5}, {0xc9,0xa5}, {0xa5,0xc7}, {0xc9,0xa6}, {0xa0,0x69}, {0xca,0x43}, {0xca,0x44}, {0xcb,0x66}, {0xcb,0x62}, {0xcb,0x61},
    {0xaa,0xac}, {0xcb,0x65}, {0xa8,0x67}, {0xcb,0x63}, {0xa8,0x66}, {0xcb,0x67}, {0xcb,0x64}, {0xcd,0x5f}, {0xcf,0xbe}, {0xcd,0x5d},
    {0xcd,0x64}, {0x98,0xb4}, {0xaa,0xad}, {0xaa,0xb0}, {0xcd,0x65}, {0xcd,0x61}, {0xcd,0x62}, {0xcd,0x5c}, {0xaa,0xaf}, {0xcd,0x5e},
    {0xaa,0xae}, {0xcd,0x63}, {0xcd,0x60}, {0xcf,0xc2}, {0xac,0xbd}, {0xac,0xbe}, {0xa0,0x49}, {0xcf,0xc5}, {0xcf,0xbf}, {0xcf,0xc4},
    {0xcf,0xc0}, {0xac,0xbc}, {0xcf,0xc3}, {0xcf,0xc1}, {0xd2,0xa8}, {0xd2,0xa5}, {0xd2,0xa7}, {0xaf,0x58}, {0xaf,0x57}, {0xaf,0x55},
    {0xd2,0xa4}, {0xd2,0xa9}, {0xaf,0x54}, {0xaf,0x56}, {0xd2,0xa6}, {0xd6,0x67}, {0xd2,0xa3}, {0xd2,0xaa}, {0xa0,0x4c}, {0x9e,0x65},
    {0xd6,0x62}, {0xd6,0x66}, {0xd6,0x65}, {0xda,0x6e}, {0xda,0x79}, {0xd6,0x68}, {0x98,0xb5}, {0xd6,0x63}, {0xda,0x6d}, {0xb2,0x74},
    {0xb2,0x73}, {0xd6,0x61}, {0xd6,0x64}, {0xb2,0x75}, {0xb2,0x72}, {0xb2,0x71}, {0xd6,0x60}, {0xd6,0x69}, {0xda,0x70}, {0xda,0x77},
    {0xb5,0x54}, {0xda,0x76}, {0xda,0x73}, {0xfe,0x58}, {0xb5,0x56}, {0x99,0x75}, {0xfe,0x53}, {0xa0,0x65}, {0xda,0x75}, {0xfe,0x59},
    {0xda,0x6f}, {0xda,0x71}, {0xda,0x74}, {0xda,0x72}, {0xb5,0x55}, {0xda,0x78}, {0xb5,0x53}, {0xb7,0xdf}, {0x98,0xb7}, {0x98,0xb8},
    {0xde,0xad}, {0xde,0xac}, {0xde,0xaa}, {0xb7,0xe2}, {0xb7,0xe1}, {0xde,0xae}, {0x98,0xba}, {0xde,0xab}, {0xe2,0xca}, {0xba,0xbb},
    {0xb7,0xe0}, {0x98,0xbb}, {0xde,0xb0}, {0xde,0xaf}, {0xe2,0xcd}, {0xe2,0xcb}, {0xbc,0xfa}, {0x9f,0xbc}, {0xba,0xbc}, {0xe2,0xcc},
    {0xe6,0x76}, {0xbc,0xfb}, {0xe6,0x75}, {0xe6,0x7e}, {0xe6,0x7d}, {0xe6,0x7b}, {0xe6,0x7a}, {0xe6,0x77}, {0xe6,0x78}, {0xe6,0x79},
    {0xe6,0x7c}, {0xe6,0xa1}, {0xea,0x5f}, {0xea,0x5c}, {0xea,0x5d}, {0xbf,0x57}, {0xea,0x5b}, {0xea,0x61}, {0xea,0x60}, {0xea,0x5e},
    {0xed,0x64}, {0xed,0x65}, {0xc0,0xf1}, {0xa0,0x4a}, {0xc0,0xf2}, {0xed,0x63}, {0x9e,0xc7}, {0xc2,0x79}, {0xef,0xfe}, {0xc2,0x78},
    {0xc3,0x7e}, {0xc3,0xa1}, {0xc4,0x6d}, {0xf4,0x6e}, {0xf4,0x6d}, {0xf5,0xdd}, {0xf6,0xef}, {0xc5,0x7a}, {0xf7,0xe8}, {0xf7,0xe7},
    {0xf7,0xe9}, {0xa5,0xc8}, {0xcf,0xc6}, {0xaf,0x59}, {0xb2,0x76}, {0xd6,0x6a}, {0xa5,0xc9}, {0xc9,0xa7}, {0xa4,0xfd}, {0x8c,0xa9},
    {0xca,0x45}, {0x98,0xae}, {0xcb,0x6c}, {0xcb,0x6a}, {0xcb,0x6b}, {0xcb,0x68}, {0xa8,0x68}, {0xcb,0x69}, {0x92,0xd6}, {0xfa,0xe1},
    {0xcd,0x6d}, {0x91,0xd4}, {0xaa,0xb3}, {0xcd,0x6b}, {0xcd,0x67}, {0xcd,0x6a}, {0xcd,0x66}, {0xaa,0xb5}, {0xcd,0x69}, {0xfa,0xde},
    {0xaa,0xb2}, {0xaa,0xb1}, {0xfe,0x5b}, {0xaa,0xb4}, {0xcd,0x6c}, {0xcd,0x68}, {0xac,0xc2}, {0xac,0xc5}, {0xcf,0xce}, {0xcf,0xcd},
    {0xcf,0xcc}, {0xac,0xbf}, {0xcf,0xd5}, {0xcf,0xcb}, {0x8c,0x53}, {0xac,0xc1}, {0xd2,0xaf}, {0xcf,0xd2}, {0xcf,0xd0}, {0xac,0xc4},
    {0xcf,0xc8}, {0xcf,0xd3}, {0xcf,0xca}, {0xcf,0xd4}, {0xcf,0xd1}, {0xcf,0xc9}, {0xfe,0x5e}, {0xac,0xc0}, {0xcf,0xd6}, {0xcf,0xc7},
    {0xac,0xc3}, {0xfb,0xd7}, {0xfe,0x5a}, {0x94,0xc5}, {0xd2,0xb4}, {0xd2,0xab}, {0xd2,0xb6}, {0xfa,0xca}, {0xd2,0xae}, {0xd2,0xb9},
    {0xd2,0xba}, {0xd2,0xac}, {0xd2,0xb8}, {0xd2,0xb5}, {0xd2,0xb3}, {0xd2,0xb7}, {0xaf,0x5f}, {0xaf,0x5d}, {0x98,0xc1}, {0x97,0x5c},
    {0xd2,0xb1}, {0xfe,0x74}, {0xd2,0xad}, {0x97,0x73}, {0xd2,0xb0}, {0xd2,0xbb}, {0xd2,0xb2}, {0xaf,0x5e}, {0xcf,0xcf}, {0xaf,0x5a},
    {0xaf,0x5c}, {0xfa,0x46}, {0x97,0x64}, {0xd6,0x78}, {0xd6,0x6d}, {0xd6,0x6b}, {0xfe,0x68}, {0xd6,0x6c}, {0x96,0x4e}, {0xd6,0x73},
    {0x97,0x65}, {0xd6,0x74}, {0xd6,0x70}, {0xb2,0x7b}, {0xd6,0x75}, {0xd6,0x72}, {0xd6,0x6f}, {0x8c,0x5a}, {0xb2,0x79}, {0xd6,0x6e},
    {0xb2,0x77}, {0xb2,0x7a}, {0xd6,0x71}, {0xd6,0x79}, {0xaf,0x5b}, {0xb2,0x78}, {0xd6,0x77}, {0xd6,0x76}, {0xb2,0x7c}, {0x89,0xa1},
    {0x95,0xfa}, {0x92,0xd4}, {0xfe,0x69}, {0xda,0x7e}, {0xfb,0x45}, {0x98,0xc8}, {0xda,0xa1}, {0xb5,0x60}, {0x90,0xef}, {0xda,0xa7},
    {0x98,0xc9}, {0x98,0xca}, {0xda,0xa9}, {0xda,0xa2}, {0xb5,0x5a}, {0xda,0xa6}, {0xda,0xa5}, {0xb5,0x5b}, {0xb5,0x61}, {0xb5,0x62},
    {0xda,0xa8}, {0xb5,0x58}, {0xda,0x7d}, {0xda,0x7b}, {0xda,0xa3}, {0xda,0x7a}, {0xb5,0x5f}, {0xda,0x7c}, {0xda,0xa4}, {0xda,0xaa},
    {0xb5,0x59}, {0xb5,0x5e}, {0xb5,0x5c}, {0xb5,0x5d}, {0x94,0x6d}, {0x94,0xb7}, {0xfe,0x6c}, {0xb5,0x57}, {0x94,0x6b}, {0xb7,0xe9},
    {0xde,0xb7}, {0xb7,0xe8}, {0xde,0xbb}, {0x92,0xfc}, {0xde,0xb1}, {0x95,0xeb}, {0xde,0xbc}, {0xfe,0x73}, {0x97,0x6e}, {0xfe,0x5f},
    {0xde,0xb2}, {0xde,0xb3}, {0xde,0xbd}, {0xde,0xba}, {0xde,0xb8}, {0xde,0xb9}, {0xde,0xb5}, {0xde,0xb4}, {0xfd,0xbd}, {0xde,0xbe},
    {0xb7,0xe5}, {0x92,0xd5}, {0xde,0xb6}, {0xb7,0xea}, {0xb7,0xe4}, {0xb7,0xeb}, {0xb7,0xec}, {0xfe,0xb9}, {0xb7,0xe7}, {0xb7,0xe6},
    {0xfe,0x71}, {0xe2,0xce}, {0xba,0xbe}, {0xba,0xbd}, {0xfb,0xbb}, {0xe2,0xd3}, {0x94,0x7a}, {0xbc,0xfc}, {0xba,0xbf}, {0x95,0xfb},
    {0xfe,0x77}, {0xba,0xc1}, {0xe2,0xd4}, {0xb7,0xe3}, {0xba,0xc0}, {0xe2,0xd0}, {0xe2,0xd2}, {0xe2,0xcf}, {0xfe,0x79}, {0xe2,0xd1},
    {0xfe,0x75}, {0xe6,0xab}, {0x94,0x5d}, {0xe6,0xaa}, {0xe6,0xa7}, {0xbd,0x40}, {0xea,0x62}, {0xbd,0x41}, {0xe6,0xa6}, {0xfe,0x7c},
    {0xbc,0xfe}, {0xe6,0xa8}, {0xe6,0xa5}, {0xe6,0xa2}, {0xe6,0xa9}, {0xe6,0xa3}, {0xe6,0xa4}, {0xbc,0xfd}, {0x93,0x44}, {0x8e,0xa6},
    {0xed,0x69}, {0xea,0x66}, {0xea,0x65}, {0xea,0x67}, {0xed,0x66}, {0xbf,0x5a}, {0x92,0xd3}, {0xea,0x63}, {0x94,0xb8}, {0xbf,0x58},
    {0xbf,0x5c}, {0xbf,0x5b}, {0xea,0x64}, {0xea,0x68}, {0xbf,0x59}, {0xfc,0x71}, {0xed,0x6d}, {0xc0,0xf5}, {0xc2,0x7a}, {0xc0,0xf6},
    {0xc0,0xf3}, {0xed,0x6a}, {0xed,0x68}, {0xed,0x6b}, {0xed,0x6e}, {0xc0,0xf4}, {0xed,0x6c}, {0xed,0x67}, {0x97,0x5e}, {0xf0,0x42},
    {0xf0,0x45}, {0xf2,0x75}, {0xf0,0x40}, {0x8c,0xad}, {0xf4,0x6f}, {0xf0,0x46}, {0xc3,0xa2}, {0xf0,0x44}, {0xc2,0x7b}, {0xf0,0x41},
    {0xf0,0x43}, {0xf0,0x47}, {0xf2,0x76}, {0xf2,0x74}, {0xfe,0xa7}, {0xc3,0xa3}, {0xf2,0x73}, {0x94,0x6a}, {0xc4,0x6e}, {0x93,0xe3},
    {0x98,0xcf}, {0xc4,0xed}, {0xf6,0xf1}, {0xc4,0xec}, {0xf6,0xf3}, {0xf6,0xf0}, {0xf6,0xf2}, {0xc5,0xd0}, {0xf8,0xb2}, {0xa5,0xca},
    {0xcd,0x6e}, {0xd2,0xbc}, {0xd2,0xbd}, {0xb2,0x7d}, {0xde,0xbf}, {0xbf,0x5d}, {0xc3,0xa4}, {0xc5,0x7b}, {0xf8,0xb3}, {0xa5,0xcb},
    {0xa0,0xd9}, {0xcd,0x6f}, {0xa2,0x60}, {0xcf,0xd7}, {0xcf,0xd8}, {0xa0,0xbf}, {0xa0,0x4d}, {0xa0,0xb8}, {0xd2,0xbe}, {0xd2,0xbf},
    {0xb2,0x7e}, {0xb2,0xa1}, {0xa0,0xce}, {0xda,0xab}, {0xde,0xc2}, {0xde,0xc1}, {0xde,0xc0}, {0xe2,0xd5}, {0xe2,0xd6}, {0xe2,0xd7},
    {0xba,0xc2}, {0xa0,0xb7}, {0xe6,0xad}, {0xe6,0xac}, {0xea,0x69}, {0xbf,0x5e}, {0xbf,0x5f}, {0xfe,0xa9}, {0xed,0x72}, {0xed,0x6f},
    {0xed,0x70}, {0xed,0x71}, {0xf0,0x49}, {0xf0,0x48}, {0xc2,0x7c}, {0xf2,0x77}, {0xf5,0xde}, {0xa5,0xcc}, {0x89,0xc3}, {0xac,0xc6},
    {0xb2,0xa2}, {0xde,0xc3}, {0xfe,0xab}, {0xa5,0xcd}, {0xd2,0xc0}, {0xb2,0xa3}, {0xb5,0x63}, {0xb5,0x64}, {0xa5,0xce}, {0xa5,0xcf},
    {0xca,0x46}, {0xa8,0x6a}, {0xa8,0x69}, {0xac,0xc7}, {0xcf,0xd9}, {0xda,0xac}, {0xa5,0xd0}, {0xa5,0xd1}, {0xa5,0xd2}, {0xa5,0xd3},
    {0x9d,0xf4}, {0x89,0x6d}, {0xa8,0x6b}, {0xa8,0x6c}, {0xcb,0x6e}, {0xcb,0x6d}, {0x9c,0x7b}, {0xaa,0xb6}, {0xcd,0x72}, {0xcd,0x70},
    {0xcd,0x71}, {0x98,0xd2}, {0x9f,0xa9}, {0xcf,0xda}, {0xcf,0xdb}, {0xfe,0xb2}, {0xac,0xcb}, {0xac,0xc9}, {0xfe,0xb1}, {0xac,0xca},
    {0xac,0xc8}, {0x97,0xd9}, {0xa0,0xc4}, {0xaf,0x60}, {0x94,0x76}, {0xaf,0x64}, {0xaf,0x63}, {0xd2,0xc1}, {0xaf,0x62}, {0xaf,0x61},
    {0xd2,0xc2}, {0x99,0x78}, {0xb2,0xa6}, {0xd6,0x7b}, {0xd6,0x7a}, {0xb2,0xa4}, {0xb2,0xa5}, {0xfe,0xb3}, {0xb5,0x66}, {0xb5,0x65},
    {0xda,0xae}, {0x98,0xd3}, {0xfe,0xb4}, {0xda,0xad}, {0xb2,0xa7}, {0x98,0xd4}, {0xb7,0xed}, {0xde,0xc5}, {0xb7,0xee}, {0xde,0xc4},
    {0x9f,0xb9}, {0xe2,0xd8}, {0xe6,0xae}, {0xbd,0x42}, {0xea,0x6a}, {0x94,0x71}, {0xed,0x73}, {0xc3,0xa6}, {0xc3,0xa5}, {0xc5,0x7c},
    {0xa5,0xd4}, {0xcd,0x73}, {0x98,0xd5}, {0xfe,0xb8}, {0xb2,0xa8}, {0xe2,0xd9}, {0xba,0xc3}, {0xc6,0xd4}, {0xcb,0x6f}, {0xcb,0x70},
    {0xcd,0x74}, {0xaa,0xb8}, {0xaa,0xb9}, {0xaa,0xb7}, {0xfe,0xba}, {0xac,0xcf}, {0xac,0xd0}, {0xac,0xcd}, {0xac,0xce}, {0xcf,0xdc},
    {0xcf,0xdd}, {0xac,0xcc}, {0xd2,0xc3}, {0x9e,0x5c}, {0xaf,0x68}, {0xaf,0x69}, {0xfe,0xbb}, {0xb2,0xab}, {0xd2,0xc9}, {0xaf,0x6e},
    {0xaf,0x6c}, {0xd2,0xca}, {0xd2,0xc5}, {0xaf,0x6b}, {0xaf,0x6a}, {0xaf,0x65}, {0xd2,0xc8}, {0xd2,0xc7}, {0xd2,0xc4}, {0xaf,0x6d},
    {0xa0,0x44}, {0xd2,0xc6}, {0xaf,0x66}, {0xaf,0x67}, {0x98,0xd7}, {0xb2,0xac}, {0xd6,0xa1}, {0xd6,0xa2}, {0xb2,0xad}, {0xd6,0x7c},
    {0xd6,0x7e}, {0xd6,0xa4}, {0xd6,0xa3}, {0xd6,0x7d}, {0xb2,0xa9}, {0xb2,0xaa}, {0xda,0xb6}, {0xb5,0x6b}, {0xb5,0x6a}, {0xda,0xb0},
    {0xb5,0x68}, {0x98,0xd8}, {0xda,0xb3}, {0xb5,0x6c}, {0xda,0xb4}, {0xb5,0x6d}, {0xda,0xb1}, {0xb5,0x67}, {0xb5,0x69}, {0xda,0xb5},
    {0xda,0xb2}, {0xda,0xaf}, {0xde,0xd2}, {0xde,0xc7}, {0xb7,0xf0}, {0xb7,0xf3}, {0xb7,0xf2}, {0xb7,0xf7}, {0xb7,0xf6}, {0xde,0xd3},
    {0xde,0xd1}, {0xde,0xca}, {0xde,0xce}, {0xde,0xcd}, {0xb7,0xf4}, {0xde,0xd0}, {0xde,0xcc}, {0xde,0xd4}, {0xde,0xcb}, {0xb7,0xf5},
    {0xb7,0xef}, {0xb7,0xf1}, {0xfe,0xbc}, {0xde,0xc9}, {0x9f,0xfe}, {0xe2,0xdb}, {0xba,0xc7}, {0xe2,0xdf}, {0xba,0xc6}, {0xe2,0xdc},
    {0xba,0xc5}, {0xde,0xc8}, {0xde,0xcf}, {0xe2,0xde}, {0xba,0xc8}, {0xe2,0xe0}, {0xe2,0xdd}, {0xe2,0xda}, {0xe6,0xb1}, {0xe6,0xb5},
    {0xe6,0xb7}, {0xe6,0xb3}, {0xe6,0xb2}, {0xe6,0xb0}, {0xbd,0x45}, {0xbd,0x43}, {0xbd,0x48}, {0xbd,0x49}, {0xe6,0xb4}, {0xbd,0x46},
    {0xe6,0xaf}, {0xbd,0x47}, {0xba,0xc4}, {0xe6,0xb6}, {0xbd,0x44}, {0xfe,0xbd}, {0xea,0x6c}, {0xea,0x6b}, {0xea,0x73}, {0xea,0x6d},
    {0xea,0x72}, {0xea,0x6f}, {0xbf,0x60}, {0xea,0x71}, {0xbf,0x61}, {0xbf,0x62}, {0x9d,0xdd}, {0xea,0x70}, {0xea,0x6e}, {0x9e,0xe1},
    {0xc0,0xf8}, {0xed,0x74}, {0xc0,0xf7}, {0xed,0x77}, {0xed,0x75}, {0xed,0x76}, {0xc0,0xf9}, {0x98,0xda}, {0x9d,0xdf}, {0xfe,0xbf},
    {0xf0,0x4d}, {0xfe,0xbe}, {0xc2,0xa1}, {0xf0,0x4e}, {0x9e,0xeb}, {0xc2,0x7d}, {0xf0,0x4f}, {0xc2,0x7e}, {0xf0,0x4c}, {0xf0,0x50},
    {0xf0,0x4a}, {0xc3,0xa7}, {0xf2,0x78}, {0xc3,0xa8}, {0xc4,0x6f}, {0xf0,0x4b}, {0xc4,0x70}, {0x9e,0x59}, {0xa0,0x5c}, {0xc4,0xee},
    {0xf5,0xdf}, {0xc5,0x7e}, {0xf6,0xf4}, {0xc5,0x7d}, {0xfe,0xc0}, {0xf7,0xea}, {0xc5,0xf5}, {0xc5,0xf6}, {0x94,0x77}, {0x98,0xdc},
    {0xf9,0xcc}, {0xfe,0xc1}, {0xac,0xd1}, {0xcf,0xde}, {0x98,0xde}, {0xb5,0x6e}, {0xb5,0x6f}, {0xa5,0xd5}, {0xa6,0xca}, {0xca,0x47},
    {0xcb,0x71}, {0xa8,0x6d}, {0xaa,0xba}, {0xac,0xd2}, {0xac,0xd3}, {0xac,0xd4}, {0xd6,0xa6}, {0xd2,0xcb}, {0xaf,0x6f}, {0xb2,0xae},
    {0xd6,0xa5}, {0xfe,0xc3}, {0xda,0xb8}, {0xb5,0x71}, {0xda,0xb7}, {0xb5,0x70}, {0xde,0xd5}, {0xbd,0x4a}, {0xe6,0xbb}, {0xe6,0xb8},
    {0xe6,0xb9}, {0xe6,0xba}, {0xfe,0xc8}, {0xed,0x78}, {0xfe,0xc9}, {0xf0,0x51}, {0xf4,0x71}, {0xf4,0x70}, {0xf6,0xf5}, {0xa5,0xd6},
    {0xcd,0x75}, {0xaf,0x70}, {0xb5,0x72}, {0xde,0xd6}, {0xfe,0xca}, {0xe2,0xe1}, {0xbd,0x4b}, {0xea,0x74}, {0xf0,0x52}, {0xf4,0x72},
    {0xa5,0xd7}, {0xaa,0xbb}, {0xac,0xd7}, {0xcf,0xdf}, {0xac,0xd8}, {0xac,0xd6}, {0xac,0xd5}, {0xd2,0xcc}, {0xaf,0x71}, {0xfe,0xcb},
    {0xaf,0x72}, {0xaf,0x73}, {0xb2,0xb0}, {0xd6,0xa7}, {0xb2,0xaf}, {0x9f,0xc2}, {0x8c,0x6b}, {0xda,0xb9}, {0xb2,0xb1}, {0xb5,0x73},
    {0xde,0xd7}, {0xb7,0xf8}, {0xb7,0xf9}, {0xba,0xc9}, {0xba,0xca}, {0xbd,0x4c}, {0xbf,0x64}, {0xea,0x75}, {0xbf,0x63}, {0xed,0x79},
    {0xc0,0xfa}, {0xf0,0x53}, {0xf4,0x73}, {0xa5,0xd8}, {0xa8,0x6e}, {0xcd,0x78}, {0xcd,0x77}, {0xaa,0xbc}, {0xcd,0x76}, {0xaa,0xbd},
    {0xcd,0x79}, {0xcf,0xe5}, {0xac,0xdb}, {0xac,0xda}, {0xcf,0xe7}, {0xcf,0xe6}, {0xac,0xdf}, {0xac,0xde}, {0xac,0xd9}, {0xcf,0xe1},
    {0xcf,0xe2}, {0xcf,0xe3}, {0xac,0xe0}, {0xcf,0xe0}, {0xac,0xdc}, {0xcf,0xe4}, {0xac,0xdd}, {0x98,0xc4}, {0x94,0xb0}, {0x94,0xb1},
    {0xd2,0xcf}, {0xd2,0xd3}, {0xd2,0xd1}, {0xd2,0xd0}, {0xd2,0xd4}, {0xd2,0xd5}, {0xd2,0xd6}, {0xd2,0xce}, {0xd2,0xcd}, {0xfe,0xd1},
    {0xaf,0x75}, {0xaf,0x76}, {0xd2,0xd7}, {0xd2,0xd2}, {0xa0,0xc1}, {0xd6,0xb0}, {0xfe,0xd2}, {0xd2,0xd8}, {0xaf,0x77}, {0xaf,0x74},
    {0xa0,0xcd}, {0xd6,0xaa}, {0xd6,0xa9}, {0xd6,0xab}, {0xd6,0xac}, {0xd6,0xae}, {0xd6,0xad}, {0xd6,0xb2}, {0xb2,0xb5}, {0xb2,0xb2},
    {0xb2,0xb6}, {0xd6,0xa8}, {0xb2,0xb7}, {0xd6,0xb1}, {0xb2,0xb4}, {0xd6,0xaf}, {0xb2,0xb3}, {0xfe,0xd3}, {0x98,0xe5}, {0xda,0xbc},
    {0xda,0xbe}, {0xda,0xba}, {0xda,0xbb}, {0xda,0xbf}, {0xda,0xc1}, {0xda,0xc2}, {0xda,0xbd}, {0xda,0xc0}, {0xb5,0x74}, {0xde,0xdb},
    {0xde,0xe0}, {0xde,0xd8}, {0xde,0xdc}, {0xfe,0xd6}, {0xde,0xe1}, {0xde,0xdd}, {0xb7,0xfa}, {0xb8,0x43}, {0xb7,0xfd}, {0xde,0xd9},
    {0xde,0xda}, {0xba,0xce}, {0xb8,0x46}, {0xb7,0xfe}, {0xb8,0x44}, {0xb7,0xfc}, {0xde,0xdf}, {0xb8,0x45}, {0xde,0xde}, {0xb8,0x41},
    {0xb7,0xfb}, {0xb8,0x42}, {0xde,0xe2}, {0xe2,0xe6}, {0xe2,0xe8}, {0x91,0xe4}, {0x8f,0xc7}, {0x94,0xae}, {0xb8,0x40}, {0x8a,0x4f},
    {0x94,0xb2}, {0xe2,0xe3}, {0xba,0xcc}, {0xe2,0xe9}, {0xba,0xcd}, {0xe2,0xe7}, {0xe2,0xe2}, {0xe2,0xe5}, {0xe2,0xea}, {0xba,0xcb},
    {0xe2,0xe4}, {0xbd,0x4e}, {0xe6,0xbf}, {0xe6,0xbe}, {0xbd,0x51}, {0xbd,0x4f}, {0xe6,0xbc}, {0xbd,0x4d}, {0xe6,0xbd}, {0xbd,0x50},
    {0x8f,0xd4}, {0xea,0x7d}, {0xea,0xa1}, {0x98,0xea}, {0xea,0x7e}, {0xea,0x76}, {0xea,0x7a}, {0xea,0x79}, {0xea,0x77}, {0xbf,0x66},
    {0xbf,0x67}, {0xbf,0x65}, {0xea,0x78}, {0xea,0x7b}, {0xea,0x7c}, {0xbf,0x68}, {0xc1,0x40}, {0xed,0xa3}, {0xc0,0xfc}, {0xed,0x7b},
    {0xc0,0xfe}, {0xc1,0x41}, {0xfe,0xd8}, {0xc0,0xfd}, {0xed,0xa2}, {0xed,0x7c}, {0xc0,0xfb}, {0xed,0xa1}, {0xed,0x7a}, {0xed,0x7e},
    {0xed,0x7d}, {0x9d,0xe0}, {0xf0,0x55}, {0xc2,0xa4}, {0xc2,0xa5}, {0xc2,0xa2}, {0x98,0xee}, {0xc2,0xa3}, {0xf0,0x54}, {0x95,0xc4},
    {0xf2,0x7b}, {0xfc,0xe8}, {0xc3,0xa9}, {0xf2,0x79}, {0xf2,0x7a}, {0x98,0xef}, {0xf4,0x74}, {0xf4,0x77}, {0xf4,0x75}, {0xf4,0x76},
    {0xf5,0xe0}, {0xc4,0xef}, {0xf7,0xeb}, {0xf8,0xb4}, {0xc5,0xf7}, {0xf8,0xf8}, {0xf8,0xf9}, {0xc6,0x66}, {0xa5,0xd9}, {0xac,0xe1},
    {0x8c,0x6e}, {0xda,0xc3}, {0xde,0xe3}, {0xa5,0xda}, {0xa8,0x6f}, {0xaa,0xbe}, {0xfa,0xd8}, {0xcf,0xe8}, {0xcf,0xe9}, {0xaf,0x78},
    {0xda,0xc4}, {0xb5,0x75}, {0xb8,0x47}, {0xc1,0x42}, {0xed,0xa4}, {0xf2,0x7c}, {0xf4,0x78}, {0xa5,0xdb}, {0xfe,0xdc}, {0xcd,0xa1},
    {0xcd,0x7a}, {0xcd,0x7c}, {0xcd,0x7e}, {0xcd,0x7d}, {0xcd,0x7b}, {0xaa,0xbf}, {0xa0,0xae}, {0xac,0xe2}, {0xcf,0xf2}, {0xcf,0xed},
    {0xcf,0xea}, {0x9d,0x4c}, {0xcf,0xf1}, {0xac,0xe4}, {0xac,0xe5}, {0xcf,0xf0}, {0xcf,0xef}, {0xcf,0xee}, {0xcf,0xeb}, {0xcf,0xec},
    {0xcf,0xf3}, {0xac,0xe3}, {0x98,0xf1}, {0x98,0xf3}, {0xaf,0x7c}, {0x94,0xc1}, {0xaf,0xa4}, {0xaf,0xa3}, {0xd2,0xe1}, {0xd2,0xdb},
    {0xd2,0xd9}, {0xaf,0xa1}, {0xd6,0xb9}, {0xaf,0x7a}, {0xd2,0xde}, {0xd2,0xe2}, {0xd2,0xe4}, {0xd2,0xe0}, {0xd2,0xda}, {0xaf,0xa2},
    {0xd2,0xdf}, {0xd2,0xdd}, {0xaf,0x79}, {0xd2,0xe5}, {0xaf,0xa5}, {0xd2,0xe3}, {0xaf,0x7d}, {0xd2,0xdc}, {0xaf,0x7e}, {0xaf,0x7b},
    {0x98,0xf5}, {0xfa,0x4f}, {0x96,0xe2}, {0x94,0x50}, {0xb2,0xb9}, {0x96,0xa2}, {0xd6,0xba}, {0x98,0xf6}, {0xd6,0xb3}, {0xd6,0xb5},
    {0xd6,0xb7}, {0x96,0xe5}, {0xd6,0xb8}, {0xd6,0xb6}, {0xb2,0xba}, {0xd6,0xbb}, {0x98,0xf7}, {0xd6,0xb4}, {0xa0,0x46}, {0x96,0xe3},
    {0xda,0xc8}, {0xb5,0x76}, {0xda,0xd0}, {0xda,0xc5}, {0xda,0xd1}, {0xda,0xc6}, {0xda,0xc7}, {0x98,0xf8}, {0xda,0xcf}, {0xda,0xce},
    {0xda,0xcb}, {0xb2,0xb8}, {0xb5,0x77}, {0xda,0xc9}, {0xda,0xcc}, {0xb5,0x78}, {0xda,0xcd}, {0xda,0xca}, {0xde,0xee}, {0x9e,0xe4},
    {0xde,0xf2}, {0xb8,0x4e}, {0xe2,0xf0}, {0xb8,0x51}, {0xde,0xf0}, {0xf9,0xd6}, {0xde,0xed}, {0xde,0xe8}, {0xde,0xea}, {0xde,0xeb},
    {0xde,0xe4}, {0x94,0xc3}, {0xb8,0x4d}, {0xb8,0x4c}, {0x94,0xc2}, {0xb8,0x48}, {0xde,0xe7}, {0xb8,0x4f}, {0xb8,0x50}, {0xde,0xe6},
    {0xde,0xe9}, {0xde,0xf1}, {0xb8,0x4a}, {0xb8,0x4b}, {0xde,0xef}, {0xde,0xe5}, {0xe2,0xf2}, {0xba,0xd0}, {0xe2,0xf4}, {0xde,0xec},
    {0xe2,0xf6}, {0xba,0xd4}, {0xe2,0xf7}, {0xe2,0xf3}, {0xba,0xd1}, {0xe2,0xef}, {0xba,0xd3}, {0xe2,0xec}, {0xe2,0xf1}, {0xe2,0xf5},
    {0xe2,0xee}, {0xfe,0xe1}, {0xb8,0x49}, {0xfe,0xe9}, {0xe2,0xeb}, {0xba,0xd2}, {0xe2,0xed}, {0x96,0xe4}, {0x89,0xac}, {0x96,0xdb},
    {0xbd,0x54}, {0xe6,0xc1}, {0xbd,0x58}, {0xbd,0x56}, {0xba,0xcf}, {0xe6,0xc8}, {0xe6,0xc9}, {0xbd,0x53}, {0xfe,0xe2}, {0xe6,0xc7},
    {0xe6,0xca}, {0xbd,0x55}, {0xbd,0x52}, {0xe6,0xc3}, {0xe6,0xc0}, {0xe6,0xc5}, {0xe6,0xc2}, {0xbd,0x59}, {0xe6,0xc4}, {0x94,0xc4},
    {0xfe,0xe3}, {0xe6,0xc6}, {0xbd,0x57}, {0xfe,0xe7}, {0x9f,0xfb}, {0xbf,0x6a}, {0xea,0xa8}, {0xea,0xa2}, {0xea,0xa6}, {0xea,0xac},
    {0xea,0xad}, {0xea,0xa9}, {0xea,0xaa}, {0xea,0xa7}, {0x8c,0x59}, {0xea,0xa4}, {0xbf,0x6c}, {0xbf,0x69}, {0xea,0xa3}, {0xea,0xa5},
    {0xbf,0x6b}, {0xea,0xab}, {0x93,0xc9}, {0xc1,0x46}, {0x94,0xe8}, {0xfb,0x56}, {0xed,0xaa}, {0xed,0xa5}, {0xc1,0x45}, {0x90,0xc5},
    {0xc1,0x43}, {0xed,0xac}, {0xc1,0x44}, {0xed,0xa8}, {0xed,0xa9}, {0xed,0xa6}, {0xed,0xad}, {0xf0,0x56}, {0xc1,0x47}, {0xed,0xa7},
    {0xed,0xae}, {0xed,0xab}, {0xa0,0xa8}, {0xf0,0x5a}, {0xf0,0x57}, {0xc2,0xa6}, {0xf0,0x5b}, {0xf0,0x5d}, {0xf0,0x5c}, {0xf0,0x58},
    {0xf0,0x59}, {0xf2,0xa3}, {0xc3,0xaa}, {0xf2,0x7e}, {0xf2,0xa2}, {0xf2,0x7d}, {0xf2,0xa4}, {0xf2,0xa1}, {0xf4,0x7a}, {0xf4,0x7d},
    {0xf4,0x79}, {0xc4,0x71}, {0xf4,0x7b}, {0xf4,0x7c}, {0xf4,0x7e}, {0xc4,0x72}, {0xc4,0x74}, {0xc4,0x73}, {0xf5,0xe1}, {0xfe,0xe5},
    {0xf5,0xe3}, {0xf5,0xe2}, {0x98,0xfd}, {0x98,0xfb}, {0xfe,0xe8}, {0xf6,0xf6}, {0x8e,0xbf}, {0xf8,0xb5}, {0xf8,0xfa}, {0xa5,0xdc},
    {0x8b,0xd8}, {0xfe,0xf7}, {0xcb,0x72}, {0xaa,0xc0}, {0xcd,0xa3}, {0xaa,0xc1}, {0xaa,0xc2}, {0xcd,0xa2}, {0xcf,0xf8}, {0xcf,0xf7},
    {0xac,0xe6}, {0xac,0xe9}, {0xac,0xe8}, {0xac,0xe7}, {0xcf,0xf4}, {0xcf,0xf6}, {0xcf,0xf5}, {0xd2,0xe8}, {0xaf,0xa7}, {0xd2,0xec},
    {0xd2,0xeb}, {0xd2,0xea}, {0xd2,0xe6}, {0xaf,0xa6}, {0xaf,0xaa}, {0xaf,0xad}, {0x8f,0x68}, {0x94,0xc6}, {0xaf,0xae}, {0xd2,0xe7},
    {0xd2,0xe9}, {0xaf,0xac}, {0xaf,0xab}, {0xaf,0xa9}, {0xaf,0xa8}, {0xd6,0xc2}, {0x9d,0xea}, {0xd6,0xc0}, {0xd6,0xbc}, {0xb2,0xbb},
    {0xd6,0xbd}, {0xb2,0xbc}, {0xd6,0xbe}, {0xd6,0xbf}, {0xd6,0xc1}, {0xb2,0xbd}, {0xda,0xd5}, {0xfc,0x69}, {0xda,0xd4}, {0xda,0xd3},
    {0xda,0xd2}, {0xde,0xf6}, {0xb8,0x52}, {0xde,0xf3}, {0xde,0xf5}, {0x9c,0xda}, {0xb8,0x53}, {0xfe,0xf3}, {0xb8,0x54}, {0xde,0xf4},
    {0x9c,0x72}, {0xfe,0xf0}, {0x89,0xc9}, {0xe3,0x41}, {0xe2,0xf9}, {0xe2,0xfa}, {0xba,0xd7}, {0xba,0xd5}, {0xba,0xd6}, {0xe3,0x43},
    {0x99,0x41}, {0xe3,0x42}, {0xe2,0xfe}, {0xe2,0xfd}, {0xe2,0xfc}, {0xe2,0xfb}, {0xe3,0x40}, {0xe2,0xf8}, {0x99,0x42}, {0xe6,0xcb},
    {0xe6,0xd0}, {0xe6,0xce}, {0xfe,0xf5}, {0x91,0xd7}, {0xe6,0xcd}, {0xe6,0xcc}, {0xe6,0xcf}, {0xea,0xae}, {0x94,0xcc}, {0xbf,0x6d},
    {0xc1,0x48}, {0xed,0xb0}, {0xfe,0xf8}, {0xc1,0x49}, {0xed,0xaf}, {0xf0,0x5f}, {0xf0,0x5e}, {0xc2,0xa7}, {0xf2,0xa5}, {0xc3,0xab},
    {0xf4,0xa1}, {0xc5,0xa1}, {0xf6,0xf7}, {0xf8,0xb7}, {0xf8,0xb6}, {0xc9,0xa8}, {0xac,0xea}, {0xac,0xeb}, {0xd6,0xc3}, {0xb8,0x56},
    {0xa5,0xdd}, {0xa8,0x72}, {0xa8,0x71}, {0xa8,0x70}, {0x97,0xa8}, {0xcd,0xa4}, {0xfe,0xfc}, {0xaa,0xc4}, {0xaa,0xc3}, {0xac,0xee},
    {0xfd,0xbf}, {0xcf,0xfa}, {0xcf,0xfd}, {0xcf,0xfb}, {0xac,0xec}, {0xac,0xed}, {0xfe,0xfe}, {0xcf,0xf9}, {0xcf,0xfc}, {0xaf,0xb5},
    {0xd2,0xf3}, {0xd2,0xf5}, {0xd2,0xf4}, {0xaf,0xb2}, {0xd2,0xef}, {0x96,0xd1}, {0xaf,0xb0}, {0xaf,0xaf}, {0xaf,0xb3}, {0xaf,0xb1},
    {0xaf,0xb4}, {0xd2,0xf2}, {0xd2,0xed}, {0xd2,0xee}, {0xd2,0xf1}, {0xd2,0xf0}, {0x94,0xd5}, {0x94,0xd0}, {0xd6,0xc6}, {0xd6,0xc7},
    {0xd6,0xc5}, {0xd6,0xc4}, {0xb2,0xbe}, {0xb5,0x7d}, {0xda,0xd6}, {0xda,0xd8}, {0xda,0xda}, {0xb5,0x7c}, {0x99,0x44}, {0xb5,0x7a},
    {0xda,0xd7}, {0xb5,0x7b}, {0xda,0xd9}, {0xb5,0x79}, {0xdf,0x41}, {0xde,0xf7}, {0xde,0xfa}, {0xde,0xfe}, {0xb8,0x5a}, {0xde,0xfc},
    {0xde,0xfb}, {0xde,0xf8}, {0xde,0xf9}, {0xb8,0x58}, {0xdf,0x40}, {0xb8,0x57}, {0xb8,0x5c}, {0xb8,0x5b}, {0xb8,0x59}, {0xde,0xfd},
    {0xe3,0x49}, {0xe3,0x48}, {0x8c,0x63}, {0xe3,0x44}, {0xa0,0xb3}, {0xba,0xd8}, {0xe3,0x47}, {0xe3,0x46}, {0xba,0xd9}, {0xbd,0x5e},
    {0xe6,0xd2}, {0x94,0xcf}, {0xbd,0x5f}, {0xbd,0x5b}, {0xbd,0x5d}, {0x9f,0xfa}, {0xbd,0x5a}, {0xbd,0x5c}, {0x91,0xe5}, {0xea,0xaf},
    {0x9c,0x6a}, {0xbf,0x70}, {0xea,0xb1}, {0xea,0xb0}, {0x8e,0x49}, {0xe3,0x45}, {0xbf,0x72}, {0xbf,0x71}, {0xbf,0x6e}, {0xbf,0x6f},
    {0xed,0xb5}, {0xed,0xb3}, {0xc1,0x4a}, {0xed,0xb4}, {0xed,0xb6}, {0xed,0xb2}, {0xed,0xb1}, {0xf0,0x60}, {0xc2,0xaa}, {0xc2,0xa8},
    {0xc2,0xa9}, {0x8e,0x4c}, {0xf2,0xa6}, {0xf2,0xa7}, {0xc3,0xad}, {0xc3,0xac}, {0xf4,0xa3}, {0xf4,0xa4}, {0xf4,0xa2}, {0xf6,0xf8},
    {0xf6,0xf9}, {0xa5,0xde}, {0xca,0x48}, {0xa8,0x73}, {0xcd,0xa5}, {0xaa,0xc6}, {0xaa,0xc5}, {0xcd,0xa6}, {0x8e,0x4d}, {0xd0,0x40},
    {0xac,0xef}, {0xcf,0xfe}, {0xac,0xf0}, {0x9a,0x73}, {0xaf,0xb6}, {0xd2,0xf8}, {0xd2,0xf6}, {0xd2,0xfc}, {0xaf,0xb7}, {0xd2,0xf7},
    {0xd2,0xfb}, {0xd2,0xf9}, {0xd2,0xfa}, {0xd6,0xc8}, {0xd6,0xca}, {0x99,0x47}, {0xb2,0xbf}, {0x8c,0xb1}, {0xd6,0xc9}, {0xb2,0xc0},
    {0xb5,0xa2}, {0xb5,0xa1}, {0xb5,0x7e}, {0xda,0xdb}, {0xdf,0x44}, {0xb8,0x5d}, {0xb8,0x5e}, {0xdf,0x43}, {0xdf,0x42}, {0xe3,0x4a},
    {0xba,0xdb}, {0xba,0xda}, {0xe3,0x4b}, {0xe3,0x4c}, {0xbd,0x61}, {0xbd,0x60}, {0x8e,0x50}, {0xea,0xb5}, {0xe6,0xd3}, {0xe6,0xd5},
    {0xe6,0xd4}, {0xea,0xb4}, {0xea,0xb2}, {0xea,0xb6}, {0xea,0xb3}, {0xbf,0x73}, {0x8e,0x4f}, {0x99,0x49}, {0xed,0xb7}, {0xc1,0x4b},
    {0xed,0xb8}, {0xed,0xb9}, {0x8e,0x51}, {0x8e,0x52}, {0xc2,0xab}, {0xc2,0xac}, {0xc4,0x75}, {0x9a,0xb2}, {0x89,0xa5}, {0xc5,0xd1},
    {0xa5,0xdf}, {0x99,0x4c}, {0xd0,0x41}, {0x9f,0xf8}, {0xd2,0xfd}, {0xaf,0xb8}, {0x8e,0x56}, {0x99,0x4d}, {0x91,0xca}, {0x8e,0x57},
    {0xb3,0xba}, {0xb3,0xb9}, {0x94,0xe1}, {0xb5,0xa4}, {0xda,0xdd}, {0xb5,0xa3}, {0xda,0xdc}, {0x90,0x47}, {0x8f,0xd8}, {0x8e,0x58},
    {0xdf,0x45}, {0xba,0xdc}, {0xe3,0x4d}, {0xba,0xdd}, {0xc4,0x76}, {0xf4,0xa5}, {0xa6,0xcb}, {0xaa,0xc7}, {0xcd,0xa7}, {0xac,0xf2},
    {0x94,0xeb}, {0xac,0xf1}, {0xd0,0x42}, {0xd0,0x43}, {0xd3,0x40}, {0xd3,0x42}, {0xaf,0xb9}, {0xd3,0x44}, {0xd3,0x47}, {0xd3,0x45},
    {0x8e,0x5c}, {0x95,0x53}, {0xd3,0x46}, {0xd3,0x43}, {0xd2,0xfe}, {0xaf,0xba}, {0xd3,0x48}, {0xd3,0x41}, {0x9f,0xe5}, {0xd6,0xd3},
    {0xb2,0xc6}, {0xd6,0xdc}, {0xb2,0xc3}, {0xd6,0xd5}, {0xb2,0xc7}, {0x9f,0x56}, {0xb2,0xc1}, {0xd6,0xd0}, {0xd6,0xdd}, {0xd6,0xd1},
    {0xd6,0xce}, {0xb2,0xc5}, {0x95,0x4f}, {0xb2,0xc2}, {0x8e,0x5e}, {0xd6,0xd4}, {0xd6,0xd7}, {0xb2,0xc4}, {0xd6,0xd8}, {0xb2,0xc8},
    {0xd6,0xd9}, {0xd6,0xcf}, {0xd6,0xd6}, {0xd6,0xda}, {0xd6,0xd2}, {0xd6,0xcd}, {0xd6,0xcb}, {0xd6,0xdb}, {0x99,0x6a}, {0xda,0xdf},
    {0xda,0xe4}, {0x9c,0x64}, {0x9c,0xd9}, {0xda,0xe0}, {0xda,0xe6}, {0xb5,0xa7}, {0xd6,0xcc}, {0xda,0xe1}, {0xb5,0xa5}, {0xda,0xde},
    {0xb5,0xac}, {0xda,0xe2}, {0xb5,0xab}, {0xda,0xe3}, {0xb5,0xad}, {0xb5,0xa8}, {0xb5,0xae}, {0xb5,0xa9}, {0xb5,0xaa}, {0x8e,0x5d},
    {0xb5,0xa6}, {0xda,0xe5}, {0xb8,0x61}, {0xdf,0x50}, {0x99,0x50}, {0xdf,0x53}, {0xdf,0x47}, {0xdf,0x4c}, {0xdf,0x46}, {0xb8,0x63},
    {0xdf,0x4a}, {0x99,0x51}, {0xdf,0x48}, {0xb8,0x62}, {0x8e,0x62}, {0xdf,0x4f}, {0xdf,0x4e}, {0xdf,0x4b}, {0xdf,0x4d}, {0xdf,0x49},
    {0xba,0xe1}, {0xdf,0x52}, {0xb8,0x5f}, {0xdf,0x51}, {0x99,0x52}, {0xe3,0x5d}, {0xba,0xe8}, {0xe3,0x58}, {0xba,0xe7}, {0xe3,0x4e},
    {0xe3,0x50}, {0xba,0xe0}, {0xe3,0x55}, {0xe3,0x54}, {0xe3,0x57}, {0xba,0xe5}, {0xe3,0x52}, {0xe3,0x51}, {0x8e,0x68}, {0xba,0xe4},
    {0xba,0xdf}, {0xe3,0x53}, {0xba,0xe2}, {0xe3,0x59}, {0xe3,0x5b}, {0xe3,0x56}, {0xe3,0x4f}, {0xba,0xe3}, {0xbd,0x69}, {0xba,0xde},
    {0x8e,0x61}, {0x9f,0x59}, {0xe3,0x5c}, {0xe6,0xd9}, {0xbd,0x62}, {0xe6,0xdb}, {0xbd,0x63}, {0x8b,0xb3}, {0xbd,0x65}, {0xe6,0xde},
    {0xe6,0xd6}, {0xba,0xe6}, {0xe6,0xdc}, {0xe6,0xd8}, {0xb8,0x60}, {0xbd,0x68}, {0xbd,0x64}, {0xbd,0x66}, {0xbd,0x67}, {0xbf,0x76},
    {0xe6,0xdd}, {0xe6,0xd7}, {0xbd,0x6a}, {0xe6,0xda}, {0x9f,0x5d}, {0x8e,0x66}, {0xea,0xc0}, {0xea,0xbb}, {0xea,0xc5}, {0xbf,0x74},
    {0xea,0xbd}, {0xbf,0x78}, {0xea,0xc3}, {0xea,0xba}, {0xea,0xb7}, {0xea,0xc6}, {0xc1,0x51}, {0xbf,0x79}, {0xea,0xc2}, {0xea,0xb8},
    {0xbf,0x77}, {0xea,0xbc}, {0xbf,0x7b}, {0xea,0xb9}, {0xea,0xbe}, {0xbf,0x7a}, {0xea,0xc1}, {0xea,0xc4}, {0x8c,0xb2}, {0xed,0xcb},
    {0xed,0xcc}, {0xed,0xbc}, {0xed,0xc3}, {0xed,0xc1}, {0xc1,0x4f}, {0xed,0xc8}, {0xea,0xbf}, {0x8e,0x6e}, {0xed,0xbf}, {0x9f,0x64},
    {0xed,0xc9}, {0xc1,0x4e}, {0xed,0xbe}, {0xed,0xbd}, {0xed,0xc7}, {0xed,0xc4}, {0xed,0xc6}, {0xed,0xba}, {0xed,0xca}, {0xc1,0x4c},
    {0xed,0xc5}, {0xed,0xce}, {0xed,0xc2}, {0xc1,0x50}, {0xc1,0x4d}, {0xed,0xc0}, {0xed,0xbb}, {0xed,0xcd}, {0xbf,0x75}, {0x99,0x53},
    {0xfa,0xb8}, {0xf0,0x63}, {0x99,0x54}, {0xf0,0x61}, {0xf0,0x67}, {0xc2,0xb0}, {0xf0,0x65}, {0xf0,0x64}, {0xc2,0xb2}, {0xf0,0x6a},
    {0xc2,0xb1}, {0xf0,0x6b}, {0xf0,0x68}, {0xc2,0xae}, {0xf0,0x69}, {0xf0,0x62}, {0xc2,0xaf}, {0xc2,0xad}, {0xf2,0xab}, {0xf0,0x66},
    {0xf0,0x6c}, {0xf2,0xa8}, {0x8e,0x70}, {0xc3,0xb2}, {0xc3,0xb0}, {0xf2,0xaa}, {0xf2,0xac}, {0xf2,0xa9}, {0xc3,0xb1}, {0xc3,0xae},
    {0xc3,0xaf}, {0xc3,0xb3}, {0x9f,0x61}, {0xc4,0x78}, {0x8e,0x72}, {0xf4,0xaa}, {0xf4,0xa9}, {0xf4,0xa7}, {0xf4,0xa6}, {0xf4,0xa8},
    {0xc4,0x77}, {0xc4,0x79}, {0xc4,0xf0}, {0xa0,0x6b}, {0xf5,0xe5}, {0xf5,0xe4}, {0x9f,0x40}, {0xf6,0xfa}, {0xf6,0xfc}, {0xf6,0xfe},
    {0xf6,0xfd}, {0xf6,0xfb}, {0x94,0xed}, {0xc5,0xa3}, {0xc5,0xa2}, {0xc5,0xd3}, {0xc5,0xd2}, {0xc5,0xd4}, {0xf7,0xed}, {0xf7,0xec},
    {0xf8,0xfb}, {0xf8,0xb8}, {0xf8,0xfc}, {0xc6,0x58}, {0x94,0xee}, {0xc6,0x59}, {0xf9,0x6d}, {0x9f,0xbd}, {0xc6,0x7e}, {0xa6,0xcc},
    {0x8e,0x7b}, {0xcd,0xa8}, {0xd0,0x45}, {0xd0,0x46}, {0xd0,0x44}, {0x99,0x57}, {0x94,0xf7}, {0xac,0xf3}, {0x9f,0x5f}, {0xd0,0x47},
    {0xd0,0x48}, {0xd0,0x49}, {0x8e,0x73}, {0xd3,0x49}, {0xd3,0x4f}, {0x9f,0x62}, {0xd3,0x4d}, {0xaf,0xbb}, {0xd3,0x4b}, {0xd3,0x4c},
    {0xd3,0x4e}, {0x94,0xf6}, {0xd3,0x4a}, {0xb2,0xc9}, {0xd6,0xde}, {0xb2,0xcb}, {0xd6,0xe0}, {0xb2,0xca}, {0xd6,0xdf}, {0x99,0x58},
    {0xda,0xe8}, {0xb5,0xaf}, {0xda,0xea}, {0xda,0xe7}, {0xd6,0xe1}, {0xb5,0xb0}, {0x8e,0x75}, {0xf9,0xdb}, {0xda,0xe9}, {0x90,0x72},
    {0x94,0xf8}, {0xdf,0x56}, {0xb8,0x64}, {0xdf,0x54}, {0xb8,0x65}, {0xdf,0x55}, {0xb8,0x66}, {0x99,0x5a}, {0xba,0xe9}, {0xe3,0x61},
    {0xe3,0x5e}, {0xe3,0x60}, {0xba,0xea}, {0xba,0xeb}, {0xe3,0x5f}, {0xa0,0xb0}, {0x8c,0xb3}, {0xe6,0xdf}, {0x8e,0x79}, {0xe6,0xe0},
    {0x8e,0x78}, {0xbd,0x6b}, {0xe6,0xe2}, {0xe6,0xe1}, {0x94,0xf3}, {0xa2,0x61}, {0xea,0xca}, {0xea,0xcb}, {0xea,0xc7}, {0x98,0xaf},
    {0xea,0xc8}, {0xbf,0x7c}, {0xbf,0x7d}, {0xea,0xc9}, {0xc1,0x57}, {0xa0,0xb2}, {0xc1,0x53}, {0xc1,0x58}, {0xc1,0x54}, {0xc1,0x56},
    {0xc1,0x52}, {0xc1,0x55}, {0x8e,0x7a}, {0xc2,0xb3}, {0xed,0xcf}, {0xf2,0xae}, {0xf2,0xad}, {0x99,0x5c}, {0xf4,0xab}, {0xc4,0x7a},
    {0xc4,0x7b}, {0xf7,0x41}, {0xf5,0xe6}, {0x8e,0x7c}, {0xf7,0x40}, {0x8e,0x7d}, {0xf8,0xfd}, {0xf9,0xa4}, {0xa6,0xcd}, {0x8b,0xd9},
    {0xa8,0x74}, {0x89,0xa2}, {0xcd,0xa9}, {0xaa,0xc8}, {0xac,0xf6}, {0xd0,0x4c}, {0xac,0xf4}, {0xd0,0x4a}, {0xac,0xf9}, {0xac,0xf5},
    {0xac,0xfa}, {0xac,0xf8}, {0xd0,0x4b}, {0xac,0xf7}, {0xaf,0xbf}, {0xaf,0xbe}, {0xd3,0x5a}, {0xaf,0xc7}, {0xd3,0x53}, {0xd3,0x59},
    {0xaf,0xc3}, {0xd3,0x52}, {0xd3,0x58}, {0xd3,0x56}, {0xaf,0xc2}, {0xaf,0xc4}, {0xd3,0x55}, {0xaf,0xbd}, {0xd3,0x54}, {0xaf,0xc8},
    {0xaf,0xc5}, {0xaf,0xc9}, {0xaf,0xc6}, {0xd3,0x51}, {0xd3,0x50}, {0xd3,0x57}, {0xaf,0xc0}, {0xaf,0xbc}, {0xaf,0xc1}, {0x9e,0xd7},
    {0xd6,0xf0}, {0xd6,0xe9}, {0xb5,0xb5}, {0xd6,0xe8}, {0xb2,0xcf}, {0xb2,0xd6}, {0xb2,0xd3}, {0xb2,0xd9}, {0xb2,0xd8}, {0xb2,0xd4},
    {0xd6,0xe2}, {0xd6,0xe5}, {0xd6,0xe4}, {0xb2,0xd0}, {0xd6,0xe6}, {0xd6,0xef}, {0xb2,0xd1}, {0xd6,0xe3}, {0xd6,0xec}, {0xd6,0xed},
    {0xb2,0xd2}, {0xd6,0xea}, {0xb2,0xd7}, {0xb2,0xcd}, {0xb2,0xd5}, {0xd6,0xe7}, {0xb2,0xcc}, {0xd6,0xeb}, {0xd6,0xee}, {0xa0,0xb6},
    {0xda,0xfb}, {0xda,0xf2}, {0xb5,0xb2}, {0xda,0xf9}, {0xda,0xf6}, {0xda,0xee}, {0xda,0xf7}, {0xb5,0xb4}, {0xda,0xef}, {0xda,0xeb},
    {0x9e,0x42}, {0xb8,0x6c}, {0xda,0xf4}, {0x8e,0xa4}, {0xb5,0xb1}, {0xda,0xfa}, {0xb5,0xb8}, {0xb5,0xba}, {0xda,0xed}, {0xb5,0xb9},
    {0xda,0xf0}, {0xb5,0xb3}, {0xda,0xf8}, {0xda,0xf1}, {0xda,0xf5}, {0xda,0xf3}, {0xb5,0xb6}, {0xda,0xec}, {0xb5,0xbb}, {0xb2,0xce},
    {0xb5,0xb7}, {0xb5,0xbc}, {0xb8,0x68}, {0xdf,0x5d}, {0xdf,0x5f}, {0xdf,0x61}, {0xdf,0x65}, {0xdf,0x5b}, {0xdf,0x59}, {0xb8,0x6a},
    {0xdf,0x60}, {0xdf,0x64}, {0xdf,0x5c}, {0xdf,0x58}, {0xdf,0x57}, {0x8e,0xa7}, {0x8c,0x76}, {0xdf,0x62}, {0xdf,0x5a}, {0xdf,0x5e},
    {0xb8,0x6b}, {0xb8,0x69}, {0xdf,0x66}, {0xb8,0x67}, {0xdf,0x63}, {0xe3,0x72}, {0x95,0x42}, {0xba,0xee}, {0xe3,0x6a}, {0xbd,0x78},
    {0xe3,0x74}, {0xba,0xf1}, {0xe3,0x78}, {0xba,0xf7}, {0xe3,0x65}, {0x98,0x7d}, {0xe3,0x75}, {0xe3,0x62}, {0x97,0x55}, {0xe3,0x77},
    {0xe3,0x66}, {0x8e,0xa8}, {0xba,0xfe}, {0xba,0xfb}, {0xe3,0x76}, {0xe3,0x70}, {0xba,0xed}, {0xba,0xf5}, {0xba,0xf4}, {0x8e,0xaa},
    {0xba,0xf3}, {0xba,0xf9}, {0xe3,0x63}, {0xba,0xfa}, {0xe3,0x71}, {0xba,0xf6}, {0xba,0xec}, {0xe3,0x73}, {0xba,0xef}, {0xba,0xf0},
    {0xba,0xf8}, {0xe3,0x68}, {0xe3,0x67}, {0xe3,0x64}, {0xe3,0x6c}, {0xe3,0x69}, {0xe3,0x6d}, {0xba,0xfd}, {0xe3,0x79}, {0xba,0xf2},
    {0xe3,0x6e}, {0xe3,0x6f}, {0x89,0xa3}, {0xe3,0x6b}, {0x99,0x60}, {0x99,0x62}, {0xba,0xfc}, {0x94,0xfc}, {0x99,0x61}, {0xe6,0xe7},
    {0xbd,0x70}, {0xbd,0x79}, {0xbd,0x75}, {0xe6,0xe4}, {0x94,0xfa}, {0xbd,0x72}, {0xbd,0x76}, {0xe6,0xf0}, {0xbd,0x6c}, {0xe6,0xe8},
    {0xbd,0x74}, {0x8e,0xae}, {0x8e,0xb2}, {0xe6,0xeb}, {0xe6,0xe6}, {0xbd,0x73}, {0xbd,0x77}, {0xe6,0xe5}, {0xbd,0x71}, {0xe6,0xef},
    {0xbd,0x6e}, {0xe6,0xee}, {0xe6,0xed}, {0xbd,0x7a}, {0xe5,0x72}, {0xbd,0x6d}, {0x8e,0xb0}, {0xe6,0xec}, {0xe6,0xe3}, {0xbd,0x7b},
    {0xe6,0xea}, {0xbd,0x6f}, {0x99,0x63}, {0x97,0xaa}, {0xe6,0xe9}, {0x94,0xfb}, {0xbf,0xa2}, {0xbf,0xa7}, {0xbf,0x7e}, {0xea,0xd8},
    {0xea,0xcf}, {0xea,0xdb}, {0xea,0xd3}, {0xea,0xd9}, {0xbf,0xa8}, {0xbf,0xa1}, {0xea,0xcc}, {0xea,0xd2}, {0xea,0xdc}, {0xea,0xd5},
    {0xea,0xda}, {0xea,0xce}, {0xea,0xd6}, {0xbf,0xa3}, {0xea,0xd4}, {0xbf,0xa6}, {0xbf,0xa5}, {0xea,0xd0}, {0xea,0xd1}, {0xea,0xcd},
    {0xea,0xd7}, {0xbf,0xa4}, {0xea,0xde}, {0xea,0xdd}, {0x8e,0xbb}, {0xed,0xda}, {0xed,0xd6}, {0xc1,0x5f}, {0xed,0xd0}, {0xc1,0x59},
    {0xc1,0x69}, {0xed,0xdc}, {0xc1,0x61}, {0xc1,0x5d}, {0xed,0xd3}, {0xc1,0x64}, {0xc1,0x67}, {0xed,0xde}, {0xc1,0x5c}, {0xed,0xd5},
    {0xc1,0x65}, {0xed,0xe0}, {0xed,0xdd}, {0xed,0xd1}, {0xc1,0x60}, {0xc1,0x5a}, {0xc1,0x68}, {0xed,0xd8}, {0xc1,0x63}, {0xed,0xd2},
    {0xc1,0x5e}, {0xed,0xdf}, {0xc1,0x62}, {0xc1,0x5b}, {0xed,0xd9}, {0xc1,0x66}, {0xed,0xd7}, {0xed,0xdb}, {0xf0,0x6e}, {0xf0,0x74},
    {0xc2,0xb9}, {0xf0,0x77}, {0xc2,0xb4}, {0xc2,0xb5}, {0xf0,0x6f}, {0xf0,0x76}, {0xf0,0x71}, {0xc2,0xba}, {0xc2,0xb7}, {0x8c,0xdc},
    {0xf0,0x6d}, {0xc2,0xb6}, {0xf0,0x73}, {0xf0,0x75}, {0xc2,0xb8}, {0xf0,0x72}, {0xf0,0x70}, {0x98,0x76}, {0x8e,0xa1}, {0xf2,0xb8},
    {0xc3,0xb7}, {0xc3,0xb8}, {0xc3,0xb4}, {0x8c,0xb4}, {0xc3,0xb5}, {0x8e,0xb7}, {0xf2,0xb4}, {0xf2,0xb2}, {0xf2,0xb6}, {0xc3,0xba},
    {0xf2,0xb7}, {0xf2,0xb0}, {0xf2,0xaf}, {0xf2,0xb3}, {0xf2,0xb1}, {0xc3,0xb6}, {0xf2,0xb5}, {0xf4,0xac}, {0xc4,0x7e}, {0xc4,0x7d},
    {0xf4,0xad}, {0x9d,0xa6}, {0xf4,0xaf}, {0xf4,0xae}, {0xc4,0xa1}, {0xf5,0xeb}, {0xf5,0xe8}, {0xf5,0xe9}, {0xf5,0xe7}, {0xf5,0xea},
    {0xc4,0xf2}, {0xf5,0xec}, {0x9e,0xb0}, {0xc4,0xf1}, {0xf7,0x42}, {0x8e,0xb8}, {0xc5,0xd5}, {0xc5,0xd7}, {0xf7,0xee}, {0xc5,0xd6},
    {0xf8,0xb9}, {0xf9,0x40}, {0xf9,0x42}, {0xf8,0xfe}, {0xf9,0x41}, {0xc6,0x6c}, {0x9d,0x70}, {0x89,0x6e}, {0x89,0x6f}, {0x89,0x70},
    {0x89,0x71}, {0x89,0x72}, {0x89,0x73}, {0x89,0x74}, {0xa6,0xce}, {0x89,0x75}, {0xac,0xfb}, {0xd2,0x6f}, {0xaf,0xca}, {0xb2,0xda},
    {0xda,0xfc}, {0xda,0xfd}, {0x8e,0xbc}, {0x8e,0xbd}, {0xea,0xdf}, {0xc1,0x6a}, {0xed,0xe1}, {0x8e,0xbe}, {0xc2,0xbb}, {0x9d,0xd1},
    {0xf2,0xba}, {0xf2,0xb9}, {0xc4,0xa2}, {0xf5,0xed}, {0x94,0xfd}, {0xf7,0x43}, {0xc5,0xf8}, {0xca,0x49}, {0x8b,0xd7}, {0x8b,0xda},
    {0xaa,0xc9}, {0xa8,0x75}, {0xd0,0x4d}, {0xd3,0x60}, {0xd3,0x5b}, {0xd3,0x5f}, {0xd3,0x5d}, {0xaf,0xcb}, {0xd3,0x5e}, {0xd3,0x5c},
    {0xd6,0xf1}, {0xda,0xfe}, {0xdb,0x40}, {0xdf,0x69}, {0xdf,0x6a}, {0xb8,0x6e}, {0xb8,0x6f}, {0xdf,0x68}, {0xdf,0x6b}, {0xdf,0x67},
    {0xb8,0x6d}, {0xbb,0x40}, {0xa0,0xe2}, {0xb8,0x70}, {0xe3,0x7a}, {0xbd,0x7c}, {0xe6,0xf1}, {0xbd,0x7d}, {0x9f,0xe9}, {0xbf,0xa9},
    {0xea,0xe2}, {0xea,0xe0}, {0xea,0xe1}, {0xed,0xe4}, {0xed,0xe3}, {0xed,0xe2}, {0xf2,0xbb}, {0xc3,0xb9}, {0xf2,0xbc}, {0xf7,0x44},
    {0xc5,0xf9}, {0xf8,0xba}, {0xa6,0xcf}, {0xaa,0xcb}, {0xaa,0xca}, {0xd0,0x4f}, {0xac,0xfc}, {0xfd,0xa8}, {0xd0,0x4e}, {0xd3,0x62},
    {0x8a,0xe7}, {0xaf,0xcc}, {0xd6,0xf2}, {0xd3,0x61}, {0x8e,0xc2}, {0xb2,0xdc}, {0xd6,0xf5}, {0xd6,0xf3}, {0xd6,0xf4}, {0xb2,0xdb},
    {0xdb,0x42}, {0xdb,0x43}, {0xdb,0x41}, {0x8e,0xc4}, {0xb8,0x73}, {0xdf,0x6d}, {0xdf,0x6c}, {0xdf,0x6e}, {0xb8,0x72}, {0xb8,0x71},
    {0xe6,0xf2}, {0xe6,0xf4}, {0x99,0x64}, {0xbd,0x7e}, {0xe6,0xf3}, {0xea,0xe3}, {0xbf,0xaa}, {0xf0,0x79}, {0x99,0x65}, {0xf0,0x78},
    {0xc3,0xbb}, {0xf2,0xbd}, {0xc3,0xbd}, {0xc3,0xbc}, {0xf4,0xb0}, {0xf5,0xee}, {0xc4,0xf3}, {0xa6,0xd0}, {0xd0,0x50}, {0xac,0xfd},
    {0xd3,0x65}, {0xaf,0xce}, {0xd3,0x64}, {0xd3,0x63}, {0xaf,0xcd}, {0xd6,0xfb}, {0xd6,0xfd}, {0xd6,0xf6}, {0xd6,0xf7}, {0xb2,0xdd},
    {0xd6,0xf8}, {0xb2,0xde}, {0xd6,0xfc}, {0xd6,0xf9}, {0xd6,0xfa}, {0xb2,0xdf}, {0xb5,0xbe}, {0xb5,0xbf}, {0xdb,0x44}, {0xdf,0x6f},
    {0xdf,0x70}, {0x95,0x4e}, {0xe3,0x7e}, {0xbb,0x43}, {0xbb,0x41}, {0xbb,0x42}, {0xe3,0x7b}, {0xe3,0x7c}, {0xe3,0x7d}, {0xe6,0xf9},
    {0x98,0xb3}, {0xe6,0xfa}, {0xbd,0xa1}, {0xe6,0xf7}, {0xe6,0xf6}, {0xe6,0xf8}, {0xe6,0xf5}, {0xbf,0xad}, {0xea,0xe4}, {0xbf,0xab},
    {0xbf,0xac}, {0xed,0xe6}, {0xc1,0x6b}, {0xed,0xe5}, {0xef,0xa8}, {0xf0,0x7a}, {0xf0,0x7b}, {0xc2,0xbc}, {0x8e,0xcb}, {0xc2,0xbd},
    {0xc1,0x6c}, {0xf2,0xbe}, {0xf2,0xbf}, {0xf4,0xb1}, {0xc4,0xa3}, {0xa6,0xd1}, {0x8b,0xdf}, {0xa6,0xd2}, {0xac,0xfe}, {0xaa,0xcc},
    {0xaf,0xcf}, {0xd0,0x51}, {0x8e,0xce}, {0xb5,0xc0}, {0xa6,0xd3}, {0xad,0x41}, {0xd0,0x52}, {0xd0,0x53}, {0xad,0x40}, {0xad,0x42},
    {0xa6,0xd4}, {0xd0,0x54}, {0xaf,0xd1}, {0xd3,0x66}, {0xaf,0xd3}, {0xaf,0xd0}, {0xaf,0xd2}, {0xd7,0x41}, {0xb2,0xe0}, {0x8e,0xcf},
    {0xd7,0x40}, {0xd6,0xfe}, {0x99,0x68}, {0xdf,0x71}, {0xe3,0xa1}, {0x99,0x69}, {0xbd,0xa2}, {0xbf,0xae}, {0xea,0xe6}, {0xea,0xe5},
    {0xed,0xe7}, {0x99,0x6b}, {0x8e,0xd1}, {0xf5,0xef}, {0x99,0x6c}, {0xa6,0xd5}, {0xcb,0x73}, {0xcd,0xaa}, {0xad,0x43}, {0xd0,0x55},
    {0xd3,0x68}, {0x8e,0xd4}, {0x8e,0xd5}, {0xaf,0xd4}, {0xd3,0x67}, {0xaf,0xd5}, {0xd7,0x43}, {0xb2,0xe2}, {0xd7,0x42}, {0xd7,0x44},
    {0xb2,0xe1}, {0xdb,0x46}, {0xdb,0x47}, {0xdb,0x45}, {0xb5,0xc1}, {0x99,0x6d}, {0xb8,0x74}, {0xb8,0x75}, {0xbb,0x45}, {0xa0,0xbe},
    {0xe3,0xa3}, {0xe3,0xa2}, {0xbb,0x44}, {0x8e,0xd6}, {0xa0,0xbc}, {0xa0,0xb5}, {0xe6,0xfb}, {0xa0,0xb4}, {0xe6,0xfc}, {0xea,0xe7},
    {0xc1,0x70}, {0xc1,0x6f}, {0xc1,0x6d}, {0xc1,0x6e}, {0xc1,0x71}, {0xf0,0x7c}, {0xc2,0xbf}, {0xc2,0xbe}, {0xf2,0xc0}, {0xf4,0xb2},
    {0xc5,0xa5}, {0xc5,0xa4}, {0xa6,0xd6}, {0x8b,0xe0}, {0xd1,0xfb}, {0xb8,0x77}, {0xb5,0xc2}, {0xb8,0x76}, {0xbb,0x46}, {0xa6,0xd7},
    {0xc9,0xa9}, {0xa6,0xd8}, {0xa6,0xd9}, {0xcd,0xab}, {0xcb,0x76}, {0xcb,0x77}, {0xa8,0x77}, {0xcb,0x74}, {0xa8,0x76}, {0xa8,0x79},
    {0xcb,0x75}, {0xa8,0x7b}, {0xa8,0x7a}, {0xcb,0x78}, {0xa8,0x78}, {0x89,0xb5}, {0xaa,0xd1}, {0xaa,0xcf}, {0xcd,0xad}, {0xaa,0xce},
    {0x8e,0xdd}, {0xaa,0xd3}, {0xaa,0xd5}, {0xaa,0xd2}, {0xcd,0xb0}, {0xcd,0xac}, {0xaa,0xd6}, {0xaa,0xd0}, {0xa8,0x7c}, {0xaa,0xd4},
    {0xcd,0xaf}, {0x9e,0x5d}, {0x99,0x71}, {0xcd,0xae}, {0xaa,0xcd}, {0x89,0xae}, {0x9d,0xe8}, {0xd0,0x5b}, {0xad,0x47}, {0xad,0x48},
    {0xd0,0x5d}, {0x95,0x65}, {0xd0,0x57}, {0xd0,0x5a}, {0xd0,0x63}, {0xd0,0x61}, {0xad,0x49}, {0xd0,0x67}, {0xad,0x4c}, {0xd0,0x64},
    {0xd0,0x5c}, {0xd0,0x59}, {0xdb,0x49}, {0xd0,0x62}, {0xad,0x44}, {0xd0,0x65}, {0xd0,0x56}, {0xd0,0x5f}, {0xad,0x46}, {0xad,0x4b},
    {0xd0,0x60}, {0xad,0x4f}, {0xad,0x4d}, {0xd0,0x58}, {0xad,0x4a}, {0xd0,0x5e}, {0xad,0x4e}, {0xad,0x45}, {0xd0,0x66}, {0x99,0x72},
    {0x8b,0x5c}, {0xaf,0xda}, {0xaf,0xe3}, {0xaf,0xd8}, {0xaf,0xd6}, {0xd3,0x6a}, {0xaf,0xde}, {0xaf,0xdb}, {0xd3,0x6c}, {0x89,0xb1},
    {0xaf,0xdd}, {0xd3,0x6b}, {0xd3,0x69}, {0xd3,0x6e}, {0xaf,0xe2}, {0xaf,0xe0}, {0xdb,0x48}, {0xd3,0x6f}, {0xd3,0x6d}, {0xaf,0xd7},
    {0xa0,0xc0}, {0xaf,0xd9}, {0xaf,0xdc}, {0x8e,0xdf}, {0xaf,0xdf}, {0x95,0x66}, {0xaf,0xe1}, {0x99,0x74}, {0x99,0x76}, {0x99,0x77},
    {0x99,0x79}, {0xd7,0x4e}, {0xb2,0xe4}, {0x9d,0xda}, {0xd7,0x45}, {0xd7,0x47}, {0x8e,0xe0}, {0xd7,0x48}, {0xd7,0x50}, {0xd7,0x4c},
    {0xd7,0x4a}, {0xd7,0x4d}, {0xd7,0x51}, {0xb2,0xe5}, {0xb2,0xe9}, {0xd7,0x46}, {0xd7,0x4f}, {0xb2,0xe7}, {0x93,0x5c}, {0xb2,0xe6},
    {0xd7,0x4b}, {0xd7,0x49}, {0xb2,0xe3}, {0xb2,0xe8}, {0x9d,0xe6}, {0x8b,0x5f}, {0x95,0x63}, {0xb5,0xc8}, {0xdb,0x51}, {0xdb,0x4f},
    {0xb5,0xca}, {0x95,0x67}, {0xdb,0x4a}, {0xdf,0xa1}, {0xb5,0xc9}, {0xdb,0x4e}, {0x9d,0xe3}, {0xdb,0x4b}, {0xb5,0xc5}, {0xb5,0xcb},
    {0xdb,0x50}, {0xb5,0xc7}, {0xdb,0x4d}, {0xbb,0x47}, {0xb5,0xc6}, {0xdb,0x4c}, {0xb5,0xcc}, {0xb5,0xc4}, {0xb5,0xc3}, {0x99,0x7c},
    {0x99,0x7d}, {0x99,0x7e}, {0xdf,0x77}, {0xdf,0x75}, {0xdf,0x7b}, {0xdf,0x73}, {0xdf,0xa2}, {0xdf,0x78}, {0xdf,0x72}, {0xb8,0x7b},
    {0xb8,0xa3}, {0xdf,0x7d}, {0xdf,0x76}, {0xb8,0x7e}, {0x8b,0x5b}, {0xb8,0x7c}, {0xdf,0x7e}, {0xb8,0x79}, {0xb8,0x78}, {0xdf,0x79},
    {0xb8,0x7d}, {0xb5,0xcd}, {0xdf,0x7c}, {0xdf,0x74}, {0xb8,0x7a}, {0xb8,0xa1}, {0xb8,0xa2}, {0x99,0xa3}, {0xbb,0x4c}, {0xbb,0x48},
    {0xbb,0x4d}, {0xe3,0xa6}, {0x99,0xa4}, {0xe3,0xa5}, {0xe3,0xa7}, {0xbb,0x4a}, {0xe3,0xa4}, {0xbb,0x4b}, {0xe3,0xaa}, {0xe3,0xa9},
    {0xe3,0xa8}, {0xbb,0x49}, {0x99,0xa6}, {0xe7,0x41}, {0xe7,0x44}, {0xbd,0xa8}, {0xe7,0x43}, {0xbd,0xa7}, {0xbd,0xa3}, {0xbd,0xa4},
    {0xbd,0xa5}, {0xe7,0x40}, {0xe6,0xfe}, {0xbd,0xa6}, {0xe7,0x42}, {0xe6,0xfd}, {0x99,0xa8}, {0xea,0xe9}, {0xea,0xf3}, {0xbf,0xb1},
    {0xbf,0xb0}, {0x8a,0xbe}, {0xea,0xed}, {0xea,0xef}, {0xea,0xea}, {0xea,0xee}, {0xea,0xe8}, {0xea,0xf1}, {0xbf,0xaf}, {0xea,0xf0},
    {0xea,0xec}, {0x9e,0x61}, {0xea,0xf2}, {0xea,0xeb}, {0xc1,0x74}, {0xed,0xe8}, {0xed,0xee}, {0xc1,0x78}, {0xc1,0x7a}, {0xc1,0x77},
    {0xc1,0x76}, {0x99,0xaa}, {0xc1,0x75}, {0xc1,0x73}, {0xed,0xe9}, {0xed,0xec}, {0xc1,0x72}, {0xed,0xed}, {0xa0,0xc8}, {0xc1,0x79},
    {0xed,0xeb}, {0xed,0xea}, {0xc2,0xc0}, {0xc2,0xc1}, {0xf0,0xa1}, {0xf0,0x7d}, {0xf0,0x7e}, {0xf2,0xc2}, {0xf2,0xc1}, {0xc3,0xbe},
    {0xf4,0xb4}, {0xc4,0xa4}, {0xf4,0xb3}, {0xf5,0xf0}, {0xf7,0x45}, {0xc5,0xa6}, {0xf9,0x43}, {0xf9,0x44}, {0xc5,0xd8}, {0xa6,0xda},
    {0x99,0xab}, {0xaa,0xd7}, {0xdb,0x52}, {0xbb,0x4e}, {0xc1,0x7b}, {0xed,0xef}, {0xa6,0xdb}, {0xaf,0xe5}, {0xaf,0xe4}, {0xdb,0x53},
    {0xfe,0xc4}, {0xea,0xf4}, {0xa6,0xdc}, {0xad,0x50}, {0x98,0xc2}, {0xdb,0x54}, {0xdb,0x55}, {0xdb,0x56}, {0xbb,0x4f}, {0xbf,0xb2},
    {0xa6,0xdd}, {0xaa,0xd8}, {0xd0,0x68}, {0xaf,0xe6}, {0xd3,0x70}, {0xb2,0xea}, {0xdb,0x57}, {0xb8,0xa4}, {0xbb,0x50}, {0xbf,0xb3},
    {0xc1,0x7c}, {0xc2,0xc2}, {0xf4,0xb5}, {0xa6,0xde}, {0xaa,0xd9}, {0xaf,0xe7}, {0xd7,0x52}, {0xb5,0xce}, {0xbb,0x51}, {0xe3,0xab},
    {0xe7,0x45}, {0x8e,0xe8}, {0xa0,0xba}, {0xa6,0xdf}, {0xb5,0xcf}, {0xdf,0xa3}, {0xbb,0x52}, {0xa6,0xe0}, {0xcd,0xb1}, {0xd0,0x69},
    {0xad,0x51}, {0xd3,0x72}, {0xfd,0x77}, {0xaf,0xea}, {0x8e,0xee}, {0xaf,0xe8}, {0xaf,0xe9}, {0xaf,0xeb}, {0x9e,0xbf}, {0xd3,0x71},
    {0xd7,0x57}, {0xd7,0x54}, {0xd7,0x56}, {0xb2,0xeb}, {0xb2,0xed}, {0xb2,0xec}, {0xd7,0x53}, {0xb2,0xee}, {0xd7,0x55}, {0xdb,0x58},
    {0xdb,0x59}, {0x89,0xc2}, {0xdb,0x5a}, {0xdf,0xa6}, {0xdf,0xa7}, {0xdf,0xa5}, {0xdf,0xa8}, {0xb8,0xa5}, {0xdf,0xa4}, {0xbb,0x53},
    {0xe7,0x4a}, {0xe7,0x46}, {0xe7,0x49}, {0xe7,0x4b}, {0xe7,0x48}, {0xe7,0x47}, {0x99,0xac}, {0xea,0xf5}, {0xea,0xf6}, {0xea,0xf7},
    {0xbf,0xb4}, {0xbf,0xb5}, {0xed,0xf1}, {0xed,0xf0}, {0xed,0xf2}, {0xf0,0xa3}, {0xf0,0xa2}, {0xf2,0xc4}, {0x95,0x6b}, {0xf2,0xc5},
    {0xf2,0xc3}, {0x95,0x6c}, {0xc4,0xa5}, {0xf4,0xb6}, {0xf4,0xb7}, {0xf7,0x46}, {0xf7,0xef}, {0xf8,0xbb}, {0xa6,0xe1}, {0xa8,0x7d},
    {0xc1,0x7d}, {0xa6,0xe2}, {0xd7,0x58}, {0xdb,0x5b}, {0x99,0xaf}, {0xc6,0x41}, {0xca,0x4a}, {0x99,0x4a}, {0x89,0x76}, {0x8f,0x48},
    {0xca,0x4b}, {0xca,0x4d}, {0xa6,0xe3}, {0xca,0x4e}, {0xca,0x4c}, {0xcb,0xa2}, {0xcb,0xa3}, {0xcb,0x7b}, {0xfb,0xee}, {0xcb,0xa1},
    {0xa8,0xa1}, {0xa8,0xa2}, {0xcb,0x7c}, {0xcb,0x7a}, {0xcb,0x79}, {0xcb,0x7d}, {0xa8,0x7e}, {0xcb,0x7e}, {0xd0,0x6a}, {0xcd,0xb6},
    {0xaa,0xdc}, {0xcd,0xb5}, {0xcd,0xb7}, {0xaa,0xdb}, {0xcd,0xbc}, {0xaa,0xdf}, {0xcd,0xb2}, {0xcd,0xc0}, {0xcd,0xc6}, {0xaa,0xe6},
    {0xcd,0xc3}, {0xaa,0xe3}, {0x99,0xae}, {0xcd,0xb9}, {0xcd,0xbf}, {0xcd,0xc1}, {0x8e,0xfb}, {0xcd,0xb4}, {0xaa,0xe2}, {0xaa,0xdd},
    {0xcd,0xba}, {0xaa,0xe4}, {0xaa,0xe7}, {0xaa,0xe1}, {0xaa,0xda}, {0xcd,0xbe}, {0xcd,0xb8}, {0xcd,0xc5}, {0xaa,0xe9}, {0xaa,0xe5},
    {0xaa,0xe0}, {0xcd,0xbd}, {0xaf,0xec}, {0xcd,0xbb}, {0xaa,0xde}, {0xaa,0xe8}, {0x8c,0xd0}, {0xcd,0xb3}, {0xcd,0xc2}, {0xcd,0xc4},
    {0x8b,0x52}, {0x99,0xb0}, {0x89,0x77}, {0x8f,0x41}, {0xad,0x62}, {0xad,0x5c}, {0xad,0x64}, {0xad,0x61}, {0xd0,0x71}, {0xd0,0x74},
    {0xad,0x5d}, {0x99,0xb1}, {0xd0,0x6b}, {0xad,0x56}, {0xad,0x60}, {0xad,0x63}, {0xad,0x65}, {0xd0,0xa2}, {0xd0,0x77}, {0x8f,0x49},
    {0xad,0x55}, {0xd0,0xa1}, {0xad,0x59}, {0xad,0x57}, {0xad,0x52}, {0xd0,0x6f}, {0xd0,0x7e}, {0xd0,0x73}, {0xd0,0x76}, {0xd0,0xa5},
    {0xfa,0x4d}, {0xad,0x66}, {0xd0,0x7d}, {0xad,0x5e}, {0xd0,0x78}, {0xd0,0xa4}, {0xd0,0x75}, {0xd0,0x79}, {0xd0,0x7c}, {0x9d,0xe4},
    {0x8c,0xb5}, {0xd0,0x6d}, {0xd0,0xa3}, {0xd0,0x7b}, {0xfb,0xe9}, {0x9b,0x54}, {0xd0,0x6c}, {0x99,0xb2}, {0xd0,0x70}, {0xad,0x5f},
    {0xad,0x5a}, {0xad,0x53}, {0xad,0x58}, {0xad,0x54}, {0xad,0x67}, {0xd0,0x6e}, {0xd3,0xa5}, {0xad,0x5b}, {0x9e,0x68}, {0xd0,0x7a},
    {0xce,0x41}, {0xd3,0xa8}, {0xaf,0xfa}, {0x8f,0x4a}, {0xd3,0x76}, {0x8f,0x42}, {0xd3,0xa3}, {0xd3,0x7d}, {0x8f,0x51}, {0xd3,0xb2},
    {0xd3,0xaa}, {0xd3,0x7e}, {0xd3,0xa9}, {0xd3,0x78}, {0xd3,0x7c}, {0xd3,0xb5}, {0xaf,0xfd}, {0xd3,0xad}, {0xd3,0xa4}, {0xaf,0xed},
    {0xd3,0xb3}, {0xd3,0x74}, {0xd3,0xac}, {0xaf,0xfc}, {0xaf,0xf7}, {0xd3,0x73}, {0xaf,0xf5}, {0xaf,0xf4}, {0xaf,0xf9}, {0xd3,0xab},
    {0xaf,0xf1}, {0xaf,0xf8}, {0xd0,0x72}, {0xdb,0x5c}, {0xd3,0xa6}, {0x98,0x46}, {0xd3,0x7a}, {0xaf,0xfb}, {0xd3,0x7b}, {0xd3,0xa1},
    {0xaf,0xfe}, {0xd3,0x75}, {0xd3,0xaf}, {0xd3,0xae}, {0xd3,0xb6}, {0xaf,0xf3}, {0xaf,0xf0}, {0xd3,0xb4}, {0xd3,0xb0}, {0xd3,0xa7},
    {0xd3,0xa2}, {0xaf,0xf6}, {0xaf,0xf2}, {0xd3,0x77}, {0xaf,0xee}, {0xd3,0xb1}, {0xaf,0xef}, {0xd3,0x79}, {0x99,0xb4}, {0x8e,0xf5},
    {0xfd,0x55}, {0x9c,0xcd}, {0x89,0x78}, {0xd7,0x5e}, {0xd7,0x60}, {0xd7,0x65}, {0xd7,0x79}, {0xb2,0xfc}, {0xb2,0xf2}, {0xd7,0x5d},
    {0xb2,0xfd}, {0xb2,0xfe}, {0xd7,0x68}, {0xd7,0x6f}, {0xd7,0x75}, {0xd7,0x62}, {0xd7,0x69}, {0x8f,0x53}, {0xb3,0x40}, {0xd7,0x77},
    {0xd7,0x72}, {0xb2,0xfa}, {0xb2,0xf8}, {0xd7,0x6e}, {0xd7,0x6a}, {0xd7,0x5c}, {0xb2,0xef}, {0xd7,0x61}, {0xd7,0x59}, {0x8f,0x6f},
    {0xb2,0xf7}, {0xb2,0xf9}, {0xd7,0x66}, {0xd7,0x63}, {0xb2,0xf4}, {0xd7,0x73}, {0xb2,0xf1}, {0xd7,0x64}, {0xd7,0x7a}, {0xd7,0x6c},
    {0x8e,0x63}, {0xd7,0x6b}, {0xb2,0xf0}, {0xb2,0xfb}, {0xb2,0xf3}, {0xd7,0x5a}, {0xd7,0x5f}, {0xd7,0x70}, {0xd7,0x76}, {0xb3,0x41},
    {0xd7,0x5b}, {0xd7,0x67}, {0xd7,0x6d}, {0xb2,0xf6}, {0x8f,0x56}, {0xd7,0x78}, {0xd7,0x71}, {0xd7,0x74}, {0xfe,0x76}, {0xb2,0xf5},
    {0x9f,0xc6}, {0xdb,0x6c}, {0xdb,0x60}, {0xb5,0xd7}, {0xdb,0x7d}, {0xdb,0xa7}, {0xdb,0xaa}, {0xb5,0xd5}, {0xdb,0x68}, {0xdb,0xa3},
    {0xdb,0x69}, {0xdb,0x77}, {0xb5,0xe2}, {0xdb,0x73}, {0xb5,0xdf}, {0xfa,0xac}, {0xdb,0x74}, {0xdb,0x5d}, {0xdb,0xa4}, {0x8f,0x58},
    {0xb5,0xe8}, {0xdb,0xa1}, {0xdb,0x75}, {0xdb,0xac}, {0xdb,0x70}, {0xdf,0xc8}, {0xdb,0xaf}, {0xb5,0xe6}, {0xdb,0x6e}, {0xdb,0x7a},
    {0xb5,0xe9}, {0xb5,0xd4}, {0xdb,0x72}, {0xdb,0xad}, {0xdb,0x6b}, {0xdb,0x64}, {0xdb,0x6f}, {0xdb,0x63}, {0xdb,0x61}, {0xb5,0xd0},
    {0xdb,0xa5}, {0xdb,0x6a}, {0xdb,0xa8}, {0x98,0x48}, {0xdb,0xa9}, {0xb5,0xd8}, {0xb5,0xdd}, {0xb5,0xd9}, {0xb5,0xe1}, {0xdb,0x7e},
    {0xb5,0xda}, {0xdb,0x76}, {0xdb,0x66}, {0xb5,0xd2}, {0xdb,0x5e}, {0xdb,0xa2}, {0xdb,0xab}, {0xdb,0x65}, {0xb5,0xe0}, {0xdb,0xb0},
    {0xdb,0x71}, {0xdb,0x6d}, {0xb5,0xd1}, {0xb5,0xe5}, {0x99,0xb7}, {0xdb,0x7c}, {0xb5,0xe7}, {0xdb,0x78}, {0xb5,0xdc}, {0xb5,0xd6},
    {0xb5,0xde}, {0xb5,0xd3}, {0xb5,0xe4}, {0xdb,0x79}, {0xdb,0x67}, {0xdb,0x7b}, {0xdb,0x62}, {0xdb,0xa6}, {0x96,0x65}, {0xfa,0x6c},
    {0x9d,0xe7}, {0xdb,0xae}, {0x9e,0x62}, {0x96,0xcc}, {0x8e,0x67}, {0xdb,0x5f}, {0xfc,0x75}, {0x98,0x7e}, {0xdf,0xc7}, {0xdf,0xdd},
    {0xb8,0x55}, {0xdf,0xcc}, {0xfd,0xb9}, {0xdf,0xca}, {0xdf,0xb5}, {0xb8,0xa9}, {0xdf,0xc5}, {0xdf,0xd9}, {0xdf,0xc1}, {0xb8,0xb1},
    {0xdf,0xd8}, {0xdf,0xbf}, {0xb5,0xe3}, {0xdf,0xcf}, {0xdf,0xc0}, {0xdf,0xd6}, {0xb8,0xb0}, {0xb8,0xa8}, {0x97,0xfc}, {0xdf,0xaa},
    {0xdf,0xb2}, {0xdf,0xcb}, {0xdf,0xc3}, {0xdf,0xdc}, {0xdf,0xc6}, {0xb8,0xb6}, {0xdf,0xd7}, {0x98,0xf9}, {0xb8,0xad}, {0x8f,0x66},
    {0xdf,0xc9}, {0xdf,0xd1}, {0xdf,0xb6}, {0xdf,0xd0}, {0xdf,0xe1}, {0xdf,0xb1}, {0xdf,0xd2}, {0x95,0x6e}, {0xdf,0xdf}, {0x92,0x45},
    {0xdf,0xab}, {0xb5,0xdb}, {0x8f,0x60}, {0xdf,0xb9}, {0xdf,0xb8}, {0xb8,0xaf}, {0x9e,0xd1}, {0xdf,0xbc}, {0xdf,0xbe}, {0xdf,0xcd},
    {0xdf,0xde}, {0xb8,0xb2}, {0xfe,0xcd}, {0xb8,0xb3}, {0x99,0xb9}, {0xdf,0xb0}, {0xb8,0xab}, {0xdf,0xb4}, {0xdf,0xda}, {0xb8,0xb4},
    {0xb8,0xac}, {0xb8,0xae}, {0xb8,0xb5}, {0xdf,0xe0}, {0xdf,0xd3}, {0xdf,0xce}, {0x8f,0x62}, {0x97,0x4c}, {0xdf,0xbb}, {0xdf,0xba},
    {0xb8,0xaa}, {0xdf,0xac}, {0xb8,0xa7}, {0xdf,0xc4}, {0xdf,0xad}, {0xdf,0xc2}, {0xdf,0xb7}, {0xdf,0xdb}, {0x91,0xc7}, {0x95,0x5f},
    {0xb8,0xa6}, {0xdf,0xb3}, {0x99,0xbb}, {0xdf,0xaf}, {0xdf,0xd5}, {0xdf,0xae}, {0xbb,0x60}, {0xe3,0xd3}, {0x8e,0x6d}, {0x8f,0x71},
    {0xe3,0xc2}, {0x94,0xcb}, {0xe3,0xac}, {0xe3,0xca}, {0xbb,0x58}, {0xe3,0xbb}, {0xe3,0xc5}, {0xbb,0x5b}, {0xe3,0xbe}, {0xbb,0x59},
    {0xe3,0xaf}, {0xe3,0xcd}, {0xe3,0xae}, {0xe3,0xc1}, {0x95,0xb1}, {0xe3,0xad}, {0xe3,0xbf}, {0xe3,0xc8}, {0xe3,0xc6}, {0xe3,0xba},
    {0xe3,0xb5}, {0xe3,0xb3}, {0x9a,0xf2}, {0xe3,0xb4}, {0xe3,0xc7}, {0xe3,0xd2}, {0xe3,0xbc}, {0xbb,0x5a}, {0xe3,0xb7}, {0xe3,0xcb},
    {0xbb,0x5d}, {0xe3,0xb6}, {0xe3,0xb0}, {0xe3,0xc0}, {0xbb,0x61}, {0x96,0xc3}, {0x99,0xbd}, {0xbb,0x55}, {0xbb,0x5e}, {0xe3,0xb8},
    {0xe3,0xb2}, {0xbb,0x57}, {0xdf,0xd4}, {0xbb,0x56}, {0xe3,0xc3}, {0xbb,0x54}, {0xbb,0x63}, {0xbb,0x5c}, {0xe3,0xc4}, {0xe3,0xb9},
    {0xe3,0xb1}, {0xe3,0xcc}, {0xe3,0xbd}, {0xbb,0x62}, {0xe3,0xd0}, {0xbb,0x5f}, {0xe3,0xcf}, {0xe3,0xc9}, {0xe3,0xce}, {0xa0,0xcf},
    {0xe3,0xd1}, {0x8f,0x6d}, {0x99,0xbe}, {0x8e,0xf4}, {0x8f,0x72}, {0x95,0xe4}, {0xe7,0x73}, {0xe7,0x74}, {0xe7,0x67}, {0xe7,0x66},
    {0xe7,0x62}, {0xbd,0xb4}, {0xbd,0xac}, {0xe7,0x76}, {0xe7,0x75}, {0xdf,0xa9}, {0xe7,0x5f}, {0xe7,0x63}, {0xe7,0x5d}, {0xe7,0x70},
    {0xe7,0x61}, {0x99,0xbf}, {0xe7,0x77}, {0xe7,0x5a}, {0xe7,0x58}, {0xe7,0x64}, {0xe7,0x6e}, {0xe7,0x69}, {0xbd,0xb6}, {0xe7,0x4f},
    {0xe7,0x6d}, {0x92,0x42}, {0xfb,0xa5}, {0xbd,0xb7}, {0xdf,0xbd}, {0xe7,0x5b}, {0xe7,0x52}, {0xe7,0x55}, {0xe7,0x7b}, {0xe7,0x5c},
    {0xe7,0x53}, {0xe7,0x51}, {0xe7,0x4e}, {0x99,0xc0}, {0xbd,0xb0}, {0xe7,0x65}, {0xbd,0xaf}, {0xbd,0xb3}, {0xe7,0x60}, {0xe7,0x68},
    {0xbd,0xa9}, {0xe7,0x78}, {0xe7,0x7c}, {0xbd,0xab}, {0xe7,0x57}, {0xe7,0x6b}, {0xe7,0x6f}, {0xe7,0x54}, {0xe7,0x79}, {0xbd,0xb2},
    {0xbd,0xb1}, {0xe7,0x4c}, {0xbd,0xb5}, {0xe7,0x72}, {0xe7,0x56}, {0xe7,0x6a}, {0xe7,0x50}, {0xe7,0x5e}, {0xe7,0x59}, {0xbd,0xad},
    {0xbd,0xae}, {0xe7,0x6c}, {0xe7,0x7d}, {0xe7,0x7a}, {0xe7,0x71}, {0xfd,0xb4}, {0x8f,0x77}, {0x99,0xc1}, {0xe7,0x4d}, {0xbd,0xaa},
    {0xeb,0x49}, {0xeb,0x40}, {0xeb,0x43}, {0xfa,0xb9}, {0xbf,0xbb}, {0xeb,0x45}, {0xea,0xf9}, {0xeb,0x41}, {0xeb,0x47}, {0xbf,0xb8},
    {0xbf,0xbc}, {0xbf,0xb6}, {0x8f,0x40}, {0xfa,0x44}, {0xea,0xfb}, {0xeb,0x4c}, {0xeb,0x46}, {0x99,0xc2}, {0xea,0xfc}, {0xeb,0x55},
    {0xeb,0x4f}, {0xea,0xf8}, {0xee,0x46}, {0xea,0xfe}, {0xbf,0xb7}, {0x8f,0x5c}, {0xeb,0x4a}, {0xeb,0x54}, {0xbf,0xbf}, {0x8c,0xbd},
    {0xeb,0x51}, {0xea,0xfd}, {0xeb,0x44}, {0xeb,0x48}, {0xeb,0x42}, {0xeb,0x56}, {0xeb,0x53}, {0xeb,0x50}, {0xbf,0xb9}, {0xbf,0xba},
    {0xbf,0xbe}, {0xea,0xfa}, {0xeb,0x57}, {0xbf,0xbd}, {0xeb,0x4d}, {0x99,0xc4}, {0x99,0xc5}, {0xeb,0x4b}, {0x8f,0x7b}, {0xeb,0x4e},
    {0xee,0x53}, {0xee,0x40}, {0xee,0x45}, {0xee,0x52}, {0xee,0x44}, {0xed,0xfb}, {0xee,0x41}, {0xc1,0xa2}, {0xed,0xf4}, {0xee,0x4d},
    {0xee,0x4f}, {0xed,0xf3}, {0xc1,0xa1}, {0xee,0x51}, {0xee,0x49}, {0xc1,0xa8}, {0xee,0x50}, {0xee,0x42}, {0xc1,0xaa}, {0xed,0xf9},
    {0xeb,0x52}, {0xee,0x4a}, {0xee,0x47}, {0xed,0xf5}, {0xee,0x55}, {0xc1,0xa4}, {0xc1,0xa5}, {0xed,0xf7}, {0xee,0x48}, {0x8c,0xb6},
    {0xee,0x54}, {0xee,0x4b}, {0xed,0xfd}, {0xc1,0xa7}, {0xc1,0xa3}, {0xee,0x4c}, {0xed,0xfe}, {0xee,0x56}, {0xed,0xf8}, {0xee,0x43},
    {0xee,0x4e}, {0xed,0xfa}, {0xed,0xfc}, {0xc2,0xcb}, {0xed,0xf6}, {0xc1,0xa9}, {0xc2,0xc4}, {0xc1,0x7e}, {0xc1,0xa6}, {0xc2,0xc8},
    {0xf0,0xb3}, {0xf0,0xa9}, {0xf0,0xa4}, {0xf0,0xaa}, {0xf0,0xb4}, {0xf0,0xb8}, {0xf0,0xb7}, {0xc2,0xca}, {0xc2,0xc9}, {0xf0,0xab},
    {0xf0,0xb9}, {0xf0,0xae}, {0xf0,0xa6}, {0x8f,0xa3}, {0xf0,0xa8}, {0xf0,0xa7}, {0xf0,0xad}, {0xf0,0xb2}, {0xf0,0xa5}, {0xf0,0xac},
    {0xf0,0xb1}, {0xc2,0xc7}, {0xf0,0xaf}, {0xc2,0xc5}, {0xf0,0xb0}, {0xc2,0xc3}, {0xc2,0xc6}, {0xf2,0xd5}, {0xf0,0xb5}, {0xc3,0xc2},
    {0x8c,0xce}, {0xf2,0xcd}, {0xf2,0xd1}, {0xf2,0xc9}, {0xf2,0xcc}, {0xf2,0xd4}, {0xc3,0xc0}, {0xf2,0xd9}, {0xf2,0xd2}, {0x99,0xc6},
    {0xf2,0xca}, {0xf2,0xda}, {0xf2,0xd3}, {0xc3,0xc3}, {0xc3,0xc4}, {0xf2,0xd7}, {0xf2,0xcb}, {0xc3,0xbf}, {0xc3,0xc1}, {0xf2,0xc6},
    {0xf2,0xce}, {0xf2,0xc8}, {0x96,0xcd}, {0xf2,0xd8}, {0xf2,0xd6}, {0xf2,0xc7}, {0xf2,0xcf}, {0xf4,0xbe}, {0xc3,0xc5}, {0xf2,0xd0},
    {0xc4,0xa7}, {0xc4,0xa9}, {0xc4,0xa6}, {0x96,0xc7}, {0xf4,0xc3}, {0xf4,0xbb}, {0xf4,0xb9}, {0xf4,0xbd}, {0xf4,0xba}, {0x8f,0xa5},
    {0xf4,0xbf}, {0xf4,0xc1}, {0xc4,0xaa}, {0xc4,0xac}, {0xf4,0xc0}, {0xc4,0xad}, {0xc4,0xab}, {0xf4,0xc2}, {0xfa,0xbb}, {0x8c,0x61},
    {0x95,0x70}, {0xc4,0xa8}, {0x93,0x68}, {0x8f,0x7e}, {0xc4,0xf4}, {0xf5,0xf1}, {0xf5,0xf7}, {0xc4,0xf6}, {0xf4,0xbc}, {0xf5,0xf6},
    {0xf5,0xfd}, {0xf5,0xf4}, {0xf5,0xfb}, {0xf5,0xfa}, {0xf4,0xb8}, {0xf5,0xf5}, {0xf0,0xb6}, {0xf5,0xfe}, {0xf5,0xf3}, {0xf5,0xf8},
    {0x8f,0xaa}, {0xf5,0xfc}, {0xf5,0xf2}, {0xf7,0x4a}, {0xc4,0xf5}, {0xf5,0xf9}, {0xa0,0x50}, {0xf7,0xf4}, {0xf7,0x4b}, {0xf7,0x49},
    {0xf7,0x47}, {0xf7,0x48}, {0xf7,0x4c}, {0xc5,0xd9}, {0xf7,0xf2}, {0xf7,0xf0}, {0xf7,0xf5}, {0xf7,0xf3}, {0xf7,0xf6}, {0xc5,0xda},
    {0xf7,0xf1}, {0x90,0xd3}, {0xf8,0xbc}, {0x95,0x56}, {0xf9,0x45}, {0xf9,0x46}, {0xf9,0x47}, {0xf9,0xc7}, {0xf9,0xbd}, {0xca,0x4f},
    {0xaa,0xea}, {0xad,0x68}, {0xd3,0xb8}, {0xd3,0xb7}, {0xb0,0x40}, {0xb3,0x42}, {0xd7,0x7c}, {0xd7,0x7b}, {0xb5,0xea}, {0xb8,0xb8},
    {0xb8,0xb7}, {0xb8,0xb9}, {0xe3,0xd4}, {0xe7,0x7e}, {0xeb,0x58}, {0xeb,0x5a}, {0xeb,0x59}, {0xc1,0xab}, {0xee,0x57}, {0xf0,0xba},
    {0xf9,0xa5}, {0xa6,0xe4}, {0x8f,0xb8}, {0xcd,0xc9}, {0xcd,0xca}, {0xcd,0xc8}, {0xcd,0xc7}, {0xaa,0xeb}, {0x99,0xc8}, {0xd0,0xa9},
    {0xd0,0xa7}, {0xd0,0xa6}, {0xad,0x69}, {0xad,0x6b}, {0xad,0x6a}, {0xd0,0xa8}, {0x8f,0xaf}, {0xd3,0xc4}, {0xd3,0xc1}, {0xd3,0xbf},
    {0xb0,0x41}, {0xd3,0xc2}, {0xb0,0x46}, {0xd3,0xbc}, {0xd3,0xcb}, {0xd3,0xcd}, {0xd3,0xbd}, {0x99,0xc9}, {0xb0,0x43}, {0xd3,0xce},
    {0xd3,0xc9}, {0xd3,0xbb}, {0xd3,0xc0}, {0xd3,0xca}, {0xd3,0xc6}, {0xd3,0xc3}, {0xb0,0x48}, {0xd3,0xcc}, {0xd3,0xbe}, {0x95,0x79},
    {0xd3,0xc7}, {0xd3,0xb9}, {0xb0,0x47}, {0xb0,0x44}, {0xd3,0xc5}, {0xd3,0xc8}, {0xd3,0xba}, {0xb0,0x45}, {0xb0,0x42}, {0x9f,0x49},
    {0xb3,0x4c}, {0xd7,0xa5}, {0xb3,0x4b}, {0x99,0xca}, {0xd7,0xa8}, {0xd7,0xab}, {0xb3,0x48}, {0xb3,0x46}, {0xd7,0x7e}, {0xd7,0xa9},
    {0xd7,0xa7}, {0xd7,0xa4}, {0xd7,0xac}, {0xd7,0xad}, {0xd7,0xaf}, {0xd7,0xb0}, {0xd7,0x7d}, {0xb3,0x45}, {0xd7,0xa2}, {0xd7,0xa1},
    {0xd7,0xae}, {0xb3,0x47}, {0xd7,0xa3}, {0xb3,0x49}, {0xb3,0x44}, {0xd7,0xa6}, {0xb3,0x4d}, {0xb3,0x4a}, {0xd7,0xaa}, {0xb5,0xf1},
    {0xdb,0xbf}, {0xdb,0xb4}, {0xb5,0xee}, {0xdf,0xe7}, {0xdb,0xbd}, {0xdb,0xb1}, {0xb5,0xec}, {0xdb,0xb6}, {0xb5,0xef}, {0xdb,0xba},
    {0xdb,0xb8}, {0xb5,0xf2}, {0xb5,0xeb}, {0xdb,0xb2}, {0xdb,0xb5}, {0xb5,0xf0}, {0xdb,0xb3}, {0xdb,0xbe}, {0xdb,0xbc}, {0xdb,0xb7},
    {0xdb,0xb9}, {0xdb,0xbb}, {0xb5,0xed}, {0x99,0xcb}, {0xdf,0xe8}, {0xdf,0xee}, {0xdf,0xe4}, {0xdf,0xea}, {0xb8,0xba}, {0xdf,0xe6},
    {0xb8,0xc0}, {0xb8,0xbf}, {0xb8,0xbe}, {0xdf,0xed}, {0xb8,0xc1}, {0xb8,0xc2}, {0xdf,0xe3}, {0xdf,0xf0}, {0xb8,0xc3}, {0xb8,0xbd},
    {0xb8,0xbc}, {0xdf,0xec}, {0xb8,0xc4}, {0xdf,0xe2}, {0xdf,0xe5}, {0xdf,0xef}, {0xdf,0xeb}, {0xe3,0xf4}, {0xe3,0xe9}, {0xb8,0xbb},
    {0xbb,0x6a}, {0xe3,0xdd}, {0xe3,0xf2}, {0xe3,0xde}, {0xbb,0x65}, {0xe3,0xdb}, {0xe3,0xe4}, {0xe3,0xdc}, {0xbb,0x67}, {0xe3,0xd6},
    {0xe3,0xf1}, {0xbb,0x68}, {0xe3,0xee}, {0xe3,0xef}, {0xe3,0xd7}, {0xbb,0x6d}, {0xe3,0xe6}, {0xe3,0xe0}, {0xe3,0xe7}, {0xe3,0xda},
    {0xe3,0xf3}, {0xe3,0xeb}, {0xe3,0xe5}, {0xe3,0xd5}, {0xbb,0x69}, {0xe3,0xec}, {0xbb,0x6c}, {0xe3,0xf0}, {0xe3,0xea}, {0xbb,0x66},
    {0xe3,0xe8}, {0xe3,0xe2}, {0xbb,0x64}, {0xe3,0xd9}, {0xe3,0xe1}, {0xe3,0xed}, {0xe3,0xdf}, {0xe3,0xe3}, {0xbd,0xc1}, {0xdf,0xe9},
    {0xe7,0xb2}, {0xe7,0xbb}, {0xe7,0xb1}, {0xe7,0xad}, {0xe7,0xaa}, {0xbd,0xc2}, {0xe7,0xa8}, {0xbb,0x6b}, {0xe7,0xa1}, {0xbd,0xc0},
    {0xe7,0xa7}, {0xbd,0xbf}, {0xe7,0xac}, {0xe7,0xa9}, {0xe7,0xb9}, {0xe7,0xb4}, {0xe7,0xae}, {0xe7,0xb3}, {0xbd,0xbb}, {0xe7,0xab},
    {0xe7,0xbe}, {0xe7,0xa2}, {0xe7,0xa3}, {0xe7,0xba}, {0xbd,0xbc}, {0xe7,0xbf}, {0xbd,0xbe}, {0xe7,0xc0}, {0xe7,0xb0}, {0xe3,0xd8},
    {0xe7,0xb6}, {0xe7,0xaf}, {0xe7,0xb8}, {0xe7,0xb5}, {0x9d,0xd5}, {0x8f,0xb0}, {0xe7,0xa6}, {0xbd,0xb9}, {0xe7,0xbd}, {0xbd,0xba},
    {0xe7,0xa4}, {0xbd,0xbd}, {0xeb,0x64}, {0xe7,0xb7}, {0xe7,0xbc}, {0xfa,0x7a}, {0xeb,0x61}, {0xbd,0xb8}, {0xbf,0xc0}, {0xeb,0x6b},
    {0xeb,0x67}, {0x9e,0x5f}, {0xeb,0x65}, {0xeb,0x60}, {0xeb,0x6f}, {0x99,0xcd}, {0xa0,0xc9}, {0xbf,0xc4}, {0xeb,0x5c}, {0xeb,0x68},
    {0xeb,0x69}, {0xeb,0x5f}, {0xeb,0x5e}, {0xeb,0x6c}, {0xeb,0x62}, {0xeb,0x5d}, {0xeb,0x63}, {0xeb,0x6e}, {0xeb,0x5b}, {0xeb,0x6d},
    {0xeb,0x6a}, {0xbf,0xc2}, {0xbf,0xc1}, {0xbf,0xc3}, {0xeb,0x66}, {0xf0,0xcb}, {0x9a,0xdb}, {0xa0,0xc6}, {0xee,0x59}, {0xc1,0xb1},
    {0xee,0x5d}, {0xee,0x5a}, {0xee,0x61}, {0xee,0x67}, {0xee,0x5c}, {0x8f,0xb4}, {0xee,0x70}, {0xc1,0xae}, {0xee,0x6a}, {0xee,0x5f},
    {0xee,0x6b}, {0xee,0x66}, {0xee,0x6d}, {0xee,0x5e}, {0xc1,0xb3}, {0xc1,0xb2}, {0xee,0x60}, {0xee,0x6e}, {0xee,0x58}, {0xee,0x6c},
    {0xc1,0xac}, {0xa0,0xd7}, {0xee,0x64}, {0xee,0x63}, {0xee,0x68}, {0xee,0x5b}, {0xc1,0xb0}, {0xc1,0xb4}, {0xee,0x62}, {0xee,0x69},
    {0xc1,0xb5}, {0xee,0x65}, {0xa0,0xc7}, {0xc1,0xad}, {0xc1,0xaf}, {0xf0,0xc7}, {0xf0,0xc5}, {0xa0,0x43}, {0xf0,0xcc}, {0xf0,0xc9},
    {0xf0,0xcd}, {0x8f,0xb5}, {0xf0,0xbe}, {0xf0,0xc6}, {0xf0,0xd1}, {0xee,0x6f}, {0xf0,0xc2}, {0xc2,0xcf}, {0xe7,0xa5}, {0xf0,0xbd},
    {0xf0,0xca}, {0xf0,0xc4}, {0xf0,0xc1}, {0xf0,0xbc}, {0xf0,0xbb}, {0xf0,0xd0}, {0xf0,0xc0}, {0xf0,0xbf}, {0xc2,0xcd}, {0xf0,0xc8},
    {0x8f,0xb2}, {0xc2,0xcc}, {0xc2,0xce}, {0xf0,0xc3}, {0xf0,0xcf}, {0xa0,0x61}, {0xf2,0xde}, {0xf2,0xdf}, {0xc3,0xc9}, {0xf2,0xdc},
    {0xc3,0xc6}, {0xf2,0xe4}, {0xc3,0xca}, {0xf2,0xe6}, {0xf2,0xdb}, {0xf0,0xce}, {0xf2,0xe8}, {0xf2,0xdd}, {0x9e,0x5e}, {0xc3,0xc7},
    {0xf2,0xe3}, {0xf2,0xe5}, {0xf2,0xe0}, {0xf2,0xe7}, {0xf2,0xe2}, {0xf2,0xe1}, {0xc3,0xc8}, {0x8f,0xb6}, {0xf4,0xc5}, {0xf4,0xc6},
    {0xf4,0xc8}, {0xc4,0xae}, {0xc4,0xaf}, {0xf4,0xc9}, {0xf4,0xc7}, {0x9f,0xe8}, {0xf4,0xc4}, {0xf6,0x42}, {0xf6,0x45}, {0xf6,0x41},
    {0xc4,0xfa}, {0xf6,0x43}, {0xc4,0xf9}, {0xc4,0xf8}, {0xc4,0xf7}, {0xf6,0x44}, {0xf7,0x51}, {0xf7,0x4f}, {0x9c,0xb2}, {0xf7,0x4e},
    {0xf6,0x40}, {0xf7,0x50}, {0xf6,0x46}, {0xf7,0x4d}, {0x95,0x7c}, {0xf7,0xf9}, {0xf7,0xd7}, {0xf7,0xf7}, {0xc5,0xdb}, {0xf7,0xf8},
    {0xf7,0xfa}, {0xf8,0xbf}, {0xc5,0xfa}, {0xf8,0xbe}, {0xf8,0xbd}, {0xc5,0xfb}, {0xc6,0x5a}, {0xf9,0x6e}, {0xf9,0xa7}, {0xf9,0xa6},
    {0xf9,0xa8}, {0xa6,0xe5}, {0xd0,0xaa}, {0x9f,0xc7}, {0xd3,0xcf}, {0xd3,0xd0}, {0x8f,0xbb}, {0x8f,0xbc}, {0xdb,0xc0}, {0xf6,0x47},
    {0xf8,0xc0}, {0xa6,0xe6}, {0xad,0x6c}, {0xd0,0xab}, {0x8f,0xec}, {0xd7,0xb1}, {0xb3,0x4e}, {0xdb,0xc2}, {0xdb,0xc1}, {0xb5,0xf3},
    {0xb8,0xc5}, {0xe7,0xc1}, {0xbd,0xc3}, {0xbd,0xc4}, {0x8f,0xc0}, {0x93,0x6a}, {0xbf,0xc5}, {0xc5,0xfc}, {0xa6,0xe7}, {0x8b,0xe4},
    {0x9c,0x7c}, {0xd0,0xac}, {0xaa,0xed}, {0xd0,0xae}, {0xd0,0xad}, {0xad,0x6d}, {0xd3,0xd1}, {0x95,0xa1}, {0xd3,0xd8}, {0xb0,0x49},
    {0xd3,0xd6}, {0xd3,0xd4}, {0xd3,0xdb}, {0xd3,0xd2}, {0xd3,0xd3}, {0xb0,0x4a}, {0xb0,0x4e}, {0xd3,0xdc}, {0xb0,0x4d}, {0xd3,0xda},
    {0xd3,0xd7}, {0xd3,0xd5}, {0xb0,0x4b}, {0xb0,0x4c}, {0xd3,0xd9}, {0xfe,0xec}, {0x95,0xa3}, {0xb3,0x50}, {0xd7,0xb2}, {0xb3,0x55},
    {0xd7,0xc2}, {0xb3,0x54}, {0xd7,0xc4}, {0x8c,0x45}, {0x8c,0xb8}, {0xd7,0xb8}, {0xb3,0x52}, {0xd7,0xc3}, {0xd7,0xb3}, {0xb3,0x53},
    {0xd7,0xbf}, {0xd7,0xbb}, {0xd7,0xbd}, {0xd7,0xb7}, {0xd7,0xbe}, {0x8f,0xc1}, {0xb3,0x4f}, {0xd7,0xba}, {0xa0,0x52}, {0xd7,0xb9},
    {0xd7,0xb5}, {0xd7,0xc0}, {0xd7,0xbc}, {0xd7,0xb4}, {0xd7,0xb6}, {0xb3,0x51}, {0xd7,0xc1}, {0x99,0xd0}, {0xb5,0xf6}, {0xdb,0xcd},
    {0x8f,0xc3}, {0x8f,0xc4}, {0xdb,0xc9}, {0xdb,0xcb}, {0xdb,0xc6}, {0xdb,0xc5}, {0xdb,0xc3}, {0xdb,0xca}, {0xdb,0xcc}, {0xdb,0xc8},
    {0x95,0xa4}, {0xdb,0xc7}, {0xb5,0xf4}, {0xb5,0xf5}, {0x8f,0xc6}, {0x9e,0x60}, {0xdb,0xcf}, {0xb8,0xcd}, {0xdf,0xf2}, {0xdf,0xf8},
    {0xdf,0xf3}, {0xdf,0xf4}, {0xf9,0xd8}, {0xdf,0xf9}, {0xb8,0xcf}, {0xb8,0xc7}, {0xb8,0xce}, {0xdf,0xf1}, {0xdb,0xc4}, {0xb8,0xca},
    {0xb8,0xc8}, {0xdf,0xf7}, {0xdf,0xf6}, {0xb8,0xc9}, {0xb8,0xcb}, {0xdf,0xf5}, {0xb8,0xc6}, {0xb8,0xcc}, {0x95,0xa5}, {0xe3,0xf6},
    {0xbb,0x74}, {0xe4,0x42}, {0xe4,0x41}, {0xe3,0xfb}, {0xbb,0x76}, {0xe4,0x40}, {0xe3,0xf7}, {0xe3,0xf8}, {0xbb,0x6e}, {0xbb,0x70},
    {0x9c,0xb3}, {0xe3,0xfd}, {0xe3,0xf5}, {0xbb,0x72}, {0xbb,0x71}, {0xe3,0xf9}, {0xe3,0xfe}, {0xe3,0xfc}, {0xbb,0x73}, {0xe3,0xfa},
    {0x99,0xd1}, {0xfe,0xf1}, {0xdb,0xce}, {0xbb,0x6f}, {0xe7,0xc2}, {0xe7,0xc9}, {0xbd,0xc6}, {0xe7,0xcd}, {0xbd,0xca}, {0xe7,0xc5},
    {0xe7,0xc3}, {0xe7,0xcc}, {0xbd,0xc5}, {0xe7,0xcb}, {0xbd,0xc7}, {0xbd,0xc8}, {0xe7,0xc4}, {0xbd,0xc9}, {0xe7,0xca}, {0xe7,0xc6},
    {0xe7,0xc7}, {0xe7,0xc8}, {0xbb,0x75}, {0xeb,0x70}, {0xeb,0x7c}, {0xbf,0xca}, {0xeb,0x77}, {0xeb,0x79}, {0x99,0xd2}, {0xbf,0xc8},
    {0xeb,0x71}, {0xeb,0x75}, {0xeb,0x78}, {0xbf,0xc6}, {0xbf,0xc9}, {0xeb,0x7b}, {0xeb,0x73}, {0xeb,0x74}, {0xeb,0x7a}, {0xeb,0x72},
    {0xeb,0x76}, {0xbf,0xc7}, {0xee,0x72}, {0xee,0x71}, {0xc1,0xb7}, {0xee,0x77}, {0xc1,0xb9}, {0xc1,0xb6}, {0xee,0x73}, {0xc1,0xba},
    {0xee,0x74}, {0xee,0x75}, {0xee,0x78}, {0x9c,0xc2}, {0xc1,0xb8}, {0xf0,0xd6}, {0x99,0xd3}, {0xf0,0xd9}, {0xf0,0xd3}, {0xf0,0xd5},
    {0x95,0xa7}, {0xf0,0xd4}, {0xf0,0xd7}, {0xf0,0xd8}, {0xee,0x76}, {0xf0,0xd2}, {0x95,0xa9}, {0xc3,0xcd}, {0xf2,0xec}, {0xf2,0xef},
    {0xf2,0xf1}, {0xf2,0xea}, {0xf2,0xeb}, {0xf2,0xee}, {0xf2,0xf0}, {0xc3,0xce}, {0xc3,0xcc}, {0xc3,0xcb}, {0xf2,0xed}, {0xf2,0xe9},
    {0xf4,0xca}, {0xc4,0xb0}, {0x95,0xa6}, {0xf4,0xcb}, {0xf6,0x49}, {0xc4,0xfb}, {0xf6,0x4b}, {0xc4,0xfc}, {0xf6,0x48}, {0xf6,0x4a},
    {0xc5,0xa8}, {0xf7,0x52}, {0xc5,0xa7}, {0xf7,0xfd}, {0xf7,0xfc}, {0xf7,0xfb}, {0x9c,0x5d}, {0xf9,0x48}, {0xf9,0x49}, {0xf9,0x4b},
    {0xf9,0x4a}, {0xca,0x50}, {0xa6,0xe8}, {0x98,0xe2}, {0xad,0x6e}, {0xd7,0xc5}, {0xb5,0xf7}, {0xdf,0xfa}, {0xc2,0xd0}, {0x8f,0xc9},
    {0xf2,0xf2}, {0xa0,0xc2}, {0x8f,0xca}, {0xa8,0xa3}, {0xb3,0x57}, {0x99,0xd4}, {0xb3,0x56}, {0xa0,0xb9}, {0xdb,0xd0}, {0xb5,0xf8},
    {0xdb,0xd2}, {0xdb,0xd1}, {0xdf,0xfb}, {0xb8,0xd0}, {0xe4,0x43}, {0xe4,0x46}, {0xe4,0x45}, {0xe4,0x44}, {0xe7,0xce}, {0xe7,0xd0},
    {0xe7,0xcf}, {0x9b,0x58}, {0xbf,0xcc}, {0x8f,0xcd}, {0xa0,0xd4}, {0xbf,0xcb}, {0xc1,0xbb}, {0xee,0x79}, {0xee,0x7b}, {0xee,0x7a},
    {0xc2,0xd1}, {0xf2,0xf4}, {0xf2,0xf3}, {0xf4,0xcc}, {0xc4,0xb1}, {0x8f,0xce}, {0xc4,0xfd}, {0xf7,0x54}, {0xf7,0x53}, {0xc6,0x5b},
    {0x8b,0xe5}, {0x89,0x79}, {0xa8,0xa4}, {0xd0,0xaf}, {0xad,0x6f}, {0xd7,0xc8}, {0xd7,0xc6}, {0xd7,0xc7}, {0xdb,0xd4}, {0xdb,0xd5},
    {0xe0,0x43}, {0xdb,0xd3}, {0xdf,0xfc}, {0xe0,0x41}, {0xe0,0x40}, {0xe0,0x42}, {0xb8,0xd1}, {0xdf,0xfe}, {0xdf,0xfd}, {0xe0,0x44},
    {0x8f,0xd0}, {0xe4,0x49}, {0xe4,0x47}, {0xe4,0x48}, {0xe7,0xd3}, {0xe7,0xd1}, {0xe7,0xd2}, {0xeb,0x7d}, {0xee,0x7c}, {0xee,0x7d},
    {0xc2,0xd2}, {0xf2,0xf5}, {0xf4,0xcd}, {0xc4,0xb2}, {0xf6,0x4c}, {0xf7,0x55}, {0xc5,0xa9}, {0xf7,0xfe}, {0xf9,0x4c}, {0xa8,0xa5},
    {0xad,0x71}, {0xad,0x72}, {0xd0,0xb0}, {0xd0,0xb1}, {0xad,0x70}, {0xb0,0x54}, {0xb0,0x52}, {0xb0,0x51}, {0xb0,0x58}, {0xb0,0x50},
    {0xb0,0x59}, {0xd3,0xdd}, {0xb0,0x56}, {0xb0,0x53}, {0xb0,0x57}, {0xb0,0x55}, {0xb0,0x4f}, {0xb3,0x5f}, {0x95,0xb6}, {0xb3,0x59},
    {0xd7,0xcc}, {0xb3,0x5e}, {0xb3,0x60}, {0xb3,0x5a}, {0xb3,0x5b}, {0xd7,0xca}, {0x99,0xd6}, {0xb3,0x58}, {0x95,0xe5}, {0xd7,0xcb},
    {0xb3,0x5d}, {0xd7,0xc9}, {0xb3,0x5c}, {0xb6,0x44}, {0xb6,0x46}, {0x99,0xd7}, {0xdb,0xd8}, {0xb6,0x45}, {0xb5,0xf9}, {0xb5,0xfd},
    {0x95,0xb5}, {0xb8,0xe4}, {0xe0,0x49}, {0xdb,0xda}, {0xb5,0xfe}, {0xdb,0xdd}, {0xdb,0xde}, {0xb6,0x43}, {0xdb,0xe0}, {0xa0,0xca},
    {0xdb,0xe2}, {0xdb,0xe3}, {0xdb,0xd7}, {0xdb,0xd6}, {0xdb,0xe4}, {0xb6,0x42}, {0xdb,0xe1}, {0xdb,0xdf}, {0xb6,0x40}, {0xb5,0xfb},
    {0xb6,0x47}, {0xdb,0xdb}, {0xdb,0xdc}, {0xdb,0xd9}, {0xb6,0x41}, {0xb5,0xfc}, {0xb5,0xfa}, {0xe0,0x48}, {0xb8,0xdf}, {0xb8,0xda},
    {0xb8,0xd5}, {0x9f,0xfd}, {0xb8,0xe5}, {0xb8,0xd6}, {0xb8,0xd2}, {0xb8,0xe1}, {0xb8,0xde}, {0xb8,0xe0}, {0xb8,0xd7}, {0xb8,0xdc},
    {0xb8,0xd3}, {0xb8,0xd4}, {0xe0,0x50}, {0xe0,0x4d}, {0xe0,0x45}, {0xe0,0x4a}, {0xb8,0xe2}, {0xe0,0x51}, {0xb8,0xe3}, {0xb8,0xd9},
    {0xa0,0x58}, {0xe0,0x47}, {0xe0,0x4f}, {0xe0,0x4b}, {0xe0,0x4e}, {0xe0,0x4c}, {0xb8,0xdd}, {0xe0,0x46}, {0xb8,0xd8}, {0xe4,0x4c},
    {0xbb,0x78}, {0xbb,0x7b}, {0xe4,0x4e}, {0x8f,0xd6}, {0xbb,0xa5}, {0xe4,0x4d}, {0xbb,0x7d}, {0x99,0xd8}, {0xbd,0xcf}, {0xe4,0x4f},
    {0xbb,0xa4}, {0xe4,0x4b}, {0xbb,0xa6}, {0x8f,0xd3}, {0xbb,0x79}, {0xb8,0xdb}, {0xbb,0x7c}, {0xbb,0x7a}, {0xbb,0x7e}, {0xbb,0xa2},
    {0xbb,0x77}, {0xbb,0xa7}, {0xbb,0xa3}, {0x8f,0xe5}, {0xbb,0xa1}, {0xe4,0x4a}, {0x8f,0xe9}, {0xbd,0xd6}, {0xbd,0xd2}, {0x99,0xd9},
    {0xbd,0xd9}, {0xe7,0xd6}, {0xbd,0xda}, {0xe7,0xe2}, {0xe7,0xdb}, {0xbd,0xcb}, {0xe7,0xe3}, {0xe7,0xdd}, {0xbd,0xd5}, {0xe7,0xde},
    {0xbd,0xd4}, {0xe7,0xe1}, {0xbd,0xce}, {0xe7,0xdf}, {0xe7,0xd5}, {0xbd,0xcd}, {0xeb,0xaa}, {0xbd,0xd3}, {0xbd,0xd0}, {0xbd,0xd8},
    {0xe7,0xd4}, {0xe7,0xd8}, {0xbd,0xcc}, {0xe7,0xd7}, {0xe7,0xd9}, {0xe7,0xda}, {0xbd,0xd7}, {0xe7,0xdc}, {0xe7,0xe0}, {0xe7,0xe4},
    {0x92,0x7c}, {0xbd,0xdb}, {0xbf,0xd2}, {0xeb,0xa5}, {0xeb,0xab}, {0xeb,0xa8}, {0xeb,0x7e}, {0xeb,0xac}, {0xeb,0xa1}, {0xeb,0xa7},
    {0xbf,0xcd}, {0xbf,0xd3}, {0xeb,0xad}, {0x9c,0x45}, {0xbf,0xcf}, {0xbf,0xd9}, {0xbf,0xd4}, {0xeb,0xaf}, {0xeb,0xa9}, {0xbf,0xd0},
    {0xeb,0xa2}, {0xbf,0xda}, {0xeb,0xa3}, {0xeb,0xa4}, {0xbf,0xdb}, {0xbf,0xd8}, {0xbd,0xd1}, {0xbf,0xce}, {0xeb,0xb0}, {0xbf,0xdc},
    {0xbf,0xd5}, {0xeb,0xae}, {0xbf,0xd1}, {0xbf,0xd6}, {0xbf,0xd7}, {0xc1,0xc3}, {0xee,0xa4}, {0xee,0xad}, {0xee,0xaa}, {0xee,0xac},
    {0xc1,0xc0}, {0xee,0xa5}, {0x8f,0xde}, {0xee,0xab}, {0xc1,0xbc}, {0xee,0xa7}, {0xc1,0xc4}, {0xee,0xa3}, {0xee,0xa8}, {0xee,0xaf},
    {0xeb,0xa6}, {0xee,0xa9}, {0xee,0xa2}, {0xc1,0xbd}, {0xee,0xa1}, {0xc1,0xbe}, {0xee,0xb0}, {0xc1,0xbf}, {0xee,0xae}, {0xc1,0xc2},
    {0xee,0x7e}, {0x8f,0xdf}, {0xc1,0xc1}, {0xee,0xa6}, {0xf0,0xdc}, {0xf0,0xea}, {0xf0,0xe5}, {0xf0,0xe7}, {0xf0,0xdb}, {0xc2,0xd3},
    {0xf0,0xda}, {0xc2,0xd6}, {0xc2,0xd5}, {0xa0,0x4b}, {0xf0,0xe9}, {0xf0,0xe1}, {0xf0,0xde}, {0xf0,0xe4}, {0xf0,0xdd}, {0xf0,0xdf},
    {0xf0,0xe8}, {0xf0,0xe6}, {0xc2,0xd4}, {0xf0,0xed}, {0xf0,0xeb}, {0xf0,0xe2}, {0xf0,0xec}, {0xf0,0xe3}, {0x8f,0xe2}, {0xf2,0xf9},
    {0xc3,0xcf}, {0xf3,0x41}, {0xa0,0xcc}, {0xf6,0x4f}, {0xc3,0xd6}, {0xf0,0xe0}, {0xf2,0xf7}, {0xc3,0xd2}, {0xf2,0xf8}, {0xf2,0xfd},
    {0x8f,0xe3}, {0x8f,0xe4}, {0xc3,0xd4}, {0xc3,0xd5}, {0xf2,0xf6}, {0xf3,0x40}, {0xf3,0x42}, {0xf2,0xfa}, {0xf2,0xfc}, {0xf2,0xfe},
    {0xf2,0xfb}, {0xf3,0x43}, {0xc3,0xd1}, {0xc3,0xd7}, {0xc3,0xd3}, {0xc3,0xd0}, {0xf4,0xd0}, {0x9b,0xc4}, {0xc4,0xb7}, {0xf4,0xce},
    {0x9b,0xfc}, {0xf4,0xd2}, {0xf4,0xd3}, {0xc4,0xb5}, {0xf4,0xd4}, {0xf4,0xd1}, {0x96,0x4c}, {0xf4,0xcf}, {0xc4,0xb8}, {0xc4,0xb4},
    {0xf4,0xd5}, {0xc4,0xb6}, {0xc4,0xb3}, {0xc4,0xfe}, {0xc5,0x40}, {0xf6,0x4e}, {0xf6,0x4d}, {0xf6,0x50}, {0xf6,0x51}, {0xc5,0x41},
    {0xf7,0x56}, {0xf7,0x5b}, {0xc5,0xaa}, {0x9a,0xf6}, {0xf7,0x58}, {0x8c,0xae}, {0xf7,0x57}, {0xf7,0x5a}, {0xf7,0x59}, {0xf8,0x43},
    {0xc5,0xdc}, {0xf8,0x42}, {0xf8,0x40}, {0xf8,0x41}, {0x8f,0xe7}, {0xc5,0xfe}, {0xc5,0xfd}, {0xf8,0xc1}, {0xf8,0xc2}, {0xc6,0x40},
    {0xf9,0x4d}, {0xf9,0x4e}, {0xc6,0x67}, {0x8f,0xe8}, {0xc6,0x6d}, {0xf9,0xa9}, {0xf9,0xc8}, {0x8b,0xe7}, {0x89,0x7a}, {0x89,0x7b},
    {0xa8,0xa6}, {0xd7,0xcd}, {0xd7,0xce}, {0xe0,0x52}, {0xe4,0x50}, {0xe7,0xe5}, {0xc1,0xc6}, {0xc1,0xc5}, {0xf0,0xee}, {0xf3,0x44},
    {0xf8,0x44}, {0xa8,0xa7}, {0xd3,0xde}, {0xb0,0x5a}, {0xb3,0x61}, {0xe0,0x54}, {0xe0,0x53}, {0xbd,0xdc}, {0xe7,0xe6}, {0xbd,0xdd},
    {0xee,0xb1}, {0xc2,0xd7}, {0x99,0xda}, {0xc6,0x76}, {0xa8,0xa8}, {0xcd,0xcb}, {0xd3,0xdf}, {0xb3,0x62}, {0xd7,0xcf}, {0xd7,0xd0},
    {0xdb,0xe5}, {0xb6,0x48}, {0xb8,0xe6}, {0xe0,0x56}, {0xe0,0x55}, {0xe0,0x57}, {0xe4,0x51}, {0xe4,0x52}, {0xbb,0xa8}, {0xbf,0xdd},
    {0xbd,0xde}, {0xbf,0xde}, {0xee,0xb5}, {0xee,0xb2}, {0xee,0xb4}, {0xee,0xb3}, {0xc1,0xc7}, {0xf0,0xef}, {0xf3,0x46}, {0xf3,0x45},
    {0xcb,0xa4}, {0xb0,0x5c}, {0xb0,0x5b}, {0xd3,0xe0}, {0xd7,0xd1}, {0xdb,0xe7}, {0xdb,0xe6}, {0xb6,0x49}, {0xe0,0x59}, {0xe0,0x5a},
    {0xe0,0x58}, {0xb8,0xe8}, {0xb8,0xe7}, {0xbb,0xaa}, {0xbb,0xa9}, {0xe7,0xe7}, {0xeb,0xb3}, {0xeb,0xb1}, {0xeb,0xb2}, {0xbf,0xdf},
    {0xee,0xb7}, {0xee,0xb6}, {0xf0,0xf2}, {0xf0,0xf1}, {0xf0,0xf0}, {0xf3,0x47}, {0x8f,0xed}, {0xf9,0xaa}, {0xa8,0xa9}, {0xad,0x73},
    {0x95,0xc0}, {0xad,0x74}, {0xb0,0x5d}, {0xb0,0x5e}, {0xd3,0xe2}, {0xd3,0xe1}, {0xd7,0xd2}, {0xb3,0x68}, {0xb3,0x66}, {0xb3,0x63},
    {0xb3,0x67}, {0xb3,0x65}, {0xb3,0x64}, {0xa0,0xcb}, {0xb6,0x4a}, {0xdb,0xea}, {0xb8,0xed}, {0xb6,0x4c}, {0xb6,0x51}, {0xdb,0xec},
    {0xb6,0x53}, {0xb6,0x52}, {0xb6,0x55}, {0xdb,0xeb}, {0xdb,0xe8}, {0xb6,0x4f}, {0xb6,0x4b}, {0xb6,0x4d}, {0xdb,0xe9}, {0xb6,0x54},
    {0xb6,0x50}, {0xb6,0x4e}, {0xb8,0xef}, {0xb8,0xee}, {0xb8,0xec}, {0xb8,0xf0}, {0xb8,0xea}, {0xb8,0xeb}, {0xb8,0xe9}, {0xe0,0x5b},
    {0x9e,0x48}, {0xe4,0x54}, {0xbb,0xac}, {0xbb,0xad}, {0xbb,0xab}, {0x99,0xdb}, {0xe4,0x53}, {0x8f,0xf3}, {0xe4,0x55}, {0xe7,0xea},
    {0xe7,0xec}, {0x8f,0xf9}, {0xbd,0xe7}, {0xe7,0xed}, {0xbd,0xe0}, {0xe7,0xe9}, {0xbd,0xdf}, {0xbd,0xe9}, {0xbd,0xe5}, {0xbd,0xe6},
    {0xbd,0xe2}, {0xe7,0xe8}, {0xbd,0xe1}, {0xe7,0xee}, {0xe7,0xeb}, {0x95,0xc1}, {0xbd,0xe8}, {0xa0,0x4e}, {0xbd,0xe3}, {0xbd,0xe4},
    {0xeb,0xb5}, {0xeb,0xb7}, {0xeb,0xb6}, {0x99,0xdc}, {0xeb,0xb8}, {0xbf,0xe0}, {0xeb,0xb4}, {0xa0,0x64}, {0xc1,0xcb}, {0xee,0xb8},
    {0xc1,0xc8}, {0xc1,0xcc}, {0xc1,0xca}, {0xc1,0xc9}, {0xf0,0xf3}, {0xf0,0xf6}, {0xf0,0xf5}, {0x8f,0xf7}, {0xf0,0xf4}, {0xc2,0xd8},
    {0xf3,0x48}, {0xf3,0x49}, {0xc3,0xd8}, {0xf3,0x4a}, {0xc3,0xd9}, {0x89,0xb0}, {0xa0,0x48}, {0xc4,0xba}, {0xc4,0xb9}, {0xf6,0x52},
    {0x8f,0xfb}, {0x8f,0xf6}, {0xc5,0x42}, {0xf6,0x53}, {0xf7,0x5c}, {0xc5,0xab}, {0xc5,0xac}, {0x9d,0xdc}, {0xf8,0x45}, {0xc6,0x42},
    {0x99,0xdd}, {0x8b,0xe8}, {0xa8,0xaa}, {0xb3,0x6a}, {0xb3,0x69}, {0xe0,0x5c}, {0xe0,0x5d}, {0xbb,0xae}, {0xeb,0xb9}, {0xbd,0xea},
    {0xeb,0xba}, {0xee,0xb9}, {0xa8,0xab}, {0xd0,0xb2}, {0xad,0x76}, {0xad,0x75}, {0xd3,0xe3}, {0xb0,0x5f}, {0xd3,0xe4}, {0xd7,0xd5},
    {0x92,0xc1}, {0xd7,0xd4}, {0xd7,0xd3}, {0xdb,0xee}, {0xb6,0x58}, {0x9f,0xd6}, {0xdb,0xed}, {0xb6,0x57}, {0xdb,0xef}, {0xb6,0x56},
    {0xe0,0x5f}, {0xe0,0x62}, {0xe0,0x60}, {0xe0,0x61}, {0xe0,0x65}, {0xe0,0x5e}, {0xe0,0x66}, {0xe0,0x63}, {0xe0,0x64}, {0xbb,0xb0},
    {0xe4,0x56}, {0xbb,0xaf}, {0xe7,0xf2}, {0xe7,0xf0}, {0xbd,0xeb}, {0xe7,0xef}, {0xe7,0xf1}, {0xbd,0xec}, {0xeb,0xbb}, {0xa0,0xd2},
    {0xeb,0xbc}, {0xc1,0xcd}, {0x90,0x40}, {0xf3,0x4c}, {0xf3,0x4e}, {0xf3,0x4b}, {0xf3,0x4d}, {0xf4,0xd6}, {0xf6,0x54}, {0xf9,0x6f},
    {0xa8,0xac}, {0xad,0x77}, {0xd3,0xe5}, {0xd3,0xe7}, {0xd3,0xe6}, {0xd7,0xd8}, {0xb3,0x6c}, {0xd7,0xd6}, {0xb3,0x6b}, {0xd7,0xd9},
    {0x8a,0xc4}, {0xd7,0xda}, {0xd7,0xd7}, {0x99,0xe0}, {0xdb,0xfb}, {0xb6,0x60}, {0xdb,0xf3}, {0xdb,0xf9}, {0xb6,0x5b}, {0xb6,0x5e},
    {0xdb,0xf2}, {0xb6,0x59}, {0xdb,0xf6}, {0xe0,0x6c}, {0xb6,0x5d}, {0xdb,0xf1}, {0x9f,0xf0}, {0xdb,0xf7}, {0xdb,0xf4}, {0xdb,0xfa},
    {0xdb,0xf0}, {0xdb,0xf8}, {0xb6,0x5c}, {0xb6,0x5f}, {0xdb,0xf5}, {0xb6,0x5a}, {0xb8,0xf2}, {0xe0,0x68}, {0xb8,0xf1}, {0xe0,0x6f},
    {0xe0,0x6e}, {0xb8,0xf8}, {0xb8,0xf9}, {0xe0,0x70}, {0xb8,0xf3}, {0xe0,0x6d}, {0xb8,0xf7}, {0xe0,0x72}, {0xe0,0x69}, {0xe0,0x6b},
    {0xb8,0xf4}, {0xe0,0x67}, {0xe0,0x6a}, {0xe0,0x71}, {0xb8,0xf5}, {0xe0,0x73}, {0xb8,0xf6}, {0xbb,0xb1}, {0xe4,0x5b}, {0xe4,0x61},
    {0xe4,0x59}, {0xe4,0x62}, {0x9f,0xf3}, {0xe4,0x58}, {0xe4,0x5d}, {0xe4,0x63}, {0xe4,0x60}, {0xe4,0x5f}, {0xe4,0x5e}, {0xe4,0x57},
    {0xe4,0x5c}, {0xe4,0x5a}, {0x9d,0xbf}, {0xbd,0xf1}, {0xbd,0xee}, {0xe7,0xfb}, {0xe8,0x41}, {0xe8,0x43}, {0xe8,0x40}, {0xe7,0xf8},
    {0xe7,0xfa}, {0xe8,0x45}, {0xe8,0x42}, {0xe7,0xfc}, {0xe8,0x46}, {0xe7,0xf9}, {0xe8,0x44}, {0xbd,0xef}, {0xbd,0xf5}, {0xbd,0xf3},
    {0xe7,0xf3}, {0xbd,0xf4}, {0xbd,0xf0}, {0xe7,0xf4}, {0xe7,0xf6}, {0xe7,0xf5}, {0xe7,0xfd}, {0xe7,0xfe}, {0x9f,0xf6}, {0xbd,0xf2},
    {0x95,0xc8}, {0xbd,0xed}, {0x9e,0x5a}, {0xe7,0xf7}, {0xeb,0xc6}, {0xbf,0xe2}, {0xeb,0xbd}, {0xbf,0xe3}, {0xbf,0xe6}, {0xeb,0xc2},
    {0xeb,0xbf}, {0xbf,0xe5}, {0x99,0xe3}, {0xeb,0xc3}, {0xeb,0xc4}, {0xeb,0xbe}, {0xeb,0xc7}, {0xeb,0xc0}, {0xeb,0xc5}, {0xbf,0xe4},
    {0xbf,0xe1}, {0xeb,0xc1}, {0x8a,0x4a}, {0xee,0xbf}, {0xc1,0xd0}, {0xc1,0xce}, {0xc1,0xd1}, {0xc1,0xcf}, {0xee,0xbe}, {0xee,0xbb},
    {0xee,0xba}, {0x9f,0xf1}, {0xee,0xbd}, {0xee,0xbc}, {0xf1,0x45}, {0xc2,0xde}, {0xf0,0xfb}, {0xf0,0xfa}, {0xc2,0xd9}, {0xf1,0x41},
    {0xf1,0x40}, {0xf0,0xf7}, {0xf1,0x43}, {0xf0,0xfc}, {0xc2,0xdd}, {0xf0,0xf9}, {0xf1,0x42}, {0xf0,0xf8}, {0xc2,0xda}, {0xc2,0xdc},
    {0xf0,0xfd}, {0xc2,0xdb}, {0xf0,0xfe}, {0x8a,0xa7}, {0xf1,0x44}, {0xf3,0x52}, {0xc3,0xde}, {0xf3,0x4f}, {0xf3,0x53}, {0x99,0xe6},
    {0xc3,0xdb}, {0xf3,0x51}, {0xc3,0xe0}, {0x9f,0xf7}, {0xc3,0xdd}, {0x9f,0xed}, {0xf3,0x50}, {0xc3,0xdf}, {0xf3,0x54}, {0xc3,0xda},
    {0x8a,0x5c}, {0x9d,0xae}, {0xc4,0xbc}, {0xc4,0xbe}, {0xf4,0xd9}, {0xc4,0xbd}, {0xf4,0xd7}, {0xc3,0xdc}, {0xf4,0xd8}, {0xc4,0xbb},
    {0xc5,0x43}, {0xc5,0x45}, {0xf6,0x56}, {0xc5,0x44}, {0xf6,0x55}, {0xf7,0x61}, {0xc5,0xad}, {0xf7,0x60}, {0xc5,0xae}, {0xf7,0x5e},
    {0xf7,0x5d}, {0xf7,0x62}, {0xf7,0x63}, {0xf8,0x46}, {0xf7,0x5f}, {0xf8,0xc6}, {0xf8,0xc3}, {0xf8,0xc4}, {0xf8,0xc5}, {0xc6,0x5c},
    {0xf9,0x51}, {0xf9,0x50}, {0xf9,0x4f}, {0xf9,0x70}, {0x95,0xc9}, {0xf9,0xbe}, {0xf9,0xab}, {0xc6,0x6e}, {0xa8,0xad}, {0xb0,0x60},
    {0x90,0x48}, {0x99,0xe8}, {0xb8,0xfa}, {0x90,0x49}, {0x8c,0xba}, {0xbd,0xf6}, {0x90,0xb1}, {0xeb,0xc8}, {0xc2,0xdf}, {0xf3,0x55},
    {0x90,0x4a}, {0xf9,0xac}, {0xa8,0xae}, {0xaa,0xee}, {0xad,0x79}, {0xad,0x78}, {0x99,0xea}, {0xb0,0x63}, {0xd3,0xe8}, {0xb0,0x61},
    {0xd3,0xe9}, {0xb0,0x62}, {0xd7,0xdf}, {0xd7,0xdb}, {0x9b,0xd1}, {0xb3,0x6d}, {0xd7,0xde}, {0xd7,0xdd}, {0xd7,0xdc}, {0xb3,0x6e},
    {0xd7,0xe0}, {0xd7,0xe1}, {0x99,0xeb}, {0x99,0xec}, {0xdc,0x43}, {0xdc,0x41}, {0xdc,0x45}, {0xdc,0x46}, {0xdc,0x4c}, {0xdc,0x48},
    {0xdc,0x4a}, {0x99,0xed}, {0xdc,0x42}, {0xdb,0xfc}, {0xdc,0x49}, {0x99,0xee}, {0xdc,0x4b}, {0xdc,0x44}, {0xdc,0x47}, {0xdb,0xfd},
    {0xb6,0x62}, {0xdc,0x40}, {0xdb,0xfe}, {0xb6,0x61}, {0xb6,0x63}, {0xb8,0xfd}, {0xe0,0x75}, {0xe0,0x77}, {0xe0,0x76}, {0xe0,0x7b},
    {0xb8,0xfb}, {0xe0,0x78}, {0xe0,0x74}, {0xe0,0x79}, {0xe0,0x7a}, {0xb8,0xfc}, {0xb8,0xfe}, {0xe0,0x7c}, {0xe4,0x67}, {0xe4,0x66},
    {0xe4,0x64}, {0xe4,0x65}, {0xbb,0xb3}, {0xbb,0xb5}, {0xbb,0xb2}, {0xbb,0xb4}, {0xe8,0x4d}, {0xe8,0x4e}, {0xe8,0x49}, {0x90,0x4c},
    {0xe8,0x4a}, {0xbd,0xf8}, {0xbd,0xfd}, {0xbd,0xf7}, {0xbd,0xfe}, {0xbd,0xf9}, {0xe8,0x4b}, {0xe8,0x4c}, {0xe8,0x48}, {0xbe,0x40},
    {0xbd,0xfb}, {0xbd,0xfa}, {0xbd,0xfc}, {0xe8,0x47}, {0x90,0x4d}, {0xeb,0xca}, {0xbf,0xe8}, {0x95,0xcb}, {0xeb,0xcc}, {0xbf,0xea},
    {0xeb,0xcf}, {0xeb,0xcb}, {0xeb,0xc9}, {0xeb,0xce}, {0xbf,0xe9}, {0xeb,0xcd}, {0xbf,0xe7}, {0xc1,0xd3}, {0xc1,0xd6}, {0xee,0xc1},
    {0x97,0xe2}, {0xc1,0xd4}, {0xee,0xc0}, {0xc1,0xd2}, {0xc1,0xd5}, {0xf1,0x46}, {0xf1,0x47}, {0xf1,0x48}, {0xc2,0xe0}, {0x95,0xcc},
    {0xf1,0x49}, {0xc2,0xe1}, {0xc3,0xe2}, {0xf3,0x58}, {0xf3,0x59}, {0xf3,0x57}, {0xf3,0x56}, {0xf3,0x5a}, {0xc3,0xe1}, {0xf4,0xdd},
    {0xf4,0xdb}, {0xf4,0xdc}, {0xf4,0xde}, {0xf4,0xda}, {0xf4,0xdf}, {0xf6,0x58}, {0x9f,0x78}, {0xf6,0x59}, {0xf6,0x57}, {0xc5,0x46},
    {0xf7,0x64}, {0xc5,0xaf}, {0xf7,0x65}, {0xf8,0x48}, {0xf8,0x47}, {0x89,0x7c}, {0x89,0x7d}, {0x89,0x7e}, {0x99,0x5d}, {0xa8,0xaf},
    {0xb6,0x64}, {0xb9,0x40}, {0x9b,0x5a}, {0xbb,0xb6}, {0x90,0x50}, {0xbf,0xec}, {0x8c,0x4f}, {0xbf,0xeb}, {0xc3,0xe3}, {0xc4,0x7c},
    {0xc5,0x47}, {0xa8,0xb0}, {0xb0,0x64}, {0xb9,0x41}, {0x90,0x54}, {0xf3,0x5b}, {0xc6,0xd6}, {0x9a,0xa8}, {0x99,0xef}, {0xfe,0xeb},
    {0x9d,0xa3}, {0x9d,0xa1}, {0x99,0x43}, {0x99,0x45}, {0x9d,0x7d}, {0xcb,0xa6}, {0x99,0xf0}, {0xa8,0xb1}, {0xa8,0xb4}, {0xa8,0xb3},
    {0xa8,0xb2}, {0xcb,0xa5}, {0x99,0xf1}, {0xcd,0xcd}, {0x99,0xf2}, {0xcd,0xcf}, {0xaa,0xef}, {0x8c,0xbc}, {0x9d,0x60}, {0xaa,0xf1},
    {0xcd,0xcc}, {0xcd,0xce}, {0xaa,0xf0}, {0xcd,0xd1}, {0xcd,0xd0}, {0xcd,0xd2}, {0xa0,0xa3}, {0xd0,0xb6}, {0xd0,0xb4}, {0xad,0x7c},
    {0xd0,0xb3}, {0xad,0xa3}, {0xad,0x7e}, {0xad,0x7b}, {0xad,0xa4}, {0xad,0x7d}, {0xad,0xa2}, {0xad,0xa1}, {0xd0,0xb5}, {0xad,0x7a},
    {0xb0,0x6a}, {0xd3,0xeb}, {0xd3,0xf1}, {0xb0,0x67}, {0xb0,0x6e}, {0x90,0x5b}, {0xb0,0x69}, {0xd3,0xee}, {0xd3,0xf0}, {0xb0,0x6c},
    {0xd3,0xea}, {0xd3,0xed}, {0xb0,0x68}, {0xb0,0x65}, {0xd3,0xec}, {0xb0,0x6b}, {0xd3,0xef}, {0xb0,0x6d}, {0xb0,0x66}, {0x9e,0xdb},
    {0xd7,0xe3}, {0xd7,0xe6}, {0xb3,0x70}, {0xb3,0x7a}, {0xb3,0x76}, {0xd7,0xe4}, {0x9d,0x79}, {0xb3,0x7e}, {0xb3,0x77}, {0xb3,0x7c},
    {0xb3,0x72}, {0xb3,0x6f}, {0xb3,0x71}, {0xb3,0x7d}, {0xd7,0xe5}, {0xb3,0x75}, {0xb3,0x78}, {0xb3,0x74}, {0xb3,0x79}, {0xd7,0xe7},
    {0xb3,0x7b}, {0xb3,0x73}, {0xd7,0xe2}, {0xdc,0x4d}, {0xb6,0x65}, {0xdc,0x4f}, {0xb6,0x67}, {0xb6,0x69}, {0x99,0xf3}, {0xdc,0x4e},
    {0xb6,0x66}, {0xb6,0x6a}, {0x90,0x62}, {0xb6,0x68}, {0xb9,0x47}, {0xe0,0xa3}, {0xb9,0x4f}, {0xe0,0x7e}, {0xb9,0x50}, {0xb9,0x45},
    {0xe0,0xa1}, {0xb9,0x4a}, {0xe0,0xa2}, {0xb9,0x43}, {0xb9,0x42}, {0x9f,0x55}, {0xb9,0x4d}, {0xb9,0x4c}, {0xb9,0x4b}, {0xb9,0x49},
    {0xb9,0x4e}, {0xe0,0x7d}, {0xb9,0x44}, {0xb9,0x46}, {0xb9,0x48}, {0x9b,0xf9}, {0xbb,0xb8}, {0xbb,0xbb}, {0xbb,0xbf}, {0xbb,0xb9},
    {0xbb,0xbe}, {0xbb,0xbc}, {0xbb,0xb7}, {0x90,0x65}, {0xbb,0xbd}, {0xbb,0xba}, {0x96,0xe0}, {0xe8,0x52}, {0xbe,0x43}, {0xbe,0x41},
    {0xe8,0x53}, {0x98,0xbe}, {0xbe,0x44}, {0xbe,0x42}, {0xe8,0x51}, {0xe8,0x50}, {0xbf,0xf0}, {0xe8,0x4f}, {0xbf,0xee}, {0xbf,0xed},
    {0xeb,0xd0}, {0xbe,0x45}, {0xbf,0xef}, {0xeb,0xd1}, {0xbf,0xf2}, {0xeb,0xd2}, {0xbf,0xf1}, {0xc1,0xd8}, {0xee,0xc3}, {0xc1,0xd7},
    {0xc1,0xdc}, {0xc1,0xda}, {0xc1,0xdb}, {0xc2,0xe3}, {0xc1,0xd9}, {0xee,0xc2}, {0xeb,0xd3}, {0xc2,0xe2}, {0xc2,0xe4}, {0xc3,0xe4},
    {0xc3,0xe5}, {0xf4,0xe0}, {0xc5,0xde}, {0xc5,0xdd}, {0xa8,0xb6}, {0xca,0x55}, {0xb0,0x6f}, {0xca,0x52}, {0xca,0x53}, {0xca,0x51},
    {0xca,0x54}, {0xcb,0xaa}, {0xcb,0xa7}, {0xcb,0xac}, {0xcb,0xa8}, {0xa8,0xb7}, {0xa8,0xba}, {0xcb,0xa9}, {0xa8,0xb9}, {0xcb,0xab},
    {0x90,0x68}, {0xa8,0xb8}, {0x90,0x6c}, {0xcd,0xd5}, {0xcd,0xd7}, {0xaa,0xf4}, {0xcd,0xd3}, {0xcd,0xd6}, {0xcd,0xd4}, {0xaa,0xf2},
    {0xaa,0xf5}, {0xaa,0xf3}, {0x95,0xd8}, {0xd0,0xb8}, {0xd0,0xbc}, {0xd0,0xb9}, {0xad,0xa7}, {0xad,0xa8}, {0x90,0x6a}, {0xd0,0xbb},
    {0xd0,0xbd}, {0xd0,0xbf}, {0xad,0xa5}, {0xd0,0xbe}, {0xad,0xa6}, {0xd7,0xee}, {0xd0,0xba}, {0xd3,0xf2}, {0xd3,0xfb}, {0xd3,0xf9},
    {0xd3,0xf4}, {0xd3,0xf5}, {0xd3,0xfa}, {0xd3,0xfc}, {0xb0,0x71}, {0xd3,0xf7}, {0xd3,0xf3}, {0xb0,0x70}, {0xb0,0x72}, {0xd3,0xf6},
    {0xd3,0xfd}, {0xd3,0xf8}, {0xb3,0xa1}, {0xd7,0xf1}, {0xd7,0xe9}, {0xd7,0xef}, {0xd7,0xf0}, {0xb3,0xa2}, {0xd7,0xe8}, {0xd7,0xea},
    {0xd0,0xb7}, {0xd7,0xec}, {0xd7,0xed}, {0xd7,0xeb}, {0xb6,0x6c}, {0xdc,0x56}, {0xeb,0xd4}, {0xdc,0x57}, {0xdc,0x54}, {0xb3,0xa3},
    {0xb6,0x6e}, {0xdc,0x53}, {0xdc,0x59}, {0xdc,0x58}, {0xb6,0x6b}, {0xdc,0x5c}, {0xdc,0x52}, {0xdc,0x5b}, {0xdc,0x50}, {0xdc,0x5a},
    {0xdc,0x55}, {0xb6,0x6d}, {0xe0,0xaa}, {0xe0,0xa5}, {0xe0,0xab}, {0xe0,0xa6}, {0xe0,0xa4}, {0xe0,0xa7}, {0xb9,0x51}, {0xe0,0xa9},
    {0xe0,0xa8}, {0xb9,0x52}, {0xbb,0xc1}, {0xbb,0xc0}, {0xe4,0x6e}, {0xe4,0x71}, {0xe4,0x69}, {0xe4,0x6d}, {0xbb,0xc2}, {0xe4,0x6c},
    {0xe4,0x6a}, {0xe4,0x70}, {0xe4,0x6b}, {0xe4,0x68}, {0xe4,0x6f}, {0xe8,0x59}, {0xbe,0x48}, {0xf1,0x4a}, {0xe8,0x56}, {0xe8,0x57},
    {0xe8,0x55}, {0xdc,0x51}, {0xbe,0x47}, {0xe8,0x5a}, {0xe8,0x54}, {0xbe,0x46}, {0xbe,0x49}, {0xe8,0x58}, {0xeb,0xd5}, {0xbf,0xf3},
    {0xeb,0xd6}, {0xeb,0xd7}, {0xee,0xc4}, {0xc1,0xdd}, {0xf1,0x4b}, {0xf1,0x4c}, {0xf1,0x4d}, {0xf3,0x5d}, {0xf3,0x5c}, {0xf4,0xe2},
    {0xf4,0xe1}, {0xf6,0x5b}, {0xf6,0x5c}, {0xf6,0x5a}, {0xf7,0x66}, {0xc5,0xb0}, {0xa8,0xbb}, {0xad,0xaa}, {0xad,0xa9}, {0xb0,0x75},
    {0xb0,0x74}, {0xd4,0x40}, {0xd4,0x41}, {0xd3,0xfe}, {0x9f,0xb2}, {0xb0,0x73}, {0xd7,0xf5}, {0xd7,0xf6}, {0xd7,0xf2}, {0xb3,0xa4},
    {0xd7,0xf3}, {0x9f,0xae}, {0xd7,0xf4}, {0x9f,0xb0}, {0x89,0xad}, {0xdc,0x5f}, {0xdc,0x61}, {0xdc,0x5d}, {0xdc,0x60}, {0xb6,0x6f},
    {0xdc,0x5e}, {0xb6,0x70}, {0x90,0x6e}, {0xdd,0x73}, {0xb9,0x55}, {0xb9,0x54}, {0xb9,0x53}, {0xe0,0xac}, {0xe0,0xad}, {0x9e,0x71},
    {0xe4,0x73}, {0xe4,0x75}, {0xbb,0xc6}, {0xbb,0xc3}, {0x9e,0x4a}, {0xbb,0xc5}, {0xbb,0xc4}, {0xe4,0x74}, {0xe4,0x72}, {0x9f,0xdc},
    {0xe8,0x61}, {0xe8,0x5e}, {0xe8,0x5f}, {0xbe,0x4d}, {0xe8,0x60}, {0xe8,0x5b}, {0xe8,0x5c}, {0xbe,0x4a}, {0xbe,0x4b}, {0xe8,0x5d},
    {0xbe,0x4c}, {0x89,0xab}, {0xeb,0xdb}, {0x9f,0xb8}, {0xeb,0xdc}, {0xeb,0xd9}, {0xeb,0xda}, {0xbf,0xf4}, {0xeb,0xd8}, {0xee,0xc8},
    {0xee,0xc5}, {0xee,0xc7}, {0xc1,0xe0}, {0xee,0xcb}, {0xc1,0xdf}, {0xee,0xc9}, {0xee,0xcc}, {0xee,0xca}, {0xee,0xc6}, {0xc1,0xde},
    {0xf1,0x4f}, {0xf1,0x50}, {0xf1,0x4e}, {0x90,0x70}, {0xf1,0x52}, {0xc2,0xe5}, {0xc2,0xe6}, {0xf3,0x5f}, {0xc3,0xe7}, {0xf1,0x51},
    {0xf3,0x5e}, {0xc3,0xe6}, {0xf4,0xe5}, {0xf4,0xe6}, {0xc4,0xbf}, {0xf4,0xe4}, {0x8b,0x63}, {0xf4,0xe3}, {0xf6,0x5d}, {0xc5,0x48},
    {0x95,0xdc}, {0xf8,0x49}, {0xf8,0xc8}, {0xf8,0xc7}, {0xc6,0x43}, {0xc6,0x5d}, {0xf8,0xc9}, {0xf9,0x71}, {0x90,0x71}, {0xc6,0x6f},
    {0xa8,0xbc}, {0xaa,0xf6}, {0xb9,0x56}, {0xc4,0xc0}, {0xa8,0xbd}, {0xad,0xab}, {0xb3,0xa5}, {0xb6,0x71}, {0xc2,0xe7}, {0xaa,0xf7},
    {0xd0,0xc1}, {0xd0,0xc0}, {0xd4,0x42}, {0xfc,0x5e}, {0xb0,0x78}, {0xb0,0x76}, {0xb0,0x7a}, {0xd4,0x44}, {0xb0,0x79}, {0xb0,0x77},
    {0x89,0x49}, {0xd4,0x43}, {0xb3,0xa8}, {0xd7,0xfc}, {0x96,0x5b}, {0xb3,0xa7}, {0xb3,0xa9}, {0xd8,0x42}, {0xb3,0xab}, {0xd7,0xfe},
    {0xd8,0x40}, {0xd7,0xf7}, {0xb3,0xaa}, {0xd8,0x43}, {0xd7,0xf9}, {0xd7,0xfa}, {0xd7,0xf8}, {0xb3,0xa6}, {0x8c,0x50}, {0xd8,0x41},
    {0xd7,0xfb}, {0xd7,0xfd}, {0x94,0xa6}, {0xdc,0x6d}, {0x8f,0xd5}, {0xdc,0x6c}, {0xdc,0x6a}, {0xdc,0x62}, {0xdc,0x71}, {0xdc,0x65},
    {0xdc,0x6f}, {0xdc,0x76}, {0xdc,0x6e}, {0xb6,0x79}, {0x9e,0x73}, {0xb6,0x75}, {0xdc,0x63}, {0xdc,0x69}, {0xb6,0x77}, {0x90,0x75},
    {0xdc,0x68}, {0xb6,0x78}, {0xb6,0x7a}, {0xdc,0x6b}, {0x99,0xf7}, {0xb6,0x72}, {0xb6,0x73}, {0xdc,0x77}, {0xdc,0x75}, {0xdc,0x74},
    {0xdc,0x66}, {0xdc,0x72}, {0xb6,0x76}, {0x8c,0xbf}, {0xb6,0x74}, {0xdc,0x73}, {0xdc,0x64}, {0xdc,0x67}, {0xdc,0x70}, {0x99,0xf9},
    {0x96,0x63}, {0x95,0xb9}, {0xe4,0xba}, {0xe0,0xb7}, {0xe0,0xb0}, {0xe0,0xc3}, {0xe0,0xcc}, {0xe0,0xb3}, {0xb9,0x61}, {0x94,0xd4},
    {0xe0,0xc0}, {0xb9,0x57}, {0xb9,0x59}, {0xb9,0x65}, {0xe0,0xb1}, {0xfc,0xfa}, {0xb9,0x5a}, {0xb9,0x5c}, {0xb9,0x66}, {0xb9,0x5b},
    {0x90,0x77}, {0x90,0xab}, {0xb9,0x64}, {0xe0,0xb9}, {0xe0,0xae}, {0xb9,0x62}, {0xe0,0xb8}, {0xb9,0x5e}, {0xe0,0xca}, {0xb9,0x63},
    {0xe0,0xc8}, {0xe0,0xbc}, {0xe0,0xc6}, {0xb9,0x60}, {0xe0,0xaf}, {0xe0,0xc9}, {0xe0,0xc4}, {0x9d,0x4d}, {0xe0,0xcb}, {0xb9,0x58},
    {0x99,0xfa}, {0xb9,0x67}, {0xb9,0x5d}, {0x92,0xe3}, {0xe0,0xb5}, {0x97,0xbb}, {0xe0,0xbd}, {0xe0,0xc1}, {0x90,0x78}, {0xe0,0xc5},
    {0xb9,0x5f}, {0xe0,0xb4}, {0xe0,0xb2}, {0xe0,0xbe}, {0x99,0xfb}, {0xe0,0xbb}, {0xe0,0xba}, {0x97,0xe0}, {0xe0,0xbf}, {0xe0,0xc2},
    {0xe0,0xc7}, {0xe4,0x78}, {0x96,0xdc}, {0xbb,0xc7}, {0xe4,0xa4}, {0xe4,0x7a}, {0xbb,0xcc}, {0xbb,0xd0}, {0xe4,0xad}, {0xe4,0xb5},
    {0xe4,0xa6}, {0xbb,0xc8}, {0x9c,0xa8}, {0xe4,0xaa}, {0xe0,0xb6}, {0x97,0x72}, {0xbb,0xc9}, {0xe4,0xb1}, {0xe4,0xb6}, {0xe4,0xae},
    {0x94,0x40}, {0xe4,0xb0}, {0xe4,0xb9}, {0xe4,0xb2}, {0xe4,0x7e}, {0xe4,0xa9}, {0x92,0xf2}, {0xbb,0xd1}, {0xbb,0xcd}, {0xe4,0x7c},
    {0xe4,0xab}, {0xbb,0xcb}, {0xe4,0xa5}, {0xbb,0xca}, {0xe4,0xb3}, {0xe4,0xa2}, {0xe4,0x79}, {0xbb,0xce}, {0xe4,0xb8}, {0xe4,0x7b},
    {0xe4,0xaf}, {0xe4,0xac}, {0xe4,0xa7}, {0xe4,0x77}, {0xe4,0x76}, {0xe4,0xa1}, {0xe4,0xb4}, {0xbb,0xcf}, {0xe4,0xb7}, {0xe4,0x7d},
    {0xe4,0xa3}, {0xbe,0x52}, {0x99,0xfd}, {0x99,0xfc}, {0xbe,0x5a}, {0xbe,0x55}, {0xe8,0xa4}, {0xe8,0xa1}, {0xe8,0x67}, {0xbe,0x50},
    {0xf9,0xd7}, {0x96,0x4a}, {0xbe,0x4f}, {0xbe,0x56}, {0x96,0xd8}, {0x99,0xfe}, {0xe8,0x65}, {0xbe,0x54}, {0xe8,0x71}, {0xe8,0x63},
    {0xe8,0x64}, {0xbe,0x4e}, {0xe8,0xa3}, {0xbe,0x58}, {0xe8,0x74}, {0xe8,0x79}, {0xe8,0x73}, {0xeb,0xee}, {0xe8,0x6f}, {0xe8,0x77},
    {0xe8,0x75}, {0xe8,0x68}, {0xe8,0x62}, {0xe8,0x7d}, {0xbe,0x57}, {0xe8,0x7e}, {0x90,0x4b}, {0xe8,0x78}, {0xe8,0x6d}, {0xe8,0x6b},
    {0xe8,0x66}, {0xfa,0x41}, {0xe8,0x6e}, {0xe8,0x7b}, {0xe8,0x6a}, {0xe8,0x7a}, {0xe8,0xa2}, {0x9a,0x40}, {0xbe,0x53}, {0x97,0x5b},
    {0xe8,0x76}, {0xe8,0x7c}, {0xe8,0x72}, {0xe8,0x6c}, {0xbe,0x51}, {0x9a,0x41}, {0x91,0xdd}, {0xe4,0xa8}, {0xe8,0x70}, {0xbe,0x59},
    {0xe8,0x69}, {0x93,0xfc}, {0x9a,0x42}, {0x9a,0x43}, {0x96,0x59}, {0xeb,0xf4}, {0xbf,0xf7}, {0xeb,0xf3}, {0xeb,0xf0}, {0xec,0x44},
    {0xbf,0xfb}, {0x9a,0x44}, {0xec,0x41}, {0xeb,0xf8}, {0xec,0x43}, {0xeb,0xe9}, {0xeb,0xf6}, {0x90,0x51}, {0xbf,0xfd}, {0xeb,0xe1},
    {0x94,0xbf}, {0xeb,0xdf}, {0xec,0x42}, {0xec,0x40}, {0xeb,0xfe}, {0xeb,0xed}, {0xeb,0xec}, {0xeb,0xe2}, {0xc0,0x40}, {0xeb,0xe8},
    {0xeb,0xf2}, {0xeb,0xfd}, {0xc0,0x43}, {0xec,0x45}, {0xc1,0xe8}, {0xc0,0x45}, {0xbf,0xfe}, {0xeb,0xe6}, {0xeb,0xef}, {0xeb,0xde},
    {0xeb,0xe0}, {0xbf,0xf5}, {0xc0,0x42}, {0xbf,0xfa}, {0xeb,0xe7}, {0xeb,0xf7}, {0xeb,0xf1}, {0xc0,0x41}, {0xeb,0xdd}, {0xc1,0xe3},
    {0xeb,0xf9}, {0xeb,0xfc}, {0xbf,0xfc}, {0x90,0xa2}, {0xeb,0xeb}, {0xc0,0x44}, {0xbf,0xf9}, {0x9c,0xab}, {0x97,0x76}, {0xbf,0xf8},
    {0xeb,0xf5}, {0xeb,0xfb}, {0xbf,0xf6}, {0xeb,0xe4}, {0xeb,0xfa}, {0xeb,0xe5}, {0xfc,0x55}, {0xfe,0x45}, {0x94,0xa8}, {0x9a,0x45},
    {0xfa,0x4b}, {0x9d,0xe1}, {0xeb,0xea}, {0xee,0xd2}, {0x96,0xd9}, {0xee,0xd7}, {0xc1,0xe5}, {0xc1,0xe7}, {0xee,0xdd}, {0xc1,0xe1},
    {0xee,0xec}, {0xee,0xe3}, {0xee,0xd8}, {0xee,0xd9}, {0xee,0xe2}, {0xc1,0xee}, {0xee,0xe1}, {0xee,0xd1}, {0xee,0xe0}, {0xee,0xd4},
    {0xee,0xed}, {0xc1,0xed}, {0xc1,0xeb}, {0xee,0xd5}, {0xee,0xe8}, {0x97,0x74}, {0xee,0xda}, {0xee,0xe7}, {0xfd,0xf5}, {0xee,0xe9},
    {0xee,0xd0}, {0xc1,0xe6}, {0x92,0xe5}, {0xee,0xea}, {0x96,0x45}, {0x91,0xda}, {0xee,0xde}, {0x90,0xa3}, {0xc1,0xea}, {0xee,0xdb},
    {0xa0,0x5f}, {0xc1,0xec}, {0xee,0xe4}, {0x90,0xaf}, {0x97,0xbf}, {0xc1,0xe4}, {0xee,0xd6}, {0xee,0xe5}, {0x91,0x4c}, {0xee,0xdf},
    {0xeb,0xe3}, {0xee,0xe6}, {0xee,0xd3}, {0x96,0x7a}, {0xc1,0xe9}, {0xee,0xeb}, {0x91,0xde}, {0xc1,0xe2}, {0xee,0xce}, {0x9a,0x46},
    {0xfe,0xb0}, {0x97,0x79}, {0x94,0x6c}, {0xf1,0x60}, {0xf1,0x59}, {0xc2,0xe9}, {0xf1,0x54}, {0xf1,0x63}, {0xf1,0x5b}, {0xee,0xdc},
    {0x98,0x58}, {0xf1,0x65}, {0xf1,0x55}, {0xc2,0xe8}, {0xf1,0x5f}, {0xc2,0xea}, {0xc2,0xf2}, {0xc2,0xf0}, {0xf1,0x61}, {0xc2,0xf1},
    {0xf1,0x57}, {0x92,0x66}, {0xf1,0x58}, {0xf1,0x5d}, {0xf1,0x62}, {0x93,0xfb}, {0xee,0xcd}, {0xc2,0xeb}, {0xf1,0x6a}, {0xf1,0x67},
    {0xf1,0x6b}, {0xf1,0x5e}, {0xf1,0x5a}, {0xf1,0x68}, {0xf3,0x6a}, {0xf1,0x5c}, {0xc2,0xee}, {0x9a,0x47}, {0xc2,0xed}, {0xee,0xcf},
    {0xc2,0xef}, {0xf1,0x64}, {0xf1,0x66}, {0xc2,0xec}, {0xf1,0x69}, {0xf1,0x53}, {0xf1,0x56}, {0x97,0x49}, {0x97,0x48}, {0x93,0x4a},
    {0x9c,0xe2}, {0xf3,0x73}, {0xf3,0x63}, {0xc3,0xeb}, {0xf3,0x71}, {0x92,0x64}, {0xf3,0x61}, {0xc3,0xec}, {0xf3,0x6c}, {0x91,0xdf},
    {0xf3,0x68}, {0xc3,0xf1}, {0xf3,0x72}, {0xf3,0x62}, {0xf3,0x65}, {0xc3,0xe9}, {0xf3,0x74}, {0xfb,0x79}, {0xf3,0x6d}, {0xf3,0x70},
    {0xc3,0xef}, {0xc3,0xf4}, {0xc3,0xf2}, {0xf3,0x69}, {0xf3,0x64}, {0x96,0xd7}, {0xc3,0xed}, {0xc3,0xee}, {0xf3,0x60}, {0xc3,0xea},
    {0x93,0x43}, {0xc3,0xe8}, {0xc3,0xf0}, {0xf3,0x6f}, {0xc3,0xf3}, {0xf3,0x6b}, {0xf3,0x75}, {0xc3,0xf5}, {0xf3,0x67}, {0xf3,0x6e},
    {0xfd,0xcb}, {0xfe,0x7a}, {0x91,0xdb}, {0x8c,0x6a}, {0xf4,0xf3}, {0xf5,0x42}, {0xf4,0xf5}, {0xf4,0xfc}, {0xf3,0x66}, {0xf4,0xfa},
    {0xf4,0xe9}, {0xf5,0x40}, {0xc4,0xc3}, {0xf4,0xed}, {0xf4,0xfe}, {0xf4,0xf4}, {0x97,0xaf}, {0xc4,0xc2}, {0x95,0xdd}, {0xf5,0x44},
    {0xf4,0xf6}, {0x93,0x48}, {0xf4,0xfb}, {0xf4,0xfd}, {0xf4,0xe7}, {0xf5,0x41}, {0xf4,0xf2}, {0xf4,0xf7}, {0xf4,0xeb}, {0xf4,0xef},
    {0xf5,0x43}, {0xf4,0xf9}, {0xf4,0xe8}, {0xf4,0xec}, {0xf4,0xee}, {0xf4,0xf8}, {0x9a,0x4b}, {0xc4,0xc1}, {0xf4,0xf1}, {0xfc,0x45},
    {0x9a,0x4d}, {0xf4,0xea}, {0x91,0xbc}, {0x90,0xe2}, {0x90,0xb4}, {0x95,0xe1}, {0xf4,0xf0}, {0xf6,0x61}, {0xf6,0x66}, {0xc5,0x4f},
    {0xf6,0x68}, {0x9a,0x4e}, {0xc5,0x49}, {0xf6,0x64}, {0xf6,0x6a}, {0xc5,0x4e}, {0xc5,0x4a}, {0xc5,0x4b}, {0xf6,0x60}, {0xf6,0x67},
    {0xc5,0x4d}, {0xf6,0x65}, {0xc5,0x4c}, {0xf6,0x5f}, {0xf6,0x63}, {0xf6,0x62}, {0x9a,0x4f}, {0xf6,0x5e}, {0xf6,0x69}, {0xfe,0x40},
    {0xfe,0x43}, {0xc5,0xb1}, {0xf7,0x6d}, {0xf7,0x70}, {0xf7,0x6c}, {0xf7,0x6e}, {0xf7,0x6f}, {0xf7,0x69}, {0xf7,0x6a}, {0xf7,0x67},
    {0x96,0xdd}, {0xf7,0x6b}, {0xf7,0x68}, {0xc5,0xb2}, {0xc5,0xb3}, {0x9a,0x51}, {0xf8,0x4b}, {0xf8,0x4d}, {0x96,0xa7}, {0x90,0xb0},
    {0xf8,0x4c}, {0xf8,0x4e}, {0xc5,0xe0}, {0xf8,0x4a}, {0xc5,0xdf}, {0xc5,0xe1}, {0x9c,0x4e}, {0x94,0x43}, {0xf8,0xcb}, {0xf8,0xcc},
    {0xc6,0x44}, {0xf8,0xca}, {0x8e,0xba}, {0xf9,0x53}, {0xf9,0x52}, {0xf9,0x54}, {0xc6,0x5f}, {0xf9,0x55}, {0xc6,0x5e}, {0xf9,0x56},
    {0xf9,0x72}, {0xf9,0x75}, {0xf9,0x74}, {0xc6,0x68}, {0xf9,0x73}, {0x9a,0x52}, {0xfc,0xc1}, {0xc6,0x72}, {0xc6,0x70}, {0xc6,0x71},
    {0xc6,0x77}, {0xf9,0xc0}, {0xf9,0xc1}, {0xf9,0xbf}, {0xf9,0xc9}, {0x8b,0xe9}, {0x9c,0xaf}, {0x8b,0xfd}, {0x9a,0xbc}, {0x9a,0xb8},
    {0x9a,0xae}, {0x9a,0xa7}, {0x9a,0x53}, {0x9d,0x74}, {0xaa,0xf8}, {0x8b,0xea}, {0xd8,0x44}, {0xdc,0x78}, {0xe8,0xa5}, {0xf3,0x76},
    {0x8b,0xeb}, {0xaa,0xf9}, {0xad,0xac}, {0xb0,0x7b}, {0x90,0xb2}, {0xd8,0x45}, {0xd8,0x46}, {0xb3,0xac}, {0xb6,0x7d}, {0xdc,0x7a},
    {0xdc,0x79}, {0xb6,0xa3}, {0xb6,0x7c}, {0xdc,0x7b}, {0xb6,0x7e}, {0xb6,0xa2}, {0xb6,0xa1}, {0xb6,0x7b}, {0x95,0xe9}, {0x95,0xe8},
    {0xb9,0x68}, {0x95,0xe6}, {0xe0,0xd0}, {0xe0,0xce}, {0xe0,0xcf}, {0xe0,0xcd}, {0x90,0xb5}, {0xbb,0xd2}, {0x9a,0x54}, {0xbb,0xd5},
    {0xbb,0xd7}, {0xbb,0xd6}, {0x90,0xb3}, {0x95,0xe7}, {0xbb,0xd3}, {0xbb,0xd4}, {0x8b,0x50}, {0xe8,0xa7}, {0xe8,0xa6}, {0xbe,0x5b},
    {0xe8,0xa8}, {0xe8,0xa9}, {0xbe,0x5c}, {0xec,0x4d}, {0xec,0x4b}, {0xee,0xf3}, {0xec,0x49}, {0xec,0x4a}, {0xc0,0x46}, {0xec,0x46},
    {0xec,0x4e}, {0xec,0x48}, {0xec,0x4c}, {0xee,0xef}, {0xee,0xf1}, {0xee,0xf2}, {0xc1,0xf3}, {0xee,0xee}, {0xc1,0xf2}, {0xee,0xf0},
    {0xc1,0xef}, {0xc1,0xf0}, {0xc1,0xf1}, {0xec,0x47}, {0xc2,0xf5}, {0xf1,0x6e}, {0xf1,0x6c}, {0xf1,0x6d}, {0xc2,0xf3}, {0xc2,0xf6},
    {0xc2,0xf4}, {0xf3,0x77}, {0xf3,0x78}, {0xc3,0xf6}, {0xf5,0x45}, {0xf5,0x47}, {0xf5,0x46}, {0xc4,0xc4}, {0xc5,0x50}, {0xf6,0x6d},
    {0xf6,0x6c}, {0xf6,0x6b}, {0x8b,0xec}, {0x9a,0x56}, {0xaa,0xfa}, {0x8b,0xfb}, {0xc9,0xaa}, {0xca,0x58}, {0xa6,0xe9}, {0xca,0x56},
    {0xca,0x59}, {0xca,0x57}, {0xcb,0xae}, {0xa8,0xc1}, {0xa8,0xc2}, {0xcb,0xb0}, {0xa8,0xbf}, {0xcb,0xaf}, {0xcb,0xad}, {0xa8,0xc0},
    {0xa8,0xbe}, {0x9a,0x57}, {0xa0,0xaa}, {0xcd,0xd8}, {0xcd,0xdb}, {0xaa,0xfd}, {0xcd,0xda}, {0xcd,0xd9}, {0xaa,0xfc}, {0xaa,0xfb},
    {0x9f,0xa6}, {0xab,0x40}, {0xcd,0xdc}, {0xaa,0xfe}, {0x99,0xcc}, {0xd0,0xc6}, {0xad,0xae}, {0xad,0xaf}, {0xad,0xb0}, {0xd0,0xc7},
    {0xd0,0xc3}, {0xad,0xad}, {0xd0,0xc4}, {0xd0,0xc5}, {0xd0,0xc2}, {0x9c,0x59}, {0xb0,0xa4}, {0xb0,0xa1}, {0xd4,0x45}, {0xb0,0xa2},
    {0xb0,0xa5}, {0xd4,0x46}, {0xb0,0x7e}, {0xb0,0x7c}, {0xb0,0x7d}, {0xb0,0xa3}, {0x99,0xb5}, {0xb3,0xad}, {0xd8,0x49}, {0xb3,0xb5},
    {0xd8,0x48}, {0xd8,0x4b}, {0xb3,0xb1}, {0xd8,0x4a}, {0xb6,0xab}, {0xb3,0xaf}, {0xb3,0xb2}, {0xb3,0xae}, {0xb3,0xb3}, {0xb3,0xb4},
    {0xb3,0xb0}, {0x90,0xbe}, {0xd8,0x47}, {0xb6,0xa7}, {0xdc,0x7d}, {0xdc,0xa3}, {0x9f,0xaf}, {0xdc,0xa2}, {0xb6,0xac}, {0xb6,0xa8},
    {0xb6,0xa9}, {0xdc,0x7c}, {0xdc,0x7e}, {0xdc,0xa1}, {0xb6,0xa4}, {0xb6,0xa6}, {0xb6,0xaa}, {0xb6,0xa5}, {0x95,0xf2}, {0xe0,0xd3},
    {0xe0,0xd1}, {0xe0,0xd2}, {0xb9,0x6a}, {0xb9,0x6b}, {0x90,0xbf}, {0xe0,0xd4}, {0xb9,0x69}, {0xbb,0xd8}, {0xbb,0xda}, {0xbb,0xd9},
    {0xe4,0xbb}, {0xe4,0xbc}, {0xe8,0xab}, {0x90,0xc1}, {0xe8,0xaa}, {0xfe,0xe4}, {0xc0,0x47}, {0xc0,0x48}, {0xec,0x4f}, {0xc0,0x49},
    {0xee,0xf6}, {0xee,0xf4}, {0xee,0xf5}, {0xc1,0xf4}, {0xf1,0x6f}, {0xc3,0xf7}, {0x90,0xc4}, {0xc1,0xf5}, {0xab,0x41}, {0xb0,0xa6},
    {0xd4,0x47}, {0x90,0xc7}, {0xd8,0x4c}, {0xb3,0xb6}, {0xb6,0xad}, {0xdc,0xa4}, {0xdc,0xa6}, {0xb6,0xaf}, {0xb6,0xae}, {0xb6,0xb0},
    {0xb6,0xb1}, {0xdc,0xa5}, {0xb9,0x6e}, {0xb9,0x6f}, {0xb9,0x6d}, {0xbb,0xdb}, {0xb9,0x6c}, {0xe0,0xd5}, {0xbb,0xdc}, {0xe8,0xac},
    {0xec,0x50}, {0xc0,0x4a}, {0xc1,0xf6}, {0xf1,0x70}, {0xf1,0x74}, {0xc2,0xf9}, {0xf1,0x71}, {0xc2,0xfa}, {0xc2,0xf8}, {0xf1,0x75},
    {0xc2,0xfb}, {0xf1,0x73}, {0xf3,0x79}, {0xc2,0xf7}, {0xc3,0xf8}, {0xf8,0xcd}, {0xab,0x42}, {0xb3,0xb8}, {0xb3,0xb7}, {0xb6,0xb2},
    {0xdc,0xa8}, {0xdc,0xa7}, {0xb6,0xb3}, {0x92,0xe4}, {0xe0,0xd9}, {0xb9,0x73}, {0xb9,0x70}, {0xe0,0xd8}, {0xb9,0x72}, {0xe0,0xd6},
    {0xb9,0x71}, {0xe0,0xd7}, {0xe4,0xbd}, {0xbb,0xdd}, {0xe8,0xaf}, {0x9f,0x52}, {0xbe,0x5d}, {0xe8,0xad}, {0xbe,0x5e}, {0xbe,0x5f},
    {0xe8,0xae}, {0xbe,0x60}, {0xec,0x51}, {0xc0,0x4e}, {0xc0,0x4b}, {0xc0,0x50}, {0xec,0x53}, {0xc0,0x4c}, {0xec,0x52}, {0xc0,0x4f},
    {0xc0,0x4d}, {0xee,0xf9}, {0xee,0xfb}, {0x90,0xdb}, {0xc1,0xf7}, {0xee,0xfa}, {0xc1,0xf8}, {0xee,0xf8}, {0xee,0xf7}, {0xa0,0x66},
    {0xf1,0x77}, {0xf1,0x76}, {0xc2,0xfc}, {0xf1,0x78}, {0xf3,0x7e}, {0xc3,0xfa}, {0xf3,0x7d}, {0xf3,0x7a}, {0xc3,0xf9}, {0xf3,0x7b},
    {0xf3,0x7c}, {0xf5,0x48}, {0xf5,0x49}, {0xc4,0xc5}, {0x90,0xd2}, {0xc5,0x53}, {0xf6,0x6e}, {0x90,0xd4}, {0xc5,0x51}, {0xc5,0x52},
    {0xf6,0x6f}, {0xc5,0xb4}, {0xc5,0xb5}, {0xf7,0x71}, {0x9a,0x5b}, {0x95,0xfd}, {0xc6,0x45}, {0xf8,0xcf}, {0xc6,0x47}, {0xf8,0xce},
    {0xf8,0xd0}, {0xc6,0x46}, {0xf9,0x57}, {0xf9,0xad}, {0x8b,0xc4}, {0xab,0x43}, {0x8c,0x66}, {0xb9,0x74}, {0x90,0xde}, {0xe4,0xbe},
    {0xe8,0xb0}, {0xc0,0x51}, {0xc0,0x52}, {0x9c,0xe4}, {0xab,0x44}, {0x90,0xe1}, {0xbe,0x61}, {0xc3,0xfb}, {0xad,0xb1}, {0xc0,0x53},
    {0xc5,0xe2}, {0xad,0xb2}, {0xd8,0x4d}, {0xdc,0xa9}, {0x9e,0x46}, {0xdc,0xab}, {0xdc,0xaa}, {0x96,0x51}, {0xe0,0xdd}, {0xe0,0xda},
    {0xb9,0x75}, {0xb9,0x76}, {0xe0,0xdb}, {0xe0,0xdc}, {0xe4,0xc0}, {0xe4,0xc5}, {0xbb,0xde}, {0xe4,0xbf}, {0xe4,0xc1}, {0xe4,0xc8},
    {0xe4,0xc3}, {0xe4,0xc7}, {0xe4,0xc4}, {0xe4,0xc2}, {0xe4,0xc6}, {0xbb,0xdf}, {0xfb,0x58}, {0xe8,0xb3}, {0x90,0xe6}, {0xe8,0xb1},
    {0xbe,0x63}, {0xbe,0x62}, {0xe8,0xb2}, {0xbe,0x64}, {0xec,0x56}, {0xec,0x55}, {0xc0,0x54}, {0xec,0x54}, {0xee,0xfc}, {0x96,0x50},
    {0xee,0xfe}, {0xef,0x41}, {0xef,0x40}, {0x90,0xe7}, {0xc1,0xf9}, {0xee,0xfd}, {0xf1,0xa1}, {0xc2,0xfd}, {0xf1,0x7d}, {0xf1,0xa2},
    {0xc2,0xfe}, {0xf1,0x7b}, {0xf1,0x7e}, {0xf1,0x7c}, {0xf1,0x79}, {0xc3,0x40}, {0xf1,0x7a}, {0x90,0xe8}, {0x9a,0x5d}, {0xf3,0xa1},
    {0x9f,0x7a}, {0xf3,0xa3}, {0xf3,0xa2}, {0x9b,0x5c}, {0xf5,0x4a}, {0x9f,0x7c}, {0xf5,0x4b}, {0xfc,0x52}, {0x90,0xe9}, {0xf6,0x70},
    {0x90,0xea}, {0xc5,0xb7}, {0x9a,0x5e}, {0xc5,0xb6}, {0xf8,0x4f}, {0xf8,0x50}, {0xc6,0x48}, {0xf8,0xd1}, {0x9f,0x76}, {0xc6,0x69},
    {0xad,0xb3}, {0xb6,0xb4}, {0xe4,0xca}, {0xe4,0xc9}, {0xe8,0xb5}, {0xe8,0xb4}, {0x90,0xeb}, {0xc1,0xfa}, {0xef,0x43}, {0xef,0x42},
    {0xf1,0xa5}, {0xf1,0xa3}, {0xf1,0xa6}, {0xf1,0xa4}, {0xc3,0xfc}, {0xf3,0xa4}, {0xf3,0xa5}, {0xf3,0xa6}, {0x90,0xec}, {0xf6,0x71},
    {0xf7,0x72}, {0xf8,0xd2}, {0x8b,0xee}, {0xad,0xb4}, {0x90,0xee}, {0xec,0x57}, {0xef,0x44}, {0x91,0xc6}, {0xad,0xb5}, {0x90,0xf2},
    {0xbb,0xe0}, {0xec,0x58}, {0xc3,0x41}, {0xf1,0xa7}, {0xc3,0xfd}, {0xf5,0x4c}, {0xf5,0x4d}, {0xc5,0x54}, {0xf8,0x51}, {0xad,0xb6},
    {0xb3,0xbb}, {0xb3,0xbc}, {0xd8,0x4e}, {0xb6,0xb5}, {0xb6,0xb6}, {0xdc,0xac}, {0xb6,0xb7}, {0xb9,0x7a}, {0xb9,0x7c}, {0xe0,0xdf},
    {0xe0,0xe0}, {0xe0,0xde}, {0xb9,0x77}, {0xb9,0x78}, {0xb9,0x7b}, {0xb9,0x79}, {0xfc,0xbc}, {0x8a,0x74}, {0xe4,0xcb}, {0xbb,0xe1},
    {0xbb,0xe2}, {0xe8,0xbc}, {0xbe,0x67}, {0xe8,0xb7}, {0xe8,0xb6}, {0x96,0x57}, {0xe8,0xbb}, {0xbe,0x65}, {0x9c,0xef}, {0xc0,0x5b},
    {0xe8,0xb8}, {0xe8,0xbd}, {0xe8,0xba}, {0xe8,0xb9}, {0xbe,0x66}, {0xc0,0x59}, {0x9f,0xdf}, {0xec,0x5a}, {0xc0,0x55}, {0xec,0x5b},
    {0x90,0xf7}, {0x90,0xf6}, {0xec,0x59}, {0xc0,0x58}, {0xc0,0x56}, {0xc0,0x5a}, {0xc0,0x57}, {0xef,0x45}, {0xef,0x4a}, {0xef,0x46},
    {0xef,0x49}, {0xc1,0xfb}, {0x9b,0x5e}, {0xed,0xd4}, {0xef,0x48}, {0xef,0x47}, {0x90,0xf8}, {0xc3,0x44}, {0xc3,0x42}, {0xc3,0x45},
    {0xc3,0x43}, {0xf1,0xa8}, {0xf1,0xa9}, {0xf1,0xaa}, {0xc3,0x46}, {0xf3,0xaa}, {0xc4,0x40}, {0xf3,0xa8}, {0xc4,0x41}, {0xf3,0xa7},
    {0xf3,0xa9}, {0xc3,0xfe}, {0xf5,0x51}, {0xf5,0x4e}, {0xf5,0x4f}, {0xf5,0x50}, {0xf6,0x72}, {0xc5,0x56}, {0x90,0xf9}, {0xc5,0x55},
    {0x8c,0xc9}, {0xf7,0x74}, {0xf7,0x73}, {0xc5,0xb8}, {0xfa,0x6a}, {0xc5,0xe3}, {0xc6,0x49}, {0xc6,0x60}, {0xf9,0x58}, {0xf9,0xae},
    {0xf9,0xaf}, {0x8b,0xef}, {0xad,0xb7}, {0xdc,0xad}, {0xe0,0xe1}, {0xe4,0xcc}, {0xe4,0xcd}, {0xbb,0xe3}, {0xbb,0xe4}, {0xe8,0xbe},
    {0xbe,0x68}, {0x9f,0xe0}, {0xc1,0xfc}, {0x91,0x42}, {0xf1,0xab}, {0x9a,0x62}, {0xc3,0x47}, {0xf3,0xad}, {0xc4,0x42}, {0xf3,0xac},
    {0xf3,0xae}, {0xf3,0xab}, {0xf6,0x75}, {0xf5,0x52}, {0xf5,0x53}, {0x95,0x69}, {0xc4,0xc6}, {0xf6,0x74}, {0x91,0x44}, {0x91,0x43},
    {0xf6,0x73}, {0x91,0x41}, {0xf7,0x75}, {0xf9,0xb0}, {0x8b,0xf0}, {0xad,0xb8}, {0x96,0x60}, {0x8b,0xf1}, {0xad,0xb9}, {0x99,0xf6},
    {0x91,0x49}, {0xb0,0xa7}, {0xd4,0x48}, {0xd8,0x4f}, {0x91,0x4a}, {0xb6,0xb8}, {0xb6,0xbb}, {0xb6,0xb9}, {0xdc,0xae}, {0x91,0x4b},
    {0xb6,0xbd}, {0xb6,0xba}, {0x9a,0x64}, {0xb6,0xbc}, {0xb9,0x7e}, {0x8a,0xbf}, {0xe0,0xe2}, {0xe0,0xe3}, {0xe8,0xc0}, {0xb9,0x7d},
    {0xb9,0xa1}, {0xb9,0xa2}, {0xe4,0xcf}, {0xe4,0xce}, {0xbb,0xe5}, {0xbb,0xe6}, {0xe4,0xd0}, {0xe8,0xbf}, {0xbb,0xe8}, {0xbe,0x69},
    {0xbb,0xe7}, {0x9a,0x66}, {0xc0,0x5c}, {0xe8,0xc1}, {0xbe,0x6b}, {0xbe,0x6a}, {0xe8,0xc2}, {0xe8,0xc5}, {0xe8,0xc3}, {0xe8,0xc4},
    {0xbe,0x6c}, {0x9a,0x67}, {0xc0,0x61}, {0xc0,0x5f}, {0x9a,0x69}, {0xc0,0x5e}, {0xec,0x5d}, {0xc0,0x60}, {0xec,0x5c}, {0xef,0x4b},
    {0xec,0x5e}, {0xc0,0x5d}, {0xec,0x5f}, {0xef,0x4e}, {0xef,0x4c}, {0xef,0x4d}, {0xef,0x52}, {0xc3,0x4b}, {0xef,0x51}, {0xef,0x54},
    {0xef,0x53}, {0xef,0x50}, {0xef,0x4f}, {0xc1,0xfd}, {0x9a,0x6a}, {0x96,0x52}, {0x91,0x4d}, {0xf1,0xae}, {0x96,0x66}, {0xf1,0xad},
    {0xc3,0x4a}, {0xc3,0x48}, {0xc3,0x49}, {0x9f,0x7b}, {0xf1,0xac}, {0x9a,0x6b}, {0xf3,0xb1}, {0xc4,0x43}, {0xf3,0xb0}, {0xf3,0xaf},
    {0xc4,0x44}, {0xa0,0x6c}, {0xf5,0x58}, {0xf5,0x57}, {0x96,0x67}, {0xf5,0x55}, {0xf5,0x54}, {0xc4,0xc8}, {0xc4,0xc7}, {0xf5,0x59},
    {0xf7,0x76}, {0xc5,0xb9}, {0xf6,0x77}, {0xc5,0x57}, {0xf6,0x76}, {0xf5,0x56}, {0xf7,0x77}, {0xc5,0xe4}, {0x9a,0x6c}, {0xc6,0x61},
    {0xf9,0x59}, {0xf9,0xb1}, {0x9a,0x6d}, {0x8b,0xf2}, {0xad,0xba}, {0xd8,0x50}, {0xef,0x55}, {0xad,0xbb}, {0x96,0x6a}, {0xe4,0xd2},
    {0xe4,0xd1}, {0xec,0x60}, {0xef,0x57}, {0xef,0x56}, {0xfc,0xea}, {0xc3,0x4c}, {0xf3,0xb2}, {0xf3,0xb3}, {0xc4,0xc9}, {0x96,0x6c},
    {0xf9,0xb2}, {0xb0,0xa8}, {0xb6,0xbf}, {0xb6,0xbe}, {0xe0,0xe4}, {0xe0,0xe6}, {0xb9,0xa4}, {0xe0,0xe5}, {0xb9,0xa3}, {0xb9,0xa5},
    {0xe0,0xe7}, {0x91,0xc4}, {0xe4,0xd4}, {0xe4,0xd6}, {0xe4,0xd5}, {0x96,0x77}, {0xe4,0xd8}, {0xbb,0xe9}, {0xe4,0xd7}, {0xe4,0xd3},
    {0x99,0xf4}, {0x9a,0x6f}, {0xe4,0xd9}, {0xe8,0xcc}, {0xe8,0xcf}, {0xe8,0xd1}, {0xe8,0xc7}, {0xe8,0xcb}, {0xe8,0xc8}, {0xbe,0x6e},
    {0xbe,0x71}, {0xbe,0x73}, {0xe8,0xc9}, {0xe8,0xca}, {0xbe,0x72}, {0xe8,0xcd}, {0xe8,0xd0}, {0xe8,0xce}, {0xbe,0x74}, {0x9f,0xab},
    {0xbe,0x70}, {0xe8,0xc6}, {0xbe,0x6d}, {0xbe,0x6f}, {0x8c,0xbe}, {0x8e,0xc1}, {0xc0,0x63}, {0xec,0x66}, {0xec,0x64}, {0xec,0x63},
    {0x95,0x55}, {0xec,0x69}, {0xec,0x68}, {0xec,0x67}, {0xec,0x62}, {0xc0,0x62}, {0xec,0x61}, {0xec,0x65}, {0xc0,0x64}, {0xef,0x5a},
    {0x91,0x52}, {0xef,0x5e}, {0xef,0x5b}, {0xef,0x5d}, {0xef,0x5c}, {0xef,0x59}, {0xef,0x5f}, {0xef,0x62}, {0xef,0x60}, {0xef,0x61},
    {0xc2,0x40}, {0xc1,0xfe}, {0xef,0x58}, {0xef,0x63}, {0xf1,0xb3}, {0xf1,0xb6}, {0xf1,0xb8}, {0xf1,0xb7}, {0xf1,0xb1}, {0xf1,0xb5},
    {0xf1,0xb0}, {0x91,0x53}, {0xf1,0xb2}, {0xc3,0x4d}, {0xf1,0xaf}, {0x91,0x55}, {0xf1,0xb4}, {0xf3,0xc0}, {0xf3,0xb5}, {0xc4,0x45},
    {0xc4,0x46}, {0xf3,0xb4}, {0xf3,0xb9}, {0xf3,0xbf}, {0xf3,0xb7}, {0xf3,0xbe}, {0x95,0x5d}, {0xf3,0xbb}, {0x96,0x71}, {0xf3,0xba},
    {0xf3,0xbd}, {0xf3,0xb8}, {0xf3,0xb6}, {0x9c,0x6d}, {0xf3,0xbc}, {0xf5,0x60}, {0xf5,0x5e}, {0xc4,0xca}, {0xf5,0x5d}, {0xf5,0x63},
    {0xf5,0x61}, {0x96,0x73}, {0xc4,0xcb}, {0xf5,0x5c}, {0xf5,0x5a}, {0xf5,0x5b}, {0xc4,0xcd}, {0xf5,0x5f}, {0xc4,0xcc}, {0xf5,0x62},
    {0xf6,0x78}, {0xf6,0x7e}, {0x91,0x54}, {0x9a,0x71}, {0xf6,0x79}, {0xc5,0x5b}, {0xf6,0xa1}, {0xc5,0x5a}, {0xf6,0x7d}, {0xf6,0x7c},
    {0xc5,0x59}, {0xf6,0x7b}, {0xc5,0x58}, {0xf6,0x7a}, {0xf7,0x7d}, {0xf7,0xa1}, {0xf7,0x7e}, {0xf7,0x7b}, {0xc5,0xbb}, {0xf7,0x78},
    {0xf7,0x7c}, {0xf7,0xa3}, {0xf7,0xa2}, {0xf7,0x79}, {0xf7,0x7a}, {0xc5,0xba}, {0xf8,0x52}, {0xc5,0xe7}, {0x91,0x56}, {0xf8,0x53},
    {0xc5,0xe5}, {0xc5,0xe6}, {0x96,0x6d}, {0xf8,0xd3}, {0xc6,0x4a}, {0xf9,0x76}, {0xc6,0x6a}, {0x95,0x57}, {0xf9,0xb3}, {0xc6,0x6b},
    {0xf9,0xb4}, {0xf9,0xb5}, {0xf9,0xc3}, {0xf9,0xc2}, {0xc6,0x7a}, {0xf9,0xcd}, {0x89,0xc6}, {0x89,0xc7}, {0xb0,0xa9}, {0xe0,0xe9},
    {0xe0,0xe8}, {0xbb,0xea}, {0xbb,0xeb}, {0xe4,0xda}, {0x8a,0x6a}, {0xe8,0xd2}, {0xec,0x6c}, {0x8b,0x57}, {0xbe,0x75}, {0xc0,0x65},
    {0xec,0x6a}, {0x9f,0xe1}, {0xec,0x6d}, {0xc0,0x66}, {0x9b,0x5f}, {0xef,0x64}, {0xec,0x6b}, {0xf1,0xb9}, {0xc3,0x4e}, {0xf3,0xc1},
    {0xf5,0x66}, {0xf5,0x64}, {0xf5,0x65}, {0xf6,0xa2}, {0xc5,0x5c}, {0xf7,0xa4}, {0xc5,0xea}, {0xc5,0xbc}, {0xc5,0xe8}, {0xc5,0xe9},
    {0xf8,0xd4}, {0xc6,0x62}, {0xa0,0x5d}, {0xb0,0xaa}, {0xf1,0xba}, {0xd4,0x49}, {0x91,0x5b}, {0xb9,0xa6}, {0x91,0x5c}, {0xe4,0xdb},
    {0xbb,0xec}, {0xe4,0xdc}, {0xe8,0xd4}, {0xe8,0xd3}, {0xc0,0x68}, {0xbe,0x76}, {0xbe,0x77}, {0xe8,0xd7}, {0xe8,0xd6}, {0xe8,0xd5},
    {0x91,0x5e}, {0xec,0x6e}, {0xec,0x71}, {0xec,0x70}, {0xec,0x6f}, {0xc0,0x67}, {0xef,0x68}, {0xef,0x66}, {0xef,0x65}, {0x9f,0x5c},
    {0xef,0x67}, {0x9f,0x57}, {0xc3,0x4f}, {0xf1,0xbc}, {0xf1,0xbd}, {0xc3,0x50}, {0xf1,0xbb}, {0x9f,0x65}, {0xf3,0xc3}, {0xf3,0xc2},
    {0xf3,0xc5}, {0xc4,0x47}, {0xf3,0xc4}, {0x9a,0x72}, {0xf5,0x67}, {0xf5,0x69}, {0xf5,0x68}, {0x91,0x60}, {0xf6,0xa3}, {0xf6,0xa6},
    {0xf6,0xa4}, {0xf6,0xa5}, {0xf7,0xa5}, {0xc5,0xbd}, {0xf8,0x54}, {0xf8,0x55}, {0xf8,0x56}, {0xc6,0x4b}, {0xc6,0x63}, {0xf9,0xb6},
    {0xb0,0xab}, {0xbe,0x78}, {0xc0,0x69}, {0xf1,0xbe}, {0x9f,0x5e}, {0xf7,0xa6}, {0x91,0x61}, {0xf9,0xc4}, {0xd4,0x4a}, {0xc6,0x7b},
    {0xb0,0xac}, {0xec,0x72}, {0x91,0x64}, {0xf1,0xbf}, {0xf3,0xc6}, {0x9f,0x41}, {0xf6,0xa7}, {0xf7,0xa7}, {0xb0,0xad}, {0xe4,0xdd},
    {0xe4,0xde}, {0x91,0x69}, {0xbb,0xed}, {0xbb,0xee}, {0xe8,0xd9}, {0xbe,0x7a}, {0xbe,0x79}, {0xe8,0xd8}, {0xef,0x69}, {0xf1,0xc0},
    {0xf1,0xc2}, {0xf1,0xc1}, {0xc3,0x53}, {0xc3,0x52}, {0xc3,0x51}, {0x91,0x68}, {0xc5,0x5e}, {0xf6,0xa8}, {0xc5,0x5d}, {0xf7,0xa9},
    {0xf7,0xa8}, {0xc6,0x4c}, {0xf8,0xd5}, {0xb3,0xbd}, {0xe0,0xea}, {0xe4,0xe1}, {0xe4,0xdf}, {0xe4,0xe0}, {0xe8,0xe2}, {0xe8,0xdd},
    {0xe8,0xda}, {0xe8,0xe1}, {0x9a,0x74}, {0xe8,0xe3}, {0xbe,0x7c}, {0xe8,0xe0}, {0xe8,0xdc}, {0xe8,0xdb}, {0xe8,0xdf}, {0xe8,0xde},
    {0xbe,0x7b}, {0xec,0x7d}, {0xec,0x78}, {0xec,0x76}, {0xec,0xa1}, {0xec,0x77}, {0x96,0xb2}, {0xec,0x73}, {0x9a,0x75}, {0xec,0x79},
    {0xfd,0xa5}, {0xec,0x74}, {0xef,0x72}, {0xec,0x75}, {0xec,0xa2}, {0x9e,0xe9}, {0x8b,0xba}, {0x91,0x6d}, {0xa0,0x60}, {0xec,0x7c},
    {0xc0,0x6a}, {0xec,0x7b}, {0xec,0x7a}, {0xec,0x7e}, {0x9f,0xde}, {0xef,0x6a}, {0xef,0x6d}, {0x9f,0xc3}, {0xef,0x6c}, {0x96,0xb5},
    {0xef,0x74}, {0xef,0x6f}, {0xef,0x73}, {0xef,0x71}, {0xef,0x70}, {0xef,0x6e}, {0xef,0x6b}, {0xc2,0x43}, {0xc2,0x42}, {0xc2,0x44},
    {0xc2,0x41}, {0xef,0x75}, {0xa0,0x67}, {0xf1,0xc8}, {0xf1,0xcb}, {0xf1,0xc9}, {0xf1,0xcd}, {0xf1,0xce}, {0xf1,0xc6}, {0xc3,0x58},
    {0xf1,0xc7}, {0xf1,0xc5}, {0xf1,0xcc}, {0xf1,0xc4}, {0xf1,0xc3}, {0xc3,0x57}, {0xc3,0x55}, {0xc3,0x54}, {0x96,0xb3}, {0xf1,0xca},
    {0xf3,0xcf}, {0xf3,0xd5}, {0xc4,0x4a}, {0xf3,0xd0}, {0xf3,0xd3}, {0xf3,0xd7}, {0xc4,0x4b}, {0xf3,0xd2}, {0x9a,0x76}, {0xf3,0xca},
    {0xf3,0xc9}, {0xf3,0xd6}, {0xf3,0xcd}, {0xf3,0xcb}, {0xf3,0xd4}, {0xf3,0xcc}, {0xc4,0x49}, {0xc4,0x48}, {0x95,0xd5}, {0xf3,0xc7},
    {0xf3,0xc8}, {0xf3,0xd1}, {0x9e,0xca}, {0xf3,0xce}, {0x9a,0x77}, {0x9a,0x78}, {0xf5,0x6c}, {0xf5,0x6f}, {0xc3,0x56}, {0x91,0x70},
    {0x91,0x6f}, {0xf5,0x6d}, {0xf5,0x73}, {0xf5,0x71}, {0xf5,0x6b}, {0xf5,0x76}, {0x9f,0xa3}, {0xf5,0x6a}, {0x91,0x71}, {0xc4,0xcf},
    {0xf5,0x72}, {0x96,0xb1}, {0xf5,0x6e}, {0xc4,0xce}, {0xf5,0x75}, {0x9f,0x63}, {0xf5,0x74}, {0x9f,0x67}, {0xf6,0xab}, {0xf6,0xaa},
    {0x8b,0xb9}, {0x9a,0x7a}, {0xf6,0xb1}, {0xf6,0xad}, {0xf6,0xb0}, {0xc5,0x60}, {0x8b,0x56}, {0xf6,0xae}, {0xf6,0xaf}, {0xf6,0xa9},
    {0xf6,0xac}, {0xc5,0x5f}, {0x9a,0xda}, {0xc5,0xbf}, {0xf7,0xb4}, {0xf7,0xaf}, {0xf7,0xb3}, {0x96,0xb0}, {0xf7,0xb6}, {0xf7,0xb2},
    {0xf7,0xae}, {0x9a,0x7e}, {0xc5,0xc1}, {0xf7,0xb1}, {0xf7,0xb5}, {0xc5,0xc0}, {0xf7,0xac}, {0xf5,0x70}, {0xf7,0xb0}, {0xf7,0xad},
    {0x9d,0xde}, {0xf7,0xaa}, {0xf7,0xab}, {0xc5,0xbe}, {0xf8,0x5a}, {0xf8,0x5c}, {0xf8,0x5f}, {0xf8,0x5b}, {0xf8,0x60}, {0x96,0xad},
    {0xf8,0x59}, {0xf8,0x57}, {0x96,0xae}, {0xc5,0xeb}, {0xf8,0x5d}, {0xc5,0xed}, {0xc5,0xec}, {0xf8,0x58}, {0xf8,0x5e}, {0x9e,0xa1},
    {0xf8,0xda}, {0xc6,0x4d}, {0xf8,0xdb}, {0xf8,0xd9}, {0xf8,0xd6}, {0xf8,0xd8}, {0xf8,0xd7}, {0xf9,0x5a}, {0xf9,0x5c}, {0xf9,0x5b},
    {0xf9,0x79}, {0x9e,0x50}, {0xf9,0x78}, {0xf9,0x77}, {0xf9,0x7a}, {0xc6,0x73}, {0xc6,0x74}, {0xf9,0xca}, {0xf9,0xce}, {0x96,0xaf},
    {0x8b,0xf4}, {0xb3,0xbe}, {0xdc,0xaf}, {0xe0,0xed}, {0xb9,0xa7}, {0xe0,0xeb}, {0xe0,0xec}, {0xe4,0xe2}, {0xe4,0xe3}, {0xbb,0xf1},
    {0xbb,0xef}, {0xe4,0xe4}, {0xbb,0xf0}, {0xe8,0xe8}, {0xe8,0xeb}, {0xe8,0xe5}, {0xe8,0xec}, {0xe8,0xe4}, {0xe8,0xe6}, {0xe8,0xe7},
    {0xe8,0xea}, {0x9f,0xa4}, {0xbe,0xa1}, {0xe8,0xef}, {0xe8,0xee}, {0xbe,0x7d}, {0xe8,0xe9}, {0xe8,0xed}, {0xbe,0x7e}, {0x96,0xbd},
    {0xec,0xac}, {0xc0,0x6f}, {0xec,0xa7}, {0xc0,0x6b}, {0x96,0xf4}, {0xec,0xa4}, {0xec,0xaa}, {0xec,0xad}, {0xc0,0x70}, {0xec,0xa9},
    {0xec,0xa6}, {0xec,0xae}, {0xec,0xa5}, {0x96,0xb8}, {0xec,0xab}, {0xc0,0x6c}, {0xec,0xa3}, {0xc0,0x6d}, {0xc0,0x6e}, {0xec,0xa8},
    {0xef,0xa9}, {0xef,0x7a}, {0xef,0x7b}, {0xef,0x7e}, {0xef,0x7c}, {0xef,0x76}, {0xfa,0xa1}, {0xef,0x79}, {0xef,0xa5}, {0xef,0x7d},
    {0x91,0xa7}, {0xc2,0x45}, {0xef,0xa7}, {0xef,0xa4}, {0xc2,0x46}, {0xef,0xa6}, {0xef,0x77}, {0xef,0xa2}, {0xef,0xa3}, {0xa0,0x5e},
    {0xef,0xa1}, {0x9a,0x7d}, {0xf1,0xd2}, {0xf1,0xd4}, {0xf1,0xd7}, {0x89,0x48}, {0xf1,0xd1}, {0x9e,0xb1}, {0xc3,0x59}, {0xf1,0xd9},
    {0xf1,0xd0}, {0xf1,0xda}, {0xf1,0xd6}, {0xf1,0xd8}, {0xf1,0xdc}, {0xf1,0xd5}, {0xf1,0xdd}, {0xf1,0xd3}, {0xf1,0xcf}, {0xc3,0x5a},
    {0x9d,0xdb}, {0xf1,0xdb}, {0xc3,0x5b}, {0xc4,0x4d}, {0xef,0x78}, {0xf3,0xf1}, {0xf3,0xe8}, {0xc4,0x4f}, {0xf3,0xe4}, {0xc4,0x50},
    {0x95,0xbf}, {0x8a,0x73}, {0xf3,0xed}, {0xf3,0xe7}, {0xf3,0xdd}, {0xc4,0x4e}, {0xf3,0xea}, {0xf3,0xe5}, {0xf3,0xe6}, {0xf3,0xd8},
    {0xf3,0xdf}, {0xf3,0xee}, {0xf3,0xeb}, {0x9e,0xfe}, {0xf3,0xe3}, {0x91,0x7a}, {0xf3,0xef}, {0xf3,0xde}, {0xf3,0xd9}, {0xf3,0xec},
    {0x91,0x7b}, {0xf3,0xdb}, {0xf3,0xe9}, {0xf3,0xe0}, {0xf3,0xf0}, {0xf3,0xdc}, {0xc4,0x4c}, {0xf3,0xda}, {0xf3,0xe1}, {0xf3,0xe2},
    {0xf5,0x7d}, {0xf5,0x7b}, {0x9a,0xa3}, {0xf5,0xa2}, {0xf5,0xae}, {0xf5,0xa5}, {0xf5,0x7c}, {0xf5,0x78}, {0xf5,0xa7}, {0xf5,0x7e},
    {0xf5,0xa3}, {0xf5,0x7a}, {0xf5,0xaa}, {0xf5,0x77}, {0xf5,0xa1}, {0xf5,0xa6}, {0xf5,0xa8}, {0xf5,0xab}, {0xf5,0x79}, {0x96,0xc2},
    {0xf5,0xaf}, {0xf5,0xb0}, {0xf5,0xa9}, {0xf5,0xad}, {0xf5,0xa4}, {0x9f,0x77}, {0xf6,0xc1}, {0xf6,0xc4}, {0xc5,0x61}, {0xf6,0xc3},
    {0xf6,0xc8}, {0xf6,0xc6}, {0xc5,0x62}, {0xf6,0xbd}, {0xf6,0xb3}, {0xf6,0xb2}, {0xc5,0x64}, {0xf6,0xbf}, {0xf6,0xc0}, {0xf6,0xbc},
    {0xf6,0xb4}, {0x9a,0xa4}, {0xf6,0xb9}, {0xf5,0xac}, {0x9a,0xa5}, {0xf6,0xb5}, {0xc5,0x63}, {0xf6,0xbb}, {0x91,0xa1}, {0xf6,0xba},
    {0xf6,0xb6}, {0xf6,0xc2}, {0x89,0xb8}, {0xf6,0xb7}, {0xf7,0xbb}, {0xf6,0xc5}, {0xf6,0xc7}, {0xf6,0xbe}, {0xf6,0xb8}, {0xf7,0xbc},
    {0xf7,0xbe}, {0xf7,0xb8}, {0xc5,0xc2}, {0x91,0x73}, {0xf7,0xc5}, {0xf7,0xc3}, {0xc5,0xc3}, {0xf7,0xc2}, {0xf7,0xc1}, {0xf7,0xba},
    {0xf7,0xb7}, {0xf7,0xbd}, {0xf7,0xc6}, {0xf7,0xb9}, {0xf7,0xbf}, {0xf8,0x69}, {0xf8,0x6e}, {0xf8,0x64}, {0xf8,0x67}, {0xc5,0xee},
    {0xf8,0x6b}, {0xf8,0x72}, {0xf7,0xc0}, {0xf8,0x65}, {0xf8,0x6f}, {0xf8,0x73}, {0xf8,0x6a}, {0xf8,0x63}, {0xf8,0x6d}, {0xf8,0x6c},
    {0xf8,0x71}, {0xf8,0x70}, {0xf7,0xc4}, {0xf8,0x68}, {0xf8,0x62}, {0xf8,0x66}, {0xc6,0x4e}, {0xc6,0x4f}, {0xf8,0x61}, {0x9a,0xa6},
    {0xf8,0xe6}, {0xf8,0xdd}, {0xf8,0xe5}, {0xf8,0xe2}, {0xf8,0xe3}, {0xf8,0xdc}, {0xf8,0xdf}, {0xf8,0xe7}, {0xf8,0xe1}, {0xf8,0xe0},
    {0xf8,0xde}, {0xf8,0xe4}, {0x89,0xbd}, {0xf9,0x5d}, {0x89,0xb9}, {0xf9,0x5e}, {0x91,0x7d}, {0xf9,0x60}, {0xf9,0x5f}, {0xf9,0x62},
    {0xf9,0x61}, {0xf9,0x7c}, {0xf9,0x7b}, {0xf9,0xb7}, {0xf9,0xb8}, {0x96,0xbb}, {0xf9,0xc5}, {0xc6,0x78}, {0xc6,0x7c}, {0x9f,0xf2},
    {0xf9,0xcf}, {0xc6,0x7d}, {0x8b,0xf5}, {0xb3,0xbf}, {0xc4,0xd0}, {0xf6,0xc9}, {0x9a,0xa9}, {0xc6,0x50}, {0xc6,0x51}, {0xb3,0xc0},
    {0xe0,0xee}, {0x9f,0x54}, {0xb9,0xa8}, {0xe8,0xf0}, {0x9f,0xe3}, {0x9e,0xed}, {0xec,0xb0}, {0xec,0xb1}, {0xec,0xaf}, {0xef,0xab},
    {0xef,0xaa}, {0xc2,0x47}, {0xf1,0xdf}, {0xef,0xac}, {0xf1,0xde}, {0x91,0xaa}, {0xf3,0xf3}, {0xc4,0x51}, {0xc4,0x53}, {0xf3,0xf2},
    {0x91,0xab}, {0xa0,0x70}, {0xc4,0x52}, {0x9f,0x6d}, {0xf5,0xb1}, {0xf5,0xb3}, {0xf5,0xb2}, {0xf6,0xca}, {0xc5,0x65}, {0x91,0xac},
    {0xc5,0xef}, {0xf8,0xe8}, {0xf9,0x63}, {0x91,0xad}, {0xf9,0xd2}, {0xb3,0xc1}, {0xa0,0xfd}, {0xe4,0xe5}, {0x9f,0xe2}, {0xbe,0xa2},
    {0x91,0xaf}, {0x9e,0x41}, {0x9a,0xaa}, {0xec,0xb3}, {0xec,0xb2}, {0x91,0xb0}, {0xef,0xad}, {0x9a,0xab}, {0xc4,0x54}, {0xc4,0xd1},
    {0xf7,0xc7}, {0xf9,0xcb}, {0xb3,0xc2}, {0xbb,0xf2}, {0x9a,0xac}, {0xbe,0xa3}, {0x9a,0x4a}, {0xf3,0xf4}, {0x91,0xb2}, {0xf8,0x74},
    {0xb6,0xc0}, {0x8b,0xf6}, {0x9a,0xad}, {0x89,0xb6}, {0xef,0xae}, {0xc6,0x64}, {0xb6,0xc1}, {0xbe,0xa4}, {0xc2,0x48}, {0xf8,0x75},
    {0xb6,0xc2}, {0xe8,0xf1}, {0xc0,0x72}, {0xec,0xb4}, {0xec,0xb5}, {0xc0,0x71}, {0xef,0xaf}, {0xc2,0x4c}, {0xc2,0x4a}, {0xc2,0x4b},
    {0xc2,0x49}, {0xf1,0xe0}, {0xc3,0x5c}, {0x9a,0xaf}, {0xf5,0xb5}, {0xf5,0xb4}, {0xf5,0xb7}, {0xf5,0xb6}, {0xc4,0xd2}, {0xf6,0xcb},
    {0xf6,0xcd}, {0xf6,0xcc}, {0xc5,0x66}, {0xf7,0xc8}, {0x9a,0xb0}, {0xf8,0x76}, {0xf8,0x77}, {0xc5,0xf0}, {0xf9,0x64}, {0xf9,0x7d},
    {0xc6,0x75}, {0x9a,0xb1}, {0xdc,0xb0}, {0xec,0xb6}, {0xef,0xb0}, {0xf3,0xf5}, {0xe0,0xef}, {0x9a,0xa1}, {0xef,0xb1}, {0xf1,0xe2},
    {0xf1,0xe1}, {0x91,0xb9}, {0xf8,0x78}, {0xc6,0x52}, {0x91,0xba}, {0xf9,0x65}, {0xf9,0x7e}, {0xb9,0xa9}, {0xe8,0xf2}, {0xe8,0xf3},
    {0xec,0xb7}, {0xb9,0xaa}, {0xc3,0x5d}, {0xf1,0xe3}, {0x91,0xbe}, {0xf6,0xcf}, {0xc5,0x67}, {0xf6,0xd0}, {0xf6,0xce}, {0xf8,0x79},
    {0xf8,0xe9}, {0xb9,0xab}, {0xef,0xb4}, {0xef,0xb3}, {0xef,0xb2}, {0xf1,0xe4}, {0xa0,0x41}, {0x8b,0xb7}, {0xf1,0xe8}, {0xf1,0xe7},
    {0xf1,0xe6}, {0xf1,0xe5}, {0xc3,0x5e}, {0xf3,0xf6}, {0xf5,0xb9}, {0xc4,0xd3}, {0xf5,0xb8}, {0xf6,0xd1}, {0xf7,0xcb}, {0xf7,0xca},
    {0xc5,0xc4}, {0xf7,0xc9}, {0xf8,0x7c}, {0xf8,0x7b}, {0xf8,0x7a}, {0x91,0xc0}, {0xbb,0xf3}, {0xec,0xb8}, {0xc2,0x4d}, {0xf3,0xf7},
    {0xf3,0xf8}, {0xf7,0xcc}, {0xf8,0x7d}, {0x9a,0xb3}, {0x91,0xc3}, {0xf8,0xea}, {0xf9,0x66}, {0xf9,0xb9}, {0xf9,0xd4}, {0xbb,0xf4},
    {0xc2,0x4e}, {0xf1,0xe9}, {0xf3,0xf9}, {0xf6,0xd2}, {0xf8,0x7e}, {0xa0,0xfc}, {0xbe,0xa6}, {0x9f,0xee}, {0xef,0xb5}, {0xf1,0xea},
    {0xf3,0xfa}, {0xf3,0xfb}, {0xf3,0xfc}, {0xf5,0xbe}, {0x9f,0x69}, {0xf5,0xba}, {0xc5,0x68}, {0xf5,0xbd}, {0xf5,0xbc}, {0xc4,0xd4},
    {0xf5,0xbb}, {0xc4,0xd6}, {0x91,0xc8}, {0xc4,0xd5}, {0xf6,0xd4}, {0xf6,0xd3}, {0xc5,0x69}, {0xc5,0x6a}, {0x91,0xc9}, {0xc5,0xc6},
    {0xf7,0xcd}, {0xc5,0xc5}, {0xf8,0xa3}, {0xf8,0xa4}, {0xf8,0xa2}, {0xf8,0xa1}, {0xc6,0x54}, {0xf8,0xeb}, {0xf8,0xec}, {0xf8,0xed},
    {0xc6,0x53}, {0xf9,0x67}, {0xf9,0x6a}, {0xf9,0x69}, {0xf9,0x68}, {0xf9,0xd3}, {0x8d,0xe6}, {0xc0,0x73}, {0x91,0xcb}, {0xc3,0x65},
    {0xf5,0xbf}, {0xf6,0xd5}, {0xc5,0xc7}, {0xf7,0xce}, {0xf9,0xd5}, {0x89,0xc8}, {0xc0,0x74}, {0x8d,0xaa}, {0xef,0xb6}, {0xf7,0xcf},
    {0xf9,0xa1}, {0x9f,0xdd}, {0xfa,0x40}, {0xfa,0x41}, {0xfa,0x42}, {0xfa,0x43}, {0xfa,0x44}, {0xfa,0x45}, {0xfa,0x46}, {0xfa,0x47},
    {0xfa,0x48}, {0xfa,0x49}, {0xfa,0x4a}, {0xfa,0x4b}, {0xfa,0x4c}, {0xfa,0x4d}, {0xfa,0x4e}, {0xfa,0x4f}, {0xfa,0x50}, {0xfa,0x51},
    {0xfa,0x52}, {0xfa,0x53}, {0xfa,0x54}, {0xfa,0x55}, {0xfa,0x56}, {0xfa,0x57}, {0xfa,0x58}, {0xfa,0x59}, {0xfa,0x5a}, {0xfa,0x5b},
    {0xfa,0x5c}, {0xfa,0x5d}, {0xfa,0x5e}, {0xad,0xc5}, {0xfa,0x60}, {0xfa,0x61}, {0xfa,0x62}, {0xfa,0x63}, {0xfa,0x64}, {0xfa,0x65},
    {0xb0,0xb0}, {0xfa,0x67}, {0xfa,0x68}, {0xfa,0x69}, {0xfa,0x6a}, {0xfa,0x6b}, {0xfa,0x6c}, {0xfa,0x6d}, {0xfa,0x6e}, {0xfa,0x6f},
    {0xfa,0x70}, {0xfa,0x71}, {0xfa,0x72}, {0xfa,0x73}, {0xfa,0x74}, {0xfa,0x75}, {0xfa,0x76}, {0xfa,0x77}, {0xfa,0x78}, {0xfa,0x79},
    {0xfa,0x7a}, {0xfa,0x7b}, {0xfa,0x7c}, {0xfa,0x7d}, {0xfa,0x7e}, {0xfa,0xa1}, {0xfa,0xa2}, {0xfa,0xa3}, {0xfa,0xa4}, {0xfa,0xa5},
    {0xfa,0xa6}, {0xfa,0xa7}, {0xfa,0xa8}, {0xfa,0xa9}, {0xfa,0xaa}, {0xfa,0xab}, {0xfa,0xac}, {0xfa,0xad}, {0xfa,0xae}, {0xfa,0xaf},
    {0xfa,0xb0}, {0xfa,0xb1}, {0xfa,0xb2}, {0xfa,0xb3}, {0xfa,0xb4}, {0xfa,0xb5}, {0xfa,0xb6}, {0xfa,0xb7}, {0xfa,0xb8}, {0xfa,0xb9},
    {0xfa,0xba}, {0xfa,0xbb}, {0xfa,0xbc}, {0xa5,0x5d}, {0xfa,0xbe}, {0xfa,0xbf}, {0xfa,0xc0}, {0xfa,0xc1}, {0xfa,0xc2}, {0xfa,0xc3},
    {0xfa,0xc4}, {0xa2,0xcd}, {0xfa,0xc6}, {0xfa,0xc7}, {0xfa,0xc8}, {0xfa,0xc9}, {0xfa,0xca}, {0xfa,0xcb}, {0xfa,0xcc}, {0xfa,0xcd},
    {0xfa,0xce}, {0xfa,0xcf}, {0xfa,0xd0}, {0xfa,0xd1}, {0xfa,0xd2}, {0xfa,0xd3}, {0xfa,0xd4}, {0xad,0xeb}, {0xfa,0xd6}, {0xfa,0xd7},
    {0xfa,0xd8}, {0xfa,0xd9}, {0xfa,0xda}, {0xfa,0xdb}, {0xfa,0xdc}, {0xfa,0xdd}, {0xfa,0xde}, {0xfa,0xdf}, {0xfa,0xe0}, {0xfa,0xe1},
    {0xfa,0xe2}, {0xfa,0xe3}, {0xfa,0xe4}, {0xfa,0xe5}, {0xfa,0xe6}, {0xfa,0xe7}, {0xfa,0xe8}, {0xfa,0xe9}, {0xfa,0xea}, {0xfa,0xeb},
    {0xfa,0xec}, {0xfa,0xed}, {0xfa,0xee}, {0xfa,0xef}, {0xfa,0xf0}, {0xfa,0xf1}, {0xfa,0xf2}, {0xfa,0xf3}, {0xfa,0xf4}, {0xfa,0xf5},
    {0xfa,0xf6}, {0xfa,0xf7}, {0xfa,0xf8}, {0xfa,0xf9}, {0xfa,0xfa}, {0xfa,0xfb}, {0xfa,0xfc}, {0xfa,0xfd}, {0xfa,0xfe}, {0xfb,0x40},
    {0xfb,0x41}, {0xfb,0x42}, {0xfb,0x43}, {0xfb,0x44}, {0xfb,0x45}, {0xfb,0x46}, {0xfb,0x47}, {0x9d,0xef}, {0xfb,0x49}, {0xfb,0x4a},
    {0xfb,0x4b}, {0xfb,0x4c}, {0xfb,0x4d}, {0xfb,0x4e}, {0xfb,0x4f}, {0xfb,0x50}, {0xfb,0x51}, {0xfb,0x52}, {0xfb,0x53}, {0xfb,0x54},
    {0xfb,0x55}, {0xfb,0x56}, {0xfb,0x57}, {0xfb,0x58}, {0xfb,0x59}, {0xfb,0x5a}, {0xfb,0x5b}, {0xfb,0x5c}, {0xfb,0x5d}, {0xfb,0x5e},
    {0xfb,0x5f}, {0xfb,0x60}, {0xfb,0x61}, {0xfb,0x62}, {0xfb,0x63}, {0xfb,0x64}, {0xfb,0x65}, {0xfb,0x66}, {0xfb,0x67}, {0xfb,0x68},
    {0xfb,0x69}, {0xfb,0x6a}, {0xfb,0x6b}, {0xfb,0x6c}, {0xfb,0x6d}, {0xfb,0x6e}, {0xfb,0x6f}, {0xfb,0x70}, {0xfb,0x71}, {0xfb,0x72},
    {0xfb,0x73}, {0xfb,0x74}, {0xfb,0x75}, {0xfb,0x76}, {0xfb,0x77}, {0xfb,0x78}, {0xfb,0x79}, {0xfb,0x7a}, {0xfb,0x7b}, {0xfb,0x7c},
    {0xfb,0x7d}, {0xfb,0x7e}, {0xfb,0xa1}, {0xfb,0xa2}, {0xfb,0xa3}, {0xfb,0xa4}, {0xfb,0xa5}, {0xfb,0xa6}, {0xfb,0xa7}, {0xfb,0xa8},
    {0xfb,0xa9}, {0xfb,0xaa}, {0xfb,0xab}, {0xfb,0xac}, {0xfb,0xad}, {0xfb,0xae}, {0xfb,0xaf}, {0xfb,0xb0}, {0xfb,0xb1}, {0xfb,0xb2},
    {0xfb,0xb3}, {0xfb,0xb4}, {0xfb,0xb5}, {0xfb,0xb6}, {0xfb,0xb7}, {0xb4,0x40}, {0xfb,0xb9}, {0xfb,0xba}, {0xfb,0xbb}, {0xfb,0xbc},
    {0xfb,0xbd}, {0xfb,0xbe}, {0xfb,0xbf}, {0xfb,0xc0}, {0xfb,0xc1}, {0xfb,0xc2}, {0xfb,0xc3}, {0xfb,0xc4}, {0xfb,0xc5}, {0xfb,0xc6},
    {0xfb,0xc7}, {0xfb,0xc8}, {0xfb,0xc9}, {0xfb,0xca}, {0xfb,0xcb}, {0xfb,0xcc}, {0xfb,0xcd}, {0xfb,0xce}, {0xfb,0xcf}, {0xfb,0xd0},
    {0xfb,0xd1}, {0xfb,0xd2}, {0xfb,0xd3}, {0xfb,0xd4}, {0xfb,0xd5}, {0xfb,0xd6}, {0xfb,0xd7}, {0xfb,0xd8}, {0xfb,0xd9}, {0xfb,0xda},
    {0xfb,0xdb}, {0xfb,0xdc}, {0xfb,0xdd}, {0xfb,0xde}, {0xfb,0xdf}, {0xfb,0xe0}, {0xfb,0xe1}, {0xfb,0xe2}, {0xfb,0xe3}, {0xfb,0xe4},
    {0xfb,0xe5}, {0xfb,0xe6}, {0xfb,0xe7}, {0xfb,0xe8}, {0xfb,0xe9}, {0xfb,0xea}, {0xfb,0xeb}, {0xfb,0xec}, {0xfb,0xed}, {0xfb,0xee},
    {0xfb,0xef}, {0xfb,0xf0}, {0xfb,0xf1}, {0xfb,0xf2}, {0xc9,0xdb}, {0xfb,0xf4}, {0xfb,0xf5}, {0xfb,0xf6}, {0xfb,0xf7}, {0xfb,0xf8},
    {0x9d,0xfb}, {0xfb,0xfa}, {0xfb,0xfb}, {0xfb,0xfc}, {0xfb,0xfd}, {0xfb,0xfe}, {0xfc,0x40}, {0xfc,0x41}, {0xfc,0x42}, {0xfc,0x43},
    {0xfc,0x44}, {0xfc,0x45}, {0xfc,0x46}, {0xfc,0x47}, {0xfc,0x48}, {0xfc,0x49}, {0xfc,0x4a}, {0xfc,0x4b}, {0xfc,0x4c}, {0xfc,0x4d},
    {0xfc,0x4e}, {0xd8,0xf4}, {0xfc,0x50}, {0xfc,0x51}, {0xfc,0x52}, {0xfc,0x53}, {0xfc,0x54}, {0xfc,0x55}, {0xfc,0x56}, {0xfc,0x57},
    {0xfc,0x58}, {0xfc,0x59}, {0xfc,0x5a}, {0xfc,0x5b}, {0xfc,0x5c}, {0xfc,0x5d}, {0xfc,0x5e}, {0xfc,0x5f}, {0xfc,0x60}, {0xfc,0x61},
    {0xfc,0x62}, {0xfc,0x63}, {0xfc,0x64}, {0xfc,0x65}, {0xfc,0x66}, {0xfc,0x67}, {0xfc,0x68}, {0xfc,0x69}, {0xfc,0x6a}, {0xfc,0x6b},
    {0xa0,0xdc}, {0xfc,0x6d}, {0xfc,0x6e}, {0xfc,0x6f}, {0xfc,0x70}, {0xfc,0x71}, {0xfc,0x72}, {0xfc,0x73}, {0xfc,0x74}, {0xfc,0x75},
    {0xfc,0x76}, {0xfc,0x77}, {0xfc,0x78}, {0xfc,0x79}, {0xfc,0x7a}, {0xfc,0x7b}, {0xfc,0x7c}, {0xfc,0x7d}, {0xfc,0x7e}, {0xfc,0xa1},
    {0xfc,0xa2}, {0xfc,0xa3}, {0xfc,0xa4}, {0xfc,0xa5}, {0xfc,0xa6}, {0xfc,0xa7}, {0xfc,0xa8}, {0xfc,0xa9}, {0xfc,0xaa}, {0xfc,0xab},
    {0xfc,0xac}, {0xfc,0xad}, {0xfc,0xae}, {0xfc,0xaf}, {0xfc,0xb0}, {0xfc,0xb1}, {0xfc,0xb2}, {0xfc,0xb3}, {0xfc,0xb4}, {0xfc,0xb5},
    {0xfc,0xb6}, {0xfc,0xb7}, {0xfc,0xb8}, {0xbc,0xb5}, {0xfc,0xba}, {0xfc,0xbb}, {0xfc,0xbc}, {0xfc,0xbd}, {0xfc,0xbe}, {0xfc,0xbf},
    {0xfc,0xc0}, {0xfc,0xc1}, {0xfc,0xc2}, {0xfc,0xc3}, {0xfc,0xc4}, {0xfc,0xc5}, {0xfc,0xc6}, {0xfc,0xc7}, {0xfc,0xc8}, {0xfc,0xc9},
    {0xfc,0xca}, {0xfc,0xcb}, {0xfc,0xcc}, {0xfc,0xcd}, {0xfc,0xce}, {0xfc,0xcf}, {0xfc,0xd0}, {0xfc,0xd1}, {0xfc,0xd2}, {0xfc,0xd3},
    {0xfc,0xd4}, {0xfc,0xd5}, {0xfc,0xd6}, {0xfc,0xd7}, {0xfc,0xd8}, {0xfc,0xd9}, {0xfc,0xda}, {0xfc,0xdb}, {0xfc,0xdc}, {0xfc,0xdd},
    {0xfc,0xde}, {0xfc,0xdf}, {0xfc,0xe0}, {0xfc,0xe1}, {0xb4,0xb8}, {0xfc,0xe3}, {0xfc,0xe4}, {0xfc,0xe5}, {0xfc,0xe6}, {0xfc,0xe7},
    {0xfc,0xe8}, {0xfc,0xe9}, {0xfc,0xea}, {0xfc,0xeb}, {0xfc,0xec}, {0xfc,0xed}, {0xfc,0xee}, {0xfc,0xef}, {0xfc,0xf0}, {0xa7,0xfb},
    {0xfc,0xf2}, {0xfc,0xf3}, {0xfc,0xf4}, {0xfc,0xf5}, {0xfc,0xf6}, {0xfc,0xf7}, {0xfc,0xf8}, {0xfc,0xf9}, {0xfc,0xfa}, {0xfc,0xfb},
    {0xfc,0xfc}, {0xfc,0xfd}, {0xfc,0xfe}, {0xfd,0x40}, {0xfd,0x41}, {0xfd,0x42}, {0xfd,0x43}, {0xfd,0x44}, {0xfd,0x45}, {0xfd,0x46},
    {0xfd,0x47}, {0xfd,0x48}, {0xfd,0x49}, {0xfd,0x4a}, {0xfd,0x4b}, {0xfd,0x4c}, {0xfd,0x4d}, {0xfd,0x4e}, {0xfd,0x4f}, {0xfd,0x50},
    {0xfd,0x51}, {0xfd,0x52}, {0xfd,0x53}, {0xfd,0x54}, {0xfd,0x55}, {0xfd,0x56}, {0xfd,0x57}, {0xfd,0x58}, {0xfd,0x59}, {0xfd,0x5a},
    {0xfd,0x5b}, {0xfd,0x5c}, {0xfd,0x5d}, {0xfd,0x5e}, {0xfd,0x5f}, {0xfd,0x60}, {0xfd,0x61}, {0xfd,0x62}, {0xfd,0x63}, {0xfd,0x64},
    {0xfd,0x65}, {0xfd,0x66}, {0xfd,0x67}, {0xfd,0x68}, {0xfd,0x69}, {0xfd,0x6a}, {0xfd,0x6b}, {0xfd,0x6c}, {0xfd,0x6d}, {0xfd,0x6e},
    {0xfd,0x6f}, {0xfd,0x70}, {0xfd,0x71}, {0xfd,0x72}, {0xfd,0x73}, {0xfd,0x74}, {0xfd,0x75}, {0xfd,0x76}, {0xfd,0x77}, {0xfd,0x78},
    {0xfd,0x79}, {0xfd,0x7a}, {0xfd,0x7b}, {0xfd,0x7c}, {0xfd,0x7d}, {0xfd,0x7e}, {0xfd,0xa1}, {0xfd,0xa2}, {0xfd,0xa3}, {0xfd,0xa4},
    {0xfd,0xa5}, {0xfd,0xa6}, {0xfd,0xa7}, {0xfd,0xa8}, {0xfd,0xa9}, {0xfd,0xaa}, {0xfd,0xab}, {0xfd,0xac}, {0xfd,0xad}, {0xfd,0xae},
    {0xfd,0xaf}, {0xfd,0xb0}, {0xfd,0xb1}, {0xfd,0xb2}, {0xfd,0xb3}, {0xfd,0xb4}, {0xfd,0xb5}, {0xfd,0xb6}, {0xcb,0x58}, {0xb4,0xfc},
    {0xfd,0xb9}, {0xfd,0xba}, {0xb4,0xe4}, {0xfd,0xbc}, {0xfd,0xbd}, {0xfd,0xbe}, {0xfd,0xbf}, {0xfd,0xc0}, {0xfd,0xc1}, {0xfd,0xc2},
    {0xfd,0xc3}, {0xfd,0xc4}, {0xfd,0xc5}, {0xfd,0xc6}, {0xfd,0xc7}, {0xfd,0xc8}, {0xfd,0xc9}, {0xfd,0xca}, {0xfd,0xcb}, {0xfd,0xcc},
    {0xfd,0xcd}, {0xfd,0xce}, {0xfd,0xcf}, {0xfd,0xd0}, {0xfd,0xd1}, {0xfd,0xd2}, {0xfd,0xd3}, {0xfd,0xd4}, {0xfd,0xd5}, {0xfd,0xd6},
    {0xfd,0xd7}, {0xfd,0xd8}, {0xfd,0xd9}, {0xfd,0xda}, {0xfd,0xdb}, {0xfd,0xdc}, {0xfd,0xdd}, {0xfd,0xde}, {0xfd,0xdf}, {0xfd,0xe0},
    {0xfd,0xe1}, {0xfd,0xe2}, {0xfd,0xe3}, {0xfd,0xe4}, {0xfd,0xe5}, {0xfd,0xe6}, {0xfd,0xe7}, {0xfd,0xe8}, {0xfd,0xe9}, {0xfd,0xea},
    {0xfd,0xeb}, {0xfd,0xec}, {0xfd,0xed}, {0xfd,0xee}, {0xfd,0xef}, {0xfd,0xf0}, {0xb5,0x4e}, {0xfd,0xf2}, {0xfd,0xf3}, {0xfd,0xf4},
    {0xfd,0xf5}, {0xfd,0xf6}, {0xfd,0xf7}, {0xfd,0xf8}, {0xfd,0xf9}, {0xfd,0xfa}, {0xfd,0xfb}, {0xfd,0xfc}, {0xfd,0xfd}, {0xfd,0xfe},
    {0xfe,0x40}, {0xfe,0x41}, {0xfe,0x42}, {0xfe,0x43}, {0xfe,0x44}, {0xfe,0x45}, {0xfe,0x46}, {0xfe,0x47}, {0xfe,0x48}, {0xfe,0x49},
    {0xfe,0x4a}, {0xfe,0x4b}, {0xfe,0x4c}, {0xfe,0x4d}, {0xfe,0x4e}, {0xfe,0x4f}, {0xfe,0x50}, {0xfe,0x51}, {0x99,0x75}, {0xfe,0x53},
    {0xfe,0x54}, {0xfe,0x55}, {0xfe,0x56}, {0xfe,0x57}, {0xfe,0x58}, {0xfe,0x59}, {0xfe,0x5a}, {0xfe,0x5b}, {0xfe,0x5c}, {0xfe,0x5d},
    {0xfe,0x5e}, {0xfe,0x5f}, {0xfe,0x60}, {0xfe,0x61}, {0xfe,0x62}, {0xfe,0x63}, {0xfe,0x64}, {0xfe,0x65}, {0xfe,0x66}, {0xfe,0x67},
    {0xfe,0x68}, {0xfe,0x69}, {0xfe,0x6a}, {0xfe,0x6b}, {0xfe,0x6c}, {0xfe,0x6d}, {0xfe,0x6e}, {0xb7,0xec}, {0xfe,0x70}, {0xfe,0x71},
    {0xfe,0x72}, {0xfe,0x73}, {0xfe,0x74}, {0xfe,0x75}, {0xfe,0x76}, {0xfe,0x77}, {0xfe,0x78}, {0xfe,0x79}, {0xfe,0x7a}, {0xfe,0x7b},
    {0xfe,0x7c}, {0xfe,0x7d}, {0xfe,0x7e}, {0xfe,0xa1}, {0xfe,0xa2}, {0xfe,0xa3}, {0xfe,0xa4}, {0xfe,0xa5}, {0xfe,0xa6}, {0xfe,0xa7},
    {0xfe,0xa8}, {0xfe,0xa9}, {0xa2,0x60}, {0xfe,0xab}, {0xfe,0xac}, {0xfe,0xad}, {0xfe,0xae}, {0xfe,0xaf}, {0xfe,0xb0}, {0xfe,0xb1},
    {0xfe,0xb2}, {0xfe,0xb3}, {0xfe,0xb4}, {0xfe,0xb5}, {0xfe,0xb6}, {0xfe,0xb7}, {0xfe,0xb8}, {0xfe,0xb9}, {0xfe,0xba}, {0xfe,0xbb},
    {0xfe,0xbc}, {0xfe,0xbd}, {0xfe,0xbe}, {0xfe,0xbf}, {0xfe,0xc0}, {0xfe,0xc1}, {0xfe,0xc2}, {0xfe,0xc3}, {0xfe,0xc4}, {0xfe,0xc5},
    {0xfe,0xc6}, {0xfe,0xc7}, {0xfe,0xc8}, {0xfe,0xc9}, {0xfe,0xca}, {0xfe,0xcb}, {0xfe,0xcc}, {0xfe,0xcd}, {0xfe,0xce}, {0xfe,0xcf},
    {0xfe,0xd0}, {0xfe,0xd1}, {0xfe,0xd2}, {0xfe,0xd3}, {0xfe,0xd4}, {0xfe,0xd5}, {0xfe,0xd6}, {0xfe,0xd7}, {0xfe,0xd8}, {0xfe,0xd9},
    {0xfe,0xda}, {0xfe,0xdb}, {0xfe,0xdc}, {0xcf,0xf1}, {0xfe,0xde}, {0xfe,0xdf}, {0xfe,0xe0}, {0xfe,0xe1}, {0xfe,0xe2}, {0xfe,0xe3},
    {0xfe,0xe4}, {0xfe,0xe5}, {0xfe,0xe6}, {0xfe,0xe7}, {0xfe,0xe8}, {0xfe,0xe9}, {0xfe,0xea}, {0xfe,0xeb}, {0xfe,0xec}, {0xfe,0xed},
    {0xfe,0xee}, {0xfe,0xef}, {0xfe,0xf0}, {0xfe,0xf1}, {0xfe,0xf2}, {0xfe,0xf3}, {0xfe,0xf4}, {0xfe,0xf5}, {0xfe,0xf6}, {0xfe,0xf7},
    {0xfe,0xf8}, {0xfe,0xf9}, {0xfe,0xfa}, {0xfe,0xfb}, {0xfe,0xfc}, {0xfe,0xfd}, {0xfe,0xfe}, {0x8e,0x40}, {0x8e,0x41}, {0x8e,0x42},
    {0x8e,0x43}, {0x8e,0x44}, {0x8e,0x45}, {0x8e,0x46}, {0x8e,0x47}, {0x8e,0x48}, {0x8e,0x49}, {0x8e,0x4a}, {0x8e,0x4b}, {0x8e,0x4c},
    {0x8e,0x4d}, {0x8e,0x4e}, {0x8e,0x4f}, {0x8e,0x50}, {0x8e,0x51}, {0x8e,0x52}, {0x8e,0x53}, {0x8e,0x54}, {0x8e,0x55}, {0x8e,0x56},
    {0x8e,0x57}, {0x8e,0x58}, {0x8e,0x59}, {0x8e,0x5a}, {0x8e,0x5b}, {0x8e,0x5c}, {0x8e,0x5d}, {0x8e,0x5e}, {0x8e,0x5f}, {0x8e,0x60},
    {0x8e,0x61}, {0x8e,0x62}, {0x8e,0x63}, {0x8e,0x64}, {0x8e,0x65}, {0x8e,0x66}, {0x8e,0x67}, {0x8e,0x68}, {0xba,0xe6}, {0x8e,0x6a},
    {0x8e,0x6b}, {0x8e,0x6c}, {0x8e,0x6d}, {0x8e,0x6e}, {0xed,0xca}, {0x8e,0x70}, {0x8e,0x71}, {0x8e,0x72}, {0x8e,0x73}, {0x8e,0x74},
    {0x8e,0x75}, {0x8e,0x76}, {0x8e,0x77}, {0x8e,0x78}, {0x8e,0x79}, {0x8e,0x7a}, {0x8e,0x7b}, {0x8e,0x7c}, {0x8e,0x7d}, {0xa2,0x61},
    {0x8e,0xa1}, {0x8e,0xa2}, {0x8e,0xa3}, {0x8e,0xa4}, {0x8e,0xa5}, {0x8e,0xa6}, {0x8e,0xa7}, {0x8e,0xa8}, {0x8e,0xa9}, {0x8e,0xaa},
    {0xba,0xfc}, {0x8e,0xac}, {0x8e,0xad}, {0x8e,0xae}, {0x8e,0xaf}, {0x8e,0xb0}, {0x8e,0xb1}, {0x8e,0xb2}, {0x8e,0xb3}, {0xbf,0xa6},
    {0x8e,0xb5}, {0x8e,0xb6}, {0x8e,0xb7}, {0x8e,0xb8}, {0x8e,0xb9}, {0x8e,0xba}, {0x8e,0xbb}, {0x8e,0xbc}, {0x8e,0xbd}, {0x8e,0xbe},
    {0x8e,0xbf}, {0x8e,0xc0}, {0x8e,0xc1}, {0x8e,0xc2}, {0x8e,0xc3}, {0x8e,0xc4}, {0x8e,0xc5}, {0x8e,0xc6}, {0x8e,0xc7}, {0x8e,0xc8},
    {0x8e,0xc9}, {0x8e,0xca}, {0x8e,0xcb}, {0x8e,0xcc}, {0xaa,0xcc}, {0x8e,0xce}, {0x8e,0xcf}, {0xbf,0xae}, {0x8e,0xd1}, {0x8e,0xd2},
    {0x8e,0xd3}, {0x8e,0xd4}, {0x8e,0xd5}, {0x8e,0xd6}, {0x8e,0xd7}, {0x8e,0xd8}, {0x8e,0xd9}, {0x8e,0xda}, {0x8e,0xdb}, {0x8e,0xdc},
    {0x8e,0xdd}, {0x8e,0xde}, {0x8e,0xdf}, {0x8e,0xe0}, {0x8e,0xe1}, {0x8e,0xe2}, {0x8e,0xe3}, {0x8e,0xe4}, {0x8e,0xe5}, {0x8e,0xe6},
    {0x8e,0xe7}, {0x8e,0xe8}, {0x8e,0xe9}, {0x8e,0xea}, {0x8e,0xeb}, {0x8e,0xec}, {0x8e,0xed}, {0x8e,0xee}, {0x8e,0xef}, {0x8e,0xf0},
    {0x8e,0xf1}, {0x8e,0xf2}, {0x8e,0xf3}, {0x8e,0xf4}, {0x8e,0xf5}, {0x8e,0xf6}, {0x8e,0xf7}, {0x8e,0xf8}, {0x8e,0xf9}, {0x8e,0xfa},
    {0x8e,0xfb}, {0x8e,0xfc}, {0x8e,0xfd}, {0x8e,0xfe}, {0x8f,0x40}, {0x8f,0x41}, {0x8f,0x42}, {0x8f,0x43}, {0x8f,0x44}, {0x8f,0x45},
    {0x8f,0x46}, {0x8f,0x47}, {0x8f,0x48}, {0x8f,0x49}, {0x8f,0x4a}, {0x8f,0x4b}, {0x8f,0x4c}, {0x8f,0x4d}, {0x8f,0x4e}, {0x8f,0x4f},
    {0x8f,0x50}, {0x8f,0x51}, {0x8f,0x52}, {0x8f,0x53}, {0x8f,0x54}, {0x8f,0x55}, {0x8f,0x56}, {0xb5,0xd7}, {0x8f,0x58}, {0x8f,0x59},
    {0x8f,0x5a}, {0x8f,0x5b}, {0x8f,0x5c}, {0x8f,0x5d}, {0x8f,0x5e}, {0x8f,0x5f}, {0x8f,0x60}, {0x8f,0x61}, {0x8f,0x62}, {0x8f,0x63},
    {0x8f,0x64}, {0x8f,0x65}, {0x8f,0x66}, {0x8f,0x67}, {0x8f,0x68}, {0xe3,0xc8}, {0x8f,0x6a}, {0x8f,0x6b}, {0x8f,0x6c}, {0x8f,0x6d},
    {0xdb,0x79}, {0x8f,0x6f}, {0x8f,0x70}, {0x8f,0x71}, {0x8f,0x72}, {0x8f,0x73}, {0x8f,0x74}, {0x8f,0x75}, {0x8f,0x76}, {0x8f,0x77},
    {0x8f,0x78}, {0x8f,0x79}, {0x8f,0x7a}, {0x8f,0x7b}, {0x8f,0x7c}, {0x8f,0x7d}, {0x8f,0x7e}, {0x8f,0xa1}, {0x8f,0xa2}, {0x8f,0xa3},
    {0x8f,0xa4}, {0x8f,0xa5}, {0x8f,0xa6}, {0x8f,0xa7}, {0x8f,0xa8}, {0x8f,0xa9}, {0x8f,0xaa}, {0x8f,0xab}, {0x8f,0xac}, {0x8f,0xad},
    {0x8f,0xae}, {0x8f,0xaf}, {0x8f,0xb0}, {0x8f,0xb1}, {0x8f,0xb2}, {0x8f,0xb3}, {0x8f,0xb4}, {0x8f,0xb5}, {0x8f,0xb6}, {0x8f,0xb7},
    {0x8f,0xb8}, {0x8f,0xb9}, {0x8f,0xba}, {0x8f,0xbb}, {0x8f,0xbc}, {0x8f,0xbd}, {0x8f,0xbe}, {0x8f,0xbf}, {0x8f,0xc0}, {0x8f,0xc1},
    {0x8f,0xc2}, {0x8f,0xc3}, {0x8f,0xc4}, {0x8f,0xc5}, {0x8f,0xc6}, {0x8f,0xc7}, {0x8f,0xc8}, {0x8f,0xc9}, {0x8f,0xca}, {0xbf,0xcc},
    {0xa0,0xd4}, {0x8f,0xcd}, {0x8f,0xce}, {0x8f,0xcf}, {0x8f,0xd0}, {0x8f,0xd1}, {0x8f,0xd2}, {0x8f,0xd3}, {0x8f,0xd4}, {0x8f,0xd5},
    {0x8f,0xd6}, {0x8f,0xd7}, {0x8f,0xd8}, {0x8f,0xd9}, {0x8f,0xda}, {0x8f,0xdb}, {0x8f,0xdc}, {0x8f,0xdd}, {0x8f,0xde}, {0x8f,0xdf},
    {0x8f,0xe0}, {0x8f,0xe1}, {0x8f,0xe2}, {0x8f,0xe3}, {0x8f,0xe4}, {0x8f,0xe5}, {0x8f,0xe6}, {0x8f,0xe7}, {0x8f,0xe8}, {0x8f,0xe9},
    {0x8f,0xea}, {0x8f,0xeb}, {0x8f,0xec}, {0x8f,0xed}, {0x8f,0xee}, {0x8f,0xef}, {0x8f,0xf0}, {0x8f,0xf1}, {0x8f,0xf2}, {0x8f,0xf3},
    {0x8f,0xf4}, {0x8f,0xf5}, {0x8f,0xf6}, {0x8f,0xf7}, {0x8f,0xf8}, {0x8f,0xf9}, {0x8f,0xfa}, {0x8f,0xfb}, {0x8f,0xfc}, {0x8f,0xfd},
    {0xb0,0x5f}, {0x90,0x40}, {0x90,0x41}, {0x90,0x42}, {0x90,0x43}, {0x90,0x44}, {0x90,0x45}, {0x90,0x46}, {0x90,0x47}, {0x90,0x48},
    {0x90,0x49}, {0x90,0x4a}, {0x90,0x4b}, {0x90,0x4c}, {0x90,0x4d}, {0x90,0x4e}, {0x90,0x4f}, {0x90,0x50}, {0x90,0x51}, {0x90,0x52},
    {0x90,0x53}, {0x90,0x54}, {0x90,0x55}, {0x90,0x56}, {0x90,0x57}, {0x90,0x58}, {0x90,0x59}, {0x90,0x5a}, {0x90,0x5b}, {0x90,0x5c},
    {0x90,0x5d}, {0x90,0x5e}, {0x90,0x5f}, {0x90,0x60}, {0x90,0x61}, {0x90,0x62}, {0x90,0x63}, {0x90,0x64}, {0x90,0x65}, {0x90,0x66},
    {0x90,0x67}, {0x90,0x68}, {0x90,0x69}, {0x90,0x6a}, {0x90,0x6b}, {0x90,0x6c}, {0xb3,0xa3}, {0x90,0x6e}, {0x90,0x6f}, {0x90,0x70},
    {0x90,0x71}, {0x90,0x72}, {0x90,0x73}, {0x90,0x74}, {0x90,0x75}, {0x90,0x76}, {0x90,0x77}, {0x90,0x78}, {0x90,0x79}, {0xf9,0xd7},
    {0x90,0x7b}, {0x90,0x7c}, {0x90,0x7d}, {0x90,0x7e}, {0x90,0xa1}, {0x90,0xa2}, {0x90,0xa3}, {0x90,0xa4}, {0x90,0xa5}, {0x90,0xa6},
    {0x90,0xa7}, {0x90,0xa8}, {0x90,0xa9}, {0x90,0xaa}, {0x90,0xab}, {0x90,0xac}, {0x90,0xad}, {0x90,0xae}, {0x90,0xaf}, {0x90,0xb0},
    {0x90,0xb1}, {0x90,0xb2}, {0x90,0xb3}, {0x90,0xb4}, {0x90,0xb5}, {0x90,0xb6}, {0x90,0xb7}, {0x90,0xb8}, {0x90,0xb9}, {0x90,0xba},
    {0x90,0xbb}, {0x90,0xbc}, {0x90,0xbd}, {0x90,0xbe}, {0x90,0xbf}, {0x90,0xc0}, {0x90,0xc1}, {0x90,0xc2}, {0x90,0xc3}, {0x90,0xc4},
    {0x90,0xc5}, {0x90,0xc6}, {0x90,0xc7}, {0x90,0xc8}, {0x90,0xc9}, {0x90,0xca}, {0x90,0xcb}, {0x90,0xcc}, {0x90,0xcd}, {0x90,0xce},
    {0x90,0xcf}, {0x90,0xd0}, {0x90,0xd1}, {0x90,0xd2}, {0x90,0xd3}, {0x90,0xd4}, {0x90,0xd5}, {0x90,0xd6}, {0x90,0xd7}, {0x90,0xd8},
    {0x90,0xd9}, {0x90,0xda}, {0x90,0xdb}, {0xc0,0x52}, {0x90,0xdd}, {0x90,0xde}, {0x90,0xdf}, {0x90,0xe0}, {0x90,0xe1}, {0x90,0xe2},
    {0x90,0xe3}, {0x90,0xe4}, {0x90,0xe5}, {0x90,0xe6}, {0x90,0xe7}, {0x90,0xe8}, {0x90,0xe9}, {0x90,0xea}, {0x90,0xeb}, {0x90,0xec},
    {0x90,0xed}, {0x90,0xee}, {0x90,0xef}, {0x90,0xf0}, {0xc5,0x54}, {0x90,0xf2}, {0x90,0xf3}, {0x90,0xf4}, {0x90,0xf5}, {0x90,0xf6},
    {0x90,0xf7}, {0x90,0xf8}, {0x90,0xf9}, {0x90,0xfa}, {0x90,0xfb}, {0x90,0xfc}, {0x90,0xfd}, {0x90,0xfe}, {0x91,0x40}, {0x91,0x41},
    {0x91,0x42}, {0x91,0x43}, {0x91,0x44}, {0x91,0x45}, {0x91,0x46}, {0x91,0x47}, {0x91,0x48}, {0x91,0x49}, {0x91,0x4a}, {0x91,0x4b},
    {0x91,0x4c}, {0x91,0x4d}, {0x91,0x4e}, {0x91,0x4f}, {0x91,0x50}, {0x91,0x51}, {0x91,0x52}, {0x91,0x53}, {0x91,0x54}, {0x91,0x55},
    {0x91,0x56}, {0x91,0x57}, {0x91,0x58}, {0x91,0x59}, {0x91,0x5a}, {0x91,0x5b}, {0x91,0x5c}, {0x91,0x5d}, {0x91,0x5e}, {0x91,0x5f},
    {0x91,0x60}, {0x91,0x61}, {0x91,0x62}, {0x91,0x63}, {0x91,0x64}, {0x91,0x65}, {0x91,0x66}, {0x91,0x67}, {0x91,0x68}, {0x91,0x69},
    {0x91,0x6a}, {0x91,0x6b}, {0x91,0x6c}, {0x91,0x6d}, {0x91,0x6e}, {0x91,0x6f}, {0x91,0x70}, {0x91,0x71}, {0x91,0x72}, {0x91,0x73},
    {0x91,0x74}, {0x91,0x75}, {0x91,0x76}, {0x91,0x77}, {0x91,0x78}, {0x91,0x79}, {0x91,0x7a}, {0x91,0x7b}, {0x91,0x7c}, {0x91,0x7d},
    {0x91,0x7e}, {0x91,0xa1}, {0x91,0xa2}, {0x91,0xa3}, {0x91,0xa4}, {0x91,0xa5}, {0x91,0xa6}, {0x91,0xa7}, {0x91,0xa8}, {0x91,0xa9},
    {0x91,0xaa}, {0x91,0xab}, {0x91,0xac}, {0x91,0xad}, {0x91,0xae}, {0x91,0xaf}, {0x91,0xb0}, {0x91,0xb1}, {0x91,0xb2}, {0x91,0xb3},
    {0x91,0xb4}, {0x91,0xb5}, {0x91,0xb6}, {0x91,0xb7}, {0x91,0xb8}, {0x91,0xb9}, {0x91,0xba}, {0x91,0xbb}, {0x91,0xbc}, {0x91,0xbd},
    {0x91,0xbe}, {0xf1,0xe3}, {0x91,0xc0}, {0x91,0xc1}, {0x91,0xc2}, {0x91,0xc3}, {0x91,0xc4}, {0x91,0xc5}, {0x91,0xc6}, {0x91,0xc7},
    {0x91,0xc8}, {0x91,0xc9}, {0x91,0xca}, {0x91,0xcb}, {0x91,0xcc}, {0x91,0xcd}, {0x91,0xce}, {0x91,0xcf}, {0x91,0xd0}, {0x91,0xd1},
    {0x91,0xd2}, {0x91,0xd3}, {0x91,0xd4}, {0x91,0xd5}, {0x91,0xd6}, {0x91,0xd7}, {0x91,0xd8}, {0x91,0xd9}, {0x91,0xda}, {0x91,0xdb},
    {0x91,0xdc}, {0x91,0xdd}, {0x91,0xde}, {0x91,0xdf}, {0x91,0xe0}, {0x91,0xe1}, {0x91,0xe2}, {0x91,0xe3}, {0x91,0xe4}, {0x91,0xe5},
    {0x91,0xe6}, {0x91,0xe7}, {0x91,0xe8}, {0x91,0xe9}, {0x91,0xea}, {0x91,0xeb}, {0x91,0xec}, {0x91,0xed}, {0x91,0xee}, {0x91,0xef},
    {0x91,0xf0}, {0x91,0xf1}, {0x91,0xf2}, {0x91,0xf3}, {0x91,0xf4}, {0x91,0xf5}, {0x91,0xf6}, {0x91,0xf7}, {0x91,0xf8}, {0x91,0xf9},
    {0x91,0xfa}, {0x91,0xfb}, {0x91,0xfc}, {0x91,0xfd}, {0x91,0xfe}, {0x92,0x40}, {0x92,0x41}, {0x92,0x42}, {0x92,0x43}, {0x92,0x42},
    {0x92,0x45}, {0x92,0x46}, {0x92,0x47}, {0x92,0x48}, {0x92,0x49}, {0x92,0x4a}, {0x92,0x4b}, {0x92,0x4c}, {0x92,0x4d}, {0x92,0x4e},
    {0x92,0x4f}, {0x92,0x50}, {0x92,0x51}, {0x92,0x52}, {0x92,0x53}, {0x92,0x54}, {0x92,0x55}, {0x92,0x56}, {0x92,0x57}, {0x92,0x58},
    {0x92,0x59}, {0x92,0x5a}, {0x92,0x5b}, {0x92,0x5c}, {0x92,0x5d}, {0x92,0x5e}, {0x92,0x5f}, {0x92,0x60}, {0x92,0x61}, {0x92,0x62},
    {0x92,0x63}, {0x92,0x64}, {0x92,0x65}, {0x92,0x66}, {0x92,0x67}, {0x92,0x68}, {0x92,0x69}, {0x92,0x6a}, {0x92,0x6b}, {0x92,0x6c},
    {0x92,0x6d}, {0x92,0x6e}, {0x92,0x6f}, {0x92,0x70}, {0x92,0x71}, {0x92,0x72}, {0x92,0x73}, {0x92,0x74}, {0x92,0x75}, {0x92,0x76},
    {0x92,0x77}, {0x92,0x78}, {0x92,0x79}, {0x92,0x7a}, {0x92,0x7b}, {0x92,0x7c}, {0x92,0x7d}, {0x92,0x7e}, {0x92,0xa1}, {0x92,0xa2},
    {0x92,0xa3}, {0x92,0xa4}, {0x92,0xa5}, {0x92,0xa6}, {0x92,0xa7}, {0x92,0xa8}, {0x92,0xa9}, {0x92,0xaa}, {0x92,0xab}, {0x92,0xac},
    {0x92,0xad}, {0x92,0xae}, {0xa2,0x59}, {0xa2,0x5a}, {0xa2,0x5c}, {0xa2,0x5b}, {0x92,0xb3}, {0x92,0xb4}, {0x92,0xb5}, {0x92,0xb6},
    {0x92,0xb7}, {0x92,0xb8}, {0x92,0xb9}, {0x92,0xba}, {0x92,0xbb}, {0x92,0xbc}, {0x92,0xbd}, {0x92,0xbe}, {0x92,0xbf}, {0x92,0xc0},
    {0x92,0xc1}, {0x92,0xc2}, {0x92,0xc3}, {0x92,0xc4}, {0x92,0xc5}, {0x92,0xc6}, {0x92,0xc7}, {0xa0,0x5f}, {0x92,0xc9}, {0x92,0xca},
    {0x92,0xcb}, {0x92,0xcc}, {0x92,0xcd}, {0x92,0xce}, {0x92,0xcf}, {0x92,0xd0}, {0xe6,0xab}, {0x92,0xd2}, {0x92,0xd3}, {0x92,0xd4},
    {0x92,0xd5}, {0x92,0xd6}, {0x92,0xd7}, {0x92,0xd8}, {0x92,0xd9}, {0x92,0xda}, {0x92,0xdb}, {0x92,0xdc}, {0x92,0xdd}, {0x92,0xde},
    {0x92,0xdf}, {0x92,0xe0}, {0x92,0xe1}, {0x92,0xe2}, {0x92,0xe3}, {0x92,0xe4}, {0x92,0xe5}, {0x92,0xe6}, {0x92,0xe7}, {0x92,0xe8},
    {0x92,0xe9}, {0x92,0xea}, {0x92,0xeb}, {0x92,0xec}, {0x92,0xed}, {0x92,0xee}, {0x92,0xef}, {0x92,0xf0}, {0x92,0xf1}, {0x92,0xf2},
    {0x92,0xf3}, {0x92,0xf4}, {0x92,0xf5}, {0x92,0xf6}, {0x92,0xf7}, {0x92,0xf8}, {0x92,0xf9}, {0x92,0xfa}, {0x92,0xfb}, {0x92,0xfc},
    {0x92,0xfd}, {0x92,0xfe}, {0x93,0x40}, {0x93,0x41}, {0x93,0x42}, {0x93,0x43}, {0x93,0x44}, {0x93,0x45}, {0x93,0x46}, {0x93,0x47},
    {0x93,0x48}, {0x93,0x49}, {0x93,0x4a}, {0x93,0x4b}, {0x93,0x4c}, {0x93,0x4d}, {0x93,0x4e}, {0x93,0x4f}, {0x93,0x50}, {0x93,0x51},
    {0x93,0x52}, {0x93,0x53}, {0x93,0x54}, {0x93,0x55}, {0x93,0x56}, {0x93,0x57}, {0x93,0x58}, {0x93,0x59}, {0x93,0x5a}, {0x93,0x5b},
    {0x93,0x5c}, {0x93,0x5d}, {0x93,0x5e}, {0x93,0x5f}, {0x93,0x60}, {0x93,0x61}, {0x93,0x62}, {0x93,0x63}, {0x93,0x64}, {0x93,0x65},
    {0x93,0x66}, {0x93,0x67}, {0x93,0x68}, {0x93,0x69}, {0x93,0x6a}, {0x93,0x6b}, {0x93,0x6c}, {0x93,0x6d}, {0x93,0x6e}, {0x93,0x6f},
    {0x93,0x70}, {0x93,0x71}, {0x93,0x72}, {0x93,0x73}, {0x93,0x74}, {0x93,0x75}, {0x93,0x76}, {0x93,0x77}, {0x93,0x78}, {0x93,0x79},
    {0x93,0x7a}, {0x93,0x7b}, {0x93,0x7c}, {0x93,0x7d}, {0x93,0x7e}, {0x93,0xa1}, {0x93,0xa2}, {0x93,0xa3}, {0x93,0xa4}, {0x93,0xa5},
    {0x93,0xa6}, {0x93,0xa7}, {0x93,0xa8}, {0x93,0xa9}, {0x93,0xaa}, {0x93,0xab}, {0x93,0xac}, {0x93,0xad}, {0x93,0xae}, {0x93,0xaf},
    {0x93,0xb0}, {0x93,0xb1}, {0x93,0xb2}, {0x93,0xb3}, {0x93,0xb4}, {0x93,0xb5}, {0x93,0xb6}, {0x93,0xb7}, {0x93,0xb8}, {0x93,0xb9},
    {0x93,0xba}, {0x93,0xbb}, {0x93,0xbc}, {0x93,0xbd}, {0x93,0xbe}, {0x93,0xbf}, {0x93,0xc0}, {0x93,0xc1}, {0x93,0xc2}, {0x93,0xc3},
    {0x93,0xc4}, {0x93,0xc5}, {0x93,0xc6}, {0x93,0xc7}, {0x93,0xc8}, {0x93,0xc9}, {0x93,0xca}, {0x93,0xcb}, {0x93,0xcc}, {0x93,0xcd},
    {0x93,0xce}, {0x93,0xcf}, {0x93,0xd0}, {0x93,0xd1}, {0x93,0xd2}, {0x93,0xd3}, {0x93,0xd4}, {0x93,0xd5}, {0x93,0xd6}, {0x93,0xd7},
    {0x93,0xd8}, {0x93,0xd9}, {0x93,0xda}, {0x93,0xdb}, {0x93,0xdc}, {0x93,0xdd}, {0x93,0xde}, {0x93,0xdf}, {0x93,0xe0}, {0x93,0xe1},
    {0x93,0xe2}, {0x93,0xe3}, {0x93,0xe4}, {0x93,0xe5}, {0x93,0xe6}, {0x93,0xe7}, {0x93,0xe8}, {0x93,0xe9}, {0x93,0xea}, {0x93,0xeb},
    {0x93,0xec}, {0x93,0xed}, {0x93,0xee}, {0x93,0xef}, {0x93,0xf0}, {0x93,0xf1}, {0x93,0xf2}, {0x93,0xf3}, {0x93,0xf4}, {0x93,0xf5},
    {0x93,0xf6}, {0x93,0xf7}, {0x93,0xf8}, {0x93,0xf9}, {0x93,0xfa}, {0x93,0xfb}, {0x93,0xfc}, {0x93,0xfd}, {0x93,0xfe}, {0x94,0x40},
    {0x94,0x41}, {0x94,0x42}, {0x94,0x43}, {0x94,0x44}, {0x94,0x45}, {0x94,0x46}, {0xd2,0x56}, {0x94,0x48}, {0x94,0x49}, {0x94,0x4a},
    {0x94,0x4b}, {0x94,0x4c}, {0x94,0x4d}, {0x94,0x4e}, {0x94,0x4f}, {0x94,0x50}, {0x94,0x51}, {0x94,0x52}, {0x94,0x53}, {0x94,0x54},
    {0x94,0x55}, {0x94,0x56}, {0x94,0x57}, {0x94,0x58}, {0x94,0x59}, {0x94,0x5a}, {0x94,0x5b}, {0x94,0x5c}, {0x94,0x5d}, {0x94,0x5e},
    {0x94,0x5f}, {0x94,0x60}, {0x94,0x61}, {0x94,0x62}, {0x94,0x63}, {0x94,0x64}, {0x94,0x65}, {0x94,0x66}, {0x94,0x67}, {0x94,0x68},
    {0x94,0x69}, {0x94,0x6a}, {0x94,0x6b}, {0x94,0x6c}, {0x94,0x6d}, {0x94,0x6e}, {0x94,0x6f}, {0x94,0x70}, {0x94,0x71}, {0x94,0x72},
    {0x94,0x73}, {0x94,0x74}, {0x94,0x75}, {0x94,0x76}, {0x94,0x77}, {0x94,0x78}, {0x94,0x79}, {0x94,0x7a}, {0x94,0x7b}, {0x94,0x7c},
    {0x94,0x7d}, {0x94,0x7e}, {0x94,0xa1}, {0x94,0xa2}, {0x94,0xa3}, {0x94,0xa4}, {0x94,0xa5}, {0x94,0xa6}, {0x94,0xa7}, {0x94,0xa8},
    {0x94,0xa9}, {0x94,0xaa}, {0x94,0xab}, {0x94,0xac}, {0x94,0xad}, {0x94,0xae}, {0x94,0xaf}, {0x94,0xb0}, {0x94,0xb1}, {0x94,0xb2},
    {0x94,0xb3}, {0x94,0xb4}, {0x94,0xb5}, {0x94,0xb6}, {0x94,0xb7}, {0x94,0xb8}, {0x94,0xb9}, {0x94,0xba}, {0x94,0xbb}, {0x94,0xbc},
    {0x94,0xbd}, {0x94,0xbe}, {0x94,0xbf}, {0x94,0xc0}, {0x94,0xc1}, {0x94,0xc2}, {0x94,0xc3}, {0x94,0xc4}, {0x94,0xc5}, {0x94,0xc6},
    {0x94,0xc7}, {0x94,0xc8}, {0x94,0xc9}, {0xe6,0xd0}, {0x94,0xcb}, {0x94,0xcc}, {0x94,0xcd}, {0x94,0xce}, {0x94,0xcf}, {0x94,0xd0},
    {0x94,0xd1}, {0x94,0xd2}, {0x94,0xd3}, {0x94,0xd4}, {0x94,0xd5}, {0x94,0xd6}, {0x94,0xd7}, {0x94,0xd8}, {0x94,0xd9}, {0x94,0xda},
    {0x94,0xdb}, {0x94,0xdc}, {0x94,0xdd}, {0x94,0xde}, {0x94,0xdf}, {0x94,0xe0}, {0x94,0xe1}, {0x94,0xe2}, {0x94,0xe3}, {0x94,0xe4},
    {0x94,0xe5}, {0x94,0xe6}, {0x94,0xe7}, {0x94,0xe8}, {0x94,0xe9}, {0x94,0xea}, {0x94,0xeb}, {0x94,0xec}, {0x94,0xed}, {0x94,0xee},
    {0x94,0xef}, {0x94,0xf0}, {0x94,0xf1}, {0x94,0xf2}, {0x94,0xf3}, {0x94,0xf4}, {0x94,0xf5}, {0x94,0xf6}, {0x94,0xf7}, {0x94,0xf8},
    {0x94,0xf9}, {0x94,0xfa}, {0x94,0xfb}, {0x94,0xfc}, {0x94,0xfd}, {0x94,0xfe}, {0x95,0x40}, {0x95,0x41}, {0x95,0x42}, {0x95,0x43},
    {0x95,0x44}, {0x95,0x45}, {0x95,0x46}, {0x95,0x47}, {0x95,0x48}, {0x95,0x49}, {0x95,0x4a}, {0x95,0x4b}, {0x95,0x4c}, {0x95,0x4d},
    {0x95,0x4e}, {0x95,0x4f}, {0x95,0x50}, {0x95,0x51}, {0x95,0x52}, {0x95,0x53}, {0x95,0x54}, {0x95,0x55}, {0x95,0x56}, {0x95,0x57},
    {0x95,0x58}, {0x95,0x59}, {0x95,0x5a}, {0x95,0x5b}, {0x95,0x5c}, {0x95,0x5d}, {0x95,0x5e}, {0x95,0x5f}, {0x95,0x60}, {0x95,0x61},
    {0x95,0x62}, {0x95,0x63}, {0x95,0x64}, {0x95,0x65}, {0x95,0x66}, {0x95,0x67}, {0x95,0x68}, {0x95,0x69}, {0x95,0x6a}, {0x95,0x6b},
    {0x95,0x6c}, {0x95,0x6d}, {0x95,0x6e}, {0x95,0x6f}, {0x95,0x70}, {0x95,0x71}, {0x95,0x72}, {0x95,0x73}, {0x95,0x74}, {0x95,0x75},
    {0x95,0x76}, {0x95,0x77}, {0x95,0x78}, {0x95,0x79}, {0x95,0x7a}, {0x95,0x7b}, {0x95,0x7c}, {0x95,0x7d}, {0x95,0x7e}, {0x95,0xa1},
    {0x95,0xa2}, {0x95,0xa3}, {0x95,0xa4}, {0x95,0xa5}, {0x95,0xa6}, {0x95,0xa7}, {0x95,0xa8}, {0x95,0xa9}, {0x95,0xaa}, {0x95,0xab},
    {0x95,0xac}, {0x95,0xad}, {0x95,0xae}, {0x95,0xaf}, {0x95,0xb0}, {0x95,0xb1}, {0x95,0xb2}, {0x95,0xb3}, {0x95,0xb4}, {0x95,0xb5},
    {0x95,0xb6}, {0x95,0xb7}, {0x95,0xb8}, {0x95,0xb9}, {0x95,0xba}, {0x95,0xbb}, {0x95,0xbc}, {0x95,0xbd}, {0x95,0xbe}, {0x95,0xbf},
    {0x95,0xc0}, {0x95,0xc1}, {0x95,0xc2}, {0x95,0xc3}, {0x95,0xc4}, {0x95,0xc5}, {0x95,0xc6}, {0x95,0xc7}, {0x95,0xc8}, {0x95,0xc9},
    {0x95,0xca}, {0x95,0xcb}, {0x95,0xcc}, {0x95,0xcd}, {0x95,0xce}, {0x95,0xcf}, {0x95,0xd0}, {0x95,0xd1}, {0x95,0xd2}, {0x95,0xd3},
    {0x95,0xd4}, {0x95,0xd5}, {0x95,0xd6}, {0x95,0xd7}, {0x95,0xd8}, {0xca,0x52}, {0x95,0xda}, {0x95,0xdb}, {0x95,0xdc}, {0x95,0xdd},
    {0x95,0xde}, {0x95,0xdf}, {0x95,0xe0}, {0x95,0xe1}, {0x95,0xe2}, {0x95,0xe3}, {0x95,0xe4}, {0x95,0xe5}, {0x95,0xe6}, {0x95,0xe7},
    {0x95,0xe8}, {0x95,0xe9}, {0x95,0xea}, {0x95,0xeb}, {0x95,0xec}, {0x95,0xed}, {0x95,0xee}, {0x95,0xef}, {0x95,0xf0}, {0x95,0xf1},
    {0x95,0xf2}, {0x95,0xf3}, {0x95,0xf4}, {0x95,0xf5}, {0x95,0xf6}, {0x95,0xf7}, {0x95,0xf8}, {0x95,0xf9}, {0x95,0xfa}, {0x95,0xfb},
    {0x95,0xfc}, {0x95,0xfd}, {0x95,0xfe}, {0x96,0x40}, {0x96,0x41}, {0x96,0x42}, {0x96,0x43}, {0x9c,0xe4}, {0x96,0x45}, {0x96,0x46},
    {0x96,0x47}, {0x96,0x48}, {0x96,0x49}, {0x96,0x4a}, {0x96,0x4b}, {0x96,0x4c}, {0x96,0x4d}, {0x96,0x4e}, {0x96,0x4f}, {0x96,0x50},
    {0x96,0x51}, {0x96,0x52}, {0x96,0x53}, {0x96,0x54}, {0x96,0x55}, {0x96,0x56}, {0x96,0x57}, {0x96,0x58}, {0x96,0x59}, {0x96,0x5a},
    {0x96,0x5b}, {0x96,0x5c}, {0x96,0x5d}, {0x96,0x5e}, {0x96,0x5f}, {0x96,0x60}, {0x96,0x61}, {0x96,0x62}, {0x96,0x63}, {0x96,0x64},
    {0x96,0x65}, {0x96,0x66}, {0x96,0x67}, {0x96,0x68}, {0x96,0x69}, {0x96,0x6a}, {0x96,0x6b}, {0x96,0x6c}, {0x96,0x6d}, {0x96,0x6e},
    {0x96,0x6f}, {0x96,0x70}, {0x96,0x71}, {0x96,0x72}, {0x96,0x73}, {0x96,0x74}, {0x96,0x75}, {0x96,0x76}, {0x96,0x77}, {0x96,0x78},
    {0x96,0x79}, {0x96,0x7a}, {0x96,0x7b}, {0x96,0x7c}, {0x96,0x7d}, {0x96,0x7e}, {0x96,0xa1}, {0x96,0xa2}, {0x96,0xa3}, {0x96,0xa4},
    {0x96,0xa5}, {0x96,0xa6}, {0x96,0xa7}, {0x96,0xa8}, {0x96,0xa9}, {0x96,0xaa}, {0x96,0xab}, {0x96,0xac}, {0x96,0xad}, {0x96,0xae},
    {0x96,0xaf}, {0x96,0xb0}, {0x96,0xb1}, {0x96,0xb2}, {0x96,0xb3}, {0x96,0xb4}, {0x96,0xb5}, {0x96,0xb6}, {0x96,0xb7}, {0x96,0xb8},
    {0x96,0xb9}, {0x96,0xba}, {0x96,0xbb}, {0x96,0xbc}, {0x96,0xbd}, {0x96,0xbe}, {0x96,0xbf}, {0x96,0xc0}, {0x96,0xc1}, {0x96,0xc2},
    {0x96,0xc3}, {0x96,0xc4}, {0x96,0xc5}, {0x96,0xc6}, {0x96,0xc7}, {0x96,0xc8}, {0x96,0xc9}, {0x96,0xca}, {0x96,0xcb}, {0x96,0xcc},
    {0x96,0xcd}, {0x96,0xce}, {0x96,0xcf}, {0x96,0xd0}, {0x96,0xd1}, {0x96,0xd2}, {0x96,0xd3}, {0x96,0xd4}, {0x96,0xd5}, {0x96,0xd6},
    {0x96,0xd7}, {0x96,0xd8}, {0x96,0xd9}, {0x96,0xda}, {0x96,0xdb}, {0x96,0xdc}, {0x96,0xdd}, {0x96,0xde}, {0x96,0xdf}, {0x96,0xe0},
    {0x96,0xe1}, {0x96,0xe2}, {0x96,0xe3}, {0x96,0xe4}, {0x96,0xe5}, {0x96,0xe6}, {0x96,0xe7}, {0x96,0xe8}, {0x96,0xe9}, {0x96,0xea},
    {0x96,0xeb}, {0x96,0xec}, {0x96,0xee}, {0x96,0xee}, {0x96,0xef}, {0x96,0xf0}, {0x96,0xf1}, {0x96,0xf2}, {0x96,0xf3}, {0x96,0xf4},
    {0x96,0xf5}, {0x96,0xf6}, {0x96,0xf7}, {0x96,0xf8}, {0x96,0xf9}, {0x96,0xfa}, {0x96,0xfb}, {0xe9,0x59}, {0x96,0xfd}, {0x96,0xfe},
    {0x97,0x40}, {0x97,0x41}, {0x97,0x42}, {0x97,0x43}, {0x97,0x44}, {0x97,0x45}, {0x97,0x46}, {0x97,0x47}, {0x97,0x48}, {0x97,0x49},
    {0x97,0x4a}, {0x97,0x4b}, {0x97,0x4c}, {0x97,0x4d}, {0x97,0x4e}, {0x97,0x4f}, {0x97,0x50}, {0x97,0x51}, {0x97,0x52}, {0x97,0x53},
    {0x97,0x54}, {0x97,0x55}, {0x97,0x56}, {0x97,0x57}, {0x97,0x58}, {0x97,0x59}, {0x97,0x5a}, {0x97,0x5b}, {0x97,0x5c}, {0x97,0x5d},
    {0x97,0x5e}, {0x97,0x5f}, {0x97,0x60}, {0x97,0x61}, {0x97,0x62}, {0x97,0x63}, {0x97,0x64}, {0x97,0x65}, {0x97,0x66}, {0x97,0x67},
    {0x97,0x68}, {0x97,0x69}, {0x97,0x6a}, {0x97,0x6b}, {0x97,0x6c}, {0x97,0x6d}, {0x97,0x6e}, {0x97,0x6f}, {0x97,0x70}, {0x97,0x71},
    {0x97,0x72}, {0x97,0x73}, {0x97,0x74}, {0x97,0x75}, {0x97,0x76}, {0x97,0x77}, {0x97,0x78}, {0x97,0x79}, {0x97,0x7a}, {0x97,0x7b},
    {0x97,0x7c}, {0x97,0x7d}, {0x97,0x7e}, {0x97,0xa1}, {0x97,0xa2}, {0x97,0xa3}, {0x97,0xa4}, {0x97,0xa5}, {0x97,0xa6}, {0x97,0xa7},
    {0x97,0xa8}, {0x97,0xa9}, {0x97,0xaa}, {0x97,0xab}, {0x97,0xac}, {0x97,0xad}, {0x97,0xae}, {0x97,0xaf}, {0x97,0xb0}, {0x97,0xb1},
    {0x97,0xb2}, {0x97,0xb3}, {0x97,0xb4}, {0x97,0xb5}, {0x97,0xb6}, {0x97,0xb7}, {0x97,0xb8}, {0x97,0xb9}, {0x97,0xba}, {0x97,0xbb},
    {0x97,0xbc}, {0x97,0xbd}, {0x97,0xbe}, {0x97,0xbf}, {0x97,0xc0}, {0x97,0xc1}, {0x97,0xc2}, {0x97,0xc3}, {0x97,0xc4}, {0x97,0xc5},
    {0x97,0xc6}, {0x97,0xc7}, {0x97,0xc8}, {0x97,0xc9}, {0x97,0xca}, {0x97,0xcb}, {0x97,0xcc}, {0x97,0xcd}, {0x97,0xce}, {0x97,0xcf},
    {0x97,0xd0}, {0x97,0xd1}, {0x97,0xd2}, {0x97,0xd3}, {0x97,0xd4}, {0x97,0xd5}, {0x97,0xd6}, {0x97,0xd7}, {0x97,0xd8}, {0x97,0xd9},
    {0x97,0xda}, {0x97,0xdb}, {0x97,0xdc}, {0x97,0xdd}, {0x97,0xde}, {0x97,0xdf}, {0x97,0xe0}, {0x97,0xe1}, {0x97,0xe2}, {0x97,0xe3},
    {0x97,0xe4}, {0x97,0xe5}, {0x97,0xe6}, {0x97,0xe7}, {0x97,0xe8}, {0x97,0xe9}, {0x97,0xea}, {0x97,0xeb}, {0x97,0xec}, {0x97,0xed},
    {0x97,0xee}, {0x97,0xef}, {0x97,0xf0}, {0x97,0xf1}, {0x97,0xf2}, {0x97,0xf3}, {0x97,0xf4}, {0x97,0xf5}, {0x97,0xf6}, {0x97,0xf7},
    {0x97,0xf8}, {0x97,0xf9}, {0x97,0xfa}, {0x97,0xfb}, {0x97,0xfc}, {0x97,0xfd}, {0x97,0xfe}, {0x98,0x40}, {0x98,0x41}, {0x98,0x42},
    {0x98,0x43}, {0x98,0x44}, {0x98,0x45}, {0x98,0x46}, {0x98,0x47}, {0x98,0x48}, {0x98,0x49}, {0x98,0x4a}, {0x98,0x4b}, {0x98,0x4c},
    {0x98,0x4d}, {0x98,0x4e}, {0x98,0x4f}, {0x98,0x50}, {0x98,0x51}, {0x98,0x52}, {0x98,0x53}, {0x98,0x54}, {0x98,0x55}, {0x98,0x56},
    {0x98,0x57}, {0x98,0x58}, {0x98,0x59}, {0x98,0x5a}, {0x98,0x5b}, {0x98,0x5c}, {0x98,0x5d}, {0x98,0x5e}, {0x98,0x5f}, {0x98,0x60},
    {0x98,0x61}, {0x98,0x62}, {0x98,0x63}, {0x98,0x64}, {0x98,0x65}, {0x98,0x66}, {0x98,0x67}, {0x98,0x68}, {0x98,0x69}, {0x98,0x6a},
    {0x98,0x6b}, {0x98,0x6c}, {0x98,0x6d}, {0x98,0x6e}, {0x98,0x6f}, {0x98,0x70}, {0x98,0x71}, {0x98,0x72}, {0x98,0x73}, {0x98,0x74},
    {0x98,0x75}, {0x98,0x76}, {0x98,0x77}, {0x98,0x78}, {0x98,0x79}, {0x98,0x7a}, {0x98,0x7b}, {0x98,0x7c}, {0x98,0x7d}, {0x98,0x7e},
    {0x98,0xa1}, {0x98,0xa2}, {0x98,0xa3}, {0x98,0xa4}, {0x98,0xa5}, {0x98,0xa6}, {0x98,0xa7}, {0x98,0xa8}, {0x98,0xa9}, {0x98,0xaa},
    {0x98,0xab}, {0x98,0xac}, {0x98,0xad}, {0x98,0xae}, {0x98,0xaf}, {0x98,0xb0}, {0x98,0xb1}, {0x98,0xb2}, {0x98,0xb3}, {0x98,0xb4},
    {0x98,0xb5}, {0x98,0xb6}, {0x98,0xb7}, {0x98,0xb8}, {0x98,0xb9}, {0x98,0xba}, {0x98,0xbb}, {0x98,0xbc}, {0x98,0xbd}, {0x98,0xbe},
    {0x98,0xbf}, {0x98,0xc0}, {0x98,0xc1}, {0x98,0xc2}, {0x98,0xc3}, {0x98,0xc4}, {0x98,0xc5}, {0x98,0xc6}, {0x98,0xc7}, {0x98,0xc8},
    {0x98,0xc9}, {0x98,0xca}, {0x98,0xcb}, {0x98,0xcc}, {0x98,0xcd}, {0x98,0xce}, {0x98,0xcf}, {0x98,0xd0}, {0x98,0xd1}, {0x98,0xd2},
    {0x98,0xd3}, {0x98,0xd4}, {0x98,0xd5}, {0x98,0xd6}, {0x98,0xd7}, {0x98,0xd8}, {0x98,0xd9}, {0x98,0xda}, {0x98,0xdb}, {0x98,0xdc},
    {0x98,0xdd}, {0x98,0xde}, {0x98,0xdf}, {0x98,0xe0}, {0x98,0xe1}, {0x98,0xe2}, {0x98,0xe3}, {0x98,0xe4}, {0x98,0xe5}, {0x98,0xe6},
    {0x98,0xe7}, {0x98,0xe8}, {0x98,0xe9}, {0x98,0xea}, {0x98,0xeb}, {0x98,0xec}, {0x98,0xed}, {0x98,0xee}, {0x98,0xef}, {0x98,0xf0},
    {0x98,0xf1}, {0x98,0xf2}, {0x98,0xf3}, {0x98,0xf4}, {0x98,0xf5}, {0x98,0xf6}, {0x98,0xf7}, {0x98,0xf8}, {0x98,0xf9}, {0x98,0xfa},
    {0x98,0xfb}, {0x98,0xfc}, {0x98,0xfd}, {0x98,0xfe}, {0x99,0x40}, {0x99,0x41}, {0x99,0x42}, {0x99,0x43}, {0x99,0x44}, {0x99,0x45},
    {0x99,0x46}, {0x99,0x47}, {0x99,0x48}, {0x99,0x49}, {0x99,0x4a}, {0x99,0x4b}, {0x99,0x4c}, {0x99,0x4d}, {0x99,0x4e}, {0x99,0x4f},
    {0x99,0x50}, {0x99,0x51}, {0x99,0x52}, {0x99,0x53}, {0x99,0x54}, {0x99,0x55}, {0x99,0x56}, {0x99,0x57}, {0x99,0x58}, {0x99,0x59},
    {0x99,0x5a}, {0x99,0x5b}, {0x99,0x5c}, {0x99,0x5d}, {0x99,0x5e}, {0x99,0x5f}, {0x99,0x60}, {0x99,0x61}, {0x99,0x62}, {0x99,0x63},
    {0x99,0x64}, {0x99,0x65}, {0x99,0x66}, {0x99,0x67}, {0x99,0x68}, {0x99,0x69}, {0x99,0x6a}, {0x99,0x6b}, {0x99,0x6c}, {0x99,0x6d},
    {0x99,0x6e}, {0x99,0x6f}, {0x99,0x70}, {0x99,0x71}, {0x99,0x72}, {0x99,0x73}, {0x99,0x74}, {0x99,0x75}, {0x99,0x76}, {0x99,0x77},
    {0x99,0x78}, {0x99,0x79}, {0x99,0x7a}, {0x99,0x7b}, {0x99,0x7c}, {0x99,0x7d}, {0x99,0x7e}, {0x99,0xa1}, {0x99,0xa2}, {0x99,0xa3},
    {0x99,0xa4}, {0x99,0xa5}, {0x99,0xa6}, {0x99,0xa7}, {0x99,0xa8}, {0x99,0xa9}, {0x99,0xaa}, {0x99,0xab}, {0x99,0xac}, {0x99,0xad},
    {0x99,0xae}, {0x99,0xaf}, {0x99,0xb0}, {0x99,0xb1}, {0x99,0xb2}, {0x99,0xb3}, {0x99,0xb4}, {0x99,0xb5}, {0x99,0xb6}, {0x99,0xb7},
    {0x99,0xb8}, {0x99,0xb9}, {0x99,0xba}, {0x99,0xbb}, {0x99,0xbc}, {0x99,0xbd}, {0x99,0xbe}, {0x99,0xbf}, {0x99,0xc0}, {0x99,0xc1},
    {0x99,0xc2}, {0x99,0xc3}, {0x99,0xc4}, {0x99,0xc5}, {0x99,0xc6}, {0x99,0xc7}, {0x99,0xc8}, {0x99,0xc9}, {0x99,0xca}, {0x99,0xcb},
    {0x99,0xcc}, {0x99,0xcd}, {0x99,0xce}, {0x99,0xcf}, {0x99,0xd0}, {0x99,0xd1}, {0x99,0xd2}, {0x99,0xd3}, {0x99,0xd4}, {0x99,0xd5},
    {0x99,0xd6}, {0x99,0xd7}, {0x99,0xd8}, {0x99,0xd9}, {0x99,0xda}, {0x99,0xdb}, {0x99,0xdc}, {0x99,0xdd}, {0x99,0xde}, {0x99,0xdf},
    {0x99,0xe0}, {0x99,0xe1}, {0x99,0xe2}, {0x99,0xe3}, {0x99,0xe4}, {0x99,0xe5}, {0x99,0xe6}, {0x99,0xe7}, {0x99,0xe8}, {0x99,0xe9},
    {0x99,0xea}, {0x99,0xeb}, {0x99,0xec}, {0x99,0xed}, {0x99,0xee}, {0x99,0xef}, {0x99,0xf0}, {0x99,0xf1}, {0x99,0xf2}, {0x99,0xf3},
    {0x99,0xf4}, {0x99,0xf5}, {0x99,0xf6}, {0x99,0xf7}, {0x99,0xf8}, {0x99,0xf9}, {0x99,0xfa}, {0x99,0xfb}, {0x99,0xfc}, {0x99,0xfd},
    {0x99,0xfe}, {0x9a,0x40}, {0x9a,0x41}, {0x9a,0x42}, {0x9a,0x43}, {0x9a,0x44}, {0x9a,0x45}, {0x9a,0x46}, {0x9a,0x47}, {0x9a,0x48},
    {0x9a,0x49}, {0x9a,0x4a}, {0x9a,0x4b}, {0x9a,0x4c}, {0x9a,0x4d}, {0x9a,0x4e}, {0x9a,0x4f}, {0x9a,0x50}, {0x9a,0x51}, {0x9a,0x52},
    {0x9a,0x53}, {0x9a,0x54}, {0x9a,0x55}, {0x9a,0x56}, {0x9a,0x57}, {0x9a,0x58}, {0x9a,0x59}, {0x9a,0x5a}, {0x9a,0x5b}, {0x9a,0x5c},
    {0x9a,0x5d}, {0x9a,0x5e}, {0x9a,0x5f}, {0x9a,0x60}, {0x9a,0x61}, {0x9a,0x62}, {0x9a,0x63}, {0x9a,0x64}, {0x9a,0x65}, {0x9a,0x66},
    {0x9a,0x67}, {0x9a,0x68}, {0x9a,0x69}, {0x9a,0x6a}, {0x9a,0x6b}, {0x9a,0x6c}, {0x9a,0x6d}, {0x9a,0x6e}, {0x9a,0x6f}, {0x9a,0x70},
    {0x9a,0x71}, {0x9a,0x72}, {0x9a,0x73}, {0x9a,0x74}, {0x9a,0x75}, {0x9a,0x76}, {0x9a,0x77}, {0x9a,0x78}, {0x9a,0x79}, {0x9a,0x7a},
    {0x9a,0x7b}, {0x9a,0x7c}, {0x9a,0x7d}, {0x9a,0x7e}, {0x9a,0xa1}, {0x9a,0xa2}, {0x9a,0xa3}, {0x9a,0xa4}, {0x9a,0xa5}, {0x9a,0xa6},
    {0x9a,0xa7}, {0x9a,0xa8}, {0x9a,0xa9}, {0x9a,0xaa}, {0x9a,0xab}, {0x9a,0xac}, {0x9a,0xad}, {0x9a,0xae}, {0x9a,0xaf}, {0x9a,0xb0},
    {0x9a,0xb1}, {0x9a,0xb2}, {0x9a,0xb3}, {0x9a,0xb4}, {0x9a,0xb5}, {0x9a,0xb6}, {0x9a,0xb7}, {0x9a,0xb8}, {0x9a,0xb9}, {0x9a,0xba},
    {0x9a,0xbb}, {0x9a,0xbc}, {0x9a,0xbd}, {0x9a,0xbe}, {0x9a,0xbf}, {0x9a,0xc0}, {0x9a,0xc1}, {0x9a,0xc2}, {0x9a,0xc3}, {0x9a,0xc4},
    {0x9a,0xc5}, {0x9a,0xc6}, {0x9a,0xc7}, {0x9a,0xc8}, {0x9a,0xc9}, {0x9a,0xca}, {0x9a,0xcb}, {0x9a,0xcc}, {0x9a,0xcd}, {0x9a,0xce},
    {0x9a,0xcf}, {0x9a,0xd0}, {0x9a,0xd1}, {0x9a,0xd2}, {0x9a,0xd3}, {0x9a,0xd4}, {0x9a,0xd5}, {0x9a,0xd6}, {0x9a,0xd7}, {0x9a,0xd8},
    {0x9a,0xd9}, {0x9a,0xda}, {0x9a,0xdb}, {0x9a,0xdc}, {0x9a,0xdd}, {0x9a,0xde}, {0x9a,0xdf}, {0x9a,0xe0}, {0x9a,0xe1}, {0x9a,0xe2},
    {0x9a,0xe3}, {0x9a,0xe4}, {0x9a,0xe5}, {0x9a,0xe6}, {0x9a,0xe7}, {0x9a,0xe8}, {0x9a,0xe9}, {0x9a,0xea}, {0x9a,0xeb}, {0x9a,0xec},
    {0x9a,0xed}, {0x9a,0xee}, {0x9a,0xef}, {0x9a,0xf0}, {0x9a,0xf1}, {0x9a,0xf2}, {0x9a,0xf3}, {0x9a,0xf4}, {0x9a,0xf5}, {0x9a,0xf6},
    {0x9a,0xf7}, {0x9a,0xf8}, {0x9a,0xf9}, {0x9a,0xfa}, {0x9a,0xfb}, {0x9a,0xfc}, {0x9a,0xfd}, {0x9a,0xfe}, {0x9b,0x40}, {0x9b,0x41},
    {0x9b,0x42}, {0x9b,0x43}, {0x9b,0x44}, {0x9b,0x45}, {0x9b,0x46}, {0x9b,0x47}, {0x9b,0x48}, {0x9b,0x49}, {0x9b,0x4a}, {0x9b,0x4b},
    {0x9b,0x4c}, {0x9b,0x4d}, {0x9b,0x4e}, {0x9b,0x4f}, {0x9b,0x50}, {0x9b,0x51}, {0x9b,0x52}, {0x9b,0x53}, {0x9b,0x54}, {0x9b,0x55},
    {0x9b,0x56}, {0x9b,0x57}, {0x9b,0x58}, {0x9b,0x59}, {0x9b,0x5a}, {0x9b,0x5b}, {0x9b,0x5c}, {0x9b,0x5d}, {0x9b,0x5e}, {0x9b,0x5f},
    {0x9b,0x60}, {0x9b,0x61}, {0x9b,0x62}, {0x9b,0x63}, {0x9b,0x64}, {0x9b,0x65}, {0x9b,0x66}, {0x9b,0x67}, {0x9b,0x68}, {0x9b,0x69},
    {0x9b,0x6a}, {0x9b,0x6b}, {0x9b,0x6c}, {0x9b,0x6d}, {0x9b,0x6e}, {0x9b,0x6f}, {0x9b,0x70}, {0x9b,0x71}, {0x9b,0x72}, {0x9b,0x73},
    {0x9b,0x74}, {0x9b,0x75}, {0xef,0xf9}, {0x9b,0x77}, {0xc5,0xf7}, {0x9b,0x79}, {0x9b,0x7a}, {0xf5,0xe8}, {0x9b,0x7c}, {0x9b,0x7d},
    {0x9b,0x7e}, {0x9b,0xa1}, {0x9b,0xa2}, {0x9b,0xa3}, {0x9b,0xa4}, {0x9b,0xa5}, {0x9b,0xa6}, {0x9b,0xa7}, {0x9b,0xa8}, {0x9b,0xa9},
    {0x9b,0xaa}, {0x9b,0xab}, {0x9b,0xac}, {0x9b,0xad}, {0x9b,0xae}, {0x9b,0xaf}, {0x9b,0xb0}, {0x9b,0xb1}, {0x9b,0xb2}, {0x9b,0xb3},
    {0x9b,0xb4}, {0x9b,0xb5}, {0x9b,0xb6}, {0x9b,0xb7}, {0x9b,0xb8}, {0x9b,0xb9}, {0x9b,0xba}, {0x9b,0xbb}, {0x9b,0xbc}, {0x9b,0xbd},
    {0x9b,0xbe}, {0x9b,0xbf}, {0x9b,0xc0}, {0x9b,0xc1}, {0x9b,0xc2}, {0x9b,0xc3}, {0x9b,0xc4}, {0x9b,0xc5}, {0xe8,0xcd}, {0x9b,0xc7},
    {0x9b,0xc8}, {0x9b,0xc9}, {0x9b,0xca}, {0x9b,0xcb}, {0x9b,0xcc}, {0x9b,0xcd}, {0x9b,0xce}, {0x9b,0xcf}, {0x9b,0xd0}, {0x9b,0xd1},
    {0x9b,0xd2}, {0x9b,0xd3}, {0x9b,0xd4}, {0x9b,0xd5}, {0x9b,0xd6}, {0x9b,0xd7}, {0x9b,0xd8}, {0x9b,0xd9}, {0x9b,0xda}, {0x9b,0xdb},
    {0x9b,0xdc}, {0x9b,0xdd}, {0xd0,0xc0}, {0x9b,0xdf}, {0x9b,0xe0}, {0x9b,0xe1}, {0x9b,0xe2}, {0x9b,0xe3}, {0x9b,0xe4}, {0x9b,0xe5},
    {0x9b,0xe6}, {0x9b,0xe7}, {0x9b,0xe8}, {0x9b,0xe9}, {0x9b,0xea}, {0x9b,0xeb}, {0xfd,0x64}, {0x9b,0xed}, {0x9b,0xee}, {0x9b,0xef},
    {0x9b,0xf0}, {0x9b,0xf1}, {0x9b,0xf2}, {0x9b,0xf3}, {0x9b,0xf4}, {0x9b,0xf5}, {0xbf,0x47}, {0x9b,0xf7}, {0x9b,0xf8}, {0x9b,0xf9},
    {0x9b,0xfa}, {0x9b,0xfb}, {0x9b,0xfc}, {0x9b,0xfd}, {0x9b,0xfe}, {0x9c,0x40}, {0x9c,0x41}, {0xeb,0xc9}, {0x9c,0x43}, {0x9c,0x44},
    {0x9c,0x45}, {0x9c,0x46}, {0x9c,0x47}, {0x9c,0x48}, {0x9c,0x49}, {0x9c,0x4a}, {0x9c,0x4b}, {0x9c,0x4c}, {0x9c,0x4d}, {0x9c,0x4e},
    {0x9c,0x4f}, {0x9c,0x50}, {0x9c,0x51}, {0x9c,0x52}, {0xcd,0xe7}, {0x9c,0x54}, {0x9c,0x55}, {0x9c,0x56}, {0x9c,0x57}, {0x9c,0x58},
    {0x9c,0x59}, {0x9c,0x5a}, {0x9c,0x5b}, {0x9c,0x5c}, {0x9c,0x5d}, {0x9c,0x5e}, {0x9c,0x5f}, {0x9c,0x60}, {0x9c,0x61}, {0xc0,0xe7},
    {0x9c,0x63}, {0x9c,0x64}, {0x9c,0x65}, {0x9c,0x66}, {0x9c,0x67}, {0xdc,0x52}, {0x9c,0x69}, {0x9c,0x6a}, {0xf8,0x6d}, {0x9c,0x6c},
    {0x9c,0x6d}, {0x9c,0x6e}, {0x9c,0x6f}, {0x9c,0x70}, {0x9c,0x71}, {0x9c,0x72}, {0x9c,0x73}, {0x9c,0x74}, {0x9c,0x75}, {0x9c,0x76},
    {0xdb,0x5d}, {0x9c,0x78}, {0x9c,0x79}, {0x9c,0x7a}, {0x9c,0x7b}, {0x9c,0x7c}, {0x9c,0x7d}, {0x9c,0x7e}, {0x9c,0xa1}, {0x9c,0xa2},
    {0x9c,0xa3}, {0x9c,0xa4}, {0x9c,0xa5}, {0x9c,0xa6}, {0x9c,0xa7}, {0x9c,0xa8}, {0x9c,0xa9}, {0x9c,0xaa}, {0x9c,0xab}, {0x9c,0xac},
    {0x9c,0xad}, {0x9c,0xae}, {0x9c,0xaf}, {0x9c,0xb0}, {0x9c,0xb1}, {0x9c,0xb2}, {0x9c,0xb3}, {0x9c,0xb4}, {0x9c,0xb5}, {0x9c,0xb6},
    {0x9c,0xb7}, {0x9c,0xb8}, {0x9c,0xb9}, {0x9c,0xba}, {0x9c,0xbb}, {0xc9,0x5c}, {0xaf,0xb0}, {0x9c,0xbe}, {0x9c,0xbf}, {0x9c,0xc0},
    {0x9c,0xc1}, {0x9c,0xc2}, {0x9c,0xc3}, {0x9c,0xc4}, {0x9c,0xc5}, {0x9c,0xc6}, {0x9c,0xc7}, {0x9c,0xc8}, {0x9c,0xc9}, {0x9c,0xca},
    {0x9c,0xcb}, {0x9c,0xcc}, {0x9c,0xcd}, {0x9c,0xce}, {0x9c,0xcf}, {0xd4,0xd1}, {0x9c,0xd1}, {0x9c,0xd2}, {0x9c,0xd3}, {0x9c,0xd4},
    {0x9c,0xd5}, {0x9c,0xd6}, {0x9c,0xd7}, {0x9c,0xd8}, {0x9c,0xd9}, {0x9c,0xda}, {0x9c,0xdb}, {0x9c,0xdc}, {0x9c,0xdd}, {0x9c,0xde},
    {0x9c,0xdf}, {0x9c,0xe0}, {0x9c,0xe1}, {0x9c,0xe2}, {0x9c,0xe3}, {0x9c,0xe4}, {0x9c,0xe5}, {0x9c,0xe6}, {0x9c,0xe7}, {0x9c,0xe8},
    {0x9c,0xe9}, {0x9c,0xea}, {0x9c,0xeb}, {0x9c,0xec}, {0x9c,0xed}, {0x9c,0xee}, {0x9c,0xef}, {0x9c,0xf0}, {0x9c,0xf1}, {0x9c,0xf2},
    {0x9c,0xf3}, {0x9c,0xf4}, {0x9c,0xf5}, {0x9c,0xf6}, {0x9c,0xf7}, {0x9c,0xf8}, {0x9c,0xf9}, {0x9c,0xfa}, {0x9c,0xfb}, {0x9c,0xfc},
    {0x9c,0xfd}, {0x9c,0xfe}, {0x9d,0x40}, {0x9d,0x41}, {0x9d,0x42}, {0x9d,0x43}, {0x9d,0x44}, {0x9d,0x45}, {0x9d,0x46}, {0x9d,0x47},
    {0x9d,0x48}, {0x9d,0x49}, {0x9d,0x4a}, {0x9d,0x4b}, {0x9d,0x4c}, {0x9d,0x4d}, {0x9d,0x4e}, {0x9d,0x4f}, {0x9d,0x50}, {0x9d,0x51},
    {0x9d,0x52}, {0x9d,0x53}, {0x9d,0x54}, {0x9d,0x55}, {0x9d,0x56}, {0xe0,0x7c}, {0x9d,0x58}, {0x9d,0x59}, {0xb5,0xae}, {0x9d,0x5b},
    {0x9d,0x5c}, {0x9d,0x5d}, {0x9d,0x5e}, {0x9d,0x5f}, {0x9d,0x60}, {0x9d,0x61}, {0x9d,0x62}, {0x9d,0x63}, {0x9d,0x64}, {0x9d,0x65},
    {0x9d,0x66}, {0x9d,0x67}, {0x9d,0x68}, {0x9d,0x69}, {0x9d,0x6a}, {0x9d,0x6b}, {0x9d,0x6c}, {0x9d,0x6d}, {0x9d,0x6e}, {0x9d,0x6f},
    {0x9d,0x70}, {0x9d,0x71}, {0x9d,0x72}, {0x9d,0x73}, {0x9d,0x74}, {0x9d,0x75}, {0x9d,0x76}, {0x9d,0x77}, {0x9d,0x78}, {0x9d,0x79},
    {0x9d,0x7a}, {0x9d,0x7b}, {0x9d,0x7c}, {0x9d,0x7d}, {0x9d,0x7e}, {0x9d,0xa1}, {0x9d,0xa2}, {0x9d,0xa3}, {0x9d,0xa4}, {0x9d,0xa5},
    {0x9d,0xa6}, {0x9d,0xa7}, {0x9d,0xa8}, {0x9d,0xa9}, {0x9d,0xaa}, {0x9d,0xab}, {0x9d,0xac}, {0x9d,0xad}, {0x9d,0xae}, {0x9d,0xaf},
    {0x9d,0xb0}, {0x9d,0xb1}, {0x9d,0xb2}, {0x9d,0xb3}, {0x9d,0xb4}, {0x9d,0xb5}, {0x9d,0xb6}, {0x9d,0xb7}, {0x9d,0xb8}, {0x9d,0xb9},
    {0x9d,0xba}, {0x9d,0xbb}, {0x9d,0xbc}, {0x9d,0xbd}, {0x9d,0xbe}, {0x9d,0xbf}, {0x9d,0xc0}, {0x9d,0xc1}, {0x9d,0xc2}, {0x9d,0xc3},
    {0xa9,0xe4}, {0x9d,0xc5}, {0x9d,0xc6}, {0x9d,0xc7}, {0x9d,0xc8}, {0x9d,0xc9}, {0x9d,0xca}, {0x9d,0xcb}, {0x9d,0xcc}, {0x9d,0xcd},
    {0x9d,0xce}, {0x9d,0xcf}, {0x9d,0xd0}, {0x9d,0xd1}, {0x9d,0xd2}, {0x9d,0xd3}, {0x9d,0xd4}, {0x9d,0xd5}, {0x9d,0xd6}, {0x9d,0xd7},
    {0x9d,0xd8}, {0x9d,0xd9}, {0x9d,0xda}, {0x9d,0xdb}, {0x9d,0xdc}, {0x9d,0xdd}, {0x9d,0xde}, {0x9d,0xdf}, {0x9d,0xe0}, {0x9d,0xe1},
    {0x9d,0xe2}, {0x9d,0xe3}, {0x9d,0xe4}, {0x9d,0xe5}, {0x9d,0xe6}, {0x9d,0xe7}, {0x9d,0xe8}, {0x9d,0xe9}, {0x9d,0xea}, {0x9d,0xeb},
    {0x9d,0xec}, {0x9d,0xed}, {0x9d,0xee}, {0x9d,0xef}, {0x9d,0xf0}, {0x9d,0xf1}, {0x9d,0xf2}, {0x9d,0xf3}, {0x9d,0xf4}, {0x9d,0xf5},
    {0x9d,0xf6}, {0x9d,0xf7}, {0x9d,0xf8}, {0x9d,0xf9}, {0x9d,0xfa}, {0x9d,0xfb}, {0x9d,0xfc}, {0x9d,0xfd}, {0x9d,0xfe}, {0x9e,0x40},
    {0x9e,0x41}, {0x9e,0x42}, {0x9e,0x43}, {0x9e,0x44}, {0x9e,0x45}, {0x9e,0x46}, {0x9e,0x47}, {0x9e,0x48}, {0x9e,0x49}, {0x9e,0x4a},
    {0x9e,0x4b}, {0x9e,0x4c}, {0x9e,0x4d}, {0x9e,0x4e}, {0x9e,0x4f}, {0x9e,0x50}, {0x9e,0x51}, {0x9e,0x52}, {0x9e,0x53}, {0x9e,0x54},
    {0x9e,0x55}, {0x9e,0x56}, {0x9e,0x57}, {0x9e,0x58}, {0x9e,0x59}, {0x9e,0x5a}, {0x9e,0x5b}, {0x9e,0x5c}, {0x9e,0x5d}, {0x9e,0x5e},
    {0x9e,0x5f}, {0x9e,0x60}, {0x9e,0x61}, {0x9e,0x62}, {0x9e,0x63}, {0x9e,0x64}, {0x9e,0x65}, {0x9e,0x66}, {0x9e,0x67}, {0x9e,0x68},
    {0x9e,0x69}, {0x9e,0x6a}, {0x9e,0x6b}, {0x9e,0x6c}, {0x9e,0x6d}, {0x9e,0x6e}, {0x9e,0x6f}, {0x9e,0x70}, {0x9e,0x71}, {0x9e,0x72},
    {0x9e,0x73}, {0x9e,0x74}, {0x9e,0x75}, {0x9e,0x76}, {0x9e,0x77}, {0x9e,0x78}, {0x9e,0x79}, {0x9e,0x7a}, {0x9e,0x7b}, {0x9e,0x7c},
    {0x9e,0x7d}, {0x9e,0x7e}, {0x9e,0xa1}, {0x9e,0xa2}, {0x9e,0xa3}, {0x9e,0xa4}, {0x9e,0xa5}, {0x9e,0xa6}, {0x9e,0xa7}, {0x9e,0xa8},
    {0xab,0xec}, {0x9e,0xaa}, {0x9e,0xab}, {0x9e,0xac}, {0x9e,0xad}, {0x9e,0xae}, {0x9e,0xaf}, {0x9e,0xb0}, {0x9e,0xb1}, {0x9e,0xb2},
    {0x9e,0xb3}, {0x9e,0xb4}, {0x9e,0xb5}, {0x9e,0xb6}, {0x9e,0xb7}, {0x9e,0xb8}, {0x9e,0xb9}, {0x9e,0xba}, {0x9e,0xbb}, {0x9e,0xbc},
    {0x9e,0xbd}, {0x9e,0xbe}, {0x9e,0xbf}, {0x9e,0xc0}, {0x9e,0xc1}, {0x9e,0xc2}, {0x9e,0xc3}, {0x9e,0xc4}, {0x9e,0xc5}, {0x9e,0xc6},
    {0x9e,0xc7}, {0x9e,0xc8}, {0x9e,0xc9}, {0x9e,0xca}, {0x9e,0xcb}, {0x9e,0xcc}, {0x9e,0xcd}, {0x9e,0xce}, {0x9e,0xcf}, {0x9e,0xd0},
    {0x9e,0xd1}, {0x9e,0xd2}, {0x9e,0xd3}, {0x9e,0xd4}, {0x9e,0xd5}, {0x9e,0xd6}, {0x9e,0xd7}, {0x9e,0xd8}, {0x9e,0xd9}, {0x9e,0xda},
    {0x9e,0xdb}, {0x9e,0xdc}, {0x9e,0xdd}, {0x9e,0xde}, {0x9e,0xdf}, {0x9e,0xe0}, {0x9e,0xe1}, {0x9e,0xe2}, {0x9e,0xe3}, {0x9e,0xe4},
    {0x9e,0xe5}, {0x9e,0xe6}, {0x9e,0xe7}, {0x9e,0xe8}, {0x9e,0xe9}, {0x9e,0xea}, {0x9e,0xeb}, {0x9e,0xec}, {0x9e,0xed}, {0x9e,0xee},
    {0xde,0xcd}, {0x9e,0xf0}, {0x9e,0xf1}, {0x9e,0xf2}, {0x9e,0xf3}, {0x9e,0xf4}, {0x9e,0xf5}, {0x9e,0xf6}, {0x9e,0xf7}, {0x9e,0xf8},
    {0x9e,0xf9}, {0x9e,0xfa}, {0x9e,0xfb}, {0x9e,0xfc}, {0xc9,0xfc}, {0x9e,0xfe}, {0x9f,0x40}, {0x9f,0x41}, {0x9f,0x42}, {0x9f,0x43},
    {0x9f,0x44}, {0x9f,0x45}, {0x9f,0x46}, {0x9f,0x47}, {0x9f,0x48}, {0x9f,0x49}, {0x9f,0x4a}, {0x9f,0x4b}, {0x9f,0x4c}, {0x9f,0x4d},
    {0x9f,0x4e}, {0x9f,0x4f}, {0x9f,0x50}, {0x9f,0x51}, {0x9f,0x52}, {0x9f,0x53}, {0x9f,0x54}, {0x9f,0x55}, {0x9f,0x56}, {0x9f,0x57},
    {0x9f,0x58}, {0x9f,0x59}, {0x9f,0x5a}, {0x9f,0x5b}, {0x9f,0x5c}, {0x9f,0x5d}, {0x9f,0x5e}, {0x9f,0x5f}, {0xf9,0xc4}, {0x9f,0x61},
    {0x9f,0x62}, {0x9f,0x63}, {0x9f,0x64}, {0x9f,0x65}, {0x91,0xbe}, {0x9f,0x67}, {0x9f,0x68}, {0x9f,0x69}, {0x9f,0x6a}, {0x9f,0x6b},
    {0x9f,0x6c}, {0x9f,0x6d}, {0x9f,0x6e}, {0x9f,0x6f}, {0x9f,0x70}, {0x9f,0x71}, {0x9f,0x72}, {0x9f,0x73}, {0x9f,0x74}, {0x9f,0x75},
    {0x9f,0x76}, {0x9f,0x77}, {0x9f,0x78}, {0x9f,0x79}, {0x9f,0x7a}, {0x9f,0x7b}, {0x9f,0x7c}, {0x9f,0x7d}, {0x9f,0x7e}, {0x9f,0xa1},
    {0x9f,0xa2}, {0x9f,0xa3}, {0x9f,0xa4}, {0x9f,0xa5}, {0x9f,0xa6}, {0x9f,0xa7}, {0x9f,0xa8}, {0x9f,0xa9}, {0x9f,0xaa}, {0x9f,0xab},
    {0x9f,0xac}, {0x9f,0xad}, {0x9f,0xae}, {0x9f,0xaf}, {0x9f,0xb0}, {0x9f,0xb1}, {0x9f,0xb2}, {0x9f,0xb3}, {0x9f,0xb4}, {0x9f,0xb5},
    {0x9f,0xb6}, {0x9f,0xb7}, {0x9f,0xb8}, {0x9f,0xb9}, {0x9f,0xba}, {0x9f,0xbb}, {0x9f,0xbc}, {0x9f,0xbd}, {0x9f,0xbe}, {0x9f,0xbf},
    {0x9f,0xc0}, {0x9f,0xc1}, {0x9f,0xc2}, {0x9f,0xc3}, {0x9f,0xc4}, {0x9f,0xc5}, {0x9f,0xc6}, {0x9f,0xc7}, {0x9f,0xc8}, {0x9f,0xc9},
    {0x9f,0xca}, {0xb9,0xb0}, {0x9f,0xcc}, {0x9f,0xcd}, {0x9f,0xce}, {0x9f,0xcf}, {0x9f,0xd0}, {0x9f,0xd1}, {0x9f,0xd2}, {0x9f,0xd3},
    {0x9f,0xd4}, {0x9f,0xd5}, {0x9f,0xd6}, {0x9f,0xd7}, {0x93,0x61}, {0x9f,0xd9}, {0x9f,0xda}, {0x9f,0xdb}, {0x9f,0xdc}, {0x9f,0xdd},
    {0x9f,0xde}, {0x9f,0xdf}, {0x9f,0xe0}, {0x9f,0xe1}, {0x9f,0xe2}, {0x9f,0xe3}, {0x9f,0xe4}, {0x9f,0xe5}, {0x9f,0xe6}, {0x9f,0xe7},
    {0x9f,0xe8}, {0x9f,0xe9}, {0x9f,0xea}, {0x9f,0xeb}, {0x9f,0xec}, {0x9f,0xed}, {0x9f,0xee}, {0x9f,0xef}, {0x9f,0xf0}, {0x9f,0xf1},
    {0x9f,0xf2}, {0x9f,0xf3}, {0x9f,0xf4}, {0x9f,0xf5}, {0x9f,0xf6}, {0x9f,0xf7}, {0x9f,0xf8}, {0x9f,0xf9}, {0x9f,0xfa}, {0x9f,0xfb},
    {0x9f,0xfc}, {0x9f,0xfd}, {0x9f,0xfe}, {0xa0,0x40}, {0xa0,0x41}, {0xa0,0x42}, {0xa0,0x43}, {0xa0,0x44}, {0xa0,0x45}, {0xa0,0x46},
    {0xa0,0x47}, {0xa0,0x48}, {0xa0,0x49}, {0xa0,0x4a}, {0xa0,0x4b}, {0xa0,0x4c}, {0xa0,0x4d}, {0xa0,0x4e}, {0xa0,0x4f}, {0xa0,0x50},
    {0xa0,0x51}, {0xa0,0x52}, {0xa0,0x53}, {0xa0,0x54}, {0xa0,0x55}, {0xa0,0x56}, {0xa0,0x57}, {0xa0,0x58}, {0xa0,0x59}, {0xa0,0x5a},
    {0xa0,0x5b}, {0xa0,0x5c}, {0xa0,0x5d}, {0xa0,0x5e}, {0xa0,0x5f}, {0xa0,0x60}, {0xa0,0x61}, {0xa0,0x62}, {0x8f,0xb6}, {0xa0,0x64},
    {0xa0,0x65}, {0xa0,0x66}, {0xa0,0x67}, {0xa0,0x68}, {0xa0,0x69}, {0xa0,0x6a}, {0xa0,0x6b}, {0xa0,0x6c}, {0xa0,0x6d}, {0xa0,0x6e},
    {0xa0,0x6f}, {0xa0,0x70}, {0xa0,0x71}, {0xa0,0x72}, {0xa0,0x73}, {0xa0,0x74}, {0xa0,0x75}, {0xa0,0x76}, {0xa9,0xf0}, {0xa0,0x78},
    {0xa0,0x79}, {0xa0,0x7a}, {0xa0,0x7b}, {0xa0,0x7c}, {0xa0,0x7d}, {0xa0,0x7e}, {0xa0,0xa1}, {0xa0,0xa2}, {0xa0,0xa3}, {0xa0,0xa4},
    {0xa0,0xa5}, {0xa0,0xa6}, {0xa0,0xa7}, {0xa0,0xa8}, {0xa0,0xa9}, {0xa0,0xaa}, {0xa0,0xab}, {0xa0,0xac}, {0xa0,0xad}, {0xa0,0xae},
    {0xa0,0xaf}, {0xa0,0xb0}, {0xa0,0xb1}, {0xa0,0xb2}, {0xa0,0xb3}, {0xa0,0xb4}, {0xa0,0xb5}, {0xa0,0xb6}, {0xa0,0xb7}, {0xa0,0xb8},
    {0xa0,0xb9}, {0xa0,0xba}, {0xa0,0xbb}, {0xa0,0xbc}, {0xa0,0xbd}, {0xa0,0xbe}, {0xa0,0xbf}, {0xa0,0xc0}, {0xa0,0xc1}, {0xa0,0xc2},
    {0xa0,0xc3}, {0xa0,0xc4}, {0xa0,0xc5}, {0xa0,0xc6}, {0xa0,0xc7}, {0xa0,0xc8}, {0xa0,0xc9}, {0xa0,0xca}, {0xa0,0xcb}, {0xa0,0xcc},
    {0xa0,0xcd}, {0xa0,0xce}, {0xa0,0xcf}, {0xa0,0xd0}, {0xa0,0xd1}, {0xa0,0xd2}, {0xa0,0xd3}, {0xa0,0xd4}, {0x94,0x7a}, {0xa0,0xd6},
    {0xa0,0xd7}, {0xa0,0xd8}, {0xa0,0xd9}, {0xa0,0xda}, {0xa0,0xdb}, {0xa0,0xdc}, {0xa0,0xdd}, {0xa0,0xde}, {0xde,0x72}, {0xa0,0xe0},
    {0xa0,0xe1}, {0xa0,0xe2}, {0xa0,0xe3}, {0x94,0x55}, {0xa0,0xe5}, {0xa0,0xe6}, {0xa0,0xe7}, {0xa0,0xe8}, {0xa0,0xe9}, {0xa0,0xea},
    {0xa0,0xeb}, {0xa0,0xec}, {0xa0,0xed}, {0xa0,0xee}, {0xa0,0xef}, {0xa0,0xf0}, {0xa0,0xf1}, {0xa0,0xf2}, {0xa0,0xf3}, {0xa0,0xf4},
    {0xa0,0xf5}, {0xa0,0xf6}, {0xa0,0xf7}, {0xa0,0xf8}, {0xa0,0xf9}, {0xa0,0xfa}, {0xa0,0xfb}, {0xa0,0xfc}, {0xa0,0xfd}, {0xa0,0xfe},
    {0x81,0x40}, {0x81,0x41}, {0x81,0x42}, {0x81,0x43}, {0x81,0x44}, {0x81,0x45}, {0x81,0x46}, {0x81,0x47}, {0x81,0x48}, {0x81,0x49},
    {0x81,0x4a}, {0x81,0x4b}, {0x81,0x4c}, {0x81,0x4d}, {0x81,0x4e}, {0x81,0x4f}, {0x81,0x50}, {0x81,0x51}, {0x81,0x52}, {0x81,0x53},
    {0x81,0x54}, {0x81,0x55}, {0x81,0x56}, {0x81,0x57}, {0x81,0x58}, {0x81,0x59}, {0x81,0x5a}, {0x81,0x5b}, {0x81,0x5c}, {0x81,0x5d},
    {0x81,0x5e}, {0x81,0x5f}, {0x81,0x60}, {0x81,0x61}, {0x81,0x62}, {0x81,0x63}, {0x81,0x64}, {0x81,0x65}, {0x81,0x66}, {0x81,0x67},
    {0x81,0x68}, {0x81,0x69}, {0x81,0x6a}, {0x81,0x6b}, {0x81,0x6c}, {0x81,0x6d}, {0x81,0x6e}, {0x81,0x6f}, {0x81,0x70}, {0x81,0x71},
    {0x81,0x72}, {0x81,0x73}, {0x81,0x74}, {0x81,0x75}, {0x81,0x76}, {0x81,0x77}, {0x81,0x78}, {0x81,0x79}, {0x81,0x7a}, {0x81,0x7b},
    {0x81,0x7c}, {0x81,0x7d}, {0x81,0x7e}, {0x81,0xa1}, {0x81,0xa2}, {0x81,0xa3}, {0x81,0xa4}, {0x81,0xa5}, {0x81,0xa6}, {0x81,0xa7},
    {0x81,0xa8}, {0x81,0xa9}, {0x81,0xaa}, {0x81,0xab}, {0x81,0xac}, {0x81,0xad}, {0x81,0xae}, {0x81,0xaf}, {0x81,0xb0}, {0x81,0xb1},
    {0x81,0xb2}, {0x81,0xb3}, {0x81,0xb4}, {0x81,0xb5}, {0x81,0xb6}, {0x81,0xb7}, {0x81,0xb8}, {0x81,0xb9}, {0x81,0xba}, {0x81,0xbb},
    {0x81,0xbc}, {0x81,0xbd}, {0x81,0xbe}, {0x81,0xbf}, {0x81,0xc0}, {0x81,0xc1}, {0x81,0xc2}, {0x81,0xc3}, {0x81,0xc4}, {0x81,0xc5},
    {0x81,0xc6}, {0x81,0xc7}, {0x81,0xc8}, {0x81,0xc9}, {0x81,0xca}, {0x81,0xcb}, {0x81,0xcc}, {0x81,0xcd}, {0x81,0xce}, {0x81,0xcf},
    {0x81,0xd0}, {0x81,0xd1}, {0x81,0xd2}, {0x81,0xd3}, {0x81,0xd4}, {0x81,0xd5}, {0x81,0xd6}, {0x81,0xd7}, {0x81,0xd8}, {0x81,0xd9},
    {0x81,0xda}, {0x81,0xdb}, {0x81,0xdc}, {0x81,0xdd}, {0x81,0xde}, {0x81,0xdf}, {0x81,0xe0}, {0x81,0xe1}, {0x81,0xe2}, {0x81,0xe3},
    {0x81,0xe4}, {0x81,0xe5}, {0x81,0xe6}, {0x81,0xe7}, {0x81,0xe8}, {0x81,0xe9}, {0x81,0xea}, {0x81,0xeb}, {0x81,0xec}, {0x81,0xed},
    {0x81,0xee}, {0x81,0xef}, {0x81,0xf0}, {0x81,0xf1}, {0x81,0xf2}, {0x81,0xf3}, {0x81,0xf4}, {0x81,0xf5}, {0x81,0xf6}, {0x81,0xf7},
    {0x81,0xf8}, {0x81,0xf9}, {0x81,0xfa}, {0x81,0xfb}, {0x81,0xfc}, {0x81,0xfd}, {0x81,0xfe}, {0x82,0x40}, {0x82,0x41}, {0x82,0x42},
    {0x82,0x43}, {0x82,0x44}, {0x82,0x45}, {0x82,0x46}, {0x82,0x47}, {0x82,0x48}, {0x82,0x49}, {0x82,0x4a}, {0x82,0x4b}, {0x82,0x4c},
    {0x82,0x4d}, {0x82,0x4e}, {0x82,0x4f}, {0x82,0x50}, {0x82,0x51}, {0x82,0x52}, {0x82,0x53}, {0x82,0x54}, {0x82,0x55}, {0x82,0x56},
    {0x82,0x57}, {0x82,0x58}, {0x82,0x59}, {0x82,0x5a}, {0x82,0x5b}, {0x82,0x5c}, {0x82,0x5d}, {0x82,0x5e}, {0x82,0x5f}, {0x82,0x60},
    {0x82,0x61}, {0x82,0x62}, {0x82,0x63}, {0x82,0x64}, {0x82,0x65}, {0x82,0x66}, {0x82,0x67}, {0x82,0x68}, {0x82,0x69}, {0x82,0x6a},
    {0x82,0x6b}, {0x82,0x6c}, {0x82,0x6d}, {0x82,0x6e}, {0x82,0x6f}, {0x82,0x70}, {0x82,0x71}, {0x82,0x72}, {0x82,0x73}, {0x82,0x74},
    {0x82,0x75}, {0x82,0x76}, {0x82,0x77}, {0x82,0x78}, {0x82,0x79}, {0x82,0x7a}, {0x82,0x7b}, {0x82,0x7c}, {0x82,0x7d}, {0x82,0x7e},
    {0x82,0xa1}, {0x82,0xa2}, {0x82,0xa3}, {0x82,0xa4}, {0x82,0xa5}, {0x82,0xa6}, {0x82,0xa7}, {0x82,0xa8}, {0x82,0xa9}, {0x82,0xaa},
    {0x82,0xab}, {0x82,0xac}, {0x82,0xad}, {0x82,0xae}, {0x82,0xaf}, {0x82,0xb0}, {0x82,0xb1}, {0x82,0xb2}, {0x82,0xb3}, {0x82,0xb4},
    {0x82,0xb5}, {0x82,0xb6}, {0x82,0xb7}, {0x82,0xb8}, {0x82,0xb9}, {0x82,0xba}, {0x82,0xbb}, {0x82,0xbc}, {0x82,0xbd}, {0x82,0xbe},
    {0x82,0xbf}, {0x82,0xc0}, {0x82,0xc1}, {0x82,0xc2}, {0x82,0xc3}, {0x82,0xc4}, {0x82,0xc5}, {0x82,0xc6}, {0x82,0xc7}, {0x82,0xc8},
    {0x82,0xc9}, {0x82,0xca}, {0x82,0xcb}, {0x82,0xcc}, {0x82,0xcd}, {0x82,0xce}, {0x82,0xcf}, {0x82,0xd0}, {0x82,0xd1}, {0x82,0xd2},
    {0x82,0xd3}, {0x82,0xd4}, {0x82,0xd5}, {0x82,0xd6}, {0x82,0xd7}, {0x82,0xd8}, {0x82,0xd9}, {0x82,0xda}, {0x82,0xdb}, {0x82,0xdc},
    {0x82,0xdd}, {0x82,0xde}, {0x82,0xdf}, {0x82,0xe0}, {0x82,0xe1}, {0x82,0xe2}, {0x82,0xe3}, {0x82,0xe4}, {0x82,0xe5}, {0x82,0xe6},
    {0x82,0xe7}, {0x82,0xe8}, {0x82,0xe9}, {0x82,0xea}, {0x82,0xeb}, {0x82,0xec}, {0x82,0xed}, {0x82,0xee}, {0x82,0xef}, {0x82,0xf0},
    {0x82,0xf1}, {0x82,0xf2}, {0x82,0xf3}, {0x82,0xf4}, {0x82,0xf5}, {0x82,0xf6}, {0x82,0xf7}, {0x82,0xf8}, {0x82,0xf9}, {0x82,0xfa},
    {0x82,0xfb}, {0x82,0xfc}, {0x82,0xfd}, {0x82,0xfe}, {0x83,0x40}, {0x83,0x41}, {0x83,0x42}, {0x83,0x43}, {0x83,0x44}, {0x83,0x45},
    {0x83,0x46}, {0x83,0x47}, {0x83,0x48}, {0x83,0x49}, {0x83,0x4a}, {0x83,0x4b}, {0x83,0x4c}, {0x83,0x4d}, {0x83,0x4e}, {0x83,0x4f},
    {0x83,0x50}, {0x83,0x51}, {0x83,0x52}, {0x83,0x53}, {0x83,0x54}, {0x83,0x55}, {0x83,0x56}, {0x83,0x57}, {0x83,0x58}, {0x83,0x59},
    {0x83,0x5a}, {0x83,0x5b}, {0x83,0x5c}, {0x83,0x5d}, {0x83,0x5e}, {0x83,0x5f}, {0x83,0x60}, {0x83,0x61}, {0x83,0x62}, {0x83,0x63},
    {0x83,0x64}, {0x83,0x65}, {0x83,0x66}, {0x83,0x67}, {0x83,0x68}, {0x83,0x69}, {0x83,0x6a}, {0x83,0x6b}, {0x83,0x6c}, {0x83,0x6d},
    {0x83,0x6e}, {0x83,0x6f}, {0x83,0x70}, {0x83,0x71}, {0x83,0x72}, {0x83,0x73}, {0x83,0x74}, {0x83,0x75}, {0x83,0x76}, {0x83,0x77},
    {0x83,0x78}, {0x83,0x79}, {0x83,0x7a}, {0x83,0x7b}, {0x83,0x7c}, {0x83,0x7d}, {0x83,0x7e}, {0x83,0xa1}, {0x83,0xa2}, {0x83,0xa3},
    {0x83,0xa4}, {0x83,0xa5}, {0x83,0xa6}, {0x83,0xa7}, {0x83,0xa8}, {0x83,0xa9}, {0x83,0xaa}, {0x83,0xab}, {0x83,0xac}, {0x83,0xad},
    {0x83,0xae}, {0x83,0xaf}, {0x83,0xb0}, {0x83,0xb1}, {0x83,0xb2}, {0x83,0xb3}, {0x83,0xb4}, {0x83,0xb5}, {0x83,0xb6}, {0x83,0xb7},
    {0x83,0xb8}, {0x83,0xb9}, {0x83,0xba}, {0x83,0xbb}, {0x83,0xbc}, {0x83,0xbd}, {0x83,0xbe}, {0x83,0xbf}, {0x83,0xc0}, {0x83,0xc1},
    {0x83,0xc2}, {0x83,0xc3}, {0x83,0xc4}, {0x83,0xc5}, {0x83,0xc6}, {0x83,0xc7}, {0x83,0xc8}, {0x83,0xc9}, {0x83,0xca}, {0x83,0xcb},
    {0x83,0xcc}, {0x83,0xcd}, {0x83,0xce}, {0x83,0xcf}, {0x83,0xd0}, {0x83,0xd1}, {0x83,0xd2}, {0x83,0xd3}, {0x83,0xd4}, {0x83,0xd5},
    {0x83,0xd6}, {0x83,0xd7}, {0x83,0xd8}, {0x83,0xd9}, {0x83,0xda}, {0x83,0xdb}, {0x83,0xdc}, {0x83,0xdd}, {0x83,0xde}, {0x83,0xdf},
    {0x83,0xe0}, {0x83,0xe1}, {0x83,0xe2}, {0x83,0xe3}, {0x83,0xe4}, {0x83,0xe5}, {0x83,0xe6}, {0x83,0xe7}, {0x83,0xe8}, {0x83,0xe9},
    {0x83,0xea}, {0x83,0xeb}, {0x83,0xec}, {0x83,0xed}, {0x83,0xee}, {0x83,0xef}, {0x83,0xf0}, {0x83,0xf1}, {0x83,0xf2}, {0x83,0xf3},
    {0x83,0xf4}, {0x83,0xf5}, {0x83,0xf6}, {0x83,0xf7}, {0x83,0xf8}, {0x83,0xf9}, {0x83,0xfa}, {0x83,0xfb}, {0x83,0xfc}, {0x83,0xfd},
    {0x83,0xfe}, {0x84,0x40}, {0x84,0x41}, {0x84,0x42}, {0x84,0x43}, {0x84,0x44}, {0x84,0x45}, {0x84,0x46}, {0x84,0x47}, {0x84,0x48},
    {0x84,0x49}, {0x84,0x4a}, {0x84,0x4b}, {0x84,0x4c}, {0x84,0x4d}, {0x84,0x4e}, {0x84,0x4f}, {0x84,0x50}, {0x84,0x51}, {0x84,0x52},
    {0x84,0x53}, {0x84,0x54}, {0x84,0x55}, {0x84,0x56}, {0x84,0x57}, {0x84,0x58}, {0x84,0x59}, {0x84,0x5a}, {0x84,0x5b}, {0x84,0x5c},
    {0x84,0x5d}, {0x84,0x5e}, {0x84,0x5f}, {0x84,0x60}, {0x84,0x61}, {0x84,0x62}, {0x84,0x63}, {0x84,0x64}, {0x84,0x65}, {0x84,0x66},
    {0x84,0x67}, {0x84,0x68}, {0x84,0x69}, {0x84,0x6a}, {0x84,0x6b}, {0x84,0x6c}, {0x84,0x6d}, {0x84,0x6e}, {0x84,0x6f}, {0x84,0x70},
    {0x84,0x71}, {0x84,0x72}, {0x84,0x73}, {0x84,0x74}, {0x84,0x75}, {0x84,0x76}, {0x84,0x77}, {0x84,0x78}, {0x84,0x79}, {0x84,0x7a},
    {0x84,0x7b}, {0x84,0x7c}, {0x84,0x7d}, {0x84,0x7e}, {0x84,0xa1}, {0x84,0xa2}, {0x84,0xa3}, {0x84,0xa4}, {0x84,0xa5}, {0x84,0xa6},
    {0x84,0xa7}, {0x84,0xa8}, {0x84,0xa9}, {0x84,0xaa}, {0x84,0xab}, {0x84,0xac}, {0x84,0xad}, {0x84,0xae}, {0x84,0xaf}, {0x84,0xb0},
    {0x84,0xb1}, {0x84,0xb2}, {0x84,0xb3}, {0x84,0xb4}, {0x84,0xb5}, {0x84,0xb6}, {0x84,0xb7}, {0x84,0xb8}, {0x84,0xb9}, {0x84,0xba},
    {0x84,0xbb}, {0x84,0xbc}, {0x84,0xbd}, {0x84,0xbe}, {0x84,0xbf}, {0x84,0xc0}, {0x84,0xc1}, {0x84,0xc2}, {0x84,0xc3}, {0x84,0xc4},
    {0x84,0xc5}, {0x84,0xc6}, {0x84,0xc7}, {0x84,0xc8}, {0x84,0xc9}, {0x84,0xca}, {0x84,0xcb}, {0x84,0xcc}, {0x84,0xcd}, {0x84,0xce},
    {0x84,0xcf}, {0x84,0xd0}, {0x84,0xd1}, {0x84,0xd2}, {0x84,0xd3}, {0x84,0xd4}, {0x84,0xd5}, {0x84,0xd6}, {0x84,0xd7}, {0x84,0xd8},
    {0x84,0xd9}, {0x84,0xda}, {0x84,0xdb}, {0x84,0xdc}, {0x84,0xdd}, {0x84,0xde}, {0x84,0xdf}, {0x84,0xe0}, {0x84,0xe1}, {0x84,0xe2},
    {0x84,0xe3}, {0x84,0xe4}, {0x84,0xe5}, {0x84,0xe6}, {0x84,0xe7}, {0x84,0xe8}, {0x84,0xe9}, {0x84,0xea}, {0x84,0xeb}, {0x84,0xec},
    {0x84,0xed}, {0x84,0xee}, {0x84,0xef}, {0x84,0xf0}, {0x84,0xf1}, {0x84,0xf2}, {0x84,0xf3}, {0x84,0xf4}, {0x84,0xf5}, {0x84,0xf6},
    {0x84,0xf7}, {0x84,0xf8}, {0x84,0xf9}, {0x84,0xfa}, {0x84,0xfb}, {0x84,0xfc}, {0x84,0xfd}, {0x84,0xfe}, {0x85,0x40}, {0x85,0x41},
    {0x85,0x42}, {0x85,0x43}, {0x85,0x44}, {0x85,0x45}, {0x85,0x46}, {0x85,0x47}, {0x85,0x48}, {0x85,0x49}, {0x85,0x4a}, {0x85,0x4b},
    {0x85,0x4c}, {0x85,0x4d}, {0x85,0x4e}, {0x85,0x4f}, {0x85,0x50}, {0x85,0x51}, {0x85,0x52}, {0x85,0x53}, {0x85,0x54}, {0x85,0x55},
    {0x85,0x56}, {0x85,0x57}, {0x85,0x58}, {0x85,0x59}, {0x85,0x5a}, {0x85,0x5b}, {0x85,0x5c}, {0x85,0x5d}, {0x85,0x5e}, {0x85,0x5f},
    {0x85,0x60}, {0x85,0x61}, {0x85,0x62}, {0x85,0x63}, {0x85,0x64}, {0x85,0x65}, {0x85,0x66}, {0x85,0x67}, {0x85,0x68}, {0x85,0x69},
    {0x85,0x6a}, {0x85,0x6b}, {0x85,0x6c}, {0x85,0x6d}, {0x85,0x6e}, {0x85,0x6f}, {0x85,0x70}, {0x85,0x71}, {0x85,0x72}, {0x85,0x73},
    {0x85,0x74}, {0x85,0x75}, {0x85,0x76}, {0x85,0x77}, {0x85,0x78}, {0x85,0x79}, {0x85,0x7a}, {0x85,0x7b}, {0x85,0x7c}, {0x85,0x7d},
    {0x85,0x7e}, {0x85,0xa1}, {0x85,0xa2}, {0x85,0xa3}, {0x85,0xa4}, {0x85,0xa5}, {0x85,0xa6}, {0x85,0xa7}, {0x85,0xa8}, {0x85,0xa9},
    {0x85,0xaa}, {0x85,0xab}, {0x85,0xac}, {0x85,0xad}, {0x85,0xae}, {0x85,0xaf}, {0x85,0xb0}, {0x85,0xb1}, {0x85,0xb2}, {0x85,0xb3},
    {0x85,0xb4}, {0x85,0xb5}, {0x85,0xb6}, {0x85,0xb7}, {0x85,0xb8}, {0x85,0xb9}, {0x85,0xba}, {0x85,0xbb}, {0x85,0xbc}, {0x85,0xbd},
    {0x85,0xbe}, {0x85,0xbf}, {0x85,0xc0}, {0x85,0xc1}, {0x85,0xc2}, {0x85,0xc3}, {0x85,0xc4}, {0x85,0xc5}, {0x85,0xc6}, {0x85,0xc7},
    {0x85,0xc8}, {0x85,0xc9}, {0x85,0xca}, {0x85,0xcb}, {0x85,0xcc}, {0x85,0xcd}, {0x85,0xce}, {0x85,0xcf}, {0x85,0xd0}, {0x85,0xd1},
    {0x85,0xd2}, {0x85,0xd3}, {0x85,0xd4}, {0x85,0xd5}, {0x85,0xd6}, {0x85,0xd7}, {0x85,0xd8}, {0x85,0xd9}, {0x85,0xda}, {0x85,0xdb},
    {0x85,0xdc}, {0x85,0xdd}, {0x85,0xde}, {0x85,0xdf}, {0x85,0xe0}, {0x85,0xe1}, {0x85,0xe2}, {0x85,0xe3}, {0x85,0xe4}, {0x85,0xe5},
    {0x85,0xe6}, {0x85,0xe7}, {0x85,0xe8}, {0x85,0xe9}, {0x85,0xea}, {0x85,0xeb}, {0x85,0xec}, {0x85,0xed}, {0x85,0xee}, {0x85,0xef},
    {0x85,0xf0}, {0x85,0xf1}, {0x85,0xf2}, {0x85,0xf3}, {0x85,0xf4}, {0x85,0xf5}, {0x85,0xf6}, {0x85,0xf7}, {0x85,0xf8}, {0x85,0xf9},
    {0x85,0xfa}, {0x85,0xfb}, {0x85,0xfc}, {0x85,0xfd}, {0x85,0xfe}, {0x86,0x40}, {0x86,0x41}, {0x86,0x42}, {0x86,0x43}, {0x86,0x44},
    {0x86,0x45}, {0x86,0x46}, {0x86,0x47}, {0x86,0x48}, {0x86,0x49}, {0x86,0x4a}, {0x86,0x4b}, {0x86,0x4c}, {0x86,0x4d}, {0x86,0x4e},
    {0x86,0x4f}, {0x86,0x50}, {0x86,0x51}, {0x86,0x52}, {0x86,0x53}, {0x86,0x54}, {0x86,0x55}, {0x86,0x56}, {0x86,0x57}, {0x86,0x58},
    {0x86,0x59}, {0x86,0x5a}, {0x86,0x5b}, {0x86,0x5c}, {0x86,0x5d}, {0x86,0x5e}, {0x86,0x5f}, {0x86,0x60}, {0x86,0x61}, {0x86,0x62},
    {0x86,0x63}, {0x86,0x64}, {0x86,0x65}, {0x86,0x66}, {0x86,0x67}, {0x86,0x68}, {0x86,0x69}, {0x86,0x6a}, {0x86,0x6b}, {0x86,0x6c},
    {0x86,0x6d}, {0x86,0x6e}, {0x86,0x6f}, {0x86,0x70}, {0x86,0x71}, {0x86,0x72}, {0x86,0x73}, {0x86,0x74}, {0x86,0x75}, {0x86,0x76},
    {0x86,0x77}, {0x86,0x78}, {0x86,0x79}, {0x86,0x7a}, {0x86,0x7b}, {0x86,0x7c}, {0x86,0x7d}, {0x86,0x7e}, {0x86,0xa1}, {0x86,0xa2},
    {0x86,0xa3}, {0x86,0xa4}, {0x86,0xa5}, {0x86,0xa6}, {0x86,0xa7}, {0x86,0xa8}, {0x86,0xa9}, {0x86,0xaa}, {0x86,0xab}, {0x86,0xac},
    {0x86,0xad}, {0x86,0xae}, {0x86,0xaf}, {0x86,0xb0}, {0x86,0xb1}, {0x86,0xb2}, {0x86,0xb3}, {0x86,0xb4}, {0x86,0xb5}, {0x86,0xb6},
    {0x86,0xb7}, {0x86,0xb8}, {0x86,0xb9}, {0x86,0xba}, {0x86,0xbb}, {0x86,0xbc}, {0x86,0xbd}, {0x86,0xbe}, {0x86,0xbf}, {0x86,0xc0},
    {0x86,0xc1}, {0x86,0xc2}, {0x86,0xc3}, {0x86,0xc4}, {0x86,0xc5}, {0x86,0xc6}, {0x86,0xc7}, {0x86,0xc8}, {0x86,0xc9}, {0x86,0xca},
    {0x86,0xcb}, {0x86,0xcc}, {0x86,0xcd}, {0x86,0xce}, {0x86,0xcf}, {0x86,0xd0}, {0x86,0xd1}, {0x86,0xd2}, {0x86,0xd3}, {0x86,0xd4},
    {0x86,0xd5}, {0x86,0xd6}, {0x86,0xd7}, {0x86,0xd8}, {0x86,0xd9}, {0x86,0xda}, {0x86,0xdb}, {0x86,0xdc}, {0x86,0xdd}, {0x86,0xde},
    {0x86,0xdf}, {0x86,0xe0}, {0x86,0xe1}, {0x86,0xe2}, {0x86,0xe3}, {0x86,0xe4}, {0x86,0xe5}, {0x86,0xe6}, {0x86,0xe7}, {0x86,0xe8},
    {0x86,0xe9}, {0x86,0xea}, {0x86,0xeb}, {0x86,0xec}, {0x86,0xed}, {0x86,0xee}, {0x86,0xef}, {0x86,0xf0}, {0x86,0xf1}, {0x86,0xf2},
    {0x86,0xf3}, {0x86,0xf4}, {0x86,0xf5}, {0x86,0xf6}, {0x86,0xf7}, {0x86,0xf8}, {0x86,0xf9}, {0x86,0xfa}, {0x86,0xfb}, {0x86,0xfc},
    {0x86,0xfd}, {0x86,0xfe}, {0x87,0x40}, {0x87,0x41}, {0x87,0x42}, {0x87,0x43}, {0x87,0x44}, {0x87,0x45}, {0x87,0x46}, {0x87,0x47},
    {0x87,0x48}, {0x87,0x49}, {0x87,0x4a}, {0x87,0x4b}, {0x87,0x4c}, {0x87,0x4d}, {0x87,0x4e}, {0x87,0x4f}, {0x87,0x50}, {0x87,0x51},
    {0x87,0x52}, {0x87,0x53}, {0x87,0x54}, {0x87,0x55}, {0x87,0x56}, {0x87,0x57}, {0x87,0x58}, {0x87,0x59}, {0x87,0x5a}, {0x87,0x5b},
    {0x87,0x5c}, {0x87,0x5d}, {0x87,0x5e}, {0x87,0x5f}, {0x87,0x60}, {0x87,0x61}, {0x87,0x62}, {0x87,0x63}, {0x87,0x64}, {0x87,0x65},
    {0x87,0x66}, {0x87,0x67}, {0x87,0x68}, {0x87,0x69}, {0x87,0x6a}, {0x87,0x6b}, {0x87,0x6c}, {0x87,0x6d}, {0x87,0x6e}, {0x87,0x6f},
    {0x87,0x70}, {0x87,0x71}, {0x87,0x72}, {0x87,0x73}, {0x87,0x74}, {0x87,0x75}, {0x87,0x76}, {0x87,0x77}, {0x87,0x78}, {0x87,0x79},
    {0x87,0x7a}, {0x87,0x7b}, {0x87,0x7c}, {0x87,0x7d}, {0x87,0x7e}, {0x87,0xa1}, {0x87,0xa2}, {0x87,0xa3}, {0x87,0xa4}, {0x87,0xa5},
    {0x87,0xa6}, {0x87,0xa7}, {0x87,0xa8}, {0x87,0xa9}, {0x87,0xaa}, {0x87,0xab}, {0x87,0xac}, {0x87,0xad}, {0x87,0xae}, {0x87,0xaf},
    {0x87,0xb0}, {0x87,0xb1}, {0x87,0xb2}, {0x87,0xb3}, {0x87,0xb4}, {0x87,0xb5}, {0x87,0xb6}, {0x87,0xb7}, {0x87,0xb8}, {0x87,0xb9},
    {0x87,0xba}, {0x87,0xbb}, {0x87,0xbc}, {0x87,0xbd}, {0x87,0xbe}, {0x87,0xbf}, {0x87,0xc0}, {0x87,0xc1}, {0x87,0xc2}, {0x87,0xc3},
    {0x87,0xc4}, {0x87,0xc5}, {0x87,0xc6}, {0x87,0xc7}, {0x87,0xc8}, {0x87,0xc9}, {0x87,0xca}, {0x87,0xcb}, {0x87,0xcc}, {0x87,0xcd},
    {0x87,0xce}, {0x87,0xcf}, {0x87,0xd0}, {0x87,0xd1}, {0x87,0xd2}, {0x87,0xd3}, {0x87,0xd4}, {0x87,0xd5}, {0x87,0xd6}, {0x87,0xd7},
    {0x87,0xd8}, {0x87,0xd9}, {0x87,0xda}, {0x87,0xdb}, {0x87,0xdc}, {0x87,0xdd}, {0x87,0xde}, {0x87,0xdf}, {0x87,0xe0}, {0x87,0xe1},
    {0x87,0xe2}, {0x87,0xe3}, {0x87,0xe4}, {0x87,0xe5}, {0x87,0xe6}, {0x87,0xe7}, {0x87,0xe8}, {0x87,0xe9}, {0x87,0xea}, {0x87,0xeb},
    {0x87,0xec}, {0x87,0xed}, {0x87,0xee}, {0x87,0xef}, {0x87,0xf0}, {0x87,0xf1}, {0x87,0xf2}, {0x87,0xf3}, {0x87,0xf4}, {0x87,0xf5},
    {0x87,0xf6}, {0x87,0xf7}, {0x87,0xf8}, {0x87,0xf9}, {0x87,0xfa}, {0x87,0xfb}, {0x87,0xfc}, {0x87,0xfd}, {0x87,0xfe}, {0x88,0x40},
    {0x88,0x41}, {0x88,0x42}, {0x88,0x43}, {0x88,0x44}, {0x88,0x45}, {0x88,0x46}, {0x88,0x47}, {0x88,0x48}, {0x88,0x49}, {0x88,0x4a},
    {0x88,0x4b}, {0x88,0x4c}, {0x88,0x4d}, {0x88,0x4e}, {0x88,0x4f}, {0x88,0x50}, {0x88,0x51}, {0x88,0x52}, {0x88,0x53}, {0x88,0x54},
    {0x88,0x55}, {0x88,0x56}, {0x88,0x57}, {0x88,0x58}, {0x88,0x59}, {0x88,0x5a}, {0x88,0x5b}, {0x88,0x5c}, {0x88,0x5d}, {0x88,0x5e},
    {0x88,0x5f}, {0x88,0x60}, {0x88,0x61}, {0x88,0x62}, {0x88,0x63}, {0x88,0x64}, {0x88,0x65}, {0x88,0x66}, {0x88,0x67}, {0x88,0x68},
    {0x88,0x69}, {0x88,0x6a}, {0x88,0x6b}, {0x88,0x6c}, {0x88,0x6d}, {0x88,0x6e}, {0x88,0x6f}, {0x88,0x70}, {0x88,0x71}, {0x88,0x72},
    {0x88,0x73}, {0x88,0x74}, {0x88,0x75}, {0x88,0x76}, {0x88,0x77}, {0x88,0x78}, {0x88,0x79}, {0x88,0x7a}, {0x88,0x7b}, {0x88,0x7c},
    {0x88,0x7d}, {0x88,0x7e}, {0x88,0xa1}, {0x88,0xa2}, {0x88,0xa3}, {0x88,0xa4}, {0x88,0xa5}, {0x88,0xa6}, {0x88,0xa7}, {0x88,0xa8},
    {0x88,0xa9}, {0x88,0xaa}, {0x88,0xab}, {0x88,0xac}, {0x88,0xad}, {0x88,0xae}, {0x88,0xaf}, {0x88,0xb0}, {0x88,0xb1}, {0x88,0xb2},
    {0x88,0xb3}, {0x88,0xb4}, {0x88,0xb5}, {0x88,0xb6}, {0x88,0xb7}, {0x88,0xb8}, {0x88,0xb9}, {0x88,0xba}, {0x88,0xbb}, {0x88,0xbc},
    {0x88,0xbd}, {0x88,0xbe}, {0x88,0xbf}, {0x88,0xc0}, {0x88,0xc1}, {0x88,0xc2}, {0x88,0xc3}, {0x88,0xc4}, {0x88,0xc5}, {0x88,0xc6},
    {0x88,0xc7}, {0x88,0xc8}, {0x88,0xc9}, {0x88,0xca}, {0x88,0xcb}, {0x88,0xcc}, {0x88,0xcd}, {0x88,0xce}, {0x88,0xcf}, {0x88,0xd0},
    {0x88,0xd1}, {0x88,0xd2}, {0x88,0xd3}, {0x88,0xd4}, {0x88,0xd5}, {0x88,0xd6}, {0x88,0xd7}, {0x88,0xd8}, {0x88,0xd9}, {0x88,0xda},
    {0x88,0xdb}, {0x88,0xdc}, {0x88,0xdd}, {0x88,0xde}, {0x88,0xdf}, {0x88,0xe0}, {0x88,0xe1}, {0x88,0xe2}, {0x88,0xe3}, {0x88,0xe4},
    {0x88,0xe5}, {0x88,0xe6}, {0x88,0xe7}, {0x88,0xe8}, {0x88,0xe9}, {0x88,0xea}, {0x88,0xeb}, {0x88,0xec}, {0x88,0xed}, {0x88,0xee},
    {0x88,0xef}, {0x88,0xf0}, {0x88,0xf1}, {0x88,0xf2}, {0x88,0xf3}, {0x88,0xf4}, {0x88,0xf5}, {0x88,0xf6}, {0x88,0xf7}, {0x88,0xf8},
    {0x88,0xf9}, {0x88,0xfa}, {0x88,0xfb}, {0x88,0xfc}, {0x88,0xfd}, {0x88,0xfe}, {0x89,0x40}, {0x89,0x41}, {0x89,0x42}, {0x89,0x43},
    {0x89,0x44}, {0x89,0x45}, {0x89,0x46}, {0x89,0x47}, {0x89,0x48}, {0x89,0x49}, {0x89,0x4a}, {0x89,0x4b}, {0x89,0x4c}, {0x89,0x4d},
    {0x89,0x4e}, {0x89,0x4f}, {0x89,0x50}, {0x89,0x51}, {0x89,0x52}, {0x89,0x53}, {0x89,0x54}, {0x89,0x55}, {0x89,0x56}, {0x89,0x57},
    {0x89,0x58}, {0x89,0x59}, {0x89,0x5a}, {0x89,0x5b}, {0x89,0x5c}, {0x89,0x5d}, {0x89,0x5e}, {0x89,0x5f}, {0x89,0x60}, {0x89,0x61},
    {0x89,0x62}, {0x89,0x63}, {0x89,0x64}, {0x89,0x65}, {0x89,0x66}, {0x89,0x67}, {0x89,0x68}, {0x89,0x69}, {0x89,0x6a}, {0x89,0x6b},
    {0x89,0x6c}, {0x89,0x6d}, {0x89,0x6e}, {0x89,0x6f}, {0x89,0x70}, {0x89,0x71}, {0x89,0x72}, {0x89,0x73}, {0x89,0x74}, {0x89,0x75},
    {0x89,0x76}, {0x89,0x77}, {0x89,0x78}, {0x89,0x79}, {0x89,0x7a}, {0x89,0x7b}, {0x89,0x7c}, {0x89,0x7d}, {0x89,0x7e}, {0x89,0xa1},
    {0x89,0xa2}, {0x89,0xa3}, {0x89,0xa4}, {0x89,0xa5}, {0x89,0xa6}, {0x89,0xa7}, {0x89,0xa8}, {0x89,0xa9}, {0x89,0xaa}, {0x89,0xab},
    {0x89,0xac}, {0x89,0xad}, {0x89,0xae}, {0x89,0xaf}, {0x89,0xb0}, {0x89,0xb1}, {0x89,0xb2}, {0x89,0xb3}, {0x89,0xb4}, {0x89,0xb5},
    {0x89,0xb6}, {0x89,0xb7}, {0x89,0xb8}, {0x89,0xb9}, {0x89,0xba}, {0x89,0xbb}, {0x89,0xbc}, {0x89,0xbd}, {0x89,0xbe}, {0x89,0xbf},
    {0x89,0xc0}, {0x89,0xc1}, {0x89,0xc2}, {0x89,0xc3}, {0x89,0xc4}, {0x89,0xc5}, {0x89,0xc6}, {0x89,0xc7}, {0x89,0xc8}, {0x89,0xc9},
    {0x89,0xca}, {0x89,0xcb}, {0x89,0xcc}, {0x89,0xcd}, {0x89,0xce}, {0x89,0xcf}, {0x89,0xd0}, {0x89,0xd1}, {0x89,0xd2}, {0x89,0xd3},
    {0x89,0xd4}, {0x89,0xd5}, {0x89,0xd6}, {0x89,0xd7}, {0x89,0xd8}, {0x89,0xd9}, {0x89,0xda}, {0x89,0xdb}, {0x89,0xdc}, {0x89,0xdd},
    {0x89,0xde}, {0x89,0xdf}, {0x89,0xe0}, {0x89,0xe1}, {0x89,0xe2}, {0x89,0xe3}, {0x89,0xe4}, {0x89,0xe5}, {0x89,0xe6}, {0x89,0xe7},
    {0x89,0xe8}, {0x89,0xe9}, {0x89,0xea}, {0x89,0xeb}, {0x89,0xec}, {0x89,0xed}, {0x89,0xee}, {0x89,0xef}, {0x89,0xf0}, {0x89,0xf1},
    {0x89,0xf2}, {0x89,0xf3}, {0x89,0xf4}, {0x89,0xf5}, {0x89,0xf6}, {0x89,0xf7}, {0x89,0xf8}, {0x89,0xf9}, {0x89,0xfa}, {0x89,0xfb},
    {0x89,0xfc}, {0x89,0xfd}, {0x89,0xfe}, {0x8a,0x40}, {0x8a,0x41}, {0x8a,0x42}, {0x8a,0x43}, {0x8a,0x44}, {0x8a,0x45}, {0x8a,0x46},
    {0x8a,0x47}, {0x8a,0x48}, {0x8a,0x49}, {0x8a,0x4a}, {0x8a,0x4b}, {0x8a,0x4c}, {0x8a,0x4d}, {0x8a,0x4e}, {0x8a,0x4f}, {0x8a,0x50},
    {0x8a,0x51}, {0x8a,0x52}, {0x8a,0x53}, {0x8a,0x54}, {0x8a,0x55}, {0x8a,0x56}, {0x8a,0x57}, {0x8a,0x58}, {0x8a,0x59}, {0x8a,0x5a},
    {0x8a,0x5b}, {0x8a,0x5c}, {0x8a,0x5d}, {0x8a,0x5e}, {0x8a,0x5f}, {0x8a,0x60}, {0x8a,0x61}, {0x8a,0x62}, {0x8a,0x63}, {0x8a,0x64},
    {0x8a,0x65}, {0x8a,0x66}, {0x8a,0x67}, {0x8a,0x68}, {0x8a,0x69}, {0x8a,0x6a}, {0x8a,0x6b}, {0x8a,0x6c}, {0x8a,0x6d}, {0x8a,0x6e},
    {0x8a,0x6f}, {0x8a,0x70}, {0x8a,0x71}, {0x8a,0x72}, {0x8a,0x73}, {0x8a,0x74}, {0x8a,0x75}, {0x8a,0x76}, {0x8a,0x77}, {0x8a,0x78},
    {0x8a,0x79}, {0x8a,0x7a}, {0x8a,0x7b}, {0x8a,0x7c}, {0x8a,0x7d}, {0x8a,0x7e}, {0x8a,0xa1}, {0x8a,0xa2}, {0x8a,0xa3}, {0x8a,0xa4},
    {0x8a,0xa5}, {0x8a,0xa6}, {0x8a,0xa7}, {0x8a,0xa8}, {0x8a,0xa9}, {0x8a,0xaa}, {0x8a,0xab}, {0x8a,0xac}, {0x8a,0xad}, {0x8a,0xae},
    {0x8a,0xaf}, {0x8a,0xb0}, {0x8a,0xb1}, {0x8a,0xb2}, {0x8a,0xb3}, {0x8a,0xb4}, {0x8a,0xb5}, {0x8a,0xb6}, {0x8a,0xb7}, {0x8a,0xb8},
    {0x8a,0xb9}, {0x8a,0xba}, {0x8a,0xbb}, {0x8a,0xbc}, {0x8a,0xbd}, {0x8a,0xbe}, {0x8a,0xbf}, {0x8a,0xc0}, {0x8a,0xc1}, {0x8a,0xc2},
    {0x8a,0xc3}, {0x8a,0xc4}, {0x8a,0xc5}, {0x8a,0xc6}, {0x8a,0xc7}, {0x8a,0xc8}, {0x8a,0xc9}, {0x8a,0xca}, {0x8a,0xcb}, {0x8a,0xcc},
    {0x8a,0xcd}, {0x8a,0xce}, {0x8a,0xcf}, {0x8a,0xd0}, {0x8a,0xd1}, {0x8a,0xd2}, {0x8a,0xd3}, {0x8a,0xd4}, {0x8a,0xd5}, {0x8a,0xd6},
    {0x8a,0xd7}, {0x8a,0xd8}, {0x8a,0xd9}, {0x8a,0xda}, {0x8a,0xdb}, {0x8a,0xdc}, {0x8a,0xdd}, {0x8a,0xde}, {0x8a,0xdf}, {0x8a,0xe0},
    {0x8a,0xe1}, {0x8a,0xe2}, {0x8a,0xe3}, {0x8a,0xe4}, {0x8a,0xe5}, {0x8a,0xe6}, {0x8a,0xe7}, {0x8a,0xe8}, {0x8a,0xe9}, {0x8a,0xea},
    {0x8a,0xeb}, {0x8a,0xec}, {0x8a,0xed}, {0x8a,0xee}, {0x8a,0xef}, {0x8a,0xf0}, {0x8a,0xf1}, {0x8a,0xf2}, {0x8a,0xf3}, {0x8a,0xf4},
    {0x8a,0xf5}, {0x8a,0xf6}, {0x8a,0xf7}, {0x8a,0xf8}, {0x8a,0xf9}, {0x8a,0xfa}, {0x8a,0xfb}, {0x8a,0xfc}, {0x8a,0xfd}, {0x8a,0xfe},
    {0x8b,0x40}, {0x8b,0x41}, {0x8b,0x42}, {0x8b,0x43}, {0x8b,0x44}, {0x8b,0x45}, {0x8b,0x46}, {0x8b,0x47}, {0x8b,0x48}, {0x8b,0x49},
    {0x8b,0x4a}, {0x8b,0x4b}, {0x8b,0x4c}, {0x8b,0x4d}, {0x8b,0x4e}, {0x8b,0x4f}, {0x8b,0x50}, {0x8b,0x51}, {0x8b,0x52}, {0x8b,0x53},
    {0x8b,0x54}, {0x8b,0x55}, {0x8b,0x56}, {0x8b,0x57}, {0x8b,0x58}, {0x8b,0x59}, {0x8b,0x5a}, {0x8b,0x5b}, {0x8b,0x5c}, {0x8b,0x5d},
    {0x8b,0x5e}, {0x8b,0x5f}, {0x8b,0x60}, {0x8b,0x61}, {0x8b,0x62}, {0x8b,0x63}, {0x8b,0x64}, {0x8b,0x65}, {0x8b,0x66}, {0x8b,0x67},
    {0x8b,0x68}, {0x8b,0x69}, {0x8b,0x6a}, {0x8b,0x6b}, {0x8b,0x6c}, {0x8b,0x6d}, {0x8b,0x6e}, {0x8b,0x6f}, {0x8b,0x70}, {0x8b,0x71},
    {0x8b,0x72}, {0x8b,0x73}, {0x8b,0x74}, {0x8b,0x75}, {0x8b,0x76}, {0x8b,0x77}, {0x8b,0x78}, {0x8b,0x79}, {0x8b,0x7a}, {0x8b,0x7b},
    {0x8b,0x7c}, {0x8b,0x7d}, {0x8b,0x7e}, {0x8b,0xa1}, {0x8b,0xa2}, {0x8b,0xa3}, {0x8b,0xa4}, {0x8b,0xa5}, {0x8b,0xa6}, {0x8b,0xa7},
    {0x8b,0xa8}, {0x8b,0xa9}, {0x8b,0xaa}, {0x8b,0xab}, {0x8b,0xac}, {0x8b,0xad}, {0x8b,0xae}, {0x8b,0xaf}, {0x8b,0xb0}, {0x8b,0xb1},
    {0x8b,0xb2}, {0x8b,0xb3}, {0x8b,0xb4}, {0x8b,0xb5}, {0x8b,0xb6}, {0x8b,0xb7}, {0x8b,0xb8}, {0x8b,0xb9}, {0x8b,0xba}, {0x8b,0xbb},
    {0x8b,0xbc}, {0x8b,0xbd}, {0x8b,0xbe}, {0x8b,0xbf}, {0x8b,0xc0}, {0x8b,0xc1}, {0x8b,0xc2}, {0x8b,0xc3}, {0x8b,0xc4}, {0x8b,0xc5},
    {0x8b,0xc6}, {0x8b,0xc7}, {0x8b,0xc8}, {0x8b,0xc9}, {0x8b,0xca}, {0x8b,0xcb}, {0x8b,0xcc}, {0x8b,0xcd}, {0x8b,0xce}, {0x8b,0xcf},
    {0x8b,0xd0}, {0x8b,0xd1}, {0x8b,0xd2}, {0x8b,0xd3}, {0x8b,0xd4}, {0x8b,0xd5}, {0x8b,0xd6}, {0x8b,0xd7}, {0x8b,0xd8}, {0x8b,0xd9},
    {0x8b,0xda}, {0x8b,0xdb}, {0x8b,0xdc}, {0x8b,0xdd}, {0x8b,0xde}, {0x8b,0xdf}, {0x8b,0xe0}, {0x8b,0xe1}, {0x8b,0xe2}, {0x8b,0xe3},
    {0x8b,0xe4}, {0x8b,0xe5}, {0x8b,0xe6}, {0x8b,0xe7}, {0x8b,0xe8}, {0x8b,0xe9}, {0x8b,0xea}, {0x8b,0xeb}, {0x8b,0xec}, {0x8b,0xed},
    {0x8b,0xee}, {0x8b,0xef}, {0x8b,0xf0}, {0x8b,0xf1}, {0x8b,0xf2}, {0x8b,0xf3}, {0x8b,0xf4}, {0x8b,0xf5}, {0x8b,0xf6}, {0x8b,0xf7},
    {0x8b,0xf8}, {0x8b,0xf9}, {0x8b,0xfa}, {0x8b,0xfb}, {0x8b,0xfc}, {0x8b,0xfd}, {0x8b,0xfe}, {0x8c,0x40}, {0x8c,0x41}, {0x8c,0x42},
    {0x8c,0x43}, {0x8c,0x44}, {0x8c,0x45}, {0x8c,0x46}, {0x8c,0x47}, {0x8c,0x48}, {0x8c,0x49}, {0x8c,0x4a}, {0x8c,0x4b}, {0x8c,0x4c},
    {0x8c,0x4d}, {0x8c,0x4e}, {0x8c,0x4f}, {0x8c,0x50}, {0x8c,0x51}, {0x8c,0x52}, {0x8c,0x53}, {0x8c,0x54}, {0x8c,0x55}, {0x8c,0x56},
    {0x8c,0x57}, {0x8c,0x58}, {0x8c,0x59}, {0x8c,0x5a}, {0x8c,0x5b}, {0x8c,0x5c}, {0x8c,0x5d}, {0x8c,0x5e}, {0x8c,0x5f}, {0x8c,0x60},
    {0x8c,0x61}, {0x8c,0x62}, {0x8c,0x63}, {0x8c,0x64}, {0x8c,0x65}, {0x8c,0x66}, {0x8c,0x67}, {0x8c,0x68}, {0x8c,0x69}, {0x8c,0x6a},
    {0x8c,0x6b}, {0x8c,0x6c}, {0x8c,0x6d}, {0x8c,0x6e}, {0x8c,0x6f}, {0x8c,0x70}, {0x8c,0x71}, {0x8c,0x72}, {0x8c,0x73}, {0x8c,0x74},
    {0x8c,0x75}, {0x8c,0x76}, {0x8c,0x77}, {0x8c,0x78}, {0x8c,0x79}, {0x8c,0x7a}, {0x8c,0x7b}, {0x8c,0x7c}, {0x8c,0x7d}, {0x8c,0x7e},
    {0x8c,0xa1}, {0x8c,0xa2}, {0x8c,0xa3}, {0x8c,0xa4}, {0x8c,0xa5}, {0x8c,0xa6}, {0x8c,0xa7}, {0x8c,0xa8}, {0x8c,0xa9}, {0x8c,0xaa},
    {0x8c,0xab}, {0x8c,0xac}, {0x8c,0xad}, {0x8c,0xae}, {0x8c,0xaf}, {0x8c,0xb0}, {0x8c,0xb1}, {0x8c,0xb2}, {0x8c,0xb3}, {0x8c,0xb4},
    {0x8c,0xb5}, {0x8c,0xb6}, {0x8c,0xb7}, {0x8c,0xb8}, {0x8c,0xb9}, {0x8c,0xba}, {0x8c,0xbb}, {0x8c,0xbc}, {0x8c,0xbd}, {0x8c,0xbe},
    {0x8c,0xbf}, {0x8c,0xc0}, {0x8c,0xc1}, {0x8c,0xc2}, {0x8c,0xc3}, {0x8c,0xc4}, {0x8c,0xc5}, {0x8c,0xc6}, {0x8c,0xc7}, {0x8c,0xc8},
    {0x8c,0xc9}, {0x8c,0xca}, {0x8c,0xcb}, {0x8c,0xcc}, {0x8c,0xcd}, {0x8c,0xce}, {0x8c,0xcf}, {0x8c,0xd0}, {0x8c,0xd1}, {0x8c,0xd2},
    {0x8c,0xd3}, {0x8c,0xd4}, {0x8c,0xd5}, {0x8c,0xd6}, {0x8c,0xd7}, {0x8c,0xd8}, {0x8c,0xd9}, {0x8c,0xda}, {0x8c,0xdb}, {0x8c,0xdc},
    {0x8c,0xdd}, {0x8c,0xde}, {0x8c,0xdf}, {0x8c,0xe0}, {0x8c,0xe1}, {0x8c,0xe2}, {0x8c,0xe3}, {0x8c,0xe4}, {0x8c,0xe5}, {0x8c,0xe6},
    {0x8c,0xe7}, {0x8c,0xe8}, {0x8c,0xe9}, {0x8c,0xea}, {0x8c,0xeb}, {0x8c,0xec}, {0x8c,0xed}, {0x8c,0xee}, {0x8c,0xef}, {0x8c,0xf0},
    {0x8c,0xf1}, {0x8c,0xf2}, {0x8c,0xf3}, {0x8c,0xf4}, {0x8c,0xf5}, {0x8c,0xf6}, {0x8c,0xf7}, {0x8c,0xf8}, {0x8c,0xf9}, {0x8c,0xfa},
    {0x8c,0xfb}, {0x8c,0xfc}, {0x8c,0xfd}, {0x8c,0xfe}, {0x8d,0x40}, {0x8d,0x41}, {0x8d,0x42}, {0x8d,0x43}, {0x8d,0x44}, {0x8d,0x45},
    {0x8d,0x46}, {0x8d,0x47}, {0x8d,0x48}, {0x8d,0x49}, {0x8d,0x4a}, {0x8d,0x4b}, {0x8d,0x4c}, {0x8d,0x4d}, {0x8d,0x4e}, {0x8d,0x4f},
    {0x8d,0x50}, {0x8d,0x51}, {0x8d,0x52}, {0x8d,0x53}, {0x8d,0x54}, {0x8d,0x55}, {0x8d,0x56}, {0x8d,0x57}, {0x8d,0x58}, {0x8d,0x59},
    {0x8d,0x5a}, {0x8d,0x5b}, {0x8d,0x5c}, {0x8d,0x5d}, {0x8d,0x5e}, {0x8d,0x5f}, {0x8d,0x60}, {0x8d,0x61}, {0x8d,0x62}, {0x8d,0x63},
    {0x8d,0x64}, {0x8d,0x65}, {0x8d,0x66}, {0x8d,0x67}, {0x8d,0x68}, {0x8d,0x69}, {0x8d,0x6a}, {0x8d,0x6b}, {0x8d,0x6c}, {0x8d,0x6d},
    {0x8d,0x6e}, {0x8d,0x6f}, {0x8d,0x70}, {0x8d,0x71}, {0x8d,0x72}, {0x8d,0x73}, {0x8d,0x74}, {0x8d,0x75}, {0x8d,0x76}, {0x8d,0x77},
    {0x8d,0x78}, {0x8d,0x79}, {0x8d,0x7a}, {0x8d,0x7b}, {0x8d,0x7c}, {0x8d,0x7d}, {0x8d,0x7e}, {0x8d,0xa1}, {0x8d,0xa2}, {0x8d,0xa3},
    {0x8d,0xa4}, {0x8d,0xa5}, {0x8d,0xa6}, {0x8d,0xa7}, {0x8d,0xa8}, {0x8d,0xa9}, {0x8d,0xaa}, {0x8d,0xab}, {0x8d,0xac}, {0x8d,0xad},
    {0x8d,0xae}, {0x8d,0xaf}, {0x8d,0xb0}, {0x8d,0xb1}, {0x8d,0xb2}, {0x8d,0xb3}, {0x8d,0xb4}, {0x8d,0xb5}, {0x8d,0xb6}, {0x8d,0xb7},
    {0x8d,0xb8}, {0x8d,0xb9}, {0x8d,0xba}, {0x8d,0xbb}, {0x8d,0xbc}, {0x8d,0xbd}, {0x8d,0xbe}, {0x8d,0xbf}, {0x8d,0xc0}, {0x8d,0xc1},
    {0x8d,0xc2}, {0x8d,0xc3}, {0x8d,0xc4}, {0x8d,0xc5}, {0x8d,0xc6}, {0x8d,0xc7}, {0x8d,0xc8}, {0x8d,0xc9}, {0x8d,0xca}, {0x8d,0xcb},
    {0x8d,0xcc}, {0x8d,0xcd}, {0x8d,0xce}, {0x8d,0xcf}, {0x8d,0xd0}, {0x8d,0xd1}, {0x8d,0xd2}, {0x8d,0xd3}, {0x8d,0xd4}, {0x8d,0xd5},
    {0x8d,0xd6}, {0x8d,0xd7}, {0x8d,0xd8}, {0x8d,0xd9}, {0x8d,0xda}, {0x8d,0xdb}, {0x8d,0xdc}, {0x8d,0xdd}, {0x8d,0xde}, {0x8d,0xdf},
    {0x8d,0xe0}, {0x8d,0xe1}, {0x8d,0xe2}, {0x8d,0xe3}, {0x8d,0xe4}, {0x8d,0xe5}, {0x8d,0xe6}, {0x8d,0xe7}, {0x8d,0xe8}, {0x8d,0xe9},
    {0x8d,0xea}, {0x8d,0xeb}, {0x8d,0xec}, {0x8d,0xed}, {0x8d,0xee}, {0x8d,0xef}, {0x8d,0xf0}, {0x8d,0xf1}, {0x8d,0xf2}, {0x8d,0xf3},
    {0x8d,0xf4}, {0x8d,0xf5}, {0x8d,0xf6}, {0x8d,0xf7}, {0x8d,0xf8}, {0x8d,0xf9}, {0x8d,0xfa}, {0x8d,0xfb}, {0x8d,0xfc}, {0x8d,0xfd},
    {0x8d,0xfe}, {0xc6,0xa1}, {0xc6,0xa2}, {0xc6,0xa3}, {0xc6,0xa4}, {0xc6,0xa5}, {0xc6,0xa6}, {0xc6,0xa7}, {0xc6,0xa8}, {0xc6,0xa9},
    {0xc6,0xaa}, {0xc6,0xab}, {0xc6,0xac}, {0xc6,0xad}, {0xc6,0xae}, {0xc6,0xaf}, {0xc6,0xb0}, {0xc6,0xb1}, {0xc6,0xb2}, {0xc6,0xb3},
    {0xc6,0xb4}, {0xc6,0xb5}, {0xc6,0xb6}, {0xc6,0xb7}, {0xc6,0xb8}, {0xc6,0xb9}, {0xc6,0xba}, {0xc6,0xbb}, {0xc6,0xbc}, {0xc6,0xbd},
    {0xc6,0xbe}, {0xc6,0xbf}, {0xc6,0xc0}, {0xc6,0xc1}, {0xc6,0xc2}, {0xc6,0xc3}, {0xc6,0xc4}, {0xc6,0xc5}, {0xc6,0xc6}, {0xc6,0xc7},
    {0xc6,0xc8}, {0xc6,0xc9}, {0xc6,0xca}, {0xc6,0xcb}, {0xc6,0xcc}, {0xc6,0xcd}, {0xc6,0xce}, {0xc6,0xcf}, {0xc6,0xd0}, {0xc6,0xd1},
    {0xc6,0xd2}, {0xc6,0xd3}, {0xc6,0xd4}, {0xc6,0xd5}, {0xc6,0xd6}, {0xc6,0xd7}, {0xc6,0xd8}, {0xc6,0xd9}, {0xc6,0xda}, {0xc6,0xdb},
    {0xc6,0xdc}, {0xc6,0xdd}, {0xc6,0xde}, {0xc6,0xdf}, {0xc6,0xe0}, {0xc6,0xe1}, {0xc6,0xe2}, {0xc6,0xe3}, {0xc6,0xe4}, {0xc6,0xe5},
    {0xc6,0xe6}, {0xc6,0xe7}, {0xc6,0xe8}, {0xc6,0xe9}, {0xc6,0xea}, {0xc6,0xeb}, {0xc6,0xec}, {0xc6,0xed}, {0xc6,0xee}, {0xc6,0xef},
    {0xc6,0xf0}, {0xc6,0xf1}, {0xc6,0xf2}, {0xc6,0xf3}, {0xc6,0xf4}, {0xc6,0xf5}, {0xc6,0xf6}, {0xc6,0xf7}, {0xc6,0xf8}, {0xc6,0xf9},
    {0xc6,0xfa}, {0xc6,0xfb}, {0xc6,0xfc}, {0xc6,0xfd}, {0xc6,0xfe}, {0xc7,0x40}, {0xc7,0x41}, {0xc7,0x42}, {0xc7,0x43}, {0xc7,0x44},
    {0xc7,0x45}, {0xc7,0x46}, {0xc7,0x47}, {0xc7,0x48}, {0xc7,0x49}, {0xc7,0x4a}, {0xc7,0x4b}, {0xc7,0x4c}, {0xc7,0x4d}, {0xc7,0x4e},
    {0xc7,0x4f}, {0xc7,0x50}, {0xc7,0x51}, {0xc7,0x52}, {0xc7,0x53}, {0xc7,0x54}, {0xc7,0x55}, {0xc7,0x56}, {0xc7,0x57}, {0xc7,0x58},
    {0xc7,0x59}, {0xc7,0x5a}, {0xc7,0x5b}, {0xc7,0x5c}, {0xc7,0x5d}, {0xc7,0x5e}, {0xc7,0x5f}, {0xc7,0x60}, {0xc7,0x61}, {0xc7,0x62},
    {0xc7,0x63}, {0xc7,0x64}, {0xc7,0x65}, {0xc7,0x66}, {0xc7,0x67}, {0xc7,0x68}, {0xc7,0x69}, {0xc7,0x6a}, {0xc7,0x6b}, {0xc7,0x6c},
    {0xc7,0x6d}, {0xc7,0x6e}, {0xc7,0x6f}, {0xc7,0x70}, {0xc7,0x71}, {0xc7,0x72}, {0xc7,0x73}, {0xc7,0x74}, {0xc7,0x75}, {0xc7,0x76},
    {0xc7,0x77}, {0xc7,0x78}, {0xc7,0x79}, {0xc7,0x7a}, {0xc7,0x7b}, {0xc7,0x7c}, {0xc7,0x7d}, {0xc7,0x7e}, {0xc7,0xa1}, {0xc7,0xa2},
    {0xc7,0xa3}, {0xc7,0xa4}, {0xc7,0xa5}, {0xc7,0xa6}, {0xc7,0xa7}, {0xc7,0xa8}, {0xc7,0xa9}, {0xc7,0xaa}, {0xc7,0xab}, {0xc7,0xac},
    {0xc7,0xad}, {0xc7,0xae}, {0xc7,0xaf}, {0xc7,0xb0}, {0xc7,0xb1}, {0xc7,0xb2}, {0xc7,0xb3}, {0xc7,0xb4}, {0xc7,0xb5}, {0xc7,0xb6},
    {0xc7,0xb7}, {0xc7,0xb8}, {0xc7,0xb9}, {0xc7,0xba}, {0xc7,0xbb}, {0xc7,0xbc}, {0xc7,0xbd}, {0xc7,0xbe}, {0xc7,0xbf}, {0xc7,0xc0},
    {0xc7,0xc1}, {0xc7,0xc2}, {0xc7,0xc3}, {0xc7,0xc4}, {0xc7,0xc5}, {0xc7,0xc6}, {0xc7,0xc7}, {0xc7,0xc8}, {0xc7,0xc9}, {0xc7,0xca},
    {0xc7,0xcb}, {0xc7,0xcc}, {0xc7,0xcd}, {0xc7,0xce}, {0xc7,0xcf}, {0xc7,0xd0}, {0xc7,0xd1}, {0xc7,0xd2}, {0xc7,0xd3}, {0xc7,0xd4},
    {0xc7,0xd5}, {0xc7,0xd6}, {0xc7,0xd7}, {0xc7,0xd8}, {0xc7,0xd9}, {0xc7,0xda}, {0xc7,0xdb}, {0xc7,0xdc}, {0xc7,0xdd}, {0xc7,0xde},
    {0xc7,0xdf}, {0xc7,0xe0}, {0xc7,0xe1}, {0xc7,0xe2}, {0xc7,0xe3}, {0xc7,0xe4}, {0xc7,0xe5}, {0xc7,0xe6}, {0xc7,0xe7}, {0xc7,0xe8},
    {0xc7,0xe9}, {0xc7,0xea}, {0xc7,0xeb}, {0xc7,0xec}, {0xc7,0xed}, {0xc7,0xee}, {0xc7,0xef}, {0xc7,0xf0}, {0xc7,0xf1}, {0xc7,0xf2},
    {0xc7,0xf3}, {0xc7,0xf4}, {0xc7,0xf5}, {0xc7,0xf6}, {0xc7,0xf7}, {0xc7,0xf8}, {0xc7,0xf9}, {0xc7,0xfa}, {0xc7,0xfb}, {0xc7,0xfc},
    {0xc7,0xfd}, {0xc7,0xfe}, {0xc8,0x40}, {0xc8,0x41}, {0xc8,0x42}, {0xc8,0x43}, {0xc8,0x44}, {0xc8,0x45}, {0xc8,0x46}, {0xc8,0x47},
    {0xc8,0x48}, {0xc8,0x49}, {0xc8,0x4a}, {0xc8,0x4b}, {0xc8,0x4c}, {0xc8,0x4d}, {0xc8,0x4e}, {0xc8,0x4f}, {0xc8,0x50}, {0xc8,0x51},
    {0xc8,0x52}, {0xc8,0x53}, {0xc8,0x54}, {0xc8,0x55}, {0xc8,0x56}, {0xc8,0x57}, {0xc8,0x58}, {0xc8,0x59}, {0xc8,0x5a}, {0xc8,0x5b},
    {0xc8,0x5c}, {0xc8,0x5d}, {0xc8,0x5e}, {0xc8,0x5f}, {0xc8,0x60}, {0xc8,0x61}, {0xc8,0x62}, {0xc8,0x63}, {0xc8,0x64}, {0xc8,0x65},
    {0xc8,0x66}, {0xc8,0x67}, {0xc8,0x68}, {0xc8,0x69}, {0xc8,0x6a}, {0xc8,0x6b}, {0xc8,0x6c}, {0xc8,0x6d}, {0xc8,0x6e}, {0xc8,0x6f},
    {0xc8,0x70}, {0xc8,0x71}, {0xc8,0x72}, {0xc8,0x73}, {0xc8,0x74}, {0xc8,0x75}, {0xc8,0x76}, {0xc8,0x77}, {0xc8,0x78}, {0xc8,0x79},
    {0xc8,0x7a}, {0xc8,0x7b}, {0xc8,0x7c}, {0xc8,0x7d}, {0xc8,0x7e}, {0xc8,0xa1}, {0xc8,0xa2}, {0xc8,0xa3}, {0xc8,0xa4}, {0xc8,0xa5},
    {0xc8,0xa6}, {0xc8,0xa7}, {0xc8,0xa8}, {0xc8,0xa9}, {0xc8,0xaa}, {0xc8,0xab}, {0xc8,0xac}, {0xc8,0xad}, {0xc8,0xae}, {0xc8,0xaf},
    {0xc8,0xb0}, {0xc8,0xb1}, {0xc8,0xb2}, {0xc8,0xb3}, {0xc8,0xb4}, {0xc8,0xb5}, {0xc8,0xb6}, {0xc8,0xb7}, {0xc8,0xb8}, {0xc8,0xb9},
    {0xc8,0xba}, {0xc8,0xbb}, {0xc8,0xbc}, {0xc8,0xbd}, {0xc8,0xbe}, {0xc8,0xbf}, {0xc8,0xc0}, {0xc8,0xc1}, {0xc8,0xc2}, {0xc8,0xc3},
    {0xc8,0xc4}, {0xc8,0xc5}, {0xc8,0xc6}, {0xc8,0xc7}, {0xc8,0xc8}, {0xc8,0xc9}, {0xc8,0xca}, {0xc8,0xcb}, {0xc8,0xcc}, {0xc8,0xcd},
    {0xc8,0xce}, {0xc8,0xcf}, {0xc8,0xd0}, {0xc8,0xd1}, {0xc8,0xd2}, {0xc8,0xd3}, {0xc8,0xd4}, {0xc8,0xd5}, {0xc8,0xd6}, {0xc8,0xd7},
    {0xc8,0xd8}, {0xc8,0xd9}, {0xc8,0xda}, {0xc8,0xdb}, {0xc8,0xdc}, {0xc8,0xdd}, {0xc8,0xde}, {0xc8,0xdf}, {0xc8,0xe0}, {0xc8,0xe1},
    {0xc8,0xe2}, {0xc8,0xe3}, {0xc8,0xe4}, {0xc8,0xe5}, {0xc8,0xe6}, {0xc8,0xe7}, {0xc8,0xe8}, {0xc8,0xe9}, {0xc8,0xea}, {0xc8,0xeb},
    {0xc8,0xec}, {0xc8,0xed}, {0xc8,0xee}, {0xc8,0xef}, {0xc8,0xf0}, {0xc8,0xf1}, {0xc8,0xf2}, {0xc8,0xf3}, {0xc8,0xf4}, {0xc8,0xf5},
    {0xc8,0xf6}, {0xc8,0xf7}, {0xc8,0xf8}, {0xc8,0xf9}, {0xc8,0xfa}, {0xc8,0xfb}, {0xc8,0xfc}, {0xc8,0xfd}, {0xc8,0xfe}, {0xff,0x00},
    {0xb0,0x5a}, {0xa7,0xf3}, {0xa8,0xae}, {0xb8,0xeb}, {0xb7,0xc6}, {0xa6,0xea}, {0xa5,0x79}, {0x8b,0xf8}, {0xc0,0x74}, {0xab,0xb4},
    {0xaa,0xf7}, {0xb3,0xe2}, {0xa9,0x60}, {0xc3,0x69}, {0xc4,0xee}, {0xc3,0xb9}, {0xc5,0xda}, {0xc1,0xb3}, {0xbb,0x72}, {0xc5,0xde},
    {0xbc,0xd6}, {0xac,0xa5}, {0xaf,0x4f}, {0xaf,0x5f}, {0xb8,0xa8}, {0xb9,0x54}, {0xc0,0x64}, {0xb6,0xc3}, {0xa7,0x5a}, {0xc4,0xe6},
    {0xc4,0xea}, {0xc4,0xf5}, {0xc6,0x7d}, {0xb4,0x50}, {0xc0,0xdd}, {0xc2,0xc5}, {0xc4,0xb0}, {0xa9,0xd4}, {0xc3,0xbe}, {0xc4,0xfa},
    {0xb4,0x59}, {0xae,0xd4}, {0xae,0xf6}, {0xaf,0x54}, {0xa8,0xd3}, {0xa7,0x4e}, {0xb3,0xd2}, {0xbe,0xdb}, {0xc3,0x72}, {0xc4,0x6c},
    {0xbf,0x63}, {0xa6,0xd1}, {0xc4,0xaa}, {0xb8,0xb8}, {0xb8,0xf4}, {0xc5,0x53}, {0xbe,0x7c}, {0xc6,0x4f}, {0xb8,0x4c}, {0xb8,0x53},
    {0xba,0xf1}, {0xdb,0x77}, {0xbf,0xfd}, {0xb3,0xc0}, {0xbd,0xd7}, {0xc3,0x62}, {0xa7,0xcb}, {0xc5,0xa2}, {0xc5,0xa4}, {0xa8,0x63},
    {0xbd,0x55}, {0xb8,0xef}, {0xb9,0x70}, {0xc2,0x53}, {0xb9,0xf0}, {0xbc,0xd3}, {0xb2,0x5c}, {0xba,0x7c}, {0xb2,0xd6}, {0xc1,0x5c},
    {0xad,0xae}, {0xb0,0xc7}, {0xa6,0xd8}, {0xbb,0xfe}, {0xad,0xe2}, {0xb8,0x57}, {0xba,0xf0}, {0xb5,0xd9}, {0xb3,0xae}, {0xc5,0xaa},
    {0xce,0xd4}, {0xbc,0xd6}, {0xbf,0xd5}, {0xa4,0xa6}, {0xb9,0xe7}, {0xab,0xe3}, {0xb2,0x76}, {0xb2,0xa7}, {0xa5,0x5f}, {0xed,0xa8},
    {0xab,0x4b}, {0xb4,0x5f}, {0xa4,0xa3}, {0xaa,0x63}, {0xbc,0xc6}, {0xaf,0xc1}, {0xb0,0xd1}, {0xb6,0xeb}, {0xac,0xd9}, {0xb8,0xad},
    {0xbb,0xa1}, {0xb1,0xfe}, {0xa8,0xb0}, {0xa8,0x48}, {0xac,0x42}, {0xad,0x59}, {0xb1,0xb0}, {0xb2,0xa4}, {0xab,0x47}, {0xa8,0xe2},
    {0xb1,0xe7}, {0xc2,0xb3}, {0xa8,0x7d}, {0xbd,0xcc}, {0xb6,0x71}, {0xc0,0x79}, {0xa7,0x66}, {0xa4,0x6b}, {0xc3,0x66}, {0xae,0xc8},
    {0xc2,0x6f}, {0xc4,0x72}, {0xbe,0x5b}, {0xc6,0x7a}, {0xc4,0x52}, {0xbe,0xa4}, {0xa4,0x4f}, {0xbe,0xe4}, {0xbe,0xfa}, {0xf7,0x65},
    {0xa6,0x7e}, {0xbc,0xa6}, {0xc5,0xca}, {0xbc,0xbf}, {0xba,0xa7}, {0xb7,0xd2}, {0xe6,0xa3}, {0xbd,0x6d}, {0xc1,0x70}, {0xbd,0xfb},
    {0xbd,0xac}, {0xb3,0x73}, {0xc1,0xe5}, {0xa6,0x43}, {0xa6,0x48}, {0xab,0x7c}, {0xaf,0x50}, {0xb5,0xf5}, {0xbb,0xa1}, {0xb7,0x47},
    {0xa9,0xc0}, {0xb1,0xc9}, {0xc0,0xd4}, {0xc3,0xae}, {0xc2,0x79}, {0xa5,0x4f}, {0xcb,0xf1}, {0xb9,0xe7}, {0xc0,0xad}, {0xcc,0xb0},
    {0xac,0xc2}, {0xbc,0xfc}, {0xb2,0xdc}, {0xb2,0xe2}, {0xb9,0x61}, {0xb9,0x73}, {0xc6,0x46}, {0xbb,0xe2}, {0xa8,0xd2}, {0xc2,0xa7},
    {0xc4,0xbf}, {0xc1,0xf5}, {0xb4,0x63}, {0xa4,0x46}, {0xb9,0xb1}, {0xbc,0x64}, {0xa7,0xbf}, {0xae,0xc6}, {0xbc,0xd6}, {0xbf,0x52},
    {0xc0,0xf8}, {0xe7,0x64}, {0xbf,0xf1}, {0xc0,0x73}, {0xb7,0x77}, {0xa8,0xbf}, {0xbc,0x42}, {0xcc,0xd8}, {0xac,0x68}, {0xac,0x79},
    {0xb7,0xc8}, {0xaf,0x5b}, {0xaf,0x64}, {0xb2,0xb8}, {0xaf,0xc3}, {0xc3,0xfe}, {0xa4,0xbb}, {0xbc,0xae}, {0xb3,0xb0}, {0xad,0xdb},
    {0xb1,0x5b}, {0xb2,0x5f}, {0xbd,0xfc}, {0xab,0xdf}, {0xb7,0x58}, {0xae,0xdf}, {0xb2,0x76}, {0xb6,0xa9}, {0xa7,0x51}, {0xa6,0x4f},
    {0xbc,0x69}, {0xa9,0xf6}, {0xa7,0xf5}, {0xb1,0xf9}, {0xaa,0x64}, {0xb2,0x7a}, {0xb5,0x67}, {0xbf,0xa9}, {0xb8,0xcc}, {0xa8,0xbd},
    {0xc2,0xf7}, {0xb0,0xce}, {0xb7,0xc4}, {0xa7,0x5b}, {0xbf,0x4d}, {0xbf,0x5a}, {0xc4,0xa9}, {0xc5,0xec}, {0xc5,0xef}, {0xaa,0x4c},
    {0xb2,0x4f}, {0xc1,0x7b}, {0xa5,0xdf}, {0xb2,0xc1}, {0xb2,0xc9}, {0xaa,0xac}, {0xaa,0xa5}, {0xc3,0xd1}, {0xa4,0xb0}, {0xaf,0xf9},
    {0xa8,0xeb}, {0xa4,0xc1}, {0xab,0xd7}, {0xa9,0xdd}, {0xbf,0x7d}, {0xa6,0x76}, {0xac,0x7d}, {0xbc,0xc9}, {0xbf,0xe7}, {0xa6,0xe6},
    {0xad,0xb0}, {0xa8,0xa3}, {0xb9,0xf8}, {0xc9,0x4a}, {0xdd,0xfc}, {0xb6,0xef}, {0xb4,0xb8}, {0xe8,0xf9}, {0xbd,0xde}, {0xaf,0x71},
    {0xaf,0xab}, {0xb2,0xbb}, {0xba,0xd6}, {0xb9,0x74}, {0xba,0xeb}, {0xa6,0xd0}, {0xbd,0xd1}, {0xb6,0x68}, {0xb3,0xa3}, {0xb6,0xba},
    {0xb9,0x7d}, {0xc0,0x5d}, {0xc5,0x62}, {0xa1,0x4a}, {0xa1,0x57}, {0xa1,0x59}, {0xa1,0x5b}, {0xa1,0x5f}, {0xa1,0x60}, {0xa1,0x63},
    {0xa1,0x64}, {0xa1,0x67}, {0xa1,0x68}, {0xa1,0x6b}, {0xa1,0x6c}, {0xa1,0x6f}, {0xa1,0x70}, {0xa1,0x73}, {0xa1,0x74}, {0xa1,0x77},
    {0xa1,0x78}, {0xa1,0x7b}, {0xa1,0x7c}, {0xa1,0xc6}, {0xa1,0xc7}, {0xa1,0xca}, {0xa1,0xcb}, {0xa1,0xc8}, {0xa1,0xc9}, {0xa1,0x5c},
    {0xa1,0x4d}, {0xa1,0x4e}, {0xa1,0x4f}, {0xa1,0x51}, {0xa1,0x52}, {0xa1,0x53}, {0xa1,0x54}, {0xa1,0x7d}, {0xa1,0x7e}, {0xa1,0xa1},
    {0xa1,0xa2}, {0xa1,0xa3}, {0xa1,0xa4}, {0xa1,0xcc}, {0xa1,0xcd}, {0xa1,0xce}, {0xa1,0xde}, {0xa1,0xdf}, {0xa1,0xe0}, {0xa1,0xe1},
    {0xa1,0xe2}, {0xa2,0x42}, {0xa2,0x4c}, {0xa2,0x4d}, {0xa2,0x4e}, {0xa1,0x49}, {0xc8,0xd0}, {0xa1,0xad}, {0xa2,0x43}, {0xa2,0x48},
    {0xa1,0xae}, {0xc8,0xcf}, {0xa1,0x5d}, {0xa1,0x5e}, {0xa1,0xaf}, {0xa1,0xcf}, {0xa1,0x41}, {0xa1,0xd0}, {0xa1,0x44}, {0xa1,0xfe},
    {0xa2,0xaf}, {0xa2,0xb0}, {0xa2,0xb1}, {0xa2,0xb2}, {0xa2,0xb3}, {0xa2,0xb4}, {0xa2,0xb5}, {0xa2,0xb6}, {0xa2,0xb7}, {0xa2,0xb8},
    {0xa1,0x47}, {0xa1,0x46}, {0xa1,0xd5}, {0xa1,0xd7}, {0xa1,0xd6}, {0xa1,0x48}, {0xa2,0x49}, {0xa2,0xcf}, {0xa2,0xd0}, {0xa2,0xd1},
    {0xa2,0xd2}, {0xa2,0xd3}, {0xa2,0xd4}, {0xa2,0xd5}, {0xa2,0xd6}, {0xa2,0xd7}, {0xa2,0xd8}, {0xa2,0xd9}, {0xa2,0xda}, {0xa2,0xdb},
    {0xa2,0xdc}, {0xa2,0xdd}, {0xa2,0xde}, {0xa2,0xdf}, {0xa2,0xe0}, {0xa2,0xe1}, {0xa2,0xe2}, {0xa2,0xe3}, {0xa2,0xe4}, {0xa2,0xe5},
    {0xa2,0xe6}, {0xa2,0xe7}, {0xa2,0xe8}, {0xc6,0xe4}, {0xa2,0x40}, {0xc6,0xe5}, {0xa1,0x73}, {0xa1,0xc4}, {0xa1,0xa5}, {0xa2,0xe9},
    {0xa2,0xea}, {0xa2,0xeb}, {0xa2,0xec}, {0xa2,0xed}, {0xa2,0xee}, {0xa2,0xef}, {0xa2,0xf0}, {0xa2,0xf1}, {0xa2,0xf2}, {0xa2,0xf3},
    {0xa2,0xf4}, {0xa2,0xf5}, {0xa2,0xf6}, {0xa2,0xf7}, {0xa2,0xf8}, {0xa2,0xf9}, {0xa2,0xfa}, {0xa2,0xfb}, {0xa2,0xfc}, {0xa2,0xfd},
    {0xa2,0xfe}, {0xa3,0x40}, {0xa3,0x41}, {0xa3,0x42}, {0xa3,0x43}, {0xa1,0x61}, {0xa1,0x55}, {0xa1,0x62}, {0xa1,0xe3}, {0xa1,0x4e},
    {0xa2,0x46}, {0xa2,0x47}, {0xc8,0xcd}, {0xa1,0xc3}, {0xc8,0xce}, {0xa2,0x44}, {0xf9,0xfe}, {0x9c,0x71}, {0x93,0x75}, {0x93,0x76},
    {0x95,0x48}, {0x8e,0xc6}, {0x8b,0xc5}, {0x8b,0xfa}, {0xc8,0x7c}, {0x9a,0xb4}, {0x88,0x4e}, {0x88,0x4b}, {0xc8,0x7a}, {0x88,0x48},
    {0x88,0x47}, {0xa0,0xf6}, {0x88,0x45}, {0x88,0x53}, {0xfc,0xad}, {0x8a,0xad}, {0x92,0x72}, {0xfc,0x47}, {0x94,0xdf}, {0x9f,0xd1},
    {0xfb,0xcb}, {0x92,0x7d}, {0x98,0xa4}, {0x94,0xe7}, {0x90,0xcb}, {0x92,0x7b}, {0x94,0xd8}, {0xfc,0x5f}, {0xfa,0x54}, {0x9a,0xb5},
    {0x96,0xda}, {0x92,0x79}, {0xfa,0x74}, {0x92,0x75}, {0x8d,0xfb}, {0x8a,0x49}, {0x92,0xdf}, {0x9b,0x7c}, {0xfa,0x63}, {0xfa,0x60},
    {0x92,0x6d}, {0xfa,0x62}, {0x9a,0xb6}, {0x97,0x6b}, {0xfd,0x6a}, {0xfd,0x54}, {0x92,0x73}, {0x97,0xd8}, {0x9f,0xbb}, {0x93,0x42},
    {0x92,0x76}, {0xfa,0x65}, {0x92,0x6c}, {0xfa,0x6e}, {0x9e,0xe0}, {0x92,0xc0}, {0x92,0xbf}, {0x92,0xbe}, {0x9a,0xba}, {0x8a,0xb3},
    {0x97,0x75}, {0xfa,0x40}, {0xfa,0x76}, {0xfb,0xd0}, {0xfa,0x7b}, {0xfe,0x6d}, {0x9b,0xb3}, {0x89,0xcc}, {0x9a,0xbe}, {0xfa,0x42},
    {0x92,0xbc}, {0x94,0x5c}, {0x9b,0xb5}, {0x9a,0xbf}, {0x98,0xa7}, {0x97,0xa4}, {0x90,0xfd}, {0xfc,0x7b}, {0x9a,0xc0}, {0x92,0xc3},
    {0x8a,0xaa}, {0x9b,0xd0}, {0x95,0x50}, {0x92,0xc6}, {0x98,0xa6}, {0x95,0x46}, {0xfd,0x63}, {0xfa,0xc2}, {0x9e,0xc3}, {0x89,0xb2},
    {0x9c,0x66}, {0x90,0x53}, {0x97,0xc1}, {0x9a,0xc4}, {0x9a,0xc5}, {0x8e,0xef}, {0xfa,0xe9}, {0x92,0x62}, {0x8a,0xf7}, {0x9a,0xc6},
    {0x92,0xe1}, {0x9a,0xc9}, {0xfa,0xc6}, {0x97,0xa5}, {0x9a,0xcb}, {0xfa,0x72}, {0x8a,0x5e}, {0x94,0xe0}, {0x92,0xcc}, {0x8a,0xe5},
    {0xfe,0x5c}, {0x9a,0xcc}, {0x9d,0xf9}, {0x8a,0x43}, {0x8a,0xa6}, {0x9a,0xcd}, {0x9a,0xce}, {0xfa,0xee}, {0x9b,0xcc}, {0x9a,0xcf},
    {0x9a,0xd1}, {0x9d,0xfa}, {0x9d,0x7c}, {0x9a,0xd3}, {0x97,0xa6}, {0x99,0x5f}, {0xfb,0xf6}, {0x9f,0xc5}, {0x8a,0x59}, {0x8b,0x6b},
    {0x9a,0xd4}, {0x9a,0xd5}, {0x97,0xa2}, {0x8a,0x44}, {0x9f,0x4a}, {0x90,0xa1}, {0xfd,0xa4}, {0x8a,0x64}, {0x8a,0xf2}, {0x8a,0xf8},
    {0x9d,0xd8}, {0x94,0xd6}, {0xfa,0xfe}, {0xfb,0xa7}, {0x9a,0xd6}, {0x9f,0x4d}, {0xfa,0xf6}, {0x8a,0x57}, {0x8b,0x43}, {0x8b,0x44},
    {0x8a,0xb6}, {0x8a,0xc0}, {0x9e,0x54}, {0x9a,0xd7}, {0x9a,0xd8}, {0x9a,0xdc}, {0x8a,0xca}, {0x9e,0xa8}, {0x92,0x63}, {0x9a,0xdd},
    {0x8b,0x65}, {0x8b,0x6f}, {0x8b,0x7e}, {0x8f,0x43}, {0x92,0xd0}, {0x8a,0xf4}, {0x9d,0xbe}, {0x9a,0xe1}, {0xfc,0xde}, {0x9d,0xfd},
    {0x8b,0x66}, {0x8b,0x70}, {0x8b,0x75}, {0x8a,0xe4}, {0x8b,0xa4}, {0x8a,0xed}, {0x8a,0x5d}, {0x8b,0x48}, {0x9d,0xed}, {0x9e,0x40},
    {0x8a,0xef}, {0x8a,0xf6}, {0x9e,0x76}, {0x9e,0xe3}, {0x9a,0xde}, {0x8d,0xfe}, {0xfa,0xfc}, {0x9c,0xb1}, {0x9e,0x77}, {0x8b,0x64},
    {0x8b,0x67}, {0x97,0x4b}, {0x96,0x53}, {0x9a,0xe0}, {0x8b,0x4a}, {0x8a,0xf1}, {0x8a,0xd7}, {0xa0,0xab}, {0x8a,0xb5}, {0x8a,0x5f},
    {0x8a,0xee}, {0x9a,0xdf}, {0x8a,0xfe}, {0x8a,0x58}, {0x8b,0xa3}, {0x8b,0xa7}, {0x9a,0xe3}, {0x92,0x61}, {0x9d,0xd7}, {0x9e,0x7d},
    {0x9e,0xa7}, {0x9e,0xab}, {0x90,0x42}, {0x8b,0x79}, {0x8b,0x7a}, {0x9a,0xe6}, {0x9a,0xe5}, {0x8a,0x7e}, {0x9e,0x44}, {0x9a,0xe7},
    {0x8a,0x7c}, {0x8b,0x71}, {0x9a,0xe9}, {0x9a,0xea}, {0x9a,0xeb}, {0x8a,0xbd}, {0xfb,0x4e}, {0x9a,0xed}, {0x8a,0xf9}, {0x9e,0x63},
    {0x8b,0x49}, {0x8a,0xce}, {0x8b,0x6e}, {0x8a,0xe8}, {0x9a,0xee}, {0x92,0xce}, {0x8a,0x5a}, {0x8b,0x7b}, {0x8b,0x7c}, {0x9a,0xef},
    {0x9a,0xf0}, {0x8a,0xfa}, {0x89,0x41}, {0x8b,0x72}, {0x8a,0xf3}, {0x8b,0xa8}, {0x9e,0xae}, {0x9e,0x72}, {0xfb,0x73}, {0xfb,0x5f},
    {0x90,0xba}, {0x91,0xfe}, {0x9e,0xf6}, {0x97,0xed}, {0x9a,0xf3}, {0xa0,0xee}, {0x96,0x7c}, {0x93,0x45}, {0x98,0x6e}, {0xfa,0x56},
    {0x9a,0xf5}, {0xfc,0x4b}, {0x9a,0xf4}, {0xfe,0xde}, {0xfc,0xb7}, {0x97,0xf1}, {0x97,0xc7}, {0x9c,0xcb}, {0x92,0x40}, {0x9c,0xe8},
    {0x91,0xfd}, {0x97,0x4e}, {0xfb,0x68}, {0x97,0x6c}, {0x8c,0xc2}, {0x97,0xe8}, {0xfb,0x6a}, {0x8b,0x74}, {0x8e,0xe7}, {0xfd,0xc8},
    {0x92,0x41}, {0x96,0xa1}, {0x8e,0xf3}, {0x9a,0xf7}, {0x8f,0xa6}, {0xfa,0xd6}, {0x9c,0xc7}, {0xfa,0xd7}, {0x9a,0xf8}, {0xfb,0xa1},
    {0x8e,0xc5}, {0xfb,0xa4}, {0xfb,0xc2}, {0x9a,0xc1}, {0x91,0xfa}, {0xfe,0xdb}, {0x97,0xab}, {0x91,0x47}, {0xfb,0xb1}, {0x8f,0xea},
    {0x94,0xd2}, {0xfe,0x61}, {0xfa,0xce}, {0x92,0xed}, {0x91,0xf3}, {0x93,0xc6}, {0x93,0x5a}, {0xfa,0xfb}, {0x92,0xef}, {0xfa,0xc8},
    {0x98,0x47}, {0x93,0x66}, {0x98,0x55}, {0x96,0xe6}, {0x9f,0x43}, {0x9f,0xaa}, {0x94,0xda}, {0x92,0xee}, {0xfc,0xaf}, {0xfb,0xfb},
    {0x8e,0xf9}, {0x91,0xf6}, {0x93,0x64}, {0x94,0xf5}, {0x9c,0xb6}, {0xfb,0xad}, {0x98,0x4e}, {0x8f,0x44}, {0x96,0xfd}, {0x9a,0xf9},
    {0x9a,0xfa}, {0x97,0x69}, {0x95,0xd4}, {0x98,0x4b}, {0xfb,0xaa}, {0x98,0x7c}, {0x91,0xea}, {0x9d,0xaf}, {0x9d,0xc5}, {0x91,0xf1},
    {0x8e,0xb1}, {0x97,0xa9}, {0xfb,0xac}, {0xfc,0xb8}, {0x9c,0xb9}, {0xfb,0xb0}, {0xfc,0xd2}, {0x93,0xcb}, {0x9a,0xfd}, {0x91,0xf4},
    {0x8b,0xac}, {0xa0,0x55}, {0x95,0x74}, {0x95,0xbe}, {0x97,0xad}, {0x8e,0xe9}, {0x92,0xf8}, {0x97,0xbe}, {0x91,0x6c}, {0x94,0xaa},
    {0xfc,0x63}, {0x9d,0xc6}, {0x97,0xb5}, {0x92,0xb8}, {0x91,0xef}, {0xfe,0xa6}, {0x97,0x60}, {0x93,0x58}, {0x95,0x76}, {0x8f,0xac},
    {0x91,0xec}, {0x97,0xb4}, {0x91,0xf7}, {0x97,0x4a}, {0xfb,0x49}, {0x95,0x78}, {0x93,0xbc}, {0x91,0xd6}, {0x93,0x55}, {0x93,0x56},
    {0x98,0x51}, {0x8f,0xf8}, {0xfb,0xc0}, {0x93,0xf2}, {0x90,0xd0}, {0x9c,0x44}, {0x92,0x55}, {0x93,0x63}, {0x91,0xa5}, {0xa0,0xed},
    {0xfd,0x6b}, {0x9a,0xfe}, {0x93,0x51}, {0x8c,0x57}, {0xfa,0x78}, {0xfe,0xa8}, {0x93,0x50}, {0xfa,0x4c}, {0x92,0xf7}, {0x9b,0x40},
    {0xfb,0xce}, {0x9b,0x41}, {0xfe,0xad}, {0xfb,0xd5}, {0x8b,0xc2}, {0x9a,0x7c}, {0x9b,0x42}, {0x9b,0x43}, {0x9e,0x79}, {0xfb,0xd9},
    {0x9b,0x44}, {0xa0,0xa7}, {0x9b,0xf3}, {0x8c,0x79}, {0x93,0x5e}, {0x89,0xcb}, {0x9f,0x53}, {0x93,0xd7}, {0xfb,0xe1}, {0xfe,0xd0},
    {0xfb,0xe2}, {0xfc,0xe3}, {0x90,0x74}, {0xfb,0xe6}, {0x9b,0xb7}, {0x9b,0x45}, {0x9b,0x47}, {0x9f,0x50}, {0x9b,0x48}, {0xfc,0x5b},
    {0x98,0xa9}, {0x9c,0xfd}, {0x88,0x4c}, {0x9b,0x4b}, {0xfb,0xec}, {0x8c,0x69}, {0x9b,0xa8}, {0x8a,0xd5}, {0xfa,0x73}, {0xfd,0x59},
    {0x91,0xa2}, {0xfb,0xed}, {0x9c,0xa9}, {0x8a,0xa8}, {0x9b,0xc3}, {0x8a,0xe1}, {0x9b,0x4e}, {0x95,0xd0}, {0x90,0x5f}, {0x97,0xee},
    {0xfc,0x4e}, {0x9b,0x4f}, {0x9b,0x50}, {0x9e,0xc6}, {0xfc,0x50}, {0xfd,0x73}, {0xfd,0xa7}, {0x9d,0xa2}, {0xfa,0x58}, {0xfa,0x5e},
    {0xa0,0x59}, {0xfa,0x75}, {0xfb,0xbe}, {0x9c,0xa2}, {0x93,0x70}, {0x93,0x71}, {0x93,0x77}, {0xfe,0xef}, {0x93,0x6d}, {0xfc,0x5d},
    {0x90,0xb8}, {0x8a,0xfc}, {0xfb,0x41}, {0x9e,0x6b}, {0x94,0xe3}, {0x8e,0xe2}, {0x8c,0x7d}, {0x8e,0xd7}, {0x9c,0x4d}, {0x96,0xa3},
    {0x9b,0x51}, {0x8a,0xc3}, {0x96,0xaa}, {0xfc,0x68}, {0x8b,0x6d}, {0xfd,0x67}, {0x8a,0xe9}, {0xfc,0xa1}, {0x93,0x6c}, {0x9b,0x52},
    {0xfe,0x70}, {0xfc,0xa8}, {0xfc,0xe9}, {0x9c,0xb4}, {0x8a,0xea}, {0x9b,0x53}, {0x9b,0x55}, {0x96,0xab}, {0xfc,0xa7}, {0x9b,0x56},
    {0x8a,0xbc}, {0x8a,0xcb}, {0x9b,0x57}, {0x89,0xcd}, {0x9b,0x59}, {0x9b,0x5b}, {0x93,0xa5}, {0x9b,0x5d}, {0x9e,0x4f}, {0x93,0xa3},
    {0x8a,0x7b}, {0x8b,0x42}, {0x97,0x50}, {0x8f,0xb3}, {0x8a,0x50}, {0x9b,0x60}, {0x8b,0x45}, {0x8b,0x46}, {0x9d,0xfe}, {0x9b,0x62},
    {0x93,0x7b}, {0x93,0xb1}, {0x8a,0x60}, {0x8a,0xd8}, {0x9b,0x63}, {0x8a,0x69}, {0x8a,0x47}, {0x8a,0xcc}, {0x93,0x7c}, {0x9b,0x65},
    {0x9b,0x66}, {0x8a,0x72}, {0x8a,0x7a}, {0x93,0xaf}, {0x8a,0xb0}, {0x9b,0x68}, {0x9e,0xa3}, {0xfa,0xec}, {0x8b,0x77}, {0x9b,0x67},
    {0x8b,0x59}, {0xfc,0xb1}, {0xfc,0xbb}, {0x9b,0x69}, {0x93,0xa8}, {0x8a,0xe0}, {0x9e,0x51}, {0x8f,0x5f}, {0x9b,0x6a}, {0x9b,0x6b},
    {0x97,0xec}, {0x9b,0x6c}, {0xfe,0x4e}, {0xfd,0xc2}, {0x9b,0x6d}, {0x91,0x67}, {0xfc,0xcc}, {0x93,0xb6}, {0x90,0xe4}, {0x90,0xe5},
    {0x9e,0xf2}, {0x93,0xca}, {0x8b,0xbc}, {0x8f,0x46}, {0x93,0xcf}, {0xfc,0xdb}, {0xfc,0xdc}, {0x93,0xc0}, {0xfc,0xe6}, {0x96,0xe7},
    {0xfc,0xd8}, {0xfc,0xd9}, {0xfd,0xa6}, {0x93,0xce}, {0x95,0xf1}, {0x9c,0xe9}, {0xfc,0xe4}, {0x94,0xaf}, {0xfa,0x77}, {0x93,0xcc},
    {0x90,0x5a}, {0x8c,0x54}, {0x93,0xbf}, {0xfb,0x51}, {0x93,0xb9}, {0xfe,0xd7}, {0x93,0xb7}, {0x93,0xd9}, {0x93,0xbb}, {0x93,0xda},
    {0x98,0xa3}, {0x90,0xd1}, {0x9b,0x6e}, {0xfa,0x70}, {0x9b,0xeb}, {0x9b,0x6f}, {0xfc,0xfc}, {0x8b,0x40}, {0xa0,0x7b}, {0x8c,0xa1},
    {0x97,0xf7}, {0x93,0xe2}, {0xfc,0xd6}, {0x95,0x59}, {0x93,0xa6}, {0xfd,0x40}, {0x93,0x5f}, {0x97,0xf2}, {0x9c,0x76}, {0x8e,0xf8},
    {0x8f,0x47}, {0x9b,0x74}, {0x92,0xb4}, {0x91,0xed}, {0x96,0xd2}, {0xfd,0x46}, {0x8f,0x4f}, {0x95,0x49}, {0x9b,0x75}, {0xfa,0x5c},
    {0x9b,0x79}, {0xfd,0x4b}, {0x96,0xd3}, {0xfd,0x58}, {0x94,0x5f}, {0xa0,0xf5}, {0x92,0x43}, {0x97,0xfa}, {0x9d,0xd9}, {0x97,0xf4},
    {0x92,0x4d}, {0xfd,0x5b}, {0x9b,0x7a}, {0x9e,0xd5}, {0xfa,0xae}, {0x9c,0xc9}, {0x92,0x58}, {0x8e,0xc8}, {0x94,0xb4}, {0x93,0xe1},
    {0x93,0xdf}, {0xfc,0xf0}, {0x93,0xec}, {0x97,0xf6}, {0x96,0xcf}, {0x93,0xde}, {0x8a,0xcf}, {0x9b,0xa2}, {0xfd,0x69}, {0x93,0x52},
    {0x98,0xa2}, {0xfd,0x6e}, {0x8c,0xa4}, {0xfa,0x7c}, {0x93,0xfa}, {0x90,0x7c}, {0x8f,0x67}, {0x9d,0xb7}, {0xa0,0xe9}, {0xfa,0x4e},
    {0xfd,0xa1}, {0x9e,0x74}, {0x9f,0xbf}, {0x9e,0xcb}, {0x9b,0xb9}, {0x9d,0xd4}, {0x97,0xb9}, {0x8e,0xf1}, {0x95,0x7b}, {0x9e,0xd2},
    {0x97,0x53}, {0x96,0xa4}, {0x8f,0xbe}, {0x94,0xd9}, {0x90,0x58}, {0xfd,0x79}, {0xfd,0x7b}, {0x8e,0xda}, {0x8e,0xfa}, {0x9b,0xa5},
    {0x9e,0xd9}, {0x97,0xd4}, {0x90,0xbb}, {0xfd,0xbc}, {0xfd,0xc6}, {0x92,0x48}, {0x92,0xb5}, {0x9d,0xc1}, {0x92,0xb9}, {0x92,0xa6},
    {0x8f,0x4b}, {0x9b,0xa6}, {0x92,0xb6}, {0x8e,0x40}, {0x9e,0xd8}, {0x94,0x5e}, {0x98,0x5f}, {0x94,0xce}, {0x92,0x4a}, {0xfd,0x70},
    {0x94,0x67}, {0x8d,0xec}, {0x9b,0xd8}, {0x94,0x48}, {0xfa,0xc1}, {0x9c,0xf7}, {0xfd,0xbe}, {0x8f,0xda}, {0xfd,0xd9}, {0xfc,0x7e},
    {0x93,0xf9}, {0xfa,0x43}, {0xfa,0xeb}, {0xfa,0xc3}, {0x97,0xd3}, {0x95,0xf9}, {0x9c,0x48}, {0xfd,0xd8}, {0xa0,0xd8}, {0xfd,0xd7},
    {0xfb,0x4a}, {0x9b,0xaf}, {0x94,0x4b}, {0xfd,0xc9}, {0x8e,0xac}, {0xfd,0xb2}, {0x92,0x5a}, {0xfc,0xbd}, {0x92,0xd9}, {0xfd,0xd5},
    {0x92,0xdd}, {0x92,0x59}, {0x96,0xba}, {0x92,0x5b}, {0x9b,0xab}, {0xfd,0xda}, {0xfd,0xde}, {0xfd,0xd3}, {0x8c,0x46}, {0xfd,0xd6},
    {0xfd,0xdc}, {0xfd,0xdd}, {0x90,0xfe}, {0xfe,0xa1}, {0x8b,0xad}, {0x9c,0xd8}, {0x9e,0x6d}, {0xfd,0x7c}, {0xfb,0x61}, {0x96,0xf8},
    {0x96,0xf0}, {0xfc,0xf4}, {0xfe,0x60}, {0x98,0x52}, {0x96,0x4f}, {0x91,0x6e}, {0x98,0x6d}, {0x98,0x64}, {0x94,0x53}, {0xfd,0xec},
    {0xfb,0x78}, {0x95,0xba}, {0x98,0x5d}, {0x92,0xf9}, {0x98,0x5a}, {0xfd,0xf6}, {0x93,0xd0}, {0x98,0x62}, {0x9b,0xad}, {0x97,0x4f},
    {0x9b,0xae}, {0x94,0x52}, {0x9b,0xb0}, {0x91,0xd2}, {0x97,0xea}, {0xfb,0x6b}, {0x91,0xb1}, {0xfd,0xf3}, {0x92,0xcb}, {0x9b,0xb1},
    {0xfc,0xec}, {0x98,0x6b}, {0x97,0x51}, {0x98,0x71}, {0x95,0xef}, {0x9e,0xf3}, {0x91,0xe8}, {0x9b,0xba}, {0xfb,0x4c}, {0x92,0x6a},
    {0xfd,0xf8}, {0x98,0x61}, {0x91,0xe7}, {0x93,0xed}, {0x97,0x44}, {0x91,0xe1}, {0xfb,0xf5}, {0x98,0x69}, {0x8a,0x62}, {0x9b,0xbb},
    {0x8c,0xa8}, {0x9c,0x55}, {0x8e,0x77}, {0x8a,0xb2}, {0x9e,0xbc}, {0x93,0xe6}, {0x93,0xa2}, {0x9b,0xbd}, {0x94,0xb3}, {0x93,0x7d},
    {0x9e,0x66}, {0x94,0x59}, {0x9b,0xbf}, {0x94,0x58}, {0x9e,0xa5}, {0x9b,0xc7}, {0xfe,0x54}, {0x8e,0x74}, {0x8b,0xd6}, {0x94,0xb6},
    {0xfd,0x74}, {0x98,0xc0}, {0x94,0xa5}, {0x9b,0xc8}, {0x95,0xed}, {0xfd,0x7e}, {0xfb,0xeb}, {0xfd,0x7d}, {0x97,0x6f}, {0x94,0x61},
    {0x9f,0xc1}, {0x95,0xd7}, {0xfa,0x52}, {0x9c,0x58}, {0x9f,0x68}, {0x9b,0xe7}, {0xfc,0xce}, {0x96,0xe8}, {0xfa,0x49}, {0x97,0xa1},
    {0x95,0x4d}, {0x9e,0xf8}, {0xfe,0x49}, {0x91,0xce}, {0x97,0x71}, {0x8c,0xcf}, {0xfd,0xb1}, {0xfc,0x6e}, {0x9c,0xf2}, {0x93,0xb8},
    {0x90,0x43}, {0x97,0x59}, {0x94,0xd7}, {0xfe,0x66}, {0x94,0x7d}, {0xfc,0x6f}, {0x92,0x46}, {0xfa,0x6d}, {0x8e,0xf7}, {0xfb,0xb7},
    {0x94,0x7c}, {0x92,0xcd}, {0x97,0xb2}, {0xfe,0x65}, {0x96,0x7e}, {0x97,0x58}, {0x9b,0x77}, {0x91,0xcf}, {0x94,0xa4}, {0x9c,0xad},
    {0x8b,0xab}, {0x96,0xd5}, {0xfc,0xb3}, {0x93,0xae}, {0x97,0x6d}, {0x94,0x46}, {0x95,0xf7}, {0x9c,0x46}, {0x95,0x5b}, {0x91,0xd1},
    {0x94,0xf4}, {0xfe,0x67}, {0x92,0xa5}, {0xfe,0xdf}, {0x8c,0xab}, {0x9b,0xc9}, {0xfc,0xed}, {0xfd,0xfa}, {0xfc,0xc8}, {0xfe,0x62},
    {0x91,0xfc}, {0xfe,0x6b}, {0xfd,0xf9}, {0xfc,0xc7}, {0x91,0x4e}, {0x9c,0xb8}, {0x97,0x67}, {0x95,0xee}, {0x9b,0xb2}, {0x94,0x60},
    {0x94,0xa2}, {0x98,0x75}, {0x97,0xac}, {0x91,0xd3}, {0x98,0x7b}, {0x8e,0xeb}, {0x97,0x6a}, {0x96,0x5e}, {0x97,0xeb}, {0x9f,0xf9},
    {0x95,0xf8}, {0xfe,0xa2}, {0x8f,0xe6}, {0xfe,0x7e}, {0x9d,0xa4}, {0x97,0x68}, {0x8e,0xec}, {0x94,0xbd}, {0x94,0x5b}, {0x9c,0xf6},
    {0xfa,0xa7}, {0x9b,0xd9}, {0xfa,0x5d}, {0x96,0x56}, {0x97,0x62}, {0x94,0xba}, {0xa0,0x4f}, {0x92,0xd8}, {0x9b,0xcb}, {0x94,0xbb},
    {0x9d,0x5f}, {0x90,0xcf}, {0x94,0x65}, {0x9f,0x4c}, {0x90,0xd8}, {0x9e,0xbe}, {0xfb,0x6d}, {0x95,0xca}, {0x9d,0xc2}, {0x97,0xf8},
    {0x8f,0xfc}, {0x94,0x73}, {0x94,0x74}, {0xfe,0xb7}, {0x8a,0x4b}, {0x8a,0x55}, {0x8b,0x69}, {0x8a,0xdc}, {0x8b,0x76}, {0x9b,0xce},
    {0x8a,0x68}, {0xa0,0xf8}, {0x98,0xdf}, {0xfe,0xb5}, {0x9b,0xcf}, {0x96,0xfb}, {0x9b,0xfb}, {0x9e,0xce}, {0x8e,0xe5}, {0x9e,0x7b},
    {0x9b,0xd2}, {0x8a,0xa5}, {0xfe,0xce}, {0x8a,0x45}, {0x9d,0xfc}, {0xfe,0xcf}, {0x8b,0xa5}, {0x8c,0x4a}, {0x8a,0xec}, {0xfc,0xe0},
    {0x94,0xad}, {0xfe,0xd5}, {0x94,0xac}, {0xfc,0x5a}, {0x9b,0xd6}, {0x8a,0x6f}, {0x8b,0xa9}, {0x8e,0x5f}, {0x9d,0xcb}, {0xfc,0xe7},
    {0x9b,0xd7}, {0x93,0xc8}, {0x91,0xf0}, {0x8f,0xe0}, {0x9b,0xdb}, {0x90,0xed}, {0x9b,0xdc}, {0xa0,0xec}, {0x98,0xfa}, {0x9b,0xe0},
    {0x93,0xc7}, {0x92,0x49}, {0x96,0xe1}, {0x9b,0xe2}, {0x9b,0xe4}, {0x8f,0xe1}, {0x9b,0xe5}, {0x94,0xc0}, {0x93,0xc3}, {0x93,0xc5},
    {0x90,0x79}, {0x97,0x7b}, {0x90,0x7e}, {0xfe,0xe6}, {0xfe,0x46}, {0x9d,0xb8}, {0x92,0x70}, {0x95,0xa8}, {0x8c,0xb0}, {0x94,0xc8},
    {0x98,0xb9}, {0x91,0x40}, {0xfc,0xbe}, {0x91,0x57}, {0x8b,0xb2}, {0xfa,0xdf}, {0x9b,0xe6}, {0x96,0x43}, {0x8e,0x44}, {0x9c,0x4f},
    {0xfe,0xf4}, {0x9b,0xe8}, {0x93,0xdc}, {0x96,0x6f}, {0x8e,0x4a}, {0x9b,0xed}, {0x92,0xf6}, {0x9d,0xb9}, {0x8e,0x4e}, {0xfb,0xcf},
    {0x9e,0xc2}, {0x94,0xe5}, {0x9b,0xf0}, {0x94,0xe4}, {0x95,0x51}, {0x8b,0xbb}, {0x9b,0xf1}, {0x94,0xf0}, {0x8e,0x64}, {0x94,0xea},
    {0x8f,0x61}, {0x9b,0x64}, {0x8e,0x5b}, {0x9b,0xf2}, {0x9f,0xbe}, {0x9d,0xc9}, {0x8e,0x6c}, {0x8f,0x73}, {0x8c,0xaf}, {0x8f,0x75},
    {0x8e,0x71}, {0x8e,0x60}, {0x8e,0x6a}, {0x8c,0x4c}, {0x95,0x52}, {0x95,0x54}, {0x8a,0xd4}, {0x9d,0xbb}, {0x95,0x43}, {0x92,0xfe},
    {0x94,0xf2}, {0x94,0xf1}, {0xa0,0xea}, {0x9d,0xd2}, {0xa0,0xb1}, {0x91,0xf8}, {0x94,0x62}, {0x9b,0xa4}, {0x8e,0xad}, {0x9e,0xad},
    {0x96,0xd0}, {0xfe,0xee}, {0x8a,0xb4}, {0x97,0x57}, {0x8a,0x77}, {0x9b,0xf7}, {0x8e,0xb5}, {0xa0,0x6d}, {0x8e,0xb6}, {0x97,0x56},
    {0x95,0x40}, {0xa0,0xf3}, {0x94,0xbe}, {0x9b,0xfa}, {0xfd,0xdf}, {0x9d,0xbc}, {0x94,0xfe}, {0x8b,0xdb}, {0xa0,0xfe}, {0x8e,0xc0},
    {0x9f,0x47}, {0x8b,0xde}, {0xa0,0xfb}, {0x8e,0xc3}, {0x96,0x49}, {0xfe,0xc2}, {0x95,0x4c}, {0x9b,0xfd}, {0x90,0xcc}, {0x9c,0x60},
    {0x95,0x4b}, {0x9b,0xfe}, {0x9c,0x70}, {0x9c,0x43}, {0x9c,0x47}, {0x8e,0xcc}, {0x8e,0x54}, {0x8e,0xe4}, {0x9c,0x49}, {0x8b,0x5e},
    {0x95,0x5e}, {0x95,0x5c}, {0x9c,0x4b}, {0x8b,0xe1}, {0x8e,0xd9}, {0x9d,0xb4}, {0x92,0x5f}, {0x9c,0x4c}, {0x8a,0xa1}, {0x8e,0xdb},
    {0x9c,0x56}, {0x8a,0xa2}, {0x97,0x54}, {0x9c,0x5e}, {0x9e,0xd4}, {0x95,0x68}, {0xa0,0xc3}, {0x8a,0xe6}, {0xa0,0xf7}, {0x9c,0x61},
    {0x9c,0x5f}, {0xfc,0x4d}, {0x9e,0x5b}, {0x9e,0x69}, {0x9c,0x63}, {0xfe,0xc7}, {0xfe,0xc6}, {0x9c,0x67}, {0x9c,0x69}, {0x8b,0xe2},
    {0x91,0x65}, {0x9c,0xe7}, {0x8a,0x54}, {0x9c,0x6c}, {0x9c,0x6e}, {0xfe,0x5d}, {0x9c,0x73}, {0x95,0x6a}, {0x95,0x6d}, {0x8e,0xf0},
    {0x8f,0x4d}, {0x8e,0xf6}, {0xfa,0xbc}, {0x8c,0xd5}, {0xfb,0xda}, {0x8b,0x4c}, {0xfd,0x75}, {0x9b,0xdd}, {0xfa,0xf5}, {0x9c,0x74},
    {0x95,0x45}, {0x96,0xc6}, {0x8f,0x6a}, {0x8f,0x4e}, {0x9c,0x78}, {0xfa,0x55}, {0x97,0xe4}, {0x9c,0x41}, {0x92,0x5c}, {0x96,0xfa},
    {0xfb,0x66}, {0x8e,0x65}, {0x98,0x49}, {0xfb,0xa8}, {0x98,0x42}, {0x9c,0x7a}, {0x97,0xfb}, {0x90,0xca}, {0x9c,0x5b}, {0x97,0x4d},
    {0x8e,0xd3}, {0x95,0x61}, {0x9f,0x4b}, {0x9f,0xb5}, {0x93,0xd2}, {0xfd,0xaa}, {0x98,0x40}, {0x91,0x46}, {0x98,0x67}, {0xfa,0x5a},
    {0xfb,0xa9}, {0x98,0x41}, {0x8c,0xd3}, {0xfc,0xfd}, {0xfd,0xab}, {0x91,0xbd}, {0x8f,0x4c}, {0x96,0xc9}, {0x8f,0x55}, {0xfb,0xae},
    {0x95,0x6f}, {0x9c,0x7d}, {0xa0,0xf0}, {0x94,0x6f}, {0xfd,0xac}, {0x96,0xcb}, {0x96,0xce}, {0xa0,0x56}, {0x9c,0xe1}, {0x96,0xc4},
    {0x8f,0x5e}, {0x8f,0x6c}, {0x8e,0xa3}, {0xfb,0xb3}, {0xfc,0x53}, {0xfd,0xb3}, {0x8f,0x6b}, {0x96,0xca}, {0x8f,0x79}, {0x9e,0x6f},
    {0xa0,0xc5}, {0xfc,0x78}, {0x8e,0x42}, {0x8f,0x5a}, {0x90,0xc2}, {0x8e,0xa5}, {0x90,0x61}, {0x92,0x4f}, {0x93,0x73}, {0xfd,0xb5},
    {0xfe,0xcc}, {0xfb,0xbd}, {0x8c,0xd6}, {0x98,0x43}, {0x96,0xc5}, {0x89,0xbc}, {0x9c,0xa3}, {0x92,0x4b}, {0x98,0x4a}, {0x8f,0xa4},
    {0xa0,0xf1}, {0x9e,0xfb}, {0x9c,0xd2}, {0x8f,0xa7}, {0xfc,0x5c}, {0x98,0x45}, {0x90,0x46}, {0x8c,0xd1}, {0xfe,0xfa}, {0x95,0x60},
    {0x9f,0x48}, {0x92,0x47}, {0x90,0xfb}, {0x9c,0xa4}, {0x95,0x71}, {0x9c,0xa6}, {0x9c,0xa7}, {0x9c,0xaa}, {0x9e,0xd3}, {0x9e,0x70},
    {0x9c,0xac}, {0x8f,0xae}, {0x95,0x7d}, {0x9c,0xb0}, {0x97,0xb6}, {0xa0,0xbd}, {0x8a,0xdf}, {0x9e,0xaa}, {0x8f,0xbd}, {0x8f,0xbf},
    {0x93,0x69}, {0x9b,0xa7}, {0xc8,0xa4}, {0xfe,0xea}, {0x9b,0xe1}, {0x8b,0x41}, {0x9d,0xb6}, {0xa0,0xeb}, {0x9b,0xa3}, {0x8b,0xa1},
    {0x8f,0xc8}, {0x89,0x4c}, {0x98,0x60}, {0x94,0xc7}, {0x8b,0x58}, {0x95,0xab}, {0x95,0xaa}, {0x9c,0xc3}, {0x9c,0xc4}, {0x93,0xd6},
    {0x9d,0xac}, {0x8b,0xe6}, {0x8a,0x71}, {0x8f,0xd1}, {0x99,0xd5}, {0x90,0xf4}, {0x8a,0xa3}, {0x9c,0xce}, {0x9c,0xd4}, {0x9c,0xd5},
    {0xfb,0xc8}, {0x9d,0xb3}, {0xfc,0x70}, {0x8f,0xd7}, {0x9b,0x73}, {0xfa,0x5b}, {0x8f,0xd2}, {0x90,0x64}, {0x98,0xb6}, {0x96,0x68},
    {0x9c,0xd6}, {0x98,0xbd}, {0x8f,0xdc}, {0xfe,0xf6}, {0x8f,0xd9}, {0x95,0x41}, {0x97,0xf3}, {0x9b,0xf8}, {0x9e,0x6c}, {0x8f,0xf2},
    {0x8f,0xee}, {0x9c,0xd7}, {0x9e,0x6e}, {0x8a,0x40}, {0x8f,0xef}, {0x8f,0xf4}, {0x8f,0xf5}, {0x95,0xc2}, {0x98,0x6a}, {0x97,0xcf},
    {0x9e,0x7c}, {0x90,0x41}, {0x9c,0xdb}, {0x94,0x41}, {0x9c,0xe6}, {0x9d,0xb0}, {0x9c,0xea}, {0x9c,0xed}, {0x9c,0xfa}, {0x8b,0x62},
    {0x8a,0x4e}, {0x9c,0xca}, {0x8a,0x66}, {0x9c,0xfb}, {0x9c,0xfc}, {0x9c,0xfe}, {0x8a,0x53}, {0x9c,0xe5}, {0x9d,0x40}, {0x9d,0x41},
    {0x90,0x45}, {0x8b,0x73}, {0x97,0xca}, {0x9d,0x42}, {0x8a,0x61}, {0x8b,0xae}, {0x8a,0xd2}, {0x8b,0xa2}, {0x9d,0xf2}, {0x9d,0x43},
    {0x9c,0xdf}, {0x9d,0x44}, {0x8e,0xca}, {0x90,0x4e}, {0x8e,0xb3}, {0x9f,0xf5}, {0x9d,0x45}, {0x90,0x4f}, {0x9d,0x47}, {0x89,0xca},
    {0x9c,0xb5}, {0xfb,0xfe}, {0x90,0x5e}, {0x90,0x63}, {0x90,0x57}, {0x90,0x66}, {0x9b,0xc0}, {0xfc,0xe5}, {0x91,0x62}, {0x90,0x67},
    {0x8f,0xa1}, {0x8f,0xa2}, {0x9d,0x48}, {0xfa,0xd3}, {0x90,0x5d}, {0x90,0xb9}, {0x90,0x6b}, {0x8c,0x5c}, {0x90,0x69}, {0xfe,0x57},
    {0xfe,0x55}, {0x90,0x73}, {0x9b,0xef}, {0x9c,0xf0}, {0x9d,0x4b}, {0xfe,0xd9}, {0xfe,0xda}, {0x91,0xe0}, {0x91,0xd8}, {0x96,0x46},
    {0x93,0x60}, {0xfa,0x53}, {0x9c,0xd3}, {0x9d,0x4e}, {0xfb,0x40}, {0x8d,0xe2}, {0x94,0x42}, {0x90,0x56}, {0x98,0x65}, {0x8c,0x6c},
    {0xfa,0x4a}, {0x9d,0x50}, {0x9d,0x52}, {0x95,0xaf}, {0x97,0x5a}, {0x93,0x49}, {0x97,0x47}, {0xa0,0xf4}, {0x97,0x78}, {0x8f,0xcf},
    {0xfc,0x60}, {0x8c,0x4e}, {0xfc,0x56}, {0x91,0xdc}, {0x96,0x61}, {0x92,0xec}, {0x93,0x5d}, {0x8e,0xde}, {0x96,0xfe}, {0xfd,0x4f},
    {0x95,0xde}, {0x98,0xb0}, {0xa0,0x40}, {0x97,0xbd}, {0x97,0x7d}, {0x97,0xf5}, {0x9b,0xac}, {0xfa,0xda}, {0x92,0xc2}, {0x97,0xb1},
    {0x90,0x7b}, {0x93,0xfe}, {0x94,0x7b}, {0x97,0x77}, {0xfa,0xbe}, {0xfd,0x43}, {0x90,0xc6}, {0x90,0xa4}, {0x90,0xa8}, {0x94,0xa9},
    {0x90,0xa9}, {0x8c,0x65}, {0x95,0xe0}, {0x90,0x7d}, {0x92,0x65}, {0xfd,0xba}, {0x93,0xc4}, {0xfe,0xed}, {0x9d,0xab}, {0xa0,0xe3},
    {0x96,0x48}, {0x9d,0x53}, {0x8a,0xa9}, {0x9b,0xc5}, {0x96,0x5d}, {0x97,0x5f}, {0x96,0x5f}, {0x96,0x6e}, {0xfb,0x5d}, {0x9d,0xb1},
    {0xfe,0xa3}, {0x9d,0xb2}, {0x95,0xae}, {0xfc,0xa3}, {0xa0,0xa2}, {0x96,0x55}, {0x9d,0x54}, {0x93,0x41}, {0x95,0xad}, {0x91,0xd5},
    {0x97,0x7a}, {0xfd,0xfc}, {0x8e,0x47}, {0x93,0xfd}, {0x90,0xa5}, {0x90,0xac}, {0x95,0xac}, {0x90,0xae}, {0xfe,0xa5}, {0x9d,0x56},
    {0x97,0xe3}, {0x95,0xe2}, {0x94,0x66}, {0x96,0x47}, {0x91,0xb8}, {0x9c,0xec}, {0x90,0xad}, {0x95,0xe3}, {0x8b,0x4f}, {0x8a,0xe3},
    {0x8b,0x4d}, {0x95,0xea}, {0x8b,0x4e}, {0x8c,0xc1}, {0x8b,0xed}, {0x91,0xd9}, {0xa0,0xa4}, {0x95,0xf5}, {0x95,0xf4}, {0x9f,0xb3},
    {0xfe,0xaf}, {0xfe,0x72}, {0x92,0x7a}, {0xfe,0xac}, {0x95,0xf3}, {0x9d,0x58}, {0x93,0x72}, {0x91,0xc5}, {0x96,0x42}, {0x90,0xcd},
    {0x95,0xfe}, {0x91,0x59}, {0x9c,0x65}, {0x97,0xcc}, {0x90,0xce}, {0x9d,0x59}, {0xfc,0xf5}, {0xfe,0xfd}, {0x9d,0x5b}, {0x9d,0x5c},
    {0x93,0x7e}, {0x98,0xac}, {0x9d,0x5e}, {0xfd,0xd0}, {0xfd,0x60}, {0x9c,0xcf}, {0x90,0xdd}, {0x90,0xe0}, {0x90,0xf3}, {0x98,0xb1},
    {0x90,0xf0}, {0x93,0xbd}, {0x95,0xb7}, {0x9f,0x46}, {0x8e,0x4b}, {0x96,0x58}, {0x8a,0x4c}, {0x9d,0x63}, {0x9e,0xcf}, {0x9d,0x65},
    {0x9d,0x66}, {0x96,0x5a}, {0x9d,0x64}, {0x8a,0x6c}, {0x8a,0xd9}, {0x9d,0x67}, {0x8a,0x70}, {0x8b,0xf3}, {0x91,0x50}, {0x9c,0xc1},
    {0x9d,0x68}, {0x93,0xa7}, {0x96,0x74}, {0xa0,0xef}, {0x91,0x51}, {0x96,0xc1}, {0x8c,0x64}, {0x96,0x76}, {0x9d,0x69}, {0xfc,0xa4},
    {0x9d,0x6a}, {0x92,0x4e}, {0x9d,0x6b}, {0x9b,0xc1}, {0x9d,0x6c}, {0x8a,0x65}, {0x91,0x5d}, {0x9d,0x6d}, {0x91,0x5a}, {0x8c,0x42},
    {0x9c,0xc0}, {0x91,0x6a}, {0x9d,0x6e}, {0x9e,0xa6}, {0x9d,0xcd}, {0x9d,0x6f}, {0x89,0xbb}, {0x9e,0xf9}, {0x96,0xb4}, {0x91,0x72},
    {0x9e,0xc8}, {0x8b,0x55}, {0x9d,0x71}, {0x9d,0x72}, {0x9e,0xcc}, {0x91,0x74}, {0x9e,0xd0}, {0x90,0x5c}, {0x8e,0xd2}, {0x91,0xa8},
    {0x91,0x77}, {0x96,0xbf}, {0x96,0xc0}, {0x8f,0xb1}, {0x96,0xb7}, {0x8c,0x55}, {0x91,0x78}, {0x89,0xbe}, {0x91,0x7c}, {0xfb,0x77},
    {0x91,0x75}, {0x91,0xa3}, {0x91,0x76}, {0x96,0xbe}, {0x91,0x79}, {0x96,0xb6}, {0x91,0xa4}, {0x91,0xa6}, {0x9d,0x75}, {0x90,0x52},
    {0xa0,0x45}, {0x91,0xa9}, {0x98,0xaa}, {0x8c,0x5f}, {0x8b,0xaa}, {0x9c,0xdd}, {0x9d,0x77}, {0x89,0x40}, {0x9e,0xec}, {0x93,0xaa},
    {0x94,0x78}, {0x9d,0x7a}, {0x8a,0xc9}, {0x8b,0x4b}, {0x9f,0xec}, {0x8a,0xe2}, {0x9e,0x75}, {0x98,0x74}, {0x9a,0xc8}, {0xa0,0x47},
    {0x8b,0xc3}, {0xfc,0x48}, {0xfc,0x77}, {0x9c,0x52}, {0x8e,0xfd}, {0x8f,0xa8}, {0x95,0x7a}, {0x8f,0xf0},
};


/* Index of the convert table */
static const Summary16 big5hkscs_uni2index_page00[70] = {
  /* 0x0000 */
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0xE7EE }, {   12, 0x87BF },
  {   23, 0xFFFF }, {   39, 0xFFFF }, {   55, 0xFFFF }, {   71, 0xFFFF },
  /* 0x0100 */
  {   87, 0x0003 }, {   89, 0x0C0C }, {   93, 0x0800 }, {   94, 0x0000 },
  {   94, 0x3800 }, {   97, 0x0008 }, {   98, 0x0800 }, {   99, 0x0000 },
  {   99, 0x0000 }, {   99, 0x0000 }, {   99, 0x0000 }, {   99, 0x0000 },
  {   99, 0x6000 }, {  101, 0x1557 }, {  109, 0x0000 }, {  109, 0x0000 },
  /* 0x0200 */
  {  109, 0x0000 }, {  109, 0x0000 }, {  109, 0x0000 }, {  109, 0x0000 },
  {  109, 0x0000 }, {  109, 0x0813 }, {  113, 0x0402 }, {  115, 0x0020 },
  {  116, 0x0408 }, {  118, 0x0000 }, {  118, 0x0000 }, {  118, 0x0000 },
  {  118, 0x2EC0 }, {  124, 0x0200 }, {  125, 0x0000 }, {  125, 0x0000 },
  /* 0x0300 */
  {  125, 0x0020 }, {  126, 0x0000 }, {  126, 0x0000 }, {  126, 0x0000 },
  {  126, 0x0000 }, {  126, 0x0000 }, {  126, 0x0000 }, {  126, 0x0000 },
  {  126, 0x0000 }, {  126, 0xFFFE }, {  141, 0x03FB }, {  150, 0xFFFE },
  {  165, 0x03FB }, {  174, 0x0000 }, {  174, 0x0000 }, {  174, 0x0000 },
  /* 0x0400 */
  {  174, 0x0002 }, {  175, 0xFFFF }, {  191, 0xFFFF }, {  207, 0xFFFF },
  {  223, 0xFFFF }, {  239, 0x0002 },
};
static const Summary16 big5hkscs_uni2index_page1e[13] = {
  /* 0x1E00 */
  {  240, 0x0000 }, {  240, 0x0000 }, {  240, 0x0000 }, {  240, 0x0000 },
  {  240, 0x0000 }, {  240, 0x0000 }, {  240, 0x0000 }, {  240, 0x0000 },
  {  240, 0x0000 }, {  240, 0x0000 }, {  240, 0x0000 }, {  240, 0xC000 },
  {  242, 0x0003 },
};
static const Summary16 big5hkscs_uni2index_page20[116] = {
  /* 0x2000 */
  {  244, 0x0000 }, {  244, 0x3378 }, {  252, 0x00F4 }, {  257, 0x482C },
  {  262, 0x0000 }, {  262, 0x0000 }, {  262, 0x0000 }, {  262, 0x0000 },
  {  262, 0x0000 }, {  262, 0x0000 }, {  262, 0x1000 }, {  263, 0x0000 },
  {  263, 0x0000 }, {  263, 0x0000 }, {  263, 0x0000 }, {  263, 0x0000 },
  /* 0x2100 */
  {  263, 0x0228 }, {  266, 0x0040 }, {  267, 0x0002 }, {  268, 0x0000 },
  {  268, 0x0000 }, {  268, 0x0000 }, {  268, 0x03FF }, {  278, 0x03FF },
  {  288, 0x0000 }, {  288, 0x03CF }, {  296, 0x0000 }, {  296, 0x0300 },
  {  298, 0x0000 }, {  298, 0x0000 }, {  298, 0x0080 }, {  299, 0x0000 },
  /* 0x2200 */
  {  299, 0x0000 }, {  299, 0xC560 }, {  305, 0x4E29 }, {  312, 0x0030 },
  {  314, 0x0000 }, {  314, 0x0004 }, {  315, 0x00CB }, {  320, 0x0000 },
  {  320, 0x0000 }, {  320, 0x0220 }, {  322, 0x0020 }, {  323, 0x8000 },
  {  324, 0x0000 }, {  324, 0x0000 }, {  324, 0x0000 }, {  324, 0x0000 },
  /* 0x2300 */
  {  324, 0x0080 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 },
  {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 },
  {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 },
  {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 },
  /* 0x2400 */
  {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 },
  {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x03FF }, {  335, 0x3FF0 },
  {  345, 0x0000 }, {  345, 0x0000 }, {  345, 0x0000 }, {  345, 0x0000 },
  {  345, 0x0000 }, {  345, 0x0000 }, {  345, 0x0000 }, {  345, 0x0000 },
  /* 0x2500 */
  {  345, 0x1005 }, {  348, 0x1111 }, {  352, 0x1010 }, {  354, 0x1010 },
  {  356, 0x0000 }, {  356, 0xFFFF }, {  372, 0xFFFF }, {  388, 0x001F },
  {  393, 0xFFFE }, {  408, 0x0038 }, {  411, 0x0003 }, {  413, 0x300C },
  {  417, 0xC8C0 }, {  422, 0x0000 }, {  422, 0x003C }, {  426, 0x0000 },
  /* 0x2600 */
  {  426, 0x0260 }, {  429, 0x0000 }, {  429, 0x0000 }, {  429, 0x0000 },
  {  429, 0x0007 }, {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x0000 },
  {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x0000 },
  {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x0000 },
  /* 0x2700 */
  {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x2000 },
};
static const Summary16 big5hkscs_uni2index_page2e[1819] = {
  /* 0x2E00 */
  {  433, 0x0000 }, {  433, 0x0000 }, {  433, 0x0000 }, {  433, 0x0000 },
  {  433, 0x0000 }, {  433, 0x0000 }, {  433, 0x0000 }, {  433, 0x0000 },
  {  433, 0x35D1 }, {  441, 0x3020 }, {  444, 0x54A0 }, {  449, 0x5040 },
  {  452, 0xB440 }, {  457, 0x40C0 }, {  460, 0x0008 }, {  461, 0x0000 },
  /* 0x2F00 */
  {  461, 0x0000 }, {  461, 0x0000 }, {  461, 0x0000 }, {  461, 0x0008 },
  {  462, 0x0000 }, {  462, 0x0000 }, {  462, 0x0000 }, {  462, 0x0000 },
  {  462, 0x0000 }, {  462, 0x0000 }, {  462, 0x0000 }, {  462, 0x0000 },
  {  462, 0x0000 }, {  462, 0x0000 }, {  462, 0x0000 }, {  462, 0x0000 },
  /* 0x3000 */
  {  462, 0xFFEF }, {  477, 0x7037 }, {  485, 0x03FE }, {  494, 0x0001 },
  {  495, 0xFFFE }, {  510, 0xFFFF }, {  526, 0xFFFF }, {  542, 0xFFFF },
  {  558, 0xFFFF }, {  574, 0x780F }, {  582, 0xFFFE }, {  597, 0xFFFF },
  {  613, 0xFFFF }, {  629, 0xFFFF }, {  645, 0xFFFF }, {  661, 0x707F },
  /* 0x3100 */
  {  671, 0xFFE0 }, {  682, 0xFFFF }, {  698, 0x03FF }, {  708, 0x0000 },
  {  708, 0x0000 }, {  708, 0x0000 }, {  708, 0x0000 }, {  708, 0x0000 },
  {  708, 0x0000 }, {  708, 0xFFFC }, {  722, 0x0000 }, {  722, 0x0000 },
  {  722, 0x0000 }, {  722, 0x0000 }, {  722, 0x0000 }, {  722, 0x0000 },
  /* 0x3200 */
  {  722, 0x0000 }, {  722, 0x0000 }, {  722, 0xFFFF }, {  738, 0xFFFF },
  {  754, 0x000F }, {  758, 0x0000 }, {  758, 0x0000 }, {  758, 0x0000 },
  {  758, 0xFFFF }, {  774, 0xFFFF }, {  790, 0xFFFF }, {  806, 0x0001 },
  {  807, 0x0000 }, {  807, 0x0000 }, {  807, 0x0000 }, {  807, 0x0000 },
  /* 0x3300 */
  {  807, 0x0000 }, {  807, 0x0000 }, {  807, 0x0000 }, {  807, 0x0000 },
  {  807, 0x0000 }, {  807, 0x0000 }, {  807, 0x0000 }, {  807, 0x0000 },
  {  807, 0xC000 }, {  809, 0x7000 }, {  812, 0x0002 }, {  813, 0x0000 },
  {  813, 0x4010 }, {  815, 0x0026 }, {  818, 0x0000 }, {  818, 0x0000 },
  /* 0x3400 */
  {  818, 0x0000 }, {  818, 0x0000 }, {  818, 0x0000 }, {  818, 0x0020 },
  {  819, 0x1001 }, {  821, 0x0000 }, {  821, 0x0010 }, {  822, 0x6408 },
  {  826, 0x0000 }, {  826, 0x0048 }, {  828, 0x8020 }, {  830, 0x1000 },
  {  831, 0x0102 }, {  833, 0x8000 }, {  834, 0x0010 }, {  835, 0x0800 },
  /* 0x3500 */
  {  836, 0x0040 }, {  837, 0x0000 }, {  837, 0x0000 }, {  837, 0x4000 },
  {  838, 0x0000 }, {  838, 0x020A }, {  841, 0x2002 }, {  843, 0x0185 },
  {  847, 0x0010 }, {  848, 0x0180 }, {  850, 0x2022 }, {  853, 0x8000 },
  {  854, 0x44A2 }, {  859, 0x2844 }, {  863, 0x0000 }, {  863, 0x480E },
  /* 0x3600 */
  {  868, 0x0200 }, {  869, 0x0500 }, {  871, 0x2008 }, {  873, 0x4220 },
  {  876, 0x4380 }, {  880, 0x8000 }, {  881, 0x0000 }, {  881, 0x0400 },
  {  882, 0x0002 }, {  883, 0x0400 }, {  884, 0x1420 }, {  887, 0x1223 },
  {  892, 0x01BA }, {  898, 0x2058 }, {  902, 0x0066 }, {  906, 0x0020 },
  /* 0x3700 */
  {  907, 0x250A }, {  912, 0x1000 }, {  913, 0x302C }, {  918, 0x040D },
  {  922, 0x0009 }, {  924, 0x0000 }, {  924, 0x8004 }, {  926, 0x0000 },
  {  926, 0x0000 }, {  926, 0x0080 }, {  927, 0x0001 }, {  928, 0x4200 },
  {  930, 0x0000 }, {  930, 0x0000 }, {  930, 0x0000 }, {  930, 0x0904 },
  /* 0x3800 */
  {  933, 0x8000 }, {  934, 0x0200 }, {  935, 0x2001 }, {  937, 0x0140 },
  {  939, 0x0000 }, {  939, 0x0000 }, {  939, 0x0008 }, {  940, 0x0000 },
  {  940, 0x0000 }, {  940, 0x0000 }, {  940, 0x0001 }, {  941, 0x0000 },
  {  941, 0x1008 }, {  943, 0x0002 }, {  944, 0x0000 }, {  944, 0x0400 },
  /* 0x3900 */
  {  945, 0x0100 }, {  946, 0x0010 }, {  947, 0x0080 }, {  948, 0x8004 },
  {  950, 0x2000 }, {  951, 0x0000 }, {  951, 0x0008 }, {  952, 0x0000 },
  {  952, 0x0601 }, {  955, 0x0A04 }, {  958, 0x0012 }, {  960, 0x0100 },
  {  961, 0x0000 }, {  961, 0x1000 }, {  962, 0x1024 }, {  965, 0x4900 },
  /* 0x3A00 */
  {  968, 0x004A }, {  971, 0x0180 }, {  973, 0x0600 }, {  975, 0x0010 },
  {  976, 0x0800 }, {  977, 0x5084 }, {  981, 0x00C0 }, {  983, 0x0000 },
  {  983, 0x0000 }, {  983, 0x0080 }, {  984, 0x0800 }, {  985, 0x2000 },
  {  986, 0x0000 }, {  986, 0x4000 }, {  987, 0x0001 }, {  988, 0x0805 },
  /* 0x3B00 */
  {  991, 0x4000 }, {  992, 0x0200 }, {  993, 0x0804 }, {  995, 0x0200 },
  {  996, 0x0004 }, {  997, 0x0100 }, {  998, 0x0001 }, {  999, 0x1806 },
  { 1003, 0x0001 }, { 1004, 0x0240 }, { 1006, 0x0002 }, { 1007, 0x5000 },
  { 1009, 0x0014 }, { 1011, 0x2080 }, { 1013, 0x1000 }, { 1014, 0x001C },
  /* 0x3C00 */
  { 1017, 0x2000 }, { 1018, 0x0122 }, { 1021, 0x0000 }, { 1021, 0x0000 },
  { 1021, 0x0000 }, { 1021, 0x0010 }, { 1022, 0x0000 }, { 1022, 0x0000 },
  { 1022, 0x0800 }, { 1023, 0x0000 }, { 1023, 0x0000 }, { 1023, 0x0000 },
  { 1023, 0x2800 }, { 1025, 0x1042 }, { 1028, 0x8800 }, { 1030, 0x0000 },
  /* 0x3D00 */
  { 1030, 0x0000 }, { 1030, 0x2008 }, { 1032, 0x0000 }, { 1032, 0x0804 },
  { 1034, 0x5040 }, { 1037, 0x8002 }, { 1039, 0x8604 }, { 1043, 0x2020 },
  { 1045, 0x8420 }, { 1048, 0x0002 }, { 1049, 0x2020 }, { 1051, 0x8010 },
  { 1053, 0x32C0 }, { 1058, 0x0808 }, { 1060, 0x0980 }, { 1063, 0x3088 },
  /* 0x3E00 */
  { 1067, 0x0040 }, { 1068, 0x0000 }, { 1068, 0x0000 }, { 1068, 0x0000 },
  { 1068, 0x0109 }, { 1071, 0x0020 }, { 1072, 0x0000 }, { 1072, 0x0010 },
  { 1073, 0x0000 }, { 1073, 0x0000 }, { 1073, 0x2700 }, { 1077, 0x8102 },
  { 1080, 0x1484 }, { 1084, 0x4CC3 }, { 1091, 0x0A86 }, { 1096, 0x9419 },
  /* 0x3F00 */
  { 1102, 0x4051 }, { 1106, 0x0000 }, { 1106, 0x0000 }, { 1106, 0x0000 },
  { 1106, 0x0000 }, { 1106, 0x0308 }, { 1109, 0x0008 }, { 1110, 0x1000 },
  { 1111, 0x0000 }, { 1111, 0x0008 }, { 1112, 0x0000 }, { 1112, 0x0000 },
  { 1112, 0x0001 }, { 1113, 0x1080 }, { 1115, 0x2020 }, { 1117, 0x0600 },
  /* 0x4000 */
  { 1119, 0x0210 }, { 1121, 0x2000 }, { 1122, 0x0000 }, { 1122, 0x0200 },
  { 1123, 0x0020 }, { 1124, 0x0088 }, { 1126, 0x8424 }, { 1130, 0x0002 },
  { 1131, 0x0000 }, { 1131, 0x0000 }, { 1131, 0x0100 }, { 1132, 0x8800 },
  { 1134, 0x0100 }, { 1135, 0x8100 }, { 1137, 0x0000 }, { 1137, 0x0400 },
  /* 0x4100 */
  { 1138, 0x4218 }, { 1142, 0x0000 }, { 1142, 0x0000 }, { 1142, 0x0004 },
  { 1143, 0x0000 }, { 1143, 0x0000 }, { 1143, 0x5080 }, { 1146, 0x8000 },
  { 1147, 0x0000 }, { 1147, 0x0001 }, { 1148, 0x0000 }, { 1148, 0x0004 },
  { 1149, 0x8410 }, { 1152, 0x0800 }, { 1153, 0x8000 }, { 1154, 0x0200 },
  /* 0x4200 */
  { 1155, 0x0000 }, { 1155, 0x0002 }, { 1156, 0x0008 }, { 1157, 0x0000 },
  { 1157, 0x0001 }, { 1158, 0x0000 }, { 1158, 0x0401 }, { 1160, 0x0440 },
  { 1162, 0x1000 }, { 1163, 0x0010 }, { 1164, 0x0004 }, { 1165, 0x1220 },
  { 1168, 0x0000 }, { 1168, 0x0000 }, { 1168, 0x0000 }, { 1168, 0x1810 },
  /* 0x4300 */
  { 1171, 0x0000 }, { 1171, 0x0000 }, { 1171, 0x0800 }, { 1172, 0x0000 },
  { 1172, 0x0000 }, { 1172, 0x0000 }, { 1172, 0x4000 }, { 1173, 0x0000 },
  { 1173, 0x0000 }, { 1173, 0x0080 }, { 1174, 0x0000 }, { 1174, 0x0400 },
  { 1175, 0x0002 }, { 1176, 0x8200 }, { 1178, 0x2000 }, { 1179, 0x0004 },
  /* 0x4400 */
  { 1180, 0x0006 }, { 1182, 0x0008 }, { 1183, 0x2020 }, { 1185, 0x0000 },
  { 1185, 0x0000 }, { 1185, 0x0000 }, { 1185, 0x0000 }, { 1185, 0x0400 },
  { 1186, 0x8000 }, { 1187, 0x8000 }, { 1188, 0x0005 }, { 1190, 0x0081 },
  { 1192, 0x4021 }, { 1195, 0xA000 }, { 1197, 0x1E10 }, { 1202, 0x0010 },
  /* 0x4500 */
  { 1203, 0x0A18 }, { 1207, 0x2040 }, { 1209, 0x4080 }, { 1211, 0xA808 },
  { 1215, 0x0008 }, { 1216, 0x1026 }, { 1220, 0x0404 }, { 1222, 0x0080 },
  { 1223, 0x0020 }, { 1224, 0x0000 }, { 1224, 0x0000 }, { 1224, 0x0000 },
  { 1224, 0x0000 }, { 1224, 0x0000 }, { 1224, 0x0200 }, { 1225, 0x0000 },
  /* 0x4600 */
  { 1225, 0x8040 }, { 1227, 0x00A0 }, { 1229, 0x0000 }, { 1229, 0x0000 },
  { 1229, 0x0000 }, { 1229, 0x0800 }, { 1230, 0x0000 }, { 1230, 0x0400 },
  { 1231, 0x0001 }, { 1232, 0x0000 }, { 1232, 0x0000 }, { 1232, 0x0000 },
  { 1232, 0x8000 }, { 1233, 0x0001 }, { 1234, 0x0000 }, { 1234, 0x0020 },
  /* 0x4700 */
  { 1235, 0x0000 }, { 1235, 0x0108 }, { 1237, 0x0000 }, { 1237, 0x0000 },
  { 1237, 0x4000 }, { 1238, 0x0000 }, { 1238, 0x0000 }, { 1238, 0x1000 },
  { 1239, 0x0000 }, { 1239, 0x0100 }, { 1240, 0x0040 }, { 1241, 0x0040 },
  { 1242, 0x0000 }, { 1242, 0x0020 }, { 1243, 0x2000 }, { 1244, 0x0010 },
  /* 0x4800 */
  { 1245, 0x0801 }, { 1247, 0x0000 }, { 1247, 0x0000 }, { 1247, 0x0080 },
  { 1248, 0x0000 }, { 1248, 0x2000 }, { 1249, 0x0000 }, { 1249, 0x0002 },
  { 1250, 0x0000 }, { 1250, 0x0800 }, { 1251, 0x6000 }, { 1253, 0x0000 },
  { 1253, 0x0000 }, { 1253, 0x2001 }, { 1255, 0x2000 }, { 1256, 0x0408 },
  /* 0x4900 */
  { 1258, 0x0040 }, { 1259, 0x4002 }, { 1261, 0x2420 }, { 1264, 0x5020 },
  { 1267, 0x0020 }, { 1268, 0x000A }, { 1270, 0x0420 }, { 1272, 0x0004 },
  { 1273, 0x0200 }, { 1274, 0x0000 }, { 1274, 0x0082 }, { 1276, 0x0000 },
  { 1276, 0x0000 }, { 1276, 0x8000 }, { 1277, 0x00A0 }, { 1279, 0x0000 },
  /* 0x4A00 */
  { 1279, 0x8000 }, { 1280, 0x2000 }, { 1281, 0x0010 }, { 1282, 0x0020 },
  { 1283, 0x0000 }, { 1283, 0x0000 }, { 1283, 0x0000 }, { 1283, 0x0000 },
  { 1283, 0x0000 }, { 1283, 0x0040 }, { 1284, 0x0000 }, { 1284, 0x0110 },
  { 1286, 0x0000 }, { 1286, 0x0002 }, { 1287, 0x0010 }, { 1288, 0x8000 },
  /* 0x4B00 */
  { 1289, 0x0000 }, { 1289, 0x0201 }, { 1291, 0x1001 }, { 1293, 0x0080 },
  { 1294, 0x0000 }, { 1294, 0x0000 }, { 1294, 0x8000 }, { 1295, 0x4805 },
  { 1299, 0x4000 }, { 1300, 0x20C9 }, { 1305, 0x0000 }, { 1305, 0x6000 },
  { 1307, 0x0001 }, { 1308, 0x0000 }, { 1308, 0x0000 }, { 1308, 0x0000 },
  /* 0x4C00 */
  { 1308, 0x4090 }, { 1311, 0x0000 }, { 1311, 0x0000 }, { 1311, 0x4800 },
  { 1313, 0x0000 }, { 1313, 0x0800 }, { 1314, 0x2000 }, { 1315, 0x2000 },
  { 1316, 0x0002 }, { 1317, 0x0000 }, { 1317, 0x4010 }, { 1319, 0x0081 },
  { 1321, 0x2000 }, { 1322, 0x0000 }, { 1322, 0x2002 }, { 1324, 0x0000 },
  /* 0x4D00 */
  { 1324, 0x0200 }, { 1325, 0x0001 }, { 1326, 0x0000 }, { 1326, 0x0010 },
  { 1327, 0x0000 }, { 1327, 0x0000 }, { 1327, 0x0000 }, { 1327, 0x0000 },
  { 1327, 0x0000 }, { 1327, 0x1002 }, { 1329, 0x0000 }, { 1329, 0x0000 },
  { 1329, 0x0000 }, { 1329, 0x0000 }, { 1329, 0x0000 }, { 1329, 0x0000 },
  /* 0x4E00 */
  { 1329, 0xFF9B }, { 1342, 0xD773 }, { 1353, 0xFD52 }, { 1363, 0xBBCF },
  { 1375, 0xEBAC }, { 1385, 0xFF4C }, { 1396, 0x0600 }, { 1398, 0xC108 },
  { 1402, 0x7BFF }, { 1416, 0xCF3E }, { 1427, 0x797F }, { 1439, 0x9EC8 },
  { 1447, 0x6FDF }, { 1460, 0xF7F0 }, { 1471, 0x4F3A }, { 1480, 0xA9FF },
  /* 0x4F00 */
  { 1492, 0xEF3F }, { 1505, 0x27BF }, { 1516, 0xB304 }, { 1522, 0xFFDD },
  { 1536, 0xFBEE }, { 1549, 0xFFFF }, { 1565, 0xDE9F }, { 1577, 0xFFFD },
  { 1592, 0xAFFF }, { 1606, 0x7DF7 }, { 1619, 0xC904 }, { 1624, 0xAEED },
  { 1635, 0xFFBF }, { 1650, 0xFFDB }, { 1664, 0xD033 }, { 1671, 0x67FF },
  /* 0x5000 */
  { 1684, 0xFBE9 }, { 1696, 0xDFFE }, { 1710, 0xFFEF }, { 1725, 0x18BB },
  { 1733, 0xFFEB }, { 1747, 0xFDEA }, { 1759, 0xFF7F }, { 1774, 0x24FD },
  { 1783, 0x79AF }, { 1794, 0x7F77 }, { 1807, 0xF04C }, { 1814, 0xFDFF },
  { 1829, 0xEFF6 }, { 1842, 0xAEFB }, { 1854, 0xF7FB }, { 1868, 0xFB7B },
  /* 0x5100 */
  { 1881, 0x7FFF }, { 1896, 0x95BF }, { 1907, 0x6E77 }, { 1918, 0xBFBF },
  { 1932, 0x3BFB }, { 1944, 0xFEF4 }, { 1956, 0x7FAF }, { 1969, 0x13F2 },
  { 1977, 0xA7C5 }, { 1986, 0x55FE }, { 1997, 0x5DB5 }, { 2007, 0x73FF },
  { 2020, 0xFFF8 }, { 2033, 0xF99F }, { 2045, 0x2017 }, { 2050, 0x777B },
  /* 0x5200 */
  { 2062, 0x5FEF }, { 2075, 0xF0CF }, { 2085, 0x47F3 }, { 2095, 0x1DFF },
  { 2107, 0x7EDA }, { 2118, 0xFEF4 }, { 2130, 0xFF07 }, { 2141, 0xBFBC },
  { 2153, 0xBF9F }, { 2166, 0x8FDB }, { 2177, 0x7F5B }, { 2189, 0x5A20 },
  { 2194, 0x32AF }, { 2203, 0xEBEF }, { 2216, 0x8A5F }, { 2225, 0xDFBB },
  /* 0x5300 */
  { 2238, 0xEF62 }, { 2248, 0xB6E7 }, { 2259, 0xB49F }, { 2269, 0xFB9F },
  { 2282, 0x77BF }, { 2295, 0xF49E }, { 2305, 0xF2DB }, { 2316, 0xFBBF },
  { 2330, 0xC414 }, { 2335, 0xF7DC }, { 2347, 0x7FF5 }, { 2360, 0x0A55 },
  { 2366, 0x3F2E }, { 2376, 0x8FD7 }, { 2387, 0xFF7F }, { 2402, 0x59EF },
  /* 0x5400 */
  { 2413, 0xFFDA }, { 2426, 0xFF5F }, { 2440, 0xFFFB }, { 2455, 0x7BFF },
  { 2469, 0xEDEF }, { 2482, 0x0010 }, { 2483, 0xBFFF }, { 2498, 0xFDFF },
  { 2513, 0xF9F7 }, { 2526, 0x55FF }, { 2538, 0xFFFF }, { 2554, 0xFFDF },
  { 2569, 0xFBFF }, { 2584, 0x4441 }, { 2588, 0xEFFF }, { 2603, 0xBD8E },
  /* 0x5500 */
  { 2613, 0xFFFE }, { 2628, 0x459F }, { 2637, 0xFDE8 }, { 2648, 0xDBFF },
  { 2662, 0xEFFB }, { 2676, 0xF0EF }, { 2687, 0x0E7E }, { 2696, 0xFAEE },
  { 2708, 0xFFDF }, { 2723, 0xB73F }, { 2735, 0x7FFE }, { 2749, 0x9E3F },
  { 2760, 0xFFFF }, { 2776, 0xFFFF }, { 2792, 0x97FE }, { 2804, 0xFEE7 },
  /* 0x5600 */
  { 2817, 0xF377 }, { 2829, 0xF8FF }, { 2842, 0xF6AF }, { 2854, 0xEFFD },
  { 2868, 0xF76F }, { 2881, 0x679D }, { 2891, 0xFF7F }, { 2906, 0xDFDF },
  { 2920, 0xFEFF }, { 2935, 0xF7AD }, { 2947, 0xFDF2 }, { 2959, 0xF2FE },
  { 2971, 0x3F6F }, { 2983, 0xECDA }, { 2993, 0xECB7 }, { 3004, 0xA683 },
  /* 0x5700 */
  { 3011, 0x3F9F }, { 3023, 0xFD7C }, { 3035, 0xF70D }, { 3045, 0xE81D },
  { 3053, 0xFEEF }, { 3067, 0x8897 }, { 3074, 0xAFD6 }, { 3085, 0xFCFF },
  { 3099, 0xBD0D }, { 3108, 0xFFB9 }, { 3121, 0x44BF }, { 3130, 0xFF70 },
  { 3141, 0xD9DE }, { 3152, 0xF0B5 }, { 3161, 0xF2FF }, { 3174, 0x7FFF },
  /* 0x5800 */
  { 3189, 0x7FFF }, { 3204, 0x7A15 }, { 3212, 0xF7FF }, { 3227, 0xAFFF },
  { 3241, 0xFF91 }, { 3252, 0xFFBE }, { 3266, 0xBB3C }, { 3276, 0xFE7E },
  { 3289, 0xCFEF }, { 3302, 0xF71F }, { 3314, 0xDFEB }, { 3327, 0xFC6B },
  { 3338, 0xCBE6 }, { 3348, 0xFF7F }, { 3363, 0x9B9D }, { 3373, 0xFE1D },
  /* 0x5900 */
  { 3384, 0xF4FC }, { 3395, 0x96F6 }, { 3405, 0xFEB5 }, { 3417, 0x5196 },
  { 3424, 0xC7B1 }, { 3433, 0x15BB }, { 3442, 0x6EA7 }, { 3452, 0xFBFF },
  { 3467, 0xE63F }, { 3478, 0xE7DD }, { 3490, 0xD1FF }, { 3502, 0x7FFF },
  { 3517, 0xFFFB }, { 3532, 0x7F5F }, { 3545, 0xFF7B }, { 3559, 0xFFFF },
  /* 0x5A00 */
  { 3575, 0xBE0F }, { 3585, 0xDFEE }, { 3598, 0x7EBB }, { 3610, 0x73E8 },
  { 3619, 0x37FF }, { 3632, 0xFFFF }, { 3648, 0x7FFF }, { 3663, 0xFF83 },
  { 3674, 0xDD5E }, { 3685, 0xFEFF }, { 3700, 0xDAE7 }, { 3711, 0xFFFF },
  { 3727, 0xFFDF }, { 3742, 0xFFE8 }, { 3754, 0x7F7F }, { 3768, 0xEFFD },
  /* 0x5B00 */
  { 3782, 0xBBAE }, { 3793, 0xEEFB }, { 3806, 0xFDFB }, { 3820, 0xF115 },
  { 3828, 0xFDFB }, { 3842, 0xBDFB }, { 3855, 0x7B7C }, { 3866, 0xBDFF },
  { 3880, 0xDBBF }, { 3893, 0xFFED }, { 3907, 0x75FC }, { 3918, 0x8379 },
  { 3926, 0x7CFF }, { 3939, 0xC3FF }, { 3951, 0xDFFF }, { 3966, 0x856F },
  /* 0x5C00 */
  { 3975, 0xFFBA }, { 3988, 0xD47F }, { 3999, 0x153D }, { 4007, 0xDF8B },
  { 4018, 0xFFF3 }, { 4032, 0x737B }, { 4043, 0xF7BD }, { 4056, 0x5E1A },
  { 4064, 0xBF60 }, { 4073, 0xF63F }, { 4085, 0xFFFF }, { 4101, 0x05EB },
  { 4109, 0xDFC6 }, { 4120, 0xCFDF }, { 4133, 0xF720 }, { 4141, 0xABF3 },
  /* 0x5D00 */
  { 4152, 0xF8C3 }, { 4161, 0xEFF7 }, { 4175, 0xD3FD }, { 4187, 0xF7FF },
  { 4202, 0x5FEF }, { 4215, 0x4AE7 }, { 4224, 0x9BAC }, { 4233, 0xFE97 },
  { 4245, 0x6FF7 }, { 4258, 0xF6BC }, { 4269, 0xFF97 }, { 4282, 0x37F7 },
  { 4294, 0xAACF }, { 4304, 0xE9F6 }, { 4315, 0x49E7 }, { 4324, 0xE2BF },
  /* 0x5E00 */
  { 4335, 0x5E5C }, { 4344, 0xAFF6 }, { 4356, 0x6B3F }, { 4367, 0x61D8 },
  { 4374, 0xFD3F }, { 4387, 0xFBB8 }, { 4398, 0xFFCF }, { 4412, 0xFF7D },
  { 4426, 0xBFDD }, { 4439, 0x1EE4 }, { 4447, 0x7DFD }, { 4460, 0x63FF },
  { 4472, 0x7FF6 }, { 4485, 0xFFFF }, { 4501, 0xD3EF }, { 4513, 0xDFDE },
  /* 0x5F00 */
  { 4526, 0xFDB6 }, { 4538, 0xADBC }, { 4548, 0x63FC }, { 4558, 0x15EB },
  { 4567, 0xFF59 }, { 4579, 0x33D3 }, { 4588, 0xBEBE }, { 4600, 0xFBDF },
  { 4614, 0x1FEF }, { 4626, 0xDBC7 }, { 4637, 0xFFF3 }, { 4651, 0xFEE6 },
  { 4663, 0xB23F }, { 4673, 0xEBF7 }, { 4686, 0xED3B }, { 4697, 0xADBA },
  /* 0x6000 */
  { 4707, 0xFE01 }, { 4715, 0x7EFF }, { 4729, 0xFFFF }, { 4745, 0x0ABE },
  { 4753, 0x36FF }, { 4765, 0xEF3D }, { 4777, 0xFFFC }, { 4791, 0xC0A5 },
  { 4797, 0x77FB }, { 4810, 0xFCF5 }, { 4822, 0x019D }, { 4828, 0xFFFF },
  { 4844, 0xFFFB }, { 4859, 0xFFBA }, { 4872, 0x03DF }, { 4881, 0xFFFF },
  /* 0x6100 */
  { 4897, 0xFFFB }, { 4912, 0xBF7D }, { 4925, 0xDB8C }, { 4934, 0xE8D5 },
  { 4943, 0xFFF7 }, { 4958, 0xFF7D }, { 4972, 0xDDFF }, { 4986, 0x76FF },
  { 4999, 0x7E8F }, { 5010, 0xBF7F }, { 5024, 0xFF96 }, { 5036, 0xD7FF },
  { 5050, 0xBFEF }, { 5064, 0xC549 }, { 5071, 0x6FFD }, { 5084, 0xFFE7 },
  /* 0x6200 */
  { 5098, 0x779B }, { 5109, 0x8E77 }, { 5119, 0x7EBF }, { 5132, 0xE6DD },
  { 5143, 0x7FCF }, { 5156, 0x5F1F }, { 5167, 0xE17F }, { 5178, 0xFEDF },
  { 5192, 0xD7FF }, { 5206, 0x21FF }, { 5216, 0xFF50 }, { 5226, 0xFB7B },
  { 5239, 0xFFFC }, { 5253, 0x9FFF }, { 5267, 0xF820 }, { 5273, 0xFFFF },
  /* 0x6300 */
  { 5289, 0xFB8F }, { 5301, 0x017B }, { 5308, 0xFF00 }, { 5316, 0x7FFE },
  { 5330, 0xFFFF }, { 5346, 0x07F3 }, { 5355, 0xFBB0 }, { 5365, 0xBFE7 },
  { 5378, 0xFFBF }, { 5393, 0xFBD7 }, { 5406, 0xFFBF }, { 5421, 0x6203 },
  { 5426, 0xFFFF }, { 5442, 0xFFEF }, { 5457, 0xEFFF }, { 5472, 0x5B7F },
  /* 0x6400 */
  { 5484, 0xFEC0 }, { 5493, 0xDDFD }, { 5506, 0xFDFF }, { 5521, 0xEFFD },
  { 5535, 0x680B }, { 5541, 0xFF1F }, { 5554, 0xFBE3 }, { 5566, 0xBFFF },
  { 5581, 0xBFA4 }, { 5591, 0xF7EF }, { 5605, 0xFA7D }, { 5617, 0xF85F },
  { 5628, 0xEEBF }, { 5641, 0x2FDD }, { 5652, 0xBFFF }, { 5667, 0xFD9F },
  /* 0x6500 */
  { 5680, 0xF6DB }, { 5692, 0xFBFB }, { 5706, 0xFE7F }, { 5720, 0xEBFD },
  { 5733, 0xA76A }, { 5742, 0xF3FA }, { 5754, 0xBDFC }, { 5766, 0x9FFC },
  { 5778, 0x1BFF }, { 5790, 0xFAF7 }, { 5803, 0xDDB7 }, { 5815, 0xFBED },
  { 5828, 0xF87E }, { 5839, 0xECDF }, { 5851, 0xF36F }, { 5863, 0xBC3F },
  /* 0x6600 */
  { 5874, 0xFFFD }, { 5889, 0xF13F }, { 5900, 0xE9FF }, { 5913, 0x067F },
  { 5922, 0x9FBE }, { 5934, 0xFE8E }, { 5945, 0xDDFE }, { 5958, 0x7FDF },
  { 5972, 0x7FF1 }, { 5984, 0xA7F7 }, { 5996, 0xEF17 }, { 6007, 0xEFFF },
  { 6022, 0xFFD1 }, { 6034, 0x7F44 }, { 6043, 0x7B59 }, { 6053, 0xD3DF },
  /* 0x6700 */
  { 6065, 0xFF3F }, { 6079, 0xEBFD }, { 6092, 0x7DEF }, { 6105, 0xFF7A },
  { 6118, 0xFBF0 }, { 6129, 0xF6EB }, { 6141, 0xBC87 }, { 6150, 0xFFFF },
  { 6166, 0xFAFA }, { 6178, 0xB7BF }, { 6191, 0xD011 }, { 6196, 0x8FFF },
  { 6209, 0xFF7F }, { 6224, 0xFFDF }, { 6239, 0xFEFC }, { 6252, 0xD7FF },
  /* 0x6800 */
  { 6266, 0x201F }, { 6272, 0xFDDD }, { 6285, 0xEF67 }, { 6297, 0x7FFE },
  { 6311, 0xFFFF }, { 6327, 0x207B }, { 6334, 0xE820 }, { 6339, 0xFBF6 },
  { 6352, 0x9FFF }, { 6366, 0xB9DF }, { 6378, 0xFFDF }, { 6393, 0x227F },
  { 6402, 0x7FF8 }, { 6414, 0xF5FF }, { 6428, 0xDFDB }, { 6441, 0x3FFF },
  /* 0x6900 */
  { 6455, 0xFFFF }, { 6471, 0x0FBF }, { 6482, 0x9420 }, { 6486, 0xFBFD },
  { 6500, 0xDF7F }, { 6514, 0xFFFE }, { 6529, 0xFFFF }, { 6545, 0x0FFF },
  { 6557, 0x646D }, { 6565, 0xDFFB }, { 6579, 0xFFFF }, { 6595, 0xFAFF },
  { 6609, 0xFE5F }, { 6622, 0x027B }, { 6629, 0x7BF6 }, { 6641, 0xFFDE },
  /* 0x6A00 */
  { 6655, 0xBFFF }, { 6670, 0xFFFA }, { 6684, 0x39EB }, { 6694, 0xFF3C },
  { 6706, 0xFBFB }, { 6720, 0xEFFF }, { 6735, 0xAFFF }, { 6749, 0xC452 },
  { 6755, 0xF6BF }, { 6768, 0xFEFF }, { 6783, 0xF9FF }, { 6797, 0x6FFE },
  { 6810, 0xBFEC }, { 6822, 0xFF1B }, { 6834, 0xDDA3 }, { 6844, 0x1F4B },
  /* 0x6B00 */
  { 6853, 0x8F3D }, { 6863, 0x67CF }, { 6874, 0xB12B }, { 6882, 0xFFFE },
  { 6897, 0x7FEE }, { 6910, 0xDAF7 }, { 6922, 0xA4FF }, { 6933, 0xCFD4 },
  { 6943, 0xF75F }, { 6956, 0xCBF2 }, { 6966, 0xECFD }, { 6978, 0xB4ED },
  { 6988, 0xBFFB }, { 7002, 0x5DDD }, { 7013, 0x9DDF }, { 7025, 0xFF8D },
  /* 0x6C00 */
  { 7037, 0xBB7F }, { 7050, 0xBF7B }, { 7063, 0xDDFB }, { 7076, 0xEFFB },
  { 7090, 0xFE4F }, { 7102, 0xFFB5 }, { 7115, 0xEFE3 }, { 7127, 0xEF7F },
  { 7141, 0xFFFF }, { 7157, 0xBF7D }, { 7170, 0xFC04 }, { 7177, 0xFFDF },
  { 7192, 0xFEFF }, { 7207, 0xFEFF }, { 7222, 0xFFAF }, { 7236, 0x822F },
  /* 0x6D00 */
  { 7243, 0xFFFF }, { 7259, 0xEFC7 }, { 7271, 0xFFF5 }, { 7285, 0xFFFF },
  { 7301, 0x4007 }, { 7305, 0xDF80 }, { 7313, 0xF7FF }, { 7328, 0xFFF7 },
  { 7343, 0xFFFF }, { 7359, 0x01FF }, { 7368, 0xDC30 }, { 7375, 0xFFBE },
  { 7389, 0xBFF5 }, { 7402, 0xFFFF }, { 7418, 0xFF7F }, { 7433, 0x7EFF },
  /* 0x6E00 */
  { 7447, 0x843D }, { 7454, 0xBF20 }, { 7462, 0xFFFF }, { 7478, 0xFF7F },
  { 7493, 0xEEFB }, { 7506, 0xFF7F }, { 7521, 0xCBFF }, { 7534, 0x13DE },
  { 7543, 0xEB40 }, { 7550, 0xFFDD }, { 7564, 0xCCFF }, { 7576, 0xFFFF },
  { 7592, 0xFFFF }, { 7608, 0x3F7F }, { 7621, 0xFB04 }, { 7629, 0xFFF6 },
  /* 0x6F00 */
  { 7643, 0xFFFF }, { 7659, 0xD7FC }, { 7671, 0xFEFF }, { 7686, 0xFFFF },
  { 7702, 0xC01B }, { 7708, 0xFDFF }, { 7723, 0xFEDF }, { 7737, 0xFFDD },
  { 7751, 0x7FF7 }, { 7765, 0xE0FD }, { 7775, 0xFFFF }, { 7791, 0xFF7F },
  { 7806, 0xFFDF }, { 7821, 0xFF38 }, { 7832, 0xFBDF }, { 7846, 0xDDD7 },
  /* 0x7000 */
  { 7858, 0xFEFB }, { 7872, 0xFFF2 }, { 7885, 0x9FDF }, { 7898, 0xDFBF },
  { 7912, 0x3F7F }, { 7925, 0xFDF7 }, { 7939, 0x9FFF }, { 7953, 0xF7F3 },
  { 7966, 0xCE7E }, { 7977, 0x877E }, { 7987, 0xFAFB }, { 8000, 0x7FBB },
  { 8013, 0xFDF1 }, { 8025, 0xF7FF }, { 8040, 0x8017 }, { 8045, 0xFFFB },
  /* 0x7100 */
  { 8060, 0x7E75 }, { 8071, 0xFE89 }, { 8081, 0xDB6F }, { 8093, 0x4C7F },
  { 8103, 0xFEFF }, { 8118, 0xF75F }, { 8131, 0x5FFF }, { 8145, 0x7DEF },
  { 8158, 0xD7F7 }, { 8171, 0xFFD7 }, { 8185, 0xB7BF }, { 8198, 0xF7BF },
  { 8212, 0xCFFF }, { 8226, 0xBF77 }, { 8239, 0x79F7 }, { 8251, 0xFB77 },
  /* 0x7200 */
  { 8264, 0xF6EF }, { 8277, 0xEEF9 }, { 8289, 0x7FDC }, { 8301, 0xEF61 },
  { 8311, 0x9FD7 }, { 8323, 0xFFED }, { 8337, 0xD6CF }, { 8348, 0xFBDD },
  { 8361, 0xFBF7 }, { 8375, 0xEDFF }, { 8389, 0xF7FE }, { 8403, 0xA435 },
  { 8410, 0x7E7F }, { 8423, 0x97D7 }, { 8434, 0x0F5F }, { 8444, 0xFFD8 },
  /* 0x7300 */
  { 8456, 0x9D97 }, { 8466, 0x7BCF }, { 8478, 0x7FEC }, { 8490, 0xDFFF },
  { 8505, 0xF73F }, { 8518, 0xEF87 }, { 8529, 0xDFE7 }, { 8542, 0xFDFF },
  { 8557, 0xDFFF }, { 8572, 0xF1FC }, { 8583, 0x3FF7 }, { 8596, 0xDFFC },
  { 8609, 0xFFED }, { 8623, 0x7FFD }, { 8637, 0xEFFF }, { 8652, 0xFFF8 },
  /* 0x7400 */
  { 8665, 0x3FFF }, { 8679, 0xFEF6 }, { 8692, 0xFF7F }, { 8707, 0x97FF },
  { 8720, 0xEFFF }, { 8735, 0xFEFF }, { 8750, 0xFFBD }, { 8764, 0xF67F },
  { 8777, 0x3FEF }, { 8790, 0xDFB5 }, { 8802, 0xAFFB }, { 8815, 0xEFF7 },
  { 8829, 0x9D2F }, { 8839, 0xFFF9 }, { 8853, 0x53FF }, { 8865, 0xE9F7 },
  /* 0x7500 */
  { 8877, 0xF9BD }, { 8889, 0xF7FF }, { 8904, 0xFF66 }, { 8916, 0xEFBF },
  { 8930, 0xFDC5 }, { 8941, 0xBE3A }, { 8951, 0xFCFD }, { 8964, 0xE7C5 },
  { 8974, 0xFCD9 }, { 8985, 0x6737 }, { 8995, 0x0CBC }, { 9002, 0xFF7F },
  { 9017, 0xFDBF }, { 9031, 0xFFB7 }, { 9045, 0xA0DF }, { 9054, 0xFFFF },
  /* 0x7600 */
  { 9070, 0xBF8F }, { 9082, 0xFE7B }, { 9095, 0xB3FF }, { 9108, 0x3D3F },
  { 9119, 0xF3CD }, { 9130, 0x97DF }, { 9142, 0xF6F7 }, { 9155, 0xFF7F },
  { 9170, 0xCFD6 }, { 9181, 0x7E6D }, { 9192, 0xEC72 }, { 9201, 0xEDB1 },
  { 9211, 0x777C }, { 9222, 0xFE5C }, { 9233, 0xF6FA }, { 9245, 0x5FBF },
  /* 0x7700 */
  { 9258, 0xDFBA }, { 9270, 0xEE2F }, { 9281, 0xABFD }, { 9293, 0x7FFE },
  { 9307, 0xFCF9 }, { 9319, 0xDF74 }, { 9330, 0xFFEF }, { 9345, 0xFF84 },
  { 9355, 0xFBBF }, { 9369, 0xFFAA }, { 9381, 0xBDAF }, { 9393, 0xFEFF },
  { 9408, 0xFEBC }, { 9420, 0x7FB9 }, { 9432, 0xF3ED }, { 9444, 0x7F9F },
  /* 0x7800 */
  { 9457, 0xF36C }, { 9467, 0xF11F }, { 9477, 0xFFEF }, { 9492, 0x33BF },
  { 9503, 0x7FBC }, { 9515, 0x701F }, { 9523, 0xFF75 }, { 9536, 0xDE03 },
  { 9544, 0xF3FB }, { 9557, 0xC7FA }, { 9568, 0xBFBF }, { 9582, 0x5F5F },
  { 9594, 0xFFBA }, { 9607, 0xEDBF }, { 9620, 0xF7BF }, { 9634, 0xFEBF },
  /* 0x7900 */
  { 9648, 0x5276 }, { 9656, 0x7A9F }, { 9667, 0xFFFA }, { 9681, 0xFF7E },
  { 9695, 0x9FF7 }, { 9708, 0xFFFF }, { 9724, 0x2FBF }, { 9736, 0xF61F },
  { 9747, 0xEDCF }, { 9759, 0xBFFF }, { 9774, 0x7FF7 }, { 9788, 0xEFDF },
  { 9802, 0xFB73 }, { 9814, 0xF176 }, { 9824, 0x7EDD }, { 9836, 0x0DD2 },
  /* 0x7A00 */
  { 9843, 0x3D7D }, { 9854, 0xDFBF }, { 9868, 0xED45 }, { 9877, 0xFE83 },
  { 9887, 0x7FF9 }, { 9900, 0x9DD0 }, { 9908, 0x7BA7 }, { 9919, 0xEF73 },
  { 9931, 0x9FFB }, { 9944, 0xC3FF }, { 9956, 0xDF0D }, { 9966, 0xDDFF },
  { 9980, 0x8FBF }, { 9992, 0xBF0A }, { 10001, 0xEEFD }, { 10014, 0xEEC0 },
  /* 0x7B00 */
  { 10022, 0xDF73 }, { 10034, 0xEF1F }, { 10046, 0xFFFD }, { 10061, 0x0B3F },
  { 10070, 0xFFFD }, { 10085, 0x0177 }, { 10092, 0xF2FF }, { 10105, 0x09FF },
  { 10115, 0xFDB4 }, { 10126, 0x3BF7 }, { 10138, 0xB01F }, { 10146, 0x43B6 },
  { 10154, 0xDED3 }, { 10165, 0xFF31 }, { 10176, 0x1FFF }, { 10189, 0xFF9F },
  /* 0x7C00 */
  { 10203, 0xFEEF }, { 10217, 0xFA27 }, { 10227, 0x3FEF }, { 10240, 0xFBA9 },
  { 10251, 0x37BD }, { 10262, 0xBEDB }, { 10274, 0xFEF9 }, { 10287, 0xFF3D },
  { 10300, 0x777B }, { 10312, 0xD1F6 }, { 10322, 0xD1EE }, { 10332, 0xFF3E },
  { 10345, 0x7FAC }, { 10356, 0xF6FF }, { 10370, 0xF5C5 }, { 10380, 0x7BFF },
  /* 0x7D00 */
  { 10394, 0xFFFF }, { 10410, 0xFFFF }, { 10426, 0xDB27 }, { 10436, 0xFF6F },
  { 10450, 0xE4FF }, { 10462, 0xFD7F }, { 10476, 0xEFCE }, { 10488, 0xBE0F },
  { 10498, 0xFB7B }, { 10511, 0xF0DE }, { 10521, 0xFFDF }, { 10536, 0xFFBF },
  { 10551, 0xFEF7 }, { 10565, 0xFF9D }, { 10578, 0xD7FB }, { 10591, 0x6EFF },
  /* 0x7E00 */
  { 10604, 0xFF88 }, { 10614, 0xFCFF }, { 10628, 0xEEBF }, { 10641, 0xFFFF },
  { 10657, 0x13FF }, { 10668, 0xDFFF }, { 10683, 0xFFAF }, { 10697, 0xFFFD },
  { 10712, 0xFDC7 }, { 10724, 0x9FFE }, { 10737, 0x1010 }, { 10739, 0x0400 },
  { 10740, 0x8080 }, { 10742, 0x8000 }, { 10743, 0x0000 }, { 10743, 0x0000 },
  /* 0x7F00 */
  { 10743, 0x0040 }, { 10744, 0x0000 }, { 10744, 0x0000 }, { 10744, 0xE7C0 },
  { 10752, 0xFFBB }, { 10766, 0xF93F }, { 10778, 0x7FEB }, { 10791, 0xFFEF },
  { 10806, 0xFFE8 }, { 10818, 0x7CFE }, { 10830, 0xF3FF }, { 10844, 0xFFFF },
  { 10860, 0xFEAF }, { 10873, 0xF8B7 }, { 10884, 0xFFEF }, { 10899, 0xFFBF },
  /* 0x8000 */
  { 10914, 0xF9FF }, { 10928, 0xFBF7 }, { 10942, 0xD773 }, { 10953, 0xFAFB },
  { 10966, 0x85C8 }, { 10972, 0x7D57 }, { 10983, 0x90DE }, { 10991, 0xE3EF },
  { 11003, 0x9EF5 }, { 11014, 0xBF6D }, { 11026, 0xEEAE }, { 11037, 0x35F6 },
  { 11047, 0xF7FC }, { 11060, 0x7FF3 }, { 11073, 0xB27B }, { 11083, 0x7F7F },
  /* 0x8100 */
  { 11097, 0x57EF }, { 11109, 0xEFF4 }, { 11121, 0xBEBE }, { 11133, 0x6695 },
  { 11141, 0xFDDC }, { 11153, 0x5E7F }, { 11165, 0xEAF7 }, { 11177, 0x97DF },
  { 11189, 0xBFDD }, { 11202, 0xFFA8 }, { 11213, 0x5FED }, { 11225, 0xFEFF },
  { 11240, 0xB7FF }, { 11254, 0xEFA7 }, { 11266, 0xF7FF }, { 11281, 0xDFDC },
  /* 0x8200 */
  { 11293, 0x3FB7 }, { 11305, 0xFD77 }, { 11318, 0xBF67 }, { 11330, 0xF7FC },
  { 11343, 0xCAB5 }, { 11352, 0xDFFF }, { 11367, 0xFB7E }, { 11380, 0xFFF6 },
  { 11394, 0xECB9 }, { 11404, 0xEF1F }, { 11416, 0xFFFF }, { 11432, 0xFFFB },
  { 11447, 0x841D }, { 11453, 0xDBFF }, { 11467, 0xFDFF }, { 11482, 0xFFFF },
  /* 0x8300 */
  { 11498, 0x3BFF }, { 11511, 0x7FC0 }, { 11520, 0xBFF5 }, { 11533, 0xBFFE },
  { 11547, 0xFFBF }, { 11562, 0x00DF }, { 11569, 0x804C }, { 11573, 0xFDF8 },
  { 11585, 0xFFEA }, { 11598, 0x7FFF }, { 11613, 0xDFFD }, { 11627, 0xE201 },
  { 11632, 0xFFFF }, { 11648, 0xFBFA }, { 11661, 0xFFBF }, { 11676, 0xFF7F },
  /* 0x8400 */
  { 11691, 0xFEFA }, { 11704, 0x195F }, { 11713, 0xFA5B }, { 11724, 0xFFFF },
  { 11740, 0x7FFD }, { 11754, 0xFFFF }, { 11770, 0xFBFF }, { 11785, 0xE7FF },
  { 11799, 0xE145 }, { 11806, 0xFFDF }, { 11821, 0xFF9F }, { 11835, 0xFF57 },
  { 11848, 0xFEF7 }, { 11862, 0x4CDF }, { 11872, 0xDFB6 }, { 11884, 0xFFDF },
  /* 0x8500 */
  { 11899, 0xFFED }, { 11913, 0xF7FF }, { 11928, 0xFFFB }, { 11943, 0x691B },
  { 11951, 0x7FFF }, { 11966, 0xEFFE }, { 11980, 0xFFFF }, { 11996, 0x5FEB },
  { 12008, 0xFFFF }, { 12024, 0xFFF3 }, { 12038, 0x87DF }, { 12049, 0xE7FB },
  { 12062, 0xEBFF }, { 12076, 0xF7E7 }, { 12089, 0xFF7F }, { 12104, 0xFFC7 },
  /* 0x8600 */
  { 12117, 0xBEF7 }, { 12130, 0xDFD3 }, { 12142, 0xF7FF }, { 12157, 0xDF7E },
  { 12170, 0x79ED }, { 12181, 0xDA7D }, { 12192, 0xFFBE }, { 12206, 0x5E9F },
  { 12217, 0x7CE0 }, { 12225, 0x77FF }, { 12239, 0xA7BF }, { 12251, 0xFFFF },
  { 12267, 0x1BFF }, { 12279, 0xFFDB }, { 12293, 0xBF5C }, { 12304, 0x4FE0 },
  /* 0x8700 */
  { 12312, 0x7FFF }, { 12327, 0x5F0E }, { 12336, 0x77FF }, { 12350, 0xDDBF },
  { 12363, 0xF04F }, { 12372, 0xFFFF }, { 12388, 0xFFFF }, { 12404, 0x2FFB },
  { 12416, 0xBBFE }, { 12429, 0xFDDF }, { 12443, 0xFE3C }, { 12454, 0xFFFF },
  { 12470, 0x5F7F }, { 12483, 0xFFDE }, { 12497, 0xFDFF }, { 12512, 0xDEFC },
  /* 0x8800 */
  { 12524, 0xBF7F }, { 12538, 0xBBFB }, { 12551, 0xFFFF }, { 12567, 0xFBEF },
  { 12581, 0xFD7F }, { 12595, 0x6EEC }, { 12605, 0xEFBF }, { 12619, 0xF2F7 },
  { 12631, 0xFB9F }, { 12644, 0xDFEF }, { 12658, 0x5D97 }, { 12668, 0xF7F6 },
  { 12681, 0xFEA7 }, { 12693, 0xFFF5 }, { 12707, 0xD9C2 }, { 12715, 0xFFFF },
  /* 0x8900 */
  { 12731, 0x5EE7 }, { 12742, 0xC7FF }, { 12755, 0xFEFE }, { 12769, 0x79EF },
  { 12781, 0xBADE }, { 12792, 0xFFDF }, { 12807, 0xFE7F }, { 12821, 0xDEDE },
  { 12833, 0x8FEF }, { 12845, 0xF9FA }, { 12857, 0xF6FE }, { 12870, 0xF6C4 },
  { 12879, 0x0043 }, { 12882, 0xBE7C }, { 12893, 0x3BFF }, { 12906, 0xDDDF },
  /* 0x8A00 */
  { 12919, 0xD59D }, { 12929, 0xF9EF }, { 12942, 0x3EAC }, { 12951, 0xFF53 },
  { 12963, 0xF773 }, { 12975, 0x4BF7 }, { 12986, 0x7BCF }, { 12998, 0xDEFF },
  { 13012, 0xB8FE }, { 13023, 0x577F }, { 13035, 0x8FFB }, { 13047, 0xFF55 },
  { 13059, 0xABFD }, { 13071, 0xFFFE }, { 13086, 0xEDD7 }, { 13098, 0xDDFF },
  /* 0x8B00 */
  { 13112, 0xFDF7 }, { 13126, 0xFFFF }, { 13142, 0xFDFD }, { 13156, 0xFEEB },
  { 13169, 0xFFEF }, { 13184, 0xF7FF }, { 13199, 0xBFED }, { 13212, 0xEF91 },
  { 13222, 0x5D7F }, { 13234, 0xDF7D }, { 13247, 0x0001 }, { 13248, 0x4000 },
  { 13249, 0x0000 }, { 13249, 0x0000 }, { 13249, 0x0004 }, { 13250, 0x0000 },
  /* 0x8C00 */
  { 13250, 0x0000 }, { 13250, 0x0000 }, { 13250, 0x0000 }, { 13250, 0xFA80 },
  { 13257, 0xFFEE }, { 13271, 0xB4F3 }, { 13281, 0xBF76 }, { 13293, 0x2FEF },
  { 13305, 0xB677 }, { 13316, 0xFFBF }, { 13331, 0xBFBF }, { 13345, 0xFFFD },
  { 13360, 0xB5BF }, { 13372, 0xFEFE }, { 13386, 0x7FFF }, { 13401, 0x7FBF },
  /* 0x8D00 */
  { 13415, 0xBFFD }, { 13429, 0x3BFF }, { 13442, 0x0000 }, { 13442, 0x0000 },
  { 13442, 0x0000 }, { 13442, 0x0000 }, { 13442, 0xFBD0 }, { 13452, 0x2FDD },
  { 13463, 0xF637 }, { 13474, 0x9A7F }, { 13485, 0xFFEB }, { 13499, 0xD6FC },
  { 13510, 0xF9EF }, { 13523, 0xBFFB }, { 13537, 0xDFDF }, { 13551, 0xF41F },
  /* 0x8E00 */
  { 13561, 0xE6FF }, { 13574, 0xFFFF }, { 13590, 0x6FFF }, { 13604, 0xF77B },
  { 13617, 0xFFF7 }, { 13632, 0xFEF9 }, { 13645, 0xB7FF }, { 13659, 0x5DFE },
  { 13671, 0x7FF7 }, { 13685, 0xE5FF }, { 13698, 0x3FFB }, { 13711, 0x3645 },
  { 13718, 0xFE0D }, { 13728, 0xFD9E }, { 13740, 0xFBF7 }, { 13754, 0xDFF6 },
  /* 0x8F00 */
  { 13767, 0x6FEF }, { 13780, 0xFFFF }, { 13796, 0xF679 }, { 13807, 0xCBFD },
  { 13819, 0xEFFF }, { 13834, 0xFFFF }, { 13850, 0x40DF }, { 13858, 0x0000 },
  { 13858, 0x0000 }, { 13858, 0x9808 }, { 13862, 0xE1E9 }, { 13871, 0xDFFF },
  { 13886, 0xFE76 }, { 13898, 0x04FF }, { 13907, 0x6D7F }, { 13919, 0xFFF1 },
  /* 0x9000 */
  { 13932, 0xB97F }, { 13944, 0xFEF7 }, { 13958, 0xE01F }, { 13966, 0xF1FE },
  { 13978, 0xFE96 }, { 13989, 0x7B7F }, { 14002, 0xFB9F }, { 14015, 0xFFFD },
  { 14030, 0xADFF }, { 14043, 0xCBB3 }, { 14053, 0xC5EF }, { 14064, 0xE97F },
  { 14076, 0x4DBA }, { 14085, 0xBFF0 }, { 14096, 0xBF3F }, { 14109, 0xFE3F },
  /* 0x9100 */
  { 14122, 0xEBFF }, { 14136, 0xFFD7 }, { 14150, 0xFFDF }, { 14165, 0xCF7F },
  { 14178, 0xFFFB }, { 14193, 0xD7EF }, { 14206, 0xD7BF }, { 14219, 0x17FD },
  { 14230, 0xFEFF }, { 14245, 0xFE0F }, { 14256, 0xFFAF }, { 14270, 0x7EFF },
  { 14284, 0xFAFF }, { 14298, 0xB7FB }, { 14311, 0x7FFC }, { 14324, 0xE7FA },
  /* 0x9200 */
  { 14336, 0xF7FF }, { 14351, 0x56FF }, { 14363, 0x6DFA }, { 14374, 0xF7FF },
  { 14389, 0xFF73 }, { 14402, 0xEDFF }, { 14416, 0xF8FF }, { 14429, 0xFFC5 },
  { 14441, 0xFFFF }, { 14457, 0x3FFA }, { 14469, 0x5FFF }, { 14483, 0xDEFE },
  { 14496, 0xFFFF }, { 14512, 0xEBBF }, { 14525, 0xDFFB }, { 14539, 0xFFDF },
  /* 0x9300 */
  { 14554, 0xFBDF }, { 14568, 0xEF7D }, { 14581, 0xFFFF }, { 14597, 0x137B },
  { 14606, 0xFFFF }, { 14622, 0xDFF7 }, { 14636, 0x7FFF }, { 14651, 0x7FFB },
  { 14665, 0xF7FF }, { 14680, 0xFFF7 }, { 14695, 0xF7FF }, { 14710, 0xA9BF },
  { 14721, 0xFDDD }, { 14734, 0xFFFF }, { 14750, 0x51DF }, { 14760, 0xFFFB },
  /* 0x9400 */
  { 14775, 0xFFDB }, { 14789, 0x2BFF }, { 14801, 0x7FF1 }, { 14813, 0xFFEF },
  { 14828, 0xBFFD }, { 14842, 0x69B7 }, { 14852, 0xFFBD }, { 14866, 0xFBFF },
  { 14881, 0x002F }, { 14886, 0x8000 }, { 14887, 0x0004 }, { 14888, 0x0000 },
  { 14888, 0x000A }, { 14890, 0x1000 }, { 14891, 0x0000 }, { 14891, 0x0040 },
  /* 0x9500 */
  { 14892, 0x0000 }, { 14892, 0x0000 }, { 14892, 0x2000 }, { 14893, 0x0000 },
  { 14893, 0x0080 }, { 14894, 0x0000 }, { 14894, 0x0000 }, { 14894, 0xBD80 },
  { 14901, 0xFB6D }, { 14913, 0xDBDF }, { 14926, 0x7FFF }, { 14941, 0xFEE3 },
  { 14953, 0x3FE9 }, { 14964, 0xDC7F }, { 14976, 0x013F }, { 14983, 0x0010 },
  /* 0x9600 */
  { 14984, 0x0000 }, { 14984, 0x7000 }, { 14987, 0xF51F }, { 14998, 0xBF0F },
  { 15009, 0xFC3F }, { 15021, 0xF95B }, { 15032, 0xBE1E }, { 15042, 0x79FF },
  { 15055, 0xEFFB }, { 15069, 0x5BFE }, { 15081, 0x57BE }, { 15092, 0xBB5B },
  { 15103, 0x7FFF }, { 15118, 0xFFFC }, { 15132, 0x872E }, { 15140, 0xAFF7 },
  /* 0x9700 */
  { 15153, 0xEBFD }, { 15166, 0xFB4F }, { 15178, 0xDFFF }, { 15193, 0xE767 },
  { 15204, 0x0BDF }, { 15214, 0xFDE6 }, { 15226, 0x7747 }, { 15236, 0xFDDF },
  { 15250, 0xEFBF }, { 15264, 0xFF90 }, { 15274, 0x7D7F }, { 15287, 0xEFDE },
  { 15300, 0xFBFF }, { 15315, 0xF3FD }, { 15328, 0x606B }, { 15335, 0xEF6F },
  /* 0x9800 */
  { 15348, 0xF5FF }, { 15362, 0xF9FF }, { 15376, 0xEBDB }, { 15388, 0x0BBD },
  { 15397, 0xFFFA }, { 15411, 0xFB8F }, { 15423, 0x9FFD }, { 15436, 0x003F },
  { 15442, 0x0000 }, { 15442, 0x0000 }, { 15442, 0xF300 }, { 15448, 0xFFDE },
  { 15462, 0x5FDF }, { 15475, 0xD800 }, { 15479, 0xBEEF }, { 15492, 0x7676 },
  /* 0x9900 */
  { 15502, 0x57AD }, { 15512, 0xDFFF }, { 15527, 0xFFB2 }, { 15539, 0xFFAF },
  { 15553, 0x7FAF }, { 15566, 0xFBFF }, { 15581, 0x000E }, { 15584, 0x0000 },
  { 15584, 0x0000 }, { 15584, 0x7BC0 }, { 15592, 0xFDFA }, { 15605, 0x3F3F },
  { 15617, 0xFABE }, { 15629, 0xBFFF }, { 15644, 0x76FF }, { 15657, 0xFFF3 },
  /* 0x9A00 */
  { 15671, 0xFEFE }, { 15685, 0xFE73 }, { 15697, 0xFEFF }, { 15712, 0xFFF7 },
  { 15727, 0xF77F }, { 15741, 0xDFFD }, { 15755, 0x1FFD }, { 15767, 0x0000 },
  { 15767, 0x8000 }, { 15768, 0x0000 }, { 15768, 0xA900 }, { 15772, 0xFFDF },
  { 15787, 0xA4C7 }, { 15795, 0x91FF }, { 15806, 0xF8CF }, { 15817, 0xFEDE },
  /* 0x9B00 */
  { 15830, 0xFF7E }, { 15844, 0xC7F7 }, { 15856, 0xEFBD }, { 15869, 0xDEBE },
  { 15881, 0xFD7F }, { 15895, 0x8F77 }, { 15906, 0x93D3 }, { 15915, 0xFCF3 },
  { 15927, 0xE9EF }, { 15939, 0xECAF }, { 15950, 0xED77 }, { 15962, 0xA361 },
  { 15969, 0x87DB }, { 15979, 0x7EF8 }, { 15990, 0x3FF7 }, { 16003, 0xA193 },
  /* 0x9C00 */
  { 16010, 0x7FE4 }, { 16021, 0xB8BD }, { 16031, 0xBB7B }, { 16043, 0xFEFE },
  { 16057, 0xFF73 }, { 16070, 0xE3FD }, { 16082, 0x61CD }, { 16090, 0x1FBE },
  { 16101, 0x0000 }, { 16101, 0x0000 }, { 16101, 0x0000 }, { 16101, 0x0000 },
  { 16101, 0x0000 }, { 16101, 0x0000 }, { 16101, 0x26E0 }, { 16107, 0xBEFE },
  /* 0x9D00 */
  { 16120, 0x13FD }, { 16130, 0xEBF5 }, { 16142, 0xE36F }, { 16153, 0xEBDB },
  { 16165, 0xDE3F }, { 16177, 0xFFDF }, { 16192, 0xFF83 }, { 16203, 0xFBBF },
  { 16217, 0x1FFF }, { 16230, 0xFFDD }, { 16244, 0xBFFF }, { 16259, 0xFFFE },
  { 16274, 0xFFBF }, { 16289, 0xFFFF }, { 16305, 0xFB7E }, { 16318, 0xFFFD },
  /* 0x9E00 */
  { 16333, 0xFEFF }, { 16348, 0xFFBF }, { 16363, 0x0000 }, { 16363, 0x0000 },
  { 16363, 0x0000 }, { 16363, 0x0000 }, { 16363, 0x0000 }, { 16363, 0xBE20 },
  { 16370, 0x7FFF }, { 16385, 0xFFFF }, { 16401, 0xFFF7 }, { 16416, 0xF8F3 },
  { 16427, 0xF1DF }, { 16439, 0xFD7B }, { 16452, 0xE9F5 }, { 16463, 0xFFFF },
  /* 0x9F00 */
  { 16479, 0xC7C7 }, { 16489, 0x5FED }, { 16501, 0xFFFD }, { 16516, 0x6BFF },
  { 16529, 0xFFFF }, { 16545, 0xFFFD }, { 16560, 0xDEFF }, { 16574, 0xCFF7 },
  { 16587, 0x6000 }, { 16589, 0x9337 }, { 16598, 0x0035 },
};
static const Summary16 big5hkscs_uni2index_pagee0[419] = {
  /* 0xE000 */
  { 16602, 0xFFFF }, { 16618, 0xFFFF }, { 16634, 0xFFFF }, { 16650, 0xFFFF },
  { 16666, 0xFFFF }, { 16682, 0xFFFF }, { 16698, 0xFFFF }, { 16714, 0xFFFF },
  { 16730, 0xFFFF }, { 16746, 0xFFFF }, { 16762, 0xFFFF }, { 16778, 0xFFFF },
  { 16794, 0xFFFF }, { 16810, 0xFFFF }, { 16826, 0xFFFF }, { 16842, 0xFFFF },
  /* 0xE100 */
  { 16858, 0xFFFF }, { 16874, 0xFFFF }, { 16890, 0xFFFF }, { 16906, 0xFFFF },
  { 16922, 0xFFFF }, { 16938, 0xFFFF }, { 16954, 0xFFFF }, { 16970, 0xFFFF },
  { 16986, 0xFFFF }, { 17002, 0xFFFF }, { 17018, 0xFFFF }, { 17034, 0xFFFF },
  { 17050, 0xFFFF }, { 17066, 0xFFFF }, { 17082, 0xFFFF }, { 17098, 0xFFFF },
  /* 0xE200 */
  { 17114, 0xFFFF }, { 17130, 0xFFFF }, { 17146, 0xFFFF }, { 17162, 0xFFFF },
  { 17178, 0xFFFF }, { 17194, 0xFFFF }, { 17210, 0xFFFF }, { 17226, 0xFFFF },
  { 17242, 0xFFFF }, { 17258, 0xFFFF }, { 17274, 0xFFFF }, { 17290, 0xFFFF },
  { 17306, 0xFFFF }, { 17322, 0xFFFF }, { 17338, 0xFFFF }, { 17354, 0xFFFF },
  /* 0xE300 */
  { 17370, 0xFFFF }, { 17386, 0xFFFF }, { 17402, 0xFFFF }, { 17418, 0xFFFF },
  { 17434, 0xFFFF }, { 17450, 0xFFFF }, { 17466, 0xFFFF }, { 17482, 0xFFFF },
  { 17498, 0xFFFF }, { 17514, 0xFFFF }, { 17530, 0xFFFF }, { 17546, 0xFFFF },
  { 17562, 0xFFFF }, { 17578, 0xFFFF }, { 17594, 0xFFFF }, { 17610, 0xFFFF },
  /* 0xE400 */
  { 17626, 0xFFFF }, { 17642, 0xFFFF }, { 17658, 0xFFFF }, { 17674, 0xFFFF },
  { 17690, 0xFFFF }, { 17706, 0xFFFF }, { 17722, 0xFFFF }, { 17738, 0xFFFF },
  { 17754, 0xFFFF }, { 17770, 0xFFFF }, { 17786, 0xFFFF }, { 17802, 0xFFFF },
  { 17818, 0xFFFF }, { 17834, 0xFFFF }, { 17850, 0xFFFF }, { 17866, 0xFFFF },
  /* 0xE500 */
  { 17882, 0xFFFF }, { 17898, 0xFFFF }, { 17914, 0xFFFF }, { 17930, 0xFFFF },
  { 17946, 0xFFFF }, { 17962, 0xFFFF }, { 17978, 0xFFFF }, { 17994, 0xFFFF },
  { 18010, 0xFFFF }, { 18026, 0xFFFF }, { 18042, 0xFFFF }, { 18058, 0xFFFF },
  { 18074, 0xFFFF }, { 18090, 0xFFFF }, { 18106, 0xFFFF }, { 18122, 0xFFFF },
  /* 0xE600 */
  { 18138, 0xFFFF }, { 18154, 0xFFFF }, { 18170, 0xFFFF }, { 18186, 0xFFFF },
  { 18202, 0xFFFF }, { 18218, 0xFFFF }, { 18234, 0xFFFF }, { 18250, 0xFFFF },
  { 18266, 0xFFFF }, { 18282, 0xFFFF }, { 18298, 0xFFFF }, { 18314, 0xFFFF },
  { 18330, 0xFFFF }, { 18346, 0xFFFF }, { 18362, 0xFFFF }, { 18378, 0xFFFF },
  /* 0xE700 */
  { 18394, 0xFFFF }, { 18410, 0xFFFF }, { 18426, 0xFFFF }, { 18442, 0xFFFF },
  { 18458, 0xFFFF }, { 18474, 0xFFFF }, { 18490, 0xFFFF }, { 18506, 0xFFFF },
  { 18522, 0xFFFF }, { 18538, 0xFFFF }, { 18554, 0xFFFF }, { 18570, 0xFFFF },
  { 18586, 0xFFFF }, { 18602, 0xFFFF }, { 18618, 0xFFFF }, { 18634, 0xFFFF },
  /* 0xE800 */
  { 18650, 0xFFFF }, { 18666, 0xFFFF }, { 18682, 0xFFFF }, { 18698, 0xFFFF },
  { 18714, 0xFFFF }, { 18730, 0xFFFF }, { 18746, 0xFFFF }, { 18762, 0xFFFF },
  { 18778, 0xFFFF }, { 18794, 0xFFFF }, { 18810, 0xFFFF }, { 18826, 0xFFFF },
  { 18842, 0xFFFF }, { 18858, 0xFFFF }, { 18874, 0xFFFF }, { 18890, 0xFFFF },
  /* 0xE900 */
  { 18906, 0xFFFF }, { 18922, 0xFFFF }, { 18938, 0xFFFF }, { 18954, 0xFFFF },
  { 18970, 0xFFFF }, { 18986, 0xFFFF }, { 19002, 0xFFFF }, { 19018, 0xFFFF },
  { 19034, 0xFFFF }, { 19050, 0xFFFF }, { 19066, 0xFFFF }, { 19082, 0xFFFF },
  { 19098, 0xFFFF }, { 19114, 0xFFFF }, { 19130, 0xFFFF }, { 19146, 0xFFFF },
  /* 0xEA00 */
  { 19162, 0xFFFF }, { 19178, 0xFFFF }, { 19194, 0xFFFF }, { 19210, 0xFFFF },
  { 19226, 0xFFFF }, { 19242, 0xFFFF }, { 19258, 0xFFFF }, { 19274, 0xFFFF },
  { 19290, 0xFFFF }, { 19306, 0xFFFF }, { 19322, 0xFFFF }, { 19338, 0xFFFF },
  { 19354, 0xFFFF }, { 19370, 0xFFFF }, { 19386, 0xFFFF }, { 19402, 0xFFFF },
  /* 0xEB00 */
  { 19418, 0xFFFF }, { 19434, 0xFFFF }, { 19450, 0xFFFF }, { 19466, 0xFFFF },
  { 19482, 0xFFFF }, { 19498, 0xFFFF }, { 19514, 0xFFFF }, { 19530, 0xFFFF },
  { 19546, 0xFFFF }, { 19562, 0xFFFF }, { 19578, 0xFFFF }, { 19594, 0xFFFF },
  { 19610, 0xFFFF }, { 19626, 0xFFFF }, { 19642, 0xFFFF }, { 19658, 0xFFFF },
  /* 0xEC00 */
  { 19674, 0xFFFF }, { 19690, 0xFFFF }, { 19706, 0xFFFF }, { 19722, 0xFFFF },
  { 19738, 0xFFFF }, { 19754, 0xFFFF }, { 19770, 0xFFFF }, { 19786, 0xFFFF },
  { 19802, 0xFFFF }, { 19818, 0xFFFF }, { 19834, 0xFFFF }, { 19850, 0xFFFF },
  { 19866, 0xFFFF }, { 19882, 0xFFFF }, { 19898, 0xFFFF }, { 19914, 0xFFFF },
  /* 0xED00 */
  { 19930, 0xFFFF }, { 19946, 0xFFFF }, { 19962, 0xFFFF }, { 19978, 0xFFFF },
  { 19994, 0xFFFF }, { 20010, 0xFFFF }, { 20026, 0xFFFF }, { 20042, 0xFFFF },
  { 20058, 0xFFFF }, { 20074, 0xFFFF }, { 20090, 0xFFFF }, { 20106, 0xFFFF },
  { 20122, 0xFFFF }, { 20138, 0xFFFF }, { 20154, 0xFFFF }, { 20170, 0xFFFF },
  /* 0xEE00 */
  { 20186, 0xFFFF }, { 20202, 0xFFFF }, { 20218, 0xFFFF }, { 20234, 0xFFFF },
  { 20250, 0xFFFF }, { 20266, 0xFFFF }, { 20282, 0xFFFF }, { 20298, 0xFFFF },
  { 20314, 0xFFFF }, { 20330, 0xFFFF }, { 20346, 0xFFFF }, { 20362, 0xFFFF },
  { 20378, 0xFFFF }, { 20394, 0xFFFF }, { 20410, 0xFFFF }, { 20426, 0xFFFF },
  /* 0xEF00 */
  { 20442, 0xFFFF }, { 20458, 0xFFFF }, { 20474, 0xFFFF }, { 20490, 0xFFFF },
  { 20506, 0xFFFF }, { 20522, 0xFFFF }, { 20538, 0xFFFF }, { 20554, 0xFFFF },
  { 20570, 0xFFFF }, { 20586, 0xFFFF }, { 20602, 0xFFFF }, { 20618, 0xFFFF },
  { 20634, 0xFFFF }, { 20650, 0xFFFF }, { 20666, 0xFFFF }, { 20682, 0xFFFF },
  /* 0xF000 */
  { 20698, 0xFFFF }, { 20714, 0xFFFF }, { 20730, 0xFFFF }, { 20746, 0xFFFF },
  { 20762, 0xFFFF }, { 20778, 0xFFFF }, { 20794, 0xFFFF }, { 20810, 0xFFFF },
  { 20826, 0xFFFF }, { 20842, 0xFFFF }, { 20858, 0xFFFF }, { 20874, 0xFFFF },
  { 20890, 0xFFFF }, { 20906, 0xFFFF }, { 20922, 0xFFFF }, { 20938, 0xFFFF },
  /* 0xF100 */
  { 20954, 0xFFFF }, { 20970, 0xFFFF }, { 20986, 0xFFFF }, { 21002, 0xFFFF },
  { 21018, 0xFFFF }, { 21034, 0xFFFF }, { 21050, 0xFFFF }, { 21066, 0xFFFF },
  { 21082, 0xFFFF }, { 21098, 0xFFFF }, { 21114, 0xFFFF }, { 21130, 0xFFFF },
  { 21146, 0xFFFF }, { 21162, 0xFFFF }, { 21178, 0xFFFF }, { 21194, 0xFFFF },
  /* 0xF200 */
  { 21210, 0xFFFF }, { 21226, 0xFFFF }, { 21242, 0xFFFF }, { 21258, 0xFFFF },
  { 21274, 0xFFFF }, { 21290, 0xFFFF }, { 21306, 0xFFFF }, { 21322, 0xFFFF },
  { 21338, 0xFFFF }, { 21354, 0xFFFF }, { 21370, 0xFFFF }, { 21386, 0xFFFF },
  { 21402, 0xFFFF }, { 21418, 0xFFFF }, { 21434, 0xFFFF }, { 21450, 0xFFFF },
  /* 0xF300 */
  { 21466, 0xFFFF }, { 21482, 0xFFFF }, { 21498, 0xFFFF }, { 21514, 0xFFFF },
  { 21530, 0xFFFF }, { 21546, 0xFFFF }, { 21562, 0xFFFF }, { 21578, 0xFFFF },
  { 21594, 0xFFFF }, { 21610, 0xFFFF }, { 21626, 0xFFFF }, { 21642, 0xFFFF },
  { 21658, 0xFFFF }, { 21674, 0xFFFF }, { 21690, 0xFFFF }, { 21706, 0xFFFF },
  /* 0xF400 */
  { 21722, 0xFFFF }, { 21738, 0xFFFF }, { 21754, 0xFFFF }, { 21770, 0xFFFF },
  { 21786, 0xFFFF }, { 21802, 0xFFFF }, { 21818, 0xFFFF }, { 21834, 0xFFFF },
  { 21850, 0xFFFF }, { 21866, 0xFFFF }, { 21882, 0xFFFF }, { 21898, 0xFFFF },
  { 21914, 0xFFFF }, { 21930, 0xFFFF }, { 21946, 0xFFFF }, { 21962, 0xFFFF },
  /* 0xF500 */
  { 21978, 0xFFFF }, { 21994, 0xFFFF }, { 22010, 0xFFFF }, { 22026, 0xFFFF },
  { 22042, 0xFFFF }, { 22058, 0xFFFF }, { 22074, 0xFFFF }, { 22090, 0xFFFF },
  { 22106, 0xFFFF }, { 22122, 0xFFFF }, { 22138, 0xFFFF }, { 22154, 0xFFFF },
  { 22170, 0xFFFF }, { 22186, 0xFFFF }, { 22202, 0xFFFF }, { 22218, 0xFFFF },
  /* 0xF600 */
  { 22234, 0xFFFF }, { 22250, 0xFFFF }, { 22266, 0xFFFF }, { 22282, 0xFFFF },
  { 22298, 0xFFFF }, { 22314, 0xFFFF }, { 22330, 0xFFFF }, { 22346, 0xFFFF },
  { 22362, 0xFFFF }, { 22378, 0xFFFF }, { 22394, 0xFFFF }, { 22410, 0xFFFF },
  { 22426, 0xFFFF }, { 22442, 0xFFFF }, { 22458, 0xFFFF }, { 22474, 0xFFFF },
  /* 0xF700 */
  { 22490, 0xFFFF }, { 22506, 0xFFFF }, { 22522, 0xFFFF }, { 22538, 0xFFFF },
  { 22554, 0xFFFF }, { 22570, 0xFFFF }, { 22586, 0xFFFF }, { 22602, 0xFFFF },
  { 22618, 0xFFFF }, { 22634, 0xFFFF }, { 22650, 0xFFFF }, { 22666, 0xFFFF },
  { 22682, 0xFFFF }, { 22698, 0xFFFF }, { 22714, 0xFFFF }, { 22730, 0xFFFF },
  /* 0xF800 */
  { 22746, 0xFFFF }, { 22762, 0xFFFF }, { 22778, 0xFFFF }, { 22794, 0xFFFF },
  { 22810, 0x01FF }, { 22819, 0x0000 }, { 22819, 0x0000 }, { 22819, 0x0000 },
  { 22819, 0x0000 }, { 22819, 0x0000 }, { 22819, 0x0000 }, { 22819, 0x0000 },
  { 22819, 0x0000 }, { 22819, 0x0000 }, { 22819, 0x0000 }, { 22819, 0x0100 },
  /* 0xF900 */
  { 22820, 0xFFFF }, { 22836, 0xFFFF }, { 22852, 0xEFFF }, { 22867, 0xFFFF },
  { 22883, 0xFFFF }, { 22899, 0xFFFF }, { 22915, 0xFFFF }, { 22931, 0xFDFF },
  { 22946, 0xFFFF }, { 22962, 0xFFDF }, { 22977, 0xFFFF }, { 22993, 0xFFFF },
  { 23009, 0xFFFF }, { 23025, 0xFFFF }, { 23041, 0xFF7F }, { 23056, 0xFFFD },
  /* 0xFA00 */
  { 23071, 0x3FFF }, { 23085, 0x7EE5 }, { 23096, 0x3C64 },
};
static const Summary16 big5hkscs_uni2index_pagefe[31] = {
  /* 0xFE00 */
  { 23103, 0x0000 }, { 23103, 0x0000 }, { 23103, 0x0000 }, { 23103, 0xFFFB },
  { 23118, 0xFE1F }, { 23130, 0xFEF7 }, { 23144, 0x0F7F }, { 23155, 0x0000 },
  { 23155, 0x0000 }, { 23155, 0x0000 }, { 23155, 0x0000 }, { 23155, 0x0000 },
  { 23155, 0x0000 }, { 23155, 0x0000 }, { 23155, 0x0000 }, { 23155, 0x0000 },
  /* 0xFF00 */
  { 23155, 0xFFFE }, { 23170, 0xFFFF }, { 23186, 0xFFFF }, { 23202, 0xFFFF },
  { 23218, 0xFFFF }, { 23234, 0x7FFF }, { 23249, 0x0010 }, { 23250, 0x0000 },
  { 23250, 0x0000 }, { 23250, 0x0000 }, { 23250, 0x0000 }, { 23250, 0x0000 },
  { 23250, 0x0000 }, { 23250, 0x0000 }, { 23250, 0x203F },
};
static const Summary16 big5hkscs_uni2index_page200[2335] = {
  /* 0x20000 */
  { 23257, 0x0000 }, { 23257, 0x0000 }, { 23257, 0x0002 }, { 23258, 0x4000 },
  { 23259, 0x4040 }, { 23261, 0x0000 }, { 23261, 0x0100 }, { 23262, 0x0000 },
  { 23262, 0x04C0 }, { 23265, 0x0010 }, { 23266, 0x0000 }, { 23266, 0x0000 },
  { 23266, 0x3C00 }, { 23270, 0x0002 }, { 23271, 0x4000 }, { 23272, 0x0000 },
  /* 0x20100 */
  { 23272, 0x5000 }, { 23274, 0x0100 }, { 23275, 0x0000 }, { 23275, 0x0000 },
  { 23275, 0x0000 }, { 23275, 0x0000 }, { 23275, 0x0000 }, { 23275, 0x0000 },
  { 23275, 0x0000 }, { 23275, 0x0000 }, { 23275, 0x0A00 }, { 23277, 0x0000 },
  { 23277, 0x0002 }, { 23278, 0x0010 }, { 23279, 0x0000 }, { 23279, 0x0004 },
  /* 0x20200 */
  { 23280, 0x1010 }, { 23282, 0x0010 }, { 23283, 0x0000 }, { 23283, 0x0000 },
  { 23283, 0x0000 }, { 23283, 0x0800 }, { 23284, 0x0000 }, { 23284, 0x0030 },
  { 23286, 0x0000 }, { 23286, 0x4200 }, { 23288, 0x0001 }, { 23289, 0x8080 },
  { 23291, 0x0001 }, { 23292, 0x0000 }, { 23292, 0x0020 }, { 23293, 0x0000 },
  /* 0x20300 */
  { 23293, 0x0400 }, { 23294, 0x0000 }, { 23294, 0x0020 }, { 23295, 0x0000 },
  { 23295, 0x00E2 }, { 23299, 0x0000 }, { 23299, 0x0000 }, { 23299, 0xC000 },
  { 23301, 0x0001 }, { 23302, 0x0000 }, { 23302, 0x0081 }, { 23304, 0x0020 },
  { 23305, 0x0A00 }, { 23307, 0x0000 }, { 23307, 0x0000 }, { 23307, 0x1020 },
  /* 0x20400 */
  { 23309, 0x0000 }, { 23309, 0x8018 }, { 23312, 0x0000 }, { 23312, 0x0000 },
  { 23312, 0x0000 }, { 23312, 0x0000 }, { 23312, 0x0020 }, { 23313, 0x0000 },
  { 23313, 0x4080 }, { 23315, 0x0006 }, { 23317, 0x0008 }, { 23318, 0x0000 },
  { 23318, 0x0000 }, { 23318, 0x0080 }, { 23319, 0x0000 }, { 23319, 0x5000 },
  /* 0x20500 */
  { 23321, 0x0000 }, { 23321, 0x0000 }, { 23321, 0x0000 }, { 23321, 0x0000 },
  { 23321, 0x0080 }, { 23322, 0x0000 }, { 23322, 0x0000 }, { 23322, 0x0000 },
  { 23322, 0x4000 }, { 23323, 0x0000 }, { 23323, 0x0020 }, { 23324, 0x0008 },
  { 23325, 0x0408 }, { 23327, 0x8021 }, { 23330, 0x0801 }, { 23332, 0x0000 },
  /* 0x20600 */
  { 23332, 0x0000 }, { 23332, 0x0622 }, { 23336, 0x0000 }, { 23336, 0x0001 },
  { 23337, 0x0000 }, { 23337, 0x0040 }, { 23338, 0x0000 }, { 23338, 0x0040 },
  { 23339, 0x0000 }, { 23339, 0x0000 }, { 23339, 0x0000 }, { 23339, 0x0000 },
  { 23339, 0x0000 }, { 23339, 0x0000 }, { 23339, 0x0000 }, { 23339, 0x0000 },
  /* 0x20700 */
  { 23339, 0x4000 }, { 23340, 0x0000 }, { 23340, 0x0000 }, { 23340, 0x0002 },
  { 23341, 0x0000 }, { 23341, 0x0000 }, { 23341, 0x0000 }, { 23341, 0x0200 },
  { 23342, 0x0000 }, { 23342, 0x0000 }, { 23342, 0x0000 }, { 23342, 0x0000 },
  { 23342, 0x0000 }, { 23342, 0x0000 }, { 23342, 0x0000 }, { 23342, 0x0000 },
  /* 0x20800 */
  { 23342, 0x0000 }, { 23342, 0x0000 }, { 23342, 0x1000 }, { 23343, 0x0000 },
  { 23343, 0x0000 }, { 23343, 0x0000 }, { 23343, 0x0000 }, { 23343, 0x0008 },
  { 23344, 0x0000 }, { 23344, 0x0000 }, { 23344, 0x0000 }, { 23344, 0x0000 },
  { 23344, 0x0000 }, { 23344, 0x0020 }, { 23345, 0x0000 }, { 23345, 0x0000 },
  /* 0x20900 */
  { 23345, 0x0000 }, { 23345, 0x0040 }, { 23346, 0x0008 }, { 23347, 0x0000 },
  { 23347, 0x0000 }, { 23347, 0x0010 }, { 23348, 0x0000 }, { 23348, 0x0200 },
  { 23349, 0x0000 }, { 23349, 0x0000 }, { 23349, 0x0000 }, { 23349, 0x0000 },
  { 23349, 0x0000 }, { 23349, 0x0000 }, { 23349, 0x0080 }, { 23350, 0x0000 },
  /* 0x20A00 */
  { 23350, 0x0000 }, { 23350, 0x0002 }, { 23351, 0x0000 }, { 23351, 0x0000 },
  { 23351, 0x0000 }, { 23351, 0x0001 }, { 23352, 0x0000 }, { 23352, 0x0000 },
  { 23352, 0x0000 }, { 23352, 0x0000 }, { 23352, 0x0000 }, { 23352, 0x0010 },
  { 23353, 0x2004 }, { 23355, 0x0000 }, { 23355, 0x0000 }, { 23355, 0x0000 },
  /* 0x20B00 */
  { 23355, 0x2000 }, { 23356, 0x0000 }, { 23356, 0x0000 }, { 23356, 0x0000 },
  { 23356, 0x0000 }, { 23356, 0x0000 }, { 23356, 0x0000 }, { 23356, 0x0000 },
  { 23356, 0x8000 }, { 23357, 0x0000 }, { 23357, 0x0300 }, { 23359, 0x8000 },
  { 23360, 0x0840 }, { 23362, 0x0000 }, { 23362, 0x0804 }, { 23364, 0x8800 },
  /* 0x20C00 */
  { 23366, 0x2800 }, { 23368, 0x0000 }, { 23368, 0x0001 }, { 23369, 0x0C10 },
  { 23372, 0x000E }, { 23375, 0x0008 }, { 23376, 0x0020 }, { 23377, 0x1180 },
  { 23380, 0x2000 }, { 23381, 0x1040 }, { 23383, 0x0000 }, { 23383, 0x0120 },
  { 23385, 0x8000 }, { 23386, 0x2078 }, { 23391, 0x2000 }, { 23392, 0x8000 },
  /* 0x20D00 */
  { 23393, 0x0000 }, { 23393, 0x0020 }, { 23394, 0x0100 }, { 23395, 0x0006 },
  { 23397, 0x73C0 }, { 23404, 0x0000 }, { 23404, 0x8000 }, { 23405, 0xD012 },
  { 23410, 0x0000 }, { 23410, 0x1040 }, { 23412, 0x0080 }, { 23413, 0x0004 },
  { 23414, 0x0100 }, { 23415, 0x0000 }, { 23415, 0x0000 }, { 23415, 0x0000 },
  /* 0x20E00 */
  { 23415, 0xE610 }, { 23421, 0x2043 }, { 23425, 0x0000 }, { 23425, 0x0000 },
  { 23425, 0x1000 }, { 23426, 0x0000 }, { 23426, 0x2000 }, { 23427, 0x0FE8 },
  { 23435, 0x1000 }, { 23436, 0x2140 }, { 23439, 0x1C04 }, { 23443, 0x0040 },
  { 23444, 0x0000 }, { 23444, 0x2180 }, { 23447, 0x0000 }, { 23447, 0x0F00 },
  /* 0x20F00 */
  { 23451, 0x0000 }, { 23451, 0x2000 }, { 23452, 0x6040 }, { 23455, 0x0803 },
  { 23458, 0x1000 }, { 23459, 0x0000 }, { 23459, 0x0010 }, { 23460, 0x0000 },
  { 23460, 0x2000 }, { 23461, 0x0001 }, { 23462, 0x2000 }, { 23463, 0x1070 },
  { 23467, 0x0000 }, { 23467, 0x8000 }, { 23468, 0x3C00 }, { 23472, 0x0000 },
  /* 0x21000 */
  { 23472, 0x0000 }, { 23472, 0x6010 }, { 23475, 0x0000 }, { 23475, 0x0000 },
  { 23475, 0x8000 }, { 23476, 0x1000 }, { 23477, 0x8000 }, { 23478, 0x09E0 },
  { 23483, 0x0100 }, { 23484, 0x2040 }, { 23486, 0x0000 }, { 23486, 0x8010 },
  { 23488, 0x8383 }, { 23494, 0x0008 }, { 23495, 0x0010 }, { 23496, 0x0070 },
  /* 0x21100 */
  { 23499, 0x0000 }, { 23499, 0x0000 }, { 23499, 0x8000 }, { 23500, 0x2800 },
  { 23502, 0x8120 }, { 23505, 0x0000 }, { 23505, 0x0000 }, { 23505, 0x0000 },
  { 23505, 0x0081 }, { 23507, 0x0000 }, { 23507, 0x0000 }, { 23507, 0x0000 },
  { 23507, 0x0000 }, { 23507, 0x0200 }, { 23508, 0x0000 }, { 23508, 0x0000 },
  /* 0x21200 */
  { 23508, 0x0000 }, { 23508, 0x0000 }, { 23508, 0x0000 }, { 23508, 0x1000 },
  { 23509, 0x8000 }, { 23510, 0x0000 }, { 23510, 0x0000 }, { 23510, 0x1000 },
  { 23511, 0x0000 }, { 23511, 0x0000 }, { 23511, 0x0300 }, { 23513, 0x0001 },
  { 23514, 0x0000 }, { 23514, 0x0000 }, { 23514, 0x0008 }, { 23515, 0x4000 },
  /* 0x21300 */
  { 23516, 0x003C }, { 23520, 0x0000 }, { 23520, 0x0000 }, { 23520, 0x0440 },
  { 23522, 0x0000 }, { 23522, 0x0000 }, { 23522, 0x0000 }, { 23522, 0x0060 },
  { 23524, 0x4000 }, { 23525, 0x1100 }, { 23527, 0x0000 }, { 23527, 0x0000 },
  { 23527, 0x0060 }, { 23529, 0x0000 }, { 23529, 0x2000 }, { 23530, 0x4000 },
  /* 0x21400 */
  { 23531, 0x0000 }, { 23531, 0x0048 }, { 23533, 0x0010 }, { 23534, 0x8000 },
  { 23535, 0x0000 }, { 23535, 0x0034 }, { 23538, 0x0000 }, { 23538, 0x0000 },
  { 23538, 0x0400 }, { 23539, 0x0080 }, { 23540, 0x0000 }, { 23540, 0x0040 },
  { 23541, 0x0000 }, { 23541, 0x0000 }, { 23541, 0x0100 }, { 23542, 0x2000 },
  /* 0x21500 */
  { 23543, 0x0000 }, { 23543, 0x0000 }, { 23543, 0x0000 }, { 23543, 0x0000 },
  { 23543, 0x0000 }, { 23543, 0x0000 }, { 23543, 0x0000 }, { 23543, 0x0080 },
  { 23544, 0x0004 }, { 23545, 0x0040 }, { 23546, 0x0000 }, { 23546, 0x0000 },
  { 23546, 0x0000 }, { 23546, 0x0000 }, { 23546, 0x0000 }, { 23546, 0x0000 },
  /* 0x21600 */
  { 23546, 0x0400 }, { 23547, 0x0208 }, { 23549, 0x0000 }, { 23549, 0x4000 },
  { 23550, 0x0000 }, { 23550, 0x0000 }, { 23550, 0x0002 }, { 23551, 0x0000 },
  { 23551, 0x0000 }, { 23551, 0x0004 }, { 23552, 0x0000 }, { 23552, 0x0500 },
  { 23554, 0x0007 }, { 23557, 0x8028 }, { 23560, 0x01C0 }, { 23563, 0x5C00 },
  /* 0x21700 */
  { 23567, 0x2000 }, { 23568, 0x0001 }, { 23569, 0x0040 }, { 23570, 0x1C00 },
  { 23573, 0x0000 }, { 23573, 0x0080 }, { 23574, 0xF000 }, { 23578, 0x001B },
  { 23582, 0x0000 }, { 23582, 0x0000 }, { 23582, 0x0800 }, { 23583, 0x003F },
  { 23589, 0x0088 }, { 23591, 0x9E00 }, { 23596, 0x8000 }, { 23597, 0x1F60 },
  /* 0x21800 */
  { 23604, 0x0000 }, { 23604, 0x0000 }, { 23604, 0x2701 }, { 23609, 0x0E00 },
  { 23612, 0x0021 }, { 23614, 0x4004 }, { 23616, 0x001E }, { 23620, 0x0880 },
  { 23622, 0x0038 }, { 23625, 0xC000 }, { 23627, 0x0007 }, { 23630, 0xC000 },
  { 23632, 0x0000 }, { 23632, 0x03C2 }, { 23637, 0x0000 }, { 23637, 0x0400 },
  /* 0x21900 */
  { 23638, 0x0038 }, { 23641, 0x1027 }, { 23646, 0x0084 }, { 23648, 0x0800 },
  { 23649, 0x0010 }, { 23650, 0x0100 }, { 23651, 0x0400 }, { 23652, 0x1000 },
  { 23653, 0x0109 }, { 23656, 0x0040 }, { 23657, 0x0000 }, { 23657, 0x0000 },
  { 23657, 0x0000 }, { 23657, 0x0800 }, { 23658, 0x0000 }, { 23658, 0x0008 },
  /* 0x21A00 */
  { 23659, 0x0000 }, { 23659, 0x0000 }, { 23659, 0x2000 }, { 23660, 0x0010 },
  { 23661, 0x0820 }, { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 },
  { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 },
  { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 },
  /* 0x21B00 */
  { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 },
  { 23663, 0x0010 }, { 23664, 0x0000 }, { 23664, 0x0000 }, { 23664, 0x0000 },
  { 23664, 0x0000 }, { 23664, 0x0000 }, { 23664, 0x0000 }, { 23664, 0x0000 },
  { 23664, 0x0006 }, { 23666, 0x0000 }, { 23666, 0x0000 }, { 23666, 0x0000 },
  /* 0x21C00 */
  { 23666, 0x0000 }, { 23666, 0x0000 }, { 23666, 0x0400 }, { 23667, 0x0000 },
  { 23667, 0x0000 }, { 23667, 0x0000 }, { 23667, 0x0000 }, { 23667, 0x0001 },
  { 23668, 0x0000 }, { 23668, 0x0000 }, { 23668, 0x1024 }, { 23671, 0x0000 },
  { 23671, 0x0000 }, { 23671, 0x0000 }, { 23671, 0x0000 }, { 23671, 0x0000 },
  /* 0x21D00 */
  { 23671, 0x0000 }, { 23671, 0x0000 }, { 23671, 0x0000 }, { 23671, 0x0000 },
  { 23671, 0x0040 }, { 23672, 0x0000 }, { 23672, 0x0000 }, { 23672, 0x0000 },
  { 23672, 0x0000 }, { 23672, 0x0001 }, { 23673, 0x0000 }, { 23673, 0x0440 },
  { 23675, 0x0400 }, { 23676, 0x0002 }, { 23677, 0x0800 }, { 23678, 0x0200 },
  /* 0x21E00 */
  { 23679, 0x0000 }, { 23679, 0x1000 }, { 23680, 0x0000 }, { 23680, 0x2080 },
  { 23682, 0x0000 }, { 23682, 0x0000 }, { 23682, 0x0000 }, { 23682, 0x0000 },
  { 23682, 0x0200 }, { 23683, 0x0000 }, { 23683, 0x0110 }, { 23685, 0x0000 },
  { 23685, 0x0100 }, { 23686, 0x0020 }, { 23687, 0x0000 }, { 23687, 0x0000 },
  /* 0x21F00 */
  { 23687, 0x8000 }, { 23688, 0x0020 }, { 23689, 0x0000 }, { 23689, 0x0000 },
  { 23689, 0x0000 }, { 23689, 0x0000 }, { 23689, 0x0400 }, { 23690, 0x0000 },
  { 23690, 0x0000 }, { 23690, 0x4000 }, { 23691, 0x0002 }, { 23692, 0x0000 },
  { 23692, 0x0000 }, { 23692, 0x0000 }, { 23692, 0x0100 }, { 23693, 0x0000 },
  /* 0x22000 */
  { 23693, 0x0000 }, { 23693, 0x0000 }, { 23693, 0x0000 }, { 23693, 0x0000 },
  { 23693, 0x0220 }, { 23695, 0x0000 }, { 23695, 0x0000 }, { 23695, 0x4000 },
  { 23696, 0x0000 }, { 23696, 0x0400 }, { 23697, 0x0000 }, { 23697, 0x0000 },
  { 23697, 0x0080 }, { 23698, 0x0000 }, { 23698, 0x0000 }, { 23698, 0x1000 },
  /* 0x22100 */
  { 23699, 0x0000 }, { 23699, 0x0000 }, { 23699, 0x0400 }, { 23700, 0x0000 },
  { 23700, 0x0000 }, { 23700, 0x0800 }, { 23701, 0x0000 }, { 23701, 0x0408 },
  { 23703, 0x0000 }, { 23703, 0x0000 }, { 23703, 0x0002 }, { 23704, 0x0000 },
  { 23704, 0x0008 }, { 23705, 0x0000 }, { 23705, 0x0000 }, { 23705, 0x0000 },
  /* 0x22200 */
  { 23705, 0x0100 }, { 23706, 0x0000 }, { 23706, 0x0000 }, { 23706, 0x0000 },
  { 23706, 0x0000 }, { 23706, 0x0000 }, { 23706, 0x0000 }, { 23706, 0x1000 },
  { 23707, 0x0000 }, { 23707, 0x0000 }, { 23707, 0x0000 }, { 23707, 0x0000 },
  { 23707, 0x0000 }, { 23707, 0x0000 }, { 23707, 0x0000 }, { 23707, 0x0000 },
  /* 0x22300 */
  { 23707, 0x0000 }, { 23707, 0x0000 }, { 23707, 0x0022 }, { 23709, 0x0000 },
  { 23709, 0x0000 }, { 23709, 0x0000 }, { 23709, 0x0000 }, { 23709, 0x0000 },
  { 23709, 0x0000 }, { 23709, 0x0000 }, { 23709, 0x0000 }, { 23709, 0x2000 },
  { 23710, 0x0000 }, { 23710, 0x0081 }, { 23712, 0x0000 }, { 23712, 0x0400 },
  /* 0x22400 */
  { 23713, 0x0000 }, { 23713, 0x0000 }, { 23713, 0x0000 }, { 23713, 0x0000 },
  { 23713, 0x0000 }, { 23713, 0x0000 }, { 23713, 0x0020 }, { 23714, 0x0002 },
  { 23715, 0x0800 }, { 23716, 0x0002 }, { 23717, 0x0000 }, { 23717, 0x0001 },
  { 23718, 0x0000 }, { 23718, 0x0000 }, { 23718, 0x2000 }, { 23719, 0x0000 },
  /* 0x22500 */
  { 23719, 0x0000 }, { 23719, 0x0808 }, { 23721, 0x0000 }, { 23721, 0x0001 },
  { 23722, 0x0000 }, { 23722, 0x0010 }, { 23723, 0x0000 }, { 23723, 0x0000 },
  { 23723, 0x2000 }, { 23724, 0x0000 }, { 23724, 0x8000 }, { 23725, 0x4000 },
  { 23726, 0x0000 }, { 23726, 0x0000 }, { 23726, 0x0000 }, { 23726, 0x0000 },
  /* 0x22600 */
  { 23726, 0x0000 }, { 23726, 0x1800 }, { 23728, 0x0800 }, { 23729, 0x0000 },
  { 23729, 0x0000 }, { 23729, 0x0000 }, { 23729, 0x0100 }, { 23730, 0x0400 },
  { 23731, 0x0000 }, { 23731, 0x0140 }, { 23733, 0x0000 }, { 23733, 0x0000 },
  { 23733, 0x0000 }, { 23733, 0x0000 }, { 23733, 0x0000 }, { 23733, 0x0070 },
  /* 0x22700 */
  { 23736, 0x0000 }, { 23736, 0x8814 }, { 23740, 0x0400 }, { 23741, 0x0000 },
  { 23741, 0x0000 }, { 23741, 0x0000 }, { 23741, 0x0000 }, { 23741, 0x0020 },
  { 23742, 0x0002 }, { 23743, 0x0000 }, { 23743, 0x0000 }, { 23743, 0x0030 },
  { 23745, 0x2000 }, { 23746, 0x0000 }, { 23746, 0x0000 }, { 23746, 0x0000 },
  /* 0x22800 */
  { 23746, 0x0008 }, { 23747, 0x0000 }, { 23747, 0x0000 }, { 23747, 0x0000 },
  { 23747, 0x0000 }, { 23747, 0x8000 }, { 23748, 0x0001 }, { 23749, 0x0002 },
  { 23750, 0x0000 }, { 23750, 0x0000 }, { 23750, 0x2000 }, { 23751, 0x0000 },
  { 23751, 0x0002 }, { 23752, 0x0000 }, { 23752, 0x0000 }, { 23752, 0x0080 },
  /* 0x22900 */
  { 23753, 0x0000 }, { 23753, 0x0000 }, { 23753, 0x0040 }, { 23754, 0x0200 },
  { 23755, 0x8000 }, { 23756, 0x0000 }, { 23756, 0x0880 }, { 23758, 0x0000 },
  { 23758, 0x0001 }, { 23759, 0x0008 }, { 23760, 0x0000 }, { 23760, 0x0000 },
  { 23760, 0x0000 }, { 23760, 0x0000 }, { 23760, 0x0000 }, { 23760, 0x0000 },
  /* 0x22A00 */
  { 23760, 0x0000 }, { 23760, 0x0000 }, { 23760, 0x0000 }, { 23760, 0x0000 },
  { 23760, 0x0000 }, { 23760, 0x0000 }, { 23760, 0x0040 }, { 23761, 0x0000 },
  { 23761, 0x0000 }, { 23761, 0x0000 }, { 23761, 0x0000 }, { 23761, 0x0000 },
  { 23761, 0x8000 }, { 23762, 0x0020 }, { 23763, 0x0140 }, { 23765, 0x0000 },
  /* 0x22B00 */
  { 23765, 0x4000 }, { 23766, 0x0000 }, { 23766, 0x0004 }, { 23767, 0x8000 },
  { 23768, 0x0008 }, { 23769, 0x0000 }, { 23769, 0x0400 }, { 23770, 0x0000 },
  { 23770, 0x0000 }, { 23770, 0x0000 }, { 23770, 0x0000 }, { 23770, 0x0000 },
  { 23770, 0x4400 }, { 23772, 0x0000 }, { 23772, 0x0000 }, { 23772, 0x0000 },
  /* 0x22C00 */
  { 23772, 0x0000 }, { 23772, 0x0000 }, { 23772, 0x00C0 }, { 23774, 0x0100 },
  { 23775, 0x1000 }, { 23776, 0x0022 }, { 23778, 0x0004 }, { 23779, 0x0000 },
  { 23779, 0x0100 }, { 23780, 0x0800 }, { 23781, 0x0202 }, { 23783, 0x0084 },
  { 23785, 0x0244 }, { 23788, 0x0000 }, { 23788, 0x0000 }, { 23788, 0x0000 },
  /* 0x22D00 */
  { 23788, 0x0180 }, { 23790, 0x0004 }, { 23791, 0x0000 }, { 23791, 0x0000 },
  { 23791, 0x1010 }, { 23793, 0x0000 }, { 23793, 0x0080 }, { 23794, 0x0000 },
  { 23794, 0x2000 }, { 23795, 0x0020 }, { 23796, 0x0019 }, { 23799, 0x0080 },
  { 23800, 0x0000 }, { 23800, 0x0000 }, { 23800, 0x4000 }, { 23801, 0x0000 },
  /* 0x22E00 */
  { 23801, 0x2000 }, { 23802, 0x0000 }, { 23802, 0x0000 }, { 23802, 0x0040 },
  { 23803, 0x0004 }, { 23804, 0x0000 }, { 23804, 0x0000 }, { 23804, 0x0100 },
  { 23805, 0x0800 }, { 23806, 0x0000 }, { 23806, 0x0000 }, { 23806, 0x0008 },
  { 23807, 0x0000 }, { 23807, 0x0000 }, { 23807, 0x8000 }, { 23808, 0x0000 },
  /* 0x22F00 */
  { 23808, 0x0000 }, { 23808, 0x0000 }, { 23808, 0x0000 }, { 23808, 0x0000 },
  { 23808, 0x0000 }, { 23808, 0x0000 }, { 23808, 0x0000 }, { 23808, 0x0010 },
  { 23809, 0x0000 }, { 23809, 0x0000 }, { 23809, 0x0000 }, { 23809, 0x0000 },
  { 23809, 0x1000 }, { 23810, 0x0000 }, { 23810, 0x0008 }, { 23811, 0x0000 },
  /* 0x23000 */
  { 23811, 0x0000 }, { 23811, 0x0000 }, { 23811, 0x0000 }, { 23811, 0x0008 },
  { 23812, 0x0810 }, { 23814, 0x0000 }, { 23814, 0x0040 }, { 23815, 0x6000 },
  { 23817, 0x4000 }, { 23818, 0x0000 }, { 23818, 0x0000 }, { 23818, 0x1080 },
  { 23820, 0x0000 }, { 23820, 0x0400 }, { 23821, 0x0000 }, { 23821, 0x0000 },
  /* 0x23100 */
  { 23821, 0x0008 }, { 23822, 0x0000 }, { 23822, 0x0000 }, { 23822, 0x2000 },
  { 23823, 0x0000 }, { 23823, 0x0000 }, { 23823, 0x0000 }, { 23823, 0x2000 },
  { 23824, 0x0004 }, { 23825, 0x0000 }, { 23825, 0x0030 }, { 23827, 0x0008 },
  { 23828, 0x0300 }, { 23830, 0x0000 }, { 23830, 0x0000 }, { 23830, 0x0380 },
  /* 0x23200 */
  { 23833, 0x8000 }, { 23834, 0x0000 }, { 23834, 0x8020 }, { 23836, 0x001E },
  { 23840, 0x0000 }, { 23840, 0x0000 }, { 23840, 0x0004 }, { 23841, 0x0000 },
  { 23841, 0x0602 }, { 23844, 0x0000 }, { 23844, 0x3800 }, { 23847, 0x0000 },
  { 23847, 0x0000 }, { 23847, 0x0004 }, { 23848, 0x0003 }, { 23850, 0x0000 },
  /* 0x23300 */
  { 23850, 0x0401 }, { 23852, 0x8000 }, { 23853, 0x0000 }, { 23853, 0x0000 },
  { 23853, 0x0000 }, { 23853, 0x0000 }, { 23853, 0x0000 }, { 23853, 0x0000 },
  { 23853, 0x0000 }, { 23853, 0x0000 }, { 23853, 0x0000 }, { 23853, 0x0010 },
  { 23854, 0x1000 }, { 23855, 0x4000 }, { 23856, 0x0040 }, { 23857, 0x4630 },
  /* 0x23400 */
  { 23862, 0x0001 }, { 23863, 0x0000 }, { 23863, 0x0000 }, { 23863, 0x8000 },
  { 23864, 0x0000 }, { 23864, 0x0001 }, { 23865, 0x8000 }, { 23866, 0x0004 },
  { 23867, 0x0000 }, { 23867, 0x0000 }, { 23867, 0x0000 }, { 23867, 0x0000 },
  { 23867, 0x0000 }, { 23867, 0x0000 }, { 23867, 0x0020 }, { 23868, 0x0000 },
  /* 0x23500 */
  { 23868, 0x0000 }, { 23868, 0x0200 }, { 23869, 0x0000 }, { 23869, 0x0001 },
  { 23870, 0x0000 }, { 23870, 0x0400 }, { 23871, 0x0080 }, { 23872, 0x0000 },
  { 23872, 0x0000 }, { 23872, 0x1220 }, { 23875, 0x0000 }, { 23875, 0x0000 },
  { 23875, 0xE000 }, { 23878, 0x0000 }, { 23878, 0x0000 }, { 23878, 0x0008 },
  /* 0x23600 */
  { 23879, 0x0001 }, { 23880, 0x0400 }, { 23881, 0x0000 }, { 23881, 0x1000 },
  { 23882, 0x0001 }, { 23883, 0x8200 }, { 23885, 0x0000 }, { 23885, 0x0080 },
  { 23886, 0x0000 }, { 23886, 0x0000 }, { 23886, 0x2040 }, { 23888, 0x0400 },
  { 23889, 0x0000 }, { 23889, 0x8000 }, { 23890, 0x4000 }, { 23891, 0x0000 },
  /* 0x23700 */
  { 23891, 0x0008 }, { 23892, 0x0040 }, { 23893, 0xA001 }, { 23896, 0x8000 },
  { 23897, 0x0000 }, { 23897, 0x0000 }, { 23897, 0x0040 }, { 23898, 0x0000 },
  { 23898, 0x0002 }, { 23899, 0x0000 }, { 23899, 0x0004 }, { 23900, 0x1000 },
  { 23901, 0x0004 }, { 23902, 0x00E0 }, { 23905, 0x0000 }, { 23905, 0x0000 },
  /* 0x23800 */
  { 23905, 0x0000 }, { 23905, 0x0000 }, { 23905, 0x0000 }, { 23905, 0x0400 },
  { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 },
  { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 },
  { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 },
  /* 0x23900 */
  { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 },
  { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 },
  { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 },
  { 23906, 0x0004 }, { 23907, 0x0000 }, { 23907, 0x0000 }, { 23907, 0x0000 },
  /* 0x23A00 */
  { 23907, 0x0000 }, { 23907, 0x0000 }, { 23907, 0x0000 }, { 23907, 0x0000 },
  { 23907, 0x0000 }, { 23907, 0x0000 }, { 23907, 0x0000 }, { 23907, 0x0000 },
  { 23907, 0x0000 }, { 23907, 0x0000 }, { 23907, 0x0080 }, { 23908, 0x0000 },
  { 23908, 0x0000 }, { 23908, 0x0800 }, { 23909, 0x4000 }, { 23910, 0x0400 },
  /* 0x23B00 */
  { 23911, 0x0000 }, { 23911, 0x0000 }, { 23911, 0x0000 }, { 23911, 0x0000 },
  { 23911, 0x0000 }, { 23911, 0x0400 }, { 23912, 0x0000 }, { 23912, 0x0000 },
  { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0000 },
  { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0000 },
  /* 0x23C00 */
  { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0000 },
  { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0008 }, { 23913, 0x0000 },
  { 23913, 0x0000 }, { 23913, 0x0E00 }, { 23916, 0x0000 }, { 23916, 0x00A0 },
  { 23918, 0x0380 }, { 23921, 0x0000 }, { 23921, 0x0000 }, { 23921, 0xF000 },
  /* 0x23D00 */
  { 23925, 0x0000 }, { 23925, 0x0000 }, { 23925, 0x0000 }, { 23925, 0x0000 },
  { 23925, 0x0001 }, { 23926, 0x0800 }, { 23927, 0x0000 }, { 23927, 0x4000 },
  { 23928, 0x8000 }, { 23929, 0x0000 }, { 23929, 0x0000 }, { 23929, 0x3FC0 },
  { 23937, 0x0000 }, { 23937, 0x0000 }, { 23937, 0x0008 }, { 23938, 0x0100 },
  /* 0x23E00 */
  { 23939, 0x0000 }, { 23939, 0x0002 }, { 23940, 0xF000 }, { 23944, 0x0203 },
  { 23947, 0x0000 }, { 23947, 0x0000 }, { 23947, 0x0000 }, { 23947, 0x0000 },
  { 23947, 0x0F00 }, { 23951, 0x0000 }, { 23951, 0x0000 }, { 23951, 0x8200 },
  { 23953, 0x0000 }, { 23953, 0x0080 }, { 23954, 0x0000 }, { 23954, 0x1F80 },
  /* 0x23F00 */
  { 23960, 0x0000 }, { 23960, 0x0000 }, { 23960, 0x0000 }, { 23960, 0x0020 },
  { 23961, 0x0402 }, { 23963, 0x0000 }, { 23963, 0x0000 }, { 23963, 0x8000 },
  { 23964, 0x8007 }, { 23968, 0x0000 }, { 23968, 0x0000 }, { 23968, 0x0090 },
  { 23970, 0x0021 }, { 23972, 0x0000 }, { 23972, 0xF800 }, { 23977, 0x0001 },
  /* 0x24000 */
  { 23978, 0x0000 }, { 23978, 0x0002 }, { 23979, 0x0000 }, { 23979, 0x3E00 },
  { 23984, 0x0000 }, { 23984, 0x0080 }, { 23985, 0x0000 }, { 23985, 0x0000 },
  { 23985, 0x3820 }, { 23989, 0x0002 }, { 23990, 0x0000 }, { 23990, 0x0000 },
  { 23990, 0x0200 }, { 23991, 0x0000 }, { 23991, 0x0002 }, { 23992, 0x0000 },
  /* 0x24100 */
  { 23992, 0x8010 }, { 23994, 0x0200 }, { 23995, 0x0000 }, { 23995, 0x8000 },
  { 23996, 0x4011 }, { 23999, 0x90E0 }, { 24004, 0x0000 }, { 24004, 0x0480 },
  { 24006, 0x0000 }, { 24006, 0x0000 }, { 24006, 0x1038 }, { 24010, 0x0020 },
  { 24011, 0x2000 }, { 24012, 0x0000 }, { 24012, 0x0004 }, { 24013, 0x1000 },
  /* 0x24200 */
  { 24014, 0x0000 }, { 24014, 0x0800 }, { 24015, 0x0000 }, { 24015, 0x0000 },
  { 24015, 0x0800 }, { 24016, 0x0240 }, { 24018, 0x0000 }, { 24018, 0x01C0 },
  { 24021, 0x0010 }, { 24022, 0x0028 }, { 24024, 0x0020 }, { 24025, 0x0000 },
  { 24025, 0x0602 }, { 24028, 0x0000 }, { 24028, 0x4000 }, { 24029, 0x0400 },
  /* 0x24300 */
  { 24030, 0x2000 }, { 24031, 0x0400 }, { 24032, 0x0000 }, { 24032, 0x0010 },
  { 24033, 0x0100 }, { 24034, 0x0000 }, { 24034, 0x003C }, { 24038, 0x0000 },
  { 24038, 0x1000 }, { 24039, 0x1040 }, { 24041, 0x0000 }, { 24041, 0x2000 },
  { 24042, 0x0002 }, { 24043, 0x0000 }, { 24043, 0x0600 }, { 24045, 0x0104 },
  /* 0x24400 */
  { 24047, 0x0010 }, { 24048, 0x0000 }, { 24048, 0x0000 }, { 24048, 0x0060 },
  { 24050, 0x0000 }, { 24050, 0x0C00 }, { 24052, 0x0000 }, { 24052, 0x0008 },
  { 24053, 0x0180 }, { 24055, 0x0000 }, { 24055, 0x0000 }, { 24055, 0x1200 },
  { 24057, 0x4000 }, { 24058, 0x0048 }, { 24060, 0x0000 }, { 24060, 0x0000 },
  /* 0x24500 */
  { 24060, 0x0020 }, { 24061, 0x0000 }, { 24061, 0x0002 }, { 24062, 0x0000 },
  { 24062, 0x0000 }, { 24062, 0x0000 }, { 24062, 0x0000 }, { 24062, 0x0100 },
  { 24063, 0x0000 }, { 24063, 0x0000 }, { 24063, 0x0000 }, { 24063, 0x0000 },
  { 24063, 0x0100 }, { 24064, 0x0000 }, { 24064, 0x0000 }, { 24064, 0x0000 },
  /* 0x24600 */
  { 24064, 0x0000 }, { 24064, 0x0100 }, { 24065, 0x0400 }, { 24066, 0x0000 },
  { 24066, 0x0000 }, { 24066, 0x0000 }, { 24066, 0x0020 }, { 24067, 0x0010 },
  { 24068, 0x0000 }, { 24068, 0x0080 }, { 24069, 0x0000 }, { 24069, 0x0000 },
  { 24069, 0x0000 }, { 24069, 0x0010 }, { 24070, 0x0000 }, { 24070, 0x0000 },
  /* 0x24700 */
  { 24070, 0x0040 }, { 24071, 0x0000 }, { 24071, 0x8020 }, { 24073, 0x0000 },
  { 24073, 0x0000 }, { 24073, 0x0000 }, { 24073, 0x0000 }, { 24073, 0x0000 },
  { 24073, 0x8000 }, { 24074, 0x0000 }, { 24074, 0x0000 }, { 24074, 0x0000 },
  { 24074, 0x0000 }, { 24074, 0x0000 }, { 24074, 0x0001 }, { 24075, 0x0000 },
  /* 0x24800 */
  { 24075, 0x0000 }, { 24075, 0x0004 }, { 24076, 0x0008 }, { 24077, 0x0000 },
  { 24077, 0x0000 }, { 24077, 0x0000 }, { 24077, 0x0000 }, { 24077, 0x0000 },
  { 24077, 0x0004 }, { 24078, 0x0000 }, { 24078, 0x0000 }, { 24078, 0x0000 },
  { 24078, 0x0000 }, { 24078, 0x0000 }, { 24078, 0x0200 }, { 24079, 0x880F },
  /* 0x24900 */
  { 24085, 0x1003 }, { 24088, 0x02C0 }, { 24091, 0x8000 }, { 24092, 0xC018 },
  { 24096, 0x000F }, { 24100, 0x0000 }, { 24100, 0x000C }, { 24102, 0x8870 },
  { 24107, 0xFF04 }, { 24116, 0x0010 }, { 24117, 0x3A90 }, { 24123, 0x0F80 },
  { 24128, 0x0020 }, { 24129, 0xC401 }, { 24133, 0x3028 }, { 24137, 0x0BC0 },
  /* 0x24A00 */
  { 24142, 0x4000 }, { 24143, 0x002C }, { 24146, 0x07FE }, { 24156, 0x4000 },
  { 24157, 0xC424 }, { 24162, 0x2003 }, { 24165, 0x00E0 }, { 24168, 0x0782 },
  { 24173, 0x1000 }, { 24174, 0x0078 }, { 24178, 0x00F0 }, { 24182, 0x1C0E },
  { 24188, 0x0481 }, { 24191, 0x8002 }, { 24193, 0x0204 }, { 24195, 0x0000 },
  /* 0x24B00 */
  { 24195, 0x0000 }, { 24195, 0x0000 }, { 24195, 0x0000 }, { 24195, 0x0000 },
  { 24195, 0x0000 }, { 24195, 0x0000 }, { 24195, 0x4000 }, { 24196, 0x0000 },
  { 24196, 0x0000 }, { 24196, 0x0000 }, { 24196, 0x0000 }, { 24196, 0x0000 },
  { 24196, 0x0000 }, { 24196, 0x0000 }, { 24196, 0x0000 }, { 24196, 0x0020 },
  /* 0x24C00 */
  { 24197, 0x0200 }, { 24198, 0x0000 }, { 24198, 0x0000 }, { 24198, 0x0000 },
  { 24198, 0x0000 }, { 24198, 0x0000 }, { 24198, 0x0000 }, { 24198, 0x0000 },
  { 24198, 0x0000 }, { 24198, 0xC000 }, { 24200, 0x0000 }, { 24200, 0x0000 },
  { 24200, 0x0200 }, { 24201, 0x0200 }, { 24202, 0x0000 }, { 24202, 0x0000 },
  /* 0x24D00 */
  { 24202, 0x0040 }, { 24203, 0x0008 }, { 24204, 0x0000 }, { 24204, 0x0000 },
  { 24204, 0x0000 }, { 24204, 0x0000 }, { 24204, 0x0000 }, { 24204, 0x0000 },
  { 24204, 0x0000 }, { 24204, 0x0000 }, { 24204, 0x0000 }, { 24204, 0x0100 },
  { 24205, 0x0000 }, { 24205, 0x0000 }, { 24205, 0x0C00 }, { 24207, 0x0000 },
  /* 0x24E00 */
  { 24207, 0x0000 }, { 24207, 0x0000 }, { 24207, 0x0000 }, { 24207, 0x0800 },
  { 24208, 0x0000 }, { 24208, 0x0001 }, { 24209, 0x0000 }, { 24209, 0x0000 },
  { 24209, 0x0000 }, { 24209, 0x0000 }, { 24209, 0x00A0 }, { 24211, 0x0000 },
  { 24211, 0x0000 }, { 24211, 0x0000 }, { 24211, 0x0000 }, { 24211, 0x0000 },
  /* 0x24F00 */
  { 24211, 0x4000 }, { 24212, 0x0000 }, { 24212, 0x0000 }, { 24212, 0x0000 },
  { 24212, 0x0000 }, { 24212, 0x1000 }, { 24213, 0x0000 }, { 24213, 0x0000 },
  { 24213, 0x0044 }, { 24215, 0x0480 }, { 24217, 0x0200 }, { 24218, 0x0100 },
  { 24219, 0x0004 }, { 24220, 0x0000 }, { 24220, 0x0000 }, { 24220, 0x0000 },
  /* 0x25000 */
  { 24220, 0x0000 }, { 24220, 0x0000 }, { 24220, 0x1000 }, { 24221, 0x0000 },
  { 24221, 0x0000 }, { 24221, 0x0004 }, { 24222, 0x0000 }, { 24222, 0x0000 },
  { 24222, 0x0000 }, { 24222, 0x2000 }, { 24223, 0x0000 }, { 24223, 0x0000 },
  { 24223, 0x0000 }, { 24223, 0x0000 }, { 24223, 0x0000 }, { 24223, 0x0000 },
  /* 0x25100 */
  { 24223, 0x0000 }, { 24223, 0x0000 }, { 24223, 0x0800 }, { 24224, 0x0000 },
  { 24224, 0x0100 }, { 24225, 0x0000 }, { 24225, 0x0000 }, { 24225, 0x6000 },
  { 24227, 0x0000 }, { 24227, 0x0000 }, { 24227, 0x0000 }, { 24227, 0x0000 },
  { 24227, 0x2000 }, { 24228, 0x0000 }, { 24228, 0x00C8 }, { 24231, 0x0000 },
  /* 0x25200 */
  { 24231, 0x0000 }, { 24231, 0x0000 }, { 24231, 0x0003 }, { 24233, 0x0000 },
  { 24233, 0x0000 }, { 24233, 0x0001 }, { 24234, 0x0000 }, { 24234, 0x0000 },
  { 24234, 0x0000 }, { 24234, 0x0200 }, { 24235, 0x0000 }, { 24235, 0x0000 },
  { 24235, 0x0080 }, { 24236, 0x0100 }, { 24237, 0x0000 }, { 24237, 0x0000 },
  /* 0x25300 */
  { 24237, 0x4000 }, { 24238, 0x000A }, { 24240, 0x0000 }, { 24240, 0x0000 },
  { 24240, 0x0000 }, { 24240, 0x0000 }, { 24240, 0x0000 }, { 24240, 0x0000 },
  { 24240, 0x0000 }, { 24240, 0x0000 }, { 24240, 0x0000 }, { 24240, 0x0000 },
  { 24240, 0x0000 }, { 24240, 0x0000 }, { 24240, 0x0000 }, { 24240, 0x0000 },
  /* 0x25400 */
  { 24240, 0x0000 }, { 24240, 0x0200 }, { 24241, 0x8020 }, { 24243, 0x0001 },
  { 24244, 0x0040 }, { 24245, 0x0000 }, { 24245, 0x5000 }, { 24247, 0x0000 },
  { 24247, 0x0000 }, { 24247, 0x0000 }, { 24247, 0x0000 }, { 24247, 0x0000 },
  { 24247, 0x0000 }, { 24247, 0x0000 }, { 24247, 0x0000 }, { 24247, 0x0000 },
  /* 0x25500 */
  { 24247, 0x0000 }, { 24247, 0x0000 }, { 24247, 0x0000 }, { 24247, 0x8022 },
  { 24250, 0x0000 }, { 24250, 0x7800 }, { 24254, 0x0064 }, { 24257, 0x0000 },
  { 24257, 0x8012 }, { 24260, 0x0000 }, { 24260, 0x0000 }, { 24260, 0x0200 },
  { 24261, 0x0000 }, { 24261, 0x0820 }, { 24263, 0x0001 }, { 24264, 0x0000 },
  /* 0x25600 */
  { 24264, 0x0020 }, { 24265, 0x0000 }, { 24265, 0x0000 }, { 24265, 0x0020 },
  { 24266, 0x0000 }, { 24266, 0x0002 }, { 24267, 0x0000 }, { 24267, 0x0000 },
  { 24267, 0x0008 }, { 24268, 0x0020 }, { 24269, 0x0000 }, { 24269, 0x0000 },
  { 24269, 0x0000 }, { 24269, 0x0000 }, { 24269, 0x0008 }, { 24270, 0x0040 },
  /* 0x25700 */
  { 24271, 0x0040 }, { 24272, 0x2000 }, { 24273, 0x0020 }, { 24274, 0x2000 },
  { 24275, 0x0000 }, { 24275, 0x0000 }, { 24275, 0x0000 }, { 24275, 0x0004 },
  { 24276, 0x0000 }, { 24276, 0x0000 }, { 24276, 0x0000 }, { 24276, 0x0000 },
  { 24276, 0x0080 }, { 24277, 0x8000 }, { 24278, 0x0003 }, { 24280, 0x0000 },
  /* 0x25800 */
  { 24280, 0x0000 }, { 24280, 0x0000 }, { 24280, 0x0000 }, { 24280, 0x0000 },
  { 24280, 0x0000 }, { 24280, 0x2080 }, { 24282, 0x0000 }, { 24282, 0x0004 },
  { 24283, 0x0000 }, { 24283, 0x0000 }, { 24283, 0x0000 }, { 24283, 0x0000 },
  { 24283, 0x0100 }, { 24284, 0x0000 }, { 24284, 0x0002 }, { 24285, 0x0000 },
  /* 0x25900 */
  { 24285, 0x0008 }, { 24286, 0x0000 }, { 24286, 0x0000 }, { 24286, 0x0000 },
  { 24286, 0x0040 }, { 24287, 0x0040 }, { 24288, 0x0000 }, { 24288, 0x0000 },
  { 24288, 0x0000 }, { 24288, 0x0000 }, { 24288, 0x1000 }, { 24289, 0x0000 },
  { 24289, 0x1000 }, { 24290, 0x0000 }, { 24290, 0x0000 }, { 24290, 0x0000 },
  /* 0x25A00 */
  { 24290, 0x0000 }, { 24290, 0x0000 }, { 24290, 0x0000 }, { 24290, 0x0000 },
  { 24290, 0x0000 }, { 24290, 0x0000 }, { 24290, 0x0000 }, { 24290, 0x0000 },
  { 24290, 0x0000 }, { 24290, 0x1020 }, { 24292, 0xC000 }, { 24294, 0x0000 },
  { 24294, 0x0000 }, { 24294, 0x0000 }, { 24294, 0x0200 }, { 24295, 0x0000 },
  /* 0x25B00 */
  { 24295, 0x0000 }, { 24295, 0x0000 }, { 24295, 0x0000 }, { 24295, 0x0000 },
  { 24295, 0x0000 }, { 24295, 0x0000 }, { 24295, 0x0000 }, { 24295, 0x0010 },
  { 24296, 0x0200 }, { 24297, 0x0000 }, { 24297, 0x0000 }, { 24297, 0x0018 },
  { 24299, 0x0040 }, { 24300, 0x0000 }, { 24300, 0x0110 }, { 24302, 0x0000 },
  /* 0x25C00 */
  { 24302, 0x0042 }, { 24304, 0x0000 }, { 24304, 0x0002 }, { 24305, 0x0000 },
  { 24305, 0x0400 }, { 24306, 0x0000 }, { 24306, 0x0020 }, { 24307, 0x0000 },
  { 24307, 0x0000 }, { 24307, 0x0002 }, { 24308, 0x0010 }, { 24309, 0x0000 },
  { 24309, 0x0003 }, { 24311, 0x0000 }, { 24311, 0x0000 }, { 24311, 0x4000 },
  /* 0x25D00 */
  { 24312, 0x0000 }, { 24312, 0x0000 }, { 24312, 0x0001 }, { 24313, 0x0001 },
  { 24314, 0x0008 }, { 24315, 0x0000 }, { 24315, 0x0000 }, { 24315, 0x0000 },
  { 24315, 0x0000 }, { 24315, 0x0000 }, { 24315, 0x0000 }, { 24315, 0x0000 },
  { 24315, 0x0000 }, { 24315, 0x0000 }, { 24315, 0x0000 }, { 24315, 0x0000 },
  /* 0x25E00 */
  { 24315, 0x4000 }, { 24316, 0x0000 }, { 24316, 0x0000 }, { 24316, 0x0000 },
  { 24316, 0x0200 }, { 24317, 0x0000 }, { 24317, 0x0000 }, { 24317, 0x0000 },
  { 24317, 0x000E }, { 24320, 0x0000 }, { 24320, 0x0040 }, { 24321, 0x1000 },
  { 24322, 0x0000 }, { 24322, 0x0180 }, { 24324, 0x0000 }, { 24324, 0x0000 },
  /* 0x25F00 */
  { 24324, 0x0000 }, { 24324, 0x0400 }, { 24325, 0x0000 }, { 24325, 0x0000 },
  { 24325, 0x0800 }, { 24326, 0x0000 }, { 24326, 0x0000 }, { 24326, 0x0000 },
  { 24326, 0x0000 }, { 24326, 0x0000 }, { 24326, 0x0000 }, { 24326, 0x0000 },
  { 24326, 0x0000 }, { 24326, 0x0000 }, { 24326, 0x0006 }, { 24328, 0x0000 },
  /* 0x26000 */
  { 24328, 0x0000 }, { 24328, 0x0000 }, { 24328, 0x0200 }, { 24329, 0x0000 },
  { 24329, 0x0100 }, { 24330, 0x0000 }, { 24330, 0x0010 }, { 24331, 0x0000 },
  { 24331, 0x0008 }, { 24332, 0x0080 }, { 24333, 0x0030 }, { 24335, 0x0000 },
  { 24335, 0x0000 }, { 24335, 0x0000 }, { 24335, 0x0000 }, { 24335, 0x0000 },
  /* 0x26100 */
  { 24335, 0x0004 }, { 24336, 0x0000 }, { 24336, 0x0002 }, { 24337, 0x0000 },
  { 24337, 0x0000 }, { 24337, 0x1E00 }, { 24341, 0x0000 }, { 24341, 0x0000 },
  { 24341, 0x0000 }, { 24341, 0x0000 }, { 24341, 0x6000 }, { 24343, 0x0004 },
  { 24344, 0x0000 }, { 24344, 0x2000 }, { 24345, 0x0000 }, { 24345, 0x0000 },
  /* 0x26200 */
  { 24345, 0x0000 }, { 24345, 0x0000 }, { 24345, 0x0000 }, { 24345, 0x0000 },
  { 24345, 0x0000 }, { 24345, 0x0100 }, { 24346, 0x0C02 }, { 24349, 0x0000 },
  { 24349, 0x0000 }, { 24349, 0x0000 }, { 24349, 0x0000 }, { 24349, 0x0000 },
  { 24349, 0x0000 }, { 24349, 0x0001 }, { 24350, 0x0000 }, { 24350, 0x0000 },
  /* 0x26300 */
  { 24350, 0x0000 }, { 24350, 0x0000 }, { 24350, 0x0000 }, { 24350, 0x0020 },
  { 24351, 0x1800 }, { 24353, 0x0002 }, { 24354, 0x0000 }, { 24354, 0x0000 },
  { 24354, 0x0000 }, { 24354, 0x0000 }, { 24354, 0x0000 }, { 24354, 0x4000 },
  { 24355, 0x0000 }, { 24355, 0x0000 }, { 24355, 0x0000 }, { 24355, 0x0120 },
  /* 0x26400 */
  { 24357, 0x0004 }, { 24358, 0x0007 }, { 24361, 0x0000 }, { 24361, 0x0000 },
  { 24361, 0x0400 }, { 24362, 0x0000 }, { 24362, 0x0200 }, { 24363, 0x0000 },
  { 24363, 0x2310 }, { 24367, 0x0100 }, { 24368, 0x0000 }, { 24368, 0x0000 },
  { 24368, 0x0000 }, { 24368, 0x0000 }, { 24368, 0x0000 }, { 24368, 0x0000 },
  /* 0x26500 */
  { 24368, 0x0000 }, { 24368, 0x0004 }, { 24369, 0x0000 }, { 24369, 0x0000 },
  { 24369, 0x0000 }, { 24369, 0x0000 }, { 24369, 0x0000 }, { 24369, 0x0004 },
  { 24370, 0x0000 }, { 24370, 0x0000 }, { 24370, 0x2001 }, { 24372, 0x8000 },
  { 24373, 0x0000 }, { 24373, 0x0000 }, { 24373, 0x0000 }, { 24373, 0x0000 },
  /* 0x26600 */
  { 24373, 0x0000 }, { 24373, 0x0004 }, { 24374, 0x0040 }, { 24375, 0x0000 },
  { 24375, 0x0000 }, { 24375, 0x0000 }, { 24375, 0x0000 }, { 24375, 0x0000 },
  { 24375, 0x0000 }, { 24375, 0x0000 }, { 24375, 0x8000 }, { 24376, 0x0022 },
  { 24378, 0x0000 }, { 24378, 0x0400 }, { 24379, 0x0100 }, { 24380, 0x1000 },
  /* 0x26700 */
  { 24381, 0x0000 }, { 24381, 0x0040 }, { 24382, 0x0000 }, { 24382, 0x0000 },
  { 24382, 0x0002 }, { 24383, 0x0000 }, { 24383, 0x0000 }, { 24383, 0x0000 },
  { 24383, 0x0000 }, { 24383, 0x0200 }, { 24384, 0x0000 }, { 24384, 0x0018 },
  { 24386, 0x1000 }, { 24387, 0x0000 }, { 24387, 0x0000 }, { 24387, 0x0000 },
  /* 0x26800 */
  { 24387, 0x0000 }, { 24387, 0x1000 }, { 24388, 0x0000 }, { 24388, 0x0000 },
  { 24388, 0x0040 }, { 24389, 0x4000 }, { 24390, 0x4000 }, { 24391, 0x0000 },
  { 24391, 0x0500 }, { 24393, 0x0008 }, { 24394, 0x0000 }, { 24394, 0x0000 },
  { 24394, 0x0080 }, { 24395, 0x0000 }, { 24395, 0x0000 }, { 24395, 0x0000 },
  /* 0x26900 */
  { 24395, 0x4000 }, { 24396, 0x0002 }, { 24397, 0x0040 }, { 24398, 0x0200 },
  { 24399, 0x0000 }, { 24399, 0x0002 }, { 24400, 0x0000 }, { 24400, 0x0000 },
  { 24400, 0x0000 }, { 24400, 0x0000 }, { 24400, 0x0100 }, { 24401, 0x0020 },
  { 24402, 0x0000 }, { 24402, 0x0000 }, { 24402, 0x0000 }, { 24402, 0x0404 },
  /* 0x26A00 */
  { 24404, 0x0000 }, { 24404, 0x0000 }, { 24404, 0x6000 }, { 24406, 0x0010 },
  { 24407, 0x0004 }, { 24408, 0x0006 }, { 24410, 0x0000 }, { 24410, 0x0000 },
  { 24410, 0x0000 }, { 24410, 0x0000 }, { 24410, 0x0000 }, { 24410, 0x0000 },
  { 24410, 0x0000 }, { 24410, 0x0000 }, { 24410, 0x0000 }, { 24410, 0x0000 },
  /* 0x26B00 */
  { 24410, 0x0420 }, { 24412, 0x0028 }, { 24414, 0x0100 }, { 24415, 0x0000 },
  { 24415, 0x0000 }, { 24415, 0x080F }, { 24420, 0x0000 }, { 24420, 0x0020 },
  { 24421, 0x0004 }, { 24422, 0x20C0 }, { 24425, 0x0000 }, { 24425, 0x0008 },
  { 24426, 0x0001 }, { 24427, 0x0000 }, { 24427, 0x0000 }, { 24427, 0x0080 },
  /* 0x26C00 */
  { 24428, 0x0000 }, { 24428, 0x0000 }, { 24428, 0x0002 }, { 24429, 0x0000 },
  { 24429, 0x0001 }, { 24430, 0x0000 }, { 24430, 0x0000 }, { 24430, 0xC000 },
  { 24432, 0x0007 }, { 24435, 0x0000 }, { 24435, 0x0010 }, { 24436, 0x2180 },
  { 24439, 0x0009 }, { 24441, 0x0002 }, { 24442, 0x0000 }, { 24442, 0x0000 },
  /* 0x26D00 */
  { 24442, 0x0000 }, { 24442, 0x0000 }, { 24442, 0x07FC }, { 24451, 0x0000 },
  { 24451, 0x0000 }, { 24451, 0x0002 }, { 24452, 0x0000 }, { 24452, 0x0010 },
  { 24453, 0x0000 }, { 24453, 0x0000 }, { 24453, 0x40FF }, { 24462, 0x0000 },
  { 24462, 0x0000 }, { 24462, 0x1000 }, { 24463, 0x0C00 }, { 24465, 0x0001 },
  /* 0x26E00 */
  { 24466, 0x00A1 }, { 24469, 0x0004 }, { 24470, 0x0000 }, { 24470, 0x0000 },
  { 24470, 0x003C }, { 24474, 0x0000 }, { 24474, 0x4000 }, { 24475, 0x0084 },
  { 24477, 0x0010 }, { 24478, 0x0200 }, { 24479, 0x0000 }, { 24479, 0x0000 },
  { 24479, 0x0000 }, { 24479, 0x00FF }, { 24487, 0x0000 }, { 24487, 0x0000 },
  /* 0x26F00 */
  { 24487, 0x0000 }, { 24487, 0x0000 }, { 24487, 0x0040 }, { 24488, 0x0000 },
  { 24488, 0x0000 }, { 24488, 0x0000 }, { 24488, 0x0000 }, { 24488, 0x0018 },
  { 24490, 0x0000 }, { 24490, 0x8000 }, { 24491, 0x0002 }, { 24492, 0x4000 },
  { 24493, 0x0000 }, { 24493, 0xC000 }, { 24495, 0x0000 }, { 24495, 0x0000 },
  /* 0x27000 */
  { 24495, 0x4000 }, { 24496, 0x0000 }, { 24496, 0x0000 }, { 24496, 0x0000 },
  { 24496, 0x0800 }, { 24497, 0x000C }, { 24499, 0x0000 }, { 24499, 0x0000 },
  { 24499, 0x0100 }, { 24500, 0x0000 }, { 24500, 0xE000 }, { 24503, 0x0000 },
  { 24503, 0x2000 }, { 24504, 0x0000 }, { 24504, 0x0000 }, { 24504, 0x0100 },
  /* 0x27100 */
  { 24505, 0x3200 }, { 24508, 0x0000 }, { 24508, 0x00C0 }, { 24510, 0x0000 },
  { 24510, 0x0000 }, { 24510, 0x0000 }, { 24510, 0x0030 }, { 24512, 0x0020 },
  { 24513, 0x0000 }, { 24513, 0x0000 }, { 24513, 0x0000 }, { 24513, 0x0000 },
  { 24513, 0x2000 }, { 24514, 0x0000 }, { 24514, 0x0000 }, { 24514, 0x0000 },
  /* 0x27200 */
  { 24514, 0x0000 }, { 24514, 0x0800 }, { 24515, 0x0000 }, { 24515, 0x0000 },
  { 24515, 0x0000 }, { 24515, 0x0000 }, { 24515, 0x0000 }, { 24515, 0x0000 },
  { 24515, 0x0821 }, { 24518, 0x0000 }, { 24518, 0x0000 }, { 24518, 0x0044 },
  { 24520, 0x0000 }, { 24520, 0x0000 }, { 24520, 0x0040 }, { 24521, 0x0000 },
  /* 0x27300 */
  { 24521, 0x0000 }, { 24521, 0x0000 }, { 24521, 0x0000 }, { 24521, 0x0000 },
  { 24521, 0x0000 }, { 24521, 0x0000 }, { 24521, 0x0000 }, { 24521, 0x0000 },
  { 24521, 0x0000 }, { 24521, 0x0400 }, { 24522, 0x0000 }, { 24522, 0x0000 },
  { 24522, 0x0000 }, { 24522, 0x0000 }, { 24522, 0x0000 }, { 24522, 0x0000 },
  /* 0x27400 */
  { 24522, 0x0000 }, { 24522, 0x0000 }, { 24522, 0x0004 }, { 24523, 0x0000 },
  { 24523, 0x0000 }, { 24523, 0x0001 }, { 24524, 0x0000 }, { 24524, 0x0000 },
  { 24524, 0x0050 }, { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0000 },
  { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0000 },
  /* 0x27500 */
  { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0000 },
  { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0010 },
  { 24527, 0x0000 }, { 24527, 0x0000 }, { 24527, 0x0008 }, { 24528, 0x0000 },
  { 24528, 0x0000 }, { 24528, 0x0000 }, { 24528, 0x0011 }, { 24530, 0x6000 },
  /* 0x27600 */
  { 24532, 0x1080 }, { 24534, 0x0000 }, { 24534, 0x0000 }, { 24534, 0x0204 },
  { 24536, 0x0000 }, { 24536, 0x00E0 }, { 24539, 0x0000 }, { 24539, 0x0000 },
  { 24539, 0x0000 }, { 24539, 0x0010 }, { 24540, 0x0000 }, { 24540, 0x0000 },
  { 24540, 0x0000 }, { 24540, 0x0000 }, { 24540, 0x0000 }, { 24540, 0x0000 },
  /* 0x27700 */
  { 24540, 0x8000 }, { 24541, 0x0000 }, { 24541, 0x0000 }, { 24541, 0x0060 },
  { 24543, 0x0002 }, { 24544, 0x4000 }, { 24545, 0x0000 }, { 24545, 0x0000 },
  { 24545, 0x0030 }, { 24547, 0x0000 }, { 24547, 0x0000 }, { 24547, 0x0000 },
  { 24547, 0x1000 }, { 24548, 0x0000 }, { 24548, 0x0000 }, { 24548, 0x0000 },
  /* 0x27800 */
  { 24548, 0x0000 }, { 24548, 0x0000 }, { 24548, 0x0000 }, { 24548, 0x0000 },
  { 24548, 0x0000 }, { 24548, 0x0100 }, { 24549, 0x0000 }, { 24549, 0x0001 },
  { 24550, 0x0000 }, { 24550, 0x2000 }, { 24551, 0x0000 }, { 24551, 0x0004 },
  { 24552, 0x0100 }, { 24553, 0x0000 }, { 24553, 0x0000 }, { 24553, 0x0000 },
  /* 0x27900 */
  { 24553, 0x0000 }, { 24553, 0x0000 }, { 24553, 0x0010 }, { 24554, 0x0000 },
  { 24554, 0x0000 }, { 24554, 0x0000 }, { 24554, 0x0080 }, { 24555, 0x0400 },
  { 24556, 0x0000 }, { 24556, 0x0000 }, { 24556, 0x0001 }, { 24557, 0x0000 },
  { 24557, 0x0000 }, { 24557, 0x2000 }, { 24558, 0x0000 }, { 24558, 0x2000 },
  /* 0x27A00 */
  { 24559, 0x4400 }, { 24561, 0x0000 }, { 24561, 0x0000 }, { 24561, 0x4000 },
  { 24562, 0x0000 }, { 24562, 0x0208 }, { 24564, 0x0000 }, { 24564, 0x0200 },
  { 24565, 0x0010 }, { 24566, 0x0000 }, { 24566, 0x0000 }, { 24566, 0x6000 },
  { 24568, 0x0000 }, { 24568, 0x0000 }, { 24568, 0x0000 }, { 24568, 0x0010 },
  /* 0x27B00 */
  { 24569, 0x0840 }, { 24571, 0x0100 }, { 24572, 0x0000 }, { 24572, 0x0700 },
  { 24575, 0x0100 }, { 24576, 0x0000 }, { 24576, 0x0000 }, { 24576, 0x0000 },
  { 24576, 0x0000 }, { 24576, 0x0000 }, { 24576, 0x0000 }, { 24576, 0x0000 },
  { 24576, 0x0000 }, { 24576, 0x0000 }, { 24576, 0x0000 }, { 24576, 0x0010 },
  /* 0x27C00 */
  { 24577, 0x0000 }, { 24577, 0x0004 }, { 24578, 0x0000 }, { 24578, 0x0000 },
  { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x0000 },
  { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x0000 },
  { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x0000 },
  /* 0x27D00 */
  { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x8000 }, { 24579, 0x0000 },
  { 24579, 0x0000 }, { 24579, 0x0018 }, { 24581, 0x0040 }, { 24582, 0x0008 },
  { 24583, 0x8010 }, { 24585, 0x0100 }, { 24586, 0x0000 }, { 24586, 0x2000 },
  { 24587, 0x0000 }, { 24587, 0x1000 }, { 24588, 0x0000 }, { 24588, 0x0000 },
  /* 0x27E00 */
  { 24588, 0x0000 }, { 24588, 0x0000 }, { 24588, 0x0000 }, { 24588, 0x0000 },
  { 24588, 0xA000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 },
  { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 },
  { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 },
  /* 0x27F00 */
  { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 },
  { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 },
  { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 },
  { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0200 },
  /* 0x28000 */
  { 24591, 0x0204 }, { 24593, 0x4000 }, { 24594, 0x0018 }, { 24596, 0x0000 },
  { 24596, 0x0100 }, { 24597, 0x0000 }, { 24597, 0x0000 }, { 24597, 0x0000 },
  { 24597, 0x0008 }, { 24598, 0x0001 }, { 24599, 0x0000 }, { 24599, 0x6000 },
  { 24601, 0x0000 }, { 24601, 0x0000 }, { 24601, 0x0300 }, { 24603, 0x0010 },
  /* 0x28100 */
  { 24604, 0x0000 }, { 24604, 0x0000 }, { 24604, 0x4000 }, { 24605, 0x0000 },
  { 24605, 0x8000 }, { 24606, 0x2000 }, { 24607, 0x8000 }, { 24608, 0x0000 },
  { 24608, 0x0200 }, { 24609, 0x0000 }, { 24609, 0x8000 }, { 24610, 0x1000 },
  { 24611, 0x0000 }, { 24611, 0x0000 }, { 24611, 0x0000 }, { 24611, 0x0000 },
  /* 0x28200 */
  { 24611, 0x0080 }, { 24612, 0x0500 }, { 24614, 0x0000 }, { 24614, 0x0000 },
  { 24614, 0x0000 }, { 24614, 0x0040 }, { 24615, 0x0000 }, { 24615, 0x1000 },
  { 24616, 0x0000 }, { 24616, 0x0800 }, { 24617, 0x0000 }, { 24617, 0x0000 },
  { 24617, 0x2000 }, { 24618, 0x0000 }, { 24618, 0x0004 }, { 24619, 0x0000 },
  /* 0x28300 */
  { 24619, 0x0040 }, { 24620, 0x0100 }, { 24621, 0x8000 }, { 24622, 0x0400 },
  { 24623, 0x0000 }, { 24623, 0x0000 }, { 24623, 0x2020 }, { 24625, 0x2000 },
  { 24626, 0x0400 }, { 24627, 0x0000 }, { 24627, 0x0000 }, { 24627, 0x0000 },
  { 24627, 0x0000 }, { 24627, 0x0000 }, { 24627, 0x0000 }, { 24627, 0x0000 },
  /* 0x28400 */
  { 24627, 0x0000 }, { 24627, 0x0004 }, { 24628, 0x0000 }, { 24628, 0x0000 },
  { 24628, 0x0000 }, { 24628, 0x0000 }, { 24628, 0x1100 }, { 24630, 0x0008 },
  { 24631, 0x0004 }, { 24632, 0x0000 }, { 24632, 0x0000 }, { 24632, 0x0000 },
  { 24632, 0x0000 }, { 24632, 0x0000 }, { 24632, 0x0000 }, { 24632, 0x0000 },
  /* 0x28500 */
  { 24632, 0x0002 }, { 24633, 0x0000 }, { 24633, 0x0000 }, { 24633, 0x3000 },
  { 24635, 0x0000 }, { 24635, 0x0000 }, { 24635, 0x1000 }, { 24636, 0x0000 },
  { 24636, 0x0000 }, { 24636, 0x0000 }, { 24636, 0x0000 }, { 24636, 0x0000 },
  { 24636, 0x0000 }, { 24636, 0x0000 }, { 24636, 0x0100 }, { 24637, 0x0010 },
  /* 0x28600 */
  { 24638, 0x0801 }, { 24640, 0x0000 }, { 24640, 0x0020 }, { 24641, 0x0800 },
  { 24642, 0x0000 }, { 24642, 0x0000 }, { 24642, 0x0000 }, { 24642, 0x0000 },
  { 24642, 0x0000 }, { 24642, 0x0000 }, { 24642, 0x0C00 }, { 24644, 0x1000 },
  { 24645, 0x0000 }, { 24645, 0x0100 }, { 24646, 0x0040 }, { 24647, 0x0000 },
  /* 0x28700 */
  { 24647, 0x8000 }, { 24648, 0x0008 }, { 24649, 0x0000 }, { 24649, 0x0000 },
  { 24649, 0x0000 }, { 24649, 0x0000 }, { 24649, 0x0000 }, { 24649, 0x0000 },
  { 24649, 0x0000 }, { 24649, 0x0000 }, { 24649, 0x0000 }, { 24649, 0x0000 },
  { 24649, 0x0000 }, { 24649, 0x0000 }, { 24649, 0x0000 }, { 24649, 0x0000 },
  /* 0x28800 */
  { 24649, 0x0010 }, { 24650, 0x0000 }, { 24650, 0x0800 }, { 24651, 0x0000 },
  { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 },
  { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 },
  { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 },
  /* 0x28900 */
  { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0008 },
  { 24652, 0x0300 }, { 24654, 0x0040 }, { 24655, 0x1110 }, { 24658, 0x4000 },
  { 24659, 0x0200 }, { 24660, 0x0000 }, { 24660, 0x0D00 }, { 24663, 0x1100 },
  { 24665, 0x0001 }, { 24666, 0x5000 }, { 24668, 0x019A }, { 24673, 0x1E00 },
  /* 0x28A00 */
  { 24677, 0x8000 }, { 24678, 0x0040 }, { 24679, 0x0220 }, { 24681, 0x0044 },
  { 24683, 0x0FF0 }, { 24691, 0x0600 }, { 24693, 0x0000 }, { 24693, 0x0000 },
  { 24693, 0x000E }, { 24696, 0x1C00 }, { 24699, 0x0000 }, { 24699, 0x0000 },
  { 24699, 0x5841 }, { 24704, 0xC000 }, { 24706, 0x042F }, { 24712, 0x1000 },
  /* 0x28B00 */
  { 24713, 0x1000 }, { 24714, 0x0008 }, { 24715, 0xB806 }, { 24721, 0x0000 },
  { 24721, 0x5040 }, { 24724, 0x0001 }, { 24725, 0x1078 }, { 24730, 0x0000 },
  { 24730, 0x8000 }, { 24731, 0x3200 }, { 24734, 0x0000 }, { 24734, 0x0000 },
  { 24734, 0x0024 }, { 24736, 0x0690 }, { 24740, 0x1F80 }, { 24746, 0x8020 },
  /* 0x28C00 */
  { 24748, 0x0208 }, { 24750, 0x3000 }, { 24752, 0x0848 }, { 24755, 0x0A01 },
  { 24758, 0x0000 }, { 24758, 0x0000 }, { 24758, 0x0000 }, { 24758, 0x0000 },
  { 24758, 0x0000 }, { 24758, 0x0000 }, { 24758, 0x0000 }, { 24758, 0x0000 },
  { 24758, 0x2400 }, { 24760, 0x0004 }, { 24761, 0x0000 }, { 24761, 0x0000 },
  /* 0x28D00 */
  { 24761, 0x0000 }, { 24761, 0x0000 }, { 24761, 0x0000 }, { 24761, 0x0010 },
  { 24762, 0x0000 }, { 24762, 0x0000 }, { 24762, 0x0000 }, { 24762, 0x0000 },
  { 24762, 0x0000 }, { 24762, 0x0200 }, { 24763, 0x0000 }, { 24763, 0x0200 },
  { 24764, 0x0000 }, { 24764, 0x0000 }, { 24764, 0x0000 }, { 24764, 0x0000 },
  /* 0x28E00 */
  { 24764, 0x8000 }, { 24765, 0x0000 }, { 24765, 0x0000 }, { 24765, 0x0240 },
  { 24767, 0x0000 }, { 24767, 0x0000 }, { 24767, 0x0060 }, { 24769, 0x0000 },
  { 24769, 0x0000 }, { 24769, 0x0080 }, { 24770, 0x1000 }, { 24771, 0x000C },
  { 24773, 0x0000 }, { 24773, 0x0200 }, { 24774, 0x0080 }, { 24775, 0x0000 },
  /* 0x28F00 */
  { 24775, 0x0000 }, { 24775, 0x0000 }, { 24775, 0x0000 }, { 24775, 0x0000 },
  { 24775, 0x0000 }, { 24775, 0x0000 }, { 24775, 0x0000 }, { 24775, 0x0000 },
  { 24775, 0x0000 }, { 24775, 0x0000 }, { 24775, 0x0000 }, { 24775, 0x0000 },
  { 24775, 0x0020 }, { 24776, 0x0000 }, { 24776, 0x0000 }, { 24776, 0x0000 },
  /* 0x29000 */
  { 24776, 0x0000 }, { 24776, 0x0000 }, { 24776, 0x0000 }, { 24776, 0x0000 },
  { 24776, 0x0000 }, { 24776, 0x0000 }, { 24776, 0x0000 }, { 24776, 0x0000 },
  { 24776, 0x0900 }, { 24778, 0x0008 }, { 24779, 0x8000 }, { 24780, 0x0003 },
  { 24782, 0x0001 }, { 24783, 0x0000 }, { 24783, 0x3030 }, { 24787, 0x0000 },
  /* 0x29100 */
  { 24787, 0x2000 }, { 24788, 0x0001 }, { 24789, 0x0000 }, { 24789, 0x1000 },
  { 24790, 0x2000 }, { 24791, 0x4800 }, { 24793, 0x0000 }, { 24793, 0x0001 },
  { 24794, 0x0000 }, { 24794, 0x1000 }, { 24795, 0x0100 }, { 24796, 0x0000 },
  { 24796, 0x0000 }, { 24796, 0x0020 }, { 24797, 0x0800 },
};
static const Summary16 big5hkscs_uni2index_page294[32] = {
  /* 0x29400 */
  { 24798, 0x0000 }, { 24798, 0x2000 }, { 24799, 0x0001 }, { 24800, 0x8008 },
  { 24802, 0x0100 }, { 24803, 0x0000 }, { 24803, 0x0000 }, { 24803, 0x0000 },
  { 24803, 0x0000 }, { 24803, 0x0000 }, { 24803, 0x0000 }, { 24803, 0x0000 },
  { 24803, 0x0000 }, { 24803, 0x0601 }, { 24806, 0x00A0 }, { 24808, 0x0000 },
  /* 0x29500 */
  { 24808, 0x0000 }, { 24808, 0x0000 }, { 24808, 0x0000 }, { 24808, 0x0000 },
  { 24808, 0x0000 }, { 24808, 0x0000 }, { 24808, 0x0000 }, { 24808, 0x0000 },
  { 24808, 0x0000 }, { 24808, 0x4000 }, { 24809, 0x0000 }, { 24809, 0x0101 },
  { 24811, 0x0000 }, { 24811, 0x0080 }, { 24812, 0x0200 }, { 24813, 0x0010 },
};
static const Summary16 big5hkscs_uni2index_page297[251] = {
  /* 0x29700 */
  { 24814, 0x0000 }, { 24814, 0x0000 }, { 24814, 0x0001 }, { 24815, 0x0004 },
  { 24816, 0x0000 }, { 24816, 0x0000 }, { 24816, 0x0000 }, { 24816, 0x0000 },
  { 24816, 0x0000 }, { 24816, 0x0000 }, { 24816, 0x0000 }, { 24816, 0x0000 },
  { 24816, 0x0000 }, { 24816, 0x0010 }, { 24817, 0x0000 }, { 24817, 0x0000 },
  /* 0x29800 */
  { 24817, 0x0000 }, { 24817, 0x0001 }, { 24818, 0x0000 }, { 24818, 0x0000 },
  { 24818, 0x0000 }, { 24818, 0x0080 }, { 24819, 0x0000 }, { 24819, 0x0000 },
  { 24819, 0x0000 }, { 24819, 0x0000 }, { 24819, 0x0010 }, { 24820, 0x0000 },
  { 24820, 0x0000 }, { 24820, 0x0002 }, { 24821, 0x0400 }, { 24822, 0x0002 },
  /* 0x29900 */
  { 24823, 0x0028 }, { 24825, 0x0000 }, { 24825, 0x8000 }, { 24826, 0x0000 },
  { 24826, 0x0380 }, { 24829, 0x2000 }, { 24830, 0x0400 }, { 24831, 0x0000 },
  { 24831, 0x0000 }, { 24831, 0x2000 }, { 24832, 0x0000 }, { 24832, 0x0000 },
  { 24832, 0x0208 }, { 24834, 0x0000 }, { 24834, 0x0000 }, { 24834, 0x0000 },
  /* 0x29A00 */
  { 24834, 0x0000 }, { 24834, 0x0000 }, { 24834, 0x0100 }, { 24835, 0x0000 },
  { 24835, 0x2000 }, { 24836, 0x0000 }, { 24836, 0x0000 }, { 24836, 0x0000 },
  { 24836, 0x0000 }, { 24836, 0x0000 }, { 24836, 0x0000 }, { 24836, 0x0000 },
  { 24836, 0x0000 }, { 24836, 0x0000 }, { 24836, 0x0000 }, { 24836, 0x0000 },
  /* 0x29B00 */
  { 24836, 0x4020 }, { 24838, 0x0000 }, { 24838, 0x0000 }, { 24838, 0x0000 },
  { 24838, 0x0000 }, { 24838, 0x0000 }, { 24838, 0x0000 }, { 24838, 0x0000 },
  { 24838, 0x0000 }, { 24838, 0x0000 }, { 24838, 0x0000 }, { 24838, 0x0000 },
  { 24838, 0x0000 }, { 24838, 0x0020 }, { 24839, 0x0000 }, { 24839, 0x0000 },
  /* 0x29C00 */
  { 24839, 0x0000 }, { 24839, 0x0000 }, { 24839, 0x0000 }, { 24839, 0x0000 },
  { 24839, 0x0000 }, { 24839, 0x0000 }, { 24839, 0x0000 }, { 24839, 0x0008 },
  { 24840, 0x0000 }, { 24840, 0x0000 }, { 24840, 0x2000 }, { 24841, 0x0000 },
  { 24841, 0x0000 }, { 24841, 0x0000 }, { 24841, 0x0000 }, { 24841, 0x0000 },
  /* 0x29D00 */
  { 24841, 0x0000 }, { 24841, 0x0000 }, { 24841, 0x0000 }, { 24841, 0x4000 },
  { 24842, 0x0000 }, { 24842, 0x0400 }, { 24843, 0x0000 }, { 24843, 0x1000 },
  { 24844, 0x0000 }, { 24844, 0x0900 }, { 24846, 0x0000 }, { 24846, 0x0000 },
  { 24846, 0x0000 }, { 24846, 0x0000 }, { 24846, 0x0000 }, { 24846, 0x0040 },
  /* 0x29E00 */
  { 24847, 0x0040 }, { 24848, 0x0000 }, { 24848, 0x2000 }, { 24849, 0x0000 },
  { 24849, 0x0000 }, { 24849, 0x0000 }, { 24849, 0x0100 }, { 24850, 0x0000 },
  { 24850, 0x0000 }, { 24850, 0x0000 }, { 24850, 0x1000 }, { 24851, 0x0000 },
  { 24851, 0x0008 }, { 24852, 0x0000 }, { 24852, 0x0000 }, { 24852, 0x0100 },
  /* 0x29F00 */
  { 24853, 0x0000 }, { 24853, 0x0000 }, { 24853, 0x0008 }, { 24854, 0x0001 },
  { 24855, 0x0000 }, { 24855, 0x0000 }, { 24855, 0x0000 }, { 24855, 0x0000 },
  { 24855, 0x0000 }, { 24855, 0x0000 }, { 24855, 0x0000 }, { 24855, 0x0080 },
  { 24856, 0x0000 }, { 24856, 0x4000 }, { 24857, 0x0000 }, { 24857, 0x0000 },
  /* 0x2A000 */
  { 24857, 0x0000 }, { 24857, 0x0010 }, { 24858, 0x0000 }, { 24858, 0x0000 },
  { 24858, 0x0000 }, { 24858, 0x0000 }, { 24858, 0x0000 }, { 24858, 0x0000 },
  { 24858, 0x0080 }, { 24859, 0x0000 }, { 24859, 0x0000 }, { 24859, 0x0200 },
  { 24860, 0x0000 }, { 24860, 0x0000 }, { 24860, 0x2002 }, { 24862, 0x4108 },
  /* 0x2A100 */
  { 24865, 0x0080 }, { 24866, 0x0000 }, { 24866, 0x0008 }, { 24867, 0x0018 },
  { 24869, 0x0000 }, { 24869, 0x0001 }, { 24870, 0x0000 }, { 24870, 0x0000 },
  { 24870, 0x0000 }, { 24870, 0x000C }, { 24872, 0x0800 }, { 24873, 0x0010 },
  { 24874, 0x0000 }, { 24874, 0x8000 }, { 24875, 0x0000 }, { 24875, 0x0020 },
  /* 0x2A200 */
  { 24876, 0x0000 }, { 24876, 0x0000 }, { 24876, 0x0001 }, { 24877, 0x0008 },
  { 24878, 0x0000 }, { 24878, 0x0000 }, { 24878, 0x0000 }, { 24878, 0x0000 },
  { 24878, 0x0000 }, { 24878, 0x8008 }, { 24880, 0x0000 }, { 24880, 0x2454 },
  { 24885, 0x0000 }, { 24885, 0x8000 }, { 24886, 0x0000 }, { 24886, 0x8000 },
  /* 0x2A300 */
  { 24887, 0x0000 }, { 24887, 0x0000 }, { 24887, 0x0000 }, { 24887, 0x0000 },
  { 24887, 0x0000 }, { 24887, 0x0000 }, { 24887, 0x0000 }, { 24887, 0x0000 },
  { 24887, 0x0000 }, { 24887, 0x0000 }, { 24887, 0x0200 }, { 24888, 0x0000 },
  { 24888, 0x0000 }, { 24888, 0x0000 }, { 24888, 0x0000 }, { 24888, 0x0000 },
  /* 0x2A400 */
  { 24888, 0x0000 }, { 24888, 0x0000 }, { 24888, 0x0000 }, { 24888, 0x0010 },
  { 24889, 0x0000 }, { 24889, 0x0800 }, { 24890, 0x0000 }, { 24890, 0x0000 },
  { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 },
  { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 },
  /* 0x2A500 */
  { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 },
  { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 },
  { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 },
  { 24890, 0x0840 }, { 24892, 0x0000 }, { 24892, 0x0000 }, { 24892, 0x0000 },
  /* 0x2A600 */
  { 24892, 0x0002 }, { 24893, 0x0000 }, { 24893, 0x0000 }, { 24893, 0x0004 },
  { 24894, 0x0400 }, { 24895, 0x0800 }, { 24896, 0x0000 }, { 24896, 0x0000 },
  { 24896, 0x0000 }, { 24896, 0x0000 }, { 24896, 0x0200 },
};
static const Summary16 big5hkscs_uni2index_page2f8[30] = {
  /* 0x2F800 */
  { 24897, 0x0000 }, { 24897, 0x0000 }, { 24897, 0x0020 }, { 24898, 0x0800 },
  { 24899, 0x0001 }, { 24900, 0x0000 }, { 24900, 0x0000 }, { 24900, 0x0100 },
  { 24901, 0x0000 }, { 24901, 0x0010 }, { 24902, 0x0040 }, { 24903, 0x0000 },
  { 24903, 0x2000 }, { 24904, 0x0000 }, { 24904, 0x0000 }, { 24904, 0x0000 },
  /* 0x2F900 */
  { 24904, 0x0000 }, { 24904, 0x0000 }, { 24904, 0x0000 }, { 24904, 0x0000 },
  { 24904, 0x0000 }, { 24904, 0x0000 }, { 24904, 0x0000 }, { 24904, 0x0000 },
  { 24904, 0x0000 }, { 24904, 0x0010 }, { 24905, 0x0000 }, { 24905, 0x1004 },
  { 24907, 0x0000 }, { 24907, 0x0010 },
};

static int qt_UnicodeToBig5hkscs(unsigned wc, uint8_t *r)
{
	const Summary16 *summary = NULL;
	if (wc < 0x80) {
		r[0] = (uint8_t)wc;
		return 1;
	}
	if (wc < 0x0460)
		summary = &big5hkscs_uni2index_page00[(wc >> 4)];
	else if (wc >= 0x1e00 && wc < 0x1ed0)
		summary = &big5hkscs_uni2index_page1e[(wc >> 4) - 0x1e0];
	else if (wc >= 0x2000 && wc < 0x2740)
		summary = &big5hkscs_uni2index_page20[(wc >> 4) - 0x200];
	else if (wc >= 0x2e00 && wc < 0x9fb0)
		summary = &big5hkscs_uni2index_page2e[(wc >> 4) - 0x2e0];
	else if (wc >= 0xe000 && wc < 0xfa30)
		summary = &big5hkscs_uni2index_pagee0[(wc >> 4) - 0xe00];
	else if (wc >= 0xfe00 && wc < 0xfff0)
		summary = &big5hkscs_uni2index_pagefe[(wc >> 4) - 0xfe0];
	else if (wc >= 0x20000 && wc < 0x291f0)
		summary = &big5hkscs_uni2index_page200[(wc >> 4) - 0x2000];
	else if (wc >= 0x29400 && wc < 0x29600)
		summary = &big5hkscs_uni2index_page294[(wc >> 4) - 0x2940];
	else if (wc >= 0x29700 && wc < 0x2a6b0)
		summary = &big5hkscs_uni2index_page297[(wc >> 4) - 0x2970];
	else if (wc >= 0x2f800 && wc < 0x2f9e0)
		summary = &big5hkscs_uni2index_page2f8[(wc >> 4) - 0x2f80];
	if (summary) {
		uint16_t used = summary->used;
		unsigned i = wc & 0x0f;
		if (used & ((uint16_t)1 << i)) {
			/* Keep in `used' only the bits 0..i-1. */
			used &= ((uint16_t)1 << i) - 1;
			/* Add `summary->index' and the number of bits set in `used'. */
			used = (used & 0x5555) + ((used & 0xaaaa) >> 1);
			used = (used & 0x3333) + ((used & 0xcccc) >> 2);
			used = (used & 0x0f0f) + ((used & 0xf0f0) >> 4);
			used = (used & 0x00ff) + (used >> 8);
			const uint8_t *c = big5hkscs_to_charset[summary->index + used];
			if (c[1] != 0) {
				r[0] = c[0];
				r[1] = c[1];
				return 2;
			}
			else {  // (c [1] == 0)
				r[0] = c[0];
				return 1;
			}
		}
	}
	return 0;
}

static int qt_UnicodeToBig5(unsigned ch, uint8_t *buf)
{
	//all the tables are individually sorted on Y
	for (int i = 0; i < 5; i++) {
		int start = 0;
		int end = b5_map_table[i].tableSize - 1;

		while (start <= end) {
			int middle = (end + start + 1) / 2;
			if (b5_map_table[i].table[middle].y == ch) {
				buf[0] = b5_map_table[i].table[middle].x >> 8;
				buf[1] = b5_map_table[i].table[middle].x & 0xff;
				return 2;
			}
			else if (b5_map_table[i].table[middle].y > ch) {
				end = middle - 1;
			}
			else {
				start = middle + 1;
			}
		}
	}
	return qt_UnicodeToBig5hkscs(ch, buf);
}

void
Big5TextEncoder::EncodeBig5(const std::wstring& str, std::string& bytes)
{
	static const char replacement = '?';
	//int invalid = 0;

	bytes.resize(2 * str.length() + 1);
	int index = 0;

	uint8_t c[2];
	for (wchar_t ch : str) {
		if (ch < 0x80) {
			// ASCII
			bytes[index++] = static_cast<char>(ch);
		}
		else if (qt_UnicodeToBig5(ch, c) == 2 && c[0] >= 0xa1 && c[0] <= 0xf9) {
			bytes[index++] = c[0];
			bytes[index++] = c[1];
		}
		else {
			bytes[index++] = replacement;
			//++invalid;
		}
	}
	bytes.resize(index);
}
